# File generated from our OpenAPI spec by Stainless. See CONTRIBUTING.md for details.

from typing import List, Optional
from typing_extensions import Literal

from ...._models import BaseModel

__all__ = ["ConversationItemWithReference", "Content"]


class Content(BaseModel):
    id: Optional[str] = None
    """
    ID of a previous conversation item to reference (for `item_reference` content
    types in `response.create` events). These can reference both client and server
    created items.
    """

    audio: Optional[str] = None
    """Base64-encoded audio bytes, used for `input_audio` content type."""

    text: Optional[str] = None
    """The text content, used for `input_text` and `text` content types."""

    transcript: Optional[str] = None
    """The transcript of the audio, used for `input_audio` content type."""

    type: Optional[Literal["input_text", "input_audio", "item_reference", "text"]] = None
    """The content type (`input_text`, `input_audio`, `item_reference`, `text`)."""


class ConversationItemWithReference(BaseModel):
    id: Optional[str] = None
    """
    For an item of type (`message` | `function_call` | `function_call_output`) this
    field allows the client to assign the unique ID of the item. It is not required
    because the server will generate one if not provided.

    For an item of type `item_reference`, this field is required and is a reference
    to any item that has previously existed in the conversation.
    """

    arguments: Optional[str] = None
    """The arguments of the function call (for `function_call` items)."""

    call_id: Optional[str] = None
    """
    The ID of the function call (for `function_call` and `function_call_output`
    items). If passed on a `function_call_output` item, the server will check that a
    `function_call` item with the same ID exists in the conversation history.
    """

    content: Optional[List[Content]] = None
    """The content of the message, applicable for `message` items.

    - Message items of role `system` support only `input_text` content
    - Message items of role `user` support `input_text` and `input_audio` content
    - Message items of role `assistant` support `text` content.
    """

    name: Optional[str] = None
    """The name of the function being called (for `function_call` items)."""

    object: Optional[Literal["realtime.item"]] = None
    """Identifier for the API object being returned - always `realtime.item`."""

    output: Optional[str] = None
    """The output of the function call (for `function_call_output` items)."""

    role: Optional[Literal["user", "assistant", "system"]] = None
    """
    The role of the message sender (`user`, `assistant`, `system`), only applicable
    for `message` items.
    """

    status: Optional[Literal["completed", "incomplete", "in_progress"]] = None
    """The status of the item (`completed`, `incomplete`, `in_progress`).

    These have no effect on the conversation, but are accepted for consistency with
    the `conversation.item.created` event.
    """

    type: Optional[Literal["message", "function_call", "function_call_output", "item_reference"]] = None
    """
    The type of the item (`message`, `function_call`, `function_call_output`,
    `item_reference`).
    """
