/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.settingsSync.core.git.renderers;

import com.intellij.icons.AllIcons;
import com.intellij.settingsSync.core.git.record.ChangeRecord;
import com.intellij.settingsSync.core.git.renderers.SettingsHistoryCellRenderer;
import com.intellij.settingsSync.core.git.table.SettingsHistoryTable;
import com.intellij.settingsSync.core.git.table.SettingsHistoryTableRow;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.ui.JBUI;
import java.awt.Insets;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J0\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u0012H\u0016R\u0013\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0007\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/intellij/settingsSync/core/git/renderers/SettingsHistorySubtitleRenderer;", "Lcom/intellij/settingsSync/core/git/renderers/SettingsHistoryCellRenderer;", "<init>", "()V", "windowsIcon", "Ljavax/swing/Icon;", "Lorg/jetbrains/annotations/NotNull;", "linuxIcon", "customizeHistoryCellRenderer", "", "table", "Lcom/intellij/settingsSync/core/git/table/SettingsHistoryTable;", "row", "Lcom/intellij/settingsSync/core/git/table/SettingsHistoryTableRow;", "selected", "", "hasFocus", "rowIndex", "", "intellij.settingsSync.core"})
public final class SettingsHistorySubtitleRenderer
extends SettingsHistoryCellRenderer {
    @NotNull
    private final Icon windowsIcon;
    @NotNull
    private final Icon linuxIcon;

    public SettingsHistorySubtitleRenderer() {
        Icon icon = AllIcons.FileTypes.MicrosoftWindows;
        Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"MicrosoftWindows");
        this.windowsIcon = icon;
        Icon icon2 = AllIcons.Linux.Linux;
        Intrinsics.checkNotNullExpressionValue((Object)icon2, (String)"Linux");
        this.linuxIcon = icon2;
    }

    @Override
    public void customizeHistoryCellRenderer(@NotNull SettingsHistoryTable table, @NotNull SettingsHistoryTableRow row, boolean selected, boolean hasFocus, int rowIndex) {
        Intrinsics.checkNotNullParameter((Object)((Object)table), (String)"table");
        Intrinsics.checkNotNullParameter((Object)row, (String)"row");
        ChangeRecord record = row.getRecord();
        SimpleTextAttributes textAttributes = this.isGreyedOut(table, rowIndex) ? SimpleTextAttributes.GRAY_ATTRIBUTES : SimpleTextAttributes.GRAYED_ATTRIBUTES;
        ChangeRecord.OperatingSystem operatingSystem = record.getOs();
        switch (operatingSystem == null ? -1 : WhenMappings.$EnumSwitchMapping$0[operatingSystem.ordinal()]) {
            case 1: {
                this.setIcon(this.windowsIcon);
                Unit unit = Unit.INSTANCE;
                break;
            }
            case 2: {
                this.setIcon(this.linuxIcon);
                Unit unit = Unit.INSTANCE;
                break;
            }
            case 3: {
                SimpleColoredComponent simpleColoredComponent = this.appendWithClipping("macOS  ", textAttributes, SimpleColoredComponent.DefaultFragmentTextClipper.INSTANCE);
                Unit unit = simpleColoredComponent;
                Intrinsics.checkNotNullExpressionValue((Object)simpleColoredComponent, (String)"appendWithClipping(...)");
                break;
            }
            case -1: {
                Unit unit = Unit.INSTANCE;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        if (this.getIcon() == null) {
            this.setIpad((Insets)JBUI.insetsLeft((int)20));
        } else {
            this.setIpad((Insets)JBUI.insetsLeft((int)22));
        }
        if (this.isGreyedOut(table, rowIndex)) {
            this.setIconOpacity(Float.valueOf(0.6f));
        }
        this.setIconTextGap(1);
        this.appendWithClipping(record.getHost() + ", " + record.getBuild(), textAttributes, SimpleColoredComponent.DefaultFragmentTextClipper.INSTANCE);
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ChangeRecord.OperatingSystem.values().length];
            try {
                nArray[ChangeRecord.OperatingSystem.WINDOWS.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ChangeRecord.OperatingSystem.LINUX.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ChangeRecord.OperatingSystem.MAC.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

