/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.history.integration.ui.models;

import com.intellij.history.core.LocalHistoryFacade;
import com.intellij.history.core.revisions.Revision;
import com.intellij.history.integration.IdeaGateway;
import com.intellij.history.integration.revertion.Reverter;
import com.intellij.history.integration.revertion.SelectionReverter;
import com.intellij.history.integration.ui.models.FileDifferenceModel;
import com.intellij.history.integration.ui.models.FileHistoryDialogModel;
import com.intellij.history.integration.ui.models.RevisionData;
import com.intellij.history.integration.ui.models.RevisionDataKt;
import com.intellij.history.integration.ui.models.RevisionSelectionCalculator;
import com.intellij.history.integration.ui.models.SelectionDifferenceModel;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.platform.lvcs.impl.statistics.LocalHistoryCounter;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Internal
public class SelectionHistoryDialogModel
extends FileHistoryDialogModel {
    private RevisionSelectionCalculator myCalculatorCache;
    private final int myFrom;
    private final int myTo;

    public SelectionHistoryDialogModel(Project p, IdeaGateway gw, LocalHistoryFacade vcs, VirtualFile f, int from, int to) {
        super(p, gw, vcs, f);
        this.myFrom = from;
        this.myTo = to;
    }

    @Override
    @NotNull
    protected RevisionData collectRevisionData() {
        this.myCalculatorCache = null;
        RevisionData revisionData = super.collectRevisionData();
        if (revisionData == null) {
            SelectionHistoryDialogModel.$$$reportNull$$$0(0);
        }
        return revisionData;
    }

    @Override
    public FileDifferenceModel getDifferenceModel() {
        return new SelectionDifferenceModel(this.myProject, this.myGateway, this.getCalculator(), this.getLeftRevision(), this.getRightRevision(), this.myFrom, this.myTo, this.isCurrentRevisionSelected());
    }

    private RevisionSelectionCalculator getCalculator() {
        if (this.myCalculatorCache == null) {
            this.myCalculatorCache = new RevisionSelectionCalculator(this.myGateway, (List<? extends Revision>)RevisionDataKt.getAllRevisions(this.getRevisionData()), this.myFrom, this.myTo);
        }
        return this.myCalculatorCache;
    }

    @Override
    public Reverter createReverter() {
        return new SelectionReverter(this.myProject, this.myVcs, this.myGateway, this.getCalculator(), this.getLeftRevision(), this.getRightEntry(), this.myFrom, this.myTo);
    }

    @Override
    @NotNull
    public Set<Long> filterContents(@NotNull String filter2) {
        if (filter2 == null) {
            SelectionHistoryDialogModel.$$$reportNull$$$0(1);
        }
        Set<Long> set = RevisionDataKt.filterContents(this.getCalculator(), filter2);
        if (set == null) {
            SelectionHistoryDialogModel.$$$reportNull$$$0(2);
        }
        return set;
    }

    @Override
    @ApiStatus.Internal
    @NotNull
    public LocalHistoryCounter.Kind getKind() {
        LocalHistoryCounter.Kind kind = LocalHistoryCounter.Kind.Selection;
        if (kind == null) {
            SelectionHistoryDialogModel.$$$reportNull$$$0(3);
        }
        return kind;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/history/integration/ui/models/SelectionHistoryDialogModel";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filter";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "collectRevisionData";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/history/integration/ui/models/SelectionHistoryDialogModel";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "filterContents";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getKind";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "filterContents";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1 -> new IllegalArgumentException(string);
        };
    }
}

