/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.neuralsearch.sparse.codec;

import java.io.IOException;
import lombok.Generated;
import org.apache.lucene.index.PostingsEnum;
import org.apache.lucene.util.BytesRef;
import org.opensearch.neuralsearch.sparse.cache.CacheKey;
import org.opensearch.neuralsearch.sparse.common.DocWeightIterator;
import org.opensearch.neuralsearch.sparse.common.IteratorWrapper;
import org.opensearch.neuralsearch.sparse.data.DocumentCluster;
import org.opensearch.neuralsearch.sparse.data.PostingClusters;
import org.opensearch.neuralsearch.sparse.quantization.ByteQuantizationUtil;

public class SparsePostingsEnum
extends PostingsEnum {
    private final PostingClusters clusters;
    private final CacheKey cacheKey;
    private final IteratorWrapper<DocumentCluster> currentCluster;
    private DocWeightIterator currentDocWeight;

    public SparsePostingsEnum(PostingClusters clusters, CacheKey cacheKey) throws IOException {
        this.clusters = clusters;
        this.cacheKey = cacheKey;
        this.currentCluster = this.clusterIterator();
        this.currentDocWeight = this.currentCluster.next().getDisi();
    }

    public IteratorWrapper<DocumentCluster> clusterIterator() {
        return this.clusters.iterator();
    }

    public int size() {
        return this.clusters.getSize();
    }

    public int freq() throws IOException {
        assert (this.currentDocWeight != null);
        return ByteQuantizationUtil.getUnsignedByte(this.currentDocWeight.weight());
    }

    public int nextPosition() throws IOException {
        throw new UnsupportedOperationException();
    }

    public int startOffset() throws IOException {
        throw new UnsupportedOperationException();
    }

    public int endOffset() throws IOException {
        throw new UnsupportedOperationException();
    }

    public BytesRef getPayload() throws IOException {
        throw new UnsupportedOperationException();
    }

    public int docID() {
        if (this.currentDocWeight == null) {
            return -1;
        }
        return this.currentDocWeight.docID();
    }

    public int nextDoc() throws IOException {
        assert (this.currentDocWeight != null);
        int doc = this.currentDocWeight.nextDoc();
        while (doc == Integer.MAX_VALUE) {
            if (!this.currentCluster.hasNext()) {
                return Integer.MAX_VALUE;
            }
            this.currentDocWeight = this.currentCluster.next().getDisi();
            doc = this.currentDocWeight.nextDoc();
        }
        return doc;
    }

    public int advance(int target) throws IOException {
        throw new UnsupportedOperationException();
    }

    public long cost() {
        return 0L;
    }

    @Generated
    public PostingClusters getClusters() {
        return this.clusters;
    }

    @Generated
    public CacheKey getCacheKey() {
        return this.cacheKey;
    }
}

