/*
 * Decompiled with CFR 0.152.
 */
package ai.djl.huggingface.translator;

import ai.djl.huggingface.tokenizers.Encoding;
import ai.djl.huggingface.tokenizers.HuggingFaceTokenizer;
import ai.djl.ndarray.NDArray;
import ai.djl.ndarray.NDList;
import ai.djl.ndarray.NDManager;
import ai.djl.translate.ArgumentsUtil;
import ai.djl.translate.Batchifier;
import ai.djl.translate.Translator;
import ai.djl.translate.TranslatorContext;
import ai.djl.util.PairList;
import ai.djl.util.StringPair;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class CrossEncoderTranslator
implements Translator<StringPair, float[]> {
    private HuggingFaceTokenizer tokenizer;
    private boolean includeTokenTypes;
    private boolean sigmoid;
    private Batchifier batchifier;

    CrossEncoderTranslator(HuggingFaceTokenizer tokenizer, boolean includeTokenTypes, boolean sigmoid, Batchifier batchifier) {
        this.tokenizer = tokenizer;
        this.includeTokenTypes = includeTokenTypes;
        this.sigmoid = sigmoid;
        this.batchifier = batchifier;
    }

    public Batchifier getBatchifier() {
        return this.batchifier;
    }

    public NDList processInput(TranslatorContext ctx, StringPair input) {
        Encoding encoding = this.tokenizer.encode((String)input.getKey(), (String)input.getValue());
        ctx.setAttachment("encoding", (Object)encoding);
        return encoding.toNDList(ctx.getNDManager(), this.includeTokenTypes);
    }

    public NDList batchProcessInput(TranslatorContext ctx, List<StringPair> inputs) {
        NDManager manager = ctx.getNDManager();
        PairList list = new PairList(inputs);
        Encoding[] encodings = this.tokenizer.batchEncode((PairList<String, String>)list);
        NDList[] batch = new NDList[encodings.length];
        for (int i = 0; i < encodings.length; ++i) {
            batch[i] = encodings[i].toNDList(manager, this.includeTokenTypes);
        }
        return this.batchifier.batchify(batch);
    }

    public float[] processOutput(TranslatorContext ctx, NDList list) {
        NDArray logits = (NDArray)list.get(0);
        if (this.sigmoid) {
            logits = logits.getNDArrayInternal().sigmoid();
        }
        return logits.toFloatArray();
    }

    public List<float[]> batchProcessOutput(TranslatorContext ctx, NDList list) {
        if (this.sigmoid) {
            NDList[] batches = this.batchifier.unbatchify(list);
            ArrayList<float[]> ret = new ArrayList<float[]>(batches.length);
            for (NDList batch : batches) {
                NDArray result = (NDArray)batch.get(0);
                result = result.getNDArrayInternal().sigmoid();
                ret.add(result.toFloatArray());
            }
            return ret;
        }
        NDArray array = (NDArray)list.get(0);
        int batchSize = Math.toIntExact(array.size(0));
        float[] buf = ((NDArray)list.get(0)).toFloatArray();
        if (batchSize == 1) {
            return Collections.singletonList(buf);
        }
        int length = buf.length / batchSize;
        ArrayList<float[]> ret = new ArrayList<float[]>(batchSize);
        for (int i = 0; i < batchSize; ++i) {
            float[] f = new float[length];
            System.arraycopy(buf, i * length, f, 0, length);
            ret.add(f);
        }
        return ret;
    }

    public static Builder builder(HuggingFaceTokenizer tokenizer) {
        return new Builder(tokenizer);
    }

    public static Builder builder(HuggingFaceTokenizer tokenizer, Map<String, ?> arguments) {
        Builder builder = CrossEncoderTranslator.builder(tokenizer);
        builder.configure(arguments);
        return builder;
    }

    public static final class Builder {
        private HuggingFaceTokenizer tokenizer;
        private boolean includeTokenTypes;
        private boolean sigmoid = true;
        private Batchifier batchifier = Batchifier.STACK;

        Builder(HuggingFaceTokenizer tokenizer) {
            this.tokenizer = tokenizer;
        }

        public Builder optIncludeTokenTypes(boolean includeTokenTypes) {
            this.includeTokenTypes = includeTokenTypes;
            return this;
        }

        public Builder optSigmoid(boolean sigmoid) {
            this.sigmoid = sigmoid;
            return this;
        }

        public Builder optBatchifier(Batchifier batchifier) {
            this.batchifier = batchifier;
            return this;
        }

        public void configure(Map<String, ?> arguments) {
            this.optIncludeTokenTypes(ArgumentsUtil.booleanValue(arguments, (String)"includeTokenTypes"));
            this.optSigmoid(ArgumentsUtil.booleanValue(arguments, (String)"sigmoid", (boolean)true));
            String batchifierStr = ArgumentsUtil.stringValue(arguments, (String)"batchifier", (String)"stack");
            this.optBatchifier(Batchifier.fromString((String)batchifierStr));
        }

        public CrossEncoderTranslator build() throws IOException {
            return new CrossEncoderTranslator(this.tokenizer, this.includeTokenTypes, this.sigmoid, this.batchifier);
        }
    }
}

