/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrockruntime.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.bedrockruntime.model.DocumentCharLocation;
import software.amazon.awssdk.services.bedrockruntime.model.DocumentChunkLocation;
import software.amazon.awssdk.services.bedrockruntime.model.DocumentPageLocation;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CitationLocation
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, CitationLocation> {
    private static final SdkField<DocumentCharLocation> DOCUMENT_CHAR_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("documentChar").getter(CitationLocation.getter(CitationLocation::documentChar)).setter(CitationLocation.setter(Builder::documentChar)).constructor(DocumentCharLocation::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("documentChar").build()}).build();
    private static final SdkField<DocumentPageLocation> DOCUMENT_PAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("documentPage").getter(CitationLocation.getter(CitationLocation::documentPage)).setter(CitationLocation.setter(Builder::documentPage)).constructor(DocumentPageLocation::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("documentPage").build()}).build();
    private static final SdkField<DocumentChunkLocation> DOCUMENT_CHUNK_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("documentChunk").getter(CitationLocation.getter(CitationLocation::documentChunk)).setter(CitationLocation.setter(Builder::documentChunk)).constructor(DocumentChunkLocation::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("documentChunk").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DOCUMENT_CHAR_FIELD, DOCUMENT_PAGE_FIELD, DOCUMENT_CHUNK_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CitationLocation.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final DocumentCharLocation documentChar;
    private final DocumentPageLocation documentPage;
    private final DocumentChunkLocation documentChunk;
    private final Type type;

    private CitationLocation(BuilderImpl builder) {
        this.documentChar = builder.documentChar;
        this.documentPage = builder.documentPage;
        this.documentChunk = builder.documentChunk;
        this.type = builder.type;
    }

    public final DocumentCharLocation documentChar() {
        return this.documentChar;
    }

    public final DocumentPageLocation documentPage() {
        return this.documentPage;
    }

    public final DocumentChunkLocation documentChunk() {
        return this.documentChunk;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.documentChar());
        hashCode = 31 * hashCode + Objects.hashCode(this.documentPage());
        hashCode = 31 * hashCode + Objects.hashCode(this.documentChunk());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CitationLocation)) {
            return false;
        }
        CitationLocation other = (CitationLocation)obj;
        return Objects.equals(this.documentChar(), other.documentChar()) && Objects.equals(this.documentPage(), other.documentPage()) && Objects.equals(this.documentChunk(), other.documentChunk());
    }

    public final String toString() {
        return ToString.builder((String)"CitationLocation").add("DocumentChar", (Object)this.documentChar()).add("DocumentPage", (Object)this.documentPage()).add("DocumentChunk", (Object)this.documentChunk()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "documentChar": {
                return Optional.ofNullable(clazz.cast(this.documentChar()));
            }
            case "documentPage": {
                return Optional.ofNullable(clazz.cast(this.documentPage()));
            }
            case "documentChunk": {
                return Optional.ofNullable(clazz.cast(this.documentChunk()));
            }
        }
        return Optional.empty();
    }

    public static CitationLocation fromDocumentChar(DocumentCharLocation documentChar) {
        return (CitationLocation)CitationLocation.builder().documentChar(documentChar).build();
    }

    public static CitationLocation fromDocumentChar(Consumer<DocumentCharLocation.Builder> documentChar) {
        DocumentCharLocation.Builder builder = DocumentCharLocation.builder();
        documentChar.accept(builder);
        return CitationLocation.fromDocumentChar((DocumentCharLocation)builder.build());
    }

    public static CitationLocation fromDocumentPage(DocumentPageLocation documentPage) {
        return (CitationLocation)CitationLocation.builder().documentPage(documentPage).build();
    }

    public static CitationLocation fromDocumentPage(Consumer<DocumentPageLocation.Builder> documentPage) {
        DocumentPageLocation.Builder builder = DocumentPageLocation.builder();
        documentPage.accept(builder);
        return CitationLocation.fromDocumentPage((DocumentPageLocation)builder.build());
    }

    public static CitationLocation fromDocumentChunk(DocumentChunkLocation documentChunk) {
        return (CitationLocation)CitationLocation.builder().documentChunk(documentChunk).build();
    }

    public static CitationLocation fromDocumentChunk(Consumer<DocumentChunkLocation.Builder> documentChunk) {
        DocumentChunkLocation.Builder builder = DocumentChunkLocation.builder();
        documentChunk.accept(builder);
        return CitationLocation.fromDocumentChunk((DocumentChunkLocation)builder.build());
    }

    public Type type() {
        return this.type;
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("documentChar", DOCUMENT_CHAR_FIELD);
        map.put("documentPage", DOCUMENT_PAGE_FIELD);
        map.put("documentChunk", DOCUMENT_CHUNK_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CitationLocation, T> g) {
        return obj -> g.apply((CitationLocation)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    public static enum Type {
        DOCUMENT_CHAR,
        DOCUMENT_PAGE,
        DOCUMENT_CHUNK,
        UNKNOWN_TO_SDK_VERSION;

    }

    static final class BuilderImpl
    implements Builder {
        private DocumentCharLocation documentChar;
        private DocumentPageLocation documentPage;
        private DocumentChunkLocation documentChunk;
        private Type type = Type.UNKNOWN_TO_SDK_VERSION;
        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(CitationLocation model) {
            this.documentChar(model.documentChar);
            this.documentPage(model.documentPage);
            this.documentChunk(model.documentChunk);
        }

        public final DocumentCharLocation.Builder getDocumentChar() {
            return this.documentChar != null ? this.documentChar.toBuilder() : null;
        }

        public final void setDocumentChar(DocumentCharLocation.BuilderImpl documentChar) {
            DocumentCharLocation oldValue = this.documentChar;
            this.documentChar = documentChar != null ? documentChar.build() : null;
            this.handleUnionValueChange(Type.DOCUMENT_CHAR, oldValue, this.documentChar);
        }

        @Override
        public final Builder documentChar(DocumentCharLocation documentChar) {
            DocumentCharLocation oldValue = this.documentChar;
            this.documentChar = documentChar;
            this.handleUnionValueChange(Type.DOCUMENT_CHAR, oldValue, this.documentChar);
            return this;
        }

        public final DocumentPageLocation.Builder getDocumentPage() {
            return this.documentPage != null ? this.documentPage.toBuilder() : null;
        }

        public final void setDocumentPage(DocumentPageLocation.BuilderImpl documentPage) {
            DocumentPageLocation oldValue = this.documentPage;
            this.documentPage = documentPage != null ? documentPage.build() : null;
            this.handleUnionValueChange(Type.DOCUMENT_PAGE, oldValue, this.documentPage);
        }

        @Override
        public final Builder documentPage(DocumentPageLocation documentPage) {
            DocumentPageLocation oldValue = this.documentPage;
            this.documentPage = documentPage;
            this.handleUnionValueChange(Type.DOCUMENT_PAGE, oldValue, this.documentPage);
            return this;
        }

        public final DocumentChunkLocation.Builder getDocumentChunk() {
            return this.documentChunk != null ? this.documentChunk.toBuilder() : null;
        }

        public final void setDocumentChunk(DocumentChunkLocation.BuilderImpl documentChunk) {
            DocumentChunkLocation oldValue = this.documentChunk;
            this.documentChunk = documentChunk != null ? documentChunk.build() : null;
            this.handleUnionValueChange(Type.DOCUMENT_CHUNK, oldValue, this.documentChunk);
        }

        @Override
        public final Builder documentChunk(DocumentChunkLocation documentChunk) {
            DocumentChunkLocation oldValue = this.documentChunk;
            this.documentChunk = documentChunk;
            this.handleUnionValueChange(Type.DOCUMENT_CHUNK, oldValue, this.documentChunk);
            return this;
        }

        public CitationLocation build() {
            return new CitationLocation(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                this.setTypes.remove((Object)type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                this.setTypes.add(type);
            }
            this.type = this.setTypes.size() == 1 ? this.setTypes.iterator().next() : (this.setTypes.isEmpty() ? Type.UNKNOWN_TO_SDK_VERSION : null);
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, CitationLocation> {
        public Builder documentChar(DocumentCharLocation var1);

        default public Builder documentChar(Consumer<DocumentCharLocation.Builder> documentChar) {
            return this.documentChar((DocumentCharLocation)((DocumentCharLocation.Builder)DocumentCharLocation.builder().applyMutation(documentChar)).build());
        }

        public Builder documentPage(DocumentPageLocation var1);

        default public Builder documentPage(Consumer<DocumentPageLocation.Builder> documentPage) {
            return this.documentPage((DocumentPageLocation)((DocumentPageLocation.Builder)DocumentPageLocation.builder().applyMutation(documentPage)).build());
        }

        public Builder documentChunk(DocumentChunkLocation var1);

        default public Builder documentChunk(Consumer<DocumentChunkLocation.Builder> documentChunk) {
            return this.documentChunk((DocumentChunkLocation)((DocumentChunkLocation.Builder)DocumentChunkLocation.builder().applyMutation(documentChunk)).build());
        }
    }
}

