/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ml.cluster;

import java.util.List;
import lombok.Generated;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.cluster.ClusterStateListener;
import org.opensearch.cluster.LocalNodeClusterManagerListener;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.lifecycle.LifecycleListener;
import org.opensearch.common.settings.Settings;
import org.opensearch.common.unit.TimeValue;
import org.opensearch.core.action.ActionListener;
import org.opensearch.ml.autoredeploy.MLModelAutoReDeployer;
import org.opensearch.ml.cluster.DiscoveryNodeHelper;
import org.opensearch.ml.cluster.MLSyncUpCron;
import org.opensearch.ml.common.settings.MLCommonsSettings;
import org.opensearch.ml.common.settings.MLFeatureEnabledSetting;
import org.opensearch.ml.engine.encryptor.Encryptor;
import org.opensearch.ml.engine.indices.MLIndicesHandler;
import org.opensearch.remote.metadata.client.SdkClient;
import org.opensearch.threadpool.Scheduler;
import org.opensearch.threadpool.ThreadPool;
import org.opensearch.transport.client.Client;

public class MLCommonsClusterManagerEventListener
implements LocalNodeClusterManagerListener {
    @Generated
    private static final Logger log = LogManager.getLogger(MLCommonsClusterManagerEventListener.class);
    private final ClusterService clusterService;
    private Client client;
    private final SdkClient sdkClient;
    private ThreadPool threadPool;
    private Scheduler.Cancellable syncModelRoutingCron;
    private DiscoveryNodeHelper nodeHelper;
    private final MLIndicesHandler mlIndicesHandler;
    private final Encryptor encryptor;
    private volatile Integer jobInterval;
    private final MLModelAutoReDeployer mlModelAutoReDeployer;
    private final MLFeatureEnabledSetting mlFeatureEnabledSetting;

    public MLCommonsClusterManagerEventListener(ClusterService clusterService, Client client, SdkClient sdkClient, Settings settings, ThreadPool threadPool, DiscoveryNodeHelper nodeHelper, MLIndicesHandler mlIndicesHandler, Encryptor encryptor, MLModelAutoReDeployer modelAutoReDeployer, MLFeatureEnabledSetting mlFeatureEnabledSetting) {
        this.clusterService = clusterService;
        this.client = client;
        this.sdkClient = sdkClient;
        this.threadPool = threadPool;
        this.clusterService.addListener((ClusterStateListener)this);
        this.nodeHelper = nodeHelper;
        this.mlIndicesHandler = mlIndicesHandler;
        this.encryptor = encryptor;
        this.mlModelAutoReDeployer = modelAutoReDeployer;
        this.mlFeatureEnabledSetting = mlFeatureEnabledSetting;
        this.jobInterval = (Integer)MLCommonsSettings.ML_COMMONS_SYNC_UP_JOB_INTERVAL_IN_SECONDS.get(settings);
        clusterService.getClusterSettings().addSettingsUpdateConsumer(MLCommonsSettings.ML_COMMONS_SYNC_UP_JOB_INTERVAL_IN_SECONDS, it -> {
            this.jobInterval = it;
            this.cancel(this.syncModelRoutingCron);
            this.startSyncModelRoutingCron();
        });
    }

    public void onClusterManager() {
        ActionListener listener = ActionListener.wrap(r -> {
            if (this.syncModelRoutingCron == null) {
                this.startSyncModelRoutingCron();
            }
        }, e -> {
            if (this.syncModelRoutingCron == null) {
                this.startSyncModelRoutingCron();
            }
        });
        this.mlModelAutoReDeployer.setStartCronJobListener((ActionListener<Boolean>)listener);
        String localNodeId = this.clusterService.localNode().getId();
        this.threadPool.schedule(() -> this.mlModelAutoReDeployer.buildAutoReloadArrangement(List.of(localNodeId), localNodeId), TimeValue.timeValueSeconds((long)this.jobInterval.intValue()), "opensearch_ml_general");
    }

    private void startSyncModelRoutingCron() {
        if (this.jobInterval > 0) {
            log.info("Starting ML sync up job...");
            this.syncModelRoutingCron = this.threadPool.scheduleWithFixedDelay((Runnable)new MLSyncUpCron(this.client, this.sdkClient, this.clusterService, this.nodeHelper, this.mlIndicesHandler, this.encryptor, this.mlFeatureEnabledSetting), TimeValue.timeValueSeconds((long)this.jobInterval.intValue()), "opensearch_ml_general");
        } else {
            log.debug("Stop ML syncup job as its interval is: {}", (Object)this.jobInterval);
        }
        this.clusterService.addLifecycleListener(new LifecycleListener(){

            public void beforeStop() {
                MLCommonsClusterManagerEventListener.this.cancel(MLCommonsClusterManagerEventListener.this.syncModelRoutingCron);
                MLCommonsClusterManagerEventListener.this.syncModelRoutingCron = null;
            }
        });
    }

    public void offClusterManager() {
        this.cancel(this.syncModelRoutingCron);
        this.syncModelRoutingCron = null;
    }

    private void cancel(Scheduler.Cancellable cron) {
        if (cron != null) {
            cron.cancel();
        }
    }
}

