/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.search.aggregations.metrics;

import java.io.IOException;
import java.util.Map;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.search.ScoreMode;
import org.opensearch.common.lease.Releasable;
import org.opensearch.common.lease.Releasables;
import org.opensearch.common.util.BigArrays;
import org.opensearch.common.util.DoubleArray;
import org.opensearch.index.fielddata.SortedNumericDoubleValues;
import org.opensearch.search.DocValueFormat;
import org.opensearch.search.aggregations.AggregationExecutionException;
import org.opensearch.search.aggregations.Aggregator;
import org.opensearch.search.aggregations.InternalAggregation;
import org.opensearch.search.aggregations.LeafBucketCollector;
import org.opensearch.search.aggregations.LeafBucketCollectorBase;
import org.opensearch.search.aggregations.metrics.CompensatedSum;
import org.opensearch.search.aggregations.metrics.InternalWeightedAvg;
import org.opensearch.search.aggregations.metrics.NumericMetricsAggregator;
import org.opensearch.search.aggregations.metrics.WeightedAvgAggregationBuilder;
import org.opensearch.search.aggregations.support.MultiValuesSource;
import org.opensearch.search.internal.SearchContext;

class WeightedAvgAggregator
extends NumericMetricsAggregator.SingleValue {
    private final MultiValuesSource.NumericMultiValuesSource valuesSources;
    private DoubleArray weights;
    private DoubleArray valueSums;
    private DoubleArray valueCompensations;
    private DoubleArray weightCompensations;
    private DocValueFormat format;

    WeightedAvgAggregator(String name, MultiValuesSource.NumericMultiValuesSource valuesSources, DocValueFormat format, SearchContext context, Aggregator parent, Map<String, Object> metadata) throws IOException {
        super(name, context, parent, metadata);
        this.valuesSources = valuesSources;
        this.format = format;
        if (valuesSources != null) {
            BigArrays bigArrays = context.bigArrays();
            this.weights = bigArrays.newDoubleArray(1L, true);
            this.valueSums = bigArrays.newDoubleArray(1L, true);
            this.valueCompensations = bigArrays.newDoubleArray(1L, true);
            this.weightCompensations = bigArrays.newDoubleArray(1L, true);
        }
    }

    @Override
    public ScoreMode scoreMode() {
        return this.valuesSources != null && this.valuesSources.needsScores() ? ScoreMode.COMPLETE : ScoreMode.COMPLETE_NO_SCORES;
    }

    @Override
    public LeafBucketCollector getLeafCollector(LeafReaderContext ctx, LeafBucketCollector sub) throws IOException {
        if (this.valuesSources == null) {
            return LeafBucketCollector.NO_OP_COLLECTOR;
        }
        final BigArrays bigArrays = this.context.bigArrays();
        final SortedNumericDoubleValues docValues = this.valuesSources.getField(WeightedAvgAggregationBuilder.VALUE_FIELD.getPreferredName(), ctx);
        final SortedNumericDoubleValues docWeights = this.valuesSources.getField(WeightedAvgAggregationBuilder.WEIGHT_FIELD.getPreferredName(), ctx);
        final CompensatedSum compensatedValueSum = new CompensatedSum(0.0, 0.0);
        final CompensatedSum compensatedWeightSum = new CompensatedSum(0.0, 0.0);
        return new LeafBucketCollectorBase(sub, docValues){

            @Override
            public void collect(int doc, long bucket) throws IOException {
                WeightedAvgAggregator.this.weights = bigArrays.grow(WeightedAvgAggregator.this.weights, bucket + 1L);
                WeightedAvgAggregator.this.valueSums = bigArrays.grow(WeightedAvgAggregator.this.valueSums, bucket + 1L);
                WeightedAvgAggregator.this.valueCompensations = bigArrays.grow(WeightedAvgAggregator.this.valueCompensations, bucket + 1L);
                WeightedAvgAggregator.this.weightCompensations = bigArrays.grow(WeightedAvgAggregator.this.weightCompensations, bucket + 1L);
                if (docValues.advanceExact(doc) && docWeights.advanceExact(doc)) {
                    if (docWeights.docValueCount() > 1) {
                        throw new AggregationExecutionException("Encountered more than one weight for a single document. Use a script to combine multiple weights-per-doc into a single value.");
                    }
                    assert (docWeights.docValueCount() == 1);
                    double weight = docWeights.nextValue();
                    int numValues = docValues.docValueCount();
                    assert (numValues > 0);
                    double valueSum = WeightedAvgAggregator.this.valueSums.get(bucket);
                    double valueCompensation = WeightedAvgAggregator.this.valueCompensations.get(bucket);
                    compensatedValueSum.reset(valueSum, valueCompensation);
                    double weightSum = WeightedAvgAggregator.this.weights.get(bucket);
                    double weightCompensation = WeightedAvgAggregator.this.weightCompensations.get(bucket);
                    compensatedWeightSum.reset(weightSum, weightCompensation);
                    for (int i = 0; i < numValues; ++i) {
                        compensatedValueSum.add(docValues.nextValue() * weight);
                        compensatedWeightSum.add(weight);
                    }
                    WeightedAvgAggregator.this.valueSums.set(bucket, compensatedValueSum.value());
                    WeightedAvgAggregator.this.valueCompensations.set(bucket, compensatedValueSum.delta());
                    WeightedAvgAggregator.this.weights.set(bucket, compensatedWeightSum.value());
                    WeightedAvgAggregator.this.weightCompensations.set(bucket, compensatedWeightSum.delta());
                }
            }
        };
    }

    @Override
    public double metric(long owningBucketOrd) {
        if (this.valuesSources == null || owningBucketOrd >= this.valueSums.size()) {
            return Double.NaN;
        }
        return this.valueSums.get(owningBucketOrd) / this.weights.get(owningBucketOrd);
    }

    @Override
    public InternalAggregation buildAggregation(long bucket) {
        if (this.valuesSources == null || bucket >= this.valueSums.size()) {
            return this.buildEmptyAggregation();
        }
        return new InternalWeightedAvg(this.name, this.valueSums.get(bucket), this.weights.get(bucket), this.format, this.metadata());
    }

    @Override
    public InternalAggregation buildEmptyAggregation() {
        return new InternalWeightedAvg(this.name, 0.0, 0.0, this.format, this.metadata());
    }

    @Override
    public void doClose() {
        Releasables.close((Releasable[])new Releasable[]{this.weights, this.valueSums, this.valueCompensations, this.weightCompensations});
    }
}

