/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jandex;

import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.InputStream;
import java.lang.reflect.Array;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

class Utils {
    static final byte[] INIT_METHOD_NAME = Utils.toUTF8("<init>");
    static final byte[] CLINIT_METHOD_NAME = Utils.toUTF8("<clinit>");

    Utils() {
    }

    static byte[] toUTF8(String string) {
        return string.getBytes(StandardCharsets.UTF_8);
    }

    static String fromUTF8(byte[] bytes) {
        return new String(bytes, StandardCharsets.UTF_8);
    }

    static <K, V> Map<K, V[]> unfold(Map<K, List<V>> map, Class<V> listElementType) {
        if (map.isEmpty()) {
            return Collections.emptyMap();
        }
        HashMap result = new HashMap();
        map.forEach((key, value) -> {
            Object[] array = (Object[])Array.newInstance(listElementType, value.size());
            result.put(key, value.toArray(array));
        });
        return result;
    }

    static <K, V> Map<K, V> minimize(Map<K, V> map) {
        if (map.isEmpty()) {
            return Collections.emptyMap();
        }
        if (map.size() == 1) {
            Map.Entry<K, V> entry = map.entrySet().iterator().next();
            return Collections.singletonMap(entry.getKey(), entry.getValue());
        }
        return map;
    }

    static <T> List<T> listOfCapacity(int capacity) {
        return capacity > 0 ? new ArrayList(capacity) : Collections.emptyList();
    }

    private static final class ReusableBufferedInputStream
    extends BufferedInputStream {
        private ReusableBufferedInputStream() {
            super(null);
        }

        void setInputStream(InputStream in) {
            Objects.requireNonNull(in);
            if (this.pos != 0 && this.in != null) {
                throw new IllegalStateException("the stream cannot be reused");
            }
            this.in = in;
        }

        @Override
        public void close() {
            this.in = null;
            this.count = 0;
            this.pos = 0;
        }

        @Override
        public boolean markSupported() {
            return false;
        }

        @Override
        @Deprecated
        public synchronized void mark(int readlimit) {
            throw new UnsupportedOperationException("mark/reset not supported");
        }

        @Override
        @Deprecated
        public synchronized void reset() {
            throw new UnsupportedOperationException("mark/reset not supported");
        }
    }

    static final class ReusableBufferedDataInputStream
    extends DataInputStream {
        private ReusableBufferedInputStream reusableBuffered = null;

        ReusableBufferedDataInputStream() {
            super(null);
        }

        void setInputStream(InputStream in) {
            Objects.requireNonNull(in);
            if (in instanceof BufferedInputStream) {
                assert (!(in instanceof ReusableBufferedInputStream));
                this.in = in;
            } else {
                if (this.in == null) {
                    if (this.reusableBuffered == null) {
                        this.reusableBuffered = new ReusableBufferedInputStream();
                    }
                    this.in = this.reusableBuffered;
                }
                this.reusableBuffered.setInputStream(in);
            }
        }

        @Override
        public void close() {
            if (this.in == this.reusableBuffered) {
                this.reusableBuffered.close();
            } else {
                this.in = null;
            }
        }

        @Override
        public boolean markSupported() {
            return false;
        }

        @Override
        @Deprecated
        public synchronized void mark(int readlimit) {
            throw new UnsupportedOperationException("mark/reset not supported");
        }

        @Override
        @Deprecated
        public synchronized void reset() {
            throw new UnsupportedOperationException("mark/reset not supported");
        }
    }
}

