/*
 * Decompiled with CFR 0.152.
 */
package com.dynatrace.hash4j.similarity;

import com.dynatrace.hash4j.internal.Preconditions;
import com.dynatrace.hash4j.random.PseudoRandomGenerator;
import com.dynatrace.hash4j.random.PseudoRandomGeneratorProvider;
import com.dynatrace.hash4j.similarity.AbstractSimilarityHashPolicy;
import com.dynatrace.hash4j.similarity.ElementHashProvider;
import com.dynatrace.hash4j.similarity.SimilarityHasher;
import java.util.Arrays;
import java.util.Objects;

final class FastSimHashPolicy_v1
extends AbstractSimilarityHashPolicy {
    private static final int BULK_CONSTANT = 3;
    private static final long TEMPORARY_COUNTER_LIMIT = FastSimHashPolicy_v1.calculateTemporaryCounterLimit(3);
    private static final long BULK_MASK = FastSimHashPolicy_v1.calculateBulkMask(3);

    public FastSimHashPolicy_v1(int numberOfComponents, PseudoRandomGeneratorProvider pseudoRandomGeneratorProvider) {
        super(numberOfComponents, 1, pseudoRandomGeneratorProvider);
    }

    @Override
    public SimilarityHasher createHasher() {
        return new Hasher();
    }

    static long calculateBulkMask(int bulkConstant) {
        long mask = 1L;
        for (int i = 0; i < bulkConstant; ++i) {
            mask |= mask << (1 << 5 - i);
        }
        return mask;
    }

    static long calculateTemporaryCounterLimit(int bulkConstant) {
        return (2L << (1 << 6 - bulkConstant) - 1) - 1L;
    }

    private class Hasher
    implements SimilarityHasher {
        private final int[] counts;
        private final long[] tmpCounts;
        private final PseudoRandomGenerator pseudoRandomGenerator;

        private Hasher() {
            this.counts = new int[FastSimHashPolicy_v1.this.numberOfComponents];
            this.tmpCounts = new long[FastSimHashPolicy_v1.this.numberOfComponents + 7 >>> 3];
            this.pseudoRandomGenerator = FastSimHashPolicy_v1.this.pseudoRandomGeneratorProvider.create();
        }

        @Override
        public byte[] compute(ElementHashProvider elementHashProvider) {
            Objects.requireNonNull(elementHashProvider);
            int numberOfElements = elementHashProvider.getNumberOfElements();
            Preconditions.checkArgument(numberOfElements > 0, "Number of elements must be positive!");
            Arrays.fill(this.counts, 0);
            Arrays.fill(this.tmpCounts, 0L);
            int numTmpCountChunks = this.tmpCounts.length >>> 3;
            int numTmpCountRemaining = this.tmpCounts.length & 7;
            long c = 0L;
            for (int k = 0; k < numberOfElements; ++k) {
                int g;
                long tmp;
                int off;
                int h;
                long elementHash = elementHashProvider.getElementHash(k);
                this.pseudoRandomGenerator.reset(elementHash);
                for (h = 0; h < numTmpCountChunks; ++h) {
                    long randomValue = this.pseudoRandomGenerator.nextLong();
                    off = h << 3;
                    for (int j = 0; j < 8; ++j) {
                        int n = off + j;
                        this.tmpCounts[n] = this.tmpCounts[n] + (randomValue >>> j & BULK_MASK);
                    }
                }
                if (numTmpCountRemaining > 0) {
                    long randomValue = this.pseudoRandomGenerator.nextLong();
                    int off2 = numTmpCountChunks << 3;
                    for (int j = 0; j < numTmpCountRemaining; ++j) {
                        int n = off2 + j;
                        this.tmpCounts[n] = this.tmpCounts[n] + (randomValue >>> j & BULK_MASK);
                    }
                }
                if (++c != TEMPORARY_COUNTER_LIMIT && k != numberOfElements - 1) continue;
                c = 0L;
                for (h = 0; h < this.counts.length >>> 3; ++h) {
                    tmp = this.tmpCounts[h];
                    this.tmpCounts[h] = 0L;
                    off = h << 3;
                    for (g = 0; g < 8; ++g) {
                        int n = off + g;
                        this.counts[n] = this.counts[n] + (int)(tmp >>> (g << 3) & TEMPORARY_COUNTER_LIMIT);
                    }
                }
                for (h = this.counts.length >>> 3; h < this.tmpCounts.length; ++h) {
                    tmp = this.tmpCounts[h];
                    this.tmpCounts[h] = 0L;
                    off = h << 3;
                    for (g = 0; g < this.counts.length - (h << 3); ++g) {
                        int n = off + g;
                        this.counts[n] = this.counts[n] + (int)(tmp >>> (g << 3) & TEMPORARY_COUNTER_LIMIT);
                    }
                }
            }
            long limit = numberOfElements >>> 1;
            return FastSimHashPolicy_v1.this.packedArrayHandler.create(i -> (long)(this.counts[i] + (i & (~numberOfElements & 1))) > limit ? 1L : 0L, FastSimHashPolicy_v1.this.numberOfComponents);
        }
    }
}

