/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.j2k.copyPaste;

import com.intellij.codeInsight.editorActions.CopyPastePostProcessor;
import com.intellij.codeInsight.editorActions.TextBlockTransferableData;
import com.intellij.openapi.diagnostic.ControlFlowException;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaFile;
import java.awt.datatransfer.Transferable;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.TestOnly;
import org.jetbrains.kotlin.idea.editor.KotlinEditorOptions;
import org.jetbrains.kotlin.idea.statistics.ConversionType;
import org.jetbrains.kotlin.idea.statistics.J2KFusCollector;
import org.jetbrains.kotlin.j2k.J2kConverterExtension;
import org.jetbrains.kotlin.j2k.copyPaste.ConversionData;
import org.jetbrains.kotlin.j2k.copyPaste.ConvertJavaCopyPasteProcessorKt;
import org.jetbrains.kotlin.j2k.copyPaste.CopiedJavaCode;
import org.jetbrains.kotlin.j2k.copyPaste.CopyPasteConversionUtilsKt;
import org.jetbrains.kotlin.j2k.copyPaste.J2KCopyPasteConverter;
import org.jetbrains.kotlin.j2k.copyPaste.TargetData;
import org.jetbrains.kotlin.j2k.copyPaste.TargetDataKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0015\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u001dB\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0016\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J.\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00020\u00062\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000fH\u0016JF\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u000e\u0010\u0019\u001a\n\u0012\u0006\b\u0000\u0012\u00020\u001b0\u001a2\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00020\u0006H\u0016\u00a8\u0006\u001e"}, d2={"Lorg/jetbrains/kotlin/j2k/copyPaste/ConvertJavaCopyPasteProcessor;", "Lcom/intellij/codeInsight/editorActions/CopyPastePostProcessor;", "Lcom/intellij/codeInsight/editorActions/TextBlockTransferableData;", "<init>", "()V", "extractTransferableData", "", "content", "Ljava/awt/datatransfer/Transferable;", "collectTransferableData", "file", "Lcom/intellij/psi/PsiFile;", "editor", "Lcom/intellij/openapi/editor/Editor;", "startOffsets", "", "endOffsets", "processTransferableData", "", "project", "Lcom/intellij/openapi/project/Project;", "bounds", "Lcom/intellij/openapi/editor/RangeMarker;", "caretOffset", "", "indented", "Lcom/intellij/openapi/util/Ref;", "", "values", "Util", "kotlin.j2k.shared"})
@SourceDebugExtension(value={"SMAP\nConvertJavaCopyPasteProcessor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ConvertJavaCopyPasteProcessor.kt\norg/jetbrains/kotlin/j2k/copyPaste/ConvertJavaCopyPasteProcessor\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 Timing.kt\nkotlin/system/TimingKt\n*L\n1#1,104:1\n1#2:105\n29#3,3:106\n*S KotlinDebug\n*F\n+ 1 ConvertJavaCopyPasteProcessor.kt\norg/jetbrains/kotlin/j2k/copyPaste/ConvertJavaCopyPasteProcessor\n*L\n87#1:106,3\n*E\n"})
public final class ConvertJavaCopyPasteProcessor
extends CopyPastePostProcessor<TextBlockTransferableData> {
    @NotNull
    public List<TextBlockTransferableData> extractTransferableData(@NotNull Transferable content) {
        Intrinsics.checkNotNullParameter((Object)content, (String)"content");
        try {
            if (content.isDataFlavorSupported(CopiedJavaCode.Companion.getDATA_FLAVOR())) {
                Object object = content.getTransferData(CopiedJavaCode.Companion.getDATA_FLAVOR());
                Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type com.intellij.codeInsight.editorActions.TextBlockTransferableData");
                return CollectionsKt.listOf((Object)((TextBlockTransferableData)object));
            }
        }
        catch (Throwable e) {
            if (e instanceof ControlFlowException) {
                throw e;
            }
            ConvertJavaCopyPasteProcessorKt.access$getLOG$p().error(e);
        }
        return CollectionsKt.emptyList();
    }

    @NotNull
    public List<TextBlockTransferableData> collectTransferableData(@NotNull PsiFile file, @NotNull Editor editor, @NotNull int[] startOffsets, @NotNull int[] endOffsets) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)startOffsets, (String)"startOffsets");
        Intrinsics.checkNotNullParameter((Object)endOffsets, (String)"endOffsets");
        if (!(file instanceof PsiJavaFile)) {
            return CollectionsKt.emptyList();
        }
        String string = file.getText();
        Intrinsics.checkNotNull((Object)string);
        return CollectionsKt.listOf((Object)new CopiedJavaCode(string, startOffsets, endOffsets));
    }

    /*
     * WARNING - void declaration
     */
    public void processTransferableData(@NotNull Project project, @NotNull Editor editor, @NotNull RangeMarker bounds, int caretOffset, @NotNull Ref<? super Boolean> indented, @NotNull List<? extends TextBlockTransferableData> values2) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)bounds, (String)"bounds");
        Intrinsics.checkNotNullParameter(indented, (String)"indented");
        Intrinsics.checkNotNullParameter(values2, (String)"values");
        if (DumbService.Companion.getInstance(project).isDumb()) {
            return;
        }
        if (!KotlinEditorOptions.getInstance().isEnableJavaToKotlinConversion()) {
            return;
        }
        Document document = editor.getDocument();
        Intrinsics.checkNotNullExpressionValue((Object)document, (String)"getDocument(...)");
        TargetData targetData = TargetDataKt.getTargetData(project, document, caretOffset, bounds);
        if (targetData == null) {
            return;
        }
        TargetData targetData2 = targetData;
        if (!CopyPasteConversionUtilsKt.isConversionSupportedAtPosition(targetData2.getFile(), targetData2.getBounds().getStartOffset())) {
            return;
        }
        Object object = CollectionsKt.single(values2);
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.j2k.copyPaste.CopiedJavaCode");
        CopiedJavaCode copiedJavaCode = (CopiedJavaCode)object;
        ConversionData conversionData = ConversionData.Companion.prepare(copiedJavaCode, project);
        J2kConverterExtension.Kind j2kKind = CopyPasteConversionUtilsKt.getJ2kKind(targetData2.getFile());
        J2KCopyPasteConverter converter = J2kConverterExtension.Companion.extension(j2kKind).createCopyPasteConverter(project, editor, conversionData, targetData2);
        Iterable iterable = (Iterable)ArraysKt.getIndices((int[])copiedJavaCode.getStartOffsets());
        int n = 0;
        Iterator iterator2 = iterable.iterator();
        while (iterator2.hasNext()) {
            void it;
            int n2;
            int n3 = n2 = ((IntIterator)iterator2).nextInt();
            int n4 = n;
            boolean bl = false;
            int n5 = copiedJavaCode.getEndOffsets()[it] - copiedJavaCode.getStartOffsets()[it];
            n = n4 + n5;
        }
        int textLength = n;
        if (textLength < 1000 && converter.convertAndRestoreReferencesIfTextIsUnchanged()) {
            return;
        }
        if (!CopyPasteConversionUtilsKt.confirmConvertJavaOnPaste(project, false)) {
            return;
        }
        boolean $i$f$measureTimeMillis = false;
        long start$iv = System.currentTimeMillis();
        boolean bl = false;
        converter.convert();
        long conversionTime = System.currentTimeMillis() - start$iv;
        J2KFusCollector.INSTANCE.log(ConversionType.PSI_EXPRESSION, j2kKind == J2kConverterExtension.Kind.K1_NEW, conversionTime, CopyPasteConversionUtilsKt.lineCount(conversionData.getElementsAndTexts()), 1);
        Util.INSTANCE.setConversionPerformed(true);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u001c\u0010\u0004\u001a\u00020\u00058\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\t\u00a8\u0006\n"}, d2={"Lorg/jetbrains/kotlin/j2k/copyPaste/ConvertJavaCopyPasteProcessor$Util;", "", "<init>", "()V", "conversionPerformed", "", "getConversionPerformed", "()Z", "setConversionPerformed", "(Z)V", "kotlin.j2k.shared"})
    public static final class Util {
        @NotNull
        public static final Util INSTANCE = new Util();
        private static boolean conversionPerformed;

        private Util() {
        }

        @TestOnly
        public final boolean getConversionPerformed() {
            return conversionPerformed;
        }

        public final void setConversionPerformed(boolean bl) {
            conversionPerformed = bl;
        }
    }
}

