/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.quickfix;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.ConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.diagnostics.Diagnostic;
import org.jetbrains.kotlin.idea.actions.KotlinAddImportAction;
import org.jetbrains.kotlin.idea.actions.KotlinAddImportActionKt;
import org.jetbrains.kotlin.idea.core.KotlinIndicesHelper;
import org.jetbrains.kotlin.idea.imports.ImportsUtils;
import org.jetbrains.kotlin.idea.quickfix.AbstractImportFixKt;
import org.jetbrains.kotlin.idea.quickfix.ImportFixBase;
import org.jetbrains.kotlin.idea.references.ReferenceUtilsKt;
import org.jetbrains.kotlin.idea.util.CallTypeAndReceiver;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import org.jetbrains.kotlin.resolve.BindingContext;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u0000  2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001 B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\n\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u0014J6\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u000b\u001a\u00020\f2\u000e\u0010\r\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J&\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001aH\u0014R\u001a\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001d0\u001aX\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001f\u00a8\u0006!"}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/ImportConstructorReferenceFix;", "Lorg/jetbrains/kotlin/idea/quickfix/ImportFixBase;", "Lorg/jetbrains/kotlin/psi/KtSimpleNameExpression;", "expression", "<init>", "(Lorg/jetbrains/kotlin/psi/KtSimpleNameExpression;)V", "getCallTypeAndReceiver", "Lorg/jetbrains/kotlin/idea/util/CallTypeAndReceiver$CALLABLE_REFERENCE;", "fillCandidates", "", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "name", "", "callTypeAndReceiver", "Lorg/jetbrains/kotlin/idea/util/CallTypeAndReceiver;", "bindingContext", "Lorg/jetbrains/kotlin/resolve/BindingContext;", "indicesHelper", "Lorg/jetbrains/kotlin/idea/core/KotlinIndicesHelper;", "createAction", "Lorg/jetbrains/kotlin/idea/actions/KotlinAddImportAction;", "editor", "Lcom/intellij/openapi/editor/Editor;", "element", "Lorg/jetbrains/kotlin/psi/KtExpression;", "suggestions", "", "Lorg/jetbrains/kotlin/name/FqName;", "importNames", "Lorg/jetbrains/kotlin/name/Name;", "getImportNames", "()Ljava/util/Collection;", "MyFactory", "kotlin.idea"})
public final class ImportConstructorReferenceFix
extends ImportFixBase<KtSimpleNameExpression> {
    @NotNull
    public static final MyFactory MyFactory = new MyFactory(null);
    @NotNull
    private final Collection<Name> importNames;

    public ImportConstructorReferenceFix(@NotNull KtSimpleNameExpression expression) {
        Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
        super((KtExpression)expression, MyFactory);
        Object object = (KtSimpleNameExpression)this.getElement();
        if (object == null || (object = ReferenceUtilsKt.getMainReference((KtSimpleNameExpression)object)) == null || (object = object.getResolvesByNames()) == null) {
            object = CollectionsKt.emptyList();
        }
        this.importNames = object;
    }

    @Nullable
    protected CallTypeAndReceiver.CALLABLE_REFERENCE getCallTypeAndReceiver() {
        CallTypeAndReceiver.CALLABLE_REFERENCE cALLABLE_REFERENCE;
        KtSimpleNameExpression ktSimpleNameExpression = (KtSimpleNameExpression)this.getElement();
        if (ktSimpleNameExpression != null) {
            KtSimpleNameExpression it = ktSimpleNameExpression;
            boolean bl = false;
            CallTypeAndReceiver<?, ?> callTypeAndReceiver = CallTypeAndReceiver.Companion.detect(it);
            cALLABLE_REFERENCE = callTypeAndReceiver instanceof CallTypeAndReceiver.CALLABLE_REFERENCE ? (CallTypeAndReceiver.CALLABLE_REFERENCE)callTypeAndReceiver : null;
        } else {
            cALLABLE_REFERENCE = null;
        }
        return cALLABLE_REFERENCE;
    }

    @Override
    @NotNull
    public List<DeclarationDescriptor> fillCandidates(@NotNull String name2, @NotNull CallTypeAndReceiver<?, ?> callTypeAndReceiver, @NotNull BindingContext bindingContext, @NotNull KotlinIndicesHelper indicesHelper2) {
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        Intrinsics.checkNotNullParameter(callTypeAndReceiver, (String)"callTypeAndReceiver");
        Intrinsics.checkNotNullParameter((Object)bindingContext, (String)"bindingContext");
        Intrinsics.checkNotNullParameter((Object)indicesHelper2, (String)"indicesHelper");
        KtSimpleNameExpression ktSimpleNameExpression = (KtSimpleNameExpression)this.getElement();
        if (ktSimpleNameExpression == null) {
            return CollectionsKt.emptyList();
        }
        KtSimpleNameExpression expression = ktSimpleNameExpression;
        Function1 filterByCallType = AbstractImportFixKt.access$toFilter(callTypeAndReceiver);
        return SequencesKt.toList((Sequence)SequencesKt.filter((Sequence)SequencesKt.filter((Sequence)SequencesKt.flatMapIterable((Sequence)CollectionsKt.asSequence((Iterable)AbstractImportFixKt.access$getClassifiersByName(indicesHelper2, (KtExpression)expression, name2)), ImportConstructorReferenceFix::fillCandidates$lambda$0), ImportConstructorReferenceFix::fillCandidates$lambda$1), (Function1)filterByCallType));
    }

    @Override
    @NotNull
    protected KotlinAddImportAction createAction(@NotNull Editor editor, @NotNull KtExpression element, @NotNull Collection<FqName> suggestions) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter(suggestions, (String)"suggestions");
        Project project = element.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        return KotlinAddImportActionKt.createSingleImportActionForConstructor(project, editor, (KtElement)element, suggestions);
    }

    @Override
    @NotNull
    protected Collection<Name> getImportNames() {
        return this.importNames;
    }

    private static final Iterable fillCandidates$lambda$0(ClassifierDescriptor it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return ImportsUtils.getConstructors(it);
    }

    private static final boolean fillCandidates$lambda$1(ConstructorDescriptor it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return ImportsUtils.getImportableFqName((DeclarationDescriptor)it) != null;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\b"}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/ImportConstructorReferenceFix$MyFactory;", "Lorg/jetbrains/kotlin/idea/quickfix/ImportFixBase$FactoryWithUnresolvedReferenceQuickFix;", "<init>", "()V", "createImportAction", "Lorg/jetbrains/kotlin/idea/quickfix/ImportConstructorReferenceFix;", "diagnostic", "Lorg/jetbrains/kotlin/diagnostics/Diagnostic;", "kotlin.idea"})
    @SourceDebugExtension(value={"SMAP\nAbstractImportFix.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AbstractImportFix.kt\norg/jetbrains/kotlin/idea/quickfix/ImportConstructorReferenceFix$MyFactory\n+ 2 addToStdlib.kt\norg/jetbrains/kotlin/utils/addToStdlib/AddToStdlibKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,986:1\n125#2:987\n1#3:988\n*S KotlinDebug\n*F\n+ 1 AbstractImportFix.kt\norg/jetbrains/kotlin/idea/quickfix/ImportConstructorReferenceFix$MyFactory\n*L\n630#1:987\n*E\n"})
    public static final class MyFactory
    extends ImportFixBase.FactoryWithUnresolvedReferenceQuickFix {
        private MyFactory() {
        }

        @Nullable
        public ImportConstructorReferenceFix createImportAction(@NotNull Diagnostic diagnostic) {
            ImportConstructorReferenceFix importConstructorReferenceFix;
            Intrinsics.checkNotNullParameter((Object)diagnostic, (String)"diagnostic");
            PsiElement $this$safeAs$iv = diagnostic.getPsiElement();
            boolean $i$f$safeAs = false;
            PsiElement psiElement = $this$safeAs$iv;
            if (!(psiElement instanceof KtSimpleNameExpression)) {
                psiElement = null;
            }
            KtSimpleNameExpression ktSimpleNameExpression = (KtSimpleNameExpression)psiElement;
            if (ktSimpleNameExpression != null) {
                KtSimpleNameExpression p0 = ktSimpleNameExpression;
                boolean bl = false;
                importConstructorReferenceFix = new ImportConstructorReferenceFix(p0);
            } else {
                importConstructorReferenceFix = null;
            }
            return importConstructorReferenceFix;
        }

        public /* synthetic */ MyFactory(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

