/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.style.css.om;

import io.sf.carte.doc.agent.DeviceFactory;
import io.sf.carte.doc.style.css.CSSFontFaceRule;
import io.sf.carte.doc.style.css.SelectorMatcher;
import io.sf.carte.doc.style.css.StyleDatabase;
import io.sf.carte.doc.style.css.StyleFormattingContext;
import io.sf.carte.doc.style.css.om.AbstractCSSStyleSheet;
import io.sf.carte.doc.style.css.om.BaseCSSDeclarationRule;
import io.sf.carte.doc.style.css.om.BaseDocumentCSSStyleSheet;
import io.sf.carte.doc.style.css.om.ComputedCSSStyle;
import io.sf.carte.util.BufferSimpleWriter;
import io.sf.carte.util.SimpleWriter;
import java.io.IOException;
import org.w3c.dom.DOMException;

public class FontFaceRule
extends BaseCSSDeclarationRule
implements CSSFontFaceRule {
    private static final long serialVersionUID = 1L;

    public FontFaceRule(AbstractCSSStyleSheet parentSheet, int origin) {
        super(parentSheet, (short)5, origin);
    }

    @Override
    void cascade(BaseDocumentCSSStyleSheet.Cascade cascade, SelectorMatcher matcher, ComputedCSSStyle style, String targetMedium) {
        StyleDatabase sdb;
        DeviceFactory df = this.getParentStyleSheet().getStyleSheetFactory().getDeviceFactory();
        if (df != null && (sdb = df.getStyleDatabase(targetMedium)) != null) {
            sdb.loadFontFaceRule(this);
        }
    }

    @Override
    public String getCssText() {
        StyleFormattingContext context = this.getStyleFormattingContext();
        context.setParentContext(this.getParentRule());
        BufferSimpleWriter sw = new BufferSimpleWriter(50 + this.getStyle().getLength() * 24);
        try {
            this.writeCssText((SimpleWriter)sw, context);
        }
        catch (IOException e) {
            throw new DOMException(11, e.getMessage());
        }
        return sw.toString();
    }

    @Override
    public String getMinifiedCssText() {
        if (this.getStyle().getLength() != 0) {
            StringBuilder buf = new StringBuilder(128);
            buf.append("@font-face{").append(this.getStyle().getMinifiedCssText()).append('}');
            return buf.toString();
        }
        return "";
    }

    @Override
    public void writeCssText(SimpleWriter wri, StyleFormattingContext context) throws IOException {
        if (this.getStyle().getLength() != 0) {
            context.startRule(wri, this.getPrecedingComments());
            wri.write((CharSequence)"@font-face");
            context.updateContext(this);
            context.writeLeftCurlyBracket(wri);
            context.startStyleDeclaration(wri);
            this.getStyle().writeCssText(wri, context);
            context.endCurrentContext(this);
            context.endStyleDeclaration(wri);
            context.writeRightCurlyBracket(wri);
            context.endRule(wri, this.getTrailingComments());
        }
    }
}

