/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.style.css.property;

import io.sf.carte.doc.style.css.CSSValue;
import io.sf.carte.doc.style.css.parser.ParseHelper;
import io.sf.carte.doc.style.css.property.URIValue;
import io.sf.carte.doc.style.css.property.WrappedValue;
import io.sf.carte.util.BufferSimpleWriter;
import io.sf.carte.util.SimpleWriter;
import java.io.IOException;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import org.w3c.dom.DOMException;

public class URIValueWrapper
extends URIValue
implements WrappedValue {
    private static final long serialVersionUID = 1L;
    private final String parentSheetHref;

    public URIValueWrapper(URIValue uRIValue, String string, String string2) {
        super(uRIValue);
        this.parentSheetHref = string2;
        if (string != string2) {
            this.setStringValue(this.getStringValue(super.getStringValue(), string));
        }
    }

    @Override
    public String getParentSheetHref() {
        return this.parentSheetHref;
    }

    @Override
    public String getCssText() {
        String string = this.getStringValue();
        if (string == null) {
            return "";
        }
        BufferSimpleWriter bufferSimpleWriter = new BufferSimpleWriter(string.length() + 6);
        try {
            this.writeCssText((SimpleWriter)bufferSimpleWriter);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return bufferSimpleWriter.toString();
    }

    @Override
    public void writeCssText(SimpleWriter simpleWriter) throws IOException {
        String string = this.getStringValue();
        if (string != null) {
            simpleWriter.write((CharSequence)"url(");
            string = ParseHelper.quote(string, this.quote);
            simpleWriter.write((CharSequence)string);
            simpleWriter.write(')');
        }
    }

    @Override
    public String getMinifiedCssText(String string) {
        URI uRI;
        URI uRI2;
        int n;
        String string2 = this.getStringValue();
        if (string2 == null) {
            return "";
        }
        if (this.parentSheetHref == null || (n = this.parentSheetHref.lastIndexOf(47)) == -1) {
            return super.getCssText();
        }
        String string3 = this.parentSheetHref.substring(0, n + 1);
        try {
            uRI2 = new URI(string2);
            uRI = new URI(string3);
        }
        catch (URISyntaxException uRISyntaxException) {
            return super.getCssText();
        }
        uRI = uRI.normalize();
        String string4 = uRI.relativize(uRI2).toASCIIString();
        String string5 = ParseHelper.quote(string4, this.quote);
        return "url(" + string5 + ')';
    }

    @Override
    public void setCssText(String string) throws DOMException {
        this.error();
    }

    @Override
    public String getStringValue() {
        return this.getStringValue(super.getStringValue(), this.parentSheetHref);
    }

    private String getStringValue(String string, String string2) {
        if (string != null) {
            Serializable serializable;
            if (!string.contains("://") && string2 != null) {
                try {
                    serializable = new URL(string2);
                    URL uRL = new URL((URL)serializable, string);
                    string = uRL.toExternalForm();
                }
                catch (MalformedURLException malformedURLException) {
                    // empty catch block
                }
            }
            try {
                serializable = new URI(string);
                string = serializable.normalize().toString();
            }
            catch (URISyntaxException uRISyntaxException) {
                // empty catch block
            }
        }
        return string;
    }

    @Override
    public void setStringValue(CSSValue.Type type, String string) throws DOMException {
        this.error();
    }

    private void error() throws DOMException {
        throw new DOMException(7, "This property is read-only computed value. Must modify at the original style sheet.");
    }

    @Override
    public URL getURLValue() {
        URL uRL = null;
        String string = super.getStringValue();
        if (string != null) {
            if (this.parentSheetHref != null) {
                try {
                    URL uRL2 = new URL(this.parentSheetHref);
                    uRL = new URL(uRL2, string);
                    return uRL;
                }
                catch (MalformedURLException malformedURLException) {
                    // empty catch block
                }
            }
            try {
                uRL = new URL(string);
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        return uRL;
    }

    @Override
    public URIValue clone() {
        return new URIValueWrapper(super.clone(), this.parentSheetHref, this.parentSheetHref);
    }
}

