﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/network-firewall/NetworkFirewall_EXPORTS.h>

#include <utility>

namespace Aws {
namespace Utils {
namespace Json {
class JsonValue;
class JsonView;
}  // namespace Json
}  // namespace Utils
namespace NetworkFirewall {
namespace Model {

/**
 * <p>High-level information about a VPC endpoint association, returned by
 * <code>ListVpcEndpointAssociations</code>. You can use the information provided
 * in the metadata to retrieve and manage a VPC endpoint association.</p><p><h3>See
 * Also:</h3>   <a
 * href="http://docs.aws.amazon.com/goto/WebAPI/network-firewall-2020-11-12/VpcEndpointAssociationMetadata">AWS
 * API Reference</a></p>
 */
class VpcEndpointAssociationMetadata {
 public:
  AWS_NETWORKFIREWALL_API VpcEndpointAssociationMetadata() = default;
  AWS_NETWORKFIREWALL_API VpcEndpointAssociationMetadata(Aws::Utils::Json::JsonView jsonValue);
  AWS_NETWORKFIREWALL_API VpcEndpointAssociationMetadata& operator=(Aws::Utils::Json::JsonView jsonValue);
  AWS_NETWORKFIREWALL_API Aws::Utils::Json::JsonValue Jsonize() const;

  ///@{
  /**
   * <p>The Amazon Resource Name (ARN) of a VPC endpoint association.</p>
   */
  inline const Aws::String& GetVpcEndpointAssociationArn() const { return m_vpcEndpointAssociationArn; }
  inline bool VpcEndpointAssociationArnHasBeenSet() const { return m_vpcEndpointAssociationArnHasBeenSet; }
  template <typename VpcEndpointAssociationArnT = Aws::String>
  void SetVpcEndpointAssociationArn(VpcEndpointAssociationArnT&& value) {
    m_vpcEndpointAssociationArnHasBeenSet = true;
    m_vpcEndpointAssociationArn = std::forward<VpcEndpointAssociationArnT>(value);
  }
  template <typename VpcEndpointAssociationArnT = Aws::String>
  VpcEndpointAssociationMetadata& WithVpcEndpointAssociationArn(VpcEndpointAssociationArnT&& value) {
    SetVpcEndpointAssociationArn(std::forward<VpcEndpointAssociationArnT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_vpcEndpointAssociationArn;
  bool m_vpcEndpointAssociationArnHasBeenSet = false;
};

}  // namespace Model
}  // namespace NetworkFirewall
}  // namespace Aws
