/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSImageBitmapRenderingContext.h"

#include "ActiveDOMObject.h"
#include "ContextDestructionObserverInlines.h"
#include "ExtendedDOMClientIsoSubspaces.h"
#include "ExtendedDOMIsoSubspaces.h"
#include "IDLTypes.h"
#include "InspectorCanvasCallTracer.h"
#include "JSDOMAttribute.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructorNotConstructable.h"
#include "JSDOMConvertBase.h"
#include "JSDOMConvertInterface.h"
#include "JSDOMConvertNullable.h"
#include "JSDOMConvertUnion.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMGlobalObject.h"
#include "JSDOMGlobalObjectInlines.h"
#include "JSDOMOperation.h"
#include "JSDOMWrapperCache.h"
#include "JSHTMLCanvasElement.h"
#include "JSImageBitmap.h"
#include "JSOffscreenCanvas.h"
#include "ScriptExecutionContext.h"
#include "WebCoreJSClientData.h"
#include <JavaScriptCore/FunctionPrototype.h>
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/JSDestructibleObjectHeapCellType.h>
#include <JavaScriptCore/SlotVisitorMacros.h>
#include <JavaScriptCore/SubspaceInlines.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>
#include <wtf/Variant.h>
#include <wtf/text/MakeString.h>

namespace WebCore {
using namespace JSC;

// Functions

static JSC_DECLARE_HOST_FUNCTION(jsImageBitmapRenderingContextPrototypeFunction_transferFromImageBitmap);

// Attributes

static JSC_DECLARE_CUSTOM_GETTER(jsImageBitmapRenderingContextConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsImageBitmapRenderingContext_canvas);

class JSImageBitmapRenderingContextPrototype final : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSImageBitmapRenderingContextPrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSImageBitmapRenderingContextPrototype* ptr = new (NotNull, JSC::allocateCell<JSImageBitmapRenderingContextPrototype>(vm)) JSImageBitmapRenderingContextPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    template<typename CellType, JSC::SubspaceAccess>
    static JSC::GCClient::IsoSubspace* subspaceFor(JSC::VM& vm)
    {
        STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSImageBitmapRenderingContextPrototype, Base);
        return &vm.plainObjectSpace();
    }
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSImageBitmapRenderingContextPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSImageBitmapRenderingContextPrototype, JSImageBitmapRenderingContextPrototype::Base);

using JSImageBitmapRenderingContextDOMConstructor = JSDOMConstructorNotConstructable<JSImageBitmapRenderingContext>;

template<> const ClassInfo JSImageBitmapRenderingContextDOMConstructor::s_info = { "ImageBitmapRenderingContext"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSImageBitmapRenderingContextDOMConstructor) };

template<> JSValue JSImageBitmapRenderingContextDOMConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    UNUSED_PARAM(vm);
    return globalObject.functionPrototype();
}

template<> void JSImageBitmapRenderingContextDOMConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->length, jsNumber(0), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    JSString* nameString = jsNontrivialString(vm, "ImageBitmapRenderingContext"_s);
    m_originalName.set(vm, this, nameString);
    putDirect(vm, vm.propertyNames->name, nameString, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->prototype, JSImageBitmapRenderingContext::prototype(vm, globalObject), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum | JSC::PropertyAttribute::DontDelete);
}

/* Hash table for prototype */

static const std::array<HashTableValue, 3> JSImageBitmapRenderingContextPrototypeTableValues {
    HashTableValue { "constructor"_s, static_cast<unsigned>(PropertyAttribute::DontEnum), NoIntrinsic, { HashTableValue::GetterSetterType, jsImageBitmapRenderingContextConstructor, 0 } },
    HashTableValue { "canvas"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsImageBitmapRenderingContext_canvas, 0 } },
    HashTableValue { "transferFromImageBitmap"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsImageBitmapRenderingContextPrototypeFunction_transferFromImageBitmap, 1 } },
};

const ClassInfo JSImageBitmapRenderingContextPrototype::s_info = { "ImageBitmapRenderingContext"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSImageBitmapRenderingContextPrototype) };

void JSImageBitmapRenderingContextPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSImageBitmapRenderingContext::info(), JSImageBitmapRenderingContextPrototypeTableValues, *this);
    JSC_TO_STRING_TAG_WITHOUT_TRANSITION();
}

const ClassInfo JSImageBitmapRenderingContext::s_info = { "ImageBitmapRenderingContext"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSImageBitmapRenderingContext) };

JSImageBitmapRenderingContext::JSImageBitmapRenderingContext(Structure* structure, JSDOMGlobalObject& globalObject, Ref<ImageBitmapRenderingContext>&& impl)
    : JSDOMWrapper<ImageBitmapRenderingContext>(structure, globalObject, WTFMove(impl))
{
}

static_assert(!std::is_base_of<ActiveDOMObject, ImageBitmapRenderingContext>::value, "Interface is not marked as [ActiveDOMObject] even though implementation class subclasses ActiveDOMObject.");

JSObject* JSImageBitmapRenderingContext::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    auto* structure = JSImageBitmapRenderingContextPrototype::createStructure(vm, &globalObject, globalObject.objectPrototype());
    structure->setMayBePrototype(true);
    return JSImageBitmapRenderingContextPrototype::create(vm, &globalObject, structure);
}

JSObject* JSImageBitmapRenderingContext::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSImageBitmapRenderingContext>(vm, globalObject);
}

JSValue JSImageBitmapRenderingContext::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSImageBitmapRenderingContextDOMConstructor, DOMConstructorID::ImageBitmapRenderingContext>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

void JSImageBitmapRenderingContext::destroy(JSC::JSCell* cell)
{
    JSImageBitmapRenderingContext* thisObject = static_cast<JSImageBitmapRenderingContext*>(cell);
    thisObject->JSImageBitmapRenderingContext::~JSImageBitmapRenderingContext();
}

JSC_DEFINE_CUSTOM_GETTER(jsImageBitmapRenderingContextConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName))
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSImageBitmapRenderingContextPrototype*>(JSValue::decode(thisValue));
    if (!prototype) [[unlikely]]
        return throwVMTypeError(lexicalGlobalObject, throwScope);
    return JSValue::encode(JSImageBitmapRenderingContext::getConstructor(vm, prototype->globalObject()));
}

static inline JSValue jsImageBitmapRenderingContext_canvasGetter(JSGlobalObject& lexicalGlobalObject, JSImageBitmapRenderingContext& thisObject)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLUnion<IDLInterface<HTMLCanvasElement>, IDLInterface<OffscreenCanvas>>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.canvas())));
}

JSC_DEFINE_CUSTOM_GETTER(jsImageBitmapRenderingContext_canvas, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSImageBitmapRenderingContext>::get<jsImageBitmapRenderingContext_canvasGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSC::EncodedJSValue jsImageBitmapRenderingContextPrototypeFunction_transferFromImageBitmapBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSImageBitmapRenderingContext>::ClassParameter castedThis)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = castedThis->wrapped();
    if (callFrame->argumentCount() < 1) [[unlikely]]
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto bitmapConversionResult = convert<IDLNullable<IDLInterface<ImageBitmap>>>(*lexicalGlobalObject, argument0.value(), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "bitmap"_s, "ImageBitmapRenderingContext"_s, "transferFromImageBitmap"_s, "ImageBitmap"_s); });
    if (bitmapConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    if (impl.hasActiveInspectorCanvasCallTracer()) [[unlikely]]
        InspectorCanvasCallTracer::recordAction(impl, "transferFromImageBitmap"_s, { InspectorCanvasCallTracer::processArgument(impl, bitmapConversionResult.returnValue()) });
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLUndefined>(*lexicalGlobalObject, throwScope, [&]() -> decltype(auto) { return impl.transferFromImageBitmap(bitmapConversionResult.releaseReturnValue()); })));
}

JSC_DEFINE_HOST_FUNCTION(jsImageBitmapRenderingContextPrototypeFunction_transferFromImageBitmap, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSImageBitmapRenderingContext>::call<jsImageBitmapRenderingContextPrototypeFunction_transferFromImageBitmapBody>(*lexicalGlobalObject, *callFrame, "transferFromImageBitmap");
}

JSC::GCClient::IsoSubspace* JSImageBitmapRenderingContext::subspaceForImpl(JSC::VM& vm)
{
    return WebCore::subspaceForImpl<JSImageBitmapRenderingContext, UseCustomHeapCellType::No>(vm, "JSImageBitmapRenderingContext"_s,
        [] (auto& spaces) { return spaces.m_clientSubspaceForImageBitmapRenderingContext.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_clientSubspaceForImageBitmapRenderingContext = std::forward<decltype(space)>(space); },
        [] (auto& spaces) { return spaces.m_subspaceForImageBitmapRenderingContext.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_subspaceForImageBitmapRenderingContext = std::forward<decltype(space)>(space); }
    );
}

void JSImageBitmapRenderingContext::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSImageBitmapRenderingContext*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (RefPtr context = thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, makeString("url "_s, context->url().string()));
    Base::analyzeHeap(cell, analyzer);
}

bool JSImageBitmapRenderingContextOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, AbstractSlotVisitor& visitor, ASCIILiteral* reason)
{
    UNUSED_PARAM(handle);
    UNUSED_PARAM(visitor);
    UNUSED_PARAM(reason);
    return false;
}

void JSImageBitmapRenderingContextOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    auto* jsImageBitmapRenderingContext = static_cast<JSImageBitmapRenderingContext*>(handle.slot()->asCell());
    auto& world = *static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, jsImageBitmapRenderingContext->protectedWrapped().ptr(), jsImageBitmapRenderingContext);
}

WTF_ALLOW_UNSAFE_BUFFER_USAGE_BEGIN
#if ENABLE(BINDING_INTEGRITY)
#if PLATFORM(WIN)
#pragma warning(disable: 4483)
extern "C" { extern void (*const __identifier("??_7ImageBitmapRenderingContext@WebCore@@6B@")[])(); }
#else
extern "C" { extern void* _ZTVN7WebCore27ImageBitmapRenderingContextE[]; }
#endif
template<std::same_as<ImageBitmapRenderingContext> T>
static inline void verifyVTable(ImageBitmapRenderingContext* ptr) 
{
    if constexpr (std::is_polymorphic_v<T>) {
        const void* actualVTablePointer = getVTablePointer<T>(ptr);
#if PLATFORM(WIN)
        void* expectedVTablePointer = __identifier("??_7ImageBitmapRenderingContext@WebCore@@6B@");
#else
        void* expectedVTablePointer = &_ZTVN7WebCore27ImageBitmapRenderingContextE[2];
#endif

        // If you hit this assertion you either have a use after free bug, or
        // ImageBitmapRenderingContext has subclasses. If ImageBitmapRenderingContext has subclasses that get passed
        // to toJS() we currently require ImageBitmapRenderingContext you to opt out of binding hardening
        // by adding the SkipVTableValidation attribute to the interface IDL definition
        RELEASE_ASSERT(actualVTablePointer == expectedVTablePointer);
    }
}
#endif
WTF_ALLOW_UNSAFE_BUFFER_USAGE_END

JSC::JSValue toJSNewlyCreated(JSC::JSGlobalObject*, JSDOMGlobalObject* globalObject, Ref<ImageBitmapRenderingContext>&& impl)
{
#if ENABLE(BINDING_INTEGRITY)
    verifyVTable<ImageBitmapRenderingContext>(impl.ptr());
#endif
    return createWrapper<ImageBitmapRenderingContext>(globalObject, WTFMove(impl));
}

JSC::JSValue toJS(JSC::JSGlobalObject* lexicalGlobalObject, JSDOMGlobalObject* globalObject, ImageBitmapRenderingContext& impl)
{
    return wrap(lexicalGlobalObject, globalObject, impl);
}

ImageBitmapRenderingContext* JSImageBitmapRenderingContext::toWrapped(JSC::VM&, JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSImageBitmapRenderingContext*>(value))
        return &wrapper->wrapped();
    return nullptr;
}

}
