/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSRouterRule.h"

#include "JSDOMConvertEnumeration.h"
#include "JSDOMConvertUnion.h"
#include "JSRouterCondition.h"
#include "JSRouterSourceDict.h"
#include "JSRouterSourceEnum.h"
#include <JavaScriptCore/JSCInlines.h>
#include <wtf/Variant.h>



namespace WebCore {
using namespace JSC;

template<> ConversionResult<IDLDictionary<RouterRule>> convertDictionary<RouterRule>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    bool isNullOrUndefined = value.isUndefinedOrNull();
    auto* object = isNullOrUndefined ? nullptr : value.getObject();
    if (!isNullOrUndefined && !object) [[unlikely]] {
        throwTypeError(&lexicalGlobalObject, throwScope);
        return ConversionResultException { };
    }
    RouterRule result;
    JSValue conditionValue;
    if (isNullOrUndefined)
        conditionValue = jsUndefined();
    else {
        conditionValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "condition"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    if (conditionValue.isUndefined()) {
        throwRequiredMemberTypeError(lexicalGlobalObject, throwScope, "condition"_s, "RouterRule"_s, "RouterCondition"_s);
        return ConversionResultException { };
    }
    auto conditionConversionResult = convert<IDLDictionary<RouterCondition>>(lexicalGlobalObject, conditionValue);
    if (conditionConversionResult.hasException(throwScope)) [[unlikely]]
        return ConversionResultException { };
    result.condition = conditionConversionResult.releaseReturnValue();
    JSValue sourceValue;
    if (isNullOrUndefined)
        sourceValue = jsUndefined();
    else {
        sourceValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "source"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    if (sourceValue.isUndefined()) {
        throwRequiredMemberTypeError(lexicalGlobalObject, throwScope, "source"_s, "RouterRule"_s, "(RouterSourceDict or RouterSourceEnum)"_s);
        return ConversionResultException { };
    }
    auto sourceConversionResult = convert<IDLUnion<IDLDictionary<RouterSourceDict>, IDLEnumeration<RouterSourceEnum>>>(lexicalGlobalObject, sourceValue);
    if (sourceConversionResult.hasException(throwScope)) [[unlikely]]
        return ConversionResultException { };
    result.source = sourceConversionResult.releaseReturnValue();
    return result;
}

} // namespace WebCore

