// java wrapper for vtkTreeAreaView object
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkABI.h"
#include "vtkSystemIncludes.h"
#include "vtkTreeAreaView.h"
#include "vtkJavaUtil.h"

#include "vtkStdString.h"

#include <sstream>
extern "C" JNIEXPORT void* vtkRenderView_Typecast(void* op,char* dType);

extern "C" JNIEXPORT void* vtkTreeAreaView_Typecast(void* me,char* dType)
{
  void* res;
  if (!strcmp("vtkTreeAreaView",dType)) { return me; }
  if ((res= vtkRenderView_Typecast(me,dType)) != nullptr) { return res; }
  return nullptr;
}


extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkTreeAreaView_IsTypeOf_10(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkTreeAreaView* op = static_cast<vtkTreeAreaView*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsTypeOf(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkTreeAreaView_IsA_11(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkTreeAreaView* op = static_cast<vtkTreeAreaView*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsA(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkTreeAreaView_GetNumberOfGenerationsFromBaseType_12(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkTreeAreaView* op = static_cast<vtkTreeAreaView*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBaseType(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkTreeAreaView_GetNumberOfGenerationsFromBase_13(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkTreeAreaView* op = static_cast<vtkTreeAreaView*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBase(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkTreeAreaView_SetTreeFromInputConnection_14(JNIEnv* env, jobject obj,jobject id0)
{
  vtkAlgorithmOutput * temp0;
  vtkDataRepresentation * temp20;
  temp0 = static_cast<vtkAlgorithmOutput*>(vtkJavaGetPointerFromObject(env, id0));

  vtkTreeAreaView* op = static_cast<vtkTreeAreaView*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->SetTreeFromInputConnection(temp0);
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkTreeAreaView_SetTreeFromInput_15(JNIEnv* env, jobject obj,jobject id0)
{
  vtkTree * temp0;
  vtkDataRepresentation * temp20;
  temp0 = static_cast<vtkTree*>(vtkJavaGetPointerFromObject(env, id0));

  vtkTreeAreaView* op = static_cast<vtkTreeAreaView*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->SetTreeFromInput(temp0);
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkTreeAreaView_SetGraphFromInputConnection_16(JNIEnv* env, jobject obj,jobject id0)
{
  vtkAlgorithmOutput * temp0;
  vtkDataRepresentation * temp20;
  temp0 = static_cast<vtkAlgorithmOutput*>(vtkJavaGetPointerFromObject(env, id0));

  vtkTreeAreaView* op = static_cast<vtkTreeAreaView*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->SetGraphFromInputConnection(temp0);
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkTreeAreaView_SetGraphFromInput_17(JNIEnv* env, jobject obj,jobject id0)
{
  vtkGraph * temp0;
  vtkDataRepresentation * temp20;
  temp0 = static_cast<vtkGraph*>(vtkJavaGetPointerFromObject(env, id0));

  vtkTreeAreaView* op = static_cast<vtkTreeAreaView*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->SetGraphFromInput(temp0);
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkTreeAreaView_SetAreaLabelArrayName_18(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkTreeAreaView* op = static_cast<vtkTreeAreaView*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetAreaLabelArrayName(temp0);
  delete[] temp0;

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkTreeAreaView_GetAreaLabelArrayName_19(JNIEnv* env, jobject obj)
{
  const char * temp20;

  vtkTreeAreaView* op = static_cast<vtkTreeAreaView*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetAreaLabelArrayName();
  return (temp20 == nullptr) ? env->NewByteArray(0) : vtkJavaCharsToUTF8(env, temp20, strlen(temp20));

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkTreeAreaView_SetAreaSizeArrayName_110(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkTreeAreaView* op = static_cast<vtkTreeAreaView*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetAreaSizeArrayName(temp0);
  delete[] temp0;

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkTreeAreaView_GetAreaSizeArrayName_111(JNIEnv* env, jobject obj)
{
  const char * temp20;

  vtkTreeAreaView* op = static_cast<vtkTreeAreaView*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetAreaSizeArrayName();
  return (temp20 == nullptr) ? env->NewByteArray(0) : vtkJavaCharsToUTF8(env, temp20, strlen(temp20));

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkTreeAreaView_SetLabelPriorityArrayName_112(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkTreeAreaView* op = static_cast<vtkTreeAreaView*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetLabelPriorityArrayName(temp0);
  delete[] temp0;

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkTreeAreaView_GetLabelPriorityArrayName_113(JNIEnv* env, jobject obj)
{
  const char * temp20;

  vtkTreeAreaView* op = static_cast<vtkTreeAreaView*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetLabelPriorityArrayName();
  return (temp20 == nullptr) ? env->NewByteArray(0) : vtkJavaCharsToUTF8(env, temp20, strlen(temp20));

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkTreeAreaView_SetEdgeLabelArrayName_114(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkTreeAreaView* op = static_cast<vtkTreeAreaView*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetEdgeLabelArrayName(temp0);
  delete[] temp0;

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkTreeAreaView_GetEdgeLabelArrayName_115(JNIEnv* env, jobject obj)
{
  const char * temp20;

  vtkTreeAreaView* op = static_cast<vtkTreeAreaView*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetEdgeLabelArrayName();
  return (temp20 == nullptr) ? env->NewByteArray(0) : vtkJavaCharsToUTF8(env, temp20, strlen(temp20));

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkTreeAreaView_SetAreaHoverArrayName_116(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkTreeAreaView* op = static_cast<vtkTreeAreaView*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetAreaHoverArrayName(temp0);
  delete[] temp0;

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkTreeAreaView_GetAreaHoverArrayName_117(JNIEnv* env, jobject obj)
{
  const char * temp20;

  vtkTreeAreaView* op = static_cast<vtkTreeAreaView*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetAreaHoverArrayName();
  return (temp20 == nullptr) ? env->NewByteArray(0) : vtkJavaCharsToUTF8(env, temp20, strlen(temp20));

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkTreeAreaView_SetAreaLabelVisibility_118(JNIEnv* env, jobject obj,jboolean id0)
{
  bool   temp0;
  temp0 = (id0 != 0) ? true : false;

  vtkTreeAreaView* op = static_cast<vtkTreeAreaView*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetAreaLabelVisibility(temp0);

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkTreeAreaView_GetAreaLabelVisibility_119(JNIEnv* env, jobject obj)
{
  bool   temp20;

  vtkTreeAreaView* op = static_cast<vtkTreeAreaView*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetAreaLabelVisibility();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkTreeAreaView_AreaLabelVisibilityOn_120(JNIEnv* env, jobject obj)
{

  vtkTreeAreaView* op = static_cast<vtkTreeAreaView*>(vtkJavaGetPointerFromObject(env, obj));
  op->AreaLabelVisibilityOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkTreeAreaView_AreaLabelVisibilityOff_121(JNIEnv* env, jobject obj)
{

  vtkTreeAreaView* op = static_cast<vtkTreeAreaView*>(vtkJavaGetPointerFromObject(env, obj));
  op->AreaLabelVisibilityOff();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkTreeAreaView_SetEdgeLabelVisibility_122(JNIEnv* env, jobject obj,jboolean id0)
{
  bool   temp0;
  temp0 = (id0 != 0) ? true : false;

  vtkTreeAreaView* op = static_cast<vtkTreeAreaView*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetEdgeLabelVisibility(temp0);

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkTreeAreaView_GetEdgeLabelVisibility_123(JNIEnv* env, jobject obj)
{
  bool   temp20;

  vtkTreeAreaView* op = static_cast<vtkTreeAreaView*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetEdgeLabelVisibility();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkTreeAreaView_EdgeLabelVisibilityOn_124(JNIEnv* env, jobject obj)
{

  vtkTreeAreaView* op = static_cast<vtkTreeAreaView*>(vtkJavaGetPointerFromObject(env, obj));
  op->EdgeLabelVisibilityOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkTreeAreaView_EdgeLabelVisibilityOff_125(JNIEnv* env, jobject obj)
{

  vtkTreeAreaView* op = static_cast<vtkTreeAreaView*>(vtkJavaGetPointerFromObject(env, obj));
  op->EdgeLabelVisibilityOff();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkTreeAreaView_SetAreaColorArrayName_126(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkTreeAreaView* op = static_cast<vtkTreeAreaView*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetAreaColorArrayName(temp0);
  delete[] temp0;

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkTreeAreaView_GetAreaColorArrayName_127(JNIEnv* env, jobject obj)
{
  const char * temp20;

  vtkTreeAreaView* op = static_cast<vtkTreeAreaView*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetAreaColorArrayName();
  return (temp20 == nullptr) ? env->NewByteArray(0) : vtkJavaCharsToUTF8(env, temp20, strlen(temp20));

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkTreeAreaView_SetColorAreas_128(JNIEnv* env, jobject obj,jboolean id0)
{
  bool   temp0;
  temp0 = (id0 != 0) ? true : false;

  vtkTreeAreaView* op = static_cast<vtkTreeAreaView*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetColorAreas(temp0);

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkTreeAreaView_GetColorAreas_129(JNIEnv* env, jobject obj)
{
  bool   temp20;

  vtkTreeAreaView* op = static_cast<vtkTreeAreaView*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetColorAreas();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkTreeAreaView_ColorAreasOn_130(JNIEnv* env, jobject obj)
{

  vtkTreeAreaView* op = static_cast<vtkTreeAreaView*>(vtkJavaGetPointerFromObject(env, obj));
  op->ColorAreasOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkTreeAreaView_ColorAreasOff_131(JNIEnv* env, jobject obj)
{

  vtkTreeAreaView* op = static_cast<vtkTreeAreaView*>(vtkJavaGetPointerFromObject(env, obj));
  op->ColorAreasOff();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkTreeAreaView_SetEdgeColorArrayName_132(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkTreeAreaView* op = static_cast<vtkTreeAreaView*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetEdgeColorArrayName(temp0);
  delete[] temp0;

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkTreeAreaView_GetEdgeColorArrayName_133(JNIEnv* env, jobject obj)
{
  const char * temp20;

  vtkTreeAreaView* op = static_cast<vtkTreeAreaView*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetEdgeColorArrayName();
  return (temp20 == nullptr) ? env->NewByteArray(0) : vtkJavaCharsToUTF8(env, temp20, strlen(temp20));

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkTreeAreaView_SetEdgeColorToSplineFraction_134(JNIEnv* env, jobject obj)
{

  vtkTreeAreaView* op = static_cast<vtkTreeAreaView*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetEdgeColorToSplineFraction();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkTreeAreaView_SetShrinkPercentage_135(JNIEnv* env, jobject obj,jdouble id0)
{
  double   temp0;
  temp0 = id0;

  vtkTreeAreaView* op = static_cast<vtkTreeAreaView*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetShrinkPercentage(temp0);

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkTreeAreaView_GetShrinkPercentage_136(JNIEnv* env, jobject obj)
{
  double   temp20;

  vtkTreeAreaView* op = static_cast<vtkTreeAreaView*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetShrinkPercentage();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkTreeAreaView_SetColorEdges_137(JNIEnv* env, jobject obj,jboolean id0)
{
  bool   temp0;
  temp0 = (id0 != 0) ? true : false;

  vtkTreeAreaView* op = static_cast<vtkTreeAreaView*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetColorEdges(temp0);

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkTreeAreaView_GetColorEdges_138(JNIEnv* env, jobject obj)
{
  bool   temp20;

  vtkTreeAreaView* op = static_cast<vtkTreeAreaView*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetColorEdges();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkTreeAreaView_ColorEdgesOn_139(JNIEnv* env, jobject obj)
{

  vtkTreeAreaView* op = static_cast<vtkTreeAreaView*>(vtkJavaGetPointerFromObject(env, obj));
  op->ColorEdgesOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkTreeAreaView_ColorEdgesOff_140(JNIEnv* env, jobject obj)
{

  vtkTreeAreaView* op = static_cast<vtkTreeAreaView*>(vtkJavaGetPointerFromObject(env, obj));
  op->ColorEdgesOff();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkTreeAreaView_SetBundlingStrength_141(JNIEnv* env, jobject obj,jdouble id0)
{
  double   temp0;
  temp0 = id0;

  vtkTreeAreaView* op = static_cast<vtkTreeAreaView*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetBundlingStrength(temp0);

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkTreeAreaView_GetBundlingStrength_142(JNIEnv* env, jobject obj)
{
  double   temp20;

  vtkTreeAreaView* op = static_cast<vtkTreeAreaView*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetBundlingStrength();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkTreeAreaView_SetAreaLabelFontSize_143(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkTreeAreaView* op = static_cast<vtkTreeAreaView*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetAreaLabelFontSize(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkTreeAreaView_GetAreaLabelFontSize_144(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkTreeAreaView* op = static_cast<vtkTreeAreaView*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetAreaLabelFontSize();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkTreeAreaView_SetEdgeLabelFontSize_145(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkTreeAreaView* op = static_cast<vtkTreeAreaView*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetEdgeLabelFontSize(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkTreeAreaView_GetEdgeLabelFontSize_146(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkTreeAreaView* op = static_cast<vtkTreeAreaView*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetEdgeLabelFontSize();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkTreeAreaView_SetLayoutStrategy_147(JNIEnv* env, jobject obj,jobject id0)
{
  vtkAreaLayoutStrategy * temp0;
  temp0 = static_cast<vtkAreaLayoutStrategy*>(vtkJavaGetPointerFromObject(env, id0));

  vtkTreeAreaView* op = static_cast<vtkTreeAreaView*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetLayoutStrategy(temp0);

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkTreeAreaView_GetLayoutStrategy_148(JNIEnv* env, jobject obj)
{
  vtkAreaLayoutStrategy * temp20;

  vtkTreeAreaView* op = static_cast<vtkTreeAreaView*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetLayoutStrategy();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkTreeAreaView_SetUseRectangularCoordinates_149(JNIEnv* env, jobject obj,jboolean id0)
{
  bool   temp0;
  temp0 = (id0 != 0) ? true : false;

  vtkTreeAreaView* op = static_cast<vtkTreeAreaView*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetUseRectangularCoordinates(temp0);

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkTreeAreaView_GetUseRectangularCoordinates_150(JNIEnv* env, jobject obj)
{
  bool   temp20;

  vtkTreeAreaView* op = static_cast<vtkTreeAreaView*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetUseRectangularCoordinates();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkTreeAreaView_UseRectangularCoordinatesOn_151(JNIEnv* env, jobject obj)
{

  vtkTreeAreaView* op = static_cast<vtkTreeAreaView*>(vtkJavaGetPointerFromObject(env, obj));
  op->UseRectangularCoordinatesOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkTreeAreaView_UseRectangularCoordinatesOff_152(JNIEnv* env, jobject obj)
{

  vtkTreeAreaView* op = static_cast<vtkTreeAreaView*>(vtkJavaGetPointerFromObject(env, obj));
  op->UseRectangularCoordinatesOff();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkTreeAreaView_SetEdgeScalarBarVisibility_153(JNIEnv* env, jobject obj,jboolean id0)
{
  bool   temp0;
  temp0 = (id0 != 0) ? true : false;

  vtkTreeAreaView* op = static_cast<vtkTreeAreaView*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetEdgeScalarBarVisibility(temp0);

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkTreeAreaView_GetEdgeScalarBarVisibility_154(JNIEnv* env, jobject obj)
{
  bool   temp20;

  vtkTreeAreaView* op = static_cast<vtkTreeAreaView*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetEdgeScalarBarVisibility();
  return temp20;

}

extern "C" JNIEXPORT jlong JNICALL Java_vtk_vtkTreeAreaView_VTKInit(JNIEnv*, jobject)
{
  return reinterpret_cast<jlong>(vtkTreeAreaView::New());
}
