// java wrapper for vtkVRRenderWindow object
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkABI.h"
#include "vtkSystemIncludes.h"
#include "vtkVRRenderWindow.h"
#include "vtkJavaUtil.h"

#include "vtkStdString.h"

#include <sstream>
extern "C" JNIEXPORT void* vtkOpenGLRenderWindow_Typecast(void* op,char* dType);

extern "C" JNIEXPORT void* vtkVRRenderWindow_Typecast(void* me,char* dType)
{
  void* res;
  if (!strcmp("vtkVRRenderWindow",dType)) { return me; }
  if ((res= vtkOpenGLRenderWindow_Typecast(me,dType)) != nullptr) { return res; }
  return nullptr;
}


extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkVRRenderWindow_IsTypeOf_10(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkVRRenderWindow* op = static_cast<vtkVRRenderWindow*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsTypeOf(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkVRRenderWindow_IsA_11(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkVRRenderWindow* op = static_cast<vtkVRRenderWindow*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsA(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkVRRenderWindow_GetNumberOfGenerationsFromBaseType_12(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkVRRenderWindow* op = static_cast<vtkVRRenderWindow*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBaseType(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkVRRenderWindow_GetNumberOfGenerationsFromBase_13(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkVRRenderWindow* op = static_cast<vtkVRRenderWindow*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBase(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkVRRenderWindow_MakeRenderWindowInteractor_14(JNIEnv* env, jobject obj)
{
  vtkRenderWindowInteractor * temp20;

  vtkVRRenderWindow* op = static_cast<vtkVRRenderWindow*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->MakeRenderWindowInteractor();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkVRRenderWindow_InitializeViewFromCamera_15(JNIEnv* env, jobject obj,jobject id0)
{
  vtkCamera * temp0;
  temp0 = static_cast<vtkCamera*>(vtkJavaGetPointerFromObject(env, id0));

  vtkVRRenderWindow* op = static_cast<vtkVRRenderWindow*>(vtkJavaGetPointerFromObject(env, obj));
  op->InitializeViewFromCamera(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkVRRenderWindow_AddRenderer_16(JNIEnv* env, jobject obj,jobject id0)
{
  vtkRenderer * temp0;
  temp0 = static_cast<vtkRenderer*>(vtkJavaGetPointerFromObject(env, id0));

  vtkVRRenderWindow* op = static_cast<vtkVRRenderWindow*>(vtkJavaGetPointerFromObject(env, obj));
  op->AddRenderer(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkVRRenderWindow_MakeCurrent_17(JNIEnv* env, jobject obj)
{

  vtkVRRenderWindow* op = static_cast<vtkVRRenderWindow*>(vtkJavaGetPointerFromObject(env, obj));
  op->MakeCurrent();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkVRRenderWindow_ReleaseCurrent_18(JNIEnv* env, jobject obj)
{

  vtkVRRenderWindow* op = static_cast<vtkVRRenderWindow*>(vtkJavaGetPointerFromObject(env, obj));
  op->ReleaseCurrent();

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkVRRenderWindow_IsCurrent_19(JNIEnv* env, jobject obj)
{
  bool   temp20;

  vtkVRRenderWindow* op = static_cast<vtkVRRenderWindow*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsCurrent();
  return temp20;

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkVRRenderWindow_ReportCapabilities_110(JNIEnv* env, jobject obj)
{
  const char * temp20;

  vtkVRRenderWindow* op = static_cast<vtkVRRenderWindow*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->ReportCapabilities();
  return (temp20 == nullptr) ? env->NewByteArray(0) : vtkJavaCharsToUTF8(env, temp20, strlen(temp20));

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkVRRenderWindow_IsDirect_111(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkVRRenderWindow* op = static_cast<vtkVRRenderWindow*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsDirect();
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkVRRenderWindow_GetEventPending_112(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkVRRenderWindow* op = static_cast<vtkVRRenderWindow*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetEventPending();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkVRRenderWindow_SetSize_113(JNIEnv* env, jobject obj,jint id0,jint id1)
{
  int   temp0;
  int   temp1;
  temp0 = id0;
  temp1 = id1;

  vtkVRRenderWindow* op = static_cast<vtkVRRenderWindow*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetSize(temp0,temp1);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkVRRenderWindow_SetSize_114(JNIEnv* env, jobject obj,jintArray id0)
{
  int temp0[2];
  env->GetIntArrayRegion(id0, 0, 2, reinterpret_cast<jint*>(&temp0[0]));

  vtkVRRenderWindow* op = static_cast<vtkVRRenderWindow*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetSize(temp0);
  env->SetIntArrayRegion(id0, 0, 2, reinterpret_cast<jint*>(&temp0[0]));

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkVRRenderWindow_SupportsOpenGL_115(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkVRRenderWindow* op = static_cast<vtkVRRenderWindow*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->SupportsOpenGL();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkVRRenderWindow_Render_116(JNIEnv* env, jobject obj)
{

  vtkVRRenderWindow* op = static_cast<vtkVRRenderWindow*>(vtkJavaGetPointerFromObject(env, obj));
  op->Render();

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkVRRenderWindow_GetHelperWindow_117(JNIEnv* env, jobject obj)
{
  vtkOpenGLRenderWindow * temp20;

  vtkVRRenderWindow* op = static_cast<vtkVRRenderWindow*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetHelperWindow();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkVRRenderWindow_SetHelperWindow_118(JNIEnv* env, jobject obj,jobject id0)
{
  vtkOpenGLRenderWindow * temp0;
  temp0 = static_cast<vtkOpenGLRenderWindow*>(vtkJavaGetPointerFromObject(env, id0));

  vtkVRRenderWindow* op = static_cast<vtkVRRenderWindow*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetHelperWindow(temp0);

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkVRRenderWindow_GetState_119(JNIEnv* env, jobject obj)
{
  vtkOpenGLState * temp20;

  vtkVRRenderWindow* op = static_cast<vtkVRRenderWindow*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetState();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkVRRenderWindow_ReleaseGraphicsResources_120(JNIEnv* env, jobject obj,jobject id0)
{
  vtkWindow * temp0;
  temp0 = static_cast<vtkWindow*>(vtkJavaGetPointerFromObject(env, id0));

  vtkVRRenderWindow* op = static_cast<vtkVRRenderWindow*>(vtkJavaGetPointerFromObject(env, obj));
  op->ReleaseGraphicsResources(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkVRRenderWindow_RenderModels_121(JNIEnv* env, jobject obj)
{

  vtkVRRenderWindow* op = static_cast<vtkVRRenderWindow*>(vtkJavaGetPointerFromObject(env, obj));
  op->RenderModels();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkVRRenderWindow_SetTrackHMD_122(JNIEnv* env, jobject obj,jboolean id0)
{
  bool   temp0;
  temp0 = (id0 != 0) ? true : false;

  vtkVRRenderWindow* op = static_cast<vtkVRRenderWindow*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetTrackHMD(temp0);

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkVRRenderWindow_GetTrackHMD_123(JNIEnv* env, jobject obj)
{
  bool   temp20;

  vtkVRRenderWindow* op = static_cast<vtkVRRenderWindow*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetTrackHMD();
  return temp20;

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkVRRenderWindow_GetBaseStationVisibility_124(JNIEnv* env, jobject obj)
{
  bool   temp20;

  vtkVRRenderWindow* op = static_cast<vtkVRRenderWindow*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetBaseStationVisibility();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkVRRenderWindow_SetBaseStationVisibility_125(JNIEnv* env, jobject obj,jboolean id0)
{
  bool   temp0;
  temp0 = (id0 != 0) ? true : false;

  vtkVRRenderWindow* op = static_cast<vtkVRRenderWindow*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetBaseStationVisibility(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkVRRenderWindow_BaseStationVisibilityOn_126(JNIEnv* env, jobject obj)
{

  vtkVRRenderWindow* op = static_cast<vtkVRRenderWindow*>(vtkJavaGetPointerFromObject(env, obj));
  op->BaseStationVisibilityOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkVRRenderWindow_BaseStationVisibilityOff_127(JNIEnv* env, jobject obj)
{

  vtkVRRenderWindow* op = static_cast<vtkVRRenderWindow*>(vtkJavaGetPointerFromObject(env, obj));
  op->BaseStationVisibilityOff();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkVRRenderWindow_UpdateHMDMatrixPose_128(JNIEnv* env, jobject obj)
{

  vtkVRRenderWindow* op = static_cast<vtkVRRenderWindow*>(vtkJavaGetPointerFromObject(env, obj));
  op->UpdateHMDMatrixPose();

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkVRRenderWindow_GetVRInitialized_129(JNIEnv* env, jobject obj)
{
  bool   temp20;

  vtkVRRenderWindow* op = static_cast<vtkVRRenderWindow*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetVRInitialized();
  return temp20;

}
