// java wrapper for vtkParallelRenderManager object
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkABI.h"
#include "vtkSystemIncludes.h"
#include "vtkParallelRenderManager.h"
#include "vtkJavaUtil.h"

#include "vtkStdString.h"

#include <sstream>
extern "C" JNIEXPORT void* vtkObject_Typecast(void* op,char* dType);

extern "C" JNIEXPORT void* vtkParallelRenderManager_Typecast(void* me,char* dType)
{
  void* res;
  if (!strcmp("vtkParallelRenderManager",dType)) { return me; }
  if ((res= vtkObject_Typecast(me,dType)) != nullptr) { return res; }
  return nullptr;
}


extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkParallelRenderManager_IsTypeOf_10(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkParallelRenderManager* op = static_cast<vtkParallelRenderManager*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsTypeOf(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkParallelRenderManager_IsA_11(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkParallelRenderManager* op = static_cast<vtkParallelRenderManager*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsA(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkParallelRenderManager_GetNumberOfGenerationsFromBaseType_12(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkParallelRenderManager* op = static_cast<vtkParallelRenderManager*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBaseType(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkParallelRenderManager_GetNumberOfGenerationsFromBase_13(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkParallelRenderManager* op = static_cast<vtkParallelRenderManager*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBase(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkParallelRenderManager_MakeRenderWindow_14(JNIEnv* env, jobject obj)
{
  vtkRenderWindow * temp20;

  vtkParallelRenderManager* op = static_cast<vtkParallelRenderManager*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->MakeRenderWindow();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkParallelRenderManager_MakeRenderer_15(JNIEnv* env, jobject obj)
{
  vtkRenderer * temp20;

  vtkParallelRenderManager* op = static_cast<vtkParallelRenderManager*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->MakeRenderer();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkParallelRenderManager_GetRenderWindow_16(JNIEnv* env, jobject obj)
{
  vtkRenderWindow * temp20;

  vtkParallelRenderManager* op = static_cast<vtkParallelRenderManager*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetRenderWindow();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkParallelRenderManager_SetRenderWindow_17(JNIEnv* env, jobject obj,jobject id0)
{
  vtkRenderWindow * temp0;
  temp0 = static_cast<vtkRenderWindow*>(vtkJavaGetPointerFromObject(env, id0));

  vtkParallelRenderManager* op = static_cast<vtkParallelRenderManager*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetRenderWindow(temp0);

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkParallelRenderManager_GetController_18(JNIEnv* env, jobject obj)
{
  vtkMultiProcessController * temp20;

  vtkParallelRenderManager* op = static_cast<vtkParallelRenderManager*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetController();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkParallelRenderManager_SetController_19(JNIEnv* env, jobject obj,jobject id0)
{
  vtkMultiProcessController * temp0;
  temp0 = static_cast<vtkMultiProcessController*>(vtkJavaGetPointerFromObject(env, id0));

  vtkParallelRenderManager* op = static_cast<vtkParallelRenderManager*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetController(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkParallelRenderManager_InitializePieces_110(JNIEnv* env, jobject obj)
{

  vtkParallelRenderManager* op = static_cast<vtkParallelRenderManager*>(vtkJavaGetPointerFromObject(env, obj));
  op->InitializePieces();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkParallelRenderManager_InitializeOffScreen_111(JNIEnv* env, jobject obj)
{

  vtkParallelRenderManager* op = static_cast<vtkParallelRenderManager*>(vtkJavaGetPointerFromObject(env, obj));
  op->InitializeOffScreen();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkParallelRenderManager_StartInteractor_112(JNIEnv* env, jobject obj)
{

  vtkParallelRenderManager* op = static_cast<vtkParallelRenderManager*>(vtkJavaGetPointerFromObject(env, obj));
  op->StartInteractor();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkParallelRenderManager_StartServices_113(JNIEnv* env, jobject obj)
{

  vtkParallelRenderManager* op = static_cast<vtkParallelRenderManager*>(vtkJavaGetPointerFromObject(env, obj));
  op->StartServices();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkParallelRenderManager_StopServices_114(JNIEnv* env, jobject obj)
{

  vtkParallelRenderManager* op = static_cast<vtkParallelRenderManager*>(vtkJavaGetPointerFromObject(env, obj));
  op->StopServices();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkParallelRenderManager_StartRender_115(JNIEnv* env, jobject obj)
{

  vtkParallelRenderManager* op = static_cast<vtkParallelRenderManager*>(vtkJavaGetPointerFromObject(env, obj));
  op->StartRender();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkParallelRenderManager_EndRender_116(JNIEnv* env, jobject obj)
{

  vtkParallelRenderManager* op = static_cast<vtkParallelRenderManager*>(vtkJavaGetPointerFromObject(env, obj));
  op->EndRender();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkParallelRenderManager_SatelliteStartRender_117(JNIEnv* env, jobject obj)
{

  vtkParallelRenderManager* op = static_cast<vtkParallelRenderManager*>(vtkJavaGetPointerFromObject(env, obj));
  op->SatelliteStartRender();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkParallelRenderManager_SatelliteEndRender_118(JNIEnv* env, jobject obj)
{

  vtkParallelRenderManager* op = static_cast<vtkParallelRenderManager*>(vtkJavaGetPointerFromObject(env, obj));
  op->SatelliteEndRender();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkParallelRenderManager_RenderRMI_119(JNIEnv* env, jobject obj)
{

  vtkParallelRenderManager* op = static_cast<vtkParallelRenderManager*>(vtkJavaGetPointerFromObject(env, obj));
  op->RenderRMI();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkParallelRenderManager_ResetCamera_120(JNIEnv* env, jobject obj,jobject id0)
{
  vtkRenderer * temp0;
  temp0 = static_cast<vtkRenderer*>(vtkJavaGetPointerFromObject(env, id0));

  vtkParallelRenderManager* op = static_cast<vtkParallelRenderManager*>(vtkJavaGetPointerFromObject(env, obj));
  op->ResetCamera(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkParallelRenderManager_ResetCameraClippingRange_121(JNIEnv* env, jobject obj,jobject id0)
{
  vtkRenderer * temp0;
  temp0 = static_cast<vtkRenderer*>(vtkJavaGetPointerFromObject(env, id0));

  vtkParallelRenderManager* op = static_cast<vtkParallelRenderManager*>(vtkJavaGetPointerFromObject(env, obj));
  op->ResetCameraClippingRange(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkParallelRenderManager_ComputeVisiblePropBoundsRMI_122(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkParallelRenderManager* op = static_cast<vtkParallelRenderManager*>(vtkJavaGetPointerFromObject(env, obj));
  op->ComputeVisiblePropBoundsRMI(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkParallelRenderManager_InitializeRMIs_123(JNIEnv* env, jobject obj)
{

  vtkParallelRenderManager* op = static_cast<vtkParallelRenderManager*>(vtkJavaGetPointerFromObject(env, obj));
  op->InitializeRMIs();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkParallelRenderManager_ResetAllCameras_124(JNIEnv* env, jobject obj)
{

  vtkParallelRenderManager* op = static_cast<vtkParallelRenderManager*>(vtkJavaGetPointerFromObject(env, obj));
  op->ResetAllCameras();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkParallelRenderManager_ComputeVisiblePropBounds_125(JNIEnv* env, jobject obj,jobject id0,jdoubleArray id1)
{
  vtkRenderer * temp0;
  double temp1[6];
  temp0 = static_cast<vtkRenderer*>(vtkJavaGetPointerFromObject(env, id0));
  env->GetDoubleArrayRegion(id1, 0, 6, &temp1[0]);

  vtkParallelRenderManager* op = static_cast<vtkParallelRenderManager*>(vtkJavaGetPointerFromObject(env, obj));
  op->ComputeVisiblePropBounds(temp0,temp1);
  env->SetDoubleArrayRegion(id1, 0, 6, &temp1[0]);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkParallelRenderManager_SetParallelRendering_126(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkParallelRenderManager* op = static_cast<vtkParallelRenderManager*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetParallelRendering(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkParallelRenderManager_GetParallelRendering_127(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkParallelRenderManager* op = static_cast<vtkParallelRenderManager*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetParallelRendering();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkParallelRenderManager_ParallelRenderingOn_128(JNIEnv* env, jobject obj)
{

  vtkParallelRenderManager* op = static_cast<vtkParallelRenderManager*>(vtkJavaGetPointerFromObject(env, obj));
  op->ParallelRenderingOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkParallelRenderManager_ParallelRenderingOff_129(JNIEnv* env, jobject obj)
{

  vtkParallelRenderManager* op = static_cast<vtkParallelRenderManager*>(vtkJavaGetPointerFromObject(env, obj));
  op->ParallelRenderingOff();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkParallelRenderManager_SetRenderEventPropagation_130(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkParallelRenderManager* op = static_cast<vtkParallelRenderManager*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetRenderEventPropagation(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkParallelRenderManager_GetRenderEventPropagation_131(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkParallelRenderManager* op = static_cast<vtkParallelRenderManager*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetRenderEventPropagation();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkParallelRenderManager_RenderEventPropagationOn_132(JNIEnv* env, jobject obj)
{

  vtkParallelRenderManager* op = static_cast<vtkParallelRenderManager*>(vtkJavaGetPointerFromObject(env, obj));
  op->RenderEventPropagationOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkParallelRenderManager_RenderEventPropagationOff_133(JNIEnv* env, jobject obj)
{

  vtkParallelRenderManager* op = static_cast<vtkParallelRenderManager*>(vtkJavaGetPointerFromObject(env, obj));
  op->RenderEventPropagationOff();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkParallelRenderManager_SetDefaultRenderEventPropagation_134(JNIEnv* env, jobject obj,jboolean id0)
{
  bool   temp0;
  temp0 = (id0 != 0) ? true : false;

  vtkParallelRenderManager* op = static_cast<vtkParallelRenderManager*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetDefaultRenderEventPropagation(temp0);

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkParallelRenderManager_GetDefaultRenderEventPropagation_135(JNIEnv* env, jobject obj)
{
  bool   temp20;

  vtkParallelRenderManager* op = static_cast<vtkParallelRenderManager*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetDefaultRenderEventPropagation();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkParallelRenderManager_SetUseCompositing_136(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkParallelRenderManager* op = static_cast<vtkParallelRenderManager*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetUseCompositing(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkParallelRenderManager_GetUseCompositing_137(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkParallelRenderManager* op = static_cast<vtkParallelRenderManager*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetUseCompositing();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkParallelRenderManager_UseCompositingOn_138(JNIEnv* env, jobject obj)
{

  vtkParallelRenderManager* op = static_cast<vtkParallelRenderManager*>(vtkJavaGetPointerFromObject(env, obj));
  op->UseCompositingOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkParallelRenderManager_UseCompositingOff_139(JNIEnv* env, jobject obj)
{

  vtkParallelRenderManager* op = static_cast<vtkParallelRenderManager*>(vtkJavaGetPointerFromObject(env, obj));
  op->UseCompositingOff();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkParallelRenderManager_SetImageReductionFactor_140(JNIEnv* env, jobject obj,jdouble id0)
{
  double   temp0;
  temp0 = id0;

  vtkParallelRenderManager* op = static_cast<vtkParallelRenderManager*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetImageReductionFactor(temp0);

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkParallelRenderManager_GetImageReductionFactor_141(JNIEnv* env, jobject obj)
{
  double   temp20;

  vtkParallelRenderManager* op = static_cast<vtkParallelRenderManager*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetImageReductionFactor();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkParallelRenderManager_SetMaxImageReductionFactor_142(JNIEnv* env, jobject obj,jdouble id0)
{
  double   temp0;
  temp0 = id0;

  vtkParallelRenderManager* op = static_cast<vtkParallelRenderManager*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetMaxImageReductionFactor(temp0);

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkParallelRenderManager_GetMaxImageReductionFactor_143(JNIEnv* env, jobject obj)
{
  double   temp20;

  vtkParallelRenderManager* op = static_cast<vtkParallelRenderManager*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetMaxImageReductionFactor();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkParallelRenderManager_SetImageReductionFactorForUpdateRate_144(JNIEnv* env, jobject obj,jdouble id0)
{
  double   temp0;
  temp0 = id0;

  vtkParallelRenderManager* op = static_cast<vtkParallelRenderManager*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetImageReductionFactorForUpdateRate(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkParallelRenderManager_SetAutoImageReductionFactor_145(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkParallelRenderManager* op = static_cast<vtkParallelRenderManager*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetAutoImageReductionFactor(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkParallelRenderManager_GetAutoImageReductionFactor_146(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkParallelRenderManager* op = static_cast<vtkParallelRenderManager*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetAutoImageReductionFactor();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkParallelRenderManager_AutoImageReductionFactorOn_147(JNIEnv* env, jobject obj)
{

  vtkParallelRenderManager* op = static_cast<vtkParallelRenderManager*>(vtkJavaGetPointerFromObject(env, obj));
  op->AutoImageReductionFactorOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkParallelRenderManager_AutoImageReductionFactorOff_148(JNIEnv* env, jobject obj)
{

  vtkParallelRenderManager* op = static_cast<vtkParallelRenderManager*>(vtkJavaGetPointerFromObject(env, obj));
  op->AutoImageReductionFactorOff();

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkParallelRenderManager_GetRenderTime_149(JNIEnv* env, jobject obj)
{
  double   temp20;

  vtkParallelRenderManager* op = static_cast<vtkParallelRenderManager*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetRenderTime();
  return temp20;

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkParallelRenderManager_GetImageProcessingTime_150(JNIEnv* env, jobject obj)
{
  double   temp20;

  vtkParallelRenderManager* op = static_cast<vtkParallelRenderManager*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetImageProcessingTime();
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkParallelRenderManager_GetSyncRenderWindowRenderers_151(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkParallelRenderManager* op = static_cast<vtkParallelRenderManager*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetSyncRenderWindowRenderers();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkParallelRenderManager_SetSyncRenderWindowRenderers_152(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkParallelRenderManager* op = static_cast<vtkParallelRenderManager*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetSyncRenderWindowRenderers(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkParallelRenderManager_SyncRenderWindowRenderersOn_153(JNIEnv* env, jobject obj)
{

  vtkParallelRenderManager* op = static_cast<vtkParallelRenderManager*>(vtkJavaGetPointerFromObject(env, obj));
  op->SyncRenderWindowRenderersOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkParallelRenderManager_SyncRenderWindowRenderersOff_154(JNIEnv* env, jobject obj)
{

  vtkParallelRenderManager* op = static_cast<vtkParallelRenderManager*>(vtkJavaGetPointerFromObject(env, obj));
  op->SyncRenderWindowRenderersOff();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkParallelRenderManager_AddRenderer_155(JNIEnv* env, jobject obj,jobject id0)
{
  vtkRenderer * temp0;
  temp0 = static_cast<vtkRenderer*>(vtkJavaGetPointerFromObject(env, id0));

  vtkParallelRenderManager* op = static_cast<vtkParallelRenderManager*>(vtkJavaGetPointerFromObject(env, obj));
  op->AddRenderer(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkParallelRenderManager_RemoveRenderer_156(JNIEnv* env, jobject obj,jobject id0)
{
  vtkRenderer * temp0;
  temp0 = static_cast<vtkRenderer*>(vtkJavaGetPointerFromObject(env, id0));

  vtkParallelRenderManager* op = static_cast<vtkParallelRenderManager*>(vtkJavaGetPointerFromObject(env, obj));
  op->RemoveRenderer(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkParallelRenderManager_RemoveAllRenderers_157(JNIEnv* env, jobject obj)
{

  vtkParallelRenderManager* op = static_cast<vtkParallelRenderManager*>(vtkJavaGetPointerFromObject(env, obj));
  op->RemoveAllRenderers();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkParallelRenderManager_SetWriteBackImages_158(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkParallelRenderManager* op = static_cast<vtkParallelRenderManager*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetWriteBackImages(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkParallelRenderManager_GetWriteBackImages_159(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkParallelRenderManager* op = static_cast<vtkParallelRenderManager*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetWriteBackImages();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkParallelRenderManager_WriteBackImagesOn_160(JNIEnv* env, jobject obj)
{

  vtkParallelRenderManager* op = static_cast<vtkParallelRenderManager*>(vtkJavaGetPointerFromObject(env, obj));
  op->WriteBackImagesOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkParallelRenderManager_WriteBackImagesOff_161(JNIEnv* env, jobject obj)
{

  vtkParallelRenderManager* op = static_cast<vtkParallelRenderManager*>(vtkJavaGetPointerFromObject(env, obj));
  op->WriteBackImagesOff();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkParallelRenderManager_SetMagnifyImages_162(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkParallelRenderManager* op = static_cast<vtkParallelRenderManager*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetMagnifyImages(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkParallelRenderManager_GetMagnifyImages_163(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkParallelRenderManager* op = static_cast<vtkParallelRenderManager*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetMagnifyImages();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkParallelRenderManager_MagnifyImagesOn_164(JNIEnv* env, jobject obj)
{

  vtkParallelRenderManager* op = static_cast<vtkParallelRenderManager*>(vtkJavaGetPointerFromObject(env, obj));
  op->MagnifyImagesOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkParallelRenderManager_MagnifyImagesOff_165(JNIEnv* env, jobject obj)
{

  vtkParallelRenderManager* op = static_cast<vtkParallelRenderManager*>(vtkJavaGetPointerFromObject(env, obj));
  op->MagnifyImagesOff();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkParallelRenderManager_SetMagnifyImageMethod_166(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkParallelRenderManager* op = static_cast<vtkParallelRenderManager*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetMagnifyImageMethod(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkParallelRenderManager_GetMagnifyImageMethod_167(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkParallelRenderManager* op = static_cast<vtkParallelRenderManager*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetMagnifyImageMethod();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkParallelRenderManager_SetMagnifyImageMethodToNearest_168(JNIEnv* env, jobject obj)
{

  vtkParallelRenderManager* op = static_cast<vtkParallelRenderManager*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetMagnifyImageMethodToNearest();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkParallelRenderManager_SetMagnifyImageMethodToLinear_169(JNIEnv* env, jobject obj)
{

  vtkParallelRenderManager* op = static_cast<vtkParallelRenderManager*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetMagnifyImageMethodToLinear();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkParallelRenderManager_MagnifyImage_170(JNIEnv* env, jobject obj,jobject id0,jintArray id1,jobject id2,jintArray id3,jintArray id4,jintArray id5)
{
  vtkUnsignedCharArray * temp0;
  int temp1[2];
  vtkUnsignedCharArray * temp2;
  int temp3[2];
  int temp4[4];
  int temp5[4];
  temp0 = static_cast<vtkUnsignedCharArray*>(vtkJavaGetPointerFromObject(env, id0));
  env->GetIntArrayRegion(id1, 0, 2, reinterpret_cast<jint*>(&temp1[0]));
  temp2 = static_cast<vtkUnsignedCharArray*>(vtkJavaGetPointerFromObject(env, id2));
  env->GetIntArrayRegion(id3, 0, 2, reinterpret_cast<jint*>(&temp3[0]));
  env->GetIntArrayRegion(id4, 0, 4, reinterpret_cast<jint*>(&temp4[0]));
  env->GetIntArrayRegion(id5, 0, 4, reinterpret_cast<jint*>(&temp5[0]));

  vtkParallelRenderManager* op = static_cast<vtkParallelRenderManager*>(vtkJavaGetPointerFromObject(env, obj));
  op->MagnifyImage(temp0,temp1,temp2,temp3,temp4,temp5);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkParallelRenderManager_MagnifyImageNearest_171(JNIEnv* env, jobject obj,jobject id0,jintArray id1,jobject id2,jintArray id3,jintArray id4,jintArray id5)
{
  vtkUnsignedCharArray * temp0;
  int temp1[2];
  vtkUnsignedCharArray * temp2;
  int temp3[2];
  int temp4[4];
  int temp5[4];
  temp0 = static_cast<vtkUnsignedCharArray*>(vtkJavaGetPointerFromObject(env, id0));
  env->GetIntArrayRegion(id1, 0, 2, reinterpret_cast<jint*>(&temp1[0]));
  temp2 = static_cast<vtkUnsignedCharArray*>(vtkJavaGetPointerFromObject(env, id2));
  env->GetIntArrayRegion(id3, 0, 2, reinterpret_cast<jint*>(&temp3[0]));
  env->GetIntArrayRegion(id4, 0, 4, reinterpret_cast<jint*>(&temp4[0]));
  env->GetIntArrayRegion(id5, 0, 4, reinterpret_cast<jint*>(&temp5[0]));

  vtkParallelRenderManager* op = static_cast<vtkParallelRenderManager*>(vtkJavaGetPointerFromObject(env, obj));
  op->MagnifyImageNearest(temp0,temp1,temp2,temp3,temp4,temp5);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkParallelRenderManager_MagnifyImageLinear_172(JNIEnv* env, jobject obj,jobject id0,jintArray id1,jobject id2,jintArray id3,jintArray id4,jintArray id5)
{
  vtkUnsignedCharArray * temp0;
  int temp1[2];
  vtkUnsignedCharArray * temp2;
  int temp3[2];
  int temp4[4];
  int temp5[4];
  temp0 = static_cast<vtkUnsignedCharArray*>(vtkJavaGetPointerFromObject(env, id0));
  env->GetIntArrayRegion(id1, 0, 2, reinterpret_cast<jint*>(&temp1[0]));
  temp2 = static_cast<vtkUnsignedCharArray*>(vtkJavaGetPointerFromObject(env, id2));
  env->GetIntArrayRegion(id3, 0, 2, reinterpret_cast<jint*>(&temp3[0]));
  env->GetIntArrayRegion(id4, 0, 4, reinterpret_cast<jint*>(&temp4[0]));
  env->GetIntArrayRegion(id5, 0, 4, reinterpret_cast<jint*>(&temp5[0]));

  vtkParallelRenderManager* op = static_cast<vtkParallelRenderManager*>(vtkJavaGetPointerFromObject(env, obj));
  op->MagnifyImageLinear(temp0,temp1,temp2,temp3,temp4,temp5);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkParallelRenderManager_GetPixelData_173(JNIEnv* env, jobject obj,jobject id0)
{
  vtkUnsignedCharArray * temp0;
  temp0 = static_cast<vtkUnsignedCharArray*>(vtkJavaGetPointerFromObject(env, id0));

  vtkParallelRenderManager* op = static_cast<vtkParallelRenderManager*>(vtkJavaGetPointerFromObject(env, obj));
  op->GetPixelData(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkParallelRenderManager_GetPixelData_174(JNIEnv* env, jobject obj,jint id0,jint id1,jint id2,jint id3,jobject id4)
{
  int   temp0;
  int   temp1;
  int   temp2;
  int   temp3;
  vtkUnsignedCharArray * temp4;
  temp0 = id0;
  temp1 = id1;
  temp2 = id2;
  temp3 = id3;
  temp4 = static_cast<vtkUnsignedCharArray*>(vtkJavaGetPointerFromObject(env, id4));

  vtkParallelRenderManager* op = static_cast<vtkParallelRenderManager*>(vtkJavaGetPointerFromObject(env, obj));
  op->GetPixelData(temp0,temp1,temp2,temp3,temp4);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkParallelRenderManager_GetReducedPixelData_175(JNIEnv* env, jobject obj,jobject id0)
{
  vtkUnsignedCharArray * temp0;
  temp0 = static_cast<vtkUnsignedCharArray*>(vtkJavaGetPointerFromObject(env, id0));

  vtkParallelRenderManager* op = static_cast<vtkParallelRenderManager*>(vtkJavaGetPointerFromObject(env, obj));
  op->GetReducedPixelData(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkParallelRenderManager_GetReducedPixelData_176(JNIEnv* env, jobject obj,jint id0,jint id1,jint id2,jint id3,jobject id4)
{
  int   temp0;
  int   temp1;
  int   temp2;
  int   temp3;
  vtkUnsignedCharArray * temp4;
  temp0 = id0;
  temp1 = id1;
  temp2 = id2;
  temp3 = id3;
  temp4 = static_cast<vtkUnsignedCharArray*>(vtkJavaGetPointerFromObject(env, id4));

  vtkParallelRenderManager* op = static_cast<vtkParallelRenderManager*>(vtkJavaGetPointerFromObject(env, obj));
  op->GetReducedPixelData(temp0,temp1,temp2,temp3,temp4);

}

extern "C" JNIEXPORT jintArray  JNICALL Java_vtk_vtkParallelRenderManager_GetFullImageSize_177(JNIEnv* env, jobject obj)
{
  int * temp20;

  vtkParallelRenderManager* op = static_cast<vtkParallelRenderManager*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetFullImageSize();
  return vtkJavaMakeJArrayOfInt(env, reinterpret_cast<jint*>(temp20), 2);

}

extern "C" JNIEXPORT jintArray  JNICALL Java_vtk_vtkParallelRenderManager_GetReducedImageSize_178(JNIEnv* env, jobject obj)
{
  int * temp20;

  vtkParallelRenderManager* op = static_cast<vtkParallelRenderManager*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetReducedImageSize();
  return vtkJavaMakeJArrayOfInt(env, reinterpret_cast<jint*>(temp20), 2);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkParallelRenderManager_TileWindows_179(JNIEnv* env, jobject obj,jint id0,jint id1,jint id2)
{
  int   temp0;
  int   temp1;
  int   temp2;
  temp0 = id0;
  temp1 = id1;
  temp2 = id2;

  vtkParallelRenderManager* op = static_cast<vtkParallelRenderManager*>(vtkJavaGetPointerFromObject(env, obj));
  op->TileWindows(temp0,temp1,temp2);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkParallelRenderManager_SetUseRGBA_180(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkParallelRenderManager* op = static_cast<vtkParallelRenderManager*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetUseRGBA(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkParallelRenderManager_GetUseRGBA_181(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkParallelRenderManager* op = static_cast<vtkParallelRenderManager*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetUseRGBA();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkParallelRenderManager_SetForceRenderWindowSize_182(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkParallelRenderManager* op = static_cast<vtkParallelRenderManager*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetForceRenderWindowSize(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkParallelRenderManager_GetForceRenderWindowSize_183(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkParallelRenderManager* op = static_cast<vtkParallelRenderManager*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetForceRenderWindowSize();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkParallelRenderManager_SetForcedRenderWindowSize_184(JNIEnv* env, jobject obj,jint id0,jint id1)
{
  int   temp0;
  int   temp1;
  temp0 = id0;
  temp1 = id1;

  vtkParallelRenderManager* op = static_cast<vtkParallelRenderManager*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetForcedRenderWindowSize(temp0,temp1);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkParallelRenderManager_SetForcedRenderWindowSize_185(JNIEnv* env, jobject obj,jintArray id0)
{
  int temp0[2];
  env->GetIntArrayRegion(id0, 0, 2, reinterpret_cast<jint*>(&temp0[0]));

  vtkParallelRenderManager* op = static_cast<vtkParallelRenderManager*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetForcedRenderWindowSize(temp0);

}

extern "C" JNIEXPORT jintArray  JNICALL Java_vtk_vtkParallelRenderManager_GetForcedRenderWindowSize_186(JNIEnv* env, jobject obj)
{
  int * temp20;

  vtkParallelRenderManager* op = static_cast<vtkParallelRenderManager*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetForcedRenderWindowSize();
  return vtkJavaMakeJArrayOfInt(env, reinterpret_cast<jint*>(temp20), 2);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkParallelRenderManager_CheckForAbortRender_187(JNIEnv* env, jobject obj)
{

  vtkParallelRenderManager* op = static_cast<vtkParallelRenderManager*>(vtkJavaGetPointerFromObject(env, obj));
  op->CheckForAbortRender();

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkParallelRenderManager_CheckForAbortComposite_188(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkParallelRenderManager* op = static_cast<vtkParallelRenderManager*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->CheckForAbortComposite();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkParallelRenderManager_SetUseBackBuffer_189(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkParallelRenderManager* op = static_cast<vtkParallelRenderManager*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetUseBackBuffer(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkParallelRenderManager_GetUseBackBuffer_190(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkParallelRenderManager* op = static_cast<vtkParallelRenderManager*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetUseBackBuffer();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkParallelRenderManager_UseBackBufferOn_191(JNIEnv* env, jobject obj)
{

  vtkParallelRenderManager* op = static_cast<vtkParallelRenderManager*>(vtkJavaGetPointerFromObject(env, obj));
  op->UseBackBufferOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkParallelRenderManager_UseBackBufferOff_192(JNIEnv* env, jobject obj)
{

  vtkParallelRenderManager* op = static_cast<vtkParallelRenderManager*>(vtkJavaGetPointerFromObject(env, obj));
  op->UseBackBufferOff();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkParallelRenderManager_SetSynchronizeTileProperties_193(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkParallelRenderManager* op = static_cast<vtkParallelRenderManager*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetSynchronizeTileProperties(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkParallelRenderManager_GetSynchronizeTileProperties_194(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkParallelRenderManager* op = static_cast<vtkParallelRenderManager*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetSynchronizeTileProperties();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkParallelRenderManager_SynchronizeTilePropertiesOn_195(JNIEnv* env, jobject obj)
{

  vtkParallelRenderManager* op = static_cast<vtkParallelRenderManager*>(vtkJavaGetPointerFromObject(env, obj));
  op->SynchronizeTilePropertiesOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkParallelRenderManager_SynchronizeTilePropertiesOff_196(JNIEnv* env, jobject obj)
{

  vtkParallelRenderManager* op = static_cast<vtkParallelRenderManager*>(vtkJavaGetPointerFromObject(env, obj));
  op->SynchronizeTilePropertiesOff();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkParallelRenderManager_GenericStartRenderCallback_197(JNIEnv* env, jobject obj)
{

  vtkParallelRenderManager* op = static_cast<vtkParallelRenderManager*>(vtkJavaGetPointerFromObject(env, obj));
  op->GenericStartRenderCallback();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkParallelRenderManager_GenericEndRenderCallback_198(JNIEnv* env, jobject obj)
{

  vtkParallelRenderManager* op = static_cast<vtkParallelRenderManager*>(vtkJavaGetPointerFromObject(env, obj));
  op->GenericEndRenderCallback();

}
