// java wrapper for vtkProp object
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkABI.h"
#include "vtkSystemIncludes.h"
#include "vtkProp.h"
#include "vtkJavaUtil.h"

#include "vtkStdString.h"

#include <sstream>
extern "C" JNIEXPORT void* vtkObject_Typecast(void* op,char* dType);

extern "C" JNIEXPORT void* vtkProp_Typecast(void* me,char* dType)
{
  void* res;
  if (!strcmp("vtkProp",dType)) { return me; }
  if ((res= vtkObject_Typecast(me,dType)) != nullptr) { return res; }
  return nullptr;
}


extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkProp_IsTypeOf_10(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkProp* op = static_cast<vtkProp*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsTypeOf(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkProp_IsA_11(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkProp* op = static_cast<vtkProp*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsA(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkProp_GetNumberOfGenerationsFromBaseType_12(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkProp* op = static_cast<vtkProp*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBaseType(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkProp_GetNumberOfGenerationsFromBase_13(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkProp* op = static_cast<vtkProp*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBase(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkProp_GetActors_14(JNIEnv* env, jobject obj,jobject id0)
{
  vtkPropCollection * temp0;
  temp0 = static_cast<vtkPropCollection*>(vtkJavaGetPointerFromObject(env, id0));

  vtkProp* op = static_cast<vtkProp*>(vtkJavaGetPointerFromObject(env, obj));
  op->GetActors(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkProp_GetActors2D_15(JNIEnv* env, jobject obj,jobject id0)
{
  vtkPropCollection * temp0;
  temp0 = static_cast<vtkPropCollection*>(vtkJavaGetPointerFromObject(env, id0));

  vtkProp* op = static_cast<vtkProp*>(vtkJavaGetPointerFromObject(env, obj));
  op->GetActors2D(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkProp_GetVolumes_16(JNIEnv* env, jobject obj,jobject id0)
{
  vtkPropCollection * temp0;
  temp0 = static_cast<vtkPropCollection*>(vtkJavaGetPointerFromObject(env, id0));

  vtkProp* op = static_cast<vtkProp*>(vtkJavaGetPointerFromObject(env, obj));
  op->GetVolumes(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkProp_SetVisibility_17(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkProp* op = static_cast<vtkProp*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetVisibility(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkProp_GetVisibility_18(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkProp* op = static_cast<vtkProp*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetVisibility();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkProp_VisibilityOn_19(JNIEnv* env, jobject obj)
{

  vtkProp* op = static_cast<vtkProp*>(vtkJavaGetPointerFromObject(env, obj));
  op->VisibilityOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkProp_VisibilityOff_110(JNIEnv* env, jobject obj)
{

  vtkProp* op = static_cast<vtkProp*>(vtkJavaGetPointerFromObject(env, obj));
  op->VisibilityOff();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkProp_SetPickable_111(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkProp* op = static_cast<vtkProp*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetPickable(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkProp_GetPickable_112(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkProp* op = static_cast<vtkProp*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetPickable();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkProp_PickableOn_113(JNIEnv* env, jobject obj)
{

  vtkProp* op = static_cast<vtkProp*>(vtkJavaGetPointerFromObject(env, obj));
  op->PickableOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkProp_PickableOff_114(JNIEnv* env, jobject obj)
{

  vtkProp* op = static_cast<vtkProp*>(vtkJavaGetPointerFromObject(env, obj));
  op->PickableOff();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkProp_Pick_115(JNIEnv* env, jobject obj)
{

  vtkProp* op = static_cast<vtkProp*>(vtkJavaGetPointerFromObject(env, obj));
  op->Pick();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkProp_SetDragable_116(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkProp* op = static_cast<vtkProp*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetDragable(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkProp_GetDragable_117(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkProp* op = static_cast<vtkProp*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetDragable();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkProp_DragableOn_118(JNIEnv* env, jobject obj)
{

  vtkProp* op = static_cast<vtkProp*>(vtkJavaGetPointerFromObject(env, obj));
  op->DragableOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkProp_DragableOff_119(JNIEnv* env, jobject obj)
{

  vtkProp* op = static_cast<vtkProp*>(vtkJavaGetPointerFromObject(env, obj));
  op->DragableOff();

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkProp_GetRedrawMTime_120(JNIEnv* env, jobject obj)
{
   unsigned long   temp20;

  vtkProp* op = static_cast<vtkProp*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetRedrawMTime();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkProp_SetUseBounds_121(JNIEnv* env, jobject obj,jboolean id0)
{
  bool   temp0;
  temp0 = (id0 != 0) ? true : false;

  vtkProp* op = static_cast<vtkProp*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetUseBounds(temp0);

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkProp_GetUseBounds_122(JNIEnv* env, jobject obj)
{
  bool   temp20;

  vtkProp* op = static_cast<vtkProp*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetUseBounds();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkProp_UseBoundsOn_123(JNIEnv* env, jobject obj)
{

  vtkProp* op = static_cast<vtkProp*>(vtkJavaGetPointerFromObject(env, obj));
  op->UseBoundsOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkProp_UseBoundsOff_124(JNIEnv* env, jobject obj)
{

  vtkProp* op = static_cast<vtkProp*>(vtkJavaGetPointerFromObject(env, obj));
  op->UseBoundsOff();

}

extern "C" JNIEXPORT jdoubleArray  JNICALL Java_vtk_vtkProp_GetBounds_125(JNIEnv* env, jobject obj)
{
  double * temp20;

  vtkProp* op = static_cast<vtkProp*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetBounds();
  return vtkJavaMakeJArrayOfDouble(env, temp20, 6);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkProp_ShallowCopy_126(JNIEnv* env, jobject obj,jobject id0)
{
  vtkProp * temp0;
  temp0 = static_cast<vtkProp*>(vtkJavaGetPointerFromObject(env, id0));

  vtkProp* op = static_cast<vtkProp*>(vtkJavaGetPointerFromObject(env, obj));
  op->ShallowCopy(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkProp_InitPathTraversal_127(JNIEnv* env, jobject obj)
{

  vtkProp* op = static_cast<vtkProp*>(vtkJavaGetPointerFromObject(env, obj));
  op->InitPathTraversal();

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkProp_GetNextPath_128(JNIEnv* env, jobject obj)
{
  vtkAssemblyPath * temp20;

  vtkProp* op = static_cast<vtkProp*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNextPath();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkProp_GetNumberOfPaths_129(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkProp* op = static_cast<vtkProp*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfPaths();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkProp_PokeMatrix_130(JNIEnv* env, jobject obj,jobject id0)
{
  vtkMatrix4x4 * temp0;
  temp0 = static_cast<vtkMatrix4x4*>(vtkJavaGetPointerFromObject(env, id0));

  vtkProp* op = static_cast<vtkProp*>(vtkJavaGetPointerFromObject(env, obj));
  op->PokeMatrix(temp0);

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkProp_GetMatrix_131(JNIEnv* env, jobject obj)
{
  vtkMatrix4x4 * temp20;

  vtkProp* op = static_cast<vtkProp*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetMatrix();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkProp_GetPropertyKeys_132(JNIEnv* env, jobject obj)
{
  vtkInformation * temp20;

  vtkProp* op = static_cast<vtkProp*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetPropertyKeys();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkProp_SetPropertyKeys_133(JNIEnv* env, jobject obj,jobject id0)
{
  vtkInformation * temp0;
  temp0 = static_cast<vtkInformation*>(vtkJavaGetPointerFromObject(env, id0));

  vtkProp* op = static_cast<vtkProp*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetPropertyKeys(temp0);

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkProp_HasKeys_134(JNIEnv* env, jobject obj,jobject id0)
{
  vtkInformation * temp0;
  bool   temp20;
  temp0 = static_cast<vtkInformation*>(vtkJavaGetPointerFromObject(env, id0));

  vtkProp* op = static_cast<vtkProp*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->HasKeys(temp0);
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkProp_GeneralTextureUnit_135(JNIEnv* env, jobject obj)
{
  vtkInformationIntegerKey * temp20;

  vtkProp* op = static_cast<vtkProp*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GeneralTextureUnit();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkProp_GeneralTextureTransform_136(JNIEnv* env, jobject obj)
{
  vtkInformationDoubleVectorKey * temp20;

  vtkProp* op = static_cast<vtkProp*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GeneralTextureTransform();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkProp_RenderOpaqueGeometry_137(JNIEnv* env, jobject obj,jobject id0)
{
  vtkViewport * temp0;
  int   temp20;
  temp0 = static_cast<vtkViewport*>(vtkJavaGetPointerFromObject(env, id0));

  vtkProp* op = static_cast<vtkProp*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->RenderOpaqueGeometry(temp0);
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkProp_RenderTranslucentPolygonalGeometry_138(JNIEnv* env, jobject obj,jobject id0)
{
  vtkViewport * temp0;
  int   temp20;
  temp0 = static_cast<vtkViewport*>(vtkJavaGetPointerFromObject(env, id0));

  vtkProp* op = static_cast<vtkProp*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->RenderTranslucentPolygonalGeometry(temp0);
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkProp_RenderVolumetricGeometry_139(JNIEnv* env, jobject obj,jobject id0)
{
  vtkViewport * temp0;
  int   temp20;
  temp0 = static_cast<vtkViewport*>(vtkJavaGetPointerFromObject(env, id0));

  vtkProp* op = static_cast<vtkProp*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->RenderVolumetricGeometry(temp0);
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkProp_RenderOverlay_140(JNIEnv* env, jobject obj,jobject id0)
{
  vtkViewport * temp0;
  int   temp20;
  temp0 = static_cast<vtkViewport*>(vtkJavaGetPointerFromObject(env, id0));

  vtkProp* op = static_cast<vtkProp*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->RenderOverlay(temp0);
  return temp20;

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkProp_RenderFilteredOpaqueGeometry_141(JNIEnv* env, jobject obj,jobject id0,jobject id1)
{
  vtkViewport * temp0;
  vtkInformation * temp1;
  bool   temp20;
  temp0 = static_cast<vtkViewport*>(vtkJavaGetPointerFromObject(env, id0));
  temp1 = static_cast<vtkInformation*>(vtkJavaGetPointerFromObject(env, id1));

  vtkProp* op = static_cast<vtkProp*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->RenderFilteredOpaqueGeometry(temp0,temp1);
  return temp20;

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkProp_RenderFilteredTranslucentPolygonalGeometry_142(JNIEnv* env, jobject obj,jobject id0,jobject id1)
{
  vtkViewport * temp0;
  vtkInformation * temp1;
  bool   temp20;
  temp0 = static_cast<vtkViewport*>(vtkJavaGetPointerFromObject(env, id0));
  temp1 = static_cast<vtkInformation*>(vtkJavaGetPointerFromObject(env, id1));

  vtkProp* op = static_cast<vtkProp*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->RenderFilteredTranslucentPolygonalGeometry(temp0,temp1);
  return temp20;

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkProp_RenderFilteredVolumetricGeometry_143(JNIEnv* env, jobject obj,jobject id0,jobject id1)
{
  vtkViewport * temp0;
  vtkInformation * temp1;
  bool   temp20;
  temp0 = static_cast<vtkViewport*>(vtkJavaGetPointerFromObject(env, id0));
  temp1 = static_cast<vtkInformation*>(vtkJavaGetPointerFromObject(env, id1));

  vtkProp* op = static_cast<vtkProp*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->RenderFilteredVolumetricGeometry(temp0,temp1);
  return temp20;

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkProp_RenderFilteredOverlay_144(JNIEnv* env, jobject obj,jobject id0,jobject id1)
{
  vtkViewport * temp0;
  vtkInformation * temp1;
  bool   temp20;
  temp0 = static_cast<vtkViewport*>(vtkJavaGetPointerFromObject(env, id0));
  temp1 = static_cast<vtkInformation*>(vtkJavaGetPointerFromObject(env, id1));

  vtkProp* op = static_cast<vtkProp*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->RenderFilteredOverlay(temp0,temp1);
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkProp_HasTranslucentPolygonalGeometry_145(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkProp* op = static_cast<vtkProp*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->HasTranslucentPolygonalGeometry();
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkProp_HasOpaqueGeometry_146(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkProp* op = static_cast<vtkProp*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->HasOpaqueGeometry();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkProp_ReleaseGraphicsResources_147(JNIEnv* env, jobject obj,jobject id0)
{
  vtkWindow * temp0;
  temp0 = static_cast<vtkWindow*>(vtkJavaGetPointerFromObject(env, id0));

  vtkProp* op = static_cast<vtkProp*>(vtkJavaGetPointerFromObject(env, obj));
  op->ReleaseGraphicsResources(temp0);

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkProp_GetEstimatedRenderTime_148(JNIEnv* env, jobject obj,jobject id0)
{
  vtkViewport * temp0;
  double   temp20;
  temp0 = static_cast<vtkViewport*>(vtkJavaGetPointerFromObject(env, id0));

  vtkProp* op = static_cast<vtkProp*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetEstimatedRenderTime(temp0);
  return temp20;

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkProp_GetEstimatedRenderTime_149(JNIEnv* env, jobject obj)
{
  double   temp20;

  vtkProp* op = static_cast<vtkProp*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetEstimatedRenderTime();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkProp_SetEstimatedRenderTime_150(JNIEnv* env, jobject obj,jdouble id0)
{
  double   temp0;
  temp0 = id0;

  vtkProp* op = static_cast<vtkProp*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetEstimatedRenderTime(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkProp_RestoreEstimatedRenderTime_151(JNIEnv* env, jobject obj)
{

  vtkProp* op = static_cast<vtkProp*>(vtkJavaGetPointerFromObject(env, obj));
  op->RestoreEstimatedRenderTime();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkProp_AddEstimatedRenderTime_152(JNIEnv* env, jobject obj,jdouble id0,jobject id1)
{
  double   temp0;
  vtkViewport * temp1;
  temp0 = id0;
  temp1 = static_cast<vtkViewport*>(vtkJavaGetPointerFromObject(env, id1));

  vtkProp* op = static_cast<vtkProp*>(vtkJavaGetPointerFromObject(env, obj));
  op->AddEstimatedRenderTime(temp0,temp1);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkProp_SetAllocatedRenderTime_153(JNIEnv* env, jobject obj,jdouble id0,jobject id1)
{
  double   temp0;
  vtkViewport * temp1;
  temp0 = id0;
  temp1 = static_cast<vtkViewport*>(vtkJavaGetPointerFromObject(env, id1));

  vtkProp* op = static_cast<vtkProp*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetAllocatedRenderTime(temp0,temp1);

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkProp_GetAllocatedRenderTime_154(JNIEnv* env, jobject obj)
{
  double   temp20;

  vtkProp* op = static_cast<vtkProp*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetAllocatedRenderTime();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkProp_SetRenderTimeMultiplier_155(JNIEnv* env, jobject obj,jdouble id0)
{
  double   temp0;
  temp0 = id0;

  vtkProp* op = static_cast<vtkProp*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetRenderTimeMultiplier(temp0);

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkProp_GetRenderTimeMultiplier_156(JNIEnv* env, jobject obj)
{
  double   temp20;

  vtkProp* op = static_cast<vtkProp*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetRenderTimeMultiplier();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkProp_BuildPaths_157(JNIEnv* env, jobject obj,jobject id0,jobject id1)
{
  vtkAssemblyPaths * temp0;
  vtkAssemblyPath * temp1;
  temp0 = static_cast<vtkAssemblyPaths*>(vtkJavaGetPointerFromObject(env, id0));
  temp1 = static_cast<vtkAssemblyPath*>(vtkJavaGetPointerFromObject(env, id1));

  vtkProp* op = static_cast<vtkProp*>(vtkJavaGetPointerFromObject(env, obj));
  op->BuildPaths(temp0,temp1);

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkProp_GetSupportsSelection_158(JNIEnv* env, jobject obj)
{
  bool   temp20;

  vtkProp* op = static_cast<vtkProp*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetSupportsSelection();
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkProp_GetNumberOfConsumers_159(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkProp* op = static_cast<vtkProp*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfConsumers();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkProp_AddConsumer_160(JNIEnv* env, jobject obj,jobject id0)
{
  vtkObject * temp0;
  temp0 = static_cast<vtkObject*>(vtkJavaGetPointerFromObject(env, id0));

  vtkProp* op = static_cast<vtkProp*>(vtkJavaGetPointerFromObject(env, obj));
  op->AddConsumer(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkProp_RemoveConsumer_161(JNIEnv* env, jobject obj,jobject id0)
{
  vtkObject * temp0;
  temp0 = static_cast<vtkObject*>(vtkJavaGetPointerFromObject(env, id0));

  vtkProp* op = static_cast<vtkProp*>(vtkJavaGetPointerFromObject(env, obj));
  op->RemoveConsumer(temp0);

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkProp_GetConsumer_162(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  vtkObject * temp20;
  temp0 = id0;

  vtkProp* op = static_cast<vtkProp*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetConsumer(temp0);
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkProp_IsConsumer_163(JNIEnv* env, jobject obj,jobject id0)
{
  vtkObject * temp0;
  int   temp20;
  temp0 = static_cast<vtkObject*>(vtkJavaGetPointerFromObject(env, id0));

  vtkProp* op = static_cast<vtkProp*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsConsumer(temp0);
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkProp_SetShaderProperty_164(JNIEnv* env, jobject obj,jobject id0)
{
  vtkShaderProperty * temp0;
  temp0 = static_cast<vtkShaderProperty*>(vtkJavaGetPointerFromObject(env, id0));

  vtkProp* op = static_cast<vtkProp*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetShaderProperty(temp0);

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkProp_GetShaderProperty_165(JNIEnv* env, jobject obj)
{
  vtkShaderProperty * temp20;

  vtkProp* op = static_cast<vtkProp*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetShaderProperty();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkProp_IsRenderingTranslucentPolygonalGeometry_166(JNIEnv* env, jobject obj)
{
  bool   temp20;

  vtkProp* op = static_cast<vtkProp*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsRenderingTranslucentPolygonalGeometry();
  return temp20;

}
