// java wrapper for vtkScalarBarActor object
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkABI.h"
#include "vtkSystemIncludes.h"
#include "vtkScalarBarActor.h"
#include "vtkJavaUtil.h"

#include "vtkStdString.h"

#include <sstream>
extern "C" JNIEXPORT void* vtkActor2D_Typecast(void* op,char* dType);

extern "C" JNIEXPORT void* vtkScalarBarActor_Typecast(void* me,char* dType)
{
  void* res;
  if (!strcmp("vtkScalarBarActor",dType)) { return me; }
  if ((res= vtkActor2D_Typecast(me,dType)) != nullptr) { return res; }
  return nullptr;
}


extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkScalarBarActor_IsTypeOf_10(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkScalarBarActor* op = static_cast<vtkScalarBarActor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsTypeOf(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkScalarBarActor_IsA_11(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkScalarBarActor* op = static_cast<vtkScalarBarActor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsA(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkScalarBarActor_GetNumberOfGenerationsFromBaseType_12(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkScalarBarActor* op = static_cast<vtkScalarBarActor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBaseType(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkScalarBarActor_GetNumberOfGenerationsFromBase_13(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkScalarBarActor* op = static_cast<vtkScalarBarActor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBase(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkScalarBarActor_RenderOpaqueGeometry_14(JNIEnv* env, jobject obj,jobject id0)
{
  vtkViewport * temp0;
  int   temp20;
  temp0 = static_cast<vtkViewport*>(vtkJavaGetPointerFromObject(env, id0));

  vtkScalarBarActor* op = static_cast<vtkScalarBarActor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->RenderOpaqueGeometry(temp0);
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkScalarBarActor_RenderTranslucentPolygonalGeometry_15(JNIEnv* env, jobject obj,jobject id0)
{
  vtkViewport * temp0;
  int   temp20;
  temp0 = static_cast<vtkViewport*>(vtkJavaGetPointerFromObject(env, id0));

  vtkScalarBarActor* op = static_cast<vtkScalarBarActor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->RenderTranslucentPolygonalGeometry(temp0);
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkScalarBarActor_RenderOverlay_16(JNIEnv* env, jobject obj,jobject id0)
{
  vtkViewport * temp0;
  int   temp20;
  temp0 = static_cast<vtkViewport*>(vtkJavaGetPointerFromObject(env, id0));

  vtkScalarBarActor* op = static_cast<vtkScalarBarActor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->RenderOverlay(temp0);
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkScalarBarActor_HasTranslucentPolygonalGeometry_17(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkScalarBarActor* op = static_cast<vtkScalarBarActor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->HasTranslucentPolygonalGeometry();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkScalarBarActor_ReleaseGraphicsResources_18(JNIEnv* env, jobject obj,jobject id0)
{
  vtkWindow * temp0;
  temp0 = static_cast<vtkWindow*>(vtkJavaGetPointerFromObject(env, id0));

  vtkScalarBarActor* op = static_cast<vtkScalarBarActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->ReleaseGraphicsResources(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkScalarBarActor_GetScalarBarRect_19(JNIEnv* env, jobject obj,jintArray id0,jobject id1)
{
  int temp0[4];
  vtkViewport * temp1;
  env->GetIntArrayRegion(id0, 0, 4, reinterpret_cast<jint*>(&temp0[0]));
  temp1 = static_cast<vtkViewport*>(vtkJavaGetPointerFromObject(env, id1));

  vtkScalarBarActor* op = static_cast<vtkScalarBarActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->GetScalarBarRect(temp0,temp1);
  env->SetIntArrayRegion(id0, 0, 4, reinterpret_cast<jint*>(&temp0[0]));

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkScalarBarActor_SetLookupTable_110(JNIEnv* env, jobject obj,jobject id0)
{
  vtkScalarsToColors * temp0;
  temp0 = static_cast<vtkScalarsToColors*>(vtkJavaGetPointerFromObject(env, id0));

  vtkScalarBarActor* op = static_cast<vtkScalarBarActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetLookupTable(temp0);

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkScalarBarActor_GetLookupTable_111(JNIEnv* env, jobject obj)
{
  vtkScalarsToColors * temp20;

  vtkScalarBarActor* op = static_cast<vtkScalarBarActor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetLookupTable();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkScalarBarActor_SetOpacityFunction_112(JNIEnv* env, jobject obj,jobject id0)
{
  vtkPiecewiseFunction * temp0;
  temp0 = static_cast<vtkPiecewiseFunction*>(vtkJavaGetPointerFromObject(env, id0));

  vtkScalarBarActor* op = static_cast<vtkScalarBarActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetOpacityFunction(temp0);

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkScalarBarActor_GetOpacityFunction_113(JNIEnv* env, jobject obj)
{
  vtkPiecewiseFunction * temp20;

  vtkScalarBarActor* op = static_cast<vtkScalarBarActor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetOpacityFunction();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkScalarBarActor_SetUseOpacity_114(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkScalarBarActor* op = static_cast<vtkScalarBarActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetUseOpacity(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkScalarBarActor_GetUseOpacity_115(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkScalarBarActor* op = static_cast<vtkScalarBarActor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetUseOpacity();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkScalarBarActor_UseOpacityOn_116(JNIEnv* env, jobject obj)
{

  vtkScalarBarActor* op = static_cast<vtkScalarBarActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->UseOpacityOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkScalarBarActor_UseOpacityOff_117(JNIEnv* env, jobject obj)
{

  vtkScalarBarActor* op = static_cast<vtkScalarBarActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->UseOpacityOff();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkScalarBarActor_SetMaximumNumberOfColors_118(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkScalarBarActor* op = static_cast<vtkScalarBarActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetMaximumNumberOfColors(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkScalarBarActor_GetMaximumNumberOfColorsMinValue_119(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkScalarBarActor* op = static_cast<vtkScalarBarActor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetMaximumNumberOfColorsMinValue();
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkScalarBarActor_GetMaximumNumberOfColorsMaxValue_120(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkScalarBarActor* op = static_cast<vtkScalarBarActor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetMaximumNumberOfColorsMaxValue();
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkScalarBarActor_GetMaximumNumberOfColors_121(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkScalarBarActor* op = static_cast<vtkScalarBarActor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetMaximumNumberOfColors();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkScalarBarActor_SetNumberOfLabels_122(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkScalarBarActor* op = static_cast<vtkScalarBarActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetNumberOfLabels(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkScalarBarActor_GetNumberOfLabelsMinValue_123(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkScalarBarActor* op = static_cast<vtkScalarBarActor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfLabelsMinValue();
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkScalarBarActor_GetNumberOfLabelsMaxValue_124(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkScalarBarActor* op = static_cast<vtkScalarBarActor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfLabelsMaxValue();
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkScalarBarActor_GetNumberOfLabels_125(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkScalarBarActor* op = static_cast<vtkScalarBarActor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfLabels();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkScalarBarActor_SetCustomLabels_126(JNIEnv* env, jobject obj,jobject id0)
{
  vtkDoubleArray * temp0;
  temp0 = static_cast<vtkDoubleArray*>(vtkJavaGetPointerFromObject(env, id0));

  vtkScalarBarActor* op = static_cast<vtkScalarBarActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetCustomLabels(temp0);

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkScalarBarActor_GetCustomLabels_127(JNIEnv* env, jobject obj)
{
  vtkDoubleArray * temp20;

  vtkScalarBarActor* op = static_cast<vtkScalarBarActor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetCustomLabels();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkScalarBarActor_GetUseCustomLabels_128(JNIEnv* env, jobject obj)
{
  bool   temp20;

  vtkScalarBarActor* op = static_cast<vtkScalarBarActor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetUseCustomLabels();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkScalarBarActor_SetUseCustomLabels_129(JNIEnv* env, jobject obj,jboolean id0)
{
  bool   temp0;
  temp0 = (id0 != 0) ? true : false;

  vtkScalarBarActor* op = static_cast<vtkScalarBarActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetUseCustomLabels(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkScalarBarActor_UseCustomLabelsOn_130(JNIEnv* env, jobject obj)
{

  vtkScalarBarActor* op = static_cast<vtkScalarBarActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->UseCustomLabelsOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkScalarBarActor_UseCustomLabelsOff_131(JNIEnv* env, jobject obj)
{

  vtkScalarBarActor* op = static_cast<vtkScalarBarActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->UseCustomLabelsOff();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkScalarBarActor_SetOrientation_132(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkScalarBarActor* op = static_cast<vtkScalarBarActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetOrientation(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkScalarBarActor_GetOrientationMinValue_133(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkScalarBarActor* op = static_cast<vtkScalarBarActor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetOrientationMinValue();
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkScalarBarActor_GetOrientationMaxValue_134(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkScalarBarActor* op = static_cast<vtkScalarBarActor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetOrientationMaxValue();
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkScalarBarActor_GetOrientation_135(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkScalarBarActor* op = static_cast<vtkScalarBarActor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetOrientation();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkScalarBarActor_SetOrientationToHorizontal_136(JNIEnv* env, jobject obj)
{

  vtkScalarBarActor* op = static_cast<vtkScalarBarActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetOrientationToHorizontal();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkScalarBarActor_SetOrientationToVertical_137(JNIEnv* env, jobject obj)
{

  vtkScalarBarActor* op = static_cast<vtkScalarBarActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetOrientationToVertical();

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkScalarBarActor_GetForceVerticalTitle_138(JNIEnv* env, jobject obj)
{
  bool   temp20;

  vtkScalarBarActor* op = static_cast<vtkScalarBarActor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetForceVerticalTitle();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkScalarBarActor_SetForceVerticalTitle_139(JNIEnv* env, jobject obj,jboolean id0)
{
  bool   temp0;
  temp0 = (id0 != 0) ? true : false;

  vtkScalarBarActor* op = static_cast<vtkScalarBarActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetForceVerticalTitle(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkScalarBarActor_SetTitleTextProperty_140(JNIEnv* env, jobject obj,jobject id0)
{
  vtkTextProperty * temp0;
  temp0 = static_cast<vtkTextProperty*>(vtkJavaGetPointerFromObject(env, id0));

  vtkScalarBarActor* op = static_cast<vtkScalarBarActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetTitleTextProperty(temp0);

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkScalarBarActor_GetTitleTextProperty_141(JNIEnv* env, jobject obj)
{
  vtkTextProperty * temp20;

  vtkScalarBarActor* op = static_cast<vtkScalarBarActor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetTitleTextProperty();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkScalarBarActor_SetLabelTextProperty_142(JNIEnv* env, jobject obj,jobject id0)
{
  vtkTextProperty * temp0;
  temp0 = static_cast<vtkTextProperty*>(vtkJavaGetPointerFromObject(env, id0));

  vtkScalarBarActor* op = static_cast<vtkScalarBarActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetLabelTextProperty(temp0);

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkScalarBarActor_GetLabelTextProperty_143(JNIEnv* env, jobject obj)
{
  vtkTextProperty * temp20;

  vtkScalarBarActor* op = static_cast<vtkScalarBarActor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetLabelTextProperty();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkScalarBarActor_SetAnnotationTextProperty_144(JNIEnv* env, jobject obj,jobject id0)
{
  vtkTextProperty * temp0;
  temp0 = static_cast<vtkTextProperty*>(vtkJavaGetPointerFromObject(env, id0));

  vtkScalarBarActor* op = static_cast<vtkScalarBarActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetAnnotationTextProperty(temp0);

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkScalarBarActor_GetAnnotationTextProperty_145(JNIEnv* env, jobject obj)
{
  vtkTextProperty * temp20;

  vtkScalarBarActor* op = static_cast<vtkScalarBarActor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetAnnotationTextProperty();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkScalarBarActor_SetLabelFormat_146(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkScalarBarActor* op = static_cast<vtkScalarBarActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetLabelFormat(temp0);
  delete[] temp0;

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkScalarBarActor_GetLabelFormat_147(JNIEnv* env, jobject obj)
{
  char * temp20;

  vtkScalarBarActor* op = static_cast<vtkScalarBarActor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetLabelFormat();
  return (temp20 == nullptr) ? env->NewByteArray(0) : vtkJavaCharsToUTF8(env, temp20, strlen(temp20));

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkScalarBarActor_SetTitle_148(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkScalarBarActor* op = static_cast<vtkScalarBarActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetTitle(temp0);
  delete[] temp0;

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkScalarBarActor_GetTitle_149(JNIEnv* env, jobject obj)
{
  char * temp20;

  vtkScalarBarActor* op = static_cast<vtkScalarBarActor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetTitle();
  return (temp20 == nullptr) ? env->NewByteArray(0) : vtkJavaCharsToUTF8(env, temp20, strlen(temp20));

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkScalarBarActor_SetComponentTitle_150(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkScalarBarActor* op = static_cast<vtkScalarBarActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetComponentTitle(temp0);
  delete[] temp0;

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkScalarBarActor_GetComponentTitle_151(JNIEnv* env, jobject obj)
{
  char * temp20;

  vtkScalarBarActor* op = static_cast<vtkScalarBarActor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetComponentTitle();
  return (temp20 == nullptr) ? env->NewByteArray(0) : vtkJavaCharsToUTF8(env, temp20, strlen(temp20));

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkScalarBarActor_ShallowCopy_152(JNIEnv* env, jobject obj,jobject id0)
{
  vtkProp * temp0;
  temp0 = static_cast<vtkProp*>(vtkJavaGetPointerFromObject(env, id0));

  vtkScalarBarActor* op = static_cast<vtkScalarBarActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->ShallowCopy(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkScalarBarActor_SetTextureGridWidth_153(JNIEnv* env, jobject obj,jdouble id0)
{
  double   temp0;
  temp0 = id0;

  vtkScalarBarActor* op = static_cast<vtkScalarBarActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetTextureGridWidth(temp0);

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkScalarBarActor_GetTextureGridWidth_154(JNIEnv* env, jobject obj)
{
  double   temp20;

  vtkScalarBarActor* op = static_cast<vtkScalarBarActor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetTextureGridWidth();
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkScalarBarActor_GetTextureActor_155(JNIEnv* env, jobject obj)
{
  vtkTexturedActor2D * temp20;

  vtkScalarBarActor* op = static_cast<vtkScalarBarActor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetTextureActor();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkScalarBarActor_SetTextPosition_156(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkScalarBarActor* op = static_cast<vtkScalarBarActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetTextPosition(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkScalarBarActor_GetTextPositionMinValue_157(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkScalarBarActor* op = static_cast<vtkScalarBarActor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetTextPositionMinValue();
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkScalarBarActor_GetTextPositionMaxValue_158(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkScalarBarActor* op = static_cast<vtkScalarBarActor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetTextPositionMaxValue();
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkScalarBarActor_GetTextPosition_159(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkScalarBarActor* op = static_cast<vtkScalarBarActor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetTextPosition();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkScalarBarActor_SetTextPositionToPrecedeScalarBar_160(JNIEnv* env, jobject obj)
{

  vtkScalarBarActor* op = static_cast<vtkScalarBarActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetTextPositionToPrecedeScalarBar();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkScalarBarActor_SetTextPositionToSucceedScalarBar_161(JNIEnv* env, jobject obj)
{

  vtkScalarBarActor* op = static_cast<vtkScalarBarActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetTextPositionToSucceedScalarBar();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkScalarBarActor_SetMaximumWidthInPixels_162(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkScalarBarActor* op = static_cast<vtkScalarBarActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetMaximumWidthInPixels(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkScalarBarActor_GetMaximumWidthInPixels_163(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkScalarBarActor* op = static_cast<vtkScalarBarActor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetMaximumWidthInPixels();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkScalarBarActor_SetMaximumHeightInPixels_164(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkScalarBarActor* op = static_cast<vtkScalarBarActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetMaximumHeightInPixels(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkScalarBarActor_GetMaximumHeightInPixels_165(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkScalarBarActor* op = static_cast<vtkScalarBarActor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetMaximumHeightInPixels();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkScalarBarActor_SetAnnotationLeaderPadding_166(JNIEnv* env, jobject obj,jdouble id0)
{
  double   temp0;
  temp0 = id0;

  vtkScalarBarActor* op = static_cast<vtkScalarBarActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetAnnotationLeaderPadding(temp0);

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkScalarBarActor_GetAnnotationLeaderPadding_167(JNIEnv* env, jobject obj)
{
  double   temp20;

  vtkScalarBarActor* op = static_cast<vtkScalarBarActor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetAnnotationLeaderPadding();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkScalarBarActor_SetDrawAnnotations_168(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkScalarBarActor* op = static_cast<vtkScalarBarActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetDrawAnnotations(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkScalarBarActor_GetDrawAnnotations_169(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkScalarBarActor* op = static_cast<vtkScalarBarActor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetDrawAnnotations();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkScalarBarActor_DrawAnnotationsOn_170(JNIEnv* env, jobject obj)
{

  vtkScalarBarActor* op = static_cast<vtkScalarBarActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->DrawAnnotationsOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkScalarBarActor_DrawAnnotationsOff_171(JNIEnv* env, jobject obj)
{

  vtkScalarBarActor* op = static_cast<vtkScalarBarActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->DrawAnnotationsOff();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkScalarBarActor_SetDrawNanAnnotation_172(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkScalarBarActor* op = static_cast<vtkScalarBarActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetDrawNanAnnotation(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkScalarBarActor_GetDrawNanAnnotation_173(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkScalarBarActor* op = static_cast<vtkScalarBarActor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetDrawNanAnnotation();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkScalarBarActor_DrawNanAnnotationOn_174(JNIEnv* env, jobject obj)
{

  vtkScalarBarActor* op = static_cast<vtkScalarBarActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->DrawNanAnnotationOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkScalarBarActor_DrawNanAnnotationOff_175(JNIEnv* env, jobject obj)
{

  vtkScalarBarActor* op = static_cast<vtkScalarBarActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->DrawNanAnnotationOff();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkScalarBarActor_SetDrawBelowRangeSwatch_176(JNIEnv* env, jobject obj,jboolean id0)
{
  bool   temp0;
  temp0 = (id0 != 0) ? true : false;

  vtkScalarBarActor* op = static_cast<vtkScalarBarActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetDrawBelowRangeSwatch(temp0);

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkScalarBarActor_GetDrawBelowRangeSwatch_177(JNIEnv* env, jobject obj)
{
  bool   temp20;

  vtkScalarBarActor* op = static_cast<vtkScalarBarActor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetDrawBelowRangeSwatch();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkScalarBarActor_DrawBelowRangeSwatchOn_178(JNIEnv* env, jobject obj)
{

  vtkScalarBarActor* op = static_cast<vtkScalarBarActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->DrawBelowRangeSwatchOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkScalarBarActor_DrawBelowRangeSwatchOff_179(JNIEnv* env, jobject obj)
{

  vtkScalarBarActor* op = static_cast<vtkScalarBarActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->DrawBelowRangeSwatchOff();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkScalarBarActor_SetBelowRangeAnnotation_180(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkScalarBarActor* op = static_cast<vtkScalarBarActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetBelowRangeAnnotation(temp0);
  delete[] temp0;

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkScalarBarActor_GetBelowRangeAnnotation_181(JNIEnv* env, jobject obj)
{
  char * temp20;

  vtkScalarBarActor* op = static_cast<vtkScalarBarActor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetBelowRangeAnnotation();
  return (temp20 == nullptr) ? env->NewByteArray(0) : vtkJavaCharsToUTF8(env, temp20, strlen(temp20));

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkScalarBarActor_SetDrawAboveRangeSwatch_182(JNIEnv* env, jobject obj,jboolean id0)
{
  bool   temp0;
  temp0 = (id0 != 0) ? true : false;

  vtkScalarBarActor* op = static_cast<vtkScalarBarActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetDrawAboveRangeSwatch(temp0);

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkScalarBarActor_GetDrawAboveRangeSwatch_183(JNIEnv* env, jobject obj)
{
  bool   temp20;

  vtkScalarBarActor* op = static_cast<vtkScalarBarActor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetDrawAboveRangeSwatch();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkScalarBarActor_DrawAboveRangeSwatchOn_184(JNIEnv* env, jobject obj)
{

  vtkScalarBarActor* op = static_cast<vtkScalarBarActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->DrawAboveRangeSwatchOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkScalarBarActor_DrawAboveRangeSwatchOff_185(JNIEnv* env, jobject obj)
{

  vtkScalarBarActor* op = static_cast<vtkScalarBarActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->DrawAboveRangeSwatchOff();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkScalarBarActor_SetAboveRangeAnnotation_186(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkScalarBarActor* op = static_cast<vtkScalarBarActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetAboveRangeAnnotation(temp0);
  delete[] temp0;

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkScalarBarActor_GetAboveRangeAnnotation_187(JNIEnv* env, jobject obj)
{
  char * temp20;

  vtkScalarBarActor* op = static_cast<vtkScalarBarActor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetAboveRangeAnnotation();
  return (temp20 == nullptr) ? env->NewByteArray(0) : vtkJavaCharsToUTF8(env, temp20, strlen(temp20));

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkScalarBarActor_SetFixedAnnotationLeaderLineColor_188(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkScalarBarActor* op = static_cast<vtkScalarBarActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetFixedAnnotationLeaderLineColor(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkScalarBarActor_GetFixedAnnotationLeaderLineColor_189(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkScalarBarActor* op = static_cast<vtkScalarBarActor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetFixedAnnotationLeaderLineColor();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkScalarBarActor_FixedAnnotationLeaderLineColorOn_190(JNIEnv* env, jobject obj)
{

  vtkScalarBarActor* op = static_cast<vtkScalarBarActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->FixedAnnotationLeaderLineColorOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkScalarBarActor_FixedAnnotationLeaderLineColorOff_191(JNIEnv* env, jobject obj)
{

  vtkScalarBarActor* op = static_cast<vtkScalarBarActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->FixedAnnotationLeaderLineColorOff();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkScalarBarActor_SetNanAnnotation_192(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkScalarBarActor* op = static_cast<vtkScalarBarActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetNanAnnotation(temp0);
  delete[] temp0;

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkScalarBarActor_GetNanAnnotation_193(JNIEnv* env, jobject obj)
{
  char * temp20;

  vtkScalarBarActor* op = static_cast<vtkScalarBarActor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNanAnnotation();
  return (temp20 == nullptr) ? env->NewByteArray(0) : vtkJavaCharsToUTF8(env, temp20, strlen(temp20));

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkScalarBarActor_SetAnnotationTextScaling_194(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkScalarBarActor* op = static_cast<vtkScalarBarActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetAnnotationTextScaling(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkScalarBarActor_GetAnnotationTextScaling_195(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkScalarBarActor* op = static_cast<vtkScalarBarActor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetAnnotationTextScaling();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkScalarBarActor_AnnotationTextScalingOn_196(JNIEnv* env, jobject obj)
{

  vtkScalarBarActor* op = static_cast<vtkScalarBarActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->AnnotationTextScalingOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkScalarBarActor_AnnotationTextScalingOff_197(JNIEnv* env, jobject obj)
{

  vtkScalarBarActor* op = static_cast<vtkScalarBarActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->AnnotationTextScalingOff();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkScalarBarActor_SetDrawBackground_198(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkScalarBarActor* op = static_cast<vtkScalarBarActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetDrawBackground(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkScalarBarActor_GetDrawBackground_199(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkScalarBarActor* op = static_cast<vtkScalarBarActor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetDrawBackground();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkScalarBarActor_DrawBackgroundOn_1100(JNIEnv* env, jobject obj)
{

  vtkScalarBarActor* op = static_cast<vtkScalarBarActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->DrawBackgroundOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkScalarBarActor_DrawBackgroundOff_1101(JNIEnv* env, jobject obj)
{

  vtkScalarBarActor* op = static_cast<vtkScalarBarActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->DrawBackgroundOff();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkScalarBarActor_SetDrawFrame_1102(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkScalarBarActor* op = static_cast<vtkScalarBarActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetDrawFrame(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkScalarBarActor_GetDrawFrame_1103(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkScalarBarActor* op = static_cast<vtkScalarBarActor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetDrawFrame();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkScalarBarActor_DrawFrameOn_1104(JNIEnv* env, jobject obj)
{

  vtkScalarBarActor* op = static_cast<vtkScalarBarActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->DrawFrameOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkScalarBarActor_DrawFrameOff_1105(JNIEnv* env, jobject obj)
{

  vtkScalarBarActor* op = static_cast<vtkScalarBarActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->DrawFrameOff();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkScalarBarActor_SetDrawColorBar_1106(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkScalarBarActor* op = static_cast<vtkScalarBarActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetDrawColorBar(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkScalarBarActor_GetDrawColorBar_1107(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkScalarBarActor* op = static_cast<vtkScalarBarActor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetDrawColorBar();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkScalarBarActor_DrawColorBarOn_1108(JNIEnv* env, jobject obj)
{

  vtkScalarBarActor* op = static_cast<vtkScalarBarActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->DrawColorBarOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkScalarBarActor_DrawColorBarOff_1109(JNIEnv* env, jobject obj)
{

  vtkScalarBarActor* op = static_cast<vtkScalarBarActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->DrawColorBarOff();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkScalarBarActor_SetDrawTickLabels_1110(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkScalarBarActor* op = static_cast<vtkScalarBarActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetDrawTickLabels(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkScalarBarActor_GetDrawTickLabels_1111(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkScalarBarActor* op = static_cast<vtkScalarBarActor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetDrawTickLabels();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkScalarBarActor_DrawTickLabelsOn_1112(JNIEnv* env, jobject obj)
{

  vtkScalarBarActor* op = static_cast<vtkScalarBarActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->DrawTickLabelsOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkScalarBarActor_DrawTickLabelsOff_1113(JNIEnv* env, jobject obj)
{

  vtkScalarBarActor* op = static_cast<vtkScalarBarActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->DrawTickLabelsOff();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkScalarBarActor_SetBackgroundProperty_1114(JNIEnv* env, jobject obj,jobject id0)
{
  vtkProperty2D * temp0;
  temp0 = static_cast<vtkProperty2D*>(vtkJavaGetPointerFromObject(env, id0));

  vtkScalarBarActor* op = static_cast<vtkScalarBarActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetBackgroundProperty(temp0);

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkScalarBarActor_GetBackgroundProperty_1115(JNIEnv* env, jobject obj)
{
  vtkProperty2D * temp20;

  vtkScalarBarActor* op = static_cast<vtkScalarBarActor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetBackgroundProperty();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkScalarBarActor_SetFrameProperty_1116(JNIEnv* env, jobject obj,jobject id0)
{
  vtkProperty2D * temp0;
  temp0 = static_cast<vtkProperty2D*>(vtkJavaGetPointerFromObject(env, id0));

  vtkScalarBarActor* op = static_cast<vtkScalarBarActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetFrameProperty(temp0);

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkScalarBarActor_GetFrameProperty_1117(JNIEnv* env, jobject obj)
{
  vtkProperty2D * temp20;

  vtkScalarBarActor* op = static_cast<vtkScalarBarActor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetFrameProperty();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkScalarBarActor_GetTextPad_1118(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkScalarBarActor* op = static_cast<vtkScalarBarActor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetTextPad();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkScalarBarActor_SetTextPad_1119(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkScalarBarActor* op = static_cast<vtkScalarBarActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetTextPad(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkScalarBarActor_GetVerticalTitleSeparation_1120(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkScalarBarActor* op = static_cast<vtkScalarBarActor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetVerticalTitleSeparation();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkScalarBarActor_SetVerticalTitleSeparation_1121(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkScalarBarActor* op = static_cast<vtkScalarBarActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetVerticalTitleSeparation(temp0);

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkScalarBarActor_GetBarRatio_1122(JNIEnv* env, jobject obj)
{
  double   temp20;

  vtkScalarBarActor* op = static_cast<vtkScalarBarActor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetBarRatio();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkScalarBarActor_SetBarRatio_1123(JNIEnv* env, jobject obj,jdouble id0)
{
  double   temp0;
  temp0 = id0;

  vtkScalarBarActor* op = static_cast<vtkScalarBarActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetBarRatio(temp0);

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkScalarBarActor_GetBarRatioMinValue_1124(JNIEnv* env, jobject obj)
{
  double   temp20;

  vtkScalarBarActor* op = static_cast<vtkScalarBarActor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetBarRatioMinValue();
  return temp20;

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkScalarBarActor_GetBarRatioMaxValue_1125(JNIEnv* env, jobject obj)
{
  double   temp20;

  vtkScalarBarActor* op = static_cast<vtkScalarBarActor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetBarRatioMaxValue();
  return temp20;

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkScalarBarActor_GetTitleRatio_1126(JNIEnv* env, jobject obj)
{
  double   temp20;

  vtkScalarBarActor* op = static_cast<vtkScalarBarActor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetTitleRatio();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkScalarBarActor_SetTitleRatio_1127(JNIEnv* env, jobject obj,jdouble id0)
{
  double   temp0;
  temp0 = id0;

  vtkScalarBarActor* op = static_cast<vtkScalarBarActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetTitleRatio(temp0);

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkScalarBarActor_GetTitleRatioMinValue_1128(JNIEnv* env, jobject obj)
{
  double   temp20;

  vtkScalarBarActor* op = static_cast<vtkScalarBarActor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetTitleRatioMinValue();
  return temp20;

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkScalarBarActor_GetTitleRatioMaxValue_1129(JNIEnv* env, jobject obj)
{
  double   temp20;

  vtkScalarBarActor* op = static_cast<vtkScalarBarActor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetTitleRatioMaxValue();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkScalarBarActor_SetUnconstrainedFontSize_1130(JNIEnv* env, jobject obj,jboolean id0)
{
  bool   temp0;
  temp0 = (id0 != 0) ? true : false;

  vtkScalarBarActor* op = static_cast<vtkScalarBarActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetUnconstrainedFontSize(temp0);

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkScalarBarActor_GetUnconstrainedFontSize_1131(JNIEnv* env, jobject obj)
{
  bool   temp20;

  vtkScalarBarActor* op = static_cast<vtkScalarBarActor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetUnconstrainedFontSize();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkScalarBarActor_UnconstrainedFontSizeOn_1132(JNIEnv* env, jobject obj)
{

  vtkScalarBarActor* op = static_cast<vtkScalarBarActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->UnconstrainedFontSizeOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkScalarBarActor_UnconstrainedFontSizeOff_1133(JNIEnv* env, jobject obj)
{

  vtkScalarBarActor* op = static_cast<vtkScalarBarActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->UnconstrainedFontSizeOff();

}

extern "C" JNIEXPORT jlong JNICALL Java_vtk_vtkScalarBarActor_VTKInit(JNIEnv*, jobject)
{
  return reinterpret_cast<jlong>(vtkScalarBarActor::New());
}
