// java wrapper for vtkPDirectory object
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkABI.h"
#include "vtkSystemIncludes.h"
#include "vtkPDirectory.h"
#include "vtkJavaUtil.h"

#include "vtkStdString.h"

#include <sstream>
extern "C" JNIEXPORT void* vtkObject_Typecast(void* op,char* dType);

extern "C" JNIEXPORT void* vtkPDirectory_Typecast(void* me,char* dType)
{
  void* res;
  if (!strcmp("vtkPDirectory",dType)) { return me; }
  if ((res= vtkObject_Typecast(me,dType)) != nullptr) { return res; }
  return nullptr;
}


extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkPDirectory_IsTypeOf_10(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkPDirectory* op = static_cast<vtkPDirectory*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsTypeOf(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkPDirectory_IsA_11(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkPDirectory* op = static_cast<vtkPDirectory*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsA(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkPDirectory_GetNumberOfGenerationsFromBaseType_12(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkPDirectory* op = static_cast<vtkPDirectory*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBaseType(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkPDirectory_GetNumberOfGenerationsFromBase_13(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkPDirectory* op = static_cast<vtkPDirectory*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBase(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkPDirectory_Load_14(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  std::string temp0;
  bool   temp20;
  temp0 = vtkJavaUTF8ToString(env, id0, len0);

  vtkPDirectory* op = static_cast<vtkPDirectory*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->Load(temp0);
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkPDirectory_Open_15(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkPDirectory* op = static_cast<vtkPDirectory*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->Open(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkPDirectory_GetNumberOfFiles_16(JNIEnv* env, jobject obj)
{
  long long   temp20;

  vtkPDirectory* op = static_cast<vtkPDirectory*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfFiles();
  return temp20;

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkPDirectory_GetFile_17(JNIEnv* env, jobject obj,jlong id0)
{
  long long   temp0;
  const char * temp20;
  temp0 = id0;

  vtkPDirectory* op = static_cast<vtkPDirectory*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetFile(temp0);
  return (temp20 == nullptr) ? env->NewByteArray(0) : vtkJavaCharsToUTF8(env, temp20, strlen(temp20));

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkPDirectory_FileIsDirectory_18(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkPDirectory* op = static_cast<vtkPDirectory*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->FileIsDirectory(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkPDirectory_GetFiles_19(JNIEnv* env, jobject obj)
{
  vtkStringArray * temp20;

  vtkPDirectory* op = static_cast<vtkPDirectory*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetFiles();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkPDirectory_GetPath_110(JNIEnv* env, jobject obj)
{
  const char * temp20;

  vtkPDirectory* op = static_cast<vtkPDirectory*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetPath();
  return (temp20 == nullptr) ? env->NewByteArray(0) : vtkJavaCharsToUTF8(env, temp20, strlen(temp20));

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkPDirectory_Clear_111(JNIEnv* env, jobject obj)
{

  vtkPDirectory* op = static_cast<vtkPDirectory*>(vtkJavaGetPointerFromObject(env, obj));
  op->Clear();

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkPDirectory_GetCurrentWorkingDirectory_112(JNIEnv* env, jobject obj, jbyteArray id0, jint len0,jint id1)
{
  char * temp0;
   unsigned int   temp1;
  const char * temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);
  temp1 = id1;

  vtkPDirectory* op = static_cast<vtkPDirectory*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetCurrentWorkingDirectory(temp0,temp1);
  delete[] temp0;
  return (temp20 == nullptr) ? env->NewByteArray(0) : vtkJavaCharsToUTF8(env, temp20, strlen(temp20));

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkPDirectory_MakeDirectory_113(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkPDirectory* op = static_cast<vtkPDirectory*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->MakeDirectory(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkPDirectory_DeleteDirectory_114(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkPDirectory* op = static_cast<vtkPDirectory*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->DeleteDirectory(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkPDirectory_Rename_115(JNIEnv* env, jobject obj, jbyteArray id0, jint len0, jbyteArray id1, jint len1)
{
  char * temp0;
  char * temp1;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);
  temp1 = vtkJavaUTF8ToChars(env, id1, len1);

  vtkPDirectory* op = static_cast<vtkPDirectory*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->Rename(temp0,temp1);
  delete[] temp0;
  delete[] temp1;
  return temp20;

}

extern "C" JNIEXPORT jlong JNICALL Java_vtk_vtkPDirectory_VTKInit(JNIEnv*, jobject)
{
  return reinterpret_cast<jlong>(vtkPDirectory::New());
}
