// java wrapper for vtkImageInterpolator object
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkABI.h"
#include "vtkSystemIncludes.h"
#include "vtkImageInterpolator.h"
#include "vtkJavaUtil.h"

#include "vtkStdString.h"

#include <sstream>
extern "C" JNIEXPORT void* vtkAbstractImageInterpolator_Typecast(void* op,char* dType);

extern "C" JNIEXPORT void* vtkImageInterpolator_Typecast(void* me,char* dType)
{
  void* res;
  if (!strcmp("vtkImageInterpolator",dType)) { return me; }
  if ((res= vtkAbstractImageInterpolator_Typecast(me,dType)) != nullptr) { return res; }
  return nullptr;
}


extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkImageInterpolator_IsTypeOf_10(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkImageInterpolator* op = static_cast<vtkImageInterpolator*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsTypeOf(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkImageInterpolator_IsA_11(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkImageInterpolator* op = static_cast<vtkImageInterpolator*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsA(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkImageInterpolator_GetNumberOfGenerationsFromBaseType_12(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkImageInterpolator* op = static_cast<vtkImageInterpolator*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBaseType(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkImageInterpolator_GetNumberOfGenerationsFromBase_13(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkImageInterpolator* op = static_cast<vtkImageInterpolator*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBase(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImageInterpolator_SetInterpolationMode_14(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkImageInterpolator* op = static_cast<vtkImageInterpolator*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetInterpolationMode(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImageInterpolator_SetInterpolationModeToNearest_15(JNIEnv* env, jobject obj)
{

  vtkImageInterpolator* op = static_cast<vtkImageInterpolator*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetInterpolationModeToNearest();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImageInterpolator_SetInterpolationModeToLinear_16(JNIEnv* env, jobject obj)
{

  vtkImageInterpolator* op = static_cast<vtkImageInterpolator*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetInterpolationModeToLinear();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImageInterpolator_SetInterpolationModeToCubic_17(JNIEnv* env, jobject obj)
{

  vtkImageInterpolator* op = static_cast<vtkImageInterpolator*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetInterpolationModeToCubic();

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkImageInterpolator_GetInterpolationMode_18(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkImageInterpolator* op = static_cast<vtkImageInterpolator*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetInterpolationMode();
  return temp20;

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkImageInterpolator_GetInterpolationModeAsString_19(JNIEnv* env, jobject obj)
{
  const char * temp20;

  vtkImageInterpolator* op = static_cast<vtkImageInterpolator*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetInterpolationModeAsString();
  return (temp20 == nullptr) ? env->NewByteArray(0) : vtkJavaCharsToUTF8(env, temp20, strlen(temp20));

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImageInterpolator_ComputeSupportSize_110(JNIEnv* env, jobject obj,jdoubleArray id0,jintArray id1)
{
  double temp0[16];
  int temp1[3];
  env->GetDoubleArrayRegion(id0, 0, 16, &temp0[0]);
  env->GetIntArrayRegion(id1, 0, 3, reinterpret_cast<jint*>(&temp1[0]));

  vtkImageInterpolator* op = static_cast<vtkImageInterpolator*>(vtkJavaGetPointerFromObject(env, obj));
  op->ComputeSupportSize(temp0,temp1);
  env->SetIntArrayRegion(id1, 0, 3, reinterpret_cast<jint*>(&temp1[0]));

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkImageInterpolator_IsSeparable_111(JNIEnv* env, jobject obj)
{
  bool   temp20;

  vtkImageInterpolator* op = static_cast<vtkImageInterpolator*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsSeparable();
  return temp20;

}

extern "C" JNIEXPORT jlong JNICALL Java_vtk_vtkImageInterpolator_VTKInit(JNIEnv*, jobject)
{
  return reinterpret_cast<jlong>(vtkImageInterpolator::New());
}
