// java wrapper for vtkSignedDistance object
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkABI.h"
#include "vtkSystemIncludes.h"
#include "vtkSignedDistance.h"
#include "vtkJavaUtil.h"

#include "vtkStdString.h"

#include <sstream>
extern "C" JNIEXPORT void* vtkImageAlgorithm_Typecast(void* op,char* dType);

extern "C" JNIEXPORT void* vtkSignedDistance_Typecast(void* me,char* dType)
{
  void* res;
  if (!strcmp("vtkSignedDistance",dType)) { return me; }
  if ((res= vtkImageAlgorithm_Typecast(me,dType)) != nullptr) { return res; }
  return nullptr;
}


extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkSignedDistance_IsTypeOf_10(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkSignedDistance* op = static_cast<vtkSignedDistance*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsTypeOf(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkSignedDistance_IsA_11(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkSignedDistance* op = static_cast<vtkSignedDistance*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsA(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkSignedDistance_GetNumberOfGenerationsFromBaseType_12(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkSignedDistance* op = static_cast<vtkSignedDistance*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBaseType(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkSignedDistance_GetNumberOfGenerationsFromBase_13(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkSignedDistance* op = static_cast<vtkSignedDistance*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBase(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jintArray  JNICALL Java_vtk_vtkSignedDistance_GetDimensions_14(JNIEnv* env, jobject obj)
{
  int * temp20;

  vtkSignedDistance* op = static_cast<vtkSignedDistance*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetDimensions();
  return vtkJavaMakeJArrayOfInt(env, reinterpret_cast<jint*>(temp20), 3);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkSignedDistance_SetDimensions_15(JNIEnv* env, jobject obj,jint id0,jint id1,jint id2)
{
  int   temp0;
  int   temp1;
  int   temp2;
  temp0 = id0;
  temp1 = id1;
  temp2 = id2;

  vtkSignedDistance* op = static_cast<vtkSignedDistance*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetDimensions(temp0,temp1,temp2);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkSignedDistance_SetDimensions_16(JNIEnv* env, jobject obj,jintArray id0)
{
  int temp0[3];
  env->GetIntArrayRegion(id0, 0, 3, reinterpret_cast<jint*>(&temp0[0]));

  vtkSignedDistance* op = static_cast<vtkSignedDistance*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetDimensions(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkSignedDistance_SetBounds_17(JNIEnv* env, jobject obj,jdouble id0,jdouble id1,jdouble id2,jdouble id3,jdouble id4,jdouble id5)
{
  double   temp0;
  double   temp1;
  double   temp2;
  double   temp3;
  double   temp4;
  double   temp5;
  temp0 = id0;
  temp1 = id1;
  temp2 = id2;
  temp3 = id3;
  temp4 = id4;
  temp5 = id5;

  vtkSignedDistance* op = static_cast<vtkSignedDistance*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetBounds(temp0,temp1,temp2,temp3,temp4,temp5);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkSignedDistance_SetBounds_18(JNIEnv* env, jobject obj,jdoubleArray id0)
{
  double temp0[6];
  env->GetDoubleArrayRegion(id0, 0, 6, &temp0[0]);

  vtkSignedDistance* op = static_cast<vtkSignedDistance*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetBounds(temp0);

}

extern "C" JNIEXPORT jdoubleArray  JNICALL Java_vtk_vtkSignedDistance_GetBounds_19(JNIEnv* env, jobject obj)
{
  double * temp20;

  vtkSignedDistance* op = static_cast<vtkSignedDistance*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetBounds();
  return vtkJavaMakeJArrayOfDouble(env, temp20, 6);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkSignedDistance_SetRadius_110(JNIEnv* env, jobject obj,jdouble id0)
{
  double   temp0;
  temp0 = id0;

  vtkSignedDistance* op = static_cast<vtkSignedDistance*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetRadius(temp0);

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkSignedDistance_GetRadiusMinValue_111(JNIEnv* env, jobject obj)
{
  double   temp20;

  vtkSignedDistance* op = static_cast<vtkSignedDistance*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetRadiusMinValue();
  return temp20;

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkSignedDistance_GetRadiusMaxValue_112(JNIEnv* env, jobject obj)
{
  double   temp20;

  vtkSignedDistance* op = static_cast<vtkSignedDistance*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetRadiusMaxValue();
  return temp20;

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkSignedDistance_GetRadius_113(JNIEnv* env, jobject obj)
{
  double   temp20;

  vtkSignedDistance* op = static_cast<vtkSignedDistance*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetRadius();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkSignedDistance_SetLocator_114(JNIEnv* env, jobject obj,jobject id0)
{
  vtkAbstractPointLocator * temp0;
  temp0 = static_cast<vtkAbstractPointLocator*>(vtkJavaGetPointerFromObject(env, id0));

  vtkSignedDistance* op = static_cast<vtkSignedDistance*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetLocator(temp0);

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkSignedDistance_GetLocator_115(JNIEnv* env, jobject obj)
{
  vtkAbstractPointLocator * temp20;

  vtkSignedDistance* op = static_cast<vtkSignedDistance*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetLocator();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkSignedDistance_StartAppend_116(JNIEnv* env, jobject obj)
{

  vtkSignedDistance* op = static_cast<vtkSignedDistance*>(vtkJavaGetPointerFromObject(env, obj));
  op->StartAppend();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkSignedDistance_Append_117(JNIEnv* env, jobject obj,jobject id0)
{
  vtkPolyData * temp0;
  temp0 = static_cast<vtkPolyData*>(vtkJavaGetPointerFromObject(env, id0));

  vtkSignedDistance* op = static_cast<vtkSignedDistance*>(vtkJavaGetPointerFromObject(env, obj));
  op->Append(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkSignedDistance_EndAppend_118(JNIEnv* env, jobject obj)
{

  vtkSignedDistance* op = static_cast<vtkSignedDistance*>(vtkJavaGetPointerFromObject(env, obj));
  op->EndAppend();

}

extern "C" JNIEXPORT jlong JNICALL Java_vtk_vtkSignedDistance_VTKInit(JNIEnv*, jobject)
{
  return reinterpret_cast<jlong>(vtkSignedDistance::New());
}
