// java wrapper for vtkPlane object
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkABI.h"
#include "vtkSystemIncludes.h"
#include "vtkPlane.h"
#include "vtkJavaUtil.h"

#include "vtkStdString.h"

#include <sstream>
extern "C" JNIEXPORT void* vtkImplicitFunction_Typecast(void* op,char* dType);

extern "C" JNIEXPORT void* vtkPlane_Typecast(void* me,char* dType)
{
  void* res;
  if (!strcmp("vtkPlane",dType)) { return me; }
  if ((res= vtkImplicitFunction_Typecast(me,dType)) != nullptr) { return res; }
  return nullptr;
}


extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkPlane_IsTypeOf_10(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkPlane* op = static_cast<vtkPlane*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsTypeOf(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkPlane_IsA_11(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkPlane* op = static_cast<vtkPlane*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsA(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkPlane_GetNumberOfGenerationsFromBaseType_12(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkPlane* op = static_cast<vtkPlane*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBaseType(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkPlane_GetNumberOfGenerationsFromBase_13(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkPlane* op = static_cast<vtkPlane*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBase(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkPlane_EvaluateFunction_14(JNIEnv* env, jobject obj,jobject id0,jobject id1)
{
  vtkDataArray * temp0;
  vtkDataArray * temp1;
  temp0 = static_cast<vtkDataArray*>(vtkJavaGetPointerFromObject(env, id0));
  temp1 = static_cast<vtkDataArray*>(vtkJavaGetPointerFromObject(env, id1));

  vtkPlane* op = static_cast<vtkPlane*>(vtkJavaGetPointerFromObject(env, obj));
  op->EvaluateFunction(temp0,temp1);

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkPlane_EvaluateFunction_15(JNIEnv* env, jobject obj,jdoubleArray id0)
{
  double temp0[3];
  double   temp20;
  env->GetDoubleArrayRegion(id0, 0, 3, &temp0[0]);

  vtkPlane* op = static_cast<vtkPlane*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->EvaluateFunction(temp0);
  env->SetDoubleArrayRegion(id0, 0, 3, &temp0[0]);
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkPlane_EvaluateGradient_16(JNIEnv* env, jobject obj,jdoubleArray id0,jdoubleArray id1)
{
  double temp0[3];
  double temp1[3];
  env->GetDoubleArrayRegion(id0, 0, 3, &temp0[0]);
  env->GetDoubleArrayRegion(id1, 0, 3, &temp1[0]);

  vtkPlane* op = static_cast<vtkPlane*>(vtkJavaGetPointerFromObject(env, obj));
  op->EvaluateGradient(temp0,temp1);
  env->SetDoubleArrayRegion(id0, 0, 3, &temp0[0]);
  env->SetDoubleArrayRegion(id1, 0, 3, &temp1[0]);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkPlane_SetNormal_17(JNIEnv* env, jobject obj,jdouble id0,jdouble id1,jdouble id2)
{
  double   temp0;
  double   temp1;
  double   temp2;
  temp0 = id0;
  temp1 = id1;
  temp2 = id2;

  vtkPlane* op = static_cast<vtkPlane*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetNormal(temp0,temp1,temp2);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkPlane_SetNormal_18(JNIEnv* env, jobject obj,jdoubleArray id0)
{
  double temp0[3];
  env->GetDoubleArrayRegion(id0, 0, 3, &temp0[0]);

  vtkPlane* op = static_cast<vtkPlane*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetNormal(temp0);

}

extern "C" JNIEXPORT jdoubleArray  JNICALL Java_vtk_vtkPlane_GetNormal_19(JNIEnv* env, jobject obj)
{
  double * temp20;

  vtkPlane* op = static_cast<vtkPlane*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNormal();
  return vtkJavaMakeJArrayOfDouble(env, temp20, 3);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkPlane_SetOrigin_110(JNIEnv* env, jobject obj,jdouble id0,jdouble id1,jdouble id2)
{
  double   temp0;
  double   temp1;
  double   temp2;
  temp0 = id0;
  temp1 = id1;
  temp2 = id2;

  vtkPlane* op = static_cast<vtkPlane*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetOrigin(temp0,temp1,temp2);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkPlane_SetOrigin_111(JNIEnv* env, jobject obj,jdoubleArray id0)
{
  double temp0[3];
  env->GetDoubleArrayRegion(id0, 0, 3, &temp0[0]);

  vtkPlane* op = static_cast<vtkPlane*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetOrigin(temp0);

}

extern "C" JNIEXPORT jdoubleArray  JNICALL Java_vtk_vtkPlane_GetOrigin_112(JNIEnv* env, jobject obj)
{
  double * temp20;

  vtkPlane* op = static_cast<vtkPlane*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetOrigin();
  return vtkJavaMakeJArrayOfDouble(env, temp20, 3);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkPlane_SetOffset_113(JNIEnv* env, jobject obj,jdouble id0)
{
  double   temp0;
  temp0 = id0;

  vtkPlane* op = static_cast<vtkPlane*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetOffset(temp0);

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkPlane_GetOffset_114(JNIEnv* env, jobject obj)
{
  double   temp20;

  vtkPlane* op = static_cast<vtkPlane*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetOffset();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkPlane_SetAxisAligned_115(JNIEnv* env, jobject obj,jboolean id0)
{
  bool   temp0;
  temp0 = (id0 != 0) ? true : false;

  vtkPlane* op = static_cast<vtkPlane*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetAxisAligned(temp0);

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkPlane_GetAxisAligned_116(JNIEnv* env, jobject obj)
{
  bool   temp20;

  vtkPlane* op = static_cast<vtkPlane*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetAxisAligned();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkPlane_Push_117(JNIEnv* env, jobject obj,jdouble id0)
{
  double   temp0;
  temp0 = id0;

  vtkPlane* op = static_cast<vtkPlane*>(vtkJavaGetPointerFromObject(env, obj));
  op->Push(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkPlane_ProjectPoint_118(JNIEnv* env, jobject obj,jdoubleArray id0,jdoubleArray id1,jdoubleArray id2,jdoubleArray id3)
{
  double temp0[3];
  double temp1[3];
  double temp2[3];
  double temp3[3];
  env->GetDoubleArrayRegion(id0, 0, 3, &temp0[0]);
  env->GetDoubleArrayRegion(id1, 0, 3, &temp1[0]);
  env->GetDoubleArrayRegion(id2, 0, 3, &temp2[0]);
  env->GetDoubleArrayRegion(id3, 0, 3, &temp3[0]);

  vtkPlane* op = static_cast<vtkPlane*>(vtkJavaGetPointerFromObject(env, obj));
  op->ProjectPoint(temp0,temp1,temp2,temp3);
  env->SetDoubleArrayRegion(id3, 0, 3, &temp3[0]);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkPlane_ProjectPoint_119(JNIEnv* env, jobject obj,jdoubleArray id0,jdoubleArray id1)
{
  double temp0[3];
  double temp1[3];
  env->GetDoubleArrayRegion(id0, 0, 3, &temp0[0]);
  env->GetDoubleArrayRegion(id1, 0, 3, &temp1[0]);

  vtkPlane* op = static_cast<vtkPlane*>(vtkJavaGetPointerFromObject(env, obj));
  op->ProjectPoint(temp0,temp1);
  env->SetDoubleArrayRegion(id1, 0, 3, &temp1[0]);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkPlane_ProjectVector_120(JNIEnv* env, jobject obj,jdoubleArray id0,jdoubleArray id1,jdoubleArray id2,jdoubleArray id3)
{
  double temp0[3];
  double temp1[3];
  double temp2[3];
  double temp3[3];
  env->GetDoubleArrayRegion(id0, 0, 3, &temp0[0]);
  env->GetDoubleArrayRegion(id1, 0, 3, &temp1[0]);
  env->GetDoubleArrayRegion(id2, 0, 3, &temp2[0]);
  env->GetDoubleArrayRegion(id3, 0, 3, &temp3[0]);

  vtkPlane* op = static_cast<vtkPlane*>(vtkJavaGetPointerFromObject(env, obj));
  op->ProjectVector(temp0,temp1,temp2,temp3);
  env->SetDoubleArrayRegion(id3, 0, 3, &temp3[0]);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkPlane_ProjectVector_121(JNIEnv* env, jobject obj,jdoubleArray id0,jdoubleArray id1)
{
  double temp0[3];
  double temp1[3];
  env->GetDoubleArrayRegion(id0, 0, 3, &temp0[0]);
  env->GetDoubleArrayRegion(id1, 0, 3, &temp1[0]);

  vtkPlane* op = static_cast<vtkPlane*>(vtkJavaGetPointerFromObject(env, obj));
  op->ProjectVector(temp0,temp1);
  env->SetDoubleArrayRegion(id1, 0, 3, &temp1[0]);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkPlane_GeneralizedProjectPoint_122(JNIEnv* env, jobject obj,jdoubleArray id0,jdoubleArray id1,jdoubleArray id2,jdoubleArray id3)
{
  double temp0[3];
  double temp1[3];
  double temp2[3];
  double temp3[3];
  env->GetDoubleArrayRegion(id0, 0, 3, &temp0[0]);
  env->GetDoubleArrayRegion(id1, 0, 3, &temp1[0]);
  env->GetDoubleArrayRegion(id2, 0, 3, &temp2[0]);
  env->GetDoubleArrayRegion(id3, 0, 3, &temp3[0]);

  vtkPlane* op = static_cast<vtkPlane*>(vtkJavaGetPointerFromObject(env, obj));
  op->GeneralizedProjectPoint(temp0,temp1,temp2,temp3);
  env->SetDoubleArrayRegion(id3, 0, 3, &temp3[0]);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkPlane_GeneralizedProjectPoint_123(JNIEnv* env, jobject obj,jdoubleArray id0,jdoubleArray id1)
{
  double temp0[3];
  double temp1[3];
  env->GetDoubleArrayRegion(id0, 0, 3, &temp0[0]);
  env->GetDoubleArrayRegion(id1, 0, 3, &temp1[0]);

  vtkPlane* op = static_cast<vtkPlane*>(vtkJavaGetPointerFromObject(env, obj));
  op->GeneralizedProjectPoint(temp0,temp1);
  env->SetDoubleArrayRegion(id1, 0, 3, &temp1[0]);

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkPlane_Evaluate_124(JNIEnv* env, jobject obj,jdoubleArray id0,jdoubleArray id1,jdoubleArray id2)
{
  double temp0[3];
  double temp1[3];
  double temp2[3];
  double   temp20;
  env->GetDoubleArrayRegion(id0, 0, 3, &temp0[0]);
  env->GetDoubleArrayRegion(id1, 0, 3, &temp1[0]);
  env->GetDoubleArrayRegion(id2, 0, 3, &temp2[0]);

  vtkPlane* op = static_cast<vtkPlane*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->Evaluate(temp0,temp1,temp2);
  env->SetDoubleArrayRegion(id0, 0, 3, &temp0[0]);
  env->SetDoubleArrayRegion(id1, 0, 3, &temp1[0]);
  env->SetDoubleArrayRegion(id2, 0, 3, &temp2[0]);
  return temp20;

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkPlane_DistanceToPlane_125(JNIEnv* env, jobject obj,jdoubleArray id0,jdoubleArray id1,jdoubleArray id2)
{
  double temp0[3];
  double temp1[3];
  double temp2[3];
  double   temp20;
  env->GetDoubleArrayRegion(id0, 0, 3, &temp0[0]);
  env->GetDoubleArrayRegion(id1, 0, 3, &temp1[0]);
  env->GetDoubleArrayRegion(id2, 0, 3, &temp2[0]);

  vtkPlane* op = static_cast<vtkPlane*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->DistanceToPlane(temp0,temp1,temp2);
  env->SetDoubleArrayRegion(id0, 0, 3, &temp0[0]);
  env->SetDoubleArrayRegion(id1, 0, 3, &temp1[0]);
  env->SetDoubleArrayRegion(id2, 0, 3, &temp2[0]);
  return temp20;

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkPlane_DistanceToPlane_126(JNIEnv* env, jobject obj,jdoubleArray id0)
{
  double temp0[3];
  double   temp20;
  env->GetDoubleArrayRegion(id0, 0, 3, &temp0[0]);

  vtkPlane* op = static_cast<vtkPlane*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->DistanceToPlane(temp0);
  env->SetDoubleArrayRegion(id0, 0, 3, &temp0[0]);
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkPlane_IntersectWithFinitePlane_127(JNIEnv* env, jobject obj,jdoubleArray id0,jdoubleArray id1,jdoubleArray id2,jdoubleArray id3,jdoubleArray id4,jdoubleArray id5,jdoubleArray id6)
{
  double temp0[3];
  double temp1[3];
  double temp2[3];
  double temp3[3];
  double temp4[3];
  double temp5[3];
  double temp6[3];
  int   temp20;
  env->GetDoubleArrayRegion(id0, 0, 3, &temp0[0]);
  env->GetDoubleArrayRegion(id1, 0, 3, &temp1[0]);
  env->GetDoubleArrayRegion(id2, 0, 3, &temp2[0]);
  env->GetDoubleArrayRegion(id3, 0, 3, &temp3[0]);
  env->GetDoubleArrayRegion(id4, 0, 3, &temp4[0]);
  env->GetDoubleArrayRegion(id5, 0, 3, &temp5[0]);
  env->GetDoubleArrayRegion(id6, 0, 3, &temp6[0]);

  vtkPlane* op = static_cast<vtkPlane*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IntersectWithFinitePlane(temp0,temp1,temp2,temp3,temp4,temp5,temp6);
  env->SetDoubleArrayRegion(id0, 0, 3, &temp0[0]);
  env->SetDoubleArrayRegion(id1, 0, 3, &temp1[0]);
  env->SetDoubleArrayRegion(id2, 0, 3, &temp2[0]);
  env->SetDoubleArrayRegion(id3, 0, 3, &temp3[0]);
  env->SetDoubleArrayRegion(id4, 0, 3, &temp4[0]);
  env->SetDoubleArrayRegion(id5, 0, 3, &temp5[0]);
  env->SetDoubleArrayRegion(id6, 0, 3, &temp6[0]);
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkPlane_IntersectWithFinitePlane_128(JNIEnv* env, jobject obj,jdoubleArray id0,jdoubleArray id1,jdoubleArray id2,jdoubleArray id3,jdoubleArray id4)
{
  double temp0[3];
  double temp1[3];
  double temp2[3];
  double temp3[3];
  double temp4[3];
  int   temp20;
  env->GetDoubleArrayRegion(id0, 0, 3, &temp0[0]);
  env->GetDoubleArrayRegion(id1, 0, 3, &temp1[0]);
  env->GetDoubleArrayRegion(id2, 0, 3, &temp2[0]);
  env->GetDoubleArrayRegion(id3, 0, 3, &temp3[0]);
  env->GetDoubleArrayRegion(id4, 0, 3, &temp4[0]);

  vtkPlane* op = static_cast<vtkPlane*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IntersectWithFinitePlane(temp0,temp1,temp2,temp3,temp4);
  env->SetDoubleArrayRegion(id0, 0, 3, &temp0[0]);
  env->SetDoubleArrayRegion(id1, 0, 3, &temp1[0]);
  env->SetDoubleArrayRegion(id2, 0, 3, &temp2[0]);
  env->SetDoubleArrayRegion(id3, 0, 3, &temp3[0]);
  env->SetDoubleArrayRegion(id4, 0, 3, &temp4[0]);
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkPlane_DeepCopy_129(JNIEnv* env, jobject obj,jobject id0)
{
  vtkPlane * temp0;
  temp0 = static_cast<vtkPlane*>(vtkJavaGetPointerFromObject(env, id0));

  vtkPlane* op = static_cast<vtkPlane*>(vtkJavaGetPointerFromObject(env, obj));
  op->DeepCopy(temp0);

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkPlane_EvaluateFunction_130(JNIEnv* env, jobject obj,jdouble id0,jdouble id1,jdouble id2)
{
  double   temp0;
  double   temp1;
  double   temp2;
  double   temp20;
  temp0 = id0;
  temp1 = id1;
  temp2 = id2;

  vtkPlane* op = static_cast<vtkPlane*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->EvaluateFunction(temp0,temp1,temp2);
  return temp20;

}

extern "C" JNIEXPORT jlong JNICALL Java_vtk_vtkPlane_VTKInit(JNIEnv*, jobject)
{
  return reinterpret_cast<jlong>(vtkPlane::New());
}
