// java wrapper for vtkCellGrid object
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkABI.h"
#include "vtkSystemIncludes.h"
#include "vtkCellGrid.h"
#include "vtkJavaUtil.h"

#include "vtkStdString.h"

#include <sstream>
extern "C" JNIEXPORT void* vtkDataObject_Typecast(void* op,char* dType);

extern "C" JNIEXPORT void* vtkCellGrid_Typecast(void* me,char* dType)
{
  void* res;
  if (!strcmp("vtkCellGrid",dType)) { return me; }
  if ((res= vtkDataObject_Typecast(me,dType)) != nullptr) { return res; }
  return nullptr;
}


extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkCellGrid_IsTypeOf_10(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkCellGrid* op = static_cast<vtkCellGrid*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsTypeOf(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkCellGrid_IsA_11(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkCellGrid* op = static_cast<vtkCellGrid*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsA(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkCellGrid_GetNumberOfGenerationsFromBaseType_12(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkCellGrid* op = static_cast<vtkCellGrid*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBaseType(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkCellGrid_GetNumberOfGenerationsFromBase_13(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkCellGrid* op = static_cast<vtkCellGrid*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBase(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCellGrid_Initialize_14(JNIEnv* env, jobject obj)
{

  vtkCellGrid* op = static_cast<vtkCellGrid*>(vtkJavaGetPointerFromObject(env, obj));
  op->Initialize();

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkCellGrid_GetDataObjectType_15(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkCellGrid* op = static_cast<vtkCellGrid*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetDataObjectType();
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkCellGrid_GetActualMemorySize_16(JNIEnv* env, jobject obj)
{
   unsigned long   temp20;

  vtkCellGrid* op = static_cast<vtkCellGrid*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetActualMemorySize();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCellGrid_ShallowCopy_17(JNIEnv* env, jobject obj,jobject id0)
{
  vtkDataObject * temp0;
  temp0 = static_cast<vtkDataObject*>(vtkJavaGetPointerFromObject(env, id0));

  vtkCellGrid* op = static_cast<vtkCellGrid*>(vtkJavaGetPointerFromObject(env, obj));
  op->ShallowCopy(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCellGrid_DeepCopy_18(JNIEnv* env, jobject obj,jobject id0)
{
  vtkDataObject * temp0;
  temp0 = static_cast<vtkDataObject*>(vtkJavaGetPointerFromObject(env, id0));

  vtkCellGrid* op = static_cast<vtkCellGrid*>(vtkJavaGetPointerFromObject(env, obj));
  op->DeepCopy(temp0);

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkCellGrid_CopyStructure_19(JNIEnv* env, jobject obj,jobject id0,jboolean id1)
{
  vtkCellGrid * temp0;
  bool   temp1;
  bool   temp20;
  temp0 = static_cast<vtkCellGrid*>(vtkJavaGetPointerFromObject(env, id0));
  temp1 = (id1 != 0) ? true : false;

  vtkCellGrid* op = static_cast<vtkCellGrid*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->CopyStructure(temp0,temp1);
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkCellGrid_GetAttributes_110(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  vtkDataSetAttributes * temp20;
  temp0 = id0;

  vtkCellGrid* op = static_cast<vtkCellGrid*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetAttributes(temp0);
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkCellGrid_FindAttributes_111(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  vtkDataSetAttributes * temp20;
  temp0 = id0;

  vtkCellGrid* op = static_cast<vtkCellGrid*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->FindAttributes(temp0);
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkCellGrid_GetGhostArray_112(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  vtkUnsignedCharArray * temp20;
  temp0 = id0;

  vtkCellGrid* op = static_cast<vtkCellGrid*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetGhostArray(temp0);
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkCellGrid_SupportsGhostArray_113(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  bool   temp20;
  temp0 = id0;

  vtkCellGrid* op = static_cast<vtkCellGrid*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->SupportsGhostArray(temp0);
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkCellGrid_GetAttributeTypeForArray_114(JNIEnv* env, jobject obj,jobject id0)
{
  vtkAbstractArray * temp0;
  int   temp20;
  temp0 = static_cast<vtkAbstractArray*>(vtkJavaGetPointerFromObject(env, id0));

  vtkCellGrid* op = static_cast<vtkCellGrid*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetAttributeTypeForArray(temp0);
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkCellGrid_GetNumberOfElements_115(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  long long   temp20;
  temp0 = id0;

  vtkCellGrid* op = static_cast<vtkCellGrid*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfElements(temp0);
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkCellGrid_GetNumberOfCells_116(JNIEnv* env, jobject obj)
{
  long long   temp20;

  vtkCellGrid* op = static_cast<vtkCellGrid*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfCells();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCellGrid_GetBounds_117(JNIEnv* env, jobject obj,jdoubleArray id0)
{
  double temp0[6];
  env->GetDoubleArrayRegion(id0, 0, 6, &temp0[0]);

  vtkCellGrid* op = static_cast<vtkCellGrid*>(vtkJavaGetPointerFromObject(env, obj));
  op->GetBounds(temp0);
  env->SetDoubleArrayRegion(id0, 0, 6, &temp0[0]);

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkCellGrid_AddCellMetadata_118(JNIEnv* env, jobject obj,jobject id0)
{
  vtkCellMetadata * temp0;
  vtkCellMetadata * temp20;
  temp0 = static_cast<vtkCellMetadata*>(vtkJavaGetPointerFromObject(env, id0));

  vtkCellGrid* op = static_cast<vtkCellGrid*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->AddCellMetadata(temp0);
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkCellGrid_AddAllCellMetadata_119(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkCellGrid* op = static_cast<vtkCellGrid*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->AddAllCellMetadata();
  return temp20;

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkCellGrid_RemoveCellMetadata_120(JNIEnv* env, jobject obj,jobject id0)
{
  vtkCellMetadata * temp0;
  bool   temp20;
  temp0 = static_cast<vtkCellMetadata*>(vtkJavaGetPointerFromObject(env, id0));

  vtkCellGrid* op = static_cast<vtkCellGrid*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->RemoveCellMetadata(temp0);
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkCellGrid_RemoveUnusedCellMetadata_121(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkCellGrid* op = static_cast<vtkCellGrid*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->RemoveUnusedCellMetadata();
  return temp20;

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkCellGrid_AddCellAttribute_122(JNIEnv* env, jobject obj,jobject id0)
{
  vtkCellAttribute * temp0;
  bool   temp20;
  temp0 = static_cast<vtkCellAttribute*>(vtkJavaGetPointerFromObject(env, id0));

  vtkCellGrid* op = static_cast<vtkCellGrid*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->AddCellAttribute(temp0);
  return temp20;

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkCellGrid_RemoveCellAttribute_123(JNIEnv* env, jobject obj,jobject id0)
{
  vtkCellAttribute * temp0;
  bool   temp20;
  temp0 = static_cast<vtkCellAttribute*>(vtkJavaGetPointerFromObject(env, id0));

  vtkCellGrid* op = static_cast<vtkCellGrid*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->RemoveCellAttribute(temp0);
  return temp20;

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkCellGrid_GetCellAttributeRange_124(JNIEnv* env, jobject obj,jobject id0,jint id1,jdoubleArray id2,jboolean id3)
{
  vtkCellAttribute * temp0;
  int   temp1;
  double temp2[2];
  bool   temp3;
  bool   temp20;
  temp0 = static_cast<vtkCellAttribute*>(vtkJavaGetPointerFromObject(env, id0));
  temp1 = id1;
  env->GetDoubleArrayRegion(id2, 0, 2, &temp2[0]);
  temp3 = (id3 != 0) ? true : false;

  vtkCellGrid* op = static_cast<vtkCellGrid*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetCellAttributeRange(temp0,temp1,temp2,temp3);
  env->SetDoubleArrayRegion(id2, 0, 2, &temp2[0]);
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCellGrid_ClearRangeCache_125(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  std::string temp0;
  temp0 = vtkJavaUTF8ToString(env, id0, len0);

  vtkCellGrid* op = static_cast<vtkCellGrid*>(vtkJavaGetPointerFromObject(env, obj));
  op->ClearRangeCache(temp0);

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkCellGrid_GetCellAttributeById_126(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  vtkCellAttribute * temp20;
  temp0 = id0;

  vtkCellGrid* op = static_cast<vtkCellGrid*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetCellAttributeById(temp0);
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkCellGrid_GetCellAttributeByName_127(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  std::string temp0;
  vtkCellAttribute * temp20;
  temp0 = vtkJavaUTF8ToString(env, id0, len0);

  vtkCellGrid* op = static_cast<vtkCellGrid*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetCellAttributeByName(temp0);
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkCellGrid_GetShapeAttribute_128(JNIEnv* env, jobject obj)
{
  vtkCellAttribute * temp20;

  vtkCellGrid* op = static_cast<vtkCellGrid*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetShapeAttribute();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkCellGrid_SetShapeAttribute_129(JNIEnv* env, jobject obj,jobject id0)
{
  vtkCellAttribute * temp0;
  bool   temp20;
  temp0 = static_cast<vtkCellAttribute*>(vtkJavaGetPointerFromObject(env, id0));

  vtkCellGrid* op = static_cast<vtkCellGrid*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->SetShapeAttribute(temp0);
  return temp20;

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkCellGrid_Query_130(JNIEnv* env, jobject obj,jobject id0)
{
  vtkCellGridQuery * temp0;
  bool   temp20;
  temp0 = static_cast<vtkCellGridQuery*>(vtkJavaGetPointerFromObject(env, id0));

  vtkCellGrid* op = static_cast<vtkCellGrid*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->Query(temp0);
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkCellGrid_GetSchemaVersion_131(JNIEnv* env, jobject obj)
{
   unsigned int   temp20;

  vtkCellGrid* op = static_cast<vtkCellGrid*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetSchemaVersion();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCellGrid_SetContentVersion_132(JNIEnv* env, jobject obj,jint id0)
{
   unsigned int   temp0;
  temp0 = id0;

  vtkCellGrid* op = static_cast<vtkCellGrid*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetContentVersion(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkCellGrid_GetContentVersion_133(JNIEnv* env, jobject obj)
{
   unsigned int   temp20;

  vtkCellGrid* op = static_cast<vtkCellGrid*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetContentVersion();
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkCellGrid_GetData_134(JNIEnv* env, jobject obj,jobject id0)
{
  vtkInformation * temp0;
  vtkCellGrid * temp20;
  temp0 = static_cast<vtkInformation*>(vtkJavaGetPointerFromObject(env, id0));

  vtkCellGrid* op = static_cast<vtkCellGrid*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetData(temp0);
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkCellGrid_GetData_135(JNIEnv* env, jobject obj,jobject id0,jint id1)
{
  vtkInformationVector * temp0;
  int   temp1;
  vtkCellGrid * temp20;
  temp0 = static_cast<vtkInformationVector*>(vtkJavaGetPointerFromObject(env, id0));
  temp1 = id1;

  vtkCellGrid* op = static_cast<vtkCellGrid*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetData(temp0,temp1);
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkCellGrid_CorrespondingArray_136(JNIEnv* env, jobject obj,jobject id0,jobject id1,jobject id2)
{
  vtkCellGrid * temp0;
  vtkDataArray * temp1;
  vtkCellGrid * temp2;
  vtkDataArray * temp20;
  temp0 = static_cast<vtkCellGrid*>(vtkJavaGetPointerFromObject(env, id0));
  temp1 = static_cast<vtkDataArray*>(vtkJavaGetPointerFromObject(env, id1));
  temp2 = static_cast<vtkCellGrid*>(vtkJavaGetPointerFromObject(env, id2));

  vtkCellGrid* op = static_cast<vtkCellGrid*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->CorrespondingArray(temp0,temp1,temp2);
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkCellGrid_ARRAY_1GROUP_1IDS_137(JNIEnv* env, jobject obj)
{
  vtkInformationIntegerVectorKey * temp20;

  vtkCellGrid* op = static_cast<vtkCellGrid*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->ARRAY_GROUP_IDS();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jlong JNICALL Java_vtk_vtkCellGrid_VTKInit(JNIEnv*, jobject)
{
  return reinterpret_cast<jlong>(vtkCellGrid::New());
}
