// java wrapper for vtkDeserializer object
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkABI.h"
#include "vtkSystemIncludes.h"
#include "vtkDeserializer.h"
#include "vtkJavaUtil.h"

#include "vtkStdString.h"

#include <sstream>
extern "C" JNIEXPORT void* vtkObject_Typecast(void* op,char* dType);

extern "C" JNIEXPORT void* vtkDeserializer_Typecast(void* me,char* dType)
{
  void* res;
  if (!strcmp("vtkDeserializer",dType)) { return me; }
  if ((res= vtkObject_Typecast(me,dType)) != nullptr) { return res; }
  return nullptr;
}


extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkDeserializer_IsTypeOf_10(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkDeserializer* op = static_cast<vtkDeserializer*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsTypeOf(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkDeserializer_IsA_11(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkDeserializer* op = static_cast<vtkDeserializer*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsA(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkDeserializer_GetNumberOfGenerationsFromBaseType_12(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkDeserializer* op = static_cast<vtkDeserializer*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBaseType(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkDeserializer_GetNumberOfGenerationsFromBase_13(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkDeserializer* op = static_cast<vtkDeserializer*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBase(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkDeserializer_UnRegisterConstructor_14(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  std::string temp0;
  temp0 = vtkJavaUTF8ToString(env, id0, len0);

  vtkDeserializer* op = static_cast<vtkDeserializer*>(vtkJavaGetPointerFromObject(env, obj));
  op->UnRegisterConstructor(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkDeserializer_SetContext_15(JNIEnv* env, jobject obj,jobject id0)
{
  vtkMarshalContext * temp0;
  temp0 = static_cast<vtkMarshalContext*>(vtkJavaGetPointerFromObject(env, id0));

  vtkDeserializer* op = static_cast<vtkDeserializer*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetContext(temp0);

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkDeserializer_GetContext_16(JNIEnv* env, jobject obj)
{
  vtkMarshalContext * temp20;

  vtkDeserializer* op = static_cast<vtkDeserializer*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetContext();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkDeserializer_SetDeserializerLogVerbosity_17(JNIEnv* env, jobject obj,jint id0)
{
  vtkLogger::Verbosity   temp0;
  temp0 = static_cast<vtkLogger::Verbosity>(id0);

  vtkDeserializer* op = static_cast<vtkDeserializer*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetDeserializerLogVerbosity(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkDeserializer_GetDeserializerLogVerbosity_18(JNIEnv* env, jobject obj)
{
  vtkLogger::Verbosity   temp20;

  vtkDeserializer* op = static_cast<vtkDeserializer*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetDeserializerLogVerbosity();
  return static_cast<jint>(temp20);

}

extern "C" JNIEXPORT jlong JNICALL Java_vtk_vtkDeserializer_VTKInit(JNIEnv*, jobject)
{
  return reinterpret_cast<jlong>(vtkDeserializer::New());
}
