// python wrapper for vtkAvmeshReader
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkPythonArgs.h"
#include "vtkPythonOverload.h"
#include <cstddef>
#include <sstream>
#include "vtkVariant.h"
#include "vtkIndent.h"
#include "vtkAvmeshReader.h"

#if defined(PYTHON_PACKAGE)
#define PYTHON_PACKAGE_SCOPE PYTHON_PACKAGE "."
#else
#define PYTHON_PACKAGE_SCOPE
#endif

extern "C" { VTK_ABI_HIDDEN void PyVTKAddFile_vtkAvmeshReader(PyObject *dict); }
extern "C" { VTK_ABI_HIDDEN PyObject *PyvtkAvmeshReader_ClassNew(); }


static PyObject *
PyvtkAvmeshReader_IsTypeOf(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "IsTypeOf");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = vtkAvmeshReader::IsTypeOf(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkAvmeshReader_IsA(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "IsA");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkAvmeshReader *op = static_cast<vtkAvmeshReader *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = (ap.IsBound() ?
      op->IsA(temp0) :
      op->vtkAvmeshReader::IsA(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkAvmeshReader_SafeDownCast(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "SafeDownCast");

  vtkObjectBase *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkObjectBase"))
  {
    vtkAvmeshReader *tempr = vtkAvmeshReader::SafeDownCast(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkAvmeshReader_NewInstance(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "NewInstance");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkAvmeshReader *op = static_cast<vtkAvmeshReader *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    vtkAvmeshReader *tempr = (ap.IsBound() ?
      op->NewInstance() :
      op->vtkAvmeshReader::NewInstance());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
      if (result && PyVTKObject_Check(result))
      {
        PyVTKObject_GetObject(result)->UnRegister(nullptr);
        PyVTKObject_SetFlag(result, VTK_PYTHON_IGNORE_UNREGISTER, 1);
      }
    }
    else if (tempr != nullptr)
    {
      ap.DeleteVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkAvmeshReader_GetNumberOfGenerationsFromBaseType(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "GetNumberOfGenerationsFromBaseType");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = vtkAvmeshReader::GetNumberOfGenerationsFromBaseType(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkAvmeshReader_GetNumberOfGenerationsFromBase(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetNumberOfGenerationsFromBase");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkAvmeshReader *op = static_cast<vtkAvmeshReader *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = (ap.IsBound() ?
      op->GetNumberOfGenerationsFromBase(temp0) :
      op->vtkAvmeshReader::GetNumberOfGenerationsFromBase(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkAvmeshReader_SetFileName(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetFileName");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkAvmeshReader *op = static_cast<vtkAvmeshReader *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetFilePath(temp0))
  {
    if (ap.IsBound())
    {
      op->SetFileName(temp0);
    }
    else
    {
      op->vtkAvmeshReader::SetFileName(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkAvmeshReader_GetFileName(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetFileName");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkAvmeshReader *op = static_cast<vtkAvmeshReader *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    const char *tempr = (ap.IsBound() ?
      op->GetFileName() :
      op->vtkAvmeshReader::GetFileName());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkAvmeshReader_CanReadFile(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "CanReadFile");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkAvmeshReader *op = static_cast<vtkAvmeshReader *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetFilePath(temp0))
  {
    int tempr = (ap.IsBound() ?
      op->CanReadFile(temp0) :
      op->vtkAvmeshReader::CanReadFile(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkAvmeshReader_SetSurfaceOnly(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetSurfaceOnly");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkAvmeshReader *op = static_cast<vtkAvmeshReader *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetSurfaceOnly(temp0);
    }
    else
    {
      op->vtkAvmeshReader::SetSurfaceOnly(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkAvmeshReader_GetSurfaceOnly(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetSurfaceOnly");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkAvmeshReader *op = static_cast<vtkAvmeshReader *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = (ap.IsBound() ?
      op->GetSurfaceOnly() :
      op->vtkAvmeshReader::GetSurfaceOnly());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkAvmeshReader_SurfaceOnlyOn(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SurfaceOnlyOn");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkAvmeshReader *op = static_cast<vtkAvmeshReader *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->SurfaceOnlyOn();
    }
    else
    {
      op->vtkAvmeshReader::SurfaceOnlyOn();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkAvmeshReader_SurfaceOnlyOff(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SurfaceOnlyOff");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkAvmeshReader *op = static_cast<vtkAvmeshReader *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->SurfaceOnlyOff();
    }
    else
    {
      op->vtkAvmeshReader::SurfaceOnlyOff();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkAvmeshReader_SetBuildConnectivityIteratively(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetBuildConnectivityIteratively");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkAvmeshReader *op = static_cast<vtkAvmeshReader *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetBuildConnectivityIteratively(temp0);
    }
    else
    {
      op->vtkAvmeshReader::SetBuildConnectivityIteratively(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkAvmeshReader_GetBuildConnectivityIteratively(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetBuildConnectivityIteratively");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkAvmeshReader *op = static_cast<vtkAvmeshReader *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = (ap.IsBound() ?
      op->GetBuildConnectivityIteratively() :
      op->vtkAvmeshReader::GetBuildConnectivityIteratively());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkAvmeshReader_BuildConnectivityIterativelyOn(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "BuildConnectivityIterativelyOn");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkAvmeshReader *op = static_cast<vtkAvmeshReader *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->BuildConnectivityIterativelyOn();
    }
    else
    {
      op->vtkAvmeshReader::BuildConnectivityIterativelyOn();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkAvmeshReader_BuildConnectivityIterativelyOff(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "BuildConnectivityIterativelyOff");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkAvmeshReader *op = static_cast<vtkAvmeshReader *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->BuildConnectivityIterativelyOff();
    }
    else
    {
      op->vtkAvmeshReader::BuildConnectivityIterativelyOff();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}

static PyMethodDef PyvtkAvmeshReader_Methods[] = {
  {"IsTypeOf", PyvtkAvmeshReader_IsTypeOf, METH_VARARGS,
   "IsTypeOf(type:str) -> int\nC++: static vtkTypeBool IsTypeOf(const char *type)\n\nReturn 1 if this class type is the same type of (or a subclass\nof) the named class. Returns 0 otherwise. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"IsA", PyvtkAvmeshReader_IsA, METH_VARARGS,
   "IsA(self, type:str) -> int\nC++: vtkTypeBool IsA(const char *type) override;\n\nReturn 1 if this class is the same type of (or a subclass of) the\nnamed class. Returns 0 otherwise. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"SafeDownCast", PyvtkAvmeshReader_SafeDownCast, METH_VARARGS,
   "SafeDownCast(o:vtkObjectBase) -> vtkAvmeshReader\nC++: static vtkAvmeshReader *SafeDownCast(vtkObjectBase *o)\n\n"},
  {"NewInstance", PyvtkAvmeshReader_NewInstance, METH_VARARGS,
   "NewInstance(self) -> vtkAvmeshReader\nC++: vtkAvmeshReader *NewInstance()\n\n"},
  {"GetNumberOfGenerationsFromBaseType", PyvtkAvmeshReader_GetNumberOfGenerationsFromBaseType, METH_VARARGS,
   "GetNumberOfGenerationsFromBaseType(type:str) -> int\nC++: static vtkIdType GetNumberOfGenerationsFromBaseType(\n    const char *type)\n\nGiven a the name of a base class of this class type, return the\ndistance of inheritance between this class type and the named\nclass (how many generations of inheritance are there between this\nclass and the named class). If the named class is not in this\nclass's inheritance tree, return a negative value. Valid\nresponses will always be nonnegative. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"GetNumberOfGenerationsFromBase", PyvtkAvmeshReader_GetNumberOfGenerationsFromBase, METH_VARARGS,
   "GetNumberOfGenerationsFromBase(self, type:str) -> int\nC++: vtkIdType GetNumberOfGenerationsFromBase(const char *type)\n    override;\n\nGiven the name of a base class of this class type, return the\ndistance of inheritance between this class type and the named\nclass (how many generations of inheritance are there between this\nclass and the named class). If the named class is not in this\nclass's inheritance tree, return a negative value. Valid\nresponses will always be nonnegative. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"SetFileName", PyvtkAvmeshReader_SetFileName, METH_VARARGS,
   "SetFileName(self, arg:str) -> None\nC++: virtual void SetFileName(const char *arg)\n\n"},
  {"GetFileName", PyvtkAvmeshReader_GetFileName, METH_VARARGS,
   "GetFileName(self) -> str\nC++: virtual const char *GetFileName()\n\n"},
  {"CanReadFile", PyvtkAvmeshReader_CanReadFile, METH_VARARGS,
   "CanReadFile(self, filename:str) -> int\nC++: int CanReadFile(const char *filename)\n\n"},
  {"SetSurfaceOnly", PyvtkAvmeshReader_SetSurfaceOnly, METH_VARARGS,
   "SetSurfaceOnly(self, _arg:bool) -> None\nC++: virtual void SetSurfaceOnly(bool _arg)\n\n"},
  {"GetSurfaceOnly", PyvtkAvmeshReader_GetSurfaceOnly, METH_VARARGS,
   "GetSurfaceOnly(self) -> bool\nC++: virtual bool GetSurfaceOnly()\n\n"},
  {"SurfaceOnlyOn", PyvtkAvmeshReader_SurfaceOnlyOn, METH_VARARGS,
   "SurfaceOnlyOn(self) -> None\nC++: virtual void SurfaceOnlyOn()\n\n"},
  {"SurfaceOnlyOff", PyvtkAvmeshReader_SurfaceOnlyOff, METH_VARARGS,
   "SurfaceOnlyOff(self) -> None\nC++: virtual void SurfaceOnlyOff()\n\n"},
  {"SetBuildConnectivityIteratively", PyvtkAvmeshReader_SetBuildConnectivityIteratively, METH_VARARGS,
   "SetBuildConnectivityIteratively(self, _arg:bool) -> None\nC++: virtual void SetBuildConnectivityIteratively(bool _arg)\n\n"},
  {"GetBuildConnectivityIteratively", PyvtkAvmeshReader_GetBuildConnectivityIteratively, METH_VARARGS,
   "GetBuildConnectivityIteratively(self) -> bool\nC++: virtual bool GetBuildConnectivityIteratively()\n\n"},
  {"BuildConnectivityIterativelyOn", PyvtkAvmeshReader_BuildConnectivityIterativelyOn, METH_VARARGS,
   "BuildConnectivityIterativelyOn(self) -> None\nC++: virtual void BuildConnectivityIterativelyOn()\n\n"},
  {"BuildConnectivityIterativelyOff", PyvtkAvmeshReader_BuildConnectivityIterativelyOff, METH_VARARGS,
   "BuildConnectivityIterativelyOff(self) -> None\nC++: virtual void BuildConnectivityIterativelyOff()\n\n"},
  {nullptr, nullptr, 0, nullptr}
};

#if PY_VERSION_HEX >= 0x03070000
#define pystr(x) x
#else
#define pystr(x) const_cast<char*>(x)
#endif
static PyGetSetDef PyvtkAvmeshReader_GetSets[] = {
  PyVTKObject_GetSet[0],
  PyVTKObject_GetSet[1],
  {
    /*name=*/pystr("file_name"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkAvmeshReader_GetFileName(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkAvmeshReader_SetFileName(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkAvmeshReader_SetFileName(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetFileName/SetFileName\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("surface_only"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkAvmeshReader_GetSurfaceOnly(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkAvmeshReader_SetSurfaceOnly(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkAvmeshReader_SetSurfaceOnly(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetSurfaceOnly/SetSurfaceOnly\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("build_connectivity_iteratively"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkAvmeshReader_GetBuildConnectivityIteratively(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkAvmeshReader_SetBuildConnectivityIteratively(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkAvmeshReader_SetBuildConnectivityIteratively(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetBuildConnectivityIteratively/SetBuildConnectivityIteratively\n"),
    /*closure=*/nullptr,
  },
  { nullptr, nullptr, nullptr, nullptr, nullptr }
};
static const char *PyvtkAvmeshReader_Doc =
  "vtkAvmeshReader - Read an AVMESH file\n\n"
  "Superclass: vtkPartitionedDataSetCollectionAlgorithm\n\n"
  "Read in an AVMESH file as a partitioned dataset collection.  Can\n"
  "optionally read only surface (boundary) collections.\n\n"
  "AVMESH is the native unstructured mesh format for CREATE-AV Kestrel\n"
  "and Helios.  Formal documentation of the format is included in\n"
  "avmeshlib, which is available from\n"
  "https://github.com/DOD-HPCMP-CREATE/avmeshlib. However, this reader\n"
  "parses AVMESH files without using avmeshlib.\n\n";

#ifdef VTK_PYTHON_NEEDS_DEPRECATION_WARNING_SUPPRESSION
#pragma GCC diagnostic ignored "-Wdeprecated-declarations"
#endif

static PyTypeObject PyvtkAvmeshReader_Type = {
  PyVarObject_HEAD_INIT(&PyType_Type, 0)
  PYTHON_PACKAGE_SCOPE "vtkIOAvmesh.vtkAvmeshReader", // tp_name
  sizeof(PyVTKObject), // tp_basicsize
  0, // tp_itemsize
  PyVTKObject_Delete, // tp_dealloc
#if PY_VERSION_HEX >= 0x03080000
  0, // tp_vectorcall_offset
#else
  nullptr, // tp_print
#endif
  nullptr, // tp_getattr
  nullptr, // tp_setattr
  nullptr, // tp_compare
  PyVTKObject_Repr, // tp_repr
  nullptr, // tp_as_number
  nullptr, // tp_as_sequence
  nullptr, // tp_as_mapping
  nullptr, // tp_hash
  nullptr, // tp_call
  PyVTKObject_String, // tp_str
  PyObject_GenericGetAttr, // tp_getattro
  PyObject_GenericSetAttr, // tp_setattro
  &PyVTKObject_AsBuffer, // tp_as_buffer
  Py_TPFLAGS_DEFAULT|Py_TPFLAGS_HAVE_GC|Py_TPFLAGS_BASETYPE, // tp_flags
  PyvtkAvmeshReader_Doc, // tp_doc
  PyVTKObject_Traverse, // tp_traverse
  nullptr, // tp_clear
  nullptr, // tp_richcompare
  offsetof(PyVTKObject, vtk_weakreflist), // tp_weaklistoffset
  nullptr, // tp_iter
  nullptr, // tp_iternext
  nullptr, // tp_methods
  nullptr, // tp_members
  PyVTKObject_GetSet, // tp_getset
  nullptr, // tp_base
  nullptr, // tp_dict
  nullptr, // tp_descr_get
  nullptr, // tp_descr_set
  offsetof(PyVTKObject, vtk_dict), // tp_dictoffset
  PyVTKObject_Init, // tp_init
  nullptr, // tp_alloc
  PyVTKObject_New, // tp_new
  PyObject_GC_Del, // tp_free
  nullptr, // tp_is_gc
  nullptr, // tp_bases
  nullptr, // tp_mro
  nullptr, // tp_cache
  nullptr, // tp_subclasses
  nullptr, // tp_weaklist
  VTK_WRAP_PYTHON_SUPPRESS_UNINITIALIZED
};

static vtkObjectBase *PyvtkAvmeshReader_StaticNew()
{
  return vtkAvmeshReader::New();
}

PyObject *PyvtkAvmeshReader_ClassNew()
{
  PyTypeObject *pytype = PyVTKClass_Add(
    &PyvtkAvmeshReader_Type, PyvtkAvmeshReader_Methods,
    "vtkAvmeshReader",
 &PyvtkAvmeshReader_StaticNew);

  if ((PyType_GetFlags(pytype) & Py_TPFLAGS_READY) != 0)
  {
    return (PyObject *)pytype;
  }

  pytype->tp_base = vtkPythonUtil::FindBaseTypeObject("vtkPartitionedDataSetCollectionAlgorithm");

  PyVTKClass_AddCombinedGetSetDefinitions(pytype, PyvtkAvmeshReader_GetSets);
  PyType_Ready(pytype);
  return (PyObject *)pytype;
}

void PyVTKAddFile_vtkAvmeshReader(
  PyObject *dict)
{
  PyObject *o;
  o = PyvtkAvmeshReader_ClassNew();

  if (o && PyDict_SetItemString(dict, "vtkAvmeshReader", o) != 0)
  {
    Py_DECREF(o);
  }

}

