// java wrapper for vtkRenderView object
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkABI.h"
#include "vtkSystemIncludes.h"
#include "vtkRenderView.h"
#include "vtkJavaUtil.h"

#include "vtkStdString.h"

#include <sstream>
extern "C" JNIEXPORT void* vtkRenderViewBase_Typecast(void* op,char* dType);

extern "C" JNIEXPORT void* vtkRenderView_Typecast(void* me,char* dType)
{
  void* res;
  if (!strcmp("vtkRenderView",dType)) { return me; }
  if ((res= vtkRenderViewBase_Typecast(me,dType)) != nullptr) { return res; }
  return nullptr;
}


extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkRenderView_IsTypeOf_10(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkRenderView* op = static_cast<vtkRenderView*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsTypeOf(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkRenderView_IsA_11(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkRenderView* op = static_cast<vtkRenderView*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsA(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkRenderView_GetNumberOfGenerationsFromBaseType_12(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkRenderView* op = static_cast<vtkRenderView*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBaseType(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkRenderView_GetNumberOfGenerationsFromBase_13(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkRenderView* op = static_cast<vtkRenderView*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBase(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkRenderView_SetInteractor_14(JNIEnv* env, jobject obj,jobject id0)
{
  vtkRenderWindowInteractor * temp0;
  temp0 = static_cast<vtkRenderWindowInteractor*>(vtkJavaGetPointerFromObject(env, id0));

  vtkRenderView* op = static_cast<vtkRenderView*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetInteractor(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkRenderView_SetInteractorStyle_15(JNIEnv* env, jobject obj,jobject id0)
{
  vtkInteractorObserver * temp0;
  temp0 = static_cast<vtkInteractorObserver*>(vtkJavaGetPointerFromObject(env, id0));

  vtkRenderView* op = static_cast<vtkRenderView*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetInteractorStyle(temp0);

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkRenderView_GetInteractorStyle_16(JNIEnv* env, jobject obj)
{
  vtkInteractorObserver * temp20;

  vtkRenderView* op = static_cast<vtkRenderView*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetInteractorStyle();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkRenderView_SetRenderWindow_17(JNIEnv* env, jobject obj,jobject id0)
{
  vtkRenderWindow * temp0;
  temp0 = static_cast<vtkRenderWindow*>(vtkJavaGetPointerFromObject(env, id0));

  vtkRenderView* op = static_cast<vtkRenderView*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetRenderWindow(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkRenderView_SetInteractionMode_18(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkRenderView* op = static_cast<vtkRenderView*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetInteractionMode(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkRenderView_GetInteractionMode_19(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkRenderView* op = static_cast<vtkRenderView*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetInteractionMode();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkRenderView_SetInteractionModeTo2D_110(JNIEnv* env, jobject obj)
{

  vtkRenderView* op = static_cast<vtkRenderView*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetInteractionModeTo2D();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkRenderView_SetInteractionModeTo3D_111(JNIEnv* env, jobject obj)
{

  vtkRenderView* op = static_cast<vtkRenderView*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetInteractionModeTo3D();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkRenderView_Render_112(JNIEnv* env, jobject obj)
{

  vtkRenderView* op = static_cast<vtkRenderView*>(vtkJavaGetPointerFromObject(env, obj));
  op->Render();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkRenderView_ApplyViewTheme_113(JNIEnv* env, jobject obj,jobject id0)
{
  vtkViewTheme * temp0;
  temp0 = static_cast<vtkViewTheme*>(vtkJavaGetPointerFromObject(env, id0));

  vtkRenderView* op = static_cast<vtkRenderView*>(vtkJavaGetPointerFromObject(env, obj));
  op->ApplyViewTheme(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkRenderView_SetTransform_114(JNIEnv* env, jobject obj,jobject id0)
{
  vtkAbstractTransform * temp0;
  temp0 = static_cast<vtkAbstractTransform*>(vtkJavaGetPointerFromObject(env, id0));

  vtkRenderView* op = static_cast<vtkRenderView*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetTransform(temp0);

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkRenderView_GetTransform_115(JNIEnv* env, jobject obj)
{
  vtkAbstractTransform * temp20;

  vtkRenderView* op = static_cast<vtkRenderView*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetTransform();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkRenderView_SetDisplayHoverText_116(JNIEnv* env, jobject obj,jboolean id0)
{
  bool   temp0;
  temp0 = (id0 != 0) ? true : false;

  vtkRenderView* op = static_cast<vtkRenderView*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetDisplayHoverText(temp0);

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkRenderView_GetDisplayHoverText_117(JNIEnv* env, jobject obj)
{
  bool   temp20;

  vtkRenderView* op = static_cast<vtkRenderView*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetDisplayHoverText();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkRenderView_DisplayHoverTextOn_118(JNIEnv* env, jobject obj)
{

  vtkRenderView* op = static_cast<vtkRenderView*>(vtkJavaGetPointerFromObject(env, obj));
  op->DisplayHoverTextOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkRenderView_DisplayHoverTextOff_119(JNIEnv* env, jobject obj)
{

  vtkRenderView* op = static_cast<vtkRenderView*>(vtkJavaGetPointerFromObject(env, obj));
  op->DisplayHoverTextOff();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkRenderView_SetSelectionMode_120(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkRenderView* op = static_cast<vtkRenderView*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetSelectionMode(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkRenderView_GetSelectionModeMinValue_121(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkRenderView* op = static_cast<vtkRenderView*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetSelectionModeMinValue();
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkRenderView_GetSelectionModeMaxValue_122(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkRenderView* op = static_cast<vtkRenderView*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetSelectionModeMaxValue();
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkRenderView_GetSelectionMode_123(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkRenderView* op = static_cast<vtkRenderView*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetSelectionMode();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkRenderView_SetSelectionModeToSurface_124(JNIEnv* env, jobject obj)
{

  vtkRenderView* op = static_cast<vtkRenderView*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetSelectionModeToSurface();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkRenderView_SetSelectionModeToFrustum_125(JNIEnv* env, jobject obj)
{

  vtkRenderView* op = static_cast<vtkRenderView*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetSelectionModeToFrustum();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkRenderView_AddLabels_126(JNIEnv* env, jobject obj,jobject id0)
{
  vtkAlgorithmOutput * temp0;
  temp0 = static_cast<vtkAlgorithmOutput*>(vtkJavaGetPointerFromObject(env, id0));

  vtkRenderView* op = static_cast<vtkRenderView*>(vtkJavaGetPointerFromObject(env, obj));
  op->AddLabels(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkRenderView_RemoveLabels_127(JNIEnv* env, jobject obj,jobject id0)
{
  vtkAlgorithmOutput * temp0;
  temp0 = static_cast<vtkAlgorithmOutput*>(vtkJavaGetPointerFromObject(env, id0));

  vtkRenderView* op = static_cast<vtkRenderView*>(vtkJavaGetPointerFromObject(env, obj));
  op->RemoveLabels(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkRenderView_SetIconTexture_128(JNIEnv* env, jobject obj,jobject id0)
{
  vtkTexture * temp0;
  temp0 = static_cast<vtkTexture*>(vtkJavaGetPointerFromObject(env, id0));

  vtkRenderView* op = static_cast<vtkRenderView*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetIconTexture(temp0);

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkRenderView_GetIconTexture_129(JNIEnv* env, jobject obj)
{
  vtkTexture * temp20;

  vtkRenderView* op = static_cast<vtkRenderView*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetIconTexture();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkRenderView_SetIconSize_130(JNIEnv* env, jobject obj,jint id0,jint id1)
{
  int   temp0;
  int   temp1;
  temp0 = id0;
  temp1 = id1;

  vtkRenderView* op = static_cast<vtkRenderView*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetIconSize(temp0,temp1);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkRenderView_SetIconSize_131(JNIEnv* env, jobject obj,jintArray id0)
{
  int temp0[2];
  env->GetIntArrayRegion(id0, 0, 2, reinterpret_cast<jint*>(&temp0[0]));

  vtkRenderView* op = static_cast<vtkRenderView*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetIconSize(temp0);

}

extern "C" JNIEXPORT jintArray  JNICALL Java_vtk_vtkRenderView_GetIconSize_132(JNIEnv* env, jobject obj)
{
  int * temp20;

  vtkRenderView* op = static_cast<vtkRenderView*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetIconSize();
  return vtkJavaMakeJArrayOfInt(env, reinterpret_cast<jint*>(temp20), 2);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkRenderView_SetDisplaySize_133(JNIEnv* env, jobject obj,jint id0,jint id1)
{
  int   temp0;
  int   temp1;
  temp0 = id0;
  temp1 = id1;

  vtkRenderView* op = static_cast<vtkRenderView*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetDisplaySize(temp0,temp1);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkRenderView_SetDisplaySize_134(JNIEnv* env, jobject obj,jintArray id0)
{
  int temp0[2];
  env->GetIntArrayRegion(id0, 0, 2, reinterpret_cast<jint*>(&temp0[0]));

  vtkRenderView* op = static_cast<vtkRenderView*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetDisplaySize(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkRenderView_SetLabelPlacementMode_135(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkRenderView* op = static_cast<vtkRenderView*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetLabelPlacementMode(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkRenderView_GetLabelPlacementMode_136(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkRenderView* op = static_cast<vtkRenderView*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetLabelPlacementMode();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkRenderView_SetLabelPlacementModeToNoOverlap_137(JNIEnv* env, jobject obj)
{

  vtkRenderView* op = static_cast<vtkRenderView*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetLabelPlacementModeToNoOverlap();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkRenderView_SetLabelPlacementModeToAll_138(JNIEnv* env, jobject obj)
{

  vtkRenderView* op = static_cast<vtkRenderView*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetLabelPlacementModeToAll();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkRenderView_SetLabelRenderMode_139(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkRenderView* op = static_cast<vtkRenderView*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetLabelRenderMode(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkRenderView_GetLabelRenderMode_140(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkRenderView* op = static_cast<vtkRenderView*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetLabelRenderMode();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkRenderView_SetLabelRenderModeToFreetype_141(JNIEnv* env, jobject obj)
{

  vtkRenderView* op = static_cast<vtkRenderView*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetLabelRenderModeToFreetype();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkRenderView_SetLabelRenderModeToQt_142(JNIEnv* env, jobject obj)
{

  vtkRenderView* op = static_cast<vtkRenderView*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetLabelRenderModeToQt();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkRenderView_SetRenderOnMouseMove_143(JNIEnv* env, jobject obj,jboolean id0)
{
  bool   temp0;
  temp0 = (id0 != 0) ? true : false;

  vtkRenderView* op = static_cast<vtkRenderView*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetRenderOnMouseMove(temp0);

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkRenderView_GetRenderOnMouseMove_144(JNIEnv* env, jobject obj)
{
  bool   temp20;

  vtkRenderView* op = static_cast<vtkRenderView*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetRenderOnMouseMove();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkRenderView_RenderOnMouseMoveOn_145(JNIEnv* env, jobject obj)
{

  vtkRenderView* op = static_cast<vtkRenderView*>(vtkJavaGetPointerFromObject(env, obj));
  op->RenderOnMouseMoveOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkRenderView_RenderOnMouseMoveOff_146(JNIEnv* env, jobject obj)
{

  vtkRenderView* op = static_cast<vtkRenderView*>(vtkJavaGetPointerFromObject(env, obj));
  op->RenderOnMouseMoveOff();

}

extern "C" JNIEXPORT jlong JNICALL Java_vtk_vtkRenderView_VTKInit(JNIEnv*, jobject)
{
  return reinterpret_cast<jlong>(vtkRenderView::New());
}
