// java wrapper for vtkShaderProgram object
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkABI.h"
#include "vtkSystemIncludes.h"
#include "vtkShaderProgram.h"
#include "vtkJavaUtil.h"

#include "vtkStdString.h"

#include <sstream>
extern "C" JNIEXPORT void* vtkObject_Typecast(void* op,char* dType);

extern "C" JNIEXPORT void* vtkShaderProgram_Typecast(void* me,char* dType)
{
  void* res;
  if (!strcmp("vtkShaderProgram",dType)) { return me; }
  if ((res= vtkObject_Typecast(me,dType)) != nullptr) { return res; }
  return nullptr;
}


extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkShaderProgram_IsTypeOf_10(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkShaderProgram* op = static_cast<vtkShaderProgram*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsTypeOf(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkShaderProgram_IsA_11(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkShaderProgram* op = static_cast<vtkShaderProgram*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsA(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkShaderProgram_GetNumberOfGenerationsFromBaseType_12(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkShaderProgram* op = static_cast<vtkShaderProgram*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBaseType(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkShaderProgram_GetNumberOfGenerationsFromBase_13(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkShaderProgram* op = static_cast<vtkShaderProgram*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBase(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkShaderProgram_GetVertexShader_14(JNIEnv* env, jobject obj)
{
  vtkShader * temp20;

  vtkShaderProgram* op = static_cast<vtkShaderProgram*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetVertexShader();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkShaderProgram_SetVertexShader_15(JNIEnv* env, jobject obj,jobject id0)
{
  vtkShader * temp0;
  temp0 = static_cast<vtkShader*>(vtkJavaGetPointerFromObject(env, id0));

  vtkShaderProgram* op = static_cast<vtkShaderProgram*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetVertexShader(temp0);

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkShaderProgram_GetFragmentShader_16(JNIEnv* env, jobject obj)
{
  vtkShader * temp20;

  vtkShaderProgram* op = static_cast<vtkShaderProgram*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetFragmentShader();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkShaderProgram_SetFragmentShader_17(JNIEnv* env, jobject obj,jobject id0)
{
  vtkShader * temp0;
  temp0 = static_cast<vtkShader*>(vtkJavaGetPointerFromObject(env, id0));

  vtkShaderProgram* op = static_cast<vtkShaderProgram*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetFragmentShader(temp0);

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkShaderProgram_GetGeometryShader_18(JNIEnv* env, jobject obj)
{
  vtkShader * temp20;

  vtkShaderProgram* op = static_cast<vtkShaderProgram*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetGeometryShader();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkShaderProgram_SetGeometryShader_19(JNIEnv* env, jobject obj,jobject id0)
{
  vtkShader * temp0;
  temp0 = static_cast<vtkShader*>(vtkJavaGetPointerFromObject(env, id0));

  vtkShaderProgram* op = static_cast<vtkShaderProgram*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetGeometryShader(temp0);

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkShaderProgram_GetComputeShader_110(JNIEnv* env, jobject obj)
{
  vtkShader * temp20;

  vtkShaderProgram* op = static_cast<vtkShaderProgram*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetComputeShader();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkShaderProgram_SetComputeShader_111(JNIEnv* env, jobject obj,jobject id0)
{
  vtkShader * temp0;
  temp0 = static_cast<vtkShader*>(vtkJavaGetPointerFromObject(env, id0));

  vtkShaderProgram* op = static_cast<vtkShaderProgram*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetComputeShader(temp0);

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkShaderProgram_GetTessControlShader_112(JNIEnv* env, jobject obj)
{
  vtkShader * temp20;

  vtkShaderProgram* op = static_cast<vtkShaderProgram*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetTessControlShader();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkShaderProgram_SetTessControlShader_113(JNIEnv* env, jobject obj,jobject id0)
{
  vtkShader * temp0;
  temp0 = static_cast<vtkShader*>(vtkJavaGetPointerFromObject(env, id0));

  vtkShaderProgram* op = static_cast<vtkShaderProgram*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetTessControlShader(temp0);

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkShaderProgram_GetTessEvaluationShader_114(JNIEnv* env, jobject obj)
{
  vtkShader * temp20;

  vtkShaderProgram* op = static_cast<vtkShaderProgram*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetTessEvaluationShader();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkShaderProgram_SetTessEvaluationShader_115(JNIEnv* env, jobject obj,jobject id0)
{
  vtkShader * temp0;
  temp0 = static_cast<vtkShader*>(vtkJavaGetPointerFromObject(env, id0));

  vtkShaderProgram* op = static_cast<vtkShaderProgram*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetTessEvaluationShader(temp0);

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkShaderProgram_GetTransformFeedback_116(JNIEnv* env, jobject obj)
{
  vtkTransformFeedback * temp20;

  vtkShaderProgram* op = static_cast<vtkShaderProgram*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetTransformFeedback();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkShaderProgram_SetTransformFeedback_117(JNIEnv* env, jobject obj,jobject id0)
{
  vtkTransformFeedback * temp0;
  temp0 = static_cast<vtkTransformFeedback*>(vtkJavaGetPointerFromObject(env, id0));

  vtkShaderProgram* op = static_cast<vtkShaderProgram*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetTransformFeedback(temp0);

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkShaderProgram_GetCompiled_118(JNIEnv* env, jobject obj)
{
  bool   temp20;

  vtkShaderProgram* op = static_cast<vtkShaderProgram*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetCompiled();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkShaderProgram_SetCompiled_119(JNIEnv* env, jobject obj,jboolean id0)
{
  bool   temp0;
  temp0 = (id0 != 0) ? true : false;

  vtkShaderProgram* op = static_cast<vtkShaderProgram*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetCompiled(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkShaderProgram_CompiledOn_120(JNIEnv* env, jobject obj)
{

  vtkShaderProgram* op = static_cast<vtkShaderProgram*>(vtkJavaGetPointerFromObject(env, obj));
  op->CompiledOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkShaderProgram_CompiledOff_121(JNIEnv* env, jobject obj)
{

  vtkShaderProgram* op = static_cast<vtkShaderProgram*>(vtkJavaGetPointerFromObject(env, obj));
  op->CompiledOff();

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkShaderProgram_GetMD5Hash_122(JNIEnv* env, jobject obj)
{
  std::string   temp20;

  vtkShaderProgram* op = static_cast<vtkShaderProgram*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetMD5Hash();
  return vtkJavaStringToUTF8(env, temp20);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkShaderProgram_SetMD5Hash_123(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  std::string temp0;
  temp0 = vtkJavaUTF8ToString(env, id0, len0);

  vtkShaderProgram* op = static_cast<vtkShaderProgram*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetMD5Hash(temp0);

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkShaderProgram_isBound_124(JNIEnv* env, jobject obj)
{
  bool   temp20;

  vtkShaderProgram* op = static_cast<vtkShaderProgram*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->isBound();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkShaderProgram_ReleaseGraphicsResources_125(JNIEnv* env, jobject obj,jobject id0)
{
  vtkWindow * temp0;
  temp0 = static_cast<vtkWindow*>(vtkJavaGetPointerFromObject(env, id0));

  vtkShaderProgram* op = static_cast<vtkShaderProgram*>(vtkJavaGetPointerFromObject(env, obj));
  op->ReleaseGraphicsResources(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkShaderProgram_GetHandle_126(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkShaderProgram* op = static_cast<vtkShaderProgram*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetHandle();
  return temp20;

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkShaderProgram_GetError_127(JNIEnv* env, jobject obj)
{
  std::string   temp20;

  vtkShaderProgram* op = static_cast<vtkShaderProgram*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetError();
  return vtkJavaStringToUTF8(env, temp20);

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkShaderProgram_EnableAttributeArray_128(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  bool   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkShaderProgram* op = static_cast<vtkShaderProgram*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->EnableAttributeArray(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkShaderProgram_DisableAttributeArray_129(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  bool   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkShaderProgram* op = static_cast<vtkShaderProgram*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->DisableAttributeArray(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkShaderProgram_SetUniformi_130(JNIEnv* env, jobject obj, jbyteArray id0, jint len0,jint id1)
{
  char * temp0;
  int   temp1;
  bool   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);
  temp1 = id1;

  vtkShaderProgram* op = static_cast<vtkShaderProgram*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->SetUniformi(temp0,temp1);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkShaderProgram_SetUniformf_131(JNIEnv* env, jobject obj, jbyteArray id0, jint len0,jfloat id1)
{
  char * temp0;
  float   temp1;
  bool   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);
  temp1 = id1;

  vtkShaderProgram* op = static_cast<vtkShaderProgram*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->SetUniformf(temp0,temp1);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkShaderProgram_SetUniform2i_132(JNIEnv* env, jobject obj, jbyteArray id0, jint len0,jintArray id1)
{
  char * temp0;
  int temp1[2];
  bool   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);
  env->GetIntArrayRegion(id1, 0, 2, reinterpret_cast<jint*>(&temp1[0]));

  vtkShaderProgram* op = static_cast<vtkShaderProgram*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->SetUniform2i(temp0,temp1);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkShaderProgram_SetUniform2f_133(JNIEnv* env, jobject obj, jbyteArray id0, jint len0,jfloatArray id1)
{
  char * temp0;
  float temp1[2];
  bool   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);
  env->GetFloatArrayRegion(id1, 0, 2, &temp1[0]);

  vtkShaderProgram* op = static_cast<vtkShaderProgram*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->SetUniform2f(temp0,temp1);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkShaderProgram_SetUniform3f_134(JNIEnv* env, jobject obj, jbyteArray id0, jint len0,jfloatArray id1)
{
  char * temp0;
  float temp1[3];
  bool   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);
  env->GetFloatArrayRegion(id1, 0, 3, &temp1[0]);

  vtkShaderProgram* op = static_cast<vtkShaderProgram*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->SetUniform3f(temp0,temp1);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkShaderProgram_SetUniform3f_135(JNIEnv* env, jobject obj, jbyteArray id0, jint len0,jdoubleArray id1)
{
  char * temp0;
  double temp1[3];
  bool   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);
  env->GetDoubleArrayRegion(id1, 0, 3, &temp1[0]);

  vtkShaderProgram* op = static_cast<vtkShaderProgram*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->SetUniform3f(temp0,temp1);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkShaderProgram_SetUniform4f_136(JNIEnv* env, jobject obj, jbyteArray id0, jint len0,jfloatArray id1)
{
  char * temp0;
  float temp1[4];
  bool   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);
  env->GetFloatArrayRegion(id1, 0, 4, &temp1[0]);

  vtkShaderProgram* op = static_cast<vtkShaderProgram*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->SetUniform4f(temp0,temp1);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkShaderProgram_SetUniformMatrix_137(JNIEnv* env, jobject obj, jbyteArray id0, jint len0,jobject id1)
{
  char * temp0;
  vtkMatrix3x3 * temp1;
  bool   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);
  temp1 = static_cast<vtkMatrix3x3*>(vtkJavaGetPointerFromObject(env, id1));

  vtkShaderProgram* op = static_cast<vtkShaderProgram*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->SetUniformMatrix(temp0,temp1);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkShaderProgram_SetUniformMatrix_138(JNIEnv* env, jobject obj, jbyteArray id0, jint len0,jobject id1)
{
  char * temp0;
  vtkMatrix4x4 * temp1;
  bool   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);
  temp1 = static_cast<vtkMatrix4x4*>(vtkJavaGetPointerFromObject(env, id1));

  vtkShaderProgram* op = static_cast<vtkShaderProgram*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->SetUniformMatrix(temp0,temp1);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkShaderProgram_SetNumberOfOutputs_139(JNIEnv* env, jobject obj,jint id0)
{
   unsigned int   temp0;
  temp0 = id0;

  vtkShaderProgram* op = static_cast<vtkShaderProgram*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetNumberOfOutputs(temp0);

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkShaderProgram_Substitute_140(JNIEnv* env, jobject obj, jbyteArray id0, jint len0, jbyteArray id1, jint len1, jbyteArray id2, jint len2,jboolean id3)
{
  std::string temp0;
  std::string temp1;
  std::string temp2;
  bool   temp3;
  bool   temp20;
  temp0 = vtkJavaUTF8ToString(env, id0, len0);
  temp1 = vtkJavaUTF8ToString(env, id1, len1);
  temp2 = vtkJavaUTF8ToString(env, id2, len2);
  temp3 = (id3 != 0) ? true : false;

  vtkShaderProgram* op = static_cast<vtkShaderProgram*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->Substitute(temp0,temp1,temp2,temp3);
  return temp20;

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkShaderProgram_Substitute_141(JNIEnv* env, jobject obj,jobject id0, jbyteArray id1, jint len1, jbyteArray id2, jint len2,jboolean id3)
{
  vtkShader * temp0;
  std::string temp1;
  std::string temp2;
  bool   temp3;
  bool   temp20;
  temp0 = static_cast<vtkShader*>(vtkJavaGetPointerFromObject(env, id0));
  temp1 = vtkJavaUTF8ToString(env, id1, len1);
  temp2 = vtkJavaUTF8ToString(env, id2, len2);
  temp3 = (id3 != 0) ? true : false;

  vtkShaderProgram* op = static_cast<vtkShaderProgram*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->Substitute(temp0,temp1,temp2,temp3);
  return temp20;

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkShaderProgram_IsUniformUsed_142(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  bool   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkShaderProgram* op = static_cast<vtkShaderProgram*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsUniformUsed(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkShaderProgram_IsAttributeUsed_143(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  bool   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkShaderProgram* op = static_cast<vtkShaderProgram*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsAttributeUsed(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkShaderProgram_SetFileNamePrefixForDebugging_144(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkShaderProgram* op = static_cast<vtkShaderProgram*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetFileNamePrefixForDebugging(temp0);
  delete[] temp0;

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkShaderProgram_GetFileNamePrefixForDebugging_145(JNIEnv* env, jobject obj)
{
  char * temp20;

  vtkShaderProgram* op = static_cast<vtkShaderProgram*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetFileNamePrefixForDebugging();
  return (temp20 == nullptr) ? env->NewByteArray(0) : vtkJavaCharsToUTF8(env, temp20, strlen(temp20));

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkShaderProgram_SetUniformGroupUpdateTime_146(JNIEnv* env, jobject obj,jint id0,jlong id1)
{
  int   temp0;
   unsigned long   temp1;
  temp0 = id0;
  temp1 = id1;

  vtkShaderProgram* op = static_cast<vtkShaderProgram*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetUniformGroupUpdateTime(temp0,temp1);

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkShaderProgram_GetUniformGroupUpdateTime_147(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
   unsigned long   temp20;
  temp0 = id0;

  vtkShaderProgram* op = static_cast<vtkShaderProgram*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetUniformGroupUpdateTime(temp0);
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkShaderProgram_FindUniform_148(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkShaderProgram* op = static_cast<vtkShaderProgram*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->FindUniform(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkShaderProgram_FindAttributeArray_149(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkShaderProgram* op = static_cast<vtkShaderProgram*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->FindAttributeArray(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong JNICALL Java_vtk_vtkShaderProgram_VTKInit(JNIEnv*, jobject)
{
  return reinterpret_cast<jlong>(vtkShaderProgram::New());
}
