// java wrapper for vtkCubeAxesActor object
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkABI.h"
#include "vtkSystemIncludes.h"
#include "vtkCubeAxesActor.h"
#include "vtkJavaUtil.h"

#include "vtkStdString.h"

#include <sstream>
extern "C" JNIEXPORT void* vtkActor_Typecast(void* op,char* dType);

extern "C" JNIEXPORT void* vtkCubeAxesActor_Typecast(void* me,char* dType)
{
  void* res;
  if (!strcmp("vtkCubeAxesActor",dType)) { return me; }
  if ((res= vtkActor_Typecast(me,dType)) != nullptr) { return res; }
  return nullptr;
}


extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkCubeAxesActor_IsTypeOf_10(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkCubeAxesActor* op = static_cast<vtkCubeAxesActor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsTypeOf(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkCubeAxesActor_IsA_11(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkCubeAxesActor* op = static_cast<vtkCubeAxesActor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsA(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkCubeAxesActor_GetNumberOfGenerationsFromBaseType_12(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkCubeAxesActor* op = static_cast<vtkCubeAxesActor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBaseType(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkCubeAxesActor_GetNumberOfGenerationsFromBase_13(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkCubeAxesActor* op = static_cast<vtkCubeAxesActor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBase(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkCubeAxesActor_RenderOpaqueGeometry_14(JNIEnv* env, jobject obj,jobject id0)
{
  vtkViewport * temp0;
  int   temp20;
  temp0 = static_cast<vtkViewport*>(vtkJavaGetPointerFromObject(env, id0));

  vtkCubeAxesActor* op = static_cast<vtkCubeAxesActor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->RenderOpaqueGeometry(temp0);
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkCubeAxesActor_RenderTranslucentGeometry_15(JNIEnv* env, jobject obj,jobject id0)
{
  vtkViewport * temp0;
  int   temp20;
  temp0 = static_cast<vtkViewport*>(vtkJavaGetPointerFromObject(env, id0));

  vtkCubeAxesActor* op = static_cast<vtkCubeAxesActor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->RenderTranslucentGeometry(temp0);
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkCubeAxesActor_RenderTranslucentPolygonalGeometry_16(JNIEnv* env, jobject obj,jobject id0)
{
  vtkViewport * temp0;
  int   temp20;
  temp0 = static_cast<vtkViewport*>(vtkJavaGetPointerFromObject(env, id0));

  vtkCubeAxesActor* op = static_cast<vtkCubeAxesActor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->RenderTranslucentPolygonalGeometry(temp0);
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkCubeAxesActor_RenderOverlay_17(JNIEnv* env, jobject obj,jobject id0)
{
  vtkViewport * temp0;
  int   temp20;
  temp0 = static_cast<vtkViewport*>(vtkJavaGetPointerFromObject(env, id0));

  vtkCubeAxesActor* op = static_cast<vtkCubeAxesActor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->RenderOverlay(temp0);
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkCubeAxesActor_HasTranslucentPolygonalGeometry_18(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkCubeAxesActor* op = static_cast<vtkCubeAxesActor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->HasTranslucentPolygonalGeometry();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCubeAxesActor_SetRebuildAxes_19(JNIEnv* env, jobject obj,jboolean id0)
{
  bool   temp0;
  temp0 = (id0 != 0) ? true : false;

  vtkCubeAxesActor* op = static_cast<vtkCubeAxesActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetRebuildAxes(temp0);

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkCubeAxesActor_GetRebuildAxes_110(JNIEnv* env, jobject obj)
{
  bool   temp20;

  vtkCubeAxesActor* op = static_cast<vtkCubeAxesActor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetRebuildAxes();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCubeAxesActor_SetBounds_111(JNIEnv* env, jobject obj,jdouble id0,jdouble id1,jdouble id2,jdouble id3,jdouble id4,jdouble id5)
{
  double   temp0;
  double   temp1;
  double   temp2;
  double   temp3;
  double   temp4;
  double   temp5;
  temp0 = id0;
  temp1 = id1;
  temp2 = id2;
  temp3 = id3;
  temp4 = id4;
  temp5 = id5;

  vtkCubeAxesActor* op = static_cast<vtkCubeAxesActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetBounds(temp0,temp1,temp2,temp3,temp4,temp5);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCubeAxesActor_SetBounds_112(JNIEnv* env, jobject obj,jdoubleArray id0)
{
  double temp0[6];
  env->GetDoubleArrayRegion(id0, 0, 6, &temp0[0]);

  vtkCubeAxesActor* op = static_cast<vtkCubeAxesActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetBounds(temp0);

}

extern "C" JNIEXPORT jdoubleArray  JNICALL Java_vtk_vtkCubeAxesActor_GetBounds_113(JNIEnv* env, jobject obj)
{
  double * temp20;

  vtkCubeAxesActor* op = static_cast<vtkCubeAxesActor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetBounds();
  return vtkJavaMakeJArrayOfDouble(env, temp20, 6);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCubeAxesActor_GetRenderedBounds_114(JNIEnv* env, jobject obj,jdoubleArray id0)
{
  double temp0[6];
  env->GetDoubleArrayRegion(id0, 0, 6, &temp0[0]);

  vtkCubeAxesActor* op = static_cast<vtkCubeAxesActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->GetRenderedBounds(temp0);
  env->SetDoubleArrayRegion(id0, 0, 6, &temp0[0]);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCubeAxesActor_SetXAxisRange_115(JNIEnv* env, jobject obj,jdouble id0,jdouble id1)
{
  double   temp0;
  double   temp1;
  temp0 = id0;
  temp1 = id1;

  vtkCubeAxesActor* op = static_cast<vtkCubeAxesActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetXAxisRange(temp0,temp1);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCubeAxesActor_SetXAxisRange_116(JNIEnv* env, jobject obj,jdoubleArray id0)
{
  double temp0[2];
  env->GetDoubleArrayRegion(id0, 0, 2, &temp0[0]);

  vtkCubeAxesActor* op = static_cast<vtkCubeAxesActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetXAxisRange(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCubeAxesActor_SetYAxisRange_117(JNIEnv* env, jobject obj,jdouble id0,jdouble id1)
{
  double   temp0;
  double   temp1;
  temp0 = id0;
  temp1 = id1;

  vtkCubeAxesActor* op = static_cast<vtkCubeAxesActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetYAxisRange(temp0,temp1);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCubeAxesActor_SetYAxisRange_118(JNIEnv* env, jobject obj,jdoubleArray id0)
{
  double temp0[2];
  env->GetDoubleArrayRegion(id0, 0, 2, &temp0[0]);

  vtkCubeAxesActor* op = static_cast<vtkCubeAxesActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetYAxisRange(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCubeAxesActor_SetZAxisRange_119(JNIEnv* env, jobject obj,jdouble id0,jdouble id1)
{
  double   temp0;
  double   temp1;
  temp0 = id0;
  temp1 = id1;

  vtkCubeAxesActor* op = static_cast<vtkCubeAxesActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetZAxisRange(temp0,temp1);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCubeAxesActor_SetZAxisRange_120(JNIEnv* env, jobject obj,jdoubleArray id0)
{
  double temp0[2];
  env->GetDoubleArrayRegion(id0, 0, 2, &temp0[0]);

  vtkCubeAxesActor* op = static_cast<vtkCubeAxesActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetZAxisRange(temp0);

}

extern "C" JNIEXPORT jdoubleArray  JNICALL Java_vtk_vtkCubeAxesActor_GetXAxisRange_121(JNIEnv* env, jobject obj)
{
  double * temp20;

  vtkCubeAxesActor* op = static_cast<vtkCubeAxesActor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetXAxisRange();
  return vtkJavaMakeJArrayOfDouble(env, temp20, 2);

}

extern "C" JNIEXPORT jdoubleArray  JNICALL Java_vtk_vtkCubeAxesActor_GetYAxisRange_122(JNIEnv* env, jobject obj)
{
  double * temp20;

  vtkCubeAxesActor* op = static_cast<vtkCubeAxesActor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetYAxisRange();
  return vtkJavaMakeJArrayOfDouble(env, temp20, 2);

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkCubeAxesActor_GetAxisLabels_123(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  vtkStringArray * temp20;
  temp0 = id0;

  vtkCubeAxesActor* op = static_cast<vtkCubeAxesActor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetAxisLabels(temp0);
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCubeAxesActor_SetAxisLabels_124(JNIEnv* env, jobject obj,jint id0,jobject id1)
{
  int   temp0;
  vtkStringArray * temp1;
  temp0 = id0;
  temp1 = static_cast<vtkStringArray*>(vtkJavaGetPointerFromObject(env, id1));

  vtkCubeAxesActor* op = static_cast<vtkCubeAxesActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetAxisLabels(temp0,temp1);

}

extern "C" JNIEXPORT jdoubleArray  JNICALL Java_vtk_vtkCubeAxesActor_GetZAxisRange_125(JNIEnv* env, jobject obj)
{
  double * temp20;

  vtkCubeAxesActor* op = static_cast<vtkCubeAxesActor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetZAxisRange();
  return vtkJavaMakeJArrayOfDouble(env, temp20, 2);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCubeAxesActor_SetScreenSize_126(JNIEnv* env, jobject obj,jdouble id0)
{
  double   temp0;
  temp0 = id0;

  vtkCubeAxesActor* op = static_cast<vtkCubeAxesActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetScreenSize(temp0);

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkCubeAxesActor_GetScreenSize_127(JNIEnv* env, jobject obj)
{
  double   temp20;

  vtkCubeAxesActor* op = static_cast<vtkCubeAxesActor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetScreenSize();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCubeAxesActor_SetLabelOffset_128(JNIEnv* env, jobject obj,jdouble id0)
{
  double   temp0;
  temp0 = id0;

  vtkCubeAxesActor* op = static_cast<vtkCubeAxesActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetLabelOffset(temp0);

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkCubeAxesActor_GetLabelOffset_129(JNIEnv* env, jobject obj)
{
  double   temp20;

  vtkCubeAxesActor* op = static_cast<vtkCubeAxesActor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetLabelOffset();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCubeAxesActor_SetTitleOffset_130(JNIEnv* env, jobject obj,jdoubleArray id0)
{
  double temp0[2];
  env->GetDoubleArrayRegion(id0, 0, 2, &temp0[0]);

  vtkCubeAxesActor* op = static_cast<vtkCubeAxesActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetTitleOffset(temp0);
  env->SetDoubleArrayRegion(id0, 0, 2, &temp0[0]);

}

extern "C" JNIEXPORT jdoubleArray  JNICALL Java_vtk_vtkCubeAxesActor_GetTitleOffset_131(JNIEnv* env, jobject obj)
{
  double * temp20;

  vtkCubeAxesActor* op = static_cast<vtkCubeAxesActor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetTitleOffset();
  return vtkJavaMakeJArrayOfDouble(env, temp20, 2);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCubeAxesActor_SetCamera_132(JNIEnv* env, jobject obj,jobject id0)
{
  vtkCamera * temp0;
  temp0 = static_cast<vtkCamera*>(vtkJavaGetPointerFromObject(env, id0));

  vtkCubeAxesActor* op = static_cast<vtkCubeAxesActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetCamera(temp0);

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkCubeAxesActor_GetCamera_133(JNIEnv* env, jobject obj)
{
  vtkCamera * temp20;

  vtkCubeAxesActor* op = static_cast<vtkCubeAxesActor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetCamera();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCubeAxesActor_SetFlyMode_134(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkCubeAxesActor* op = static_cast<vtkCubeAxesActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetFlyMode(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkCubeAxesActor_GetFlyModeMinValue_135(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkCubeAxesActor* op = static_cast<vtkCubeAxesActor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetFlyModeMinValue();
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkCubeAxesActor_GetFlyModeMaxValue_136(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkCubeAxesActor* op = static_cast<vtkCubeAxesActor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetFlyModeMaxValue();
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkCubeAxesActor_GetFlyMode_137(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkCubeAxesActor* op = static_cast<vtkCubeAxesActor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetFlyMode();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCubeAxesActor_SetFlyModeToOuterEdges_138(JNIEnv* env, jobject obj)
{

  vtkCubeAxesActor* op = static_cast<vtkCubeAxesActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetFlyModeToOuterEdges();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCubeAxesActor_SetFlyModeToClosestTriad_139(JNIEnv* env, jobject obj)
{

  vtkCubeAxesActor* op = static_cast<vtkCubeAxesActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetFlyModeToClosestTriad();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCubeAxesActor_SetFlyModeToFurthestTriad_140(JNIEnv* env, jobject obj)
{

  vtkCubeAxesActor* op = static_cast<vtkCubeAxesActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetFlyModeToFurthestTriad();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCubeAxesActor_SetFlyModeToStaticTriad_141(JNIEnv* env, jobject obj)
{

  vtkCubeAxesActor* op = static_cast<vtkCubeAxesActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetFlyModeToStaticTriad();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCubeAxesActor_SetFlyModeToStaticEdges_142(JNIEnv* env, jobject obj)
{

  vtkCubeAxesActor* op = static_cast<vtkCubeAxesActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetFlyModeToStaticEdges();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCubeAxesActor_SetXTitle_143(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkCubeAxesActor* op = static_cast<vtkCubeAxesActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetXTitle(temp0);
  delete[] temp0;

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkCubeAxesActor_GetXTitle_144(JNIEnv* env, jobject obj)
{
  char * temp20;

  vtkCubeAxesActor* op = static_cast<vtkCubeAxesActor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetXTitle();
  return (temp20 == nullptr) ? env->NewByteArray(0) : vtkJavaCharsToUTF8(env, temp20, strlen(temp20));

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCubeAxesActor_SetXUnits_145(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkCubeAxesActor* op = static_cast<vtkCubeAxesActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetXUnits(temp0);
  delete[] temp0;

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkCubeAxesActor_GetXUnits_146(JNIEnv* env, jobject obj)
{
  char * temp20;

  vtkCubeAxesActor* op = static_cast<vtkCubeAxesActor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetXUnits();
  return (temp20 == nullptr) ? env->NewByteArray(0) : vtkJavaCharsToUTF8(env, temp20, strlen(temp20));

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCubeAxesActor_SetYTitle_147(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkCubeAxesActor* op = static_cast<vtkCubeAxesActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetYTitle(temp0);
  delete[] temp0;

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkCubeAxesActor_GetYTitle_148(JNIEnv* env, jobject obj)
{
  char * temp20;

  vtkCubeAxesActor* op = static_cast<vtkCubeAxesActor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetYTitle();
  return (temp20 == nullptr) ? env->NewByteArray(0) : vtkJavaCharsToUTF8(env, temp20, strlen(temp20));

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCubeAxesActor_SetYUnits_149(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkCubeAxesActor* op = static_cast<vtkCubeAxesActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetYUnits(temp0);
  delete[] temp0;

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkCubeAxesActor_GetYUnits_150(JNIEnv* env, jobject obj)
{
  char * temp20;

  vtkCubeAxesActor* op = static_cast<vtkCubeAxesActor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetYUnits();
  return (temp20 == nullptr) ? env->NewByteArray(0) : vtkJavaCharsToUTF8(env, temp20, strlen(temp20));

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCubeAxesActor_SetZTitle_151(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkCubeAxesActor* op = static_cast<vtkCubeAxesActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetZTitle(temp0);
  delete[] temp0;

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkCubeAxesActor_GetZTitle_152(JNIEnv* env, jobject obj)
{
  char * temp20;

  vtkCubeAxesActor* op = static_cast<vtkCubeAxesActor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetZTitle();
  return (temp20 == nullptr) ? env->NewByteArray(0) : vtkJavaCharsToUTF8(env, temp20, strlen(temp20));

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCubeAxesActor_SetZUnits_153(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkCubeAxesActor* op = static_cast<vtkCubeAxesActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetZUnits(temp0);
  delete[] temp0;

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkCubeAxesActor_GetZUnits_154(JNIEnv* env, jobject obj)
{
  char * temp20;

  vtkCubeAxesActor* op = static_cast<vtkCubeAxesActor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetZUnits();
  return (temp20 == nullptr) ? env->NewByteArray(0) : vtkJavaCharsToUTF8(env, temp20, strlen(temp20));

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCubeAxesActor_SetXLabelFormat_155(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkCubeAxesActor* op = static_cast<vtkCubeAxesActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetXLabelFormat(temp0);
  delete[] temp0;

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkCubeAxesActor_GetXLabelFormat_156(JNIEnv* env, jobject obj)
{
  char * temp20;

  vtkCubeAxesActor* op = static_cast<vtkCubeAxesActor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetXLabelFormat();
  return (temp20 == nullptr) ? env->NewByteArray(0) : vtkJavaCharsToUTF8(env, temp20, strlen(temp20));

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCubeAxesActor_SetYLabelFormat_157(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkCubeAxesActor* op = static_cast<vtkCubeAxesActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetYLabelFormat(temp0);
  delete[] temp0;

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkCubeAxesActor_GetYLabelFormat_158(JNIEnv* env, jobject obj)
{
  char * temp20;

  vtkCubeAxesActor* op = static_cast<vtkCubeAxesActor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetYLabelFormat();
  return (temp20 == nullptr) ? env->NewByteArray(0) : vtkJavaCharsToUTF8(env, temp20, strlen(temp20));

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCubeAxesActor_SetZLabelFormat_159(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkCubeAxesActor* op = static_cast<vtkCubeAxesActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetZLabelFormat(temp0);
  delete[] temp0;

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkCubeAxesActor_GetZLabelFormat_160(JNIEnv* env, jobject obj)
{
  char * temp20;

  vtkCubeAxesActor* op = static_cast<vtkCubeAxesActor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetZLabelFormat();
  return (temp20 == nullptr) ? env->NewByteArray(0) : vtkJavaCharsToUTF8(env, temp20, strlen(temp20));

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCubeAxesActor_SetInertia_161(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkCubeAxesActor* op = static_cast<vtkCubeAxesActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetInertia(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkCubeAxesActor_GetInertiaMinValue_162(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkCubeAxesActor* op = static_cast<vtkCubeAxesActor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetInertiaMinValue();
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkCubeAxesActor_GetInertiaMaxValue_163(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkCubeAxesActor* op = static_cast<vtkCubeAxesActor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetInertiaMaxValue();
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkCubeAxesActor_GetInertia_164(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkCubeAxesActor* op = static_cast<vtkCubeAxesActor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetInertia();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCubeAxesActor_SetCornerOffset_165(JNIEnv* env, jobject obj,jdouble id0)
{
  double   temp0;
  temp0 = id0;

  vtkCubeAxesActor* op = static_cast<vtkCubeAxesActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetCornerOffset(temp0);

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkCubeAxesActor_GetCornerOffset_166(JNIEnv* env, jobject obj)
{
  double   temp20;

  vtkCubeAxesActor* op = static_cast<vtkCubeAxesActor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetCornerOffset();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCubeAxesActor_ReleaseGraphicsResources_167(JNIEnv* env, jobject obj,jobject id0)
{
  vtkWindow * temp0;
  temp0 = static_cast<vtkWindow*>(vtkJavaGetPointerFromObject(env, id0));

  vtkCubeAxesActor* op = static_cast<vtkCubeAxesActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->ReleaseGraphicsResources(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCubeAxesActor_SetEnableDistanceLOD_168(JNIEnv* env, jobject obj,jboolean id0)
{
  bool   temp0;
  temp0 = (id0 != 0) ? true : false;

  vtkCubeAxesActor* op = static_cast<vtkCubeAxesActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetEnableDistanceLOD(temp0);

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkCubeAxesActor_GetEnableDistanceLOD_169(JNIEnv* env, jobject obj)
{
  bool   temp20;

  vtkCubeAxesActor* op = static_cast<vtkCubeAxesActor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetEnableDistanceLOD();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCubeAxesActor_SetDistanceLODThreshold_170(JNIEnv* env, jobject obj,jdouble id0)
{
  double   temp0;
  temp0 = id0;

  vtkCubeAxesActor* op = static_cast<vtkCubeAxesActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetDistanceLODThreshold(temp0);

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkCubeAxesActor_GetDistanceLODThresholdMinValue_171(JNIEnv* env, jobject obj)
{
  double   temp20;

  vtkCubeAxesActor* op = static_cast<vtkCubeAxesActor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetDistanceLODThresholdMinValue();
  return temp20;

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkCubeAxesActor_GetDistanceLODThresholdMaxValue_172(JNIEnv* env, jobject obj)
{
  double   temp20;

  vtkCubeAxesActor* op = static_cast<vtkCubeAxesActor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetDistanceLODThresholdMaxValue();
  return temp20;

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkCubeAxesActor_GetDistanceLODThreshold_173(JNIEnv* env, jobject obj)
{
  double   temp20;

  vtkCubeAxesActor* op = static_cast<vtkCubeAxesActor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetDistanceLODThreshold();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCubeAxesActor_SetEnableViewAngleLOD_174(JNIEnv* env, jobject obj,jboolean id0)
{
  bool   temp0;
  temp0 = (id0 != 0) ? true : false;

  vtkCubeAxesActor* op = static_cast<vtkCubeAxesActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetEnableViewAngleLOD(temp0);

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkCubeAxesActor_GetEnableViewAngleLOD_175(JNIEnv* env, jobject obj)
{
  bool   temp20;

  vtkCubeAxesActor* op = static_cast<vtkCubeAxesActor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetEnableViewAngleLOD();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCubeAxesActor_SetViewAngleLODThreshold_176(JNIEnv* env, jobject obj,jdouble id0)
{
  double   temp0;
  temp0 = id0;

  vtkCubeAxesActor* op = static_cast<vtkCubeAxesActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetViewAngleLODThreshold(temp0);

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkCubeAxesActor_GetViewAngleLODThresholdMinValue_177(JNIEnv* env, jobject obj)
{
  double   temp20;

  vtkCubeAxesActor* op = static_cast<vtkCubeAxesActor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetViewAngleLODThresholdMinValue();
  return temp20;

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkCubeAxesActor_GetViewAngleLODThresholdMaxValue_178(JNIEnv* env, jobject obj)
{
  double   temp20;

  vtkCubeAxesActor* op = static_cast<vtkCubeAxesActor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetViewAngleLODThresholdMaxValue();
  return temp20;

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkCubeAxesActor_GetViewAngleLODThreshold_179(JNIEnv* env, jobject obj)
{
  double   temp20;

  vtkCubeAxesActor* op = static_cast<vtkCubeAxesActor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetViewAngleLODThreshold();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCubeAxesActor_SetXAxisVisibility_180(JNIEnv* env, jobject obj,jboolean id0)
{
  bool   temp0;
  temp0 = (id0 != 0) ? true : false;

  vtkCubeAxesActor* op = static_cast<vtkCubeAxesActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetXAxisVisibility(temp0);

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkCubeAxesActor_GetXAxisVisibility_181(JNIEnv* env, jobject obj)
{
  bool   temp20;

  vtkCubeAxesActor* op = static_cast<vtkCubeAxesActor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetXAxisVisibility();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCubeAxesActor_XAxisVisibilityOn_182(JNIEnv* env, jobject obj)
{

  vtkCubeAxesActor* op = static_cast<vtkCubeAxesActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->XAxisVisibilityOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCubeAxesActor_XAxisVisibilityOff_183(JNIEnv* env, jobject obj)
{

  vtkCubeAxesActor* op = static_cast<vtkCubeAxesActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->XAxisVisibilityOff();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCubeAxesActor_SetYAxisVisibility_184(JNIEnv* env, jobject obj,jboolean id0)
{
  bool   temp0;
  temp0 = (id0 != 0) ? true : false;

  vtkCubeAxesActor* op = static_cast<vtkCubeAxesActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetYAxisVisibility(temp0);

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkCubeAxesActor_GetYAxisVisibility_185(JNIEnv* env, jobject obj)
{
  bool   temp20;

  vtkCubeAxesActor* op = static_cast<vtkCubeAxesActor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetYAxisVisibility();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCubeAxesActor_YAxisVisibilityOn_186(JNIEnv* env, jobject obj)
{

  vtkCubeAxesActor* op = static_cast<vtkCubeAxesActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->YAxisVisibilityOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCubeAxesActor_YAxisVisibilityOff_187(JNIEnv* env, jobject obj)
{

  vtkCubeAxesActor* op = static_cast<vtkCubeAxesActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->YAxisVisibilityOff();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCubeAxesActor_SetZAxisVisibility_188(JNIEnv* env, jobject obj,jboolean id0)
{
  bool   temp0;
  temp0 = (id0 != 0) ? true : false;

  vtkCubeAxesActor* op = static_cast<vtkCubeAxesActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetZAxisVisibility(temp0);

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkCubeAxesActor_GetZAxisVisibility_189(JNIEnv* env, jobject obj)
{
  bool   temp20;

  vtkCubeAxesActor* op = static_cast<vtkCubeAxesActor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetZAxisVisibility();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCubeAxesActor_ZAxisVisibilityOn_190(JNIEnv* env, jobject obj)
{

  vtkCubeAxesActor* op = static_cast<vtkCubeAxesActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->ZAxisVisibilityOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCubeAxesActor_ZAxisVisibilityOff_191(JNIEnv* env, jobject obj)
{

  vtkCubeAxesActor* op = static_cast<vtkCubeAxesActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->ZAxisVisibilityOff();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCubeAxesActor_SetXAxisLabelVisibility_192(JNIEnv* env, jobject obj,jboolean id0)
{
  bool   temp0;
  temp0 = (id0 != 0) ? true : false;

  vtkCubeAxesActor* op = static_cast<vtkCubeAxesActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetXAxisLabelVisibility(temp0);

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkCubeAxesActor_GetXAxisLabelVisibility_193(JNIEnv* env, jobject obj)
{
  bool   temp20;

  vtkCubeAxesActor* op = static_cast<vtkCubeAxesActor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetXAxisLabelVisibility();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCubeAxesActor_XAxisLabelVisibilityOn_194(JNIEnv* env, jobject obj)
{

  vtkCubeAxesActor* op = static_cast<vtkCubeAxesActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->XAxisLabelVisibilityOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCubeAxesActor_XAxisLabelVisibilityOff_195(JNIEnv* env, jobject obj)
{

  vtkCubeAxesActor* op = static_cast<vtkCubeAxesActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->XAxisLabelVisibilityOff();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCubeAxesActor_SetYAxisLabelVisibility_196(JNIEnv* env, jobject obj,jboolean id0)
{
  bool   temp0;
  temp0 = (id0 != 0) ? true : false;

  vtkCubeAxesActor* op = static_cast<vtkCubeAxesActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetYAxisLabelVisibility(temp0);

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkCubeAxesActor_GetYAxisLabelVisibility_197(JNIEnv* env, jobject obj)
{
  bool   temp20;

  vtkCubeAxesActor* op = static_cast<vtkCubeAxesActor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetYAxisLabelVisibility();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCubeAxesActor_YAxisLabelVisibilityOn_198(JNIEnv* env, jobject obj)
{

  vtkCubeAxesActor* op = static_cast<vtkCubeAxesActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->YAxisLabelVisibilityOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCubeAxesActor_YAxisLabelVisibilityOff_199(JNIEnv* env, jobject obj)
{

  vtkCubeAxesActor* op = static_cast<vtkCubeAxesActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->YAxisLabelVisibilityOff();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCubeAxesActor_SetZAxisLabelVisibility_1100(JNIEnv* env, jobject obj,jboolean id0)
{
  bool   temp0;
  temp0 = (id0 != 0) ? true : false;

  vtkCubeAxesActor* op = static_cast<vtkCubeAxesActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetZAxisLabelVisibility(temp0);

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkCubeAxesActor_GetZAxisLabelVisibility_1101(JNIEnv* env, jobject obj)
{
  bool   temp20;

  vtkCubeAxesActor* op = static_cast<vtkCubeAxesActor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetZAxisLabelVisibility();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCubeAxesActor_ZAxisLabelVisibilityOn_1102(JNIEnv* env, jobject obj)
{

  vtkCubeAxesActor* op = static_cast<vtkCubeAxesActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->ZAxisLabelVisibilityOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCubeAxesActor_ZAxisLabelVisibilityOff_1103(JNIEnv* env, jobject obj)
{

  vtkCubeAxesActor* op = static_cast<vtkCubeAxesActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->ZAxisLabelVisibilityOff();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCubeAxesActor_SetXAxisTickVisibility_1104(JNIEnv* env, jobject obj,jboolean id0)
{
  bool   temp0;
  temp0 = (id0 != 0) ? true : false;

  vtkCubeAxesActor* op = static_cast<vtkCubeAxesActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetXAxisTickVisibility(temp0);

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkCubeAxesActor_GetXAxisTickVisibility_1105(JNIEnv* env, jobject obj)
{
  bool   temp20;

  vtkCubeAxesActor* op = static_cast<vtkCubeAxesActor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetXAxisTickVisibility();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCubeAxesActor_XAxisTickVisibilityOn_1106(JNIEnv* env, jobject obj)
{

  vtkCubeAxesActor* op = static_cast<vtkCubeAxesActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->XAxisTickVisibilityOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCubeAxesActor_XAxisTickVisibilityOff_1107(JNIEnv* env, jobject obj)
{

  vtkCubeAxesActor* op = static_cast<vtkCubeAxesActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->XAxisTickVisibilityOff();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCubeAxesActor_SetYAxisTickVisibility_1108(JNIEnv* env, jobject obj,jboolean id0)
{
  bool   temp0;
  temp0 = (id0 != 0) ? true : false;

  vtkCubeAxesActor* op = static_cast<vtkCubeAxesActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetYAxisTickVisibility(temp0);

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkCubeAxesActor_GetYAxisTickVisibility_1109(JNIEnv* env, jobject obj)
{
  bool   temp20;

  vtkCubeAxesActor* op = static_cast<vtkCubeAxesActor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetYAxisTickVisibility();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCubeAxesActor_YAxisTickVisibilityOn_1110(JNIEnv* env, jobject obj)
{

  vtkCubeAxesActor* op = static_cast<vtkCubeAxesActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->YAxisTickVisibilityOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCubeAxesActor_YAxisTickVisibilityOff_1111(JNIEnv* env, jobject obj)
{

  vtkCubeAxesActor* op = static_cast<vtkCubeAxesActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->YAxisTickVisibilityOff();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCubeAxesActor_SetZAxisTickVisibility_1112(JNIEnv* env, jobject obj,jboolean id0)
{
  bool   temp0;
  temp0 = (id0 != 0) ? true : false;

  vtkCubeAxesActor* op = static_cast<vtkCubeAxesActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetZAxisTickVisibility(temp0);

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkCubeAxesActor_GetZAxisTickVisibility_1113(JNIEnv* env, jobject obj)
{
  bool   temp20;

  vtkCubeAxesActor* op = static_cast<vtkCubeAxesActor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetZAxisTickVisibility();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCubeAxesActor_ZAxisTickVisibilityOn_1114(JNIEnv* env, jobject obj)
{

  vtkCubeAxesActor* op = static_cast<vtkCubeAxesActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->ZAxisTickVisibilityOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCubeAxesActor_ZAxisTickVisibilityOff_1115(JNIEnv* env, jobject obj)
{

  vtkCubeAxesActor* op = static_cast<vtkCubeAxesActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->ZAxisTickVisibilityOff();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCubeAxesActor_SetXAxisMinorTickVisibility_1116(JNIEnv* env, jobject obj,jboolean id0)
{
  bool   temp0;
  temp0 = (id0 != 0) ? true : false;

  vtkCubeAxesActor* op = static_cast<vtkCubeAxesActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetXAxisMinorTickVisibility(temp0);

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkCubeAxesActor_GetXAxisMinorTickVisibility_1117(JNIEnv* env, jobject obj)
{
  bool   temp20;

  vtkCubeAxesActor* op = static_cast<vtkCubeAxesActor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetXAxisMinorTickVisibility();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCubeAxesActor_XAxisMinorTickVisibilityOn_1118(JNIEnv* env, jobject obj)
{

  vtkCubeAxesActor* op = static_cast<vtkCubeAxesActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->XAxisMinorTickVisibilityOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCubeAxesActor_XAxisMinorTickVisibilityOff_1119(JNIEnv* env, jobject obj)
{

  vtkCubeAxesActor* op = static_cast<vtkCubeAxesActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->XAxisMinorTickVisibilityOff();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCubeAxesActor_SetYAxisMinorTickVisibility_1120(JNIEnv* env, jobject obj,jboolean id0)
{
  bool   temp0;
  temp0 = (id0 != 0) ? true : false;

  vtkCubeAxesActor* op = static_cast<vtkCubeAxesActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetYAxisMinorTickVisibility(temp0);

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkCubeAxesActor_GetYAxisMinorTickVisibility_1121(JNIEnv* env, jobject obj)
{
  bool   temp20;

  vtkCubeAxesActor* op = static_cast<vtkCubeAxesActor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetYAxisMinorTickVisibility();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCubeAxesActor_YAxisMinorTickVisibilityOn_1122(JNIEnv* env, jobject obj)
{

  vtkCubeAxesActor* op = static_cast<vtkCubeAxesActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->YAxisMinorTickVisibilityOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCubeAxesActor_YAxisMinorTickVisibilityOff_1123(JNIEnv* env, jobject obj)
{

  vtkCubeAxesActor* op = static_cast<vtkCubeAxesActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->YAxisMinorTickVisibilityOff();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCubeAxesActor_SetZAxisMinorTickVisibility_1124(JNIEnv* env, jobject obj,jboolean id0)
{
  bool   temp0;
  temp0 = (id0 != 0) ? true : false;

  vtkCubeAxesActor* op = static_cast<vtkCubeAxesActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetZAxisMinorTickVisibility(temp0);

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkCubeAxesActor_GetZAxisMinorTickVisibility_1125(JNIEnv* env, jobject obj)
{
  bool   temp20;

  vtkCubeAxesActor* op = static_cast<vtkCubeAxesActor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetZAxisMinorTickVisibility();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCubeAxesActor_ZAxisMinorTickVisibilityOn_1126(JNIEnv* env, jobject obj)
{

  vtkCubeAxesActor* op = static_cast<vtkCubeAxesActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->ZAxisMinorTickVisibilityOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCubeAxesActor_ZAxisMinorTickVisibilityOff_1127(JNIEnv* env, jobject obj)
{

  vtkCubeAxesActor* op = static_cast<vtkCubeAxesActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->ZAxisMinorTickVisibilityOff();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCubeAxesActor_SetDrawXGridlines_1128(JNIEnv* env, jobject obj,jboolean id0)
{
  bool   temp0;
  temp0 = (id0 != 0) ? true : false;

  vtkCubeAxesActor* op = static_cast<vtkCubeAxesActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetDrawXGridlines(temp0);

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkCubeAxesActor_GetDrawXGridlines_1129(JNIEnv* env, jobject obj)
{
  bool   temp20;

  vtkCubeAxesActor* op = static_cast<vtkCubeAxesActor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetDrawXGridlines();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCubeAxesActor_DrawXGridlinesOn_1130(JNIEnv* env, jobject obj)
{

  vtkCubeAxesActor* op = static_cast<vtkCubeAxesActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->DrawXGridlinesOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCubeAxesActor_DrawXGridlinesOff_1131(JNIEnv* env, jobject obj)
{

  vtkCubeAxesActor* op = static_cast<vtkCubeAxesActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->DrawXGridlinesOff();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCubeAxesActor_SetDrawYGridlines_1132(JNIEnv* env, jobject obj,jboolean id0)
{
  bool   temp0;
  temp0 = (id0 != 0) ? true : false;

  vtkCubeAxesActor* op = static_cast<vtkCubeAxesActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetDrawYGridlines(temp0);

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkCubeAxesActor_GetDrawYGridlines_1133(JNIEnv* env, jobject obj)
{
  bool   temp20;

  vtkCubeAxesActor* op = static_cast<vtkCubeAxesActor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetDrawYGridlines();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCubeAxesActor_DrawYGridlinesOn_1134(JNIEnv* env, jobject obj)
{

  vtkCubeAxesActor* op = static_cast<vtkCubeAxesActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->DrawYGridlinesOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCubeAxesActor_DrawYGridlinesOff_1135(JNIEnv* env, jobject obj)
{

  vtkCubeAxesActor* op = static_cast<vtkCubeAxesActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->DrawYGridlinesOff();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCubeAxesActor_SetDrawZGridlines_1136(JNIEnv* env, jobject obj,jboolean id0)
{
  bool   temp0;
  temp0 = (id0 != 0) ? true : false;

  vtkCubeAxesActor* op = static_cast<vtkCubeAxesActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetDrawZGridlines(temp0);

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkCubeAxesActor_GetDrawZGridlines_1137(JNIEnv* env, jobject obj)
{
  bool   temp20;

  vtkCubeAxesActor* op = static_cast<vtkCubeAxesActor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetDrawZGridlines();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCubeAxesActor_DrawZGridlinesOn_1138(JNIEnv* env, jobject obj)
{

  vtkCubeAxesActor* op = static_cast<vtkCubeAxesActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->DrawZGridlinesOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCubeAxesActor_DrawZGridlinesOff_1139(JNIEnv* env, jobject obj)
{

  vtkCubeAxesActor* op = static_cast<vtkCubeAxesActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->DrawZGridlinesOff();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCubeAxesActor_SetDrawXInnerGridlines_1140(JNIEnv* env, jobject obj,jboolean id0)
{
  bool   temp0;
  temp0 = (id0 != 0) ? true : false;

  vtkCubeAxesActor* op = static_cast<vtkCubeAxesActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetDrawXInnerGridlines(temp0);

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkCubeAxesActor_GetDrawXInnerGridlines_1141(JNIEnv* env, jobject obj)
{
  bool   temp20;

  vtkCubeAxesActor* op = static_cast<vtkCubeAxesActor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetDrawXInnerGridlines();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCubeAxesActor_DrawXInnerGridlinesOn_1142(JNIEnv* env, jobject obj)
{

  vtkCubeAxesActor* op = static_cast<vtkCubeAxesActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->DrawXInnerGridlinesOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCubeAxesActor_DrawXInnerGridlinesOff_1143(JNIEnv* env, jobject obj)
{

  vtkCubeAxesActor* op = static_cast<vtkCubeAxesActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->DrawXInnerGridlinesOff();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCubeAxesActor_SetDrawYInnerGridlines_1144(JNIEnv* env, jobject obj,jboolean id0)
{
  bool   temp0;
  temp0 = (id0 != 0) ? true : false;

  vtkCubeAxesActor* op = static_cast<vtkCubeAxesActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetDrawYInnerGridlines(temp0);

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkCubeAxesActor_GetDrawYInnerGridlines_1145(JNIEnv* env, jobject obj)
{
  bool   temp20;

  vtkCubeAxesActor* op = static_cast<vtkCubeAxesActor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetDrawYInnerGridlines();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCubeAxesActor_DrawYInnerGridlinesOn_1146(JNIEnv* env, jobject obj)
{

  vtkCubeAxesActor* op = static_cast<vtkCubeAxesActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->DrawYInnerGridlinesOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCubeAxesActor_DrawYInnerGridlinesOff_1147(JNIEnv* env, jobject obj)
{

  vtkCubeAxesActor* op = static_cast<vtkCubeAxesActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->DrawYInnerGridlinesOff();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCubeAxesActor_SetDrawZInnerGridlines_1148(JNIEnv* env, jobject obj,jboolean id0)
{
  bool   temp0;
  temp0 = (id0 != 0) ? true : false;

  vtkCubeAxesActor* op = static_cast<vtkCubeAxesActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetDrawZInnerGridlines(temp0);

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkCubeAxesActor_GetDrawZInnerGridlines_1149(JNIEnv* env, jobject obj)
{
  bool   temp20;

  vtkCubeAxesActor* op = static_cast<vtkCubeAxesActor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetDrawZInnerGridlines();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCubeAxesActor_DrawZInnerGridlinesOn_1150(JNIEnv* env, jobject obj)
{

  vtkCubeAxesActor* op = static_cast<vtkCubeAxesActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->DrawZInnerGridlinesOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCubeAxesActor_DrawZInnerGridlinesOff_1151(JNIEnv* env, jobject obj)
{

  vtkCubeAxesActor* op = static_cast<vtkCubeAxesActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->DrawZInnerGridlinesOff();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCubeAxesActor_SetDrawXGridpolys_1152(JNIEnv* env, jobject obj,jboolean id0)
{
  bool   temp0;
  temp0 = (id0 != 0) ? true : false;

  vtkCubeAxesActor* op = static_cast<vtkCubeAxesActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetDrawXGridpolys(temp0);

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkCubeAxesActor_GetDrawXGridpolys_1153(JNIEnv* env, jobject obj)
{
  bool   temp20;

  vtkCubeAxesActor* op = static_cast<vtkCubeAxesActor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetDrawXGridpolys();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCubeAxesActor_DrawXGridpolysOn_1154(JNIEnv* env, jobject obj)
{

  vtkCubeAxesActor* op = static_cast<vtkCubeAxesActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->DrawXGridpolysOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCubeAxesActor_DrawXGridpolysOff_1155(JNIEnv* env, jobject obj)
{

  vtkCubeAxesActor* op = static_cast<vtkCubeAxesActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->DrawXGridpolysOff();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCubeAxesActor_SetDrawYGridpolys_1156(JNIEnv* env, jobject obj,jboolean id0)
{
  bool   temp0;
  temp0 = (id0 != 0) ? true : false;

  vtkCubeAxesActor* op = static_cast<vtkCubeAxesActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetDrawYGridpolys(temp0);

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkCubeAxesActor_GetDrawYGridpolys_1157(JNIEnv* env, jobject obj)
{
  bool   temp20;

  vtkCubeAxesActor* op = static_cast<vtkCubeAxesActor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetDrawYGridpolys();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCubeAxesActor_DrawYGridpolysOn_1158(JNIEnv* env, jobject obj)
{

  vtkCubeAxesActor* op = static_cast<vtkCubeAxesActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->DrawYGridpolysOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCubeAxesActor_DrawYGridpolysOff_1159(JNIEnv* env, jobject obj)
{

  vtkCubeAxesActor* op = static_cast<vtkCubeAxesActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->DrawYGridpolysOff();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCubeAxesActor_SetDrawZGridpolys_1160(JNIEnv* env, jobject obj,jboolean id0)
{
  bool   temp0;
  temp0 = (id0 != 0) ? true : false;

  vtkCubeAxesActor* op = static_cast<vtkCubeAxesActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetDrawZGridpolys(temp0);

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkCubeAxesActor_GetDrawZGridpolys_1161(JNIEnv* env, jobject obj)
{
  bool   temp20;

  vtkCubeAxesActor* op = static_cast<vtkCubeAxesActor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetDrawZGridpolys();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCubeAxesActor_DrawZGridpolysOn_1162(JNIEnv* env, jobject obj)
{

  vtkCubeAxesActor* op = static_cast<vtkCubeAxesActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->DrawZGridpolysOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCubeAxesActor_DrawZGridpolysOff_1163(JNIEnv* env, jobject obj)
{

  vtkCubeAxesActor* op = static_cast<vtkCubeAxesActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->DrawZGridpolysOff();

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkCubeAxesActor_GetTitleTextProperty_1164(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  vtkTextProperty * temp20;
  temp0 = id0;

  vtkCubeAxesActor* op = static_cast<vtkCubeAxesActor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetTitleTextProperty(temp0);
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCubeAxesActor_SetXAxesTitleProperty_1165(JNIEnv* env, jobject obj,jobject id0)
{
  vtkTextProperty * temp0;
  temp0 = static_cast<vtkTextProperty*>(vtkJavaGetPointerFromObject(env, id0));

  vtkCubeAxesActor* op = static_cast<vtkCubeAxesActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetXAxesTitleProperty(temp0);

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkCubeAxesActor_GetXAxesTitleProperty_1166(JNIEnv* env, jobject obj)
{
  vtkTextProperty * temp20;

  vtkCubeAxesActor* op = static_cast<vtkCubeAxesActor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetXAxesTitleProperty();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCubeAxesActor_SetYAxesTitleProperty_1167(JNIEnv* env, jobject obj,jobject id0)
{
  vtkTextProperty * temp0;
  temp0 = static_cast<vtkTextProperty*>(vtkJavaGetPointerFromObject(env, id0));

  vtkCubeAxesActor* op = static_cast<vtkCubeAxesActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetYAxesTitleProperty(temp0);

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkCubeAxesActor_GetYAxesTitleProperty_1168(JNIEnv* env, jobject obj)
{
  vtkTextProperty * temp20;

  vtkCubeAxesActor* op = static_cast<vtkCubeAxesActor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetYAxesTitleProperty();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCubeAxesActor_SetZAxesTitleProperty_1169(JNIEnv* env, jobject obj,jobject id0)
{
  vtkTextProperty * temp0;
  temp0 = static_cast<vtkTextProperty*>(vtkJavaGetPointerFromObject(env, id0));

  vtkCubeAxesActor* op = static_cast<vtkCubeAxesActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetZAxesTitleProperty(temp0);

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkCubeAxesActor_GetZAxesTitleProperty_1170(JNIEnv* env, jobject obj)
{
  vtkTextProperty * temp20;

  vtkCubeAxesActor* op = static_cast<vtkCubeAxesActor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetZAxesTitleProperty();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkCubeAxesActor_GetLabelTextProperty_1171(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  vtkTextProperty * temp20;
  temp0 = id0;

  vtkCubeAxesActor* op = static_cast<vtkCubeAxesActor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetLabelTextProperty(temp0);
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCubeAxesActor_SetXAxesLabelProperty_1172(JNIEnv* env, jobject obj,jobject id0)
{
  vtkTextProperty * temp0;
  temp0 = static_cast<vtkTextProperty*>(vtkJavaGetPointerFromObject(env, id0));

  vtkCubeAxesActor* op = static_cast<vtkCubeAxesActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetXAxesLabelProperty(temp0);

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkCubeAxesActor_GetXAxesLabelProperty_1173(JNIEnv* env, jobject obj)
{
  vtkTextProperty * temp20;

  vtkCubeAxesActor* op = static_cast<vtkCubeAxesActor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetXAxesLabelProperty();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCubeAxesActor_SetYAxesLabelProperty_1174(JNIEnv* env, jobject obj,jobject id0)
{
  vtkTextProperty * temp0;
  temp0 = static_cast<vtkTextProperty*>(vtkJavaGetPointerFromObject(env, id0));

  vtkCubeAxesActor* op = static_cast<vtkCubeAxesActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetYAxesLabelProperty(temp0);

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkCubeAxesActor_GetYAxesLabelProperty_1175(JNIEnv* env, jobject obj)
{
  vtkTextProperty * temp20;

  vtkCubeAxesActor* op = static_cast<vtkCubeAxesActor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetYAxesLabelProperty();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCubeAxesActor_SetZAxesLabelProperty_1176(JNIEnv* env, jobject obj,jobject id0)
{
  vtkTextProperty * temp0;
  temp0 = static_cast<vtkTextProperty*>(vtkJavaGetPointerFromObject(env, id0));

  vtkCubeAxesActor* op = static_cast<vtkCubeAxesActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetZAxesLabelProperty(temp0);

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkCubeAxesActor_GetZAxesLabelProperty_1177(JNIEnv* env, jobject obj)
{
  vtkTextProperty * temp20;

  vtkCubeAxesActor* op = static_cast<vtkCubeAxesActor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetZAxesLabelProperty();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCubeAxesActor_SetXAxesLinesProperty_1178(JNIEnv* env, jobject obj,jobject id0)
{
  vtkProperty * temp0;
  temp0 = static_cast<vtkProperty*>(vtkJavaGetPointerFromObject(env, id0));

  vtkCubeAxesActor* op = static_cast<vtkCubeAxesActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetXAxesLinesProperty(temp0);

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkCubeAxesActor_GetXAxesLinesProperty_1179(JNIEnv* env, jobject obj)
{
  vtkProperty * temp20;

  vtkCubeAxesActor* op = static_cast<vtkCubeAxesActor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetXAxesLinesProperty();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCubeAxesActor_SetYAxesLinesProperty_1180(JNIEnv* env, jobject obj,jobject id0)
{
  vtkProperty * temp0;
  temp0 = static_cast<vtkProperty*>(vtkJavaGetPointerFromObject(env, id0));

  vtkCubeAxesActor* op = static_cast<vtkCubeAxesActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetYAxesLinesProperty(temp0);

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkCubeAxesActor_GetYAxesLinesProperty_1181(JNIEnv* env, jobject obj)
{
  vtkProperty * temp20;

  vtkCubeAxesActor* op = static_cast<vtkCubeAxesActor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetYAxesLinesProperty();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCubeAxesActor_SetZAxesLinesProperty_1182(JNIEnv* env, jobject obj,jobject id0)
{
  vtkProperty * temp0;
  temp0 = static_cast<vtkProperty*>(vtkJavaGetPointerFromObject(env, id0));

  vtkCubeAxesActor* op = static_cast<vtkCubeAxesActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetZAxesLinesProperty(temp0);

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkCubeAxesActor_GetZAxesLinesProperty_1183(JNIEnv* env, jobject obj)
{
  vtkProperty * temp20;

  vtkCubeAxesActor* op = static_cast<vtkCubeAxesActor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetZAxesLinesProperty();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCubeAxesActor_SetXAxesGridlinesProperty_1184(JNIEnv* env, jobject obj,jobject id0)
{
  vtkProperty * temp0;
  temp0 = static_cast<vtkProperty*>(vtkJavaGetPointerFromObject(env, id0));

  vtkCubeAxesActor* op = static_cast<vtkCubeAxesActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetXAxesGridlinesProperty(temp0);

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkCubeAxesActor_GetXAxesGridlinesProperty_1185(JNIEnv* env, jobject obj)
{
  vtkProperty * temp20;

  vtkCubeAxesActor* op = static_cast<vtkCubeAxesActor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetXAxesGridlinesProperty();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCubeAxesActor_SetYAxesGridlinesProperty_1186(JNIEnv* env, jobject obj,jobject id0)
{
  vtkProperty * temp0;
  temp0 = static_cast<vtkProperty*>(vtkJavaGetPointerFromObject(env, id0));

  vtkCubeAxesActor* op = static_cast<vtkCubeAxesActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetYAxesGridlinesProperty(temp0);

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkCubeAxesActor_GetYAxesGridlinesProperty_1187(JNIEnv* env, jobject obj)
{
  vtkProperty * temp20;

  vtkCubeAxesActor* op = static_cast<vtkCubeAxesActor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetYAxesGridlinesProperty();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCubeAxesActor_SetZAxesGridlinesProperty_1188(JNIEnv* env, jobject obj,jobject id0)
{
  vtkProperty * temp0;
  temp0 = static_cast<vtkProperty*>(vtkJavaGetPointerFromObject(env, id0));

  vtkCubeAxesActor* op = static_cast<vtkCubeAxesActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetZAxesGridlinesProperty(temp0);

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkCubeAxesActor_GetZAxesGridlinesProperty_1189(JNIEnv* env, jobject obj)
{
  vtkProperty * temp20;

  vtkCubeAxesActor* op = static_cast<vtkCubeAxesActor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetZAxesGridlinesProperty();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCubeAxesActor_SetXAxesInnerGridlinesProperty_1190(JNIEnv* env, jobject obj,jobject id0)
{
  vtkProperty * temp0;
  temp0 = static_cast<vtkProperty*>(vtkJavaGetPointerFromObject(env, id0));

  vtkCubeAxesActor* op = static_cast<vtkCubeAxesActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetXAxesInnerGridlinesProperty(temp0);

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkCubeAxesActor_GetXAxesInnerGridlinesProperty_1191(JNIEnv* env, jobject obj)
{
  vtkProperty * temp20;

  vtkCubeAxesActor* op = static_cast<vtkCubeAxesActor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetXAxesInnerGridlinesProperty();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCubeAxesActor_SetYAxesInnerGridlinesProperty_1192(JNIEnv* env, jobject obj,jobject id0)
{
  vtkProperty * temp0;
  temp0 = static_cast<vtkProperty*>(vtkJavaGetPointerFromObject(env, id0));

  vtkCubeAxesActor* op = static_cast<vtkCubeAxesActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetYAxesInnerGridlinesProperty(temp0);

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkCubeAxesActor_GetYAxesInnerGridlinesProperty_1193(JNIEnv* env, jobject obj)
{
  vtkProperty * temp20;

  vtkCubeAxesActor* op = static_cast<vtkCubeAxesActor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetYAxesInnerGridlinesProperty();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCubeAxesActor_SetZAxesInnerGridlinesProperty_1194(JNIEnv* env, jobject obj,jobject id0)
{
  vtkProperty * temp0;
  temp0 = static_cast<vtkProperty*>(vtkJavaGetPointerFromObject(env, id0));

  vtkCubeAxesActor* op = static_cast<vtkCubeAxesActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetZAxesInnerGridlinesProperty(temp0);

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkCubeAxesActor_GetZAxesInnerGridlinesProperty_1195(JNIEnv* env, jobject obj)
{
  vtkProperty * temp20;

  vtkCubeAxesActor* op = static_cast<vtkCubeAxesActor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetZAxesInnerGridlinesProperty();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCubeAxesActor_SetXAxesGridpolysProperty_1196(JNIEnv* env, jobject obj,jobject id0)
{
  vtkProperty * temp0;
  temp0 = static_cast<vtkProperty*>(vtkJavaGetPointerFromObject(env, id0));

  vtkCubeAxesActor* op = static_cast<vtkCubeAxesActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetXAxesGridpolysProperty(temp0);

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkCubeAxesActor_GetXAxesGridpolysProperty_1197(JNIEnv* env, jobject obj)
{
  vtkProperty * temp20;

  vtkCubeAxesActor* op = static_cast<vtkCubeAxesActor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetXAxesGridpolysProperty();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCubeAxesActor_SetYAxesGridpolysProperty_1198(JNIEnv* env, jobject obj,jobject id0)
{
  vtkProperty * temp0;
  temp0 = static_cast<vtkProperty*>(vtkJavaGetPointerFromObject(env, id0));

  vtkCubeAxesActor* op = static_cast<vtkCubeAxesActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetYAxesGridpolysProperty(temp0);

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkCubeAxesActor_GetYAxesGridpolysProperty_1199(JNIEnv* env, jobject obj)
{
  vtkProperty * temp20;

  vtkCubeAxesActor* op = static_cast<vtkCubeAxesActor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetYAxesGridpolysProperty();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCubeAxesActor_SetZAxesGridpolysProperty_1200(JNIEnv* env, jobject obj,jobject id0)
{
  vtkProperty * temp0;
  temp0 = static_cast<vtkProperty*>(vtkJavaGetPointerFromObject(env, id0));

  vtkCubeAxesActor* op = static_cast<vtkCubeAxesActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetZAxesGridpolysProperty(temp0);

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkCubeAxesActor_GetZAxesGridpolysProperty_1201(JNIEnv* env, jobject obj)
{
  vtkProperty * temp20;

  vtkCubeAxesActor* op = static_cast<vtkCubeAxesActor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetZAxesGridpolysProperty();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCubeAxesActor_SetTickLocation_1202(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkCubeAxesActor* op = static_cast<vtkCubeAxesActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetTickLocation(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkCubeAxesActor_GetTickLocationMinValue_1203(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkCubeAxesActor* op = static_cast<vtkCubeAxesActor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetTickLocationMinValue();
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkCubeAxesActor_GetTickLocationMaxValue_1204(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkCubeAxesActor* op = static_cast<vtkCubeAxesActor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetTickLocationMaxValue();
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkCubeAxesActor_GetTickLocation_1205(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkCubeAxesActor* op = static_cast<vtkCubeAxesActor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetTickLocation();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCubeAxesActor_SetTickLocationToInside_1206(JNIEnv* env, jobject obj)
{

  vtkCubeAxesActor* op = static_cast<vtkCubeAxesActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetTickLocationToInside();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCubeAxesActor_SetTickLocationToOutside_1207(JNIEnv* env, jobject obj)
{

  vtkCubeAxesActor* op = static_cast<vtkCubeAxesActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetTickLocationToOutside();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCubeAxesActor_SetTickLocationToBoth_1208(JNIEnv* env, jobject obj)
{

  vtkCubeAxesActor* op = static_cast<vtkCubeAxesActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetTickLocationToBoth();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCubeAxesActor_SetLabelScaling_1209(JNIEnv* env, jobject obj,jboolean id0,jint id1,jint id2,jint id3)
{
  bool   temp0;
  int   temp1;
  int   temp2;
  int   temp3;
  temp0 = (id0 != 0) ? true : false;
  temp1 = id1;
  temp2 = id2;
  temp3 = id3;

  vtkCubeAxesActor* op = static_cast<vtkCubeAxesActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetLabelScaling(temp0,temp1,temp2,temp3);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCubeAxesActor_SetUseTextActor3D_1210(JNIEnv* env, jobject obj,jboolean id0)
{
  bool   temp0;
  temp0 = (id0 != 0) ? true : false;

  vtkCubeAxesActor* op = static_cast<vtkCubeAxesActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetUseTextActor3D(temp0);

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkCubeAxesActor_GetUseTextActor3D_1211(JNIEnv* env, jobject obj)
{
  bool   temp20;

  vtkCubeAxesActor* op = static_cast<vtkCubeAxesActor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetUseTextActor3D();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCubeAxesActor_SetUse2DMode_1212(JNIEnv* env, jobject obj,jboolean id0)
{
  bool   temp0;
  temp0 = (id0 != 0) ? true : false;

  vtkCubeAxesActor* op = static_cast<vtkCubeAxesActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetUse2DMode(temp0);

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkCubeAxesActor_GetUse2DMode_1213(JNIEnv* env, jobject obj)
{
  bool   temp20;

  vtkCubeAxesActor* op = static_cast<vtkCubeAxesActor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetUse2DMode();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCubeAxesActor_SetSaveTitlePosition_1214(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkCubeAxesActor* op = static_cast<vtkCubeAxesActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetSaveTitlePosition(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCubeAxesActor_SetOrientedBounds_1215(JNIEnv* env, jobject obj,jdouble id0,jdouble id1,jdouble id2,jdouble id3,jdouble id4,jdouble id5)
{
  double   temp0;
  double   temp1;
  double   temp2;
  double   temp3;
  double   temp4;
  double   temp5;
  temp0 = id0;
  temp1 = id1;
  temp2 = id2;
  temp3 = id3;
  temp4 = id4;
  temp5 = id5;

  vtkCubeAxesActor* op = static_cast<vtkCubeAxesActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetOrientedBounds(temp0,temp1,temp2,temp3,temp4,temp5);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCubeAxesActor_SetOrientedBounds_1216(JNIEnv* env, jobject obj,jdoubleArray id0)
{
  double temp0[6];
  env->GetDoubleArrayRegion(id0, 0, 6, &temp0[0]);

  vtkCubeAxesActor* op = static_cast<vtkCubeAxesActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetOrientedBounds(temp0);

}

extern "C" JNIEXPORT jdoubleArray  JNICALL Java_vtk_vtkCubeAxesActor_GetOrientedBounds_1217(JNIEnv* env, jobject obj)
{
  double * temp20;

  vtkCubeAxesActor* op = static_cast<vtkCubeAxesActor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetOrientedBounds();
  return vtkJavaMakeJArrayOfDouble(env, temp20, 6);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCubeAxesActor_SetUseOrientedBounds_1218(JNIEnv* env, jobject obj,jboolean id0)
{
  bool   temp0;
  temp0 = (id0 != 0) ? true : false;

  vtkCubeAxesActor* op = static_cast<vtkCubeAxesActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetUseOrientedBounds(temp0);

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkCubeAxesActor_GetUseOrientedBounds_1219(JNIEnv* env, jobject obj)
{
  bool   temp20;

  vtkCubeAxesActor* op = static_cast<vtkCubeAxesActor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetUseOrientedBounds();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCubeAxesActor_SetAxisBaseForX_1220(JNIEnv* env, jobject obj,jdouble id0,jdouble id1,jdouble id2)
{
  double   temp0;
  double   temp1;
  double   temp2;
  temp0 = id0;
  temp1 = id1;
  temp2 = id2;

  vtkCubeAxesActor* op = static_cast<vtkCubeAxesActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetAxisBaseForX(temp0,temp1,temp2);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCubeAxesActor_SetAxisBaseForX_1221(JNIEnv* env, jobject obj,jdoubleArray id0)
{
  double temp0[3];
  env->GetDoubleArrayRegion(id0, 0, 3, &temp0[0]);

  vtkCubeAxesActor* op = static_cast<vtkCubeAxesActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetAxisBaseForX(temp0);

}

extern "C" JNIEXPORT jdoubleArray  JNICALL Java_vtk_vtkCubeAxesActor_GetAxisBaseForX_1222(JNIEnv* env, jobject obj)
{
  double * temp20;

  vtkCubeAxesActor* op = static_cast<vtkCubeAxesActor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetAxisBaseForX();
  return vtkJavaMakeJArrayOfDouble(env, temp20, 3);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCubeAxesActor_SetAxisBaseForY_1223(JNIEnv* env, jobject obj,jdouble id0,jdouble id1,jdouble id2)
{
  double   temp0;
  double   temp1;
  double   temp2;
  temp0 = id0;
  temp1 = id1;
  temp2 = id2;

  vtkCubeAxesActor* op = static_cast<vtkCubeAxesActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetAxisBaseForY(temp0,temp1,temp2);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCubeAxesActor_SetAxisBaseForY_1224(JNIEnv* env, jobject obj,jdoubleArray id0)
{
  double temp0[3];
  env->GetDoubleArrayRegion(id0, 0, 3, &temp0[0]);

  vtkCubeAxesActor* op = static_cast<vtkCubeAxesActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetAxisBaseForY(temp0);

}

extern "C" JNIEXPORT jdoubleArray  JNICALL Java_vtk_vtkCubeAxesActor_GetAxisBaseForY_1225(JNIEnv* env, jobject obj)
{
  double * temp20;

  vtkCubeAxesActor* op = static_cast<vtkCubeAxesActor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetAxisBaseForY();
  return vtkJavaMakeJArrayOfDouble(env, temp20, 3);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCubeAxesActor_SetAxisBaseForZ_1226(JNIEnv* env, jobject obj,jdouble id0,jdouble id1,jdouble id2)
{
  double   temp0;
  double   temp1;
  double   temp2;
  temp0 = id0;
  temp1 = id1;
  temp2 = id2;

  vtkCubeAxesActor* op = static_cast<vtkCubeAxesActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetAxisBaseForZ(temp0,temp1,temp2);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCubeAxesActor_SetAxisBaseForZ_1227(JNIEnv* env, jobject obj,jdoubleArray id0)
{
  double temp0[3];
  env->GetDoubleArrayRegion(id0, 0, 3, &temp0[0]);

  vtkCubeAxesActor* op = static_cast<vtkCubeAxesActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetAxisBaseForZ(temp0);

}

extern "C" JNIEXPORT jdoubleArray  JNICALL Java_vtk_vtkCubeAxesActor_GetAxisBaseForZ_1228(JNIEnv* env, jobject obj)
{
  double * temp20;

  vtkCubeAxesActor* op = static_cast<vtkCubeAxesActor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetAxisBaseForZ();
  return vtkJavaMakeJArrayOfDouble(env, temp20, 3);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCubeAxesActor_SetAxisOrigin_1229(JNIEnv* env, jobject obj,jdouble id0,jdouble id1,jdouble id2)
{
  double   temp0;
  double   temp1;
  double   temp2;
  temp0 = id0;
  temp1 = id1;
  temp2 = id2;

  vtkCubeAxesActor* op = static_cast<vtkCubeAxesActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetAxisOrigin(temp0,temp1,temp2);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCubeAxesActor_SetAxisOrigin_1230(JNIEnv* env, jobject obj,jdoubleArray id0)
{
  double temp0[3];
  env->GetDoubleArrayRegion(id0, 0, 3, &temp0[0]);

  vtkCubeAxesActor* op = static_cast<vtkCubeAxesActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetAxisOrigin(temp0);

}

extern "C" JNIEXPORT jdoubleArray  JNICALL Java_vtk_vtkCubeAxesActor_GetAxisOrigin_1231(JNIEnv* env, jobject obj)
{
  double * temp20;

  vtkCubeAxesActor* op = static_cast<vtkCubeAxesActor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetAxisOrigin();
  return vtkJavaMakeJArrayOfDouble(env, temp20, 3);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCubeAxesActor_SetUseAxisOrigin_1232(JNIEnv* env, jobject obj,jboolean id0)
{
  bool   temp0;
  temp0 = (id0 != 0) ? true : false;

  vtkCubeAxesActor* op = static_cast<vtkCubeAxesActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetUseAxisOrigin(temp0);

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkCubeAxesActor_GetUseAxisOrigin_1233(JNIEnv* env, jobject obj)
{
  bool   temp20;

  vtkCubeAxesActor* op = static_cast<vtkCubeAxesActor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetUseAxisOrigin();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCubeAxesActor_SetGridLineLocation_1234(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkCubeAxesActor* op = static_cast<vtkCubeAxesActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetGridLineLocation(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkCubeAxesActor_GetGridLineLocation_1235(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkCubeAxesActor* op = static_cast<vtkCubeAxesActor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetGridLineLocation();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCubeAxesActor_SetStickyAxes_1236(JNIEnv* env, jobject obj,jboolean id0)
{
  bool   temp0;
  temp0 = (id0 != 0) ? true : false;

  vtkCubeAxesActor* op = static_cast<vtkCubeAxesActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetStickyAxes(temp0);

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkCubeAxesActor_GetStickyAxes_1237(JNIEnv* env, jobject obj)
{
  bool   temp20;

  vtkCubeAxesActor* op = static_cast<vtkCubeAxesActor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetStickyAxes();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCubeAxesActor_StickyAxesOn_1238(JNIEnv* env, jobject obj)
{

  vtkCubeAxesActor* op = static_cast<vtkCubeAxesActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->StickyAxesOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCubeAxesActor_StickyAxesOff_1239(JNIEnv* env, jobject obj)
{

  vtkCubeAxesActor* op = static_cast<vtkCubeAxesActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->StickyAxesOff();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCubeAxesActor_SetCenterStickyAxes_1240(JNIEnv* env, jobject obj,jboolean id0)
{
  bool   temp0;
  temp0 = (id0 != 0) ? true : false;

  vtkCubeAxesActor* op = static_cast<vtkCubeAxesActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetCenterStickyAxes(temp0);

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkCubeAxesActor_GetCenterStickyAxes_1241(JNIEnv* env, jobject obj)
{
  bool   temp20;

  vtkCubeAxesActor* op = static_cast<vtkCubeAxesActor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetCenterStickyAxes();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCubeAxesActor_CenterStickyAxesOn_1242(JNIEnv* env, jobject obj)
{

  vtkCubeAxesActor* op = static_cast<vtkCubeAxesActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->CenterStickyAxesOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCubeAxesActor_CenterStickyAxesOff_1243(JNIEnv* env, jobject obj)
{

  vtkCubeAxesActor* op = static_cast<vtkCubeAxesActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->CenterStickyAxesOff();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCubeAxesActor_GetBounds_1244(JNIEnv* env, jobject obj,jdoubleArray id0)
{
  double temp0[6];
  env->GetDoubleArrayRegion(id0, 0, 6, &temp0[0]);

  vtkCubeAxesActor* op = static_cast<vtkCubeAxesActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->GetBounds(temp0);
  env->SetDoubleArrayRegion(id0, 0, 6, &temp0[0]);

}

extern "C" JNIEXPORT jlong JNICALL Java_vtk_vtkCubeAxesActor_VTKInit(JNIEnv*, jobject)
{
  return reinterpret_cast<jlong>(vtkCubeAxesActor::New());
}
