// java wrapper for vtkBorderRepresentation object
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkABI.h"
#include "vtkSystemIncludes.h"
#include "vtkBorderRepresentation.h"
#include "vtkJavaUtil.h"

#include "vtkStdString.h"

#include <sstream>
extern "C" JNIEXPORT void* vtkWidgetRepresentation_Typecast(void* op,char* dType);

extern "C" JNIEXPORT void* vtkBorderRepresentation_Typecast(void* me,char* dType)
{
  void* res;
  if (!strcmp("vtkBorderRepresentation",dType)) { return me; }
  if ((res= vtkWidgetRepresentation_Typecast(me,dType)) != nullptr) { return res; }
  return nullptr;
}


extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkBorderRepresentation_IsTypeOf_10(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkBorderRepresentation* op = static_cast<vtkBorderRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsTypeOf(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkBorderRepresentation_IsA_11(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkBorderRepresentation* op = static_cast<vtkBorderRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsA(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkBorderRepresentation_GetNumberOfGenerationsFromBaseType_12(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkBorderRepresentation* op = static_cast<vtkBorderRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBaseType(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkBorderRepresentation_GetNumberOfGenerationsFromBase_13(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkBorderRepresentation* op = static_cast<vtkBorderRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBase(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkBorderRepresentation_GetPositionCoordinate_14(JNIEnv* env, jobject obj)
{
  vtkCoordinate * temp20;

  vtkBorderRepresentation* op = static_cast<vtkBorderRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetPositionCoordinate();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkBorderRepresentation_SetPosition_15(JNIEnv* env, jobject obj,jdoubleArray id0)
{
  double temp0[2];
  env->GetDoubleArrayRegion(id0, 0, 2, &temp0[0]);

  vtkBorderRepresentation* op = static_cast<vtkBorderRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetPosition(temp0);
  env->SetDoubleArrayRegion(id0, 0, 2, &temp0[0]);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkBorderRepresentation_SetPosition_16(JNIEnv* env, jobject obj,jdouble id0,jdouble id1)
{
  double   temp0;
  double   temp1;
  temp0 = id0;
  temp1 = id1;

  vtkBorderRepresentation* op = static_cast<vtkBorderRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetPosition(temp0,temp1);

}

extern "C" JNIEXPORT jdoubleArray  JNICALL Java_vtk_vtkBorderRepresentation_GetPosition_17(JNIEnv* env, jobject obj)
{
  double * temp20;

  vtkBorderRepresentation* op = static_cast<vtkBorderRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetPosition();
  return vtkJavaMakeJArrayOfDouble(env, temp20, 2);

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkBorderRepresentation_GetPosition2Coordinate_18(JNIEnv* env, jobject obj)
{
  vtkCoordinate * temp20;

  vtkBorderRepresentation* op = static_cast<vtkBorderRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetPosition2Coordinate();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkBorderRepresentation_SetPosition2_19(JNIEnv* env, jobject obj,jdoubleArray id0)
{
  double temp0[2];
  env->GetDoubleArrayRegion(id0, 0, 2, &temp0[0]);

  vtkBorderRepresentation* op = static_cast<vtkBorderRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetPosition2(temp0);
  env->SetDoubleArrayRegion(id0, 0, 2, &temp0[0]);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkBorderRepresentation_SetPosition2_110(JNIEnv* env, jobject obj,jdouble id0,jdouble id1)
{
  double   temp0;
  double   temp1;
  temp0 = id0;
  temp1 = id1;

  vtkBorderRepresentation* op = static_cast<vtkBorderRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetPosition2(temp0,temp1);

}

extern "C" JNIEXPORT jdoubleArray  JNICALL Java_vtk_vtkBorderRepresentation_GetPosition2_111(JNIEnv* env, jobject obj)
{
  double * temp20;

  vtkBorderRepresentation* op = static_cast<vtkBorderRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetPosition2();
  return vtkJavaMakeJArrayOfDouble(env, temp20, 2);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkBorderRepresentation_SetShowBorder_112(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkBorderRepresentation* op = static_cast<vtkBorderRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetShowBorder(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkBorderRepresentation_GetShowBorderMinValue_113(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkBorderRepresentation* op = static_cast<vtkBorderRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetShowBorderMinValue();
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkBorderRepresentation_GetShowBorderMaxValue_114(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkBorderRepresentation* op = static_cast<vtkBorderRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetShowBorderMaxValue();
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkBorderRepresentation_GetShowBorder_115(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkBorderRepresentation* op = static_cast<vtkBorderRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetShowBorder();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkBorderRepresentation_SetShowBorderToOff_116(JNIEnv* env, jobject obj)
{

  vtkBorderRepresentation* op = static_cast<vtkBorderRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetShowBorderToOff();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkBorderRepresentation_SetShowBorderToOn_117(JNIEnv* env, jobject obj)
{

  vtkBorderRepresentation* op = static_cast<vtkBorderRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetShowBorderToOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkBorderRepresentation_SetShowBorderToActive_118(JNIEnv* env, jobject obj)
{

  vtkBorderRepresentation* op = static_cast<vtkBorderRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetShowBorderToActive();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkBorderRepresentation_SetShowVerticalBorder_119(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkBorderRepresentation* op = static_cast<vtkBorderRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetShowVerticalBorder(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkBorderRepresentation_GetShowVerticalBorderMinValue_120(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkBorderRepresentation* op = static_cast<vtkBorderRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetShowVerticalBorderMinValue();
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkBorderRepresentation_GetShowVerticalBorderMaxValue_121(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkBorderRepresentation* op = static_cast<vtkBorderRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetShowVerticalBorderMaxValue();
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkBorderRepresentation_GetShowVerticalBorder_122(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkBorderRepresentation* op = static_cast<vtkBorderRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetShowVerticalBorder();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkBorderRepresentation_SetShowHorizontalBorder_123(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkBorderRepresentation* op = static_cast<vtkBorderRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetShowHorizontalBorder(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkBorderRepresentation_GetShowHorizontalBorderMinValue_124(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkBorderRepresentation* op = static_cast<vtkBorderRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetShowHorizontalBorderMinValue();
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkBorderRepresentation_GetShowHorizontalBorderMaxValue_125(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkBorderRepresentation* op = static_cast<vtkBorderRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetShowHorizontalBorderMaxValue();
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkBorderRepresentation_GetShowHorizontalBorder_126(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkBorderRepresentation* op = static_cast<vtkBorderRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetShowHorizontalBorder();
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkBorderRepresentation_GetBorderProperty_127(JNIEnv* env, jobject obj)
{
  vtkProperty2D * temp20;

  vtkBorderRepresentation* op = static_cast<vtkBorderRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetBorderProperty();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkBorderRepresentation_SetShowPolygon_128(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkBorderRepresentation* op = static_cast<vtkBorderRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetShowPolygon(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkBorderRepresentation_GetShowPolygon_129(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkBorderRepresentation* op = static_cast<vtkBorderRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetShowPolygon();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkBorderRepresentation_SetShowPolygonToOff_130(JNIEnv* env, jobject obj)
{

  vtkBorderRepresentation* op = static_cast<vtkBorderRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetShowPolygonToOff();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkBorderRepresentation_SetShowPolygonToOn_131(JNIEnv* env, jobject obj)
{

  vtkBorderRepresentation* op = static_cast<vtkBorderRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetShowPolygonToOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkBorderRepresentation_SetShowPolygonToActive_132(JNIEnv* env, jobject obj)
{

  vtkBorderRepresentation* op = static_cast<vtkBorderRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetShowPolygonToActive();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkBorderRepresentation_SetShowPolygonBackground_133(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkBorderRepresentation* op = static_cast<vtkBorderRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetShowPolygonBackground(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkBorderRepresentation_GetShowPolygonBackgroundMinValue_134(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkBorderRepresentation* op = static_cast<vtkBorderRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetShowPolygonBackgroundMinValue();
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkBorderRepresentation_GetShowPolygonBackgroundMaxValue_135(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkBorderRepresentation* op = static_cast<vtkBorderRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetShowPolygonBackgroundMaxValue();
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkBorderRepresentation_GetShowPolygonBackground_136(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkBorderRepresentation* op = static_cast<vtkBorderRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetShowPolygonBackground();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkBorderRepresentation_SetEnforceNormalizedViewportBounds_137(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkBorderRepresentation* op = static_cast<vtkBorderRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetEnforceNormalizedViewportBounds(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkBorderRepresentation_GetEnforceNormalizedViewportBounds_138(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkBorderRepresentation* op = static_cast<vtkBorderRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetEnforceNormalizedViewportBounds();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkBorderRepresentation_EnforceNormalizedViewportBoundsOn_139(JNIEnv* env, jobject obj)
{

  vtkBorderRepresentation* op = static_cast<vtkBorderRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  op->EnforceNormalizedViewportBoundsOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkBorderRepresentation_EnforceNormalizedViewportBoundsOff_140(JNIEnv* env, jobject obj)
{

  vtkBorderRepresentation* op = static_cast<vtkBorderRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  op->EnforceNormalizedViewportBoundsOff();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkBorderRepresentation_SetProportionalResize_141(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkBorderRepresentation* op = static_cast<vtkBorderRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetProportionalResize(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkBorderRepresentation_GetProportionalResize_142(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkBorderRepresentation* op = static_cast<vtkBorderRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetProportionalResize();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkBorderRepresentation_ProportionalResizeOn_143(JNIEnv* env, jobject obj)
{

  vtkBorderRepresentation* op = static_cast<vtkBorderRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  op->ProportionalResizeOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkBorderRepresentation_ProportionalResizeOff_144(JNIEnv* env, jobject obj)
{

  vtkBorderRepresentation* op = static_cast<vtkBorderRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  op->ProportionalResizeOff();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkBorderRepresentation_SetMinimumNormalizedViewportSize_145(JNIEnv* env, jobject obj,jdouble id0,jdouble id1)
{
  double   temp0;
  double   temp1;
  temp0 = id0;
  temp1 = id1;

  vtkBorderRepresentation* op = static_cast<vtkBorderRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetMinimumNormalizedViewportSize(temp0,temp1);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkBorderRepresentation_SetMinimumNormalizedViewportSize_146(JNIEnv* env, jobject obj,jdoubleArray id0)
{
  double temp0[2];
  env->GetDoubleArrayRegion(id0, 0, 2, &temp0[0]);

  vtkBorderRepresentation* op = static_cast<vtkBorderRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetMinimumNormalizedViewportSize(temp0);

}

extern "C" JNIEXPORT jdoubleArray  JNICALL Java_vtk_vtkBorderRepresentation_GetMinimumNormalizedViewportSize_147(JNIEnv* env, jobject obj)
{
  double * temp20;

  vtkBorderRepresentation* op = static_cast<vtkBorderRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetMinimumNormalizedViewportSize();
  return vtkJavaMakeJArrayOfDouble(env, temp20, 2);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkBorderRepresentation_SetMinimumSize_148(JNIEnv* env, jobject obj,jint id0,jint id1)
{
  int   temp0;
  int   temp1;
  temp0 = id0;
  temp1 = id1;

  vtkBorderRepresentation* op = static_cast<vtkBorderRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetMinimumSize(temp0,temp1);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkBorderRepresentation_SetMinimumSize_149(JNIEnv* env, jobject obj,jintArray id0)
{
  int temp0[2];
  env->GetIntArrayRegion(id0, 0, 2, reinterpret_cast<jint*>(&temp0[0]));

  vtkBorderRepresentation* op = static_cast<vtkBorderRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetMinimumSize(temp0);

}

extern "C" JNIEXPORT jintArray  JNICALL Java_vtk_vtkBorderRepresentation_GetMinimumSize_150(JNIEnv* env, jobject obj)
{
  int * temp20;

  vtkBorderRepresentation* op = static_cast<vtkBorderRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetMinimumSize();
  return vtkJavaMakeJArrayOfInt(env, reinterpret_cast<jint*>(temp20), 2);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkBorderRepresentation_SetMaximumSize_151(JNIEnv* env, jobject obj,jint id0,jint id1)
{
  int   temp0;
  int   temp1;
  temp0 = id0;
  temp1 = id1;

  vtkBorderRepresentation* op = static_cast<vtkBorderRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetMaximumSize(temp0,temp1);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkBorderRepresentation_SetMaximumSize_152(JNIEnv* env, jobject obj,jintArray id0)
{
  int temp0[2];
  env->GetIntArrayRegion(id0, 0, 2, reinterpret_cast<jint*>(&temp0[0]));

  vtkBorderRepresentation* op = static_cast<vtkBorderRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetMaximumSize(temp0);

}

extern "C" JNIEXPORT jintArray  JNICALL Java_vtk_vtkBorderRepresentation_GetMaximumSize_153(JNIEnv* env, jobject obj)
{
  int * temp20;

  vtkBorderRepresentation* op = static_cast<vtkBorderRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetMaximumSize();
  return vtkJavaMakeJArrayOfInt(env, reinterpret_cast<jint*>(temp20), 2);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkBorderRepresentation_SetTolerance_154(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkBorderRepresentation* op = static_cast<vtkBorderRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetTolerance(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkBorderRepresentation_GetToleranceMinValue_155(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkBorderRepresentation* op = static_cast<vtkBorderRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetToleranceMinValue();
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkBorderRepresentation_GetToleranceMaxValue_156(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkBorderRepresentation* op = static_cast<vtkBorderRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetToleranceMaxValue();
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkBorderRepresentation_GetTolerance_157(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkBorderRepresentation* op = static_cast<vtkBorderRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetTolerance();
  return temp20;

}

extern "C" JNIEXPORT jdoubleArray  JNICALL Java_vtk_vtkBorderRepresentation_GetSelectionPoint_158(JNIEnv* env, jobject obj)
{
  double * temp20;

  vtkBorderRepresentation* op = static_cast<vtkBorderRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetSelectionPoint();
  return vtkJavaMakeJArrayOfDouble(env, temp20, 2);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkBorderRepresentation_SetMoving_159(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkBorderRepresentation* op = static_cast<vtkBorderRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetMoving(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkBorderRepresentation_GetMoving_160(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkBorderRepresentation* op = static_cast<vtkBorderRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetMoving();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkBorderRepresentation_MovingOn_161(JNIEnv* env, jobject obj)
{

  vtkBorderRepresentation* op = static_cast<vtkBorderRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  op->MovingOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkBorderRepresentation_MovingOff_162(JNIEnv* env, jobject obj)
{

  vtkBorderRepresentation* op = static_cast<vtkBorderRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  op->MovingOff();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkBorderRepresentation_SetWindowLocation_163(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkBorderRepresentation* op = static_cast<vtkBorderRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetWindowLocation(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkBorderRepresentation_GetWindowLocation_164(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkBorderRepresentation* op = static_cast<vtkBorderRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetWindowLocation();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkBorderRepresentation_UpdateWindowLocation_165(JNIEnv* env, jobject obj)
{

  vtkBorderRepresentation* op = static_cast<vtkBorderRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  op->UpdateWindowLocation();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkBorderRepresentation_SetInteractionState_166(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkBorderRepresentation* op = static_cast<vtkBorderRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetInteractionState(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkBorderRepresentation_GetInteractionStateMinValue_167(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkBorderRepresentation* op = static_cast<vtkBorderRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetInteractionStateMinValue();
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkBorderRepresentation_GetInteractionStateMaxValue_168(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkBorderRepresentation* op = static_cast<vtkBorderRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetInteractionStateMaxValue();
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkBorderRepresentation_GetMTime_169(JNIEnv* env, jobject obj)
{
   unsigned long   temp20;

  vtkBorderRepresentation* op = static_cast<vtkBorderRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetMTime();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkBorderRepresentation_BuildRepresentation_170(JNIEnv* env, jobject obj)
{

  vtkBorderRepresentation* op = static_cast<vtkBorderRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  op->BuildRepresentation();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkBorderRepresentation_StartWidgetInteraction_171(JNIEnv* env, jobject obj,jdoubleArray id0)
{
  double temp0[2];
  env->GetDoubleArrayRegion(id0, 0, 2, &temp0[0]);

  vtkBorderRepresentation* op = static_cast<vtkBorderRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  op->StartWidgetInteraction(temp0);
  env->SetDoubleArrayRegion(id0, 0, 2, &temp0[0]);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkBorderRepresentation_WidgetInteraction_172(JNIEnv* env, jobject obj,jdoubleArray id0)
{
  double temp0[2];
  env->GetDoubleArrayRegion(id0, 0, 2, &temp0[0]);

  vtkBorderRepresentation* op = static_cast<vtkBorderRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  op->WidgetInteraction(temp0);
  env->SetDoubleArrayRegion(id0, 0, 2, &temp0[0]);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkBorderRepresentation_GetSize_173(JNIEnv* env, jobject obj,jdoubleArray id0)
{
  double temp0[2];
  env->GetDoubleArrayRegion(id0, 0, 2, &temp0[0]);

  vtkBorderRepresentation* op = static_cast<vtkBorderRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  op->GetSize(temp0);
  env->SetDoubleArrayRegion(id0, 0, 2, &temp0[0]);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkBorderRepresentation_ComputeInteractionState_174(JNIEnv* env, jobject obj,jint id0,jint id1,jint id2)
{
  int   temp0;
  int   temp1;
  int   temp2;
  int   temp20;
  temp0 = id0;
  temp1 = id1;
  temp2 = id2;

  vtkBorderRepresentation* op = static_cast<vtkBorderRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->ComputeInteractionState(temp0,temp1,temp2);
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkBorderRepresentation_GetActors2D_175(JNIEnv* env, jobject obj,jobject id0)
{
  vtkPropCollection * temp0;
  temp0 = static_cast<vtkPropCollection*>(vtkJavaGetPointerFromObject(env, id0));

  vtkBorderRepresentation* op = static_cast<vtkBorderRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  op->GetActors2D(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkBorderRepresentation_ReleaseGraphicsResources_176(JNIEnv* env, jobject obj,jobject id0)
{
  vtkWindow * temp0;
  temp0 = static_cast<vtkWindow*>(vtkJavaGetPointerFromObject(env, id0));

  vtkBorderRepresentation* op = static_cast<vtkBorderRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  op->ReleaseGraphicsResources(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkBorderRepresentation_RenderOverlay_177(JNIEnv* env, jobject obj,jobject id0)
{
  vtkViewport * temp0;
  int   temp20;
  temp0 = static_cast<vtkViewport*>(vtkJavaGetPointerFromObject(env, id0));

  vtkBorderRepresentation* op = static_cast<vtkBorderRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->RenderOverlay(temp0);
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkBorderRepresentation_RenderOpaqueGeometry_178(JNIEnv* env, jobject obj,jobject id0)
{
  vtkViewport * temp0;
  int   temp20;
  temp0 = static_cast<vtkViewport*>(vtkJavaGetPointerFromObject(env, id0));

  vtkBorderRepresentation* op = static_cast<vtkBorderRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->RenderOpaqueGeometry(temp0);
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkBorderRepresentation_RenderTranslucentPolygonalGeometry_179(JNIEnv* env, jobject obj,jobject id0)
{
  vtkViewport * temp0;
  int   temp20;
  temp0 = static_cast<vtkViewport*>(vtkJavaGetPointerFromObject(env, id0));

  vtkBorderRepresentation* op = static_cast<vtkBorderRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->RenderTranslucentPolygonalGeometry(temp0);
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkBorderRepresentation_HasTranslucentPolygonalGeometry_180(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkBorderRepresentation* op = static_cast<vtkBorderRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->HasTranslucentPolygonalGeometry();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkBorderRepresentation_SetBWActorDisplayOverlayEdges_181(JNIEnv* env, jobject obj,jboolean id0)
{
  bool   temp0;
  temp0 = (id0 != 0) ? true : false;

  vtkBorderRepresentation* op = static_cast<vtkBorderRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetBWActorDisplayOverlayEdges(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkBorderRepresentation_SetBWActorDisplayOverlayPolygon_182(JNIEnv* env, jobject obj,jboolean id0)
{
  bool   temp0;
  temp0 = (id0 != 0) ? true : false;

  vtkBorderRepresentation* op = static_cast<vtkBorderRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetBWActorDisplayOverlayPolygon(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkBorderRepresentation_SetBorderColor_183(JNIEnv* env, jobject obj,jdouble id0,jdouble id1,jdouble id2)
{
  double   temp0;
  double   temp1;
  double   temp2;
  temp0 = id0;
  temp1 = id1;
  temp2 = id2;

  vtkBorderRepresentation* op = static_cast<vtkBorderRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetBorderColor(temp0,temp1,temp2);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkBorderRepresentation_SetBorderColor_184(JNIEnv* env, jobject obj,jdoubleArray id0)
{
  double temp0[3];
  env->GetDoubleArrayRegion(id0, 0, 3, &temp0[0]);

  vtkBorderRepresentation* op = static_cast<vtkBorderRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetBorderColor(temp0);

}

extern "C" JNIEXPORT jdoubleArray  JNICALL Java_vtk_vtkBorderRepresentation_GetBorderColor_185(JNIEnv* env, jobject obj)
{
  double * temp20;

  vtkBorderRepresentation* op = static_cast<vtkBorderRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetBorderColor();
  return vtkJavaMakeJArrayOfDouble(env, temp20, 3);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkBorderRepresentation_SetBorderThickness_186(JNIEnv* env, jobject obj,jfloat id0)
{
  float   temp0;
  temp0 = id0;

  vtkBorderRepresentation* op = static_cast<vtkBorderRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetBorderThickness(temp0);

}

extern "C" JNIEXPORT jfloat  JNICALL Java_vtk_vtkBorderRepresentation_GetBorderThicknessMinValue_187(JNIEnv* env, jobject obj)
{
  float   temp20;

  vtkBorderRepresentation* op = static_cast<vtkBorderRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetBorderThicknessMinValue();
  return temp20;

}

extern "C" JNIEXPORT jfloat  JNICALL Java_vtk_vtkBorderRepresentation_GetBorderThicknessMaxValue_188(JNIEnv* env, jobject obj)
{
  float   temp20;

  vtkBorderRepresentation* op = static_cast<vtkBorderRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetBorderThicknessMaxValue();
  return temp20;

}

extern "C" JNIEXPORT jfloat  JNICALL Java_vtk_vtkBorderRepresentation_GetBorderThickness_189(JNIEnv* env, jobject obj)
{
  float   temp20;

  vtkBorderRepresentation* op = static_cast<vtkBorderRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetBorderThickness();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkBorderRepresentation_SetCornerRadiusStrength_190(JNIEnv* env, jobject obj,jdouble id0)
{
  double   temp0;
  temp0 = id0;

  vtkBorderRepresentation* op = static_cast<vtkBorderRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetCornerRadiusStrength(temp0);

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkBorderRepresentation_GetCornerRadiusStrengthMinValue_191(JNIEnv* env, jobject obj)
{
  double   temp20;

  vtkBorderRepresentation* op = static_cast<vtkBorderRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetCornerRadiusStrengthMinValue();
  return temp20;

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkBorderRepresentation_GetCornerRadiusStrengthMaxValue_192(JNIEnv* env, jobject obj)
{
  double   temp20;

  vtkBorderRepresentation* op = static_cast<vtkBorderRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetCornerRadiusStrengthMaxValue();
  return temp20;

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkBorderRepresentation_GetCornerRadiusStrength_193(JNIEnv* env, jobject obj)
{
  double   temp20;

  vtkBorderRepresentation* op = static_cast<vtkBorderRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetCornerRadiusStrength();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkBorderRepresentation_SetCornerResolution_194(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkBorderRepresentation* op = static_cast<vtkBorderRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetCornerResolution(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkBorderRepresentation_GetCornerResolutionMinValue_195(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkBorderRepresentation* op = static_cast<vtkBorderRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetCornerResolutionMinValue();
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkBorderRepresentation_GetCornerResolutionMaxValue_196(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkBorderRepresentation* op = static_cast<vtkBorderRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetCornerResolutionMaxValue();
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkBorderRepresentation_GetCornerResolution_197(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkBorderRepresentation* op = static_cast<vtkBorderRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetCornerResolution();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkBorderRepresentation_SetPolygonColor_198(JNIEnv* env, jobject obj,jdouble id0,jdouble id1,jdouble id2)
{
  double   temp0;
  double   temp1;
  double   temp2;
  temp0 = id0;
  temp1 = id1;
  temp2 = id2;

  vtkBorderRepresentation* op = static_cast<vtkBorderRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetPolygonColor(temp0,temp1,temp2);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkBorderRepresentation_SetPolygonColor_199(JNIEnv* env, jobject obj,jdoubleArray id0)
{
  double temp0[3];
  env->GetDoubleArrayRegion(id0, 0, 3, &temp0[0]);

  vtkBorderRepresentation* op = static_cast<vtkBorderRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetPolygonColor(temp0);

}

extern "C" JNIEXPORT jdoubleArray  JNICALL Java_vtk_vtkBorderRepresentation_GetPolygonColor_1100(JNIEnv* env, jobject obj)
{
  double * temp20;

  vtkBorderRepresentation* op = static_cast<vtkBorderRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetPolygonColor();
  return vtkJavaMakeJArrayOfDouble(env, temp20, 3);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkBorderRepresentation_SetPolygonOpacity_1101(JNIEnv* env, jobject obj,jdouble id0)
{
  double   temp0;
  temp0 = id0;

  vtkBorderRepresentation* op = static_cast<vtkBorderRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetPolygonOpacity(temp0);

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkBorderRepresentation_GetPolygonOpacityMinValue_1102(JNIEnv* env, jobject obj)
{
  double   temp20;

  vtkBorderRepresentation* op = static_cast<vtkBorderRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetPolygonOpacityMinValue();
  return temp20;

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkBorderRepresentation_GetPolygonOpacityMaxValue_1103(JNIEnv* env, jobject obj)
{
  double   temp20;

  vtkBorderRepresentation* op = static_cast<vtkBorderRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetPolygonOpacityMaxValue();
  return temp20;

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkBorderRepresentation_GetPolygonOpacity_1104(JNIEnv* env, jobject obj)
{
  double   temp20;

  vtkBorderRepresentation* op = static_cast<vtkBorderRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetPolygonOpacity();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkBorderRepresentation_SetPolygonRGBA_1105(JNIEnv* env, jobject obj,jdoubleArray id0)
{
  double temp0[4];
  env->GetDoubleArrayRegion(id0, 0, 4, &temp0[0]);

  vtkBorderRepresentation* op = static_cast<vtkBorderRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetPolygonRGBA(temp0);
  env->SetDoubleArrayRegion(id0, 0, 4, &temp0[0]);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkBorderRepresentation_SetPolygonRGBA_1106(JNIEnv* env, jobject obj,jdouble id0,jdouble id1,jdouble id2,jdouble id3)
{
  double   temp0;
  double   temp1;
  double   temp2;
  double   temp3;
  temp0 = id0;
  temp1 = id1;
  temp2 = id2;
  temp3 = id3;

  vtkBorderRepresentation* op = static_cast<vtkBorderRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetPolygonRGBA(temp0,temp1,temp2,temp3);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkBorderRepresentation_GetPolygonRGBA_1107(JNIEnv* env, jobject obj,jdoubleArray id0)
{
  double temp0[4];
  env->GetDoubleArrayRegion(id0, 0, 4, &temp0[0]);

  vtkBorderRepresentation* op = static_cast<vtkBorderRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  op->GetPolygonRGBA(temp0);
  env->SetDoubleArrayRegion(id0, 0, 4, &temp0[0]);

}

extern "C" JNIEXPORT jlong JNICALL Java_vtk_vtkBorderRepresentation_VTKInit(JNIEnv*, jobject)
{
  return reinterpret_cast<jlong>(vtkBorderRepresentation::New());
}
