// java wrapper for vtkStreamTracer object
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkABI.h"
#include "vtkSystemIncludes.h"
#include "vtkStreamTracer.h"
#include "vtkJavaUtil.h"

#include "vtkStdString.h"

#include <sstream>
extern "C" JNIEXPORT void* vtkPolyDataAlgorithm_Typecast(void* op,char* dType);

extern "C" JNIEXPORT void* vtkStreamTracer_Typecast(void* me,char* dType)
{
  void* res;
  if (!strcmp("vtkStreamTracer",dType)) { return me; }
  if ((res= vtkPolyDataAlgorithm_Typecast(me,dType)) != nullptr) { return res; }
  return nullptr;
}


extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkStreamTracer_IsTypeOf_10(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkStreamTracer* op = static_cast<vtkStreamTracer*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsTypeOf(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkStreamTracer_IsA_11(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkStreamTracer* op = static_cast<vtkStreamTracer*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsA(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkStreamTracer_GetNumberOfGenerationsFromBaseType_12(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkStreamTracer* op = static_cast<vtkStreamTracer*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBaseType(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkStreamTracer_GetNumberOfGenerationsFromBase_13(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkStreamTracer* op = static_cast<vtkStreamTracer*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBase(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkStreamTracer_SetStartPosition_14(JNIEnv* env, jobject obj,jdouble id0,jdouble id1,jdouble id2)
{
  double   temp0;
  double   temp1;
  double   temp2;
  temp0 = id0;
  temp1 = id1;
  temp2 = id2;

  vtkStreamTracer* op = static_cast<vtkStreamTracer*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetStartPosition(temp0,temp1,temp2);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkStreamTracer_SetStartPosition_15(JNIEnv* env, jobject obj,jdoubleArray id0)
{
  double temp0[3];
  env->GetDoubleArrayRegion(id0, 0, 3, &temp0[0]);

  vtkStreamTracer* op = static_cast<vtkStreamTracer*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetStartPosition(temp0);

}

extern "C" JNIEXPORT jdoubleArray  JNICALL Java_vtk_vtkStreamTracer_GetStartPosition_16(JNIEnv* env, jobject obj)
{
  double * temp20;

  vtkStreamTracer* op = static_cast<vtkStreamTracer*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetStartPosition();
  return vtkJavaMakeJArrayOfDouble(env, temp20, 3);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkStreamTracer_SetSourceData_17(JNIEnv* env, jobject obj,jobject id0)
{
  vtkDataSet * temp0;
  temp0 = static_cast<vtkDataSet*>(vtkJavaGetPointerFromObject(env, id0));

  vtkStreamTracer* op = static_cast<vtkStreamTracer*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetSourceData(temp0);

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkStreamTracer_GetSource_18(JNIEnv* env, jobject obj)
{
  vtkDataSet * temp20;

  vtkStreamTracer* op = static_cast<vtkStreamTracer*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetSource();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkStreamTracer_SetSourceConnection_19(JNIEnv* env, jobject obj,jobject id0)
{
  vtkAlgorithmOutput * temp0;
  temp0 = static_cast<vtkAlgorithmOutput*>(vtkJavaGetPointerFromObject(env, id0));

  vtkStreamTracer* op = static_cast<vtkStreamTracer*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetSourceConnection(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkStreamTracer_SetIntegrator_110(JNIEnv* env, jobject obj,jobject id0)
{
  vtkInitialValueProblemSolver * temp0;
  temp0 = static_cast<vtkInitialValueProblemSolver*>(vtkJavaGetPointerFromObject(env, id0));

  vtkStreamTracer* op = static_cast<vtkStreamTracer*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetIntegrator(temp0);

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkStreamTracer_GetIntegrator_111(JNIEnv* env, jobject obj)
{
  vtkInitialValueProblemSolver * temp20;

  vtkStreamTracer* op = static_cast<vtkStreamTracer*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetIntegrator();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkStreamTracer_SetIntegratorType_112(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkStreamTracer* op = static_cast<vtkStreamTracer*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetIntegratorType(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkStreamTracer_GetIntegratorType_113(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkStreamTracer* op = static_cast<vtkStreamTracer*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetIntegratorType();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkStreamTracer_SetIntegratorTypeToRungeKutta2_114(JNIEnv* env, jobject obj)
{

  vtkStreamTracer* op = static_cast<vtkStreamTracer*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetIntegratorTypeToRungeKutta2();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkStreamTracer_SetIntegratorTypeToRungeKutta4_115(JNIEnv* env, jobject obj)
{

  vtkStreamTracer* op = static_cast<vtkStreamTracer*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetIntegratorTypeToRungeKutta4();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkStreamTracer_SetIntegratorTypeToRungeKutta45_116(JNIEnv* env, jobject obj)
{

  vtkStreamTracer* op = static_cast<vtkStreamTracer*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetIntegratorTypeToRungeKutta45();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkStreamTracer_SetInterpolatorTypeToDataSetPointLocator_117(JNIEnv* env, jobject obj)
{

  vtkStreamTracer* op = static_cast<vtkStreamTracer*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetInterpolatorTypeToDataSetPointLocator();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkStreamTracer_SetInterpolatorTypeToCellLocator_118(JNIEnv* env, jobject obj)
{

  vtkStreamTracer* op = static_cast<vtkStreamTracer*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetInterpolatorTypeToCellLocator();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkStreamTracer_SetMaximumPropagation_119(JNIEnv* env, jobject obj,jdouble id0)
{
  double   temp0;
  temp0 = id0;

  vtkStreamTracer* op = static_cast<vtkStreamTracer*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetMaximumPropagation(temp0);

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkStreamTracer_GetMaximumPropagation_120(JNIEnv* env, jobject obj)
{
  double   temp20;

  vtkStreamTracer* op = static_cast<vtkStreamTracer*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetMaximumPropagation();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkStreamTracer_SetIntegrationStepUnit_121(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkStreamTracer* op = static_cast<vtkStreamTracer*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetIntegrationStepUnit(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkStreamTracer_GetIntegrationStepUnit_122(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkStreamTracer* op = static_cast<vtkStreamTracer*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetIntegrationStepUnit();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkStreamTracer_SetInitialIntegrationStep_123(JNIEnv* env, jobject obj,jdouble id0)
{
  double   temp0;
  temp0 = id0;

  vtkStreamTracer* op = static_cast<vtkStreamTracer*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetInitialIntegrationStep(temp0);

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkStreamTracer_GetInitialIntegrationStep_124(JNIEnv* env, jobject obj)
{
  double   temp20;

  vtkStreamTracer* op = static_cast<vtkStreamTracer*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetInitialIntegrationStep();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkStreamTracer_SetMinimumIntegrationStep_125(JNIEnv* env, jobject obj,jdouble id0)
{
  double   temp0;
  temp0 = id0;

  vtkStreamTracer* op = static_cast<vtkStreamTracer*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetMinimumIntegrationStep(temp0);

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkStreamTracer_GetMinimumIntegrationStep_126(JNIEnv* env, jobject obj)
{
  double   temp20;

  vtkStreamTracer* op = static_cast<vtkStreamTracer*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetMinimumIntegrationStep();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkStreamTracer_SetMaximumIntegrationStep_127(JNIEnv* env, jobject obj,jdouble id0)
{
  double   temp0;
  temp0 = id0;

  vtkStreamTracer* op = static_cast<vtkStreamTracer*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetMaximumIntegrationStep(temp0);

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkStreamTracer_GetMaximumIntegrationStep_128(JNIEnv* env, jobject obj)
{
  double   temp20;

  vtkStreamTracer* op = static_cast<vtkStreamTracer*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetMaximumIntegrationStep();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkStreamTracer_SetMaximumError_129(JNIEnv* env, jobject obj,jdouble id0)
{
  double   temp0;
  temp0 = id0;

  vtkStreamTracer* op = static_cast<vtkStreamTracer*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetMaximumError(temp0);

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkStreamTracer_GetMaximumError_130(JNIEnv* env, jobject obj)
{
  double   temp20;

  vtkStreamTracer* op = static_cast<vtkStreamTracer*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetMaximumError();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkStreamTracer_SetMaximumNumberOfSteps_131(JNIEnv* env, jobject obj,jlong id0)
{
  long long   temp0;
  temp0 = id0;

  vtkStreamTracer* op = static_cast<vtkStreamTracer*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetMaximumNumberOfSteps(temp0);

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkStreamTracer_GetMaximumNumberOfSteps_132(JNIEnv* env, jobject obj)
{
  long long   temp20;

  vtkStreamTracer* op = static_cast<vtkStreamTracer*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetMaximumNumberOfSteps();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkStreamTracer_SetTerminalSpeed_133(JNIEnv* env, jobject obj,jdouble id0)
{
  double   temp0;
  temp0 = id0;

  vtkStreamTracer* op = static_cast<vtkStreamTracer*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetTerminalSpeed(temp0);

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkStreamTracer_GetTerminalSpeed_134(JNIEnv* env, jobject obj)
{
  double   temp20;

  vtkStreamTracer* op = static_cast<vtkStreamTracer*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetTerminalSpeed();
  return temp20;

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkStreamTracer_GetSurfaceStreamlines_135(JNIEnv* env, jobject obj)
{
  bool   temp20;

  vtkStreamTracer* op = static_cast<vtkStreamTracer*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetSurfaceStreamlines();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkStreamTracer_SetSurfaceStreamlines_136(JNIEnv* env, jobject obj,jboolean id0)
{
  bool   temp0;
  temp0 = (id0 != 0) ? true : false;

  vtkStreamTracer* op = static_cast<vtkStreamTracer*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetSurfaceStreamlines(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkStreamTracer_SurfaceStreamlinesOn_137(JNIEnv* env, jobject obj)
{

  vtkStreamTracer* op = static_cast<vtkStreamTracer*>(vtkJavaGetPointerFromObject(env, obj));
  op->SurfaceStreamlinesOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkStreamTracer_SurfaceStreamlinesOff_138(JNIEnv* env, jobject obj)
{

  vtkStreamTracer* op = static_cast<vtkStreamTracer*>(vtkJavaGetPointerFromObject(env, obj));
  op->SurfaceStreamlinesOff();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkStreamTracer_SetIntegrationDirection_139(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkStreamTracer* op = static_cast<vtkStreamTracer*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetIntegrationDirection(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkStreamTracer_GetIntegrationDirectionMinValue_140(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkStreamTracer* op = static_cast<vtkStreamTracer*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetIntegrationDirectionMinValue();
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkStreamTracer_GetIntegrationDirectionMaxValue_141(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkStreamTracer* op = static_cast<vtkStreamTracer*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetIntegrationDirectionMaxValue();
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkStreamTracer_GetIntegrationDirection_142(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkStreamTracer* op = static_cast<vtkStreamTracer*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetIntegrationDirection();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkStreamTracer_SetIntegrationDirectionToForward_143(JNIEnv* env, jobject obj)
{

  vtkStreamTracer* op = static_cast<vtkStreamTracer*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetIntegrationDirectionToForward();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkStreamTracer_SetIntegrationDirectionToBackward_144(JNIEnv* env, jobject obj)
{

  vtkStreamTracer* op = static_cast<vtkStreamTracer*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetIntegrationDirectionToBackward();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkStreamTracer_SetIntegrationDirectionToBoth_145(JNIEnv* env, jobject obj)
{

  vtkStreamTracer* op = static_cast<vtkStreamTracer*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetIntegrationDirectionToBoth();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkStreamTracer_SetComputeVorticity_146(JNIEnv* env, jobject obj,jboolean id0)
{
  bool   temp0;
  temp0 = (id0 != 0) ? true : false;

  vtkStreamTracer* op = static_cast<vtkStreamTracer*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetComputeVorticity(temp0);

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkStreamTracer_GetComputeVorticity_147(JNIEnv* env, jobject obj)
{
  bool   temp20;

  vtkStreamTracer* op = static_cast<vtkStreamTracer*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetComputeVorticity();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkStreamTracer_SetRotationScale_148(JNIEnv* env, jobject obj,jdouble id0)
{
  double   temp0;
  temp0 = id0;

  vtkStreamTracer* op = static_cast<vtkStreamTracer*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetRotationScale(temp0);

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkStreamTracer_GetRotationScale_149(JNIEnv* env, jobject obj)
{
  double   temp20;

  vtkStreamTracer* op = static_cast<vtkStreamTracer*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetRotationScale();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkStreamTracer_SetInterpolatorPrototype_150(JNIEnv* env, jobject obj,jobject id0)
{
  vtkAbstractInterpolatedVelocityField * temp0;
  temp0 = static_cast<vtkAbstractInterpolatedVelocityField*>(vtkJavaGetPointerFromObject(env, id0));

  vtkStreamTracer* op = static_cast<vtkStreamTracer*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetInterpolatorPrototype(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkStreamTracer_SetInterpolatorType_151(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkStreamTracer* op = static_cast<vtkStreamTracer*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetInterpolatorType(temp0);

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkStreamTracer_GetForceSerialExecution_152(JNIEnv* env, jobject obj)
{
  bool   temp20;

  vtkStreamTracer* op = static_cast<vtkStreamTracer*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetForceSerialExecution();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkStreamTracer_SetForceSerialExecution_153(JNIEnv* env, jobject obj,jboolean id0)
{
  bool   temp0;
  temp0 = (id0 != 0) ? true : false;

  vtkStreamTracer* op = static_cast<vtkStreamTracer*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetForceSerialExecution(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkStreamTracer_ForceSerialExecutionOn_154(JNIEnv* env, jobject obj)
{

  vtkStreamTracer* op = static_cast<vtkStreamTracer*>(vtkJavaGetPointerFromObject(env, obj));
  op->ForceSerialExecutionOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkStreamTracer_ForceSerialExecutionOff_155(JNIEnv* env, jobject obj)
{

  vtkStreamTracer* op = static_cast<vtkStreamTracer*>(vtkJavaGetPointerFromObject(env, obj));
  op->ForceSerialExecutionOff();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkStreamTracer_CalculateVorticity_156(JNIEnv* env, jobject obj,jobject id0,jdoubleArray id1,jobject id2,jdoubleArray id3)
{
  vtkGenericCell * temp0;
  double temp1[3];
  vtkDoubleArray * temp2;
  double temp3[3];
  temp0 = static_cast<vtkGenericCell*>(vtkJavaGetPointerFromObject(env, id0));
  env->GetDoubleArrayRegion(id1, 0, 3, &temp1[0]);
  temp2 = static_cast<vtkDoubleArray*>(vtkJavaGetPointerFromObject(env, id2));
  env->GetDoubleArrayRegion(id3, 0, 3, &temp3[0]);

  vtkStreamTracer* op = static_cast<vtkStreamTracer*>(vtkJavaGetPointerFromObject(env, obj));
  op->CalculateVorticity(temp0,temp1,temp2,temp3);
  env->SetDoubleArrayRegion(id1, 0, 3, &temp1[0]);
  env->SetDoubleArrayRegion(id3, 0, 3, &temp3[0]);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkStreamTracer_SetUseLocalSeedSource_157(JNIEnv* env, jobject obj,jboolean id0)
{
  bool   temp0;
  temp0 = (id0 != 0) ? true : false;

  vtkStreamTracer* op = static_cast<vtkStreamTracer*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetUseLocalSeedSource(temp0);

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkStreamTracer_GetUseLocalSeedSource_158(JNIEnv* env, jobject obj)
{
  bool   temp20;

  vtkStreamTracer* op = static_cast<vtkStreamTracer*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetUseLocalSeedSource();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkStreamTracer_UseLocalSeedSourceOn_159(JNIEnv* env, jobject obj)
{

  vtkStreamTracer* op = static_cast<vtkStreamTracer*>(vtkJavaGetPointerFromObject(env, obj));
  op->UseLocalSeedSourceOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkStreamTracer_UseLocalSeedSourceOff_160(JNIEnv* env, jobject obj)
{

  vtkStreamTracer* op = static_cast<vtkStreamTracer*>(vtkJavaGetPointerFromObject(env, obj));
  op->UseLocalSeedSourceOff();

}

extern "C" JNIEXPORT jlong JNICALL Java_vtk_vtkStreamTracer_VTKInit(JNIEnv*, jobject)
{
  return reinterpret_cast<jlong>(vtkStreamTracer::New());
}
