// java wrapper for vtkBufferedArchiver object
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkABI.h"
#include "vtkSystemIncludes.h"
#include "vtkBufferedArchiver.h"
#include "vtkJavaUtil.h"

#include "vtkStdString.h"

#include <sstream>
extern "C" JNIEXPORT void* vtkArchiver_Typecast(void* op,char* dType);

extern "C" JNIEXPORT void* vtkBufferedArchiver_Typecast(void* me,char* dType)
{
  void* res;
  if (!strcmp("vtkBufferedArchiver",dType)) { return me; }
  if ((res= vtkArchiver_Typecast(me,dType)) != nullptr) { return res; }
  return nullptr;
}


extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkBufferedArchiver_IsTypeOf_10(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkBufferedArchiver* op = static_cast<vtkBufferedArchiver*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsTypeOf(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkBufferedArchiver_IsA_11(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkBufferedArchiver* op = static_cast<vtkBufferedArchiver*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsA(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkBufferedArchiver_GetNumberOfGenerationsFromBaseType_12(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkBufferedArchiver* op = static_cast<vtkBufferedArchiver*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBaseType(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkBufferedArchiver_GetNumberOfGenerationsFromBase_13(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkBufferedArchiver* op = static_cast<vtkBufferedArchiver*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBase(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkBufferedArchiver_OpenArchive_14(JNIEnv* env, jobject obj)
{

  vtkBufferedArchiver* op = static_cast<vtkBufferedArchiver*>(vtkJavaGetPointerFromObject(env, obj));
  op->OpenArchive();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkBufferedArchiver_CloseArchive_15(JNIEnv* env, jobject obj)
{

  vtkBufferedArchiver* op = static_cast<vtkBufferedArchiver*>(vtkJavaGetPointerFromObject(env, obj));
  op->CloseArchive();

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkBufferedArchiver_Contains_16(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  std::string temp0;
  bool   temp20;
  temp0 = vtkJavaUTF8ToString(env, id0, len0);

  vtkBufferedArchiver* op = static_cast<vtkBufferedArchiver*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->Contains(temp0);
  return temp20;

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkBufferedArchiver_GetBuffer_17(JNIEnv* env, jobject obj)
{
  const char * temp20;

  vtkBufferedArchiver* op = static_cast<vtkBufferedArchiver*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetBuffer();
  return (temp20 == nullptr) ? env->NewByteArray(0) : vtkJavaCharsToUTF8(env, temp20, strlen(temp20));

}

extern "C" JNIEXPORT jlong JNICALL Java_vtk_vtkBufferedArchiver_VTKInit(JNIEnv*, jobject)
{
  return reinterpret_cast<jlong>(vtkBufferedArchiver::New());
}
