// python wrapper for vtkBoostBreadthFirstSearch
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkPythonArgs.h"
#include "vtkPythonOverload.h"
#include <cstddef>
#include <sstream>
#include "vtkVariant.h"
#include "vtkIndent.h"
#include "vtkStdString.h"
#include "vtkBoostBreadthFirstSearch.h"

#if defined(PYTHON_PACKAGE)
#define PYTHON_PACKAGE_SCOPE PYTHON_PACKAGE "."
#else
#define PYTHON_PACKAGE_SCOPE
#endif

extern "C" { VTK_ABI_HIDDEN void PyVTKAddFile_vtkBoostBreadthFirstSearch(PyObject *dict); }
extern "C" { VTK_ABI_HIDDEN PyObject *PyvtkBoostBreadthFirstSearch_ClassNew(); }


static PyObject *
PyvtkBoostBreadthFirstSearch_IsTypeOf(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "IsTypeOf");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = vtkBoostBreadthFirstSearch::IsTypeOf(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkBoostBreadthFirstSearch_IsA(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "IsA");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkBoostBreadthFirstSearch *op = static_cast<vtkBoostBreadthFirstSearch *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = (ap.IsBound() ?
      op->IsA(temp0) :
      op->vtkBoostBreadthFirstSearch::IsA(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkBoostBreadthFirstSearch_SafeDownCast(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "SafeDownCast");

  vtkObjectBase *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkObjectBase"))
  {
    vtkBoostBreadthFirstSearch *tempr = vtkBoostBreadthFirstSearch::SafeDownCast(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkBoostBreadthFirstSearch_NewInstance(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "NewInstance");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkBoostBreadthFirstSearch *op = static_cast<vtkBoostBreadthFirstSearch *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    vtkBoostBreadthFirstSearch *tempr = (ap.IsBound() ?
      op->NewInstance() :
      op->vtkBoostBreadthFirstSearch::NewInstance());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
      if (result && PyVTKObject_Check(result))
      {
        PyVTKObject_GetObject(result)->UnRegister(nullptr);
        PyVTKObject_SetFlag(result, VTK_PYTHON_IGNORE_UNREGISTER, 1);
      }
    }
    else if (tempr != nullptr)
    {
      ap.DeleteVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkBoostBreadthFirstSearch_GetNumberOfGenerationsFromBaseType(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "GetNumberOfGenerationsFromBaseType");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = vtkBoostBreadthFirstSearch::GetNumberOfGenerationsFromBaseType(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkBoostBreadthFirstSearch_GetNumberOfGenerationsFromBase(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetNumberOfGenerationsFromBase");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkBoostBreadthFirstSearch *op = static_cast<vtkBoostBreadthFirstSearch *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = (ap.IsBound() ?
      op->GetNumberOfGenerationsFromBase(temp0) :
      op->vtkBoostBreadthFirstSearch::GetNumberOfGenerationsFromBase(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkBoostBreadthFirstSearch_SetOriginSelection(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetOriginSelection");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkBoostBreadthFirstSearch *op = static_cast<vtkBoostBreadthFirstSearch *>(vp);

  vtkSelection *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkSelection"))
  {
    if (ap.IsBound())
    {
      op->SetOriginSelection(temp0);
    }
    else
    {
      op->vtkBoostBreadthFirstSearch::SetOriginSelection(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkBoostBreadthFirstSearch_SetOriginSelectionConnection(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetOriginSelectionConnection");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkBoostBreadthFirstSearch *op = static_cast<vtkBoostBreadthFirstSearch *>(vp);

  vtkAlgorithmOutput *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkAlgorithmOutput"))
  {
    if (ap.IsBound())
    {
      op->SetOriginSelectionConnection(temp0);
    }
    else
    {
      op->vtkBoostBreadthFirstSearch::SetOriginSelectionConnection(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkBoostBreadthFirstSearch_SetOriginVertex_s1(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetOriginVertex");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkBoostBreadthFirstSearch *op = static_cast<vtkBoostBreadthFirstSearch *>(vp);

  long long temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetOriginVertex(temp0);
    }
    else
    {
      op->vtkBoostBreadthFirstSearch::SetOriginVertex(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}

static PyObject *
PyvtkBoostBreadthFirstSearch_SetOriginVertex_s2(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetOriginVertex");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkBoostBreadthFirstSearch *op = static_cast<vtkBoostBreadthFirstSearch *>(vp);

  vtkStdString temp0;
  vtkVariant *temp1 = nullptr;
  PyObject *pobj1 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(2) &&
      ap.GetValue(temp0) &&
      ap.GetSpecialObject(temp1, pobj1, "vtkVariant"))
  {
    if (ap.IsBound())
    {
      op->SetOriginVertex(temp0, *temp1);
    }
    else
    {
      op->vtkBoostBreadthFirstSearch::SetOriginVertex(temp0, *temp1);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  Py_XDECREF(pobj1);

  return result;
}

static PyObject *
PyvtkBoostBreadthFirstSearch_SetOriginVertex(PyObject *self, PyObject *args)
{
  int nargs = vtkPythonArgs::GetArgCount(self, args);

  switch(nargs)
  {
    case 1:
      return PyvtkBoostBreadthFirstSearch_SetOriginVertex_s1(self, args);
    case 2:
      return PyvtkBoostBreadthFirstSearch_SetOriginVertex_s2(self, args);
  }

  vtkPythonArgs::ArgCountError(nargs, "SetOriginVertex");
  return nullptr;
}


static PyObject *
PyvtkBoostBreadthFirstSearch_SetOriginVertexString(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetOriginVertexString");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkBoostBreadthFirstSearch *op = static_cast<vtkBoostBreadthFirstSearch *>(vp);

  size_t size0 = ap.GetStringSize(0);
  vtkPythonArgs::Array<char> store0(2*size0 + 1);
  char *temp0 = store0.Data();
  char *save0 = temp0 + size0 + 1;
  size_t size1 = ap.GetStringSize(1);
  vtkPythonArgs::Array<char> store1(2*size1 + 1);
  char *temp1 = store1.Data();
  char *save1 = temp1 + size1 + 1;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(2) &&
      ap.GetArray(temp0, size0) &&
      ap.GetArray(temp1, size1))
  {
    vtkPythonArgs::Save(temp0, save0, size0);
    vtkPythonArgs::Save(temp1, save1, size1);

    if (ap.IsBound())
    {
      op->SetOriginVertexString(temp0, temp1);
    }
    else
    {
      op->vtkBoostBreadthFirstSearch::SetOriginVertexString(temp0, temp1);
    }

    if (vtkPythonArgs::HasChanged(temp0, save0, size0) &&
        !ap.ErrorOccurred())
    {
      ap.SetArray(0, temp0, size0);
    }

    if (vtkPythonArgs::HasChanged(temp1, save1, size1) &&
        !ap.ErrorOccurred())
    {
      ap.SetArray(1, temp1, size1);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkBoostBreadthFirstSearch_SetOutputArrayName(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetOutputArrayName");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkBoostBreadthFirstSearch *op = static_cast<vtkBoostBreadthFirstSearch *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetOutputArrayName(temp0);
    }
    else
    {
      op->vtkBoostBreadthFirstSearch::SetOutputArrayName(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkBoostBreadthFirstSearch_SetOriginFromSelection(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetOriginFromSelection");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkBoostBreadthFirstSearch *op = static_cast<vtkBoostBreadthFirstSearch *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetOriginFromSelection(temp0);
    }
    else
    {
      op->vtkBoostBreadthFirstSearch::SetOriginFromSelection(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkBoostBreadthFirstSearch_GetOriginFromSelection(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetOriginFromSelection");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkBoostBreadthFirstSearch *op = static_cast<vtkBoostBreadthFirstSearch *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = (ap.IsBound() ?
      op->GetOriginFromSelection() :
      op->vtkBoostBreadthFirstSearch::GetOriginFromSelection());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkBoostBreadthFirstSearch_OriginFromSelectionOn(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "OriginFromSelectionOn");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkBoostBreadthFirstSearch *op = static_cast<vtkBoostBreadthFirstSearch *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->OriginFromSelectionOn();
    }
    else
    {
      op->vtkBoostBreadthFirstSearch::OriginFromSelectionOn();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkBoostBreadthFirstSearch_OriginFromSelectionOff(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "OriginFromSelectionOff");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkBoostBreadthFirstSearch *op = static_cast<vtkBoostBreadthFirstSearch *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->OriginFromSelectionOff();
    }
    else
    {
      op->vtkBoostBreadthFirstSearch::OriginFromSelectionOff();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkBoostBreadthFirstSearch_GetOutputSelection(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetOutputSelection");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkBoostBreadthFirstSearch *op = static_cast<vtkBoostBreadthFirstSearch *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = (ap.IsBound() ?
      op->GetOutputSelection() :
      op->vtkBoostBreadthFirstSearch::GetOutputSelection());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkBoostBreadthFirstSearch_SetOutputSelection(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetOutputSelection");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkBoostBreadthFirstSearch *op = static_cast<vtkBoostBreadthFirstSearch *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetOutputSelection(temp0);
    }
    else
    {
      op->vtkBoostBreadthFirstSearch::SetOutputSelection(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkBoostBreadthFirstSearch_OutputSelectionOn(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "OutputSelectionOn");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkBoostBreadthFirstSearch *op = static_cast<vtkBoostBreadthFirstSearch *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->OutputSelectionOn();
    }
    else
    {
      op->vtkBoostBreadthFirstSearch::OutputSelectionOn();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkBoostBreadthFirstSearch_OutputSelectionOff(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "OutputSelectionOff");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkBoostBreadthFirstSearch *op = static_cast<vtkBoostBreadthFirstSearch *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->OutputSelectionOff();
    }
    else
    {
      op->vtkBoostBreadthFirstSearch::OutputSelectionOff();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkBoostBreadthFirstSearch_SetOutputSelectionType(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetOutputSelectionType");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkBoostBreadthFirstSearch *op = static_cast<vtkBoostBreadthFirstSearch *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetOutputSelectionType(temp0);
    }
    else
    {
      op->vtkBoostBreadthFirstSearch::SetOutputSelectionType(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}

static PyMethodDef PyvtkBoostBreadthFirstSearch_Methods[] = {
  {"IsTypeOf", PyvtkBoostBreadthFirstSearch_IsTypeOf, METH_VARARGS,
   "IsTypeOf(type:str) -> int\nC++: static vtkTypeBool IsTypeOf(const char *type)\n\nReturn 1 if this class type is the same type of (or a subclass\nof) the named class. Returns 0 otherwise. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"IsA", PyvtkBoostBreadthFirstSearch_IsA, METH_VARARGS,
   "IsA(self, type:str) -> int\nC++: vtkTypeBool IsA(const char *type) override;\n\nReturn 1 if this class is the same type of (or a subclass of) the\nnamed class. Returns 0 otherwise. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"SafeDownCast", PyvtkBoostBreadthFirstSearch_SafeDownCast, METH_VARARGS,
   "SafeDownCast(o:vtkObjectBase) -> vtkBoostBreadthFirstSearch\nC++: static vtkBoostBreadthFirstSearch *SafeDownCast(\n    vtkObjectBase *o)\n\n"},
  {"NewInstance", PyvtkBoostBreadthFirstSearch_NewInstance, METH_VARARGS,
   "NewInstance(self) -> vtkBoostBreadthFirstSearch\nC++: vtkBoostBreadthFirstSearch *NewInstance()\n\n"},
  {"GetNumberOfGenerationsFromBaseType", PyvtkBoostBreadthFirstSearch_GetNumberOfGenerationsFromBaseType, METH_VARARGS,
   "GetNumberOfGenerationsFromBaseType(type:str) -> int\nC++: static vtkIdType GetNumberOfGenerationsFromBaseType(\n    const char *type)\n\nGiven a the name of a base class of this class type, return the\ndistance of inheritance between this class type and the named\nclass (how many generations of inheritance are there between this\nclass and the named class). If the named class is not in this\nclass's inheritance tree, return a negative value. Valid\nresponses will always be nonnegative. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"GetNumberOfGenerationsFromBase", PyvtkBoostBreadthFirstSearch_GetNumberOfGenerationsFromBase, METH_VARARGS,
   "GetNumberOfGenerationsFromBase(self, type:str) -> int\nC++: vtkIdType GetNumberOfGenerationsFromBase(const char *type)\n    override;\n\nGiven the name of a base class of this class type, return the\ndistance of inheritance between this class type and the named\nclass (how many generations of inheritance are there between this\nclass and the named class). If the named class is not in this\nclass's inheritance tree, return a negative value. Valid\nresponses will always be nonnegative. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"SetOriginSelection", PyvtkBoostBreadthFirstSearch_SetOriginSelection, METH_VARARGS,
   "SetOriginSelection(self, s:vtkSelection) -> None\nC++: void SetOriginSelection(vtkSelection *s)\n\nConvenience methods for setting the origin selection input.\n"},
  {"SetOriginSelectionConnection", PyvtkBoostBreadthFirstSearch_SetOriginSelectionConnection, METH_VARARGS,
   "SetOriginSelectionConnection(self, algOutput:vtkAlgorithmOutput)\n    -> None\nC++: void SetOriginSelectionConnection(\n    vtkAlgorithmOutput *algOutput)\n\n"},
  {"SetOriginVertex", PyvtkBoostBreadthFirstSearch_SetOriginVertex, METH_VARARGS,
   "SetOriginVertex(self, index:int) -> None\nC++: void SetOriginVertex(vtkIdType index)\nSetOriginVertex(self, arrayName:str, value:vtkVariant) -> None\nC++: void SetOriginVertex(vtkStdString arrayName,\n    vtkVariant value)\n\nSet the index (into the vertex array) of the breadth first search\n'origin' vertex.\n"},
  {"SetOriginVertexString", PyvtkBoostBreadthFirstSearch_SetOriginVertexString, METH_VARARGS,
   "SetOriginVertexString(self, arrayName:str, value:str) -> None\nC++: void SetOriginVertexString(char *arrayName, char *value)\n\nConvenience method for setting the origin vertex given an array\nname and string value. This method is primarily for the benefit\nof the VTK Parallel client/server layer, callers should prefer to\nuse SetOriginVertex() whenever possible.\n"},
  {"SetOutputArrayName", PyvtkBoostBreadthFirstSearch_SetOutputArrayName, METH_VARARGS,
   "SetOutputArrayName(self, _arg:str) -> None\nC++: virtual void SetOutputArrayName(const char *_arg)\n\nSet the output array name. If no output array name is set then\nthe name 'BFS' is used.\n"},
  {"SetOriginFromSelection", PyvtkBoostBreadthFirstSearch_SetOriginFromSelection, METH_VARARGS,
   "SetOriginFromSelection(self, _arg:bool) -> None\nC++: virtual void SetOriginFromSelection(bool _arg)\n\nUse the vtkSelection from input port 1 as the origin vertex. The\nselection should be a IDS selection with field type POINTS. The\nfirst ID in the selection will be used for the origin vertex.\nDefault is off (origin is specified by SetOriginVertex(...)).\n"},
  {"GetOriginFromSelection", PyvtkBoostBreadthFirstSearch_GetOriginFromSelection, METH_VARARGS,
   "GetOriginFromSelection(self) -> bool\nC++: virtual bool GetOriginFromSelection()\n\n"},
  {"OriginFromSelectionOn", PyvtkBoostBreadthFirstSearch_OriginFromSelectionOn, METH_VARARGS,
   "OriginFromSelectionOn(self) -> None\nC++: virtual void OriginFromSelectionOn()\n\n"},
  {"OriginFromSelectionOff", PyvtkBoostBreadthFirstSearch_OriginFromSelectionOff, METH_VARARGS,
   "OriginFromSelectionOff(self) -> None\nC++: virtual void OriginFromSelectionOff()\n\n"},
  {"GetOutputSelection", PyvtkBoostBreadthFirstSearch_GetOutputSelection, METH_VARARGS,
   "GetOutputSelection(self) -> bool\nC++: virtual bool GetOutputSelection()\n\nCreate an output selection containing the ID of a vertex based on\nthe output selection type. The default is to use the the maximum\ndistance from the starting vertex.  Defaults to off.\n"},
  {"SetOutputSelection", PyvtkBoostBreadthFirstSearch_SetOutputSelection, METH_VARARGS,
   "SetOutputSelection(self, _arg:bool) -> None\nC++: virtual void SetOutputSelection(bool _arg)\n\n"},
  {"OutputSelectionOn", PyvtkBoostBreadthFirstSearch_OutputSelectionOn, METH_VARARGS,
   "OutputSelectionOn(self) -> None\nC++: virtual void OutputSelectionOn()\n\n"},
  {"OutputSelectionOff", PyvtkBoostBreadthFirstSearch_OutputSelectionOff, METH_VARARGS,
   "OutputSelectionOff(self) -> None\nC++: virtual void OutputSelectionOff()\n\n"},
  {"SetOutputSelectionType", PyvtkBoostBreadthFirstSearch_SetOutputSelectionType, METH_VARARGS,
   "SetOutputSelectionType(self, _arg:str) -> None\nC++: virtual void SetOutputSelectionType(const char *_arg)\n\nSet the output selection type. The default is to use the the\nmaximum distance from the starting vertex \"MAX_DIST_FROM_ROOT\".\nBut you can also specify other things like \"ROOT\",\"2D_MAX\", etc\n"},
  {nullptr, nullptr, 0, nullptr}
};

#if PY_VERSION_HEX >= 0x03070000
#define pystr(x) x
#else
#define pystr(x) const_cast<char*>(x)
#endif
static PyGetSetDef PyvtkBoostBreadthFirstSearch_GetSets[] = {
  PyVTKObject_GetSet[0],
  PyVTKObject_GetSet[1],
  {
    /*name=*/pystr("origin_selection"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkBoostBreadthFirstSearch_SetOriginSelection(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkBoostBreadthFirstSearch_SetOriginSelection(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetOriginSelection\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("origin_selection_connection"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkBoostBreadthFirstSearch_SetOriginSelectionConnection(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkBoostBreadthFirstSearch_SetOriginSelectionConnection(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetOriginSelectionConnection\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("origin_vertex"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkBoostBreadthFirstSearch_SetOriginVertex(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkBoostBreadthFirstSearch_SetOriginVertex(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetOriginVertex\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("output_array_name"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkBoostBreadthFirstSearch_SetOutputArrayName(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkBoostBreadthFirstSearch_SetOutputArrayName(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetOutputArrayName\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("origin_from_selection"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkBoostBreadthFirstSearch_GetOriginFromSelection(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkBoostBreadthFirstSearch_SetOriginFromSelection(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkBoostBreadthFirstSearch_SetOriginFromSelection(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetOriginFromSelection/SetOriginFromSelection\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("output_selection"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkBoostBreadthFirstSearch_GetOutputSelection(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkBoostBreadthFirstSearch_SetOutputSelection(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkBoostBreadthFirstSearch_SetOutputSelection(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetOutputSelection/SetOutputSelection\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("output_selection_type"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkBoostBreadthFirstSearch_SetOutputSelectionType(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkBoostBreadthFirstSearch_SetOutputSelectionType(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetOutputSelectionType\n"),
    /*closure=*/nullptr,
  },
  { nullptr, nullptr, nullptr, nullptr, nullptr }
};
static const char *PyvtkBoostBreadthFirstSearch_Doc =
  "vtkBoostBreadthFirstSearch - Boost breadth_first_search on a vtkGraph\n\n"
  "Superclass: vtkGraphAlgorithm\n\n"
  "This vtk class uses the Boost breadth_first_search generic algorithm\n"
  "to perform a breadth first search from a given a 'source' vertex on\n"
  "the input graph (a vtkGraph).\n\n"
  "@sa\n"
  "vtkGraph vtkBoostGraphAdapter\n\n";

#ifdef VTK_PYTHON_NEEDS_DEPRECATION_WARNING_SUPPRESSION
#pragma GCC diagnostic ignored "-Wdeprecated-declarations"
#endif

static PyTypeObject PyvtkBoostBreadthFirstSearch_Type = {
  PyVarObject_HEAD_INIT(&PyType_Type, 0)
  PYTHON_PACKAGE_SCOPE "vtkInfovisBoostGraphAlgorithms.vtkBoostBreadthFirstSearch", // tp_name
  sizeof(PyVTKObject), // tp_basicsize
  0, // tp_itemsize
  PyVTKObject_Delete, // tp_dealloc
#if PY_VERSION_HEX >= 0x03080000
  0, // tp_vectorcall_offset
#else
  nullptr, // tp_print
#endif
  nullptr, // tp_getattr
  nullptr, // tp_setattr
  nullptr, // tp_compare
  PyVTKObject_Repr, // tp_repr
  nullptr, // tp_as_number
  nullptr, // tp_as_sequence
  nullptr, // tp_as_mapping
  nullptr, // tp_hash
  nullptr, // tp_call
  PyVTKObject_String, // tp_str
  PyObject_GenericGetAttr, // tp_getattro
  PyObject_GenericSetAttr, // tp_setattro
  &PyVTKObject_AsBuffer, // tp_as_buffer
  Py_TPFLAGS_DEFAULT|Py_TPFLAGS_HAVE_GC|Py_TPFLAGS_BASETYPE, // tp_flags
  PyvtkBoostBreadthFirstSearch_Doc, // tp_doc
  PyVTKObject_Traverse, // tp_traverse
  nullptr, // tp_clear
  nullptr, // tp_richcompare
  offsetof(PyVTKObject, vtk_weakreflist), // tp_weaklistoffset
  nullptr, // tp_iter
  nullptr, // tp_iternext
  nullptr, // tp_methods
  nullptr, // tp_members
  PyVTKObject_GetSet, // tp_getset
  nullptr, // tp_base
  nullptr, // tp_dict
  nullptr, // tp_descr_get
  nullptr, // tp_descr_set
  offsetof(PyVTKObject, vtk_dict), // tp_dictoffset
  PyVTKObject_Init, // tp_init
  nullptr, // tp_alloc
  PyVTKObject_New, // tp_new
  PyObject_GC_Del, // tp_free
  nullptr, // tp_is_gc
  nullptr, // tp_bases
  nullptr, // tp_mro
  nullptr, // tp_cache
  nullptr, // tp_subclasses
  nullptr, // tp_weaklist
  VTK_WRAP_PYTHON_SUPPRESS_UNINITIALIZED
};

static vtkObjectBase *PyvtkBoostBreadthFirstSearch_StaticNew()
{
  return vtkBoostBreadthFirstSearch::New();
}

PyObject *PyvtkBoostBreadthFirstSearch_ClassNew()
{
  PyTypeObject *pytype = PyVTKClass_Add(
    &PyvtkBoostBreadthFirstSearch_Type, PyvtkBoostBreadthFirstSearch_Methods,
    "vtkBoostBreadthFirstSearch",
 &PyvtkBoostBreadthFirstSearch_StaticNew);

  if ((PyType_GetFlags(pytype) & Py_TPFLAGS_READY) != 0)
  {
    return (PyObject *)pytype;
  }

  pytype->tp_base = vtkPythonUtil::FindBaseTypeObject("vtkGraphAlgorithm");

  PyVTKClass_AddCombinedGetSetDefinitions(pytype, PyvtkBoostBreadthFirstSearch_GetSets);
  PyType_Ready(pytype);
  return (PyObject *)pytype;
}

void PyVTKAddFile_vtkBoostBreadthFirstSearch(
  PyObject *dict)
{
  PyObject *o;
  o = PyvtkBoostBreadthFirstSearch_ClassNew();

  if (o && PyDict_SetItemString(dict, "vtkBoostBreadthFirstSearch", o) != 0)
  {
    Py_DECREF(o);
  }

}

