/* FocusPicker.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from FocusPicker.vala, do not modify */

/* The focuspoint picker*/
/* The API is a bit strange as it's based on https://github.com/jonom/jquery-focuspoint#1-calculate-your-images-focus-point*/
/* In summary, they are coordinates, where (1,1) is the top-right corner of the image*/
/* and (-1,-1) is the bottom-left one*/
/* This widget is responsible not only for picking the position on top of the image,*/
/* but also converting the position between the API coordinates and the width-height GTK ones*/

#include <gtk/gtk.h>
#include <glib-object.h>
#include <glib.h>
#include <float.h>
#include <math.h>
#include <gdk/gdk.h>
#include <graphene-gobject.h>
#include <stdlib.h>
#include <string.h>
#include <glib/gi18n-lib.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define TUBA_WIDGETS_TYPE_FOCUS_PICKER (tuba_widgets_focus_picker_get_type ())
#define TUBA_WIDGETS_FOCUS_PICKER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TUBA_WIDGETS_TYPE_FOCUS_PICKER, TubaWidgetsFocusPicker))
#define TUBA_WIDGETS_FOCUS_PICKER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TUBA_WIDGETS_TYPE_FOCUS_PICKER, TubaWidgetsFocusPickerClass))
#define TUBA_WIDGETS_IS_FOCUS_PICKER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TUBA_WIDGETS_TYPE_FOCUS_PICKER))
#define TUBA_WIDGETS_IS_FOCUS_PICKER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TUBA_WIDGETS_TYPE_FOCUS_PICKER))
#define TUBA_WIDGETS_FOCUS_PICKER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TUBA_WIDGETS_TYPE_FOCUS_PICKER, TubaWidgetsFocusPickerClass))

typedef struct _TubaWidgetsFocusPicker TubaWidgetsFocusPicker;
typedef struct _TubaWidgetsFocusPickerClass TubaWidgetsFocusPickerClass;
typedef struct _TubaWidgetsFocusPickerPrivate TubaWidgetsFocusPickerPrivate;
enum  {
	TUBA_WIDGETS_FOCUS_PICKER_0_PROPERTY,
	TUBA_WIDGETS_FOCUS_PICKER_POS_X_PROPERTY,
	TUBA_WIDGETS_FOCUS_PICKER_POS_Y_PROPERTY,
	TUBA_WIDGETS_FOCUS_PICKER_NUM_PROPERTIES
};
static GParamSpec* tuba_widgets_focus_picker_properties[TUBA_WIDGETS_FOCUS_PICKER_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

struct _TubaWidgetsFocusPicker {
	GtkWidget parent_instance;
	TubaWidgetsFocusPickerPrivate * priv;
};

struct _TubaWidgetsFocusPickerClass {
	GtkWidgetClass parent_class;
};

struct _TubaWidgetsFocusPickerPrivate {
	GtkPicture* pic;
	GtkFixed* fixed;
	GtkImage* picker;
	GtkAspectFrame* frame;
	GtkOverlay* overlay;
	gdouble _pos_x;
	gdouble _pos_y;
	gdouble picker_width_half;
	gdouble picker_height_half;
	gboolean dragging;
};

static gint TubaWidgetsFocusPicker_private_offset;
static gpointer tuba_widgets_focus_picker_parent_class = NULL;

VALA_EXTERN GType tuba_widgets_focus_picker_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (TubaWidgetsFocusPicker, g_object_unref)
static void tuba_widgets_focus_picker_on_fixed_click (TubaWidgetsFocusPicker* self,
                                               gint n_press,
                                               gdouble x,
                                               gdouble y);
static void tuba_widgets_focus_picker_on_motion_real (TubaWidgetsFocusPicker* self,
                                               gdouble x,
                                               gdouble y);
static void tuba_widgets_focus_picker_on_pointer_click (TubaWidgetsFocusPicker* self);
static void tuba_widgets_focus_picker_on_pointer_click_release (TubaWidgetsFocusPicker* self);
static void tuba_widgets_focus_picker_on_motion (TubaWidgetsFocusPicker* self,
                                          gdouble x,
                                          gdouble y);
VALA_EXTERN void tuba_widgets_focus_picker_set_pos_x (TubaWidgetsFocusPicker* self,
                                          gdouble value);
VALA_EXTERN void tuba_widgets_focus_picker_set_pos_y (TubaWidgetsFocusPicker* self,
                                          gdouble value);
VALA_EXTERN TubaWidgetsFocusPicker* tuba_widgets_focus_picker_new (GdkPaintable* paintable);
VALA_EXTERN TubaWidgetsFocusPicker* tuba_widgets_focus_picker_construct (GType object_type,
                                                             GdkPaintable* paintable);
static void tuba_widgets_focus_picker_real_size_allocate (GtkWidget* base,
                                                   gint width,
                                                   gint height,
                                                   gint baseline);
static void tuba_widgets_focus_picker_compute_picker_half (TubaWidgetsFocusPicker* self);
static void tuba_widgets_focus_picker_update_dot_pos (TubaWidgetsFocusPicker* self);
static void tuba_widgets_focus_picker_real_measure (GtkWidget* base,
                                             GtkOrientation orientation,
                                             gint for_size,
                                             gint* minimum,
                                             gint* natural,
                                             gint* minimum_baseline,
                                             gint* natural_baseline);
static void tuba_widgets_focus_picker_real_snapshot (GtkWidget* base,
                                              GtkSnapshot* snapshot);
VALA_EXTERN gdouble tuba_widgets_focus_picker_get_pos_x (TubaWidgetsFocusPicker* self);
VALA_EXTERN gdouble tuba_widgets_focus_picker_get_pos_y (TubaWidgetsFocusPicker* self);
static GObject * tuba_widgets_focus_picker_constructor (GType type,
                                                 guint n_construct_properties,
                                                 GObjectConstructParam * construct_properties);
static void _tuba_widgets_focus_picker_on_pointer_click_gtk_gesture_click_pressed (GtkGestureClick* _sender,
                                                                            gint n_press,
                                                                            gdouble x,
                                                                            gdouble y,
                                                                            gpointer self);
static void _tuba_widgets_focus_picker_on_pointer_click_release_gtk_gesture_click_released (GtkGestureClick* _sender,
                                                                                     gint n_press,
                                                                                     gdouble x,
                                                                                     gdouble y,
                                                                                     gpointer self);
static void _tuba_widgets_focus_picker_on_fixed_click_gtk_gesture_click_pressed (GtkGestureClick* _sender,
                                                                          gint n_press,
                                                                          gdouble x,
                                                                          gdouble y,
                                                                          gpointer self);
static void _tuba_widgets_focus_picker_on_motion_gtk_event_controller_motion_motion (GtkEventControllerMotion* _sender,
                                                                              gdouble x,
                                                                              gdouble y,
                                                                              gpointer self);
static void tuba_widgets_focus_picker_finalize (GObject * obj);
static GType tuba_widgets_focus_picker_get_type_once (void);
static void _vala_tuba_widgets_focus_picker_get_property (GObject * object,
                                                   guint property_id,
                                                   GValue * value,
                                                   GParamSpec * pspec);
static void _vala_tuba_widgets_focus_picker_set_property (GObject * object,
                                                   guint property_id,
                                                   const GValue * value,
                                                   GParamSpec * pspec);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);

static inline gpointer
tuba_widgets_focus_picker_get_instance_private (TubaWidgetsFocusPicker* self)
{
	return G_STRUCT_MEMBER_P (self, TubaWidgetsFocusPicker_private_offset);
}

static void
tuba_widgets_focus_picker_on_fixed_click (TubaWidgetsFocusPicker* self,
                                          gint n_press,
                                          gdouble x,
                                          gdouble y)
{
	g_return_if_fail (self != NULL);
	if (self->priv->dragging) {
		return;
	}
	tuba_widgets_focus_picker_on_motion_real (self, x, y);
}

static void
tuba_widgets_focus_picker_on_pointer_click (TubaWidgetsFocusPicker* self)
{
	g_return_if_fail (self != NULL);
	self->priv->dragging = TRUE;
}

static void
tuba_widgets_focus_picker_on_pointer_click_release (TubaWidgetsFocusPicker* self)
{
	g_return_if_fail (self != NULL);
	self->priv->dragging = FALSE;
}

static void
tuba_widgets_focus_picker_on_motion (TubaWidgetsFocusPicker* self,
                                     gdouble x,
                                     gdouble y)
{
	g_return_if_fail (self != NULL);
	if (!self->priv->dragging) {
		return;
	}
	tuba_widgets_focus_picker_on_motion_real (self, x, y);
}

static void
tuba_widgets_focus_picker_on_motion_real (TubaWidgetsFocusPicker* self,
                                          gdouble x,
                                          gdouble y)
{
	GtkPicture* _tmp0_;
	GtkPicture* _tmp1_;
	GtkPicture* _tmp2_;
	GtkPicture* _tmp3_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->pic;
	x = CLAMP (x, (gdouble) 0, (gdouble) gtk_widget_get_width ((GtkWidget*) _tmp0_));
	_tmp1_ = self->priv->pic;
	y = CLAMP (y, (gdouble) 0, (gdouble) gtk_widget_get_height ((GtkWidget*) _tmp1_));
	_tmp2_ = self->priv->pic;
	tuba_widgets_focus_picker_set_pos_x (self, ((2 * x) / gtk_widget_get_width ((GtkWidget*) _tmp2_)) - 1);
	_tmp3_ = self->priv->pic;
	tuba_widgets_focus_picker_set_pos_y (self, (((2 * y) / gtk_widget_get_height ((GtkWidget*) _tmp3_)) - 1) * -1);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

TubaWidgetsFocusPicker*
tuba_widgets_focus_picker_construct (GType object_type,
                                     GdkPaintable* paintable)
{
	TubaWidgetsFocusPicker * self = NULL;
	GtkPicture* _tmp0_;
	GtkOverlay* _tmp1_;
	GtkPicture* _tmp2_;
	GtkPicture* _tmp3_;
	GdkPaintable* _tmp4_;
	GdkPaintable* _tmp5_;
	GtkOverlay* _tmp6_;
	GtkWidget* _tmp7_;
	GtkAspectFrame* _tmp8_ = NULL;
	GtkAspectFrame* _tmp9_;
	GtkFixed* _tmp10_;
	GtkImage* _tmp11_;
	GtkPicture* _tmp12_;
	GtkPicture* _tmp13_;
	g_return_val_if_fail (paintable != NULL, NULL);
	self = (TubaWidgetsFocusPicker*) g_object_new (object_type, NULL);
	_tmp0_ = (GtkPicture*) gtk_picture_new_for_paintable (paintable);
	g_object_ref_sink (_tmp0_);
	_g_object_unref0 (self->priv->pic);
	self->priv->pic = _tmp0_;
	_tmp1_ = self->priv->overlay;
	_tmp2_ = self->priv->pic;
	gtk_overlay_set_child (_tmp1_, (GtkWidget*) _tmp2_);
	_tmp3_ = self->priv->pic;
	_tmp4_ = gtk_picture_get_paintable (_tmp3_);
	_tmp5_ = _tmp4_;
	_tmp6_ = self->priv->overlay;
	_tmp7_ = _g_object_ref0 ((GtkWidget*) _tmp6_);
	_tmp8_ = (GtkAspectFrame*) gtk_aspect_frame_new (0.5f, 0.5f, (gfloat) gdk_paintable_get_intrinsic_aspect_ratio (_tmp5_), FALSE);
	gtk_aspect_frame_set_child (_tmp8_, _tmp7_);
	_g_object_unref0 (_tmp7_);
	g_object_ref_sink (_tmp8_);
	_g_object_unref0 (self->priv->frame);
	self->priv->frame = _tmp8_;
	_tmp9_ = self->priv->frame;
	gtk_widget_set_parent ((GtkWidget*) _tmp9_, (GtkWidget*) self);
	_tmp10_ = self->priv->fixed;
	_tmp11_ = self->priv->picker;
	_tmp12_ = self->priv->pic;
	_tmp13_ = self->priv->pic;
	gtk_fixed_put (_tmp10_, (GtkWidget*) _tmp11_, (gdouble) (gtk_widget_get_width ((GtkWidget*) _tmp12_) / 2), (gdouble) (gtk_widget_get_height ((GtkWidget*) _tmp13_) / 2));
	return self;
}

TubaWidgetsFocusPicker*
tuba_widgets_focus_picker_new (GdkPaintable* paintable)
{
	return tuba_widgets_focus_picker_construct (TUBA_WIDGETS_TYPE_FOCUS_PICKER, paintable);
}

static void
tuba_widgets_focus_picker_real_size_allocate (GtkWidget* base,
                                              gint width,
                                              gint height,
                                              gint baseline)
{
	TubaWidgetsFocusPicker * self;
	GtkAspectFrame* _tmp0_;
	gboolean _tmp1_ = FALSE;
	self = (TubaWidgetsFocusPicker*) base;
	_tmp0_ = self->priv->frame;
	gtk_widget_allocate ((GtkWidget*) _tmp0_, width, height, baseline, NULL);
	if (self->priv->picker_width_half == ((gdouble) 0)) {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = self->priv->picker_height_half == ((gdouble) 0);
	}
	if (_tmp1_) {
		tuba_widgets_focus_picker_compute_picker_half (self);
	}
	tuba_widgets_focus_picker_update_dot_pos (self);
}

static void
tuba_widgets_focus_picker_real_measure (GtkWidget* base,
                                        GtkOrientation orientation,
                                        gint for_size,
                                        gint* minimum,
                                        gint* natural,
                                        gint* minimum_baseline,
                                        gint* natural_baseline)
{
	TubaWidgetsFocusPicker * self;
	gint _vala_minimum = 0;
	gint _vala_natural = 0;
	gint _vala_minimum_baseline = 0;
	gint _vala_natural_baseline = 0;
	GtkAspectFrame* _tmp0_;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	gint _tmp3_ = 0;
	gint _tmp4_ = 0;
	self = (TubaWidgetsFocusPicker*) base;
	_tmp0_ = self->priv->frame;
	gtk_widget_measure ((GtkWidget*) _tmp0_, orientation, for_size, &_tmp1_, &_tmp2_, &_tmp3_, &_tmp4_);
	_vala_minimum = _tmp1_;
	_vala_natural = _tmp2_;
	_vala_minimum_baseline = _tmp3_;
	_vala_natural_baseline = _tmp4_;
	if (minimum) {
		*minimum = _vala_minimum;
	}
	if (natural) {
		*natural = _vala_natural;
	}
	if (minimum_baseline) {
		*minimum_baseline = _vala_minimum_baseline;
	}
	if (natural_baseline) {
		*natural_baseline = _vala_natural_baseline;
	}
}

static void
tuba_widgets_focus_picker_real_snapshot (GtkWidget* base,
                                         GtkSnapshot* snapshot)
{
	TubaWidgetsFocusPicker * self;
	self = (TubaWidgetsFocusPicker*) base;
	g_return_if_fail (snapshot != NULL);
	GTK_WIDGET_CLASS (tuba_widgets_focus_picker_parent_class)->snapshot (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget), snapshot);
}

static void
tuba_widgets_focus_picker_update_dot_pos (TubaWidgetsFocusPicker* self)
{
	gint new_x = 0;
	GtkPicture* _tmp0_;
	gint new_y = 0;
	GtkPicture* _tmp1_;
	GtkFixed* _tmp2_;
	GtkImage* _tmp3_;
	gdouble _tmp4_;
	gdouble _tmp5_;
	gdouble _tmp6_;
	gdouble _tmp7_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->pic;
	new_x = gtk_widget_get_width ((GtkWidget*) _tmp0_) / 2;
	_tmp1_ = self->priv->pic;
	new_y = gtk_widget_get_height ((GtkWidget*) _tmp1_) / 2;
	_tmp2_ = self->priv->fixed;
	_tmp3_ = self->priv->picker;
	_tmp4_ = tuba_widgets_focus_picker_get_pos_x (self);
	_tmp5_ = _tmp4_;
	_tmp6_ = tuba_widgets_focus_picker_get_pos_y (self);
	_tmp7_ = _tmp6_;
	gtk_fixed_move (_tmp2_, (GtkWidget*) _tmp3_, (new_x + (new_x * _tmp5_)) - self->priv->picker_width_half, (new_y + ((new_y * _tmp7_) * -1)) - self->priv->picker_height_half);
}

static void
tuba_widgets_focus_picker_compute_picker_half (TubaWidgetsFocusPicker* self)
{
	graphene_rect_t rect = {0};
	GtkImage* _tmp0_;
	GtkFixed* _tmp1_;
	graphene_rect_t _tmp2_ = {0};
	gboolean _tmp3_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->picker;
	_tmp1_ = self->priv->fixed;
	_tmp3_ = gtk_widget_compute_bounds ((GtkWidget*) _tmp0_, (GtkWidget*) _tmp1_, &_tmp2_);
	rect = _tmp2_;
	if (!_tmp3_) {
		GtkImage* _tmp4_;
		GtkImage* _tmp5_;
		_tmp4_ = self->priv->picker;
		self->priv->picker_width_half = (gdouble) (gtk_widget_get_width ((GtkWidget*) _tmp4_) / 2);
		_tmp5_ = self->priv->picker;
		self->priv->picker_height_half = (gdouble) (gtk_widget_get_height ((GtkWidget*) _tmp5_) / 2);
	} else {
		graphene_rect_t _tmp6_;
		graphene_size_t _tmp7_;
		graphene_rect_t _tmp8_;
		graphene_size_t _tmp9_;
		_tmp6_ = rect;
		_tmp7_ = _tmp6_.size;
		self->priv->picker_width_half = (gdouble) (_tmp7_.width / 2);
		_tmp8_ = rect;
		_tmp9_ = _tmp8_.size;
		self->priv->picker_height_half = (gdouble) (_tmp9_.height / 2);
	}
}

gdouble
tuba_widgets_focus_picker_get_pos_x (TubaWidgetsFocusPicker* self)
{
	gdouble result;
	g_return_val_if_fail (self != NULL, 0.0);
	result = self->priv->_pos_x;
	return result;
}

void
tuba_widgets_focus_picker_set_pos_x (TubaWidgetsFocusPicker* self,
                                     gdouble value)
{
	g_return_if_fail (self != NULL);
	self->priv->_pos_x = value;
	tuba_widgets_focus_picker_update_dot_pos (self);
	g_object_notify_by_pspec ((GObject *) self, tuba_widgets_focus_picker_properties[TUBA_WIDGETS_FOCUS_PICKER_POS_X_PROPERTY]);
}

gdouble
tuba_widgets_focus_picker_get_pos_y (TubaWidgetsFocusPicker* self)
{
	gdouble result;
	g_return_val_if_fail (self != NULL, 0.0);
	result = self->priv->_pos_y;
	return result;
}

void
tuba_widgets_focus_picker_set_pos_y (TubaWidgetsFocusPicker* self,
                                     gdouble value)
{
	g_return_if_fail (self != NULL);
	self->priv->_pos_y = value;
	tuba_widgets_focus_picker_update_dot_pos (self);
	g_object_notify_by_pspec ((GObject *) self, tuba_widgets_focus_picker_properties[TUBA_WIDGETS_FOCUS_PICKER_POS_Y_PROPERTY]);
}

static void
_tuba_widgets_focus_picker_on_pointer_click_gtk_gesture_click_pressed (GtkGestureClick* _sender,
                                                                       gint n_press,
                                                                       gdouble x,
                                                                       gdouble y,
                                                                       gpointer self)
{
	tuba_widgets_focus_picker_on_pointer_click ((TubaWidgetsFocusPicker*) self);
}

static void
_tuba_widgets_focus_picker_on_pointer_click_release_gtk_gesture_click_released (GtkGestureClick* _sender,
                                                                                gint n_press,
                                                                                gdouble x,
                                                                                gdouble y,
                                                                                gpointer self)
{
	tuba_widgets_focus_picker_on_pointer_click_release ((TubaWidgetsFocusPicker*) self);
}

static void
_tuba_widgets_focus_picker_on_fixed_click_gtk_gesture_click_pressed (GtkGestureClick* _sender,
                                                                     gint n_press,
                                                                     gdouble x,
                                                                     gdouble y,
                                                                     gpointer self)
{
	tuba_widgets_focus_picker_on_fixed_click ((TubaWidgetsFocusPicker*) self, n_press, x, y);
}

static void
_tuba_widgets_focus_picker_on_motion_gtk_event_controller_motion_motion (GtkEventControllerMotion* _sender,
                                                                         gdouble x,
                                                                         gdouble y,
                                                                         gpointer self)
{
	tuba_widgets_focus_picker_on_motion ((TubaWidgetsFocusPicker*) self, x, y);
}

static GObject *
tuba_widgets_focus_picker_constructor (GType type,
                                       guint n_construct_properties,
                                       GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	TubaWidgetsFocusPicker * self;
	GtkOverlay* _tmp0_ = NULL;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar** _tmp4_;
	gchar* _tmp5_;
	GtkImage* _tmp6_ = NULL;
	GtkFixed* _tmp7_;
	GtkOverlay* _tmp8_;
	GtkFixed* _tmp9_;
	GtkOverlay* _tmp10_;
	GtkFixed* _tmp11_;
	GtkGestureClick* picker_click_gesture = NULL;
	GtkGestureClick* _tmp12_ = NULL;
	GtkGestureClick* _tmp13_;
	GtkGestureClick* _tmp14_;
	GtkImage* _tmp15_;
	GtkGestureClick* _tmp16_;
	GtkEventController* _tmp17_;
	GtkGestureClick* fixed_click_gesture = NULL;
	GtkGestureClick* _tmp18_ = NULL;
	GtkGestureClick* _tmp19_;
	GtkFixed* _tmp20_;
	GtkGestureClick* _tmp21_;
	GtkEventController* _tmp22_;
	GtkEventControllerMotion* motion = NULL;
	GtkEventControllerMotion* _tmp23_;
	GtkEventControllerMotion* _tmp24_;
	GtkFixed* _tmp25_;
	GtkEventControllerMotion* _tmp26_;
	GtkEventController* _tmp27_;
	parent_class = G_OBJECT_CLASS (tuba_widgets_focus_picker_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TUBA_WIDGETS_TYPE_FOCUS_PICKER, TubaWidgetsFocusPicker);
	_tmp0_ = (GtkOverlay*) gtk_overlay_new ();
	gtk_widget_set_vexpand ((GtkWidget*) _tmp0_, TRUE);
	gtk_widget_set_hexpand ((GtkWidget*) _tmp0_, TRUE);
	g_object_ref_sink (_tmp0_);
	_g_object_unref0 (self->priv->overlay);
	self->priv->overlay = _tmp0_;
	_tmp1_ = g_strdup ("osd");
	_tmp2_ = g_strdup ("focus-picker");
	_tmp3_ = g_strdup ("tuba-circular");
	_tmp4_ = g_new0 (gchar*, 3 + 1);
	_tmp4_[0] = _tmp1_;
	_tmp4_[1] = _tmp2_;
	_tmp4_[2] = _tmp3_;
	_tmp5_ = g_strdup (_ ("Focus Picker"));
	_tmp6_ = (GtkImage*) gtk_image_new_from_icon_name ("tuba-radio-checked-symbolic");
	gtk_widget_set_css_classes ((GtkWidget*) _tmp6_, _tmp4_);
	_tmp4_ = (_vala_array_free (_tmp4_, 3, (GDestroyNotify) g_free), NULL);
	gtk_widget_set_valign ((GtkWidget*) _tmp6_, GTK_ALIGN_CENTER);
	gtk_widget_set_halign ((GtkWidget*) _tmp6_, GTK_ALIGN_CENTER);
	gtk_image_set_icon_size (_tmp6_, GTK_ICON_SIZE_LARGE);
	gtk_widget_set_tooltip_text ((GtkWidget*) _tmp6_, _tmp5_);
	_g_free0 (_tmp5_);
	g_object_ref_sink (_tmp6_);
	_g_object_unref0 (self->priv->picker);
	self->priv->picker = _tmp6_;
	_tmp7_ = (GtkFixed*) gtk_fixed_new ();
	g_object_ref_sink (_tmp7_);
	_g_object_unref0 (self->priv->fixed);
	self->priv->fixed = _tmp7_;
	_tmp8_ = self->priv->overlay;
	_tmp9_ = self->priv->fixed;
	gtk_overlay_add_overlay (_tmp8_, (GtkWidget*) _tmp9_);
	_tmp10_ = self->priv->overlay;
	_tmp11_ = self->priv->fixed;
	gtk_overlay_set_clip_overlay (_tmp10_, (GtkWidget*) _tmp11_, TRUE);
	_tmp12_ = (GtkGestureClick*) gtk_gesture_click_new ();
	gtk_gesture_single_set_button ((GtkGestureSingle*) _tmp12_, (guint) GDK_BUTTON_PRIMARY);
	gtk_event_controller_set_propagation_phase ((GtkEventController*) _tmp12_, GTK_PHASE_CAPTURE);
	picker_click_gesture = _tmp12_;
	_tmp13_ = picker_click_gesture;
	g_signal_connect_object (_tmp13_, "pressed", (GCallback) _tuba_widgets_focus_picker_on_pointer_click_gtk_gesture_click_pressed, self, 0);
	_tmp14_ = picker_click_gesture;
	g_signal_connect_object (_tmp14_, "released", (GCallback) _tuba_widgets_focus_picker_on_pointer_click_release_gtk_gesture_click_released, self, 0);
	_tmp15_ = self->priv->picker;
	_tmp16_ = picker_click_gesture;
	_tmp17_ = _g_object_ref0 ((GtkEventController*) _tmp16_);
	gtk_widget_add_controller ((GtkWidget*) _tmp15_, _tmp17_);
	_tmp18_ = (GtkGestureClick*) gtk_gesture_click_new ();
	gtk_gesture_single_set_button ((GtkGestureSingle*) _tmp18_, (guint) GDK_BUTTON_PRIMARY);
	gtk_event_controller_set_propagation_phase ((GtkEventController*) _tmp18_, GTK_PHASE_CAPTURE);
	fixed_click_gesture = _tmp18_;
	_tmp19_ = fixed_click_gesture;
	g_signal_connect_object (_tmp19_, "pressed", (GCallback) _tuba_widgets_focus_picker_on_fixed_click_gtk_gesture_click_pressed, self, 0);
	_tmp20_ = self->priv->fixed;
	_tmp21_ = fixed_click_gesture;
	_tmp22_ = _g_object_ref0 ((GtkEventController*) _tmp21_);
	gtk_widget_add_controller ((GtkWidget*) _tmp20_, _tmp22_);
	_tmp23_ = (GtkEventControllerMotion*) gtk_event_controller_motion_new ();
	motion = _tmp23_;
	_tmp24_ = motion;
	g_signal_connect_object (_tmp24_, "motion", (GCallback) _tuba_widgets_focus_picker_on_motion_gtk_event_controller_motion_motion, self, 0);
	_tmp25_ = self->priv->fixed;
	_tmp26_ = motion;
	_tmp27_ = _g_object_ref0 ((GtkEventController*) _tmp26_);
	gtk_widget_add_controller ((GtkWidget*) _tmp25_, _tmp27_);
	_g_object_unref0 (motion);
	_g_object_unref0 (fixed_click_gesture);
	_g_object_unref0 (picker_click_gesture);
	return obj;
}

static void
tuba_widgets_focus_picker_class_init (TubaWidgetsFocusPickerClass * klass,
                                      gpointer klass_data)
{
	tuba_widgets_focus_picker_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &TubaWidgetsFocusPicker_private_offset);
	((GtkWidgetClass *) klass)->size_allocate = (void (*) (GtkWidget*, gint, gint, gint)) tuba_widgets_focus_picker_real_size_allocate;
	((GtkWidgetClass *) klass)->measure = (void (*) (GtkWidget*, GtkOrientation, gint, gint*, gint*, gint*, gint*)) tuba_widgets_focus_picker_real_measure;
	((GtkWidgetClass *) klass)->snapshot = (void (*) (GtkWidget*, GtkSnapshot*)) tuba_widgets_focus_picker_real_snapshot;
	G_OBJECT_CLASS (klass)->get_property = _vala_tuba_widgets_focus_picker_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_tuba_widgets_focus_picker_set_property;
	G_OBJECT_CLASS (klass)->constructor = tuba_widgets_focus_picker_constructor;
	G_OBJECT_CLASS (klass)->finalize = tuba_widgets_focus_picker_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), TUBA_WIDGETS_FOCUS_PICKER_POS_X_PROPERTY, tuba_widgets_focus_picker_properties[TUBA_WIDGETS_FOCUS_PICKER_POS_X_PROPERTY] = g_param_spec_double ("pos-x", "pos-x", "pos-x", -G_MAXDOUBLE, G_MAXDOUBLE, 0.0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), TUBA_WIDGETS_FOCUS_PICKER_POS_Y_PROPERTY, tuba_widgets_focus_picker_properties[TUBA_WIDGETS_FOCUS_PICKER_POS_Y_PROPERTY] = g_param_spec_double ("pos-y", "pos-y", "pos-y", -G_MAXDOUBLE, G_MAXDOUBLE, 0.0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
}

static void
tuba_widgets_focus_picker_instance_init (TubaWidgetsFocusPicker * self,
                                         gpointer klass)
{
	self->priv = tuba_widgets_focus_picker_get_instance_private (self);
	self->priv->_pos_x = 0.0;
	self->priv->_pos_y = 0.0;
	self->priv->picker_width_half = (gdouble) 0;
	self->priv->picker_height_half = (gdouble) 0;
	self->priv->dragging = FALSE;
}

static void
tuba_widgets_focus_picker_finalize (GObject * obj)
{
	TubaWidgetsFocusPicker * self;
	GtkAspectFrame* _tmp0_;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TUBA_WIDGETS_TYPE_FOCUS_PICKER, TubaWidgetsFocusPicker);
	g_debug ("FocusPicker.vala:190: Destroying FocusPicker");
	_tmp0_ = self->priv->frame;
	gtk_widget_unparent ((GtkWidget*) _tmp0_);
	_g_object_unref0 (self->priv->pic);
	_g_object_unref0 (self->priv->fixed);
	_g_object_unref0 (self->priv->picker);
	_g_object_unref0 (self->priv->frame);
	_g_object_unref0 (self->priv->overlay);
	G_OBJECT_CLASS (tuba_widgets_focus_picker_parent_class)->finalize (obj);
}

 G_GNUC_NO_INLINE static GType
tuba_widgets_focus_picker_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (TubaWidgetsFocusPickerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) tuba_widgets_focus_picker_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (TubaWidgetsFocusPicker), 0, (GInstanceInitFunc) tuba_widgets_focus_picker_instance_init, NULL };
	GType tuba_widgets_focus_picker_type_id;
	tuba_widgets_focus_picker_type_id = g_type_register_static (gtk_widget_get_type (), "TubaWidgetsFocusPicker", &g_define_type_info, 0);
	TubaWidgetsFocusPicker_private_offset = g_type_add_instance_private (tuba_widgets_focus_picker_type_id, sizeof (TubaWidgetsFocusPickerPrivate));
	return tuba_widgets_focus_picker_type_id;
}

GType
tuba_widgets_focus_picker_get_type (void)
{
	static gsize tuba_widgets_focus_picker_type_id__once = 0;
	if (g_once_init_enter (&tuba_widgets_focus_picker_type_id__once)) {
		GType tuba_widgets_focus_picker_type_id;
		tuba_widgets_focus_picker_type_id = tuba_widgets_focus_picker_get_type_once ();
		g_once_init_leave (&tuba_widgets_focus_picker_type_id__once, tuba_widgets_focus_picker_type_id);
	}
	return tuba_widgets_focus_picker_type_id__once;
}

static void
_vala_tuba_widgets_focus_picker_get_property (GObject * object,
                                              guint property_id,
                                              GValue * value,
                                              GParamSpec * pspec)
{
	TubaWidgetsFocusPicker * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TUBA_WIDGETS_TYPE_FOCUS_PICKER, TubaWidgetsFocusPicker);
	switch (property_id) {
		case TUBA_WIDGETS_FOCUS_PICKER_POS_X_PROPERTY:
		g_value_set_double (value, tuba_widgets_focus_picker_get_pos_x (self));
		break;
		case TUBA_WIDGETS_FOCUS_PICKER_POS_Y_PROPERTY:
		g_value_set_double (value, tuba_widgets_focus_picker_get_pos_y (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_tuba_widgets_focus_picker_set_property (GObject * object,
                                              guint property_id,
                                              const GValue * value,
                                              GParamSpec * pspec)
{
	TubaWidgetsFocusPicker * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TUBA_WIDGETS_TYPE_FOCUS_PICKER, TubaWidgetsFocusPicker);
	switch (property_id) {
		case TUBA_WIDGETS_FOCUS_PICKER_POS_X_PROPERTY:
		tuba_widgets_focus_picker_set_pos_x (self, g_value_get_double (value));
		break;
		case TUBA_WIDGETS_FOCUS_PICKER_POS_Y_PROPERTY:
		tuba_widgets_focus_picker_set_pos_y (self, g_value_get_double (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

