// Copyright 2014 Emilie Gillet.
//
// Author: Emilie Gillet (emilie.o.gillet@gmail.com)
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to deal
// in the Software without restriction, including without limitation the rights
// to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
// copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
// 
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
// 
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
// AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
// THE SOFTWARE.
// 
// See http://creativecommons.org/licenses/MIT/ for more information.
//
// -----------------------------------------------------------------------------
//
// Resources definitions.
//
// Automatically generated with:
// make resources


#include "clouds/resources.h"

namespace clouds {

const float src_filter_1x_2_31[] = {
   6.826286541e-03,  1.617306168e-02, -9.023930288e-03, -1.314720136e-02,
   2.771050661e-03,  2.178528721e-02,  3.540864731e-03, -2.954351590e-02,
  -1.652225270e-02,  3.723501469e-02,  3.990208332e-02, -4.362991064e-02,
  -8.919302357e-02,  4.787067784e-02,  3.056656246e-01,  4.385797663e-01,
   3.056656246e-01,  4.787067784e-02, -8.919302357e-02, -4.362991064e-02,
   3.990208332e-02,  3.723501469e-02, -1.652225270e-02, -2.954351590e-02,
   3.540864731e-03,  2.178528721e-02,  2.771050661e-03, -1.314720136e-02,
  -9.023930288e-03,  1.617306168e-02,  6.826286541e-03,
};
const float src_filter_1x_2_45[] = {
  -6.928606892e-04, -5.894682972e-03,  4.393903915e-04,  5.352009980e-03,
   1.833575577e-03, -7.103853054e-03, -5.275577768e-03,  7.999060050e-03,
   1.029879712e-02, -7.191125897e-03, -1.675763381e-02,  3.628265970e-03,
   2.423749384e-02,  4.020326715e-03, -3.208822586e-02, -1.775516900e-02,
   3.947412082e-02,  4.200610725e-02, -4.553678524e-02, -9.270618476e-02,
   4.952442102e-02,  3.157869177e-01,  4.528032253e-01,  3.157869177e-01,
   4.952442102e-02, -9.270618476e-02, -4.553678524e-02,  4.200610725e-02,
   3.947412082e-02, -1.775516900e-02, -3.208822586e-02,  4.020326715e-03,
   2.423749384e-02,  3.628265970e-03, -1.675763381e-02, -7.191125897e-03,
   1.029879712e-02,  7.999060050e-03, -5.275577768e-03, -7.103853054e-03,
   1.833575577e-03,  5.352009980e-03,  4.393903915e-04, -5.894682972e-03,
  -6.928606892e-04,
};
const float src_filter_1x_2_63[] = {
  -6.348730944e-05, -1.372758379e-03, -1.090158652e-04,  1.449992610e-03,
   7.764237476e-04, -1.914529528e-03, -1.888816073e-03,  2.068584229e-03,
   3.473105649e-03, -1.607254039e-03, -5.400889080e-03,  2.059859441e-04,
   7.378652196e-03,  2.417634823e-03, -8.932556303e-03, -6.437404089e-03,
   9.420536985e-03,  1.185151429e-02, -8.052838204e-03, -1.844452267e-02,
   3.892438708e-03,  2.578506960e-02,  4.245183480e-03, -3.325824306e-02,
  -1.824475506e-02,  4.014317945e-02,  4.244950213e-02, -4.570810215e-02,
  -9.270121085e-02,  4.933056451e-02,  3.141498821e-01,  4.501962644e-01,
   3.141498821e-01,  4.933056451e-02, -9.270121085e-02, -4.570810215e-02,
   4.244950213e-02,  4.014317945e-02, -1.824475506e-02, -3.325824306e-02,
   4.245183480e-03,  2.578506960e-02,  3.892438708e-03, -1.844452267e-02,
  -8.052838204e-03,  1.185151429e-02,  9.420536985e-03, -6.437404089e-03,
  -8.932556303e-03,  2.417634823e-03,  7.378652196e-03,  2.059859441e-04,
  -5.400889080e-03, -1.607254039e-03,  3.473105649e-03,  2.068584229e-03,
  -1.888816073e-03, -1.914529528e-03,  7.764237476e-04,  1.449992610e-03,
  -1.090158652e-04, -1.372758379e-03, -6.348730944e-05,
};
const float src_filter_1x_2_91[] = {
   5.995404419e-05, -1.086251194e-04, -1.567613822e-04,  7.318513013e-05,
   2.786863682e-04, -2.005518760e-05, -4.598993838e-04, -1.491618144e-04,
   6.419356251e-04,  4.667860185e-04, -7.605503855e-04, -9.553359341e-04,
   7.180820814e-04,  1.596791918e-03, -3.991513247e-04, -2.317029331e-03,
  -3.083105467e-04,  2.974875240e-03,  1.483218326e-03, -3.362318098e-03,
  -3.136315351e-03,  3.220007405e-03,  5.176985447e-03, -2.268251821e-03,
  -7.387480901e-03,  2.502104061e-04,  9.411423307e-03,  3.016896745e-03,
  -1.075849228e-02, -7.593299279e-03,  1.082145444e-02,  1.337979201e-02,
  -8.893304924e-03, -2.010112473e-02,  4.150771334e-03,  2.731711969e-02,
   4.473696485e-03, -3.446125216e-02, -1.876858707e-02,  4.090482428e-02,
   4.302004520e-02, -4.603598801e-02, -9.305699806e-02,  4.934267077e-02,
   3.138853910e-01,  4.495869796e-01,  3.138853910e-01,  4.934267077e-02,
  -9.305699806e-02, -4.603598801e-02,  4.302004520e-02,  4.090482428e-02,
  -1.876858707e-02, -3.446125216e-02,  4.473696485e-03,  2.731711969e-02,
   4.150771334e-03, -2.010112473e-02, -8.893304924e-03,  1.337979201e-02,
   1.082145444e-02, -7.593299279e-03, -1.075849228e-02,  3.016896745e-03,
   9.411423307e-03,  2.502104061e-04, -7.387480901e-03, -2.268251821e-03,
   5.176985447e-03,  3.220007405e-03, -3.136315351e-03, -3.362318098e-03,
   1.483218326e-03,  2.974875240e-03, -3.083105467e-04, -2.317029331e-03,
  -3.991513247e-04,  1.596791918e-03,  7.180820814e-04, -9.553359341e-04,
  -7.605503855e-04,  4.667860185e-04,  6.419356251e-04, -1.491618144e-04,
  -4.598993838e-04, -2.005518760e-05,  2.786863682e-04,  7.318513013e-05,
  -1.567613822e-04, -1.086251194e-04,  5.995404419e-05,
};


const float* src_filter_table[] = {
  src_filter_1x_2_31,
  src_filter_1x_2_45,
  src_filter_1x_2_63,
  src_filter_1x_2_91,
};

const int16_t lut_db[] = {
  -32768, -32768, -24576, -19783,
  -16384, -13746, -11591,  -9770,
   -8192,  -6799,  -5554,  -4428,
   -3399,  -2453,  -1578,   -762,
       0,    716,   1392,   2031,
    2637,   3213,   3763,   4289,
    4792,   5274,   5738,   6184,
    6613,   7028,   7429,   7816,
    8192,   8555,   8908,   9251,
    9584,   9907,  10223,  10530,
   10829,  11121,  11405,  11683,
   11955,  12221,  12481,  12735,
   12984,  13227,  13466,  13700,
   13930,  14155,  14376,  14592,
   14805,  15015,  15220,  15422,
   15621,  15816,  16008,  16197,
   16384,  16567,  16747,  16925,
   17100,  17273,  17443,  17610,
   17776,  17939,  18099,  18258,
   18415,  18569,  18722,  18872,
   19021,  19168,  19313,  19456,
   19597,  19737,  19875,  20012,
   20147,  20281,  20413,  20543,
   20673,  20800,  20927,  21052,
   21176,  21298,  21419,  21539,
   21658,  21776,  21892,  22007,
   22122,  22235,  22347,  22458,
   22568,  22676,  22784,  22891,
   22997,  23102,  23207,  23310,
   23412,  23514,  23614,  23714,
   23813,  23911,  24008,  24105,
   24200,  24295,  24389,  24483,
   24576,  24667,  24759,  24849,
   24939,  25028,  25117,  25205,
   25292,  25379,  25465,  25550,
   25635,  25719,  25802,  25885,
   25968,  26049,  26131,  26211,
   26291,  26371,  26450,  26529,
   26607,  26684,  26761,  26838,
   26914,  26989,  27064,  27139,
   27213,  27286,  27360,  27432,
   27505,  27576,  27648,  27719,
   27789,  27860,  27929,  27999,
   28067,  28136,  28204,  28272,
   28339,  28406,  28473,  28539,
   28605,  28670,  28735,  28800,
   28865,  28929,  28992,  29056,
   29119,  29181,  29244,  29306,
   29368,  29429,  29490,  29551,
   29611,  29671,  29731,  29791,
   29850,  29909,  29968,  30026,
   30084,  30142,  30199,  30257,
   30314,  30370,  30427,  30483,
   30539,  30594,  30650,  30705,
   30760,  30814,  30868,  30923,
   30976,  31030,  31083,  31136,
   31189,  31242,  31294,  31347,
   31399,  31450,  31502,  31553,
   31604,  31655,  31706,  31756,
   31806,  31856,  31906,  31955,
   32005,  32054,  32103,  32152,
   32200,  32248,  32297,  32345,
   32392,  32440,  32487,  32534,
   32581,  32628,  32675,  32721,
   32721,
};


const int16_t* lookup_table_int16_table[] = {
  lut_db,
};

const float lut_sin[] = {
   0.000000000e+00,  6.135884649e-03,  1.227153829e-02,  1.840672991e-02,
   2.454122852e-02,  3.067480318e-02,  3.680722294e-02,  4.293825693e-02,
   4.906767433e-02,  5.519524435e-02,  6.132073630e-02,  6.744391956e-02,
   7.356456360e-02,  7.968243797e-02,  8.579731234e-02,  9.190895650e-02,
   9.801714033e-02,  1.041216339e-01,  1.102222073e-01,  1.163186309e-01,
   1.224106752e-01,  1.284981108e-01,  1.345807085e-01,  1.406582393e-01,
   1.467304745e-01,  1.527971853e-01,  1.588581433e-01,  1.649131205e-01,
   1.709618888e-01,  1.770042204e-01,  1.830398880e-01,  1.890686641e-01,
   1.950903220e-01,  2.011046348e-01,  2.071113762e-01,  2.131103199e-01,
   2.191012402e-01,  2.250839114e-01,  2.310581083e-01,  2.370236060e-01,
   2.429801799e-01,  2.489276057e-01,  2.548656596e-01,  2.607941179e-01,
   2.667127575e-01,  2.726213554e-01,  2.785196894e-01,  2.844075372e-01,
   2.902846773e-01,  2.961508882e-01,  3.020059493e-01,  3.078496400e-01,
   3.136817404e-01,  3.195020308e-01,  3.253102922e-01,  3.311063058e-01,
   3.368898534e-01,  3.426607173e-01,  3.484186802e-01,  3.541635254e-01,
   3.598950365e-01,  3.656129978e-01,  3.713171940e-01,  3.770074102e-01,
   3.826834324e-01,  3.883450467e-01,  3.939920401e-01,  3.996241998e-01,
   4.052413140e-01,  4.108431711e-01,  4.164295601e-01,  4.220002708e-01,
   4.275550934e-01,  4.330938189e-01,  4.386162385e-01,  4.441221446e-01,
   4.496113297e-01,  4.550835871e-01,  4.605387110e-01,  4.659764958e-01,
   4.713967368e-01,  4.767992301e-01,  4.821837721e-01,  4.875501601e-01,
   4.928981922e-01,  4.982276670e-01,  5.035383837e-01,  5.088301425e-01,
   5.141027442e-01,  5.193559902e-01,  5.245896827e-01,  5.298036247e-01,
   5.349976199e-01,  5.401714727e-01,  5.453249884e-01,  5.504579729e-01,
   5.555702330e-01,  5.606615762e-01,  5.657318108e-01,  5.707807459e-01,
   5.758081914e-01,  5.808139581e-01,  5.857978575e-01,  5.907597019e-01,
   5.956993045e-01,  6.006164794e-01,  6.055110414e-01,  6.103828063e-01,
   6.152315906e-01,  6.200572118e-01,  6.248594881e-01,  6.296382389e-01,
   6.343932842e-01,  6.391244449e-01,  6.438315429e-01,  6.485144010e-01,
   6.531728430e-01,  6.578066933e-01,  6.624157776e-01,  6.669999223e-01,
   6.715589548e-01,  6.760927036e-01,  6.806009978e-01,  6.850836678e-01,
   6.895405447e-01,  6.939714609e-01,  6.983762494e-01,  7.027547445e-01,
   7.071067812e-01,  7.114321957e-01,  7.157308253e-01,  7.200025080e-01,
   7.242470830e-01,  7.284643904e-01,  7.326542717e-01,  7.368165689e-01,
   7.409511254e-01,  7.450577854e-01,  7.491363945e-01,  7.531867990e-01,
   7.572088465e-01,  7.612023855e-01,  7.651672656e-01,  7.691033376e-01,
   7.730104534e-01,  7.768884657e-01,  7.807372286e-01,  7.845565972e-01,
   7.883464276e-01,  7.921065773e-01,  7.958369046e-01,  7.995372691e-01,
   8.032075315e-01,  8.068475535e-01,  8.104571983e-01,  8.140363297e-01,
   8.175848132e-01,  8.211025150e-01,  8.245893028e-01,  8.280450453e-01,
   8.314696123e-01,  8.348628750e-01,  8.382247056e-01,  8.415549774e-01,
   8.448535652e-01,  8.481203448e-01,  8.513551931e-01,  8.545579884e-01,
   8.577286100e-01,  8.608669386e-01,  8.639728561e-01,  8.670462455e-01,
   8.700869911e-01,  8.730949784e-01,  8.760700942e-01,  8.790122264e-01,
   8.819212643e-01,  8.847970984e-01,  8.876396204e-01,  8.904487232e-01,
   8.932243012e-01,  8.959662498e-01,  8.986744657e-01,  9.013488470e-01,
   9.039892931e-01,  9.065957045e-01,  9.091679831e-01,  9.117060320e-01,
   9.142097557e-01,  9.166790599e-01,  9.191138517e-01,  9.215140393e-01,
   9.238795325e-01,  9.262102421e-01,  9.285060805e-01,  9.307669611e-01,
   9.329927988e-01,  9.351835099e-01,  9.373390119e-01,  9.394592236e-01,
   9.415440652e-01,  9.435934582e-01,  9.456073254e-01,  9.475855910e-01,
   9.495281806e-01,  9.514350210e-01,  9.533060404e-01,  9.551411683e-01,
   9.569403357e-01,  9.587034749e-01,  9.604305194e-01,  9.621214043e-01,
   9.637760658e-01,  9.653944417e-01,  9.669764710e-01,  9.685220943e-01,
   9.700312532e-01,  9.715038910e-01,  9.729399522e-01,  9.743393828e-01,
   9.757021300e-01,  9.770281427e-01,  9.783173707e-01,  9.795697657e-01,
   9.807852804e-01,  9.819638691e-01,  9.831054874e-01,  9.842100924e-01,
   9.852776424e-01,  9.863080972e-01,  9.873014182e-01,  9.882575677e-01,
   9.891765100e-01,  9.900582103e-01,  9.909026354e-01,  9.917097537e-01,
   9.924795346e-01,  9.932119492e-01,  9.939069700e-01,  9.945645707e-01,
   9.951847267e-01,  9.957674145e-01,  9.963126122e-01,  9.968202993e-01,
   9.972904567e-01,  9.977230666e-01,  9.981181129e-01,  9.984755806e-01,
   9.987954562e-01,  9.990777278e-01,  9.993223846e-01,  9.995294175e-01,
   9.996988187e-01,  9.998305818e-01,  9.999247018e-01,  9.999811753e-01,
   1.000000000e+00,  9.999811753e-01,  9.999247018e-01,  9.998305818e-01,
   9.996988187e-01,  9.995294175e-01,  9.993223846e-01,  9.990777278e-01,
   9.987954562e-01,  9.984755806e-01,  9.981181129e-01,  9.977230666e-01,
   9.972904567e-01,  9.968202993e-01,  9.963126122e-01,  9.957674145e-01,
   9.951847267e-01,  9.945645707e-01,  9.939069700e-01,  9.932119492e-01,
   9.924795346e-01,  9.917097537e-01,  9.909026354e-01,  9.900582103e-01,
   9.891765100e-01,  9.882575677e-01,  9.873014182e-01,  9.863080972e-01,
   9.852776424e-01,  9.842100924e-01,  9.831054874e-01,  9.819638691e-01,
   9.807852804e-01,  9.795697657e-01,  9.783173707e-01,  9.770281427e-01,
   9.757021300e-01,  9.743393828e-01,  9.729399522e-01,  9.715038910e-01,
   9.700312532e-01,  9.685220943e-01,  9.669764710e-01,  9.653944417e-01,
   9.637760658e-01,  9.621214043e-01,  9.604305194e-01,  9.587034749e-01,
   9.569403357e-01,  9.551411683e-01,  9.533060404e-01,  9.514350210e-01,
   9.495281806e-01,  9.475855910e-01,  9.456073254e-01,  9.435934582e-01,
   9.415440652e-01,  9.394592236e-01,  9.373390119e-01,  9.351835099e-01,
   9.329927988e-01,  9.307669611e-01,  9.285060805e-01,  9.262102421e-01,
   9.238795325e-01,  9.215140393e-01,  9.191138517e-01,  9.166790599e-01,
   9.142097557e-01,  9.117060320e-01,  9.091679831e-01,  9.065957045e-01,
   9.039892931e-01,  9.013488470e-01,  8.986744657e-01,  8.959662498e-01,
   8.932243012e-01,  8.904487232e-01,  8.876396204e-01,  8.847970984e-01,
   8.819212643e-01,  8.790122264e-01,  8.760700942e-01,  8.730949784e-01,
   8.700869911e-01,  8.670462455e-01,  8.639728561e-01,  8.608669386e-01,
   8.577286100e-01,  8.545579884e-01,  8.513551931e-01,  8.481203448e-01,
   8.448535652e-01,  8.415549774e-01,  8.382247056e-01,  8.348628750e-01,
   8.314696123e-01,  8.280450453e-01,  8.245893028e-01,  8.211025150e-01,
   8.175848132e-01,  8.140363297e-01,  8.104571983e-01,  8.068475535e-01,
   8.032075315e-01,  7.995372691e-01,  7.958369046e-01,  7.921065773e-01,
   7.883464276e-01,  7.845565972e-01,  7.807372286e-01,  7.768884657e-01,
   7.730104534e-01,  7.691033376e-01,  7.651672656e-01,  7.612023855e-01,
   7.572088465e-01,  7.531867990e-01,  7.491363945e-01,  7.450577854e-01,
   7.409511254e-01,  7.368165689e-01,  7.326542717e-01,  7.284643904e-01,
   7.242470830e-01,  7.200025080e-01,  7.157308253e-01,  7.114321957e-01,
   7.071067812e-01,  7.027547445e-01,  6.983762494e-01,  6.939714609e-01,
   6.895405447e-01,  6.850836678e-01,  6.806009978e-01,  6.760927036e-01,
   6.715589548e-01,  6.669999223e-01,  6.624157776e-01,  6.578066933e-01,
   6.531728430e-01,  6.485144010e-01,  6.438315429e-01,  6.391244449e-01,
   6.343932842e-01,  6.296382389e-01,  6.248594881e-01,  6.200572118e-01,
   6.152315906e-01,  6.103828063e-01,  6.055110414e-01,  6.006164794e-01,
   5.956993045e-01,  5.907597019e-01,  5.857978575e-01,  5.808139581e-01,
   5.758081914e-01,  5.707807459e-01,  5.657318108e-01,  5.606615762e-01,
   5.555702330e-01,  5.504579729e-01,  5.453249884e-01,  5.401714727e-01,
   5.349976199e-01,  5.298036247e-01,  5.245896827e-01,  5.193559902e-01,
   5.141027442e-01,  5.088301425e-01,  5.035383837e-01,  4.982276670e-01,
   4.928981922e-01,  4.875501601e-01,  4.821837721e-01,  4.767992301e-01,
   4.713967368e-01,  4.659764958e-01,  4.605387110e-01,  4.550835871e-01,
   4.496113297e-01,  4.441221446e-01,  4.386162385e-01,  4.330938189e-01,
   4.275550934e-01,  4.220002708e-01,  4.164295601e-01,  4.108431711e-01,
   4.052413140e-01,  3.996241998e-01,  3.939920401e-01,  3.883450467e-01,
   3.826834324e-01,  3.770074102e-01,  3.713171940e-01,  3.656129978e-01,
   3.598950365e-01,  3.541635254e-01,  3.484186802e-01,  3.426607173e-01,
   3.368898534e-01,  3.311063058e-01,  3.253102922e-01,  3.195020308e-01,
   3.136817404e-01,  3.078496400e-01,  3.020059493e-01,  2.961508882e-01,
   2.902846773e-01,  2.844075372e-01,  2.785196894e-01,  2.726213554e-01,
   2.667127575e-01,  2.607941179e-01,  2.548656596e-01,  2.489276057e-01,
   2.429801799e-01,  2.370236060e-01,  2.310581083e-01,  2.250839114e-01,
   2.191012402e-01,  2.131103199e-01,  2.071113762e-01,  2.011046348e-01,
   1.950903220e-01,  1.890686641e-01,  1.830398880e-01,  1.770042204e-01,
   1.709618888e-01,  1.649131205e-01,  1.588581433e-01,  1.527971853e-01,
   1.467304745e-01,  1.406582393e-01,  1.345807085e-01,  1.284981108e-01,
   1.224106752e-01,  1.163186309e-01,  1.102222073e-01,  1.041216339e-01,
   9.801714033e-02,  9.190895650e-02,  8.579731234e-02,  7.968243797e-02,
   7.356456360e-02,  6.744391956e-02,  6.132073630e-02,  5.519524435e-02,
   4.906767433e-02,  4.293825693e-02,  3.680722294e-02,  3.067480318e-02,
   2.454122852e-02,  1.840672991e-02,  1.227153829e-02,  6.135884649e-03,
   1.224646799e-16, -6.135884649e-03, -1.227153829e-02, -1.840672991e-02,
  -2.454122852e-02, -3.067480318e-02, -3.680722294e-02, -4.293825693e-02,
  -4.906767433e-02, -5.519524435e-02, -6.132073630e-02, -6.744391956e-02,
  -7.356456360e-02, -7.968243797e-02, -8.579731234e-02, -9.190895650e-02,
  -9.801714033e-02, -1.041216339e-01, -1.102222073e-01, -1.163186309e-01,
  -1.224106752e-01, -1.284981108e-01, -1.345807085e-01, -1.406582393e-01,
  -1.467304745e-01, -1.527971853e-01, -1.588581433e-01, -1.649131205e-01,
  -1.709618888e-01, -1.770042204e-01, -1.830398880e-01, -1.890686641e-01,
  -1.950903220e-01, -2.011046348e-01, -2.071113762e-01, -2.131103199e-01,
  -2.191012402e-01, -2.250839114e-01, -2.310581083e-01, -2.370236060e-01,
  -2.429801799e-01, -2.489276057e-01, -2.548656596e-01, -2.607941179e-01,
  -2.667127575e-01, -2.726213554e-01, -2.785196894e-01, -2.844075372e-01,
  -2.902846773e-01, -2.961508882e-01, -3.020059493e-01, -3.078496400e-01,
  -3.136817404e-01, -3.195020308e-01, -3.253102922e-01, -3.311063058e-01,
  -3.368898534e-01, -3.426607173e-01, -3.484186802e-01, -3.541635254e-01,
  -3.598950365e-01, -3.656129978e-01, -3.713171940e-01, -3.770074102e-01,
  -3.826834324e-01, -3.883450467e-01, -3.939920401e-01, -3.996241998e-01,
  -4.052413140e-01, -4.108431711e-01, -4.164295601e-01, -4.220002708e-01,
  -4.275550934e-01, -4.330938189e-01, -4.386162385e-01, -4.441221446e-01,
  -4.496113297e-01, -4.550835871e-01, -4.605387110e-01, -4.659764958e-01,
  -4.713967368e-01, -4.767992301e-01, -4.821837721e-01, -4.875501601e-01,
  -4.928981922e-01, -4.982276670e-01, -5.035383837e-01, -5.088301425e-01,
  -5.141027442e-01, -5.193559902e-01, -5.245896827e-01, -5.298036247e-01,
  -5.349976199e-01, -5.401714727e-01, -5.453249884e-01, -5.504579729e-01,
  -5.555702330e-01, -5.606615762e-01, -5.657318108e-01, -5.707807459e-01,
  -5.758081914e-01, -5.808139581e-01, -5.857978575e-01, -5.907597019e-01,
  -5.956993045e-01, -6.006164794e-01, -6.055110414e-01, -6.103828063e-01,
  -6.152315906e-01, -6.200572118e-01, -6.248594881e-01, -6.296382389e-01,
  -6.343932842e-01, -6.391244449e-01, -6.438315429e-01, -6.485144010e-01,
  -6.531728430e-01, -6.578066933e-01, -6.624157776e-01, -6.669999223e-01,
  -6.715589548e-01, -6.760927036e-01, -6.806009978e-01, -6.850836678e-01,
  -6.895405447e-01, -6.939714609e-01, -6.983762494e-01, -7.027547445e-01,
  -7.071067812e-01, -7.114321957e-01, -7.157308253e-01, -7.200025080e-01,
  -7.242470830e-01, -7.284643904e-01, -7.326542717e-01, -7.368165689e-01,
  -7.409511254e-01, -7.450577854e-01, -7.491363945e-01, -7.531867990e-01,
  -7.572088465e-01, -7.612023855e-01, -7.651672656e-01, -7.691033376e-01,
  -7.730104534e-01, -7.768884657e-01, -7.807372286e-01, -7.845565972e-01,
  -7.883464276e-01, -7.921065773e-01, -7.958369046e-01, -7.995372691e-01,
  -8.032075315e-01, -8.068475535e-01, -8.104571983e-01, -8.140363297e-01,
  -8.175848132e-01, -8.211025150e-01, -8.245893028e-01, -8.280450453e-01,
  -8.314696123e-01, -8.348628750e-01, -8.382247056e-01, -8.415549774e-01,
  -8.448535652e-01, -8.481203448e-01, -8.513551931e-01, -8.545579884e-01,
  -8.577286100e-01, -8.608669386e-01, -8.639728561e-01, -8.670462455e-01,
  -8.700869911e-01, -8.730949784e-01, -8.760700942e-01, -8.790122264e-01,
  -8.819212643e-01, -8.847970984e-01, -8.876396204e-01, -8.904487232e-01,
  -8.932243012e-01, -8.959662498e-01, -8.986744657e-01, -9.013488470e-01,
  -9.039892931e-01, -9.065957045e-01, -9.091679831e-01, -9.117060320e-01,
  -9.142097557e-01, -9.166790599e-01, -9.191138517e-01, -9.215140393e-01,
  -9.238795325e-01, -9.262102421e-01, -9.285060805e-01, -9.307669611e-01,
  -9.329927988e-01, -9.351835099e-01, -9.373390119e-01, -9.394592236e-01,
  -9.415440652e-01, -9.435934582e-01, -9.456073254e-01, -9.475855910e-01,
  -9.495281806e-01, -9.514350210e-01, -9.533060404e-01, -9.551411683e-01,
  -9.569403357e-01, -9.587034749e-01, -9.604305194e-01, -9.621214043e-01,
  -9.637760658e-01, -9.653944417e-01, -9.669764710e-01, -9.685220943e-01,
  -9.700312532e-01, -9.715038910e-01, -9.729399522e-01, -9.743393828e-01,
  -9.757021300e-01, -9.770281427e-01, -9.783173707e-01, -9.795697657e-01,
  -9.807852804e-01, -9.819638691e-01, -9.831054874e-01, -9.842100924e-01,
  -9.852776424e-01, -9.863080972e-01, -9.873014182e-01, -9.882575677e-01,
  -9.891765100e-01, -9.900582103e-01, -9.909026354e-01, -9.917097537e-01,
  -9.924795346e-01, -9.932119492e-01, -9.939069700e-01, -9.945645707e-01,
  -9.951847267e-01, -9.957674145e-01, -9.963126122e-01, -9.968202993e-01,
  -9.972904567e-01, -9.977230666e-01, -9.981181129e-01, -9.984755806e-01,
  -9.987954562e-01, -9.990777278e-01, -9.993223846e-01, -9.995294175e-01,
  -9.996988187e-01, -9.998305818e-01, -9.999247018e-01, -9.999811753e-01,
  -1.000000000e+00, -9.999811753e-01, -9.999247018e-01, -9.998305818e-01,
  -9.996988187e-01, -9.995294175e-01, -9.993223846e-01, -9.990777278e-01,
  -9.987954562e-01, -9.984755806e-01, -9.981181129e-01, -9.977230666e-01,
  -9.972904567e-01, -9.968202993e-01, -9.963126122e-01, -9.957674145e-01,
  -9.951847267e-01, -9.945645707e-01, -9.939069700e-01, -9.932119492e-01,
  -9.924795346e-01, -9.917097537e-01, -9.909026354e-01, -9.900582103e-01,
  -9.891765100e-01, -9.882575677e-01, -9.873014182e-01, -9.863080972e-01,
  -9.852776424e-01, -9.842100924e-01, -9.831054874e-01, -9.819638691e-01,
  -9.807852804e-01, -9.795697657e-01, -9.783173707e-01, -9.770281427e-01,
  -9.757021300e-01, -9.743393828e-01, -9.729399522e-01, -9.715038910e-01,
  -9.700312532e-01, -9.685220943e-01, -9.669764710e-01, -9.653944417e-01,
  -9.637760658e-01, -9.621214043e-01, -9.604305194e-01, -9.587034749e-01,
  -9.569403357e-01, -9.551411683e-01, -9.533060404e-01, -9.514350210e-01,
  -9.495281806e-01, -9.475855910e-01, -9.456073254e-01, -9.435934582e-01,
  -9.415440652e-01, -9.394592236e-01, -9.373390119e-01, -9.351835099e-01,
  -9.329927988e-01, -9.307669611e-01, -9.285060805e-01, -9.262102421e-01,
  -9.238795325e-01, -9.215140393e-01, -9.191138517e-01, -9.166790599e-01,
  -9.142097557e-01, -9.117060320e-01, -9.091679831e-01, -9.065957045e-01,
  -9.039892931e-01, -9.013488470e-01, -8.986744657e-01, -8.959662498e-01,
  -8.932243012e-01, -8.904487232e-01, -8.876396204e-01, -8.847970984e-01,
  -8.819212643e-01, -8.790122264e-01, -8.760700942e-01, -8.730949784e-01,
  -8.700869911e-01, -8.670462455e-01, -8.639728561e-01, -8.608669386e-01,
  -8.577286100e-01, -8.545579884e-01, -8.513551931e-01, -8.481203448e-01,
  -8.448535652e-01, -8.415549774e-01, -8.382247056e-01, -8.348628750e-01,
  -8.314696123e-01, -8.280450453e-01, -8.245893028e-01, -8.211025150e-01,
  -8.175848132e-01, -8.140363297e-01, -8.104571983e-01, -8.068475535e-01,
  -8.032075315e-01, -7.995372691e-01, -7.958369046e-01, -7.921065773e-01,
  -7.883464276e-01, -7.845565972e-01, -7.807372286e-01, -7.768884657e-01,
  -7.730104534e-01, -7.691033376e-01, -7.651672656e-01, -7.612023855e-01,
  -7.572088465e-01, -7.531867990e-01, -7.491363945e-01, -7.450577854e-01,
  -7.409511254e-01, -7.368165689e-01, -7.326542717e-01, -7.284643904e-01,
  -7.242470830e-01, -7.200025080e-01, -7.157308253e-01, -7.114321957e-01,
  -7.071067812e-01, -7.027547445e-01, -6.983762494e-01, -6.939714609e-01,
  -6.895405447e-01, -6.850836678e-01, -6.806009978e-01, -6.760927036e-01,
  -6.715589548e-01, -6.669999223e-01, -6.624157776e-01, -6.578066933e-01,
  -6.531728430e-01, -6.485144010e-01, -6.438315429e-01, -6.391244449e-01,
  -6.343932842e-01, -6.296382389e-01, -6.248594881e-01, -6.200572118e-01,
  -6.152315906e-01, -6.103828063e-01, -6.055110414e-01, -6.006164794e-01,
  -5.956993045e-01, -5.907597019e-01, -5.857978575e-01, -5.808139581e-01,
  -5.758081914e-01, -5.707807459e-01, -5.657318108e-01, -5.606615762e-01,
  -5.555702330e-01, -5.504579729e-01, -5.453249884e-01, -5.401714727e-01,
  -5.349976199e-01, -5.298036247e-01, -5.245896827e-01, -5.193559902e-01,
  -5.141027442e-01, -5.088301425e-01, -5.035383837e-01, -4.982276670e-01,
  -4.928981922e-01, -4.875501601e-01, -4.821837721e-01, -4.767992301e-01,
  -4.713967368e-01, -4.659764958e-01, -4.605387110e-01, -4.550835871e-01,
  -4.496113297e-01, -4.441221446e-01, -4.386162385e-01, -4.330938189e-01,
  -4.275550934e-01, -4.220002708e-01, -4.164295601e-01, -4.108431711e-01,
  -4.052413140e-01, -3.996241998e-01, -3.939920401e-01, -3.883450467e-01,
  -3.826834324e-01, -3.770074102e-01, -3.713171940e-01, -3.656129978e-01,
  -3.598950365e-01, -3.541635254e-01, -3.484186802e-01, -3.426607173e-01,
  -3.368898534e-01, -3.311063058e-01, -3.253102922e-01, -3.195020308e-01,
  -3.136817404e-01, -3.078496400e-01, -3.020059493e-01, -2.961508882e-01,
  -2.902846773e-01, -2.844075372e-01, -2.785196894e-01, -2.726213554e-01,
  -2.667127575e-01, -2.607941179e-01, -2.548656596e-01, -2.489276057e-01,
  -2.429801799e-01, -2.370236060e-01, -2.310581083e-01, -2.250839114e-01,
  -2.191012402e-01, -2.131103199e-01, -2.071113762e-01, -2.011046348e-01,
  -1.950903220e-01, -1.890686641e-01, -1.830398880e-01, -1.770042204e-01,
  -1.709618888e-01, -1.649131205e-01, -1.588581433e-01, -1.527971853e-01,
  -1.467304745e-01, -1.406582393e-01, -1.345807085e-01, -1.284981108e-01,
  -1.224106752e-01, -1.163186309e-01, -1.102222073e-01, -1.041216339e-01,
  -9.801714033e-02, -9.190895650e-02, -8.579731234e-02, -7.968243797e-02,
  -7.356456360e-02, -6.744391956e-02, -6.132073630e-02, -5.519524435e-02,
  -4.906767433e-02, -4.293825693e-02, -3.680722294e-02, -3.067480318e-02,
  -2.454122852e-02, -1.840672991e-02, -1.227153829e-02, -6.135884649e-03,
  -2.449293598e-16,  6.135884649e-03,  1.227153829e-02,  1.840672991e-02,
   2.454122852e-02,  3.067480318e-02,  3.680722294e-02,  4.293825693e-02,
   4.906767433e-02,  5.519524435e-02,  6.132073630e-02,  6.744391956e-02,
   7.356456360e-02,  7.968243797e-02,  8.579731234e-02,  9.190895650e-02,
   9.801714033e-02,  1.041216339e-01,  1.102222073e-01,  1.163186309e-01,
   1.224106752e-01,  1.284981108e-01,  1.345807085e-01,  1.406582393e-01,
   1.467304745e-01,  1.527971853e-01,  1.588581433e-01,  1.649131205e-01,
   1.709618888e-01,  1.770042204e-01,  1.830398880e-01,  1.890686641e-01,
   1.950903220e-01,  2.011046348e-01,  2.071113762e-01,  2.131103199e-01,
   2.191012402e-01,  2.250839114e-01,  2.310581083e-01,  2.370236060e-01,
   2.429801799e-01,  2.489276057e-01,  2.548656596e-01,  2.607941179e-01,
   2.667127575e-01,  2.726213554e-01,  2.785196894e-01,  2.844075372e-01,
   2.902846773e-01,  2.961508882e-01,  3.020059493e-01,  3.078496400e-01,
   3.136817404e-01,  3.195020308e-01,  3.253102922e-01,  3.311063058e-01,
   3.368898534e-01,  3.426607173e-01,  3.484186802e-01,  3.541635254e-01,
   3.598950365e-01,  3.656129978e-01,  3.713171940e-01,  3.770074102e-01,
   3.826834324e-01,  3.883450467e-01,  3.939920401e-01,  3.996241998e-01,
   4.052413140e-01,  4.108431711e-01,  4.164295601e-01,  4.220002708e-01,
   4.275550934e-01,  4.330938189e-01,  4.386162385e-01,  4.441221446e-01,
   4.496113297e-01,  4.550835871e-01,  4.605387110e-01,  4.659764958e-01,
   4.713967368e-01,  4.767992301e-01,  4.821837721e-01,  4.875501601e-01,
   4.928981922e-01,  4.982276670e-01,  5.035383837e-01,  5.088301425e-01,
   5.141027442e-01,  5.193559902e-01,  5.245896827e-01,  5.298036247e-01,
   5.349976199e-01,  5.401714727e-01,  5.453249884e-01,  5.504579729e-01,
   5.555702330e-01,  5.606615762e-01,  5.657318108e-01,  5.707807459e-01,
   5.758081914e-01,  5.808139581e-01,  5.857978575e-01,  5.907597019e-01,
   5.956993045e-01,  6.006164794e-01,  6.055110414e-01,  6.103828063e-01,
   6.152315906e-01,  6.200572118e-01,  6.248594881e-01,  6.296382389e-01,
   6.343932842e-01,  6.391244449e-01,  6.438315429e-01,  6.485144010e-01,
   6.531728430e-01,  6.578066933e-01,  6.624157776e-01,  6.669999223e-01,
   6.715589548e-01,  6.760927036e-01,  6.806009978e-01,  6.850836678e-01,
   6.895405447e-01,  6.939714609e-01,  6.983762494e-01,  7.027547445e-01,
   7.071067812e-01,  7.114321957e-01,  7.157308253e-01,  7.200025080e-01,
   7.242470830e-01,  7.284643904e-01,  7.326542717e-01,  7.368165689e-01,
   7.409511254e-01,  7.450577854e-01,  7.491363945e-01,  7.531867990e-01,
   7.572088465e-01,  7.612023855e-01,  7.651672656e-01,  7.691033376e-01,
   7.730104534e-01,  7.768884657e-01,  7.807372286e-01,  7.845565972e-01,
   7.883464276e-01,  7.921065773e-01,  7.958369046e-01,  7.995372691e-01,
   8.032075315e-01,  8.068475535e-01,  8.104571983e-01,  8.140363297e-01,
   8.175848132e-01,  8.211025150e-01,  8.245893028e-01,  8.280450453e-01,
   8.314696123e-01,  8.348628750e-01,  8.382247056e-01,  8.415549774e-01,
   8.448535652e-01,  8.481203448e-01,  8.513551931e-01,  8.545579884e-01,
   8.577286100e-01,  8.608669386e-01,  8.639728561e-01,  8.670462455e-01,
   8.700869911e-01,  8.730949784e-01,  8.760700942e-01,  8.790122264e-01,
   8.819212643e-01,  8.847970984e-01,  8.876396204e-01,  8.904487232e-01,
   8.932243012e-01,  8.959662498e-01,  8.986744657e-01,  9.013488470e-01,
   9.039892931e-01,  9.065957045e-01,  9.091679831e-01,  9.117060320e-01,
   9.142097557e-01,  9.166790599e-01,  9.191138517e-01,  9.215140393e-01,
   9.238795325e-01,  9.262102421e-01,  9.285060805e-01,  9.307669611e-01,
   9.329927988e-01,  9.351835099e-01,  9.373390119e-01,  9.394592236e-01,
   9.415440652e-01,  9.435934582e-01,  9.456073254e-01,  9.475855910e-01,
   9.495281806e-01,  9.514350210e-01,  9.533060404e-01,  9.551411683e-01,
   9.569403357e-01,  9.587034749e-01,  9.604305194e-01,  9.621214043e-01,
   9.637760658e-01,  9.653944417e-01,  9.669764710e-01,  9.685220943e-01,
   9.700312532e-01,  9.715038910e-01,  9.729399522e-01,  9.743393828e-01,
   9.757021300e-01,  9.770281427e-01,  9.783173707e-01,  9.795697657e-01,
   9.807852804e-01,  9.819638691e-01,  9.831054874e-01,  9.842100924e-01,
   9.852776424e-01,  9.863080972e-01,  9.873014182e-01,  9.882575677e-01,
   9.891765100e-01,  9.900582103e-01,  9.909026354e-01,  9.917097537e-01,
   9.924795346e-01,  9.932119492e-01,  9.939069700e-01,  9.945645707e-01,
   9.951847267e-01,  9.957674145e-01,  9.963126122e-01,  9.968202993e-01,
   9.972904567e-01,  9.977230666e-01,  9.981181129e-01,  9.984755806e-01,
   9.987954562e-01,  9.990777278e-01,  9.993223846e-01,  9.995294175e-01,
   9.996988187e-01,  9.998305818e-01,  9.999247018e-01,  9.999811753e-01,
   1.000000000e+00,
};
const float lut_window[] = {
   0.000000000e+00,  1.470685589e-07,  5.882741491e-07,  1.323616511e-06,
   2.353095212e-06,  3.676709646e-06,  5.294459036e-06,  7.206342428e-06,
   9.412358699e-06,  1.191250655e-05,  1.470678451e-05,  1.779519094e-05,
   2.117772402e-05,  2.485438175e-05,  2.882516199e-05,  3.309006238e-05,
   3.764908043e-05,  4.250221344e-05,  4.764945857e-05,  5.309081279e-05,
   5.882627289e-05,  6.485583551e-05,  7.117949709e-05,  7.779725391e-05,
   8.470910209e-05,  9.191503755e-05,  9.941505606e-05,  1.072091532e-04,
   1.152973244e-04,  1.236795649e-04,  1.323558697e-04,  1.413262338e-04,
   1.505906519e-04,  1.601491185e-04,  1.700016280e-04,  1.801481746e-04,
   1.905887524e-04,  2.013233552e-04,  2.123519766e-04,  2.236746103e-04,
   2.352912495e-04,  2.472018873e-04,  2.594065169e-04,  2.719051310e-04,
   2.846977223e-04,  2.977842832e-04,  3.111648060e-04,  3.248392829e-04,
   3.388077058e-04,  3.530700666e-04,  3.676263567e-04,  3.824765677e-04,
   3.976206908e-04,  4.130587171e-04,  4.287906376e-04,  4.448164429e-04,
   4.611361237e-04,  4.777496703e-04,  4.946570730e-04,  5.118583218e-04,
   5.293534066e-04,  5.471423171e-04,  5.652250429e-04,  5.836015732e-04,
   6.022718974e-04,  6.212360044e-04,  6.404938831e-04,  6.600455221e-04,
   6.798909099e-04,  7.000300348e-04,  7.204628851e-04,  7.411894487e-04,
   7.622097134e-04,  7.835236667e-04,  8.051312963e-04,  8.270325894e-04,
   8.492275331e-04,  8.717161143e-04,  8.944983198e-04,  9.175741362e-04,
   9.409435499e-04,  9.646065473e-04,  9.885631143e-04,  1.012813237e-03,
   1.037356901e-03,  1.062194091e-03,  1.087324794e-03,  1.112748995e-03,
   1.138466678e-03,  1.164477828e-03,  1.190782431e-03,  1.217380470e-03,
   1.244271930e-03,  1.271456795e-03,  1.298935049e-03,  1.326706677e-03,
   1.354771661e-03,  1.383129985e-03,  1.411781632e-03,  1.440726587e-03,
   1.469964830e-03,  1.499496346e-03,  1.529321118e-03,  1.559439126e-03,
   1.589850354e-03,  1.620554785e-03,  1.651552399e-03,  1.682843178e-03,
   1.714427105e-03,  1.746304160e-03,  1.778474325e-03,  1.810937581e-03,
   1.843693909e-03,  1.876743289e-03,  1.910085702e-03,  1.943721129e-03,
   1.977649549e-03,  2.011870944e-03,  2.046385291e-03,  2.081192572e-03,
   2.116292766e-03,  2.151685852e-03,  2.187371810e-03,  2.223350617e-03,
   2.259622254e-03,  2.296186699e-03,  2.333043930e-03,  2.370193925e-03,
   2.407636664e-03,  2.445372123e-03,  2.483400281e-03,  2.521721115e-03,
   2.560334603e-03,  2.599240721e-03,  2.638439448e-03,  2.677930759e-03,
   2.717714633e-03,  2.757791045e-03,  2.798159971e-03,  2.838821389e-03,
   2.879775273e-03,  2.921021601e-03,  2.962560348e-03,  3.004391488e-03,
   3.046514999e-03,  3.088930854e-03,  3.131639030e-03,  3.174639500e-03,
   3.217932240e-03,  3.261517224e-03,  3.305394426e-03,  3.349563821e-03,
   3.394025383e-03,  3.438779085e-03,  3.483824901e-03,  3.529162805e-03,
   3.574792770e-03,  3.620714769e-03,  3.666928776e-03,  3.713434762e-03,
   3.760232701e-03,  3.807322565e-03,  3.854704326e-03,  3.902377957e-03,
   3.950343429e-03,  3.998600714e-03,  4.047149785e-03,  4.095990611e-03,
   4.145123165e-03,  4.194547418e-03,  4.244263341e-03,  4.294270903e-03,
   4.344570077e-03,  4.395160832e-03,  4.446043138e-03,  4.497216966e-03,
   4.548682286e-03,  4.600439067e-03,  4.652487279e-03,  4.704826891e-03,
   4.757457872e-03,  4.810380191e-03,  4.863593818e-03,  4.917098721e-03,
   4.970894869e-03,  5.024982229e-03,  5.079360771e-03,  5.134030461e-03,
   5.188991268e-03,  5.244243160e-03,  5.299786104e-03,  5.355620068e-03,
   5.411745018e-03,  5.468160921e-03,  5.524867745e-03,  5.581865456e-03,
   5.639154020e-03,  5.696733404e-03,  5.754603574e-03,  5.812764495e-03,
   5.871216135e-03,  5.929958457e-03,  5.988991428e-03,  6.048315014e-03,
   6.107929178e-03,  6.167833886e-03,  6.228029103e-03,  6.288514793e-03,
   6.349290921e-03,  6.410357451e-03,  6.471714347e-03,  6.533361573e-03,
   6.595299093e-03,  6.657526870e-03,  6.720044868e-03,  6.782853049e-03,
   6.845951378e-03,  6.909339816e-03,  6.973018327e-03,  7.036986873e-03,
   7.101245416e-03,  7.165793919e-03,  7.230632344e-03,  7.295760652e-03,
   7.361178806e-03,  7.426886766e-03,  7.492884494e-03,  7.559171951e-03,
   7.625749099e-03,  7.692615898e-03,  7.759772308e-03,  7.827218291e-03,
   7.894953807e-03,  7.962978815e-03,  8.031293275e-03,  8.099897149e-03,
   8.168790394e-03,  8.237972971e-03,  8.307444839e-03,  8.377205957e-03,
   8.447256284e-03,  8.517595779e-03,  8.588224401e-03,  8.659142107e-03,
   8.730348856e-03,  8.801844607e-03,  8.873629317e-03,  8.945702944e-03,
   9.018065445e-03,  9.090716779e-03,  9.163656902e-03,  9.236885771e-03,
   9.310403343e-03,  9.384209576e-03,  9.458304425e-03,  9.532687847e-03,
   9.607359798e-03,  9.682320235e-03,  9.757569113e-03,  9.833106388e-03,
   9.908932016e-03,  9.985045952e-03,  1.006144815e-02,  1.013813857e-02,
   1.021511716e-02,  1.029238388e-02,  1.036993868e-02,  1.044778151e-02,
   1.052591234e-02,  1.060433111e-02,  1.068303779e-02,  1.076203231e-02,
   1.084131464e-02,  1.092088473e-02,  1.100074253e-02,  1.108088800e-02,
   1.116132109e-02,  1.124204175e-02,  1.132304993e-02,  1.140434559e-02,
   1.148592867e-02,  1.156779914e-02,  1.164995694e-02,  1.173240202e-02,
   1.181513433e-02,  1.189815384e-02,  1.198146048e-02,  1.206505421e-02,
   1.214893498e-02,  1.223310274e-02,  1.231755744e-02,  1.240229903e-02,
   1.248732747e-02,  1.257264269e-02,  1.265824466e-02,  1.274413331e-02,
   1.283030861e-02,  1.291677049e-02,  1.300351892e-02,  1.309055383e-02,
   1.317787517e-02,  1.326548291e-02,  1.335337697e-02,  1.344155732e-02,
   1.353002390e-02,  1.361877665e-02,  1.370781553e-02,  1.379714049e-02,
   1.388675146e-02,  1.397664840e-02,  1.406683126e-02,  1.415729998e-02,
   1.424805451e-02,  1.433909479e-02,  1.443042078e-02,  1.452203241e-02,
   1.461392964e-02,  1.470611240e-02,  1.479858066e-02,  1.489133434e-02,
   1.498437340e-02,  1.507769779e-02,  1.517130744e-02,  1.526520230e-02,
   1.535938232e-02,  1.545384744e-02,  1.554859761e-02,  1.564363277e-02,
   1.573895286e-02,  1.583455783e-02,  1.593044763e-02,  1.602662219e-02,
   1.612308145e-02,  1.621982537e-02,  1.631685389e-02,  1.641416694e-02,
   1.651176448e-02,  1.660964644e-02,  1.670781276e-02,  1.680626339e-02,
   1.690499828e-02,  1.700401735e-02,  1.710332056e-02,  1.720290785e-02,
   1.730277915e-02,  1.740293441e-02,  1.750337357e-02,  1.760409657e-02,
   1.770510336e-02,  1.780639386e-02,  1.790796802e-02,  1.800982579e-02,
   1.811196710e-02,  1.821439189e-02,  1.831710011e-02,  1.842009169e-02,
   1.852336656e-02,  1.862692468e-02,  1.873076598e-02,  1.883489039e-02,
   1.893929787e-02,  1.904398833e-02,  1.914896174e-02,  1.925421801e-02,
   1.935975709e-02,  1.946557893e-02,  1.957168345e-02,  1.967807059e-02,
   1.978474029e-02,  1.989169249e-02,  1.999892713e-02,  2.010644414e-02,
   2.021424346e-02,  2.032232502e-02,  2.043068877e-02,  2.053933463e-02,
   2.064826255e-02,  2.075747246e-02,  2.086696430e-02,  2.097673799e-02,
   2.108679349e-02,  2.119713071e-02,  2.130774961e-02,  2.141865010e-02,
   2.152983213e-02,  2.164129564e-02,  2.175304055e-02,  2.186506680e-02,
   2.197737433e-02,  2.208996306e-02,  2.220283293e-02,  2.231598389e-02,
   2.242941585e-02,  2.254312875e-02,  2.265712253e-02,  2.277139712e-02,
   2.288595245e-02,  2.300078845e-02,  2.311590506e-02,  2.323130220e-02,
   2.334697982e-02,  2.346293784e-02,  2.357917620e-02,  2.369569482e-02,
   2.381249364e-02,  2.392957259e-02,  2.404693160e-02,  2.416457059e-02,
   2.428248952e-02,  2.440068829e-02,  2.451916684e-02,  2.463792511e-02,
   2.475696303e-02,  2.487628051e-02,  2.499587750e-02,  2.511575392e-02,
   2.523590970e-02,  2.535634478e-02,  2.547705907e-02,  2.559805252e-02,
   2.571932504e-02,  2.584087657e-02,  2.596270704e-02,  2.608481637e-02,
   2.620720449e-02,  2.632987133e-02,  2.645281682e-02,  2.657604089e-02,
   2.669954346e-02,  2.682332446e-02,  2.694738381e-02,  2.707172146e-02,
   2.719633731e-02,  2.732123130e-02,  2.744640336e-02,  2.757185340e-02,
   2.769758137e-02,  2.782358718e-02,  2.794987075e-02,  2.807643203e-02,
   2.820327092e-02,  2.833038736e-02,  2.845778127e-02,  2.858545257e-02,
   2.871340120e-02,  2.884162707e-02,  2.897013011e-02,  2.909891025e-02,
   2.922796741e-02,  2.935730151e-02,  2.948691247e-02,  2.961680023e-02,
   2.974696470e-02,  2.987740581e-02,  3.000812348e-02,  3.013911764e-02,
   3.027038820e-02,  3.040193509e-02,  3.053375823e-02,  3.066585755e-02,
   3.079823297e-02,  3.093088440e-02,  3.106381178e-02,  3.119701502e-02,
   3.133049404e-02,  3.146424877e-02,  3.159827913e-02,  3.173258504e-02,
   3.186716641e-02,  3.200202318e-02,  3.213715526e-02,  3.227256257e-02,
   3.240824503e-02,  3.254420256e-02,  3.268043509e-02,  3.281694253e-02,
   3.295372480e-02,  3.309078182e-02,  3.322811351e-02,  3.336571979e-02,
   3.350360058e-02,  3.364175580e-02,  3.378018537e-02,  3.391888920e-02,
   3.405786721e-02,  3.419711932e-02,  3.433664546e-02,  3.447644553e-02,
   3.461651946e-02,  3.475686716e-02,  3.489748855e-02,  3.503838355e-02,
   3.517955208e-02,  3.532099405e-02,  3.546270937e-02,  3.560469797e-02,
   3.574695976e-02,  3.588949466e-02,  3.603230259e-02,  3.617538345e-02,
   3.631873717e-02,  3.646236367e-02,  3.660626285e-02,  3.675043463e-02,
   3.689487893e-02,  3.703959566e-02,  3.718458475e-02,  3.732984609e-02,
   3.747537961e-02,  3.762118522e-02,  3.776726284e-02,  3.791361237e-02,
   3.806023374e-02,  3.820712686e-02,  3.835429164e-02,  3.850172799e-02,
   3.864943583e-02,  3.879741507e-02,  3.894566563e-02,  3.909418741e-02,
   3.924298033e-02,  3.939204430e-02,  3.954137924e-02,  3.969098505e-02,
   3.984086165e-02,  3.999100894e-02,  4.014142685e-02,  4.029211529e-02,
   4.044307415e-02,  4.059430337e-02,  4.074580284e-02,  4.089757247e-02,
   4.104961219e-02,  4.120192189e-02,  4.135450150e-02,  4.150735091e-02,
   4.166047004e-02,  4.181385880e-02,  4.196751710e-02,  4.212144485e-02,
   4.227564196e-02,  4.243010833e-02,  4.258484388e-02,  4.273984852e-02,
   4.289512215e-02,  4.305066468e-02,  4.320647603e-02,  4.336255609e-02,
   4.351890479e-02,  4.367552202e-02,  4.383240769e-02,  4.398956171e-02,
   4.414698400e-02,  4.430467445e-02,  4.446263297e-02,  4.462085948e-02,
   4.477935387e-02,  4.493811606e-02,  4.509714595e-02,  4.525644344e-02,
   4.541600845e-02,  4.557584089e-02,  4.573594064e-02,  4.589630763e-02,
   4.605694176e-02,  4.621784293e-02,  4.637901104e-02,  4.654044601e-02,
   4.670214774e-02,  4.686411614e-02,  4.702635110e-02,  4.718885253e-02,
   4.735162034e-02,  4.751465443e-02,  4.767795471e-02,  4.784152108e-02,
   4.800535344e-02,  4.816945170e-02,  4.833381575e-02,  4.849844551e-02,
   4.866334088e-02,  4.882850176e-02,  4.899392805e-02,  4.915961965e-02,
   4.932557648e-02,  4.949179842e-02,  4.965828539e-02,  4.982503728e-02,
   4.999205399e-02,  5.015933544e-02,  5.032688151e-02,  5.049469212e-02,
   5.066276715e-02,  5.083110652e-02,  5.099971013e-02,  5.116857787e-02,
   5.133770965e-02,  5.150710536e-02,  5.167676491e-02,  5.184668820e-02,
   5.201687512e-02,  5.218732558e-02,  5.235803948e-02,  5.252901671e-02,
   5.270025718e-02,  5.287176079e-02,  5.304352743e-02,  5.321555700e-02,
   5.338784940e-02,  5.356040454e-02,  5.373322230e-02,  5.390630259e-02,
   5.407964530e-02,  5.425325034e-02,  5.442711760e-02,  5.460124698e-02,
   5.477563838e-02,  5.495029169e-02,  5.512520681e-02,  5.530038364e-02,
   5.547582207e-02,  5.565152201e-02,  5.582748335e-02,  5.600370598e-02,
   5.618018980e-02,  5.635693471e-02,  5.653394060e-02,  5.671120738e-02,
   5.688873493e-02,  5.706652315e-02,  5.724457193e-02,  5.742288118e-02,
   5.760145078e-02,  5.778028064e-02,  5.795937064e-02,  5.813872069e-02,
   5.831833067e-02,  5.849820048e-02,  5.867833001e-02,  5.885871916e-02,
   5.903936783e-02,  5.922027590e-02,  5.940144326e-02,  5.958286983e-02,
   5.976455547e-02,  5.994650010e-02,  6.012870360e-02,  6.031116586e-02,
   6.049388679e-02,  6.067686626e-02,  6.086010417e-02,  6.104360042e-02,
   6.122735490e-02,  6.141136749e-02,  6.159563810e-02,  6.178016660e-02,
   6.196495290e-02,  6.214999689e-02,  6.233529845e-02,  6.252085748e-02,
   6.270667386e-02,  6.289274749e-02,  6.307907827e-02,  6.326566607e-02,
   6.345251079e-02,  6.363961232e-02,  6.382697055e-02,  6.401458537e-02,
   6.420245667e-02,  6.439058434e-02,  6.457896826e-02,  6.476760834e-02,
   6.495650445e-02,  6.514565648e-02,  6.533506433e-02,  6.552472787e-02,
   6.571464701e-02,  6.590482163e-02,  6.609525162e-02,  6.628593686e-02,
   6.647687724e-02,  6.666807266e-02,  6.685952299e-02,  6.705122812e-02,
   6.724318795e-02,  6.743540236e-02,  6.762787124e-02,  6.782059447e-02,
   6.801357194e-02,  6.820680354e-02,  6.840028914e-02,  6.859402865e-02,
   6.878802194e-02,  6.898226891e-02,  6.917676943e-02,  6.937152339e-02,
   6.956653068e-02,  6.976179118e-02,  6.995730479e-02,  7.015307137e-02,
   7.034909082e-02,  7.054536303e-02,  7.074188787e-02,  7.093866523e-02,
   7.113569500e-02,  7.133297706e-02,  7.153051129e-02,  7.172829758e-02,
   7.192633581e-02,  7.212462587e-02,  7.232316763e-02,  7.252196099e-02,
   7.272100582e-02,  7.292030200e-02,  7.311984943e-02,  7.331964798e-02,
   7.351969753e-02,  7.371999798e-02,  7.392054919e-02,  7.412135105e-02,
   7.432240345e-02,  7.452370626e-02,  7.472525937e-02,  7.492706265e-02,
   7.512911600e-02,  7.533141929e-02,  7.553397239e-02,  7.573677520e-02,
   7.593982760e-02,  7.614312946e-02,  7.634668066e-02,  7.655048108e-02,
   7.675453061e-02,  7.695882913e-02,  7.716337651e-02,  7.736817263e-02,
   7.757321738e-02,  7.777851062e-02,  7.798405225e-02,  7.818984215e-02,
   7.839588018e-02,  7.860216623e-02,  7.880870018e-02,  7.901548190e-02,
   7.922251128e-02,  7.942978819e-02,  7.963731251e-02,  7.984508413e-02,
   8.005310290e-02,  8.026136872e-02,  8.046988146e-02,  8.067864101e-02,
   8.088764722e-02,  8.109689999e-02,  8.130639919e-02,  8.151614470e-02,
   8.172613639e-02,  8.193637414e-02,  8.214685782e-02,  8.235758732e-02,
   8.256856251e-02,  8.277978326e-02,  8.299124945e-02,  8.320296095e-02,
   8.341491765e-02,  8.362711941e-02,  8.383956612e-02,  8.405225764e-02,
   8.426519385e-02,  8.447837463e-02,  8.469179985e-02,  8.490546938e-02,
   8.511938310e-02,  8.533354089e-02,  8.554794261e-02,  8.576258815e-02,
   8.597747737e-02,  8.619261015e-02,  8.640798636e-02,  8.662360588e-02,
   8.683946858e-02,  8.705557433e-02,  8.727192300e-02,  8.748851447e-02,
   8.770534861e-02,  8.792242529e-02,  8.813974439e-02,  8.835730577e-02,
   8.857510931e-02,  8.879315489e-02,  8.901144236e-02,  8.922997161e-02,
   8.944874250e-02,  8.966775492e-02,  8.988700872e-02,  9.010650377e-02,
   9.032623996e-02,  9.054621715e-02,  9.076643521e-02,  9.098689401e-02,
   9.120759342e-02,  9.142853332e-02,  9.164971357e-02,  9.187113404e-02,
   9.209279460e-02,  9.231469512e-02,  9.253683547e-02,  9.275921552e-02,
   9.298183515e-02,  9.320469421e-02,  9.342779258e-02,  9.365113012e-02,
   9.387470671e-02,  9.409852221e-02,  9.432257649e-02,  9.454686942e-02,
   9.477140087e-02,  9.499617071e-02,  9.522117880e-02,  9.544642501e-02,
   9.567190921e-02,  9.589763126e-02,  9.612359104e-02,  9.634978840e-02,
   9.657622323e-02,  9.680289538e-02,  9.702980471e-02,  9.725695111e-02,
   9.748433443e-02,  9.771195454e-02,  9.793981130e-02,  9.816790459e-02,
   9.839623426e-02,  9.862480019e-02,  9.885360223e-02,  9.908264026e-02,
   9.931191414e-02,  9.954142373e-02,  9.977116890e-02,  1.000011495e-01,
   1.002313654e-01,  1.004618165e-01,  1.006925027e-01,  1.009234237e-01,
   1.011545795e-01,  1.013859700e-01,  1.016175949e-01,  1.018494542e-01,
   1.020815477e-01,  1.023138753e-01,  1.025464368e-01,  1.027792322e-01,
   1.030122612e-01,  1.032455238e-01,  1.034790198e-01,  1.037127490e-01,
   1.039467113e-01,  1.041809067e-01,  1.044153349e-01,  1.046499958e-01,
   1.048848893e-01,  1.051200152e-01,  1.053553734e-01,  1.055909638e-01,
   1.058267862e-01,  1.060628405e-01,  1.062991265e-01,  1.065356441e-01,
   1.067723932e-01,  1.070093736e-01,  1.072465852e-01,  1.074840279e-01,
   1.077217014e-01,  1.079596057e-01,  1.081977407e-01,  1.084361061e-01,
   1.086747019e-01,  1.089135279e-01,  1.091525840e-01,  1.093918699e-01,
   1.096313857e-01,  1.098711311e-01,  1.101111060e-01,  1.103513103e-01,
   1.105917438e-01,  1.108324064e-01,  1.110732979e-01,  1.113144182e-01,
   1.115557672e-01,  1.117973446e-01,  1.120391505e-01,  1.122811845e-01,
   1.125234467e-01,  1.127659368e-01,  1.130086547e-01,  1.132516003e-01,
   1.134947733e-01,  1.137381738e-01,  1.139818014e-01,  1.142256562e-01,
   1.144697379e-01,  1.147140464e-01,  1.149585815e-01,  1.152033432e-01,
   1.154483312e-01,  1.156935454e-01,  1.159389857e-01,  1.161846520e-01,
   1.164305440e-01,  1.166766617e-01,  1.169230049e-01,  1.171695734e-01,
   1.174163672e-01,  1.176633860e-01,  1.179106297e-01,  1.181580982e-01,
   1.184057914e-01,  1.186537090e-01,  1.189018509e-01,  1.191502171e-01,
   1.193988073e-01,  1.196476213e-01,  1.198966592e-01,  1.201459206e-01,
   1.203954055e-01,  1.206451137e-01,  1.208950451e-01,  1.211451995e-01,
   1.213955767e-01,  1.216461767e-01,  1.218969993e-01,  1.221480443e-01,
   1.223993116e-01,  1.226508010e-01,  1.229025123e-01,  1.231544456e-01,
   1.234066005e-01,  1.236589769e-01,  1.239115748e-01,  1.241643939e-01,
   1.244174340e-01,  1.246706952e-01,  1.249241771e-01,  1.251778797e-01,
   1.254318027e-01,  1.256859462e-01,  1.259403098e-01,  1.261948934e-01,
   1.264496970e-01,  1.267047203e-01,  1.269599632e-01,  1.272154256e-01,
   1.274711073e-01,  1.277270081e-01,  1.279831279e-01,  1.282394666e-01,
   1.284960239e-01,  1.287527998e-01,  1.290097941e-01,  1.292670067e-01,
   1.295244373e-01,  1.297820859e-01,  1.300399523e-01,  1.302980363e-01,
   1.305563378e-01,  1.308148566e-01,  1.310735926e-01,  1.313325456e-01,
   1.315917156e-01,  1.318511022e-01,  1.321107054e-01,  1.323705251e-01,
   1.326305610e-01,  1.328908130e-01,  1.331512809e-01,  1.334119647e-01,
   1.336728642e-01,  1.339339791e-01,  1.341953094e-01,  1.344568549e-01,
   1.347186154e-01,  1.349805908e-01,  1.352427809e-01,  1.355051856e-01,
   1.357678048e-01,  1.360306382e-01,  1.362936857e-01,  1.365569472e-01,
   1.368204225e-01,  1.370841114e-01,  1.373480138e-01,  1.376121296e-01,
   1.378764585e-01,  1.381410005e-01,  1.384057553e-01,  1.386707229e-01,
   1.389359030e-01,  1.392012956e-01,  1.394669003e-01,  1.397327172e-01,
   1.399987460e-01,  1.402649866e-01,  1.405314388e-01,  1.407981025e-01,
   1.410649775e-01,  1.413320636e-01,  1.415993607e-01,  1.418668687e-01,
   1.421345874e-01,  1.424025165e-01,  1.426706561e-01,  1.429390058e-01,
   1.432075656e-01,  1.434763353e-01,  1.437453147e-01,  1.440145037e-01,
   1.442839021e-01,  1.445535098e-01,  1.448233266e-01,  1.450933523e-01,
   1.453635868e-01,  1.456340299e-01,  1.459046815e-01,  1.461755414e-01,
   1.464466094e-01,  1.467178854e-01,  1.469893693e-01,  1.472610608e-01,
   1.475329598e-01,  1.478050662e-01,  1.480773797e-01,  1.483499003e-01,
   1.486226278e-01,  1.488955619e-01,  1.491687026e-01,  1.494420497e-01,
   1.497156030e-01,  1.499893624e-01,  1.502633277e-01,  1.505374987e-01,
   1.508118753e-01,  1.510864573e-01,  1.513612446e-01,  1.516362370e-01,
   1.519114343e-01,  1.521868363e-01,  1.524624430e-01,  1.527382541e-01,
   1.530142696e-01,  1.532904891e-01,  1.535669126e-01,  1.538435399e-01,
   1.541203708e-01,  1.543974052e-01,  1.546746429e-01,  1.549520838e-01,
   1.552297276e-01,  1.555075743e-01,  1.557856236e-01,  1.560638754e-01,
   1.563423296e-01,  1.566209859e-01,  1.568998442e-01,  1.571789043e-01,
   1.574581661e-01,  1.577376294e-01,  1.580172941e-01,  1.582971599e-01,
   1.585772268e-01,  1.588574945e-01,  1.591379629e-01,  1.594186318e-01,
   1.596995011e-01,  1.599805706e-01,  1.602618401e-01,  1.605433094e-01,
   1.608249784e-01,  1.611068470e-01,  1.613889149e-01,  1.616711821e-01,
   1.619536482e-01,  1.622363132e-01,  1.625191769e-01,  1.628022392e-01,
   1.630854998e-01,  1.633689586e-01,  1.636526155e-01,  1.639364702e-01,
   1.642205226e-01,  1.645047725e-01,  1.647892198e-01,  1.650738643e-01,
   1.653587058e-01,  1.656437442e-01,  1.659289793e-01,  1.662144109e-01,
   1.665000388e-01,  1.667858630e-01,  1.670718832e-01,  1.673580992e-01,
   1.676445109e-01,  1.679311181e-01,  1.682179207e-01,  1.685049184e-01,
   1.687921112e-01,  1.690794988e-01,  1.693670811e-01,  1.696548579e-01,
   1.699428290e-01,  1.702309942e-01,  1.705193535e-01,  1.708079066e-01,
   1.710966534e-01,  1.713855936e-01,  1.716747271e-01,  1.719640538e-01,
   1.722535735e-01,  1.725432860e-01,  1.728331911e-01,  1.731232887e-01,
   1.734135785e-01,  1.737040605e-01,  1.739947345e-01,  1.742856002e-01,
   1.745766575e-01,  1.748679063e-01,  1.751593463e-01,  1.754509774e-01,
   1.757427995e-01,  1.760348123e-01,  1.763270157e-01,  1.766194095e-01,
   1.769119935e-01,  1.772047676e-01,  1.774977316e-01,  1.777908853e-01,
   1.780842286e-01,  1.783777612e-01,  1.786714830e-01,  1.789653939e-01,
   1.792594936e-01,  1.795537820e-01,  1.798482589e-01,  1.801429242e-01,
   1.804377776e-01,  1.807328190e-01,  1.810280482e-01,  1.813234651e-01,
   1.816190694e-01,  1.819148610e-01,  1.822108398e-01,  1.825070055e-01,
   1.828033579e-01,  1.830998970e-01,  1.833966225e-01,  1.836935342e-01,
   1.839906320e-01,  1.842879157e-01,  1.845853852e-01,  1.848830402e-01,
   1.851808805e-01,  1.854789061e-01,  1.857771167e-01,  1.860755121e-01,
   1.863740923e-01,  1.866728569e-01,  1.869718058e-01,  1.872709389e-01,
   1.875702559e-01,  1.878697568e-01,  1.881694412e-01,  1.884693091e-01,
   1.887693603e-01,  1.890695946e-01,  1.893700117e-01,  1.896706117e-01,
   1.899713941e-01,  1.902723590e-01,  1.905735060e-01,  1.908748351e-01,
   1.911763460e-01,  1.914780386e-01,  1.917799127e-01,  1.920819682e-01,
   1.923842047e-01,  1.926866222e-01,  1.929892205e-01,  1.932919994e-01,
   1.935949588e-01,  1.938980984e-01,  1.942014180e-01,  1.945049176e-01,
   1.948085969e-01,  1.951124557e-01,  1.954164938e-01,  1.957207112e-01,
   1.960251075e-01,  1.963296827e-01,  1.966344365e-01,  1.969393687e-01,
   1.972444793e-01,  1.975497680e-01,  1.978552345e-01,  1.981608788e-01,
   1.984667007e-01,  1.987727000e-01,  1.990788765e-01,  1.993852300e-01,
   1.996917603e-01,  1.999984673e-01,  2.003053508e-01,  2.006124106e-01,
   2.009196465e-01,  2.012270584e-01,  2.015346460e-01,  2.018424092e-01,
   2.021503478e-01,  2.024584616e-01,  2.027667504e-01,  2.030752141e-01,
   2.033838525e-01,  2.036926653e-01,  2.040016525e-01,  2.043108138e-01,
   2.046201491e-01,  2.049296581e-01,  2.052393407e-01,  2.055491967e-01,
   2.058592259e-01,  2.061694281e-01,  2.064798032e-01,  2.067903510e-01,
   2.071010713e-01,  2.074119638e-01,  2.077230285e-01,  2.080342651e-01,
   2.083456735e-01,  2.086572535e-01,  2.089690048e-01,  2.092809274e-01,
   2.095930210e-01,  2.099052854e-01,  2.102177204e-01,  2.105303260e-01,
   2.108431018e-01,  2.111560477e-01,  2.114691636e-01,  2.117824492e-01,
   2.120959043e-01,  2.124095288e-01,  2.127233225e-01,  2.130372852e-01,
   2.133514167e-01,  2.136657168e-01,  2.139801853e-01,  2.142948222e-01,
   2.146096271e-01,  2.149245998e-01,  2.152397403e-01,  2.155550483e-01,
   2.158705237e-01,  2.161861661e-01,  2.165019756e-01,  2.168179518e-01,
   2.171340946e-01,  2.174504038e-01,  2.177668792e-01,  2.180835207e-01,
   2.184003280e-01,  2.187173009e-01,  2.190344394e-01,  2.193517431e-01,
   2.196692119e-01,  2.199868456e-01,  2.203046441e-01,  2.206226071e-01,
   2.209407344e-01,  2.212590259e-01,  2.215774814e-01,  2.218961006e-01,
   2.222148835e-01,  2.225338298e-01,  2.228529393e-01,  2.231722118e-01,
   2.234916472e-01,  2.238112453e-01,  2.241310058e-01,  2.244509286e-01,
   2.247710135e-01,  2.250912604e-01,  2.254116689e-01,  2.257322390e-01,
   2.260529704e-01,  2.263738630e-01,  2.266949165e-01,  2.270161309e-01,
   2.273375058e-01,  2.276590411e-01,  2.279807366e-01,  2.283025922e-01,
   2.286246076e-01,  2.289467826e-01,  2.292691171e-01,  2.295916108e-01,
   2.299142636e-01,  2.302370753e-01,  2.305600457e-01,  2.308831746e-01,
   2.312064619e-01,  2.315299072e-01,  2.318535105e-01,  2.321772715e-01,
   2.325011901e-01,  2.328252660e-01,  2.331494991e-01,  2.334738892e-01,
   2.337984361e-01,  2.341231395e-01,  2.344479994e-01,  2.347730155e-01,
   2.350981877e-01,  2.354235156e-01,  2.357489992e-01,  2.360746383e-01,
   2.364004326e-01,  2.367263820e-01,  2.370524863e-01,  2.373787452e-01,
   2.377051587e-01,  2.380317264e-01,  2.383584483e-01,  2.386853240e-01,
   2.390123535e-01,  2.393395366e-01,  2.396668729e-01,  2.399943624e-01,
   2.403220049e-01,  2.406498002e-01,  2.409777480e-01,  2.413058481e-01,
   2.416341005e-01,  2.419625048e-01,  2.422910610e-01,  2.426197687e-01,
   2.429486279e-01,  2.432776383e-01,  2.436067997e-01,  2.439361119e-01,
   2.442655748e-01,  2.445951881e-01,  2.449249516e-01,  2.452548653e-01,
   2.455849287e-01,  2.459151419e-01,  2.462455045e-01,  2.465760164e-01,
   2.469066773e-01,  2.472374872e-01,  2.475684457e-01,  2.478995528e-01,
   2.482308081e-01,  2.485622116e-01,  2.488937630e-01,  2.492254621e-01,
   2.495573087e-01,  2.498893026e-01,  2.502214437e-01,  2.505537317e-01,
   2.508861665e-01,  2.512187478e-01,  2.515514755e-01,  2.518843493e-01,
   2.522173691e-01,  2.525505346e-01,  2.528838457e-01,  2.532173022e-01,
   2.535509039e-01,  2.538846505e-01,  2.542185419e-01,  2.545525780e-01,
   2.548867584e-01,  2.552210829e-01,  2.555555515e-01,  2.558901639e-01,
   2.562249199e-01,  2.565598193e-01,  2.568948619e-01,  2.572300476e-01,
   2.575653760e-01,  2.579008471e-01,  2.582364605e-01,  2.585722162e-01,
   2.589081140e-01,  2.592441535e-01,  2.595803347e-01,  2.599166573e-01,
   2.602531212e-01,  2.605897261e-01,  2.609264718e-01,  2.612633582e-01,
   2.616003850e-01,  2.619375520e-01,  2.622748591e-01,  2.626123061e-01,
   2.629498927e-01,  2.632876187e-01,  2.636254840e-01,  2.639634884e-01,
   2.643016316e-01,  2.646399135e-01,  2.649783338e-01,  2.653168923e-01,
   2.656555890e-01,  2.659944235e-01,  2.663333956e-01,  2.666725052e-01,
   2.670117521e-01,  2.673511361e-01,  2.676906568e-01,  2.680303143e-01,
   2.683701082e-01,  2.687100384e-01,  2.690501046e-01,  2.693903068e-01,
   2.697306445e-01,  2.700711177e-01,  2.704117262e-01,  2.707524698e-01,
   2.710933482e-01,  2.714343613e-01,  2.717755088e-01,  2.721167906e-01,
   2.724582064e-01,  2.727997561e-01,  2.731414395e-01,  2.734832563e-01,
   2.738252064e-01,  2.741672895e-01,  2.745095055e-01,  2.748518541e-01,
   2.751943352e-01,  2.755369485e-01,  2.758796939e-01,  2.762225711e-01,
   2.765655799e-01,  2.769087202e-01,  2.772519917e-01,  2.775953943e-01,
   2.779389277e-01,  2.782825918e-01,  2.786263862e-01,  2.789703109e-01,
   2.793143656e-01,  2.796585502e-01,  2.800028643e-01,  2.803473079e-01,
   2.806918807e-01,  2.810365825e-01,  2.813814132e-01,  2.817263724e-01,
   2.820714600e-01,  2.824166759e-01,  2.827620197e-01,  2.831074913e-01,
   2.834530906e-01,  2.837988172e-01,  2.841446710e-01,  2.844906518e-01,
   2.848367593e-01,  2.851829935e-01,  2.855293540e-01,  2.858758406e-01,
   2.862224533e-01,  2.865691917e-01,  2.869160556e-01,  2.872630449e-01,
   2.876101594e-01,  2.879573988e-01,  2.883047629e-01,  2.886522516e-01,
   2.889998646e-01,  2.893476017e-01,  2.896954628e-01,  2.900434475e-01,
   2.903915558e-01,  2.907397874e-01,  2.910881421e-01,  2.914366197e-01,
   2.917852200e-01,  2.921339427e-01,  2.924827878e-01,  2.928317549e-01,
   2.931808439e-01,  2.935300545e-01,  2.938793867e-01,  2.942288400e-01,
   2.945784145e-01,  2.949281097e-01,  2.952779257e-01,  2.956278620e-01,
   2.959779186e-01,  2.963280952e-01,  2.966783916e-01,  2.970288076e-01,
   2.973793430e-01,  2.977299976e-01,  2.980807712e-01,  2.984316636e-01,
   2.987826746e-01,  2.991338039e-01,  2.994850514e-01,  2.998364169e-01,
   3.001879001e-01,  3.005395008e-01,  3.008912189e-01,  3.012430541e-01,
   3.015950063e-01,  3.019470752e-01,  3.022992605e-01,  3.026515622e-01,
   3.030039800e-01,  3.033565136e-01,  3.037091630e-01,  3.040619278e-01,
   3.044148078e-01,  3.047678030e-01,  3.051209130e-01,  3.054741376e-01,
   3.058274767e-01,  3.061809299e-01,  3.065344972e-01,  3.068881784e-01,
   3.072419731e-01,  3.075958812e-01,  3.079499025e-01,  3.083040368e-01,
   3.086582838e-01,  3.090126434e-01,  3.093671154e-01,  3.097216995e-01,
   3.100763955e-01,  3.104312033e-01,  3.107861226e-01,  3.111411532e-01,
   3.114962949e-01,  3.118515475e-01,  3.122069108e-01,  3.125623845e-01,
   3.129179685e-01,  3.132736626e-01,  3.136294665e-01,  3.139853800e-01,
   3.143414030e-01,  3.146975352e-01,  3.150537764e-01,  3.154101264e-01,
   3.157665850e-01,  3.161231520e-01,  3.164798271e-01,  3.168366102e-01,
   3.171935011e-01,  3.175504995e-01,  3.179076052e-01,  3.182648181e-01,
   3.186221378e-01,  3.189795643e-01,  3.193370972e-01,  3.196947364e-01,
   3.200524817e-01,  3.204103329e-01,  3.207682897e-01,  3.211263519e-01,
   3.214845194e-01,  3.218427919e-01,  3.222011691e-01,  3.225596510e-01,
   3.229182373e-01,  3.232769277e-01,  3.236357221e-01,  3.239946203e-01,
   3.243536220e-01,  3.247127270e-01,  3.250719351e-01,  3.254312461e-01,
   3.257906599e-01,  3.261501761e-01,  3.265097946e-01,  3.268695151e-01,
   3.272293375e-01,  3.275892615e-01,  3.279492870e-01,  3.283094137e-01,
   3.286696413e-01,  3.290299698e-01,  3.293903988e-01,  3.297509282e-01,
   3.301115578e-01,  3.304722873e-01,  3.308331165e-01,  3.311940453e-01,
   3.315550733e-01,  3.319162004e-01,  3.322774265e-01,  3.326387511e-01,
   3.330001743e-01,  3.333616957e-01,  3.337233151e-01,  3.340850323e-01,
   3.344468471e-01,  3.348087593e-01,  3.351707687e-01,  3.355328751e-01,
   3.358950782e-01,  3.362573779e-01,  3.366197738e-01,  3.369822659e-01,
   3.373448539e-01,  3.377075376e-01,  3.380703167e-01,  3.384331911e-01,
   3.387961606e-01,  3.391592249e-01,  3.395223838e-01,  3.398856371e-01,
   3.402489846e-01,  3.406124261e-01,  3.409759613e-01,  3.413395901e-01,
   3.417033122e-01,  3.420671275e-01,  3.424310356e-01,  3.427950365e-01,
   3.431591298e-01,  3.435233154e-01,  3.438875930e-01,  3.442519625e-01,
   3.446164236e-01,  3.449809761e-01,  3.453456198e-01,  3.457103545e-01,
   3.460751800e-01,  3.464400960e-01,  3.468051023e-01,  3.471701988e-01,
   3.475353851e-01,  3.479006612e-01,  3.482660267e-01,  3.486314815e-01,
   3.489970253e-01,  3.493626580e-01,  3.497283793e-01,  3.500941890e-01,
   3.504600868e-01,  3.508260727e-01,  3.511921463e-01,  3.515583074e-01,
   3.519245559e-01,  3.522908914e-01,  3.526573139e-01,  3.530238231e-01,
   3.533904187e-01,  3.537571005e-01,  3.541238684e-01,  3.544907221e-01,
   3.548576614e-01,  3.552246861e-01,  3.555917959e-01,  3.559589907e-01,
   3.563262702e-01,  3.566936343e-01,  3.570610826e-01,  3.574286151e-01,
   3.577962314e-01,  3.581639314e-01,  3.585317148e-01,  3.588995814e-01,
   3.592675310e-01,  3.596355635e-01,  3.600036785e-01,  3.603718758e-01,
   3.607401553e-01,  3.611085167e-01,  3.614769598e-01,  3.618454845e-01,
   3.622140903e-01,  3.625827773e-01,  3.629515451e-01,  3.633203935e-01,
   3.636893223e-01,  3.640583313e-01,  3.644274202e-01,  3.647965890e-01,
   3.651658372e-01,  3.655351648e-01,  3.659045715e-01,  3.662740570e-01,
   3.666436213e-01,  3.670132639e-01,  3.673829849e-01,  3.677527838e-01,
   3.681226605e-01,  3.684926148e-01,  3.688626465e-01,  3.692327553e-01,
   3.696029410e-01,  3.699732035e-01,  3.703435424e-01,  3.707139576e-01,
   3.710844489e-01,  3.714550160e-01,  3.718256588e-01,  3.721963769e-01,
   3.725671702e-01,  3.729380385e-01,  3.733089815e-01,  3.736799991e-01,
   3.740510909e-01,  3.744222569e-01,  3.747934967e-01,  3.751648102e-01,
   3.755361971e-01,  3.759076573e-01,  3.762791904e-01,  3.766507963e-01,
   3.770224748e-01,  3.773942257e-01,  3.777660486e-01,  3.781379435e-01,
   3.785099100e-01,  3.788819481e-01,  3.792540573e-01,  3.796262377e-01,
   3.799984888e-01,  3.803708105e-01,  3.807432026e-01,  3.811156648e-01,
   3.814881970e-01,  3.818607989e-01,  3.822334703e-01,  3.826062110e-01,
   3.829790207e-01,  3.833518993e-01,  3.837248465e-01,  3.840978621e-01,
   3.844709459e-01,  3.848440976e-01,  3.852173171e-01,  3.855906041e-01,
   3.859639584e-01,  3.863373798e-01,  3.867108681e-01,  3.870844230e-01,
   3.874580443e-01,  3.878317319e-01,  3.882054854e-01,  3.885793047e-01,
   3.889531895e-01,  3.893271397e-01,  3.897011549e-01,  3.900752351e-01,
   3.904493799e-01,  3.908235892e-01,  3.911978627e-01,  3.915722002e-01,
   3.919466015e-01,  3.923210663e-01,  3.926955945e-01,  3.930701858e-01,
   3.934448400e-01,  3.938195569e-01,  3.941943363e-01,  3.945691779e-01,
   3.949440816e-01,  3.953190470e-01,  3.956940740e-01,  3.960691624e-01,
   3.964443119e-01,  3.968195223e-01,  3.971947935e-01,  3.975701251e-01,
   3.979455170e-01,  3.983209689e-01,  3.986964806e-01,  3.990720519e-01,
   3.994476826e-01,  3.998233724e-01,  4.001991212e-01,  4.005749287e-01,
   4.009507946e-01,  4.013267189e-01,  4.017027012e-01,  4.020787413e-01,
   4.024548390e-01,  4.028309941e-01,  4.032072064e-01,  4.035834756e-01,
   4.039598015e-01,  4.043361839e-01,  4.047126226e-01,  4.050891173e-01,
   4.054656679e-01,  4.058422741e-01,  4.062189357e-01,  4.065956525e-01,
   4.069724242e-01,  4.073492506e-01,  4.077261315e-01,  4.081030667e-01,
   4.084800560e-01,  4.088570991e-01,  4.092341959e-01,  4.096113460e-01,
   4.099885493e-01,  4.103658055e-01,  4.107431145e-01,  4.111204760e-01,
   4.114978898e-01,  4.118753556e-01,  4.122528733e-01,  4.126304426e-01,
   4.130080633e-01,  4.133857352e-01,  4.137634580e-01,  4.141412316e-01,
   4.145190556e-01,  4.148969300e-01,  4.152748544e-01,  4.156528286e-01,
   4.160308525e-01,  4.164089258e-01,  4.167870482e-01,  4.171652196e-01,
   4.175434398e-01,  4.179217084e-01,  4.183000253e-01,  4.186783903e-01,
   4.190568031e-01,  4.194352635e-01,  4.198137714e-01,  4.201923264e-01,
   4.205709283e-01,  4.209495770e-01,  4.213282722e-01,  4.217070137e-01,
   4.220858012e-01,  4.224646345e-01,  4.228435135e-01,  4.232224378e-01,
   4.236014074e-01,  4.239804218e-01,  4.243594810e-01,  4.247385847e-01,
   4.251177327e-01,  4.254969247e-01,  4.258761605e-01,  4.262554399e-01,
   4.266347628e-01,  4.270141288e-01,  4.273935377e-01,  4.277729893e-01,
   4.281524834e-01,  4.285320198e-01,  4.289115982e-01,  4.292912185e-01,
   4.296708803e-01,  4.300505836e-01,  4.304303279e-01,  4.308101132e-01,
   4.311899392e-01,  4.315698057e-01,  4.319497124e-01,  4.323296592e-01,
   4.327096457e-01,  4.330896719e-01,  4.334697374e-01,  4.338498421e-01,
   4.342299856e-01,  4.346101679e-01,  4.349903886e-01,  4.353706476e-01,
   4.357509446e-01,  4.361312794e-01,  4.365116518e-01,  4.368920615e-01,
   4.372725083e-01,  4.376529920e-01,  4.380335124e-01,  4.384140693e-01,
   4.387946624e-01,  4.391752915e-01,  4.395559564e-01,  4.399366568e-01,
   4.403173926e-01,  4.406981635e-01,  4.410789692e-01,  4.414598097e-01,
   4.418406845e-01,  4.422215936e-01,  4.426025367e-01,  4.429835135e-01,
   4.433645239e-01,  4.437455676e-01,  4.441266444e-01,  4.445077541e-01,
   4.448888964e-01,  4.452700711e-01,  4.456512780e-01,  4.460325169e-01,
   4.464137875e-01,  4.467950897e-01,  4.471764231e-01,  4.475577877e-01,
   4.479391831e-01,  4.483206091e-01,  4.487020655e-01,  4.490835521e-01,
   4.494650686e-01,  4.498466149e-01,  4.502281907e-01,  4.506097957e-01,
   4.509914298e-01,  4.513730928e-01,  4.517547843e-01,  4.521365043e-01,
   4.525182523e-01,  4.529000284e-01,  4.532818321e-01,  4.536636633e-01,
   4.540455218e-01,  4.544274073e-01,  4.548093196e-01,  4.551912585e-01,
   4.555732237e-01,  4.559552151e-01,  4.563372324e-01,  4.567192754e-01,
   4.571013438e-01,  4.574834375e-01,  4.578655562e-01,  4.582476997e-01,
   4.586298677e-01,  4.590120601e-01,  4.593942766e-01,  4.597765170e-01,
   4.601587810e-01,  4.605410685e-01,  4.609233792e-01,  4.613057129e-01,
   4.616880693e-01,  4.620704483e-01,  4.624528496e-01,  4.628352730e-01,
   4.632177182e-01,  4.636001851e-01,  4.639826734e-01,  4.643651829e-01,
   4.647477133e-01,  4.651302645e-01,  4.655128362e-01,  4.658954282e-01,
   4.662780402e-01,  4.666606721e-01,  4.670433236e-01,  4.674259945e-01,
   4.678086845e-01,  4.681913935e-01,  4.685741212e-01,  4.689568674e-01,
   4.693396318e-01,  4.697224143e-01,  4.701052146e-01,  4.704880325e-01,
   4.708708677e-01,  4.712537201e-01,  4.716365894e-01,  4.720194754e-01,
   4.724023778e-01,  4.727852965e-01,  4.731682312e-01,  4.735511816e-01,
   4.739341477e-01,  4.743171290e-01,  4.747001255e-01,  4.750831368e-01,
   4.754661628e-01,  4.758492033e-01,  4.762322579e-01,  4.766153265e-01,
   4.769984089e-01,  4.773815049e-01,  4.777646141e-01,  4.781477364e-01,
   4.785308715e-01,  4.789140193e-01,  4.792971795e-01,  4.796803519e-01,
   4.800635362e-01,  4.804467323e-01,  4.808299398e-01,  4.812131586e-01,
   4.815963885e-01,  4.819796292e-01,  4.823628806e-01,  4.827461422e-01,
   4.831294141e-01,  4.835126958e-01,  4.838959873e-01,  4.842792882e-01,
   4.846625984e-01,  4.850459176e-01,  4.854292456e-01,  4.858125822e-01,
   4.861959271e-01,  4.865792802e-01,  4.869626411e-01,  4.873460097e-01,
   4.877293857e-01,  4.881127690e-01,  4.884961593e-01,  4.888795563e-01,
   4.892629599e-01,  4.896463697e-01,  4.900297857e-01,  4.904132076e-01,
   4.907966350e-01,  4.911800679e-01,  4.915635060e-01,  4.919469491e-01,
   4.923303969e-01,  4.927138492e-01,  4.930973057e-01,  4.934807664e-01,
   4.938642309e-01,  4.942476989e-01,  4.946311704e-01,  4.950146450e-01,
   4.953981226e-01,  4.957816029e-01,  4.961650856e-01,  4.965485706e-01,
   4.969320577e-01,  4.973155465e-01,  4.976990369e-01,  4.980825287e-01,
   4.984660216e-01,  4.988495154e-01,  4.992330099e-01,  4.996165048e-01,
   5.000000000e-01,  5.003834952e-01,  5.007669901e-01,  5.011504846e-01,
   5.015339784e-01,  5.019174713e-01,  5.023009631e-01,  5.026844535e-01,
   5.030679423e-01,  5.034514294e-01,  5.038349144e-01,  5.042183971e-01,
   5.046018774e-01,  5.049853550e-01,  5.053688296e-01,  5.057523011e-01,
   5.061357691e-01,  5.065192336e-01,  5.069026943e-01,  5.072861508e-01,
   5.076696031e-01,  5.080530509e-01,  5.084364940e-01,  5.088199321e-01,
   5.092033650e-01,  5.095867924e-01,  5.099702143e-01,  5.103536303e-01,
   5.107370401e-01,  5.111204437e-01,  5.115038407e-01,  5.118872310e-01,
   5.122706143e-01,  5.126539903e-01,  5.130373589e-01,  5.134207198e-01,
   5.138040729e-01,  5.141874178e-01,  5.145707544e-01,  5.149540824e-01,
   5.153374016e-01,  5.157207118e-01,  5.161040127e-01,  5.164873042e-01,
   5.168705859e-01,  5.172538578e-01,  5.176371194e-01,  5.180203708e-01,
   5.184036115e-01,  5.187868414e-01,  5.191700602e-01,  5.195532677e-01,
   5.199364638e-01,  5.203196481e-01,  5.207028205e-01,  5.210859807e-01,
   5.214691285e-01,  5.218522636e-01,  5.222353859e-01,  5.226184951e-01,
   5.230015911e-01,  5.233846735e-01,  5.237677421e-01,  5.241507967e-01,
   5.245338372e-01,  5.249168632e-01,  5.252998745e-01,  5.256828710e-01,
   5.260658523e-01,  5.264488184e-01,  5.268317688e-01,  5.272147035e-01,
   5.275976222e-01,  5.279805246e-01,  5.283634106e-01,  5.287462799e-01,
   5.291291323e-01,  5.295119675e-01,  5.298947854e-01,  5.302775857e-01,
   5.306603682e-01,  5.310431326e-01,  5.314258788e-01,  5.318086065e-01,
   5.321913155e-01,  5.325740055e-01,  5.329566764e-01,  5.333393279e-01,
   5.337219598e-01,  5.341045718e-01,  5.344871638e-01,  5.348697355e-01,
   5.352522867e-01,  5.356348171e-01,  5.360173266e-01,  5.363998149e-01,
   5.367822818e-01,  5.371647270e-01,  5.375471504e-01,  5.379295517e-01,
   5.383119307e-01,  5.386942871e-01,  5.390766208e-01,  5.394589315e-01,
   5.398412190e-01,  5.402234830e-01,  5.406057234e-01,  5.409879399e-01,
   5.413701323e-01,  5.417523003e-01,  5.421344438e-01,  5.425165625e-01,
   5.428986562e-01,  5.432807246e-01,  5.436627676e-01,  5.440447849e-01,
   5.444267763e-01,  5.448087415e-01,  5.451906804e-01,  5.455725927e-01,
   5.459544782e-01,  5.463363367e-01,  5.467181679e-01,  5.470999716e-01,
   5.474817477e-01,  5.478634957e-01,  5.482452157e-01,  5.486269072e-01,
   5.490085702e-01,  5.493902043e-01,  5.497718093e-01,  5.501533851e-01,
   5.505349314e-01,  5.509164479e-01,  5.512979345e-01,  5.516793909e-01,
   5.520608169e-01,  5.524422123e-01,  5.528235769e-01,  5.532049103e-01,
   5.535862125e-01,  5.539674831e-01,  5.543487220e-01,  5.547299289e-01,
   5.551111036e-01,  5.554922459e-01,  5.558733556e-01,  5.562544324e-01,
   5.566354761e-01,  5.570164865e-01,  5.573974633e-01,  5.577784064e-01,
   5.581593155e-01,  5.585401903e-01,  5.589210308e-01,  5.593018365e-01,
   5.596826074e-01,  5.600633432e-01,  5.604440436e-01,  5.608247085e-01,
   5.612053376e-01,  5.615859307e-01,  5.619664876e-01,  5.623470080e-01,
   5.627274917e-01,  5.631079385e-01,  5.634883482e-01,  5.638687206e-01,
   5.642490554e-01,  5.646293524e-01,  5.650096114e-01,  5.653898321e-01,
   5.657700144e-01,  5.661501579e-01,  5.665302626e-01,  5.669103281e-01,
   5.672903543e-01,  5.676703408e-01,  5.680502876e-01,  5.684301943e-01,
   5.688100608e-01,  5.691898868e-01,  5.695696721e-01,  5.699494164e-01,
   5.703291197e-01,  5.707087815e-01,  5.710884018e-01,  5.714679802e-01,
   5.718475166e-01,  5.722270107e-01,  5.726064623e-01,  5.729858712e-01,
   5.733652372e-01,  5.737445601e-01,  5.741238395e-01,  5.745030753e-01,
   5.748822673e-01,  5.752614153e-01,  5.756405190e-01,  5.760195782e-01,
   5.763985926e-01,  5.767775622e-01,  5.771564865e-01,  5.775353655e-01,
   5.779141988e-01,  5.782929863e-01,  5.786717278e-01,  5.790504230e-01,
   5.794290717e-01,  5.798076736e-01,  5.801862286e-01,  5.805647365e-01,
   5.809431969e-01,  5.813216097e-01,  5.816999747e-01,  5.820782916e-01,
   5.824565602e-01,  5.828347804e-01,  5.832129518e-01,  5.835910742e-01,
   5.839691475e-01,  5.843471714e-01,  5.847251456e-01,  5.851030700e-01,
   5.854809444e-01,  5.858587684e-01,  5.862365420e-01,  5.866142648e-01,
   5.869919367e-01,  5.873695574e-01,  5.877471267e-01,  5.881246444e-01,
   5.885021102e-01,  5.888795240e-01,  5.892568855e-01,  5.896341945e-01,
   5.900114507e-01,  5.903886540e-01,  5.907658041e-01,  5.911429009e-01,
   5.915199440e-01,  5.918969333e-01,  5.922738685e-01,  5.926507494e-01,
   5.930275758e-01,  5.934043475e-01,  5.937810643e-01,  5.941577259e-01,
   5.945343321e-01,  5.949108827e-01,  5.952873774e-01,  5.956638161e-01,
   5.960401985e-01,  5.964165244e-01,  5.967927936e-01,  5.971690059e-01,
   5.975451610e-01,  5.979212587e-01,  5.982972988e-01,  5.986732811e-01,
   5.990492054e-01,  5.994250713e-01,  5.998008788e-01,  6.001766276e-01,
   6.005523174e-01,  6.009279481e-01,  6.013035194e-01,  6.016790311e-01,
   6.020544830e-01,  6.024298749e-01,  6.028052065e-01,  6.031804777e-01,
   6.035556881e-01,  6.039308376e-01,  6.043059260e-01,  6.046809530e-01,
   6.050559184e-01,  6.054308221e-01,  6.058056637e-01,  6.061804431e-01,
   6.065551600e-01,  6.069298142e-01,  6.073044055e-01,  6.076789337e-01,
   6.080533985e-01,  6.084277998e-01,  6.088021373e-01,  6.091764108e-01,
   6.095506201e-01,  6.099247649e-01,  6.102988451e-01,  6.106728603e-01,
   6.110468105e-01,  6.114206953e-01,  6.117945146e-01,  6.121682681e-01,
   6.125419557e-01,  6.129155770e-01,  6.132891319e-01,  6.136626202e-01,
   6.140360416e-01,  6.144093959e-01,  6.147826829e-01,  6.151559024e-01,
   6.155290541e-01,  6.159021379e-01,  6.162751535e-01,  6.166481007e-01,
   6.170209793e-01,  6.173937890e-01,  6.177665297e-01,  6.181392011e-01,
   6.185118030e-01,  6.188843352e-01,  6.192567974e-01,  6.196291895e-01,
   6.200015112e-01,  6.203737623e-01,  6.207459427e-01,  6.211180519e-01,
   6.214900900e-01,  6.218620565e-01,  6.222339514e-01,  6.226057743e-01,
   6.229775252e-01,  6.233492037e-01,  6.237208096e-01,  6.240923427e-01,
   6.244638029e-01,  6.248351898e-01,  6.252065033e-01,  6.255777431e-01,
   6.259489091e-01,  6.263200009e-01,  6.266910185e-01,  6.270619615e-01,
   6.274328298e-01,  6.278036231e-01,  6.281743412e-01,  6.285449840e-01,
   6.289155511e-01,  6.292860424e-01,  6.296564576e-01,  6.300267965e-01,
   6.303970590e-01,  6.307672447e-01,  6.311373535e-01,  6.315073852e-01,
   6.318773395e-01,  6.322472162e-01,  6.326170151e-01,  6.329867361e-01,
   6.333563787e-01,  6.337259430e-01,  6.340954285e-01,  6.344648352e-01,
   6.348341628e-01,  6.352034110e-01,  6.355725798e-01,  6.359416687e-01,
   6.363106777e-01,  6.366796065e-01,  6.370484549e-01,  6.374172227e-01,
   6.377859097e-01,  6.381545155e-01,  6.385230402e-01,  6.388914833e-01,
   6.392598447e-01,  6.396281242e-01,  6.399963215e-01,  6.403644365e-01,
   6.407324690e-01,  6.411004186e-01,  6.414682852e-01,  6.418360686e-01,
   6.422037686e-01,  6.425713849e-01,  6.429389174e-01,  6.433063657e-01,
   6.436737298e-01,  6.440410093e-01,  6.444082041e-01,  6.447753139e-01,
   6.451423386e-01,  6.455092779e-01,  6.458761316e-01,  6.462428995e-01,
   6.466095813e-01,  6.469761769e-01,  6.473426861e-01,  6.477091086e-01,
   6.480754441e-01,  6.484416926e-01,  6.488078537e-01,  6.491739273e-01,
   6.495399132e-01,  6.499058110e-01,  6.502716207e-01,  6.506373420e-01,
   6.510029747e-01,  6.513685185e-01,  6.517339733e-01,  6.520993388e-01,
   6.524646149e-01,  6.528298012e-01,  6.531948977e-01,  6.535599040e-01,
   6.539248200e-01,  6.542896455e-01,  6.546543802e-01,  6.550190239e-01,
   6.553835764e-01,  6.557480375e-01,  6.561124070e-01,  6.564766846e-01,
   6.568408702e-01,  6.572049635e-01,  6.575689644e-01,  6.579328725e-01,
   6.582966878e-01,  6.586604099e-01,  6.590240387e-01,  6.593875739e-01,
   6.597510154e-01,  6.601143629e-01,  6.604776162e-01,  6.608407751e-01,
   6.612038394e-01,  6.615668089e-01,  6.619296833e-01,  6.622924624e-01,
   6.626551461e-01,  6.630177341e-01,  6.633802262e-01,  6.637426221e-01,
   6.641049218e-01,  6.644671249e-01,  6.648292313e-01,  6.651912407e-01,
   6.655531529e-01,  6.659149677e-01,  6.662766849e-01,  6.666383043e-01,
   6.669998257e-01,  6.673612489e-01,  6.677225735e-01,  6.680837996e-01,
   6.684449267e-01,  6.688059547e-01,  6.691668835e-01,  6.695277127e-01,
   6.698884422e-01,  6.702490718e-01,  6.706096012e-01,  6.709700302e-01,
   6.713303587e-01,  6.716905863e-01,  6.720507130e-01,  6.724107385e-01,
   6.727706625e-01,  6.731304849e-01,  6.734902054e-01,  6.738498239e-01,
   6.742093401e-01,  6.745687539e-01,  6.749280649e-01,  6.752872730e-01,
   6.756463780e-01,  6.760053797e-01,  6.763642779e-01,  6.767230723e-01,
   6.770817627e-01,  6.774403490e-01,  6.777988309e-01,  6.781572081e-01,
   6.785154806e-01,  6.788736481e-01,  6.792317103e-01,  6.795896671e-01,
   6.799475183e-01,  6.803052636e-01,  6.806629028e-01,  6.810204357e-01,
   6.813778622e-01,  6.817351819e-01,  6.820923948e-01,  6.824495005e-01,
   6.828064989e-01,  6.831633898e-01,  6.835201729e-01,  6.838768480e-01,
   6.842334150e-01,  6.845898736e-01,  6.849462236e-01,  6.853024648e-01,
   6.856585970e-01,  6.860146200e-01,  6.863705335e-01,  6.867263374e-01,
   6.870820315e-01,  6.874376155e-01,  6.877930892e-01,  6.881484525e-01,
   6.885037051e-01,  6.888588468e-01,  6.892138774e-01,  6.895687967e-01,
   6.899236045e-01,  6.902783005e-01,  6.906328846e-01,  6.909873566e-01,
   6.913417162e-01,  6.916959632e-01,  6.920500975e-01,  6.924041188e-01,
   6.927580269e-01,  6.931118216e-01,  6.934655028e-01,  6.938190701e-01,
   6.941725233e-01,  6.945258624e-01,  6.948790870e-01,  6.952321970e-01,
   6.955851922e-01,  6.959380722e-01,  6.962908370e-01,  6.966434864e-01,
   6.969960200e-01,  6.973484378e-01,  6.977007395e-01,  6.980529248e-01,
   6.984049937e-01,  6.987569459e-01,  6.991087811e-01,  6.994604992e-01,
   6.998120999e-01,  7.001635831e-01,  7.005149486e-01,  7.008661961e-01,
   7.012173254e-01,  7.015683364e-01,  7.019192288e-01,  7.022700024e-01,
   7.026206570e-01,  7.029711924e-01,  7.033216084e-01,  7.036719048e-01,
   7.040220814e-01,  7.043721380e-01,  7.047220743e-01,  7.050718903e-01,
   7.054215855e-01,  7.057711600e-01,  7.061206133e-01,  7.064699455e-01,
   7.068191561e-01,  7.071682451e-01,  7.075172122e-01,  7.078660573e-01,
   7.082147800e-01,  7.085633803e-01,  7.089118579e-01,  7.092602126e-01,
   7.096084442e-01,  7.099565525e-01,  7.103045372e-01,  7.106523983e-01,
   7.110001354e-01,  7.113477484e-01,  7.116952371e-01,  7.120426012e-01,
   7.123898406e-01,  7.127369551e-01,  7.130839444e-01,  7.134308083e-01,
   7.137775467e-01,  7.141241594e-01,  7.144706460e-01,  7.148170065e-01,
   7.151632407e-01,  7.155093482e-01,  7.158553290e-01,  7.162011828e-01,
   7.165469094e-01,  7.168925087e-01,  7.172379803e-01,  7.175833241e-01,
   7.179285400e-01,  7.182736276e-01,  7.186185868e-01,  7.189634175e-01,
   7.193081193e-01,  7.196526921e-01,  7.199971357e-01,  7.203414498e-01,
   7.206856344e-01,  7.210296891e-01,  7.213736138e-01,  7.217174082e-01,
   7.220610723e-01,  7.224046057e-01,  7.227480083e-01,  7.230912798e-01,
   7.234344201e-01,  7.237774289e-01,  7.241203061e-01,  7.244630515e-01,
   7.248056648e-01,  7.251481459e-01,  7.254904945e-01,  7.258327105e-01,
   7.261747936e-01,  7.265167437e-01,  7.268585605e-01,  7.272002439e-01,
   7.275417936e-01,  7.278832094e-01,  7.282244912e-01,  7.285656387e-01,
   7.289066518e-01,  7.292475302e-01,  7.295882738e-01,  7.299288823e-01,
   7.302693555e-01,  7.306096932e-01,  7.309498954e-01,  7.312899616e-01,
   7.316298918e-01,  7.319696857e-01,  7.323093432e-01,  7.326488639e-01,
   7.329882479e-01,  7.333274948e-01,  7.336666044e-01,  7.340055765e-01,
   7.343444110e-01,  7.346831077e-01,  7.350216662e-01,  7.353600865e-01,
   7.356983684e-01,  7.360365116e-01,  7.363745160e-01,  7.367123813e-01,
   7.370501073e-01,  7.373876939e-01,  7.377251409e-01,  7.380624480e-01,
   7.383996150e-01,  7.387366418e-01,  7.390735282e-01,  7.394102739e-01,
   7.397468788e-01,  7.400833427e-01,  7.404196653e-01,  7.407558465e-01,
   7.410918860e-01,  7.414277838e-01,  7.417635395e-01,  7.420991529e-01,
   7.424346240e-01,  7.427699524e-01,  7.431051381e-01,  7.434401807e-01,
   7.437750801e-01,  7.441098361e-01,  7.444444485e-01,  7.447789171e-01,
   7.451132416e-01,  7.454474220e-01,  7.457814581e-01,  7.461153495e-01,
   7.464490961e-01,  7.467826978e-01,  7.471161543e-01,  7.474494654e-01,
   7.477826309e-01,  7.481156507e-01,  7.484485245e-01,  7.487812522e-01,
   7.491138335e-01,  7.494462683e-01,  7.497785563e-01,  7.501106974e-01,
   7.504426913e-01,  7.507745379e-01,  7.511062370e-01,  7.514377884e-01,
   7.517691919e-01,  7.521004472e-01,  7.524315543e-01,  7.527625128e-01,
   7.530933227e-01,  7.534239836e-01,  7.537544955e-01,  7.540848581e-01,
   7.544150713e-01,  7.547451347e-01,  7.550750484e-01,  7.554048119e-01,
   7.557344252e-01,  7.560638881e-01,  7.563932003e-01,  7.567223617e-01,
   7.570513721e-01,  7.573802313e-01,  7.577089390e-01,  7.580374952e-01,
   7.583658995e-01,  7.586941519e-01,  7.590222520e-01,  7.593501998e-01,
   7.596779951e-01,  7.600056376e-01,  7.603331271e-01,  7.606604634e-01,
   7.609876465e-01,  7.613146760e-01,  7.616415517e-01,  7.619682736e-01,
   7.622948413e-01,  7.626212548e-01,  7.629475137e-01,  7.632736180e-01,
   7.635995674e-01,  7.639253617e-01,  7.642510008e-01,  7.645764844e-01,
   7.649018123e-01,  7.652269845e-01,  7.655520006e-01,  7.658768605e-01,
   7.662015639e-01,  7.665261108e-01,  7.668505009e-01,  7.671747340e-01,
   7.674988099e-01,  7.678227285e-01,  7.681464895e-01,  7.684700928e-01,
   7.687935381e-01,  7.691168254e-01,  7.694399543e-01,  7.697629247e-01,
   7.700857364e-01,  7.704083892e-01,  7.707308829e-01,  7.710532174e-01,
   7.713753924e-01,  7.716974078e-01,  7.720192634e-01,  7.723409589e-01,
   7.726624942e-01,  7.729838691e-01,  7.733050835e-01,  7.736261370e-01,
   7.739470296e-01,  7.742677610e-01,  7.745883311e-01,  7.749087396e-01,
   7.752289865e-01,  7.755490714e-01,  7.758689942e-01,  7.761887547e-01,
   7.765083528e-01,  7.768277882e-01,  7.771470607e-01,  7.774661702e-01,
   7.777851165e-01,  7.781038994e-01,  7.784225186e-01,  7.787409741e-01,
   7.790592656e-01,  7.793773929e-01,  7.796953559e-01,  7.800131544e-01,
   7.803307881e-01,  7.806482569e-01,  7.809655606e-01,  7.812826991e-01,
   7.815996720e-01,  7.819164793e-01,  7.822331208e-01,  7.825495962e-01,
   7.828659054e-01,  7.831820482e-01,  7.834980244e-01,  7.838138339e-01,
   7.841294763e-01,  7.844449517e-01,  7.847602597e-01,  7.850754002e-01,
   7.853903729e-01,  7.857051778e-01,  7.860198147e-01,  7.863342832e-01,
   7.866485833e-01,  7.869627148e-01,  7.872766775e-01,  7.875904712e-01,
   7.879040957e-01,  7.882175508e-01,  7.885308364e-01,  7.888439523e-01,
   7.891568982e-01,  7.894696740e-01,  7.897822796e-01,  7.900947146e-01,
   7.904069790e-01,  7.907190726e-01,  7.910309952e-01,  7.913427465e-01,
   7.916543265e-01,  7.919657349e-01,  7.922769715e-01,  7.925880362e-01,
   7.928989287e-01,  7.932096490e-01,  7.935201968e-01,  7.938305719e-01,
   7.941407741e-01,  7.944508033e-01,  7.947606593e-01,  7.950703419e-01,
   7.953798509e-01,  7.956891862e-01,  7.959983475e-01,  7.963073347e-01,
   7.966161475e-01,  7.969247859e-01,  7.972332496e-01,  7.975415384e-01,
   7.978496522e-01,  7.981575908e-01,  7.984653540e-01,  7.987729416e-01,
   7.990803535e-01,  7.993875894e-01,  7.996946492e-01,  8.000015327e-01,
   8.003082397e-01,  8.006147700e-01,  8.009211235e-01,  8.012273000e-01,
   8.015332993e-01,  8.018391212e-01,  8.021447655e-01,  8.024502320e-01,
   8.027555207e-01,  8.030606313e-01,  8.033655635e-01,  8.036703173e-01,
   8.039748925e-01,  8.042792888e-01,  8.045835062e-01,  8.048875443e-01,
   8.051914031e-01,  8.054950824e-01,  8.057985820e-01,  8.061019016e-01,
   8.064050412e-01,  8.067080006e-01,  8.070107795e-01,  8.073133778e-01,
   8.076157953e-01,  8.079180318e-01,  8.082200873e-01,  8.085219614e-01,
   8.088236540e-01,  8.091251649e-01,  8.094264940e-01,  8.097276410e-01,
   8.100286059e-01,  8.103293883e-01,  8.106299883e-01,  8.109304054e-01,
   8.112306397e-01,  8.115306909e-01,  8.118305588e-01,  8.121302432e-01,
   8.124297441e-01,  8.127290611e-01,  8.130281942e-01,  8.133271431e-01,
   8.136259077e-01,  8.139244879e-01,  8.142228833e-01,  8.145210939e-01,
   8.148191195e-01,  8.151169598e-01,  8.154146148e-01,  8.157120843e-01,
   8.160093680e-01,  8.163064658e-01,  8.166033775e-01,  8.169001030e-01,
   8.171966421e-01,  8.174929945e-01,  8.177891602e-01,  8.180851390e-01,
   8.183809306e-01,  8.186765349e-01,  8.189719518e-01,  8.192671810e-01,
   8.195622224e-01,  8.198570758e-01,  8.201517411e-01,  8.204462180e-01,
   8.207405064e-01,  8.210346061e-01,  8.213285170e-01,  8.216222388e-01,
   8.219157714e-01,  8.222091147e-01,  8.225022684e-01,  8.227952324e-01,
   8.230880065e-01,  8.233805905e-01,  8.236729843e-01,  8.239651877e-01,
   8.242572005e-01,  8.245490226e-01,  8.248406537e-01,  8.251320937e-01,
   8.254233425e-01,  8.257143998e-01,  8.260052655e-01,  8.262959395e-01,
   8.265864215e-01,  8.268767113e-01,  8.271668089e-01,  8.274567140e-01,
   8.277464265e-01,  8.280359462e-01,  8.283252729e-01,  8.286144064e-01,
   8.289033466e-01,  8.291920934e-01,  8.294806465e-01,  8.297690058e-01,
   8.300571710e-01,  8.303451421e-01,  8.306329189e-01,  8.309205012e-01,
   8.312078888e-01,  8.314950816e-01,  8.317820793e-01,  8.320688819e-01,
   8.323554891e-01,  8.326419008e-01,  8.329281168e-01,  8.332141370e-01,
   8.334999612e-01,  8.337855891e-01,  8.340710207e-01,  8.343562558e-01,
   8.346412942e-01,  8.349261357e-01,  8.352107802e-01,  8.354952275e-01,
   8.357794774e-01,  8.360635298e-01,  8.363473845e-01,  8.366310414e-01,
   8.369145002e-01,  8.371977608e-01,  8.374808231e-01,  8.377636868e-01,
   8.380463518e-01,  8.383288179e-01,  8.386110851e-01,  8.388931530e-01,
   8.391750216e-01,  8.394566906e-01,  8.397381599e-01,  8.400194294e-01,
   8.403004989e-01,  8.405813682e-01,  8.408620371e-01,  8.411425055e-01,
   8.414227732e-01,  8.417028401e-01,  8.419827059e-01,  8.422623706e-01,
   8.425418339e-01,  8.428210957e-01,  8.431001558e-01,  8.433790141e-01,
   8.436576704e-01,  8.439361246e-01,  8.442143764e-01,  8.444924257e-01,
   8.447702724e-01,  8.450479162e-01,  8.453253571e-01,  8.456025948e-01,
   8.458796292e-01,  8.461564601e-01,  8.464330874e-01,  8.467095109e-01,
   8.469857304e-01,  8.472617459e-01,  8.475375570e-01,  8.478131637e-01,
   8.480885657e-01,  8.483637630e-01,  8.486387554e-01,  8.489135427e-01,
   8.491881247e-01,  8.494625013e-01,  8.497366723e-01,  8.500106376e-01,
   8.502843970e-01,  8.505579503e-01,  8.508312974e-01,  8.511044381e-01,
   8.513773722e-01,  8.516500997e-01,  8.519226203e-01,  8.521949338e-01,
   8.524670402e-01,  8.527389392e-01,  8.530106307e-01,  8.532821146e-01,
   8.535533906e-01,  8.538244586e-01,  8.540953185e-01,  8.543659701e-01,
   8.546364132e-01,  8.549066477e-01,  8.551766734e-01,  8.554464902e-01,
   8.557160979e-01,  8.559854963e-01,  8.562546853e-01,  8.565236647e-01,
   8.567924344e-01,  8.570609942e-01,  8.573293439e-01,  8.575974835e-01,
   8.578654126e-01,  8.581331313e-01,  8.584006393e-01,  8.586679364e-01,
   8.589350225e-01,  8.592018975e-01,  8.594685612e-01,  8.597350134e-01,
   8.600012540e-01,  8.602672828e-01,  8.605330997e-01,  8.607987044e-01,
   8.610640970e-01,  8.613292771e-01,  8.615942447e-01,  8.618589995e-01,
   8.621235415e-01,  8.623878704e-01,  8.626519862e-01,  8.629158886e-01,
   8.631795775e-01,  8.634430528e-01,  8.637063143e-01,  8.639693618e-01,
   8.642321952e-01,  8.644948144e-01,  8.647572191e-01,  8.650194092e-01,
   8.652813846e-01,  8.655431451e-01,  8.658046906e-01,  8.660660209e-01,
   8.663271358e-01,  8.665880353e-01,  8.668487191e-01,  8.671091870e-01,
   8.673694390e-01,  8.676294749e-01,  8.678892946e-01,  8.681488978e-01,
   8.684082844e-01,  8.686674544e-01,  8.689264074e-01,  8.691851434e-01,
   8.694436622e-01,  8.697019637e-01,  8.699600477e-01,  8.702179141e-01,
   8.704755627e-01,  8.707329933e-01,  8.709902059e-01,  8.712472002e-01,
   8.715039761e-01,  8.717605334e-01,  8.720168721e-01,  8.722729919e-01,
   8.725288927e-01,  8.727845744e-01,  8.730400368e-01,  8.732952797e-01,
   8.735503030e-01,  8.738051066e-01,  8.740596902e-01,  8.743140538e-01,
   8.745681973e-01,  8.748221203e-01,  8.750758229e-01,  8.753293048e-01,
   8.755825660e-01,  8.758356061e-01,  8.760884252e-01,  8.763410231e-01,
   8.765933995e-01,  8.768455544e-01,  8.770974877e-01,  8.773491990e-01,
   8.776006884e-01,  8.778519557e-01,  8.781030007e-01,  8.783538233e-01,
   8.786044233e-01,  8.788548005e-01,  8.791049549e-01,  8.793548863e-01,
   8.796045945e-01,  8.798540794e-01,  8.801033408e-01,  8.803523787e-01,
   8.806011927e-01,  8.808497829e-01,  8.810981491e-01,  8.813462910e-01,
   8.815942086e-01,  8.818419018e-01,  8.820893703e-01,  8.823366140e-01,
   8.825836328e-01,  8.828304266e-01,  8.830769951e-01,  8.833233383e-01,
   8.835694560e-01,  8.838153480e-01,  8.840610143e-01,  8.843064546e-01,
   8.845516688e-01,  8.847966568e-01,  8.850414185e-01,  8.852859536e-01,
   8.855302621e-01,  8.857743438e-01,  8.860181986e-01,  8.862618262e-01,
   8.865052267e-01,  8.867483997e-01,  8.869913453e-01,  8.872340632e-01,
   8.874765533e-01,  8.877188155e-01,  8.879608495e-01,  8.882026554e-01,
   8.884442328e-01,  8.886855818e-01,  8.889267021e-01,  8.891675936e-01,
   8.894082562e-01,  8.896486897e-01,  8.898888940e-01,  8.901288689e-01,
   8.903686143e-01,  8.906081301e-01,  8.908474160e-01,  8.910864721e-01,
   8.913252981e-01,  8.915638939e-01,  8.918022593e-01,  8.920403943e-01,
   8.922782986e-01,  8.925159721e-01,  8.927534148e-01,  8.929906264e-01,
   8.932276068e-01,  8.934643559e-01,  8.937008735e-01,  8.939371595e-01,
   8.941732138e-01,  8.944090362e-01,  8.946446266e-01,  8.948799848e-01,
   8.951151107e-01,  8.953500042e-01,  8.955846651e-01,  8.958190933e-01,
   8.960532887e-01,  8.962872510e-01,  8.965209802e-01,  8.967544762e-01,
   8.969877388e-01,  8.972207678e-01,  8.974535632e-01,  8.976861247e-01,
   8.979184523e-01,  8.981505458e-01,  8.983824051e-01,  8.986140300e-01,
   8.988454205e-01,  8.990765763e-01,  8.993074973e-01,  8.995381835e-01,
   8.997686346e-01,  8.999988505e-01,  9.002288311e-01,  9.004585763e-01,
   9.006880859e-01,  9.009173597e-01,  9.011463978e-01,  9.013751998e-01,
   9.016037657e-01,  9.018320954e-01,  9.020601887e-01,  9.022880455e-01,
   9.025156656e-01,  9.027430489e-01,  9.029701953e-01,  9.031971046e-01,
   9.034237768e-01,  9.036502116e-01,  9.038764090e-01,  9.041023687e-01,
   9.043280908e-01,  9.045535750e-01,  9.047788212e-01,  9.050038293e-01,
   9.052285991e-01,  9.054531306e-01,  9.056774235e-01,  9.059014778e-01,
   9.061252933e-01,  9.063488699e-01,  9.065722074e-01,  9.067953058e-01,
   9.070181649e-01,  9.072407845e-01,  9.074631645e-01,  9.076853049e-01,
   9.079072054e-01,  9.081288660e-01,  9.083502864e-01,  9.085714667e-01,
   9.087924066e-01,  9.090131060e-01,  9.092335648e-01,  9.094537828e-01,
   9.096737600e-01,  9.098934962e-01,  9.101129913e-01,  9.103322451e-01,
   9.105512575e-01,  9.107700284e-01,  9.109885576e-01,  9.112068451e-01,
   9.114248907e-01,  9.116426942e-01,  9.118602556e-01,  9.120775747e-01,
   9.122946514e-01,  9.125114855e-01,  9.127280770e-01,  9.129444257e-01,
   9.131605314e-01,  9.133763941e-01,  9.135920136e-01,  9.138073898e-01,
   9.140225226e-01,  9.142374119e-01,  9.144520574e-01,  9.146664591e-01,
   9.148806169e-01,  9.150945306e-01,  9.153082002e-01,  9.155216254e-01,
   9.157348062e-01,  9.159477424e-01,  9.161604339e-01,  9.163728806e-01,
   9.165850824e-01,  9.167970390e-01,  9.170087506e-01,  9.172202167e-01,
   9.174314375e-01,  9.176424127e-01,  9.178531422e-01,  9.180636259e-01,
   9.182738636e-01,  9.184838553e-01,  9.186936008e-01,  9.189031000e-01,
   9.191123528e-01,  9.193213590e-01,  9.195301185e-01,  9.197386313e-01,
   9.199468971e-01,  9.201549159e-01,  9.203626875e-01,  9.205702118e-01,
   9.207774887e-01,  9.209845181e-01,  9.211912998e-01,  9.213978338e-01,
   9.216041198e-01,  9.218101579e-01,  9.220159477e-01,  9.222214894e-01,
   9.224267826e-01,  9.226318274e-01,  9.228366235e-01,  9.230411709e-01,
   9.232454694e-01,  9.234495189e-01,  9.236533193e-01,  9.238568705e-01,
   9.240601724e-01,  9.242632248e-01,  9.244660276e-01,  9.246685807e-01,
   9.248708840e-01,  9.250729373e-01,  9.252747406e-01,  9.254762937e-01,
   9.256775966e-01,  9.258786489e-01,  9.260794508e-01,  9.262800020e-01,
   9.264803025e-01,  9.266803520e-01,  9.268801506e-01,  9.270796980e-01,
   9.272789942e-01,  9.274780390e-01,  9.276768324e-01,  9.278753741e-01,
   9.280736642e-01,  9.282717024e-01,  9.284694887e-01,  9.286670229e-01,
   9.288643050e-01,  9.290613348e-01,  9.292581121e-01,  9.294546370e-01,
   9.296509092e-01,  9.298469286e-01,  9.300426952e-01,  9.302382088e-01,
   9.304334693e-01,  9.306284766e-01,  9.308232306e-01,  9.310177311e-01,
   9.312119781e-01,  9.314059713e-01,  9.315997109e-01,  9.317931965e-01,
   9.319864281e-01,  9.321794055e-01,  9.323721288e-01,  9.325645976e-01,
   9.327568120e-01,  9.329487719e-01,  9.331404770e-01,  9.333319273e-01,
   9.335231228e-01,  9.337140631e-01,  9.339047484e-01,  9.340951784e-01,
   9.342853530e-01,  9.344752721e-01,  9.346649357e-01,  9.348543435e-01,
   9.350434956e-01,  9.352323917e-01,  9.354210317e-01,  9.356094157e-01,
   9.357975433e-01,  9.359854146e-01,  9.361730294e-01,  9.363603877e-01,
   9.365474892e-01,  9.367343339e-01,  9.369209217e-01,  9.371072525e-01,
   9.372933261e-01,  9.374791425e-01,  9.376647016e-01,  9.378500031e-01,
   9.380350471e-01,  9.382198334e-01,  9.384043619e-01,  9.385886325e-01,
   9.387726451e-01,  9.389563996e-01,  9.391398958e-01,  9.393231337e-01,
   9.395061132e-01,  9.396888341e-01,  9.398712964e-01,  9.400534999e-01,
   9.402354445e-01,  9.404171302e-01,  9.405985567e-01,  9.407797241e-01,
   9.409606322e-01,  9.411412808e-01,  9.413216700e-01,  9.415017995e-01,
   9.416816693e-01,  9.418612793e-01,  9.420406294e-01,  9.422197194e-01,
   9.423985492e-01,  9.425771188e-01,  9.427554281e-01,  9.429334769e-01,
   9.431112651e-01,  9.432887926e-01,  9.434660594e-01,  9.436430653e-01,
   9.438198102e-01,  9.439962940e-01,  9.441725167e-01,  9.443484780e-01,
   9.445241779e-01,  9.446996164e-01,  9.448747932e-01,  9.450497083e-01,
   9.452243616e-01,  9.453987530e-01,  9.455728824e-01,  9.457467497e-01,
   9.459203547e-01,  9.460936974e-01,  9.462667777e-01,  9.464395955e-01,
   9.466121506e-01,  9.467844430e-01,  9.469564726e-01,  9.471282392e-01,
   9.472997428e-01,  9.474709833e-01,  9.476419605e-01,  9.478126744e-01,
   9.479831249e-01,  9.481533118e-01,  9.483232351e-01,  9.484928946e-01,
   9.486622904e-01,  9.488314221e-01,  9.490002899e-01,  9.491688935e-01,
   9.493372328e-01,  9.495053079e-01,  9.496731185e-01,  9.498406646e-01,
   9.500079460e-01,  9.501749627e-01,  9.503417146e-01,  9.505082016e-01,
   9.506744235e-01,  9.508403803e-01,  9.510060720e-01,  9.511714982e-01,
   9.513366591e-01,  9.515015545e-01,  9.516661842e-01,  9.518305483e-01,
   9.519946466e-01,  9.521584789e-01,  9.523220453e-01,  9.524853456e-01,
   9.526483797e-01,  9.528111475e-01,  9.529736489e-01,  9.531358839e-01,
   9.532978523e-01,  9.534595540e-01,  9.536209890e-01,  9.537821571e-01,
   9.539430582e-01,  9.541036924e-01,  9.542640594e-01,  9.544241591e-01,
   9.545839915e-01,  9.547435566e-01,  9.549028541e-01,  9.550618839e-01,
   9.552206461e-01,  9.553791405e-01,  9.555373670e-01,  9.556953256e-01,
   9.558530160e-01,  9.560104383e-01,  9.561675923e-01,  9.563244780e-01,
   9.564810952e-01,  9.566374439e-01,  9.567935240e-01,  9.569493353e-01,
   9.571048779e-01,  9.572601515e-01,  9.574151561e-01,  9.575698917e-01,
   9.577243580e-01,  9.578785552e-01,  9.580324829e-01,  9.581861412e-01,
   9.583395300e-01,  9.584926491e-01,  9.586454985e-01,  9.587980781e-01,
   9.589503878e-01,  9.591024275e-01,  9.592541972e-01,  9.594056966e-01,
   9.595569258e-01,  9.597078847e-01,  9.598585731e-01,  9.600089911e-01,
   9.601591384e-01,  9.603090150e-01,  9.604586208e-01,  9.606079557e-01,
   9.607570197e-01,  9.609058126e-01,  9.610543344e-01,  9.612025849e-01,
   9.613505642e-01,  9.614982720e-01,  9.616457084e-01,  9.617928731e-01,
   9.619397663e-01,  9.620863876e-01,  9.622327372e-01,  9.623788148e-01,
   9.625246204e-01,  9.626701539e-01,  9.628154153e-01,  9.629604043e-01,
   9.631051211e-01,  9.632495654e-01,  9.633937372e-01,  9.635376363e-01,
   9.636812628e-01,  9.638246165e-01,  9.639676974e-01,  9.641105053e-01,
   9.642530402e-01,  9.643953020e-01,  9.645372906e-01,  9.646790060e-01,
   9.648204479e-01,  9.649616164e-01,  9.651025114e-01,  9.652431328e-01,
   9.653834805e-01,  9.655235545e-01,  9.656633545e-01,  9.658028807e-01,
   9.659421328e-01,  9.660811108e-01,  9.662198146e-01,  9.663582442e-01,
   9.664963994e-01,  9.666342802e-01,  9.667718865e-01,  9.669092182e-01,
   9.670462752e-01,  9.671830575e-01,  9.673195649e-01,  9.674557974e-01,
   9.675917550e-01,  9.677274374e-01,  9.678628447e-01,  9.679979768e-01,
   9.681328336e-01,  9.682674150e-01,  9.684017209e-01,  9.685357512e-01,
   9.686695060e-01,  9.688029850e-01,  9.689361882e-01,  9.690691156e-01,
   9.692017670e-01,  9.693341424e-01,  9.694662418e-01,  9.695980649e-01,
   9.697296118e-01,  9.698608824e-01,  9.699918765e-01,  9.701225942e-01,
   9.702530353e-01,  9.703831998e-01,  9.705130875e-01,  9.706426985e-01,
   9.707720326e-01,  9.709010897e-01,  9.710298699e-01,  9.711583729e-01,
   9.712865988e-01,  9.714145474e-01,  9.715422187e-01,  9.716696126e-01,
   9.717967291e-01,  9.719235680e-01,  9.720501292e-01,  9.721764128e-01,
   9.723024186e-01,  9.724281466e-01,  9.725535966e-01,  9.726787687e-01,
   9.728036627e-01,  9.729282785e-01,  9.730526162e-01,  9.731766755e-01,
   9.733004565e-01,  9.734239591e-01,  9.735471832e-01,  9.736701287e-01,
   9.737927955e-01,  9.739151836e-01,  9.740372930e-01,  9.741591234e-01,
   9.742806750e-01,  9.744019475e-01,  9.745229409e-01,  9.746436552e-01,
   9.747640903e-01,  9.748842461e-01,  9.750041225e-01,  9.751237195e-01,
   9.752430370e-01,  9.753620749e-01,  9.754808332e-01,  9.755993117e-01,
   9.757175105e-01,  9.758354294e-01,  9.759530684e-01,  9.760704274e-01,
   9.761875064e-01,  9.763043052e-01,  9.764208238e-01,  9.765370622e-01,
   9.766530202e-01,  9.767686978e-01,  9.768840949e-01,  9.769992116e-01,
   9.771140476e-01,  9.772286029e-01,  9.773428775e-01,  9.774568712e-01,
   9.775705842e-01,  9.776840161e-01,  9.777971671e-01,  9.779100369e-01,
   9.780226257e-01,  9.781349332e-01,  9.782469595e-01,  9.783587044e-01,
   9.784701679e-01,  9.785813499e-01,  9.786922504e-01,  9.788028693e-01,
   9.789132065e-01,  9.790232620e-01,  9.791330357e-01,  9.792425275e-01,
   9.793517374e-01,  9.794606654e-01,  9.795693112e-01,  9.796776750e-01,
   9.797857565e-01,  9.798935559e-01,  9.800010729e-01,  9.801083075e-01,
   9.802152597e-01,  9.803219294e-01,  9.804283166e-01,  9.805344211e-01,
   9.806402429e-01,  9.807457820e-01,  9.808510383e-01,  9.809560117e-01,
   9.810607021e-01,  9.811651096e-01,  9.812692340e-01,  9.813730753e-01,
   9.814766334e-01,  9.815799083e-01,  9.816828999e-01,  9.817856081e-01,
   9.818880329e-01,  9.819901742e-01,  9.820920320e-01,  9.821936061e-01,
   9.822948966e-01,  9.823959034e-01,  9.824966264e-01,  9.825970656e-01,
   9.826972208e-01,  9.827970922e-01,  9.828966794e-01,  9.829959826e-01,
   9.830950017e-01,  9.831937366e-01,  9.832921872e-01,  9.833903536e-01,
   9.834882355e-01,  9.835858331e-01,  9.836831461e-01,  9.837801746e-01,
   9.838769185e-01,  9.839733778e-01,  9.840695524e-01,  9.841654422e-01,
   9.842610471e-01,  9.843563672e-01,  9.844514024e-01,  9.845461526e-01,
   9.846406177e-01,  9.847347977e-01,  9.848286926e-01,  9.849223022e-01,
   9.850156266e-01,  9.851086657e-01,  9.852014193e-01,  9.852938876e-01,
   9.853860704e-01,  9.854779676e-01,  9.855695792e-01,  9.856609052e-01,
   9.857519455e-01,  9.858427000e-01,  9.859331687e-01,  9.860233516e-01,
   9.861132485e-01,  9.862028595e-01,  9.862921845e-01,  9.863812233e-01,
   9.864699761e-01,  9.865584427e-01,  9.866466230e-01,  9.867345171e-01,
   9.868221248e-01,  9.869094462e-01,  9.869964811e-01,  9.870832295e-01,
   9.871696914e-01,  9.872558667e-01,  9.873417553e-01,  9.874273573e-01,
   9.875126725e-01,  9.875977010e-01,  9.876824426e-01,  9.877668973e-01,
   9.878510650e-01,  9.879349458e-01,  9.880185395e-01,  9.881018462e-01,
   9.881848657e-01,  9.882675980e-01,  9.883500431e-01,  9.884322009e-01,
   9.885140713e-01,  9.885956544e-01,  9.886769501e-01,  9.887579583e-01,
   9.888386789e-01,  9.889191120e-01,  9.889992575e-01,  9.890791153e-01,
   9.891586854e-01,  9.892379677e-01,  9.893169622e-01,  9.893956689e-01,
   9.894740877e-01,  9.895522185e-01,  9.896300613e-01,  9.897076161e-01,
   9.897848828e-01,  9.898618614e-01,  9.899385518e-01,  9.900149540e-01,
   9.900910680e-01,  9.901668936e-01,  9.902424309e-01,  9.903176798e-01,
   9.903926402e-01,  9.904673122e-01,  9.905416956e-01,  9.906157904e-01,
   9.906895967e-01,  9.907631142e-01,  9.908363431e-01,  9.909092832e-01,
   9.909819346e-01,  9.910542971e-01,  9.911263707e-01,  9.911981554e-01,
   9.912696511e-01,  9.913408579e-01,  9.914117756e-01,  9.914824042e-01,
   9.915527437e-01,  9.916227940e-01,  9.916925552e-01,  9.917620270e-01,
   9.918312096e-01,  9.919001029e-01,  9.919687067e-01,  9.920370212e-01,
   9.921050462e-01,  9.921727817e-01,  9.922402277e-01,  9.923073841e-01,
   9.923742509e-01,  9.924408280e-01,  9.925071155e-01,  9.925731132e-01,
   9.926388212e-01,  9.927042393e-01,  9.927693677e-01,  9.928342061e-01,
   9.928987546e-01,  9.929630131e-01,  9.930269817e-01,  9.930906602e-01,
   9.931540486e-01,  9.932171470e-01,  9.932799551e-01,  9.933424731e-01,
   9.934047009e-01,  9.934666384e-01,  9.935282857e-01,  9.935896425e-01,
   9.936507091e-01,  9.937114852e-01,  9.937719709e-01,  9.938321661e-01,
   9.938920708e-01,  9.939516850e-01,  9.940110086e-01,  9.940700415e-01,
   9.941287839e-01,  9.941872355e-01,  9.942453964e-01,  9.943032666e-01,
   9.943608460e-01,  9.944181345e-01,  9.944751323e-01,  9.945318391e-01,
   9.945882550e-01,  9.946443799e-01,  9.947002139e-01,  9.947557568e-01,
   9.948110087e-01,  9.948659695e-01,  9.949206392e-01,  9.949750178e-01,
   9.950291051e-01,  9.950829013e-01,  9.951364062e-01,  9.951896198e-01,
   9.952425421e-01,  9.952951731e-01,  9.953475127e-01,  9.953995609e-01,
   9.954513177e-01,  9.955027830e-01,  9.955539569e-01,  9.956048392e-01,
   9.956554299e-01,  9.957057291e-01,  9.957557367e-01,  9.958054526e-01,
   9.958548768e-01,  9.959040094e-01,  9.959528502e-01,  9.960013993e-01,
   9.960496566e-01,  9.960976220e-01,  9.961452957e-01,  9.961926774e-01,
   9.962397673e-01,  9.962865652e-01,  9.963330712e-01,  9.963792852e-01,
   9.964252072e-01,  9.964708372e-01,  9.965161751e-01,  9.965612209e-01,
   9.966059746e-01,  9.966504362e-01,  9.966946056e-01,  9.967384828e-01,
   9.967820678e-01,  9.968253605e-01,  9.968683610e-01,  9.969110691e-01,
   9.969534850e-01,  9.969956085e-01,  9.970374397e-01,  9.970789784e-01,
   9.971202247e-01,  9.971611786e-01,  9.972018400e-01,  9.972422090e-01,
   9.972822854e-01,  9.973220692e-01,  9.973615606e-01,  9.974007593e-01,
   9.974396654e-01,  9.974782789e-01,  9.975165997e-01,  9.975546279e-01,
   9.975923633e-01,  9.976298061e-01,  9.976669561e-01,  9.977038133e-01,
   9.977403777e-01,  9.977766494e-01,  9.978126282e-01,  9.978483141e-01,
   9.978837072e-01,  9.979188074e-01,  9.979536147e-01,  9.979881291e-01,
   9.980223505e-01,  9.980562789e-01,  9.980899143e-01,  9.981232567e-01,
   9.981563061e-01,  9.981890624e-01,  9.982215257e-01,  9.982536958e-01,
   9.982855729e-01,  9.983171568e-01,  9.983484476e-01,  9.983794452e-01,
   9.984101496e-01,  9.984405609e-01,  9.984706789e-01,  9.985005037e-01,
   9.985300352e-01,  9.985592734e-01,  9.985882184e-01,  9.986168700e-01,
   9.986452283e-01,  9.986732933e-01,  9.987010650e-01,  9.987285432e-01,
   9.987557281e-01,  9.987826195e-01,  9.988092176e-01,  9.988355222e-01,
   9.988615333e-01,  9.988872510e-01,  9.989126752e-01,  9.989378059e-01,
   9.989626431e-01,  9.989871868e-01,  9.990114369e-01,  9.990353935e-01,
   9.990590565e-01,  9.990824259e-01,  9.991055017e-01,  9.991282839e-01,
   9.991507725e-01,  9.991729674e-01,  9.991948687e-01,  9.992164763e-01,
   9.992377903e-01,  9.992588106e-01,  9.992795371e-01,  9.992999700e-01,
   9.993201091e-01,  9.993399545e-01,  9.993595061e-01,  9.993787640e-01,
   9.993977281e-01,  9.994163984e-01,  9.994347750e-01,  9.994528577e-01,
   9.994706466e-01,  9.994881417e-01,  9.995053429e-01,  9.995222503e-01,
   9.995388639e-01,  9.995551836e-01,  9.995712094e-01,  9.995869413e-01,
   9.996023793e-01,  9.996175234e-01,  9.996323736e-01,  9.996469299e-01,
   9.996611923e-01,  9.996751607e-01,  9.996888352e-01,  9.997022157e-01,
   9.997153023e-01,  9.997280949e-01,  9.997405935e-01,  9.997527981e-01,
   9.997647088e-01,  9.997763254e-01,  9.997876480e-01,  9.997986766e-01,
   9.998094112e-01,  9.998198518e-01,  9.998299984e-01,  9.998398509e-01,
   9.998494093e-01,  9.998586738e-01,  9.998676441e-01,  9.998763204e-01,
   9.998847027e-01,  9.998927908e-01,  9.999005849e-01,  9.999080850e-01,
   9.999152909e-01,  9.999222027e-01,  9.999288205e-01,  9.999351442e-01,
   9.999411737e-01,  9.999469092e-01,  9.999523505e-01,  9.999574978e-01,
   9.999623509e-01,  9.999669099e-01,  9.999711748e-01,  9.999751456e-01,
   9.999788223e-01,  9.999822048e-01,  9.999852932e-01,  9.999880875e-01,
   9.999905876e-01,  9.999927937e-01,  9.999947055e-01,  9.999963233e-01,
   9.999976469e-01,  9.999986764e-01,  9.999994117e-01,  9.999998529e-01,
   1.000000000e+00,
};
const float lut_xfade_in[] = {
   0.000000000e+00,  4.994082069e-02,  1.215722327e-01,  1.919373828e-01,
   2.603033675e-01,  3.259581062e-01,  3.882177576e-01,  4.464338430e-01,
   5.000000000e-01,  5.483582988e-01,  5.910050530e-01,  6.274960661e-01,
   6.574512582e-01,  6.805586243e-01,  6.965774847e-01,  7.053409916e-01,
   7.071067812e-01,
};
const float lut_xfade_out[] = {
   7.071067812e-01,  7.053409916e-01,  6.965774847e-01,  6.805586243e-01,
   6.574512582e-01,  6.274960661e-01,  5.910050530e-01,  5.483582988e-01,
   5.000000000e-01,  4.464338430e-01,  3.882177576e-01,  3.259581062e-01,
   2.603033675e-01,  1.919373828e-01,  1.215722327e-01,  4.994082069e-02,
   4.329780281e-17,
};
const float lut_sine_window_4096[] = {
   0.000000000e+00,  1.725808584e-04,  4.103438160e-04,  6.809730624e-04,
   9.753747396e-04,  1.288775731e-03,  1.618163527e-03,  1.961437906e-03,
   2.317038924e-03,  2.683755658e-03,  3.060616964e-03,  3.446824198e-03,
   3.841707336e-03,  4.244695063e-03,  4.655293609e-03,  5.073071350e-03,
   5.497647286e-03,  5.928682272e-03,  6.365872183e-03,  6.808942527e-03,
   7.257644129e-03,  7.711749628e-03,  8.171050605e-03,  8.635355205e-03,
   9.104486144e-03,  9.578279039e-03,  1.005658098e-02,  1.053924931e-02,
   1.102615059e-02,  1.151715968e-02,  1.201215894e-02,  1.251103757e-02,
   1.301369099e-02,  1.352002029e-02,  1.402993176e-02,  1.454333650e-02,
   1.506015001e-02,  1.558029186e-02,  1.610368539e-02,  1.663025745e-02,
   1.715993811e-02,  1.769266051e-02,  1.822836057e-02,  1.876697690e-02,
   1.930845052e-02,  1.985272482e-02,  2.039974534e-02,  2.094945966e-02,
   2.150181731e-02,  2.205676960e-02,  2.261426959e-02,  2.317427193e-02,
   2.373673281e-02,  2.430160989e-02,  2.486886219e-02,  2.543845002e-02,
   2.601033497e-02,  2.658447977e-02,  2.716084830e-02,  2.773940551e-02,
   2.832011734e-02,  2.890295073e-02,  2.948787356e-02,  3.007485457e-02,
   3.066386336e-02,  3.125487035e-02,  3.184784674e-02,  3.244276446e-02,
   3.303959618e-02,  3.363831523e-02,  3.423889562e-02,  3.484131198e-02,
   3.544553957e-02,  3.605155421e-02,  3.665933231e-02,  3.726885080e-02,
   3.788008714e-02,  3.849301930e-02,  3.910762574e-02,  3.972388538e-02,
   4.034177758e-02,  4.096128217e-02,  4.158237938e-02,  4.220504986e-02,
   4.282927463e-02,  4.345503513e-02,  4.408231313e-02,  4.471109079e-02,
   4.534135061e-02,  4.597307540e-02,  4.660624833e-02,  4.724085286e-02,
   4.787687277e-02,  4.851429213e-02,  4.915309530e-02,  4.979326692e-02,
   5.043479191e-02,  5.107765543e-02,  5.172184292e-02,  5.236734005e-02,
   5.301413276e-02,  5.366220719e-02,  5.431154973e-02,  5.496214699e-02,
   5.561398579e-02,  5.626705318e-02,  5.692133639e-02,  5.757682287e-02,
   5.823350025e-02,  5.889135637e-02,  5.955037923e-02,  6.021055704e-02,
   6.087187815e-02,  6.153433111e-02,  6.219790464e-02,  6.286258760e-02,
   6.352836903e-02,  6.419523811e-02,  6.486318419e-02,  6.553219677e-02,
   6.620226546e-02,  6.687338006e-02,  6.754553048e-02,  6.821870676e-02,
   6.889289910e-02,  6.956809781e-02,  7.024429332e-02,  7.092147621e-02,
   7.159963716e-02,  7.227876697e-02,  7.295885656e-02,  7.363989698e-02,
   7.432187936e-02,  7.500479497e-02,  7.568863515e-02,  7.637339139e-02,
   7.705905524e-02,  7.774561838e-02,  7.843307258e-02,  7.912140969e-02,
   7.981062168e-02,  8.050070060e-02,  8.119163860e-02,  8.188342789e-02,
   8.257606080e-02,  8.326952974e-02,  8.396382719e-02,  8.465894572e-02,
   8.535487798e-02,  8.605161671e-02,  8.674915471e-02,  8.744748488e-02,
   8.814660016e-02,  8.884649359e-02,  8.954715829e-02,  9.024858742e-02,
   9.095077424e-02,  9.165371207e-02,  9.235739428e-02,  9.306181433e-02,
   9.376696573e-02,  9.447284206e-02,  9.517943697e-02,  9.588674416e-02,
   9.659475739e-02,  9.730347049e-02,  9.801287735e-02,  9.872297189e-02,
   9.943374814e-02,  1.001452001e-01,  1.008573220e-01,  1.015701078e-01,
   1.022835519e-01,  1.029976486e-01,  1.037123920e-01,  1.044277766e-01,
   1.051437969e-01,  1.058604473e-01,  1.065777223e-01,  1.072956164e-01,
   1.080141244e-01,  1.087332408e-01,  1.094529604e-01,  1.101732779e-01,
   1.108941881e-01,  1.116156858e-01,  1.123377660e-01,  1.130604235e-01,
   1.137836534e-01,  1.145074506e-01,  1.152318102e-01,  1.159567272e-01,
   1.166821969e-01,  1.174082143e-01,  1.181347746e-01,  1.188618732e-01,
   1.195895052e-01,  1.203176661e-01,  1.210463511e-01,  1.217755556e-01,
   1.225052752e-01,  1.232355051e-01,  1.239662409e-01,  1.246974782e-01,
   1.254292125e-01,  1.261614394e-01,  1.268941544e-01,  1.276273534e-01,
   1.283610319e-01,  1.290951857e-01,  1.298298105e-01,  1.305649021e-01,
   1.313004563e-01,  1.320364690e-01,  1.327729361e-01,  1.335098533e-01,
   1.342472167e-01,  1.349850222e-01,  1.357232658e-01,  1.364619435e-01,
   1.372010514e-01,  1.379405854e-01,  1.386805417e-01,  1.394209165e-01,
   1.401617058e-01,  1.409029058e-01,  1.416445127e-01,  1.423865228e-01,
   1.431289322e-01,  1.438717373e-01,  1.446149343e-01,  1.453585196e-01,
   1.461024894e-01,  1.468468403e-01,  1.475915684e-01,  1.483366703e-01,
   1.490821424e-01,  1.498279811e-01,  1.505741829e-01,  1.513207443e-01,
   1.520676618e-01,  1.528149320e-01,  1.535625514e-01,  1.543105166e-01,
   1.550588242e-01,  1.558074708e-01,  1.565564531e-01,  1.573057677e-01,
   1.580554113e-01,  1.588053807e-01,  1.595556724e-01,  1.603062834e-01,
   1.610572102e-01,  1.618084498e-01,  1.625599989e-01,  1.633118543e-01,
   1.640640128e-01,  1.648164713e-01,  1.655692267e-01,  1.663222759e-01,
   1.670756157e-01,  1.678292431e-01,  1.685831550e-01,  1.693373484e-01,
   1.700918202e-01,  1.708465674e-01,  1.716015871e-01,  1.723568762e-01,
   1.731124318e-01,  1.738682509e-01,  1.746243306e-01,  1.753806681e-01,
   1.761372603e-01,  1.768941044e-01,  1.776511976e-01,  1.784085369e-01,
   1.791661196e-01,  1.799239428e-01,  1.806820037e-01,  1.814402994e-01,
   1.821988274e-01,  1.829575846e-01,  1.837165685e-01,  1.844757762e-01,
   1.852352051e-01,  1.859948524e-01,  1.867547154e-01,  1.875147914e-01,
   1.882750779e-01,  1.890355720e-01,  1.897962712e-01,  1.905571729e-01,
   1.913182743e-01,  1.920795730e-01,  1.928410662e-01,  1.936027516e-01,
   1.943646263e-01,  1.951266880e-01,  1.958889341e-01,  1.966513620e-01,
   1.974139692e-01,  1.981767532e-01,  1.989397115e-01,  1.997028417e-01,
   2.004661412e-01,  2.012296076e-01,  2.019932384e-01,  2.027570313e-01,
   2.035209837e-01,  2.042850934e-01,  2.050493577e-01,  2.058137745e-01,
   2.065783412e-01,  2.073430556e-01,  2.081079152e-01,  2.088729178e-01,
   2.096380609e-01,  2.104033422e-01,  2.111687595e-01,  2.119343104e-01,
   2.126999927e-01,  2.134658039e-01,  2.142317419e-01,  2.149978045e-01,
   2.157639892e-01,  2.165302940e-01,  2.172967165e-01,  2.180632545e-01,
   2.188299058e-01,  2.195966683e-01,  2.203635396e-01,  2.211305177e-01,
   2.218976003e-01,  2.226647853e-01,  2.234320705e-01,  2.241994538e-01,
   2.249669329e-01,  2.257345059e-01,  2.265021705e-01,  2.272699247e-01,
   2.280377663e-01,  2.288056933e-01,  2.295737035e-01,  2.303417949e-01,
   2.311099654e-01,  2.318782130e-01,  2.326465356e-01,  2.334149311e-01,
   2.341833975e-01,  2.349519329e-01,  2.357205351e-01,  2.364892021e-01,
   2.372579320e-01,  2.380267228e-01,  2.387955725e-01,  2.395644790e-01,
   2.403334405e-01,  2.411024550e-01,  2.418715204e-01,  2.426406350e-01,
   2.434097966e-01,  2.441790035e-01,  2.449482536e-01,  2.457175451e-01,
   2.464868761e-01,  2.472562446e-01,  2.480256487e-01,  2.487950867e-01,
   2.495645565e-01,  2.503340564e-01,  2.511035844e-01,  2.518731388e-01,
   2.526427176e-01,  2.534123190e-01,  2.541819412e-01,  2.549515824e-01,
   2.557212408e-01,  2.564909144e-01,  2.572606016e-01,  2.580303006e-01,
   2.588000094e-01,  2.595697265e-01,  2.603394499e-01,  2.611091779e-01,
   2.618789087e-01,  2.626486407e-01,  2.634183720e-01,  2.641881009e-01,
   2.649578256e-01,  2.657275445e-01,  2.664972557e-01,  2.672669577e-01,
   2.680366486e-01,  2.688063268e-01,  2.695759906e-01,  2.703456383e-01,
   2.711152681e-01,  2.718848785e-01,  2.726544677e-01,  2.734240342e-01,
   2.741935761e-01,  2.749630919e-01,  2.757325799e-01,  2.765020386e-01,
   2.772714661e-01,  2.780408610e-01,  2.788102216e-01,  2.795795462e-01,
   2.803488333e-01,  2.811180813e-01,  2.818872886e-01,  2.826564535e-01,
   2.834255745e-01,  2.841946499e-01,  2.849636784e-01,  2.857326581e-01,
   2.865015877e-01,  2.872704655e-01,  2.880392900e-01,  2.888080596e-01,
   2.895767728e-01,  2.903454280e-01,  2.911140238e-01,  2.918825585e-01,
   2.926510308e-01,  2.934194390e-01,  2.941877817e-01,  2.949560573e-01,
   2.957242644e-01,  2.964924015e-01,  2.972604670e-01,  2.980284595e-01,
   2.987963776e-01,  2.995642196e-01,  3.003319843e-01,  3.010996701e-01,
   3.018672756e-01,  3.026347993e-01,  3.034022398e-01,  3.041695956e-01,
   3.049368652e-01,  3.057040474e-01,  3.064711406e-01,  3.072381435e-01,
   3.080050545e-01,  3.087718724e-01,  3.095385956e-01,  3.103052229e-01,
   3.110717527e-01,  3.118381838e-01,  3.126045147e-01,  3.133707441e-01,
   3.141368705e-01,  3.149028926e-01,  3.156688091e-01,  3.164346185e-01,
   3.172003196e-01,  3.179659110e-01,  3.187313912e-01,  3.194967591e-01,
   3.202620132e-01,  3.210271522e-01,  3.217921749e-01,  3.225570797e-01,
   3.233218656e-01,  3.240865310e-01,  3.248510748e-01,  3.256154956e-01,
   3.263797921e-01,  3.271439631e-01,  3.279080072e-01,  3.286719231e-01,
   3.294357096e-01,  3.301993654e-01,  3.309628891e-01,  3.317262797e-01,
   3.324895357e-01,  3.332526559e-01,  3.340156391e-01,  3.347784840e-01,
   3.355411893e-01,  3.363037539e-01,  3.370661765e-01,  3.378284558e-01,
   3.385905906e-01,  3.393525797e-01,  3.401144219e-01,  3.408761160e-01,
   3.416376606e-01,  3.423990547e-01,  3.431602970e-01,  3.439213864e-01,
   3.446823216e-01,  3.454431014e-01,  3.462037246e-01,  3.469641901e-01,
   3.477244967e-01,  3.484846431e-01,  3.492446283e-01,  3.500044511e-01,
   3.507641103e-01,  3.515236046e-01,  3.522829331e-01,  3.530420945e-01,
   3.538010877e-01,  3.545599114e-01,  3.553185647e-01,  3.560770463e-01,
   3.568353552e-01,  3.575934901e-01,  3.583514500e-01,  3.591092337e-01,
   3.598668402e-01,  3.606242682e-01,  3.613815167e-01,  3.621385847e-01,
   3.628954709e-01,  3.636521743e-01,  3.644086938e-01,  3.651650283e-01,
   3.659211767e-01,  3.666771379e-01,  3.674329108e-01,  3.681884945e-01,
   3.689438877e-01,  3.696990894e-01,  3.704540986e-01,  3.712089141e-01,
   3.719635351e-01,  3.727179602e-01,  3.734721886e-01,  3.742262192e-01,
   3.749800509e-01,  3.757336827e-01,  3.764871135e-01,  3.772403423e-01,
   3.779933682e-01,  3.787461899e-01,  3.794988066e-01,  3.802512173e-01,
   3.810034207e-01,  3.817554161e-01,  3.825072023e-01,  3.832587784e-01,
   3.840101434e-01,  3.847612962e-01,  3.855122358e-01,  3.862629613e-01,
   3.870134717e-01,  3.877637659e-01,  3.885138430e-01,  3.892637021e-01,
   3.900133421e-01,  3.907627620e-01,  3.915119610e-01,  3.922609379e-01,
   3.930096920e-01,  3.937582221e-01,  3.945065273e-01,  3.952546068e-01,
   3.960024594e-01,  3.967500844e-01,  3.974974806e-01,  3.982446473e-01,
   3.989915834e-01,  3.997382881e-01,  4.004847603e-01,  4.012309992e-01,
   4.019770037e-01,  4.027227731e-01,  4.034683064e-01,  4.042136027e-01,
   4.049586610e-01,  4.057034804e-01,  4.064480600e-01,  4.071923990e-01,
   4.079364964e-01,  4.086803513e-01,  4.094239628e-01,  4.101673300e-01,
   4.109104521e-01,  4.116533282e-01,  4.123959573e-01,  4.131383385e-01,
   4.138804711e-01,  4.146223541e-01,  4.153639866e-01,  4.161053679e-01,
   4.168464969e-01,  4.175873729e-01,  4.183279950e-01,  4.190683622e-01,
   4.198084739e-01,  4.205483291e-01,  4.212879269e-01,  4.220272666e-01,
   4.227663472e-01,  4.235051680e-01,  4.242437280e-01,  4.249820265e-01,
   4.257200626e-01,  4.264578355e-01,  4.271953443e-01,  4.279325883e-01,
   4.286695666e-01,  4.294062784e-01,  4.301427228e-01,  4.308788991e-01,
   4.316148065e-01,  4.323504440e-01,  4.330858110e-01,  4.338209066e-01,
   4.345557300e-01,  4.352902805e-01,  4.360245571e-01,  4.367585592e-01,
   4.374922859e-01,  4.382257365e-01,  4.389589101e-01,  4.396918060e-01,
   4.404244234e-01,  4.411567615e-01,  4.418888195e-01,  4.426205967e-01,
   4.433520923e-01,  4.440833056e-01,  4.448142356e-01,  4.455448818e-01,
   4.462752433e-01,  4.470053194e-01,  4.477351093e-01,  4.484646122e-01,
   4.491938275e-01,  4.499227543e-01,  4.506513919e-01,  4.513797396e-01,
   4.521077967e-01,  4.528355623e-01,  4.535630358e-01,  4.542902164e-01,
   4.550171034e-01,  4.557436960e-01,  4.564699936e-01,  4.571959953e-01,
   4.579217006e-01,  4.586471086e-01,  4.593722186e-01,  4.600970300e-01,
   4.608215420e-01,  4.615457539e-01,  4.622696649e-01,  4.629932745e-01,
   4.637165818e-01,  4.644395862e-01,  4.651622870e-01,  4.658846835e-01,
   4.666067749e-01,  4.673285607e-01,  4.680500400e-01,  4.687712123e-01,
   4.694920767e-01,  4.702126327e-01,  4.709328796e-01,  4.716528166e-01,
   4.723724432e-01,  4.730917585e-01,  4.738107620e-01,  4.745294530e-01,
   4.752478308e-01,  4.759658947e-01,  4.766836441e-01,  4.774010784e-01,
   4.781181967e-01,  4.788349986e-01,  4.795514833e-01,  4.802676501e-01,
   4.809834985e-01,  4.816990278e-01,  4.824142373e-01,  4.831291264e-01,
   4.838436944e-01,  4.845579407e-01,  4.852718647e-01,  4.859854657e-01,
   4.866987430e-01,  4.874116961e-01,  4.881243243e-01,  4.888366270e-01,
   4.895486036e-01,  4.902602534e-01,  4.909715757e-01,  4.916825701e-01,
   4.923932358e-01,  4.931035723e-01,  4.938135788e-01,  4.945232549e-01,
   4.952325999e-01,  4.959416132e-01,  4.966502941e-01,  4.973586421e-01,
   4.980666566e-01,  4.987743369e-01,  4.994816825e-01,  5.001886927e-01,
   5.008953670e-01,  5.016017047e-01,  5.023077053e-01,  5.030133682e-01,
   5.037186928e-01,  5.044236785e-01,  5.051283247e-01,  5.058326308e-01,
   5.065365962e-01,  5.072402204e-01,  5.079435028e-01,  5.086464428e-01,
   5.093490398e-01,  5.100512932e-01,  5.107532026e-01,  5.114547672e-01,
   5.121559865e-01,  5.128568601e-01,  5.135573872e-01,  5.142575674e-01,
   5.149574000e-01,  5.156568846e-01,  5.163560205e-01,  5.170548072e-01,
   5.177532441e-01,  5.184513307e-01,  5.191490665e-01,  5.198464508e-01,
   5.205434832e-01,  5.212401631e-01,  5.219364899e-01,  5.226324631e-01,
   5.233280821e-01,  5.240233465e-01,  5.247182556e-01,  5.254128090e-01,
   5.261070060e-01,  5.268008462e-01,  5.274943291e-01,  5.281874540e-01,
   5.288802206e-01,  5.295726281e-01,  5.302646762e-01,  5.309563642e-01,
   5.316476917e-01,  5.323386582e-01,  5.330292630e-01,  5.337195058e-01,
   5.344093860e-01,  5.350989030e-01,  5.357880563e-01,  5.364768455e-01,
   5.371652700e-01,  5.378533294e-01,  5.385410230e-01,  5.392283504e-01,
   5.399153112e-01,  5.406019047e-01,  5.412881305e-01,  5.419739881e-01,
   5.426594769e-01,  5.433445965e-01,  5.440293465e-01,  5.447137262e-01,
   5.453977352e-01,  5.460813730e-01,  5.467646391e-01,  5.474475330e-01,
   5.481300543e-01,  5.488122024e-01,  5.494939768e-01,  5.501753771e-01,
   5.508564028e-01,  5.515370534e-01,  5.522173284e-01,  5.528972274e-01,
   5.535767498e-01,  5.542558952e-01,  5.549346631e-01,  5.556130530e-01,
   5.562910645e-01,  5.569686971e-01,  5.576459503e-01,  5.583228237e-01,
   5.589993167e-01,  5.596754290e-01,  5.603511599e-01,  5.610265092e-01,
   5.617014763e-01,  5.623760608e-01,  5.630502621e-01,  5.637240799e-01,
   5.643975136e-01,  5.650705629e-01,  5.657432272e-01,  5.664155062e-01,
   5.670873993e-01,  5.677589061e-01,  5.684300262e-01,  5.691007590e-01,
   5.697711042e-01,  5.704410614e-01,  5.711106299e-01,  5.717798095e-01,
   5.724485997e-01,  5.731170000e-01,  5.737850100e-01,  5.744526292e-01,
   5.751198572e-01,  5.757866936e-01,  5.764531379e-01,  5.771191897e-01,
   5.777848485e-01,  5.784501140e-01,  5.791149856e-01,  5.797794630e-01,
   5.804435458e-01,  5.811072334e-01,  5.817705255e-01,  5.824334216e-01,
   5.830959213e-01,  5.837580243e-01,  5.844197299e-01,  5.850810379e-01,
   5.857419479e-01,  5.864024593e-01,  5.870625718e-01,  5.877222849e-01,
   5.883815982e-01,  5.890405114e-01,  5.896990240e-01,  5.903571355e-01,
   5.910148457e-01,  5.916721539e-01,  5.923290599e-01,  5.929855633e-01,
   5.936416635e-01,  5.942973602e-01,  5.949526531e-01,  5.956075416e-01,
   5.962620254e-01,  5.969161041e-01,  5.975697773e-01,  5.982230445e-01,
   5.988759054e-01,  5.995283595e-01,  6.001804065e-01,  6.008320459e-01,
   6.014832774e-01,  6.021341006e-01,  6.027845150e-01,  6.034345203e-01,
   6.040841160e-01,  6.047333018e-01,  6.053820773e-01,  6.060304420e-01,
   6.066783957e-01,  6.073259378e-01,  6.079730680e-01,  6.086197860e-01,
   6.092660912e-01,  6.099119834e-01,  6.105574621e-01,  6.112025270e-01,
   6.118471777e-01,  6.124914137e-01,  6.131352348e-01,  6.137786404e-01,
   6.144216303e-01,  6.150642040e-01,  6.157063612e-01,  6.163481014e-01,
   6.169894244e-01,  6.176303297e-01,  6.182708169e-01,  6.189108857e-01,
   6.195505357e-01,  6.201897665e-01,  6.208285777e-01,  6.214669690e-01,
   6.221049400e-01,  6.227424903e-01,  6.233796195e-01,  6.240163272e-01,
   6.246526132e-01,  6.252884770e-01,  6.259239182e-01,  6.265589366e-01,
   6.271935316e-01,  6.278277030e-01,  6.284614503e-01,  6.290947733e-01,
   6.297276714e-01,  6.303601445e-01,  6.309921921e-01,  6.316238138e-01,
   6.322550093e-01,  6.328857782e-01,  6.335161202e-01,  6.341460348e-01,
   6.347755218e-01,  6.354045808e-01,  6.360332113e-01,  6.366614131e-01,
   6.372891858e-01,  6.379165291e-01,  6.385434425e-01,  6.391699257e-01,
   6.397959784e-01,  6.404216001e-01,  6.410467907e-01,  6.416715496e-01,
   6.422958765e-01,  6.429197711e-01,  6.435432331e-01,  6.441662620e-01,
   6.447888576e-01,  6.454110194e-01,  6.460327471e-01,  6.466540404e-01,
   6.472748989e-01,  6.478953223e-01,  6.485153102e-01,  6.491348623e-01,
   6.497539782e-01,  6.503726576e-01,  6.509909001e-01,  6.516087053e-01,
   6.522260730e-01,  6.528430028e-01,  6.534594943e-01,  6.540755472e-01,
   6.546911612e-01,  6.553063359e-01,  6.559210709e-01,  6.565353660e-01,
   6.571492207e-01,  6.577626347e-01,  6.583756078e-01,  6.589881395e-01,
   6.596002295e-01,  6.602118775e-01,  6.608230831e-01,  6.614338460e-01,
   6.620441658e-01,  6.626540422e-01,  6.632634749e-01,  6.638724636e-01,
   6.644810078e-01,  6.650891073e-01,  6.656967617e-01,  6.663039707e-01,
   6.669107339e-01,  6.675170511e-01,  6.681229218e-01,  6.687283458e-01,
   6.693333226e-01,  6.699378521e-01,  6.705419337e-01,  6.711455673e-01,
   6.717487524e-01,  6.723514888e-01,  6.729537760e-01,  6.735556139e-01,
   6.741570019e-01,  6.747579399e-01,  6.753584275e-01,  6.759584642e-01,
   6.765580499e-01,  6.771571842e-01,  6.777558667e-01,  6.783540972e-01,
   6.789518752e-01,  6.795492005e-01,  6.801460727e-01,  6.807424915e-01,
   6.813384566e-01,  6.819339676e-01,  6.825290242e-01,  6.831236262e-01,
   6.837177731e-01,  6.843114646e-01,  6.849047004e-01,  6.854974802e-01,
   6.860898037e-01,  6.866816704e-01,  6.872730802e-01,  6.878640327e-01,
   6.884545275e-01,  6.890445643e-01,  6.896341428e-01,  6.902232627e-01,
   6.908119236e-01,  6.914001253e-01,  6.919878673e-01,  6.925751494e-01,
   6.931619713e-01,  6.937483326e-01,  6.943342330e-01,  6.949196721e-01,
   6.955046498e-01,  6.960891655e-01,  6.966732191e-01,  6.972568101e-01,
   6.978399383e-01,  6.984226034e-01,  6.990048049e-01,  6.995865427e-01,
   7.001678163e-01,  7.007486255e-01,  7.013289700e-01,  7.019088493e-01,
   7.024882632e-01,  7.030672114e-01,  7.036456935e-01,  7.042237093e-01,
   7.048012583e-01,  7.053783404e-01,  7.059549551e-01,  7.065311021e-01,
   7.071067812e-01,  7.076819920e-01,  7.082567341e-01,  7.088310073e-01,
   7.094048113e-01,  7.099781456e-01,  7.105510101e-01,  7.111234044e-01,
   7.116953281e-01,  7.122667810e-01,  7.128377627e-01,  7.134082729e-01,
   7.139783113e-01,  7.145478775e-01,  7.151169713e-01,  7.156855923e-01,
   7.162537403e-01,  7.168214148e-01,  7.173886156e-01,  7.179553424e-01,
   7.185215948e-01,  7.190873725e-01,  7.196526752e-01,  7.202175026e-01,
   7.207818544e-01,  7.213457302e-01,  7.219091297e-01,  7.224720526e-01,
   7.230344986e-01,  7.235964674e-01,  7.241579587e-01,  7.247189720e-01,
   7.252795072e-01,  7.258395639e-01,  7.263991418e-01,  7.269582405e-01,
   7.275168598e-01,  7.280749993e-01,  7.286326587e-01,  7.291898377e-01,
   7.297465360e-01,  7.303027532e-01,  7.308584891e-01,  7.314137433e-01,
   7.319685154e-01,  7.325228053e-01,  7.330766125e-01,  7.336299368e-01,
   7.341827778e-01,  7.347351352e-01,  7.352870087e-01,  7.358383979e-01,
   7.363893027e-01,  7.369397225e-01,  7.374896572e-01,  7.380391064e-01,
   7.385880697e-01,  7.391365469e-01,  7.396845377e-01,  7.402320417e-01,
   7.407790586e-01,  7.413255881e-01,  7.418716298e-01,  7.424171835e-01,
   7.429622489e-01,  7.435068255e-01,  7.440509131e-01,  7.445945115e-01,
   7.451376201e-01,  7.456802389e-01,  7.462223673e-01,  7.467640051e-01,
   7.473051520e-01,  7.478458077e-01,  7.483859718e-01,  7.489256441e-01,
   7.494648241e-01,  7.500035116e-01,  7.505417063e-01,  7.510794078e-01,
   7.516166159e-01,  7.521533301e-01,  7.526895503e-01,  7.532252760e-01,
   7.537605069e-01,  7.542952428e-01,  7.548294832e-01,  7.553632280e-01,
   7.558964767e-01,  7.564292290e-01,  7.569614847e-01,  7.574932433e-01,
   7.580245047e-01,  7.585552684e-01,  7.590855341e-01,  7.596153015e-01,
   7.601445703e-01,  7.606733402e-01,  7.612016109e-01,  7.617293819e-01,
   7.622566531e-01,  7.627834241e-01,  7.633096945e-01,  7.638354640e-01,
   7.643607324e-01,  7.648854992e-01,  7.654097642e-01,  7.659335271e-01,
   7.664567874e-01,  7.669795450e-01,  7.675017995e-01,  7.680235505e-01,
   7.685447977e-01,  7.690655408e-01,  7.695857795e-01,  7.701055135e-01,
   7.706247424e-01,  7.711434659e-01,  7.716616837e-01,  7.721793954e-01,
   7.726966008e-01,  7.732132995e-01,  7.737294912e-01,  7.742451755e-01,
   7.747603521e-01,  7.752750208e-01,  7.757891811e-01,  7.763028328e-01,
   7.768159755e-01,  7.773286089e-01,  7.778407327e-01,  7.783523466e-01,
   7.788634501e-01,  7.793740431e-01,  7.798841251e-01,  7.803936959e-01,
   7.809027550e-01,  7.814113023e-01,  7.819193373e-01,  7.824268597e-01,
   7.829338693e-01,  7.834403656e-01,  7.839463483e-01,  7.844518172e-01,
   7.849567719e-01,  7.854612120e-01,  7.859651372e-01,  7.864685473e-01,
   7.869714418e-01,  7.874738204e-01,  7.879756829e-01,  7.884770288e-01,
   7.889778579e-01,  7.894781698e-01,  7.899779642e-01,  7.904772407e-01,
   7.909759991e-01,  7.914742390e-01,  7.919719600e-01,  7.924691619e-01,
   7.929658442e-01,  7.934620067e-01,  7.939576491e-01,  7.944527709e-01,
   7.949473720e-01,  7.954414518e-01,  7.959350102e-01,  7.964280468e-01,
   7.969205611e-01,  7.974125530e-01,  7.979040221e-01,  7.983949680e-01,
   7.988853904e-01,  7.993752889e-01,  7.998646633e-01,  8.003535132e-01,
   8.008418383e-01,  8.013296382e-01,  8.018169126e-01,  8.023036611e-01,
   8.027898835e-01,  8.032755793e-01,  8.037607483e-01,  8.042453902e-01,
   8.047295045e-01,  8.052130909e-01,  8.056961492e-01,  8.061786789e-01,
   8.066606797e-01,  8.071421514e-01,  8.076230935e-01,  8.081035057e-01,
   8.085833877e-01,  8.090627391e-01,  8.095415597e-01,  8.100198490e-01,
   8.104976067e-01,  8.109748326e-01,  8.114515261e-01,  8.119276871e-01,
   8.124033152e-01,  8.128784100e-01,  8.133529712e-01,  8.138269984e-01,
   8.143004913e-01,  8.147734496e-01,  8.152458730e-01,  8.157177610e-01,
   8.161891134e-01,  8.166599298e-01,  8.171302099e-01,  8.175999532e-01,
   8.180691596e-01,  8.185378286e-01,  8.190059599e-01,  8.194735532e-01,
   8.199406080e-01,  8.204071242e-01,  8.208731013e-01,  8.213385389e-01,
   8.218034368e-01,  8.222677946e-01,  8.227316120e-01,  8.231948885e-01,
   8.236576240e-01,  8.241198180e-01,  8.245814701e-01,  8.250425801e-01,
   8.255031475e-01,  8.259631722e-01,  8.264226536e-01,  8.268815915e-01,
   8.273399854e-01,  8.277978352e-01,  8.282551404e-01,  8.287119006e-01,
   8.291681156e-01,  8.296237850e-01,  8.300789083e-01,  8.305334854e-01,
   8.309875159e-01,  8.314409993e-01,  8.318939354e-01,  8.323463237e-01,
   8.327981641e-01,  8.332494560e-01,  8.337001992e-01,  8.341503934e-01,
   8.346000380e-01,  8.350491329e-01,  8.354976777e-01,  8.359456720e-01,
   8.363931155e-01,  8.368400078e-01,  8.372863485e-01,  8.377321374e-01,
   8.381773741e-01,  8.386220582e-01,  8.390661894e-01,  8.395097673e-01,
   8.399527916e-01,  8.403952619e-01,  8.408371779e-01,  8.412785393e-01,
   8.417193456e-01,  8.421595966e-01,  8.425992918e-01,  8.430384310e-01,
   8.434770137e-01,  8.439150397e-01,  8.443525086e-01,  8.447894199e-01,
   8.452257735e-01,  8.456615689e-01,  8.460968058e-01,  8.465314838e-01,
   8.469656025e-01,  8.473991617e-01,  8.478321610e-01,  8.482646000e-01,
   8.486964783e-01,  8.491277957e-01,  8.495585517e-01,  8.499887460e-01,
   8.504183783e-01,  8.508474482e-01,  8.512759554e-01,  8.517038995e-01,
   8.521312801e-01,  8.525580969e-01,  8.529843495e-01,  8.534100377e-01,
   8.538351610e-01,  8.542597190e-01,  8.546837115e-01,  8.551071381e-01,
   8.555299984e-01,  8.559522921e-01,  8.563740188e-01,  8.567951782e-01,
   8.572157699e-01,  8.576357936e-01,  8.580552488e-01,  8.584741354e-01,
   8.588924528e-01,  8.593102008e-01,  8.597273789e-01,  8.601439869e-01,
   8.605600244e-01,  8.609754911e-01,  8.613903865e-01,  8.618047104e-01,
   8.622184623e-01,  8.626316419e-01,  8.630442489e-01,  8.634562830e-01,
   8.638677436e-01,  8.642786306e-01,  8.646889436e-01,  8.650986821e-01,
   8.655078459e-01,  8.659164346e-01,  8.663244478e-01,  8.667318852e-01,
   8.671387465e-01,  8.675450312e-01,  8.679507390e-01,  8.683558696e-01,
   8.687604227e-01,  8.691643978e-01,  8.695677946e-01,  8.699706127e-01,
   8.703728519e-01,  8.707745117e-01,  8.711755918e-01,  8.715760919e-01,
   8.719760116e-01,  8.723753504e-01,  8.727741082e-01,  8.731722845e-01,
   8.735698790e-01,  8.739668913e-01,  8.743633211e-01,  8.747591681e-01,
   8.751544317e-01,  8.755491118e-01,  8.759432080e-01,  8.763367199e-01,
   8.767296471e-01,  8.771219894e-01,  8.775137463e-01,  8.779049175e-01,
   8.782955026e-01,  8.786855014e-01,  8.790749134e-01,  8.794637383e-01,
   8.798519758e-01,  8.802396255e-01,  8.806266870e-01,  8.810131600e-01,
   8.813990441e-01,  8.817843390e-01,  8.821690444e-01,  8.825531599e-01,
   8.829366851e-01,  8.833196197e-01,  8.837019634e-01,  8.840837157e-01,
   8.844648764e-01,  8.848454451e-01,  8.852254214e-01,  8.856048051e-01,
   8.859835956e-01,  8.863617928e-01,  8.867393963e-01,  8.871164056e-01,
   8.874928205e-01,  8.878686406e-01,  8.882438656e-01,  8.886184951e-01,
   8.889925287e-01,  8.893659662e-01,  8.897388072e-01,  8.901110513e-01,
   8.904826981e-01,  8.908537474e-01,  8.912241988e-01,  8.915940520e-01,
   8.919633065e-01,  8.923319621e-01,  8.927000185e-01,  8.930674752e-01,
   8.934343319e-01,  8.938005883e-01,  8.941662440e-01,  8.945312988e-01,
   8.948957522e-01,  8.952596039e-01,  8.956228535e-01,  8.959855008e-01,
   8.963475454e-01,  8.967089870e-01,  8.970698251e-01,  8.974300595e-01,
   8.977896899e-01,  8.981487158e-01,  8.985071370e-01,  8.988649531e-01,
   8.992221637e-01,  8.995787686e-01,  8.999347674e-01,  9.002901597e-01,
   9.006449453e-01,  9.009991237e-01,  9.013526947e-01,  9.017056579e-01,
   9.020580130e-01,  9.024097596e-01,  9.027608975e-01,  9.031114262e-01,
   9.034613454e-01,  9.038106549e-01,  9.041593542e-01,  9.045074431e-01,
   9.048549211e-01,  9.052017881e-01,  9.055480436e-01,  9.058936873e-01,
   9.062387189e-01,  9.065831381e-01,  9.069269445e-01,  9.072701378e-01,
   9.076127176e-01,  9.079546838e-01,  9.082960358e-01,  9.086367734e-01,
   9.089768963e-01,  9.093164041e-01,  9.096552966e-01,  9.099935733e-01,
   9.103312340e-01,  9.106682784e-01,  9.110047060e-01,  9.113405167e-01,
   9.116757101e-01,  9.120102858e-01,  9.123442435e-01,  9.126775830e-01,
   9.130103038e-01,  9.133424058e-01,  9.136738885e-01,  9.140047516e-01,
   9.143349949e-01,  9.146646180e-01,  9.149936206e-01,  9.153220024e-01,
   9.156497630e-01,  9.159769022e-01,  9.163034196e-01,  9.166293150e-01,
   9.169545879e-01,  9.172792382e-01,  9.176032655e-01,  9.179266695e-01,
   9.182494498e-01,  9.185716063e-01,  9.188931385e-01,  9.192140461e-01,
   9.195343289e-01,  9.198539865e-01,  9.201730187e-01,  9.204914252e-01,
   9.208092055e-01,  9.211263595e-01,  9.214428869e-01,  9.217587872e-01,
   9.220740603e-01,  9.223887059e-01,  9.227027236e-01,  9.230161131e-01,
   9.233288741e-01,  9.236410064e-01,  9.239525097e-01,  9.242633836e-01,
   9.245736279e-01,  9.248832422e-01,  9.251922264e-01,  9.255005800e-01,
   9.258083028e-01,  9.261153946e-01,  9.264218550e-01,  9.267276837e-01,
   9.270328804e-01,  9.273374450e-01,  9.276413770e-01,  9.279446762e-01,
   9.282473424e-01,  9.285493751e-01,  9.288507743e-01,  9.291515395e-01,
   9.294516705e-01,  9.297511670e-01,  9.300500288e-01,  9.303482555e-01,
   9.306458470e-01,  9.309428028e-01,  9.312391228e-01,  9.315348067e-01,
   9.318298542e-01,  9.321242650e-01,  9.324180389e-01,  9.327111756e-01,
   9.330036749e-01,  9.332955364e-01,  9.335867599e-01,  9.338773452e-01,
   9.341672919e-01,  9.344565999e-01,  9.347452688e-01,  9.350332984e-01,
   9.353206885e-01,  9.356074388e-01,  9.358935490e-01,  9.361790189e-01,
   9.364638482e-01,  9.367480367e-01,  9.370315841e-01,  9.373144902e-01,
   9.375967547e-01,  9.378783774e-01,  9.381593580e-01,  9.384396964e-01,
   9.387193922e-01,  9.389984451e-01,  9.392768551e-01,  9.395546218e-01,
   9.398317450e-01,  9.401082244e-01,  9.403840598e-01,  9.406592511e-01,
   9.409337979e-01,  9.412077000e-01,  9.414809571e-01,  9.417535692e-01,
   9.420255359e-01,  9.422968570e-01,  9.425675322e-01,  9.428375615e-01,
   9.431069444e-01,  9.433756809e-01,  9.436437707e-01,  9.439112136e-01,
   9.441780093e-01,  9.444441577e-01,  9.447096585e-01,  9.449745115e-01,
   9.452387166e-01,  9.455022734e-01,  9.457651818e-01,  9.460274417e-01,
   9.462890527e-01,  9.465500147e-01,  9.468103275e-01,  9.470699908e-01,
   9.473290046e-01,  9.475873685e-01,  9.478450824e-01,  9.481021461e-01,
   9.483585594e-01,  9.486143222e-01,  9.488694341e-01,  9.491238951e-01,
   9.493777049e-01,  9.496308634e-01,  9.498833704e-01,  9.501352257e-01,
   9.503864291e-01,  9.506369805e-01,  9.508868796e-01,  9.511361263e-01,
   9.513847205e-01,  9.516326619e-01,  9.518799504e-01,  9.521265858e-01,
   9.523725680e-01,  9.526178967e-01,  9.528625719e-01,  9.531065933e-01,
   9.533499609e-01,  9.535926744e-01,  9.538347337e-01,  9.540761386e-01,
   9.543168891e-01,  9.545569848e-01,  9.547964258e-01,  9.550352119e-01,
   9.552733428e-01,  9.555108185e-01,  9.557476388e-01,  9.559838036e-01,
   9.562193128e-01,  9.564541662e-01,  9.566883637e-01,  9.569219051e-01,
   9.571547903e-01,  9.573870193e-01,  9.576185918e-01,  9.578495078e-01,
   9.580797672e-01,  9.583093697e-01,  9.585383154e-01,  9.587666040e-01,
   9.589942355e-01,  9.592212098e-01,  9.594475267e-01,  9.596731862e-01,
   9.598981882e-01,  9.601225325e-01,  9.603462190e-01,  9.605692477e-01,
   9.607916184e-01,  9.610133312e-01,  9.612343858e-01,  9.614547821e-01,
   9.616745202e-01,  9.618935999e-01,  9.621120211e-01,  9.623297838e-01,
   9.625468879e-01,  9.627633333e-01,  9.629791199e-01,  9.631942476e-01,
   9.634087165e-01,  9.636225264e-01,  9.638356772e-01,  9.640481690e-01,
   9.642600016e-01,  9.644711750e-01,  9.646816891e-01,  9.648915439e-01,
   9.651007394e-01,  9.653092754e-01,  9.655171520e-01,  9.657243691e-01,
   9.659309267e-01,  9.661368247e-01,  9.663420631e-01,  9.665466418e-01,
   9.667505609e-01,  9.669538203e-01,  9.671564200e-01,  9.673583600e-01,
   9.675596402e-01,  9.677602606e-01,  9.679602212e-01,  9.681595221e-01,
   9.683581631e-01,  9.685561444e-01,  9.687534658e-01,  9.689501275e-01,
   9.691461293e-01,  9.693414713e-01,  9.695361536e-01,  9.697301760e-01,
   9.699235387e-01,  9.701162416e-01,  9.703082848e-01,  9.704996683e-01,
   9.706903921e-01,  9.708804563e-01,  9.710698608e-01,  9.712586057e-01,
   9.714466911e-01,  9.716341170e-01,  9.718208834e-01,  9.720069903e-01,
   9.721924379e-01,  9.723772262e-01,  9.725613551e-01,  9.727448249e-01,
   9.729276355e-01,  9.731097870e-01,  9.732912795e-01,  9.734721130e-01,
   9.736522876e-01,  9.738318034e-01,  9.740106605e-01,  9.741888589e-01,
   9.743663988e-01,  9.745432802e-01,  9.747195032e-01,  9.748950679e-01,
   9.750699744e-01,  9.752442228e-01,  9.754178132e-01,  9.755907458e-01,
   9.757630206e-01,  9.759346377e-01,  9.761055973e-01,  9.762758994e-01,
   9.764455443e-01,  9.766145320e-01,  9.767828626e-01,  9.769505364e-01,
   9.771175534e-01,  9.772839137e-01,  9.774496176e-01,  9.776146652e-01,
   9.777790566e-01,  9.779427919e-01,  9.781058714e-01,  9.782682951e-01,
   9.784300634e-01,  9.785911762e-01,  9.787516339e-01,  9.789114366e-01,
   9.790705844e-01,  9.792290775e-01,  9.793869162e-01,  9.795441006e-01,
   9.797006309e-01,  9.798565074e-01,  9.800117301e-01,  9.801662994e-01,
   9.803202154e-01,  9.804734784e-01,  9.806260885e-01,  9.807780461e-01,
   9.809293512e-01,  9.810800042e-01,  9.812300052e-01,  9.813793546e-01,
   9.815280525e-01,  9.816760993e-01,  9.818234951e-01,  9.819702401e-01,
   9.821163348e-01,  9.822617793e-01,  9.824065738e-01,  9.825507187e-01,
   9.826942143e-01,  9.828370608e-01,  9.829792584e-01,  9.831208075e-01,
   9.832617085e-01,  9.834019614e-01,  9.835415668e-01,  9.836805248e-01,
   9.838188358e-01,  9.839565000e-01,  9.840935179e-01,  9.842298897e-01,
   9.843656158e-01,  9.845006964e-01,  9.846351320e-01,  9.847689228e-01,
   9.849020692e-01,  9.850345716e-01,  9.851664303e-01,  9.852976456e-01,
   9.854282179e-01,  9.855581477e-01,  9.856874352e-01,  9.858160808e-01,
   9.859440849e-01,  9.860714480e-01,  9.861981703e-01,  9.863242524e-01,
   9.864496945e-01,  9.865744971e-01,  9.866986606e-01,  9.868221854e-01,
   9.869450719e-01,  9.870673207e-01,  9.871889320e-01,  9.873099063e-01,
   9.874302441e-01,  9.875499458e-01,  9.876690119e-01,  9.877874427e-01,
   9.879052389e-01,  9.880224008e-01,  9.881389289e-01,  9.882548237e-01,
   9.883700857e-01,  9.884847153e-01,  9.885987131e-01,  9.887120795e-01,
   9.888248150e-01,  9.889369203e-01,  9.890483956e-01,  9.891592417e-01,
   9.892694590e-01,  9.893790481e-01,  9.894880094e-01,  9.895963436e-01,
   9.897040511e-01,  9.898111326e-01,  9.899175885e-01,  9.900234195e-01,
   9.901286261e-01,  9.902332089e-01,  9.903371685e-01,  9.904405055e-01,
   9.905432204e-01,  9.906453139e-01,  9.907467866e-01,  9.908476390e-01,
   9.909478719e-01,  9.910474858e-01,  9.911464813e-01,  9.912448592e-01,
   9.913426200e-01,  9.914397644e-01,  9.915362930e-01,  9.916322065e-01,
   9.917275057e-01,  9.918221911e-01,  9.919162634e-01,  9.920097233e-01,
   9.921025716e-01,  9.921948090e-01,  9.922864360e-01,  9.923774535e-01,
   9.924678622e-01,  9.925576628e-01,  9.926468561e-01,  9.927354427e-01,
   9.928234235e-01,  9.929107992e-01,  9.929975705e-01,  9.930837383e-01,
   9.931693033e-01,  9.932542662e-01,  9.933386280e-01,  9.934223894e-01,
   9.935055512e-01,  9.935881142e-01,  9.936700792e-01,  9.937514471e-01,
   9.938322188e-01,  9.939123950e-01,  9.939919766e-01,  9.940709644e-01,
   9.941493595e-01,  9.942271625e-01,  9.943043745e-01,  9.943809962e-01,
   9.944570287e-01,  9.945324728e-01,  9.946073294e-01,  9.946815995e-01,
   9.947552840e-01,  9.948283838e-01,  9.949008999e-01,  9.949728332e-01,
   9.950441848e-01,  9.951149556e-01,  9.951851465e-01,  9.952547587e-01,
   9.953237930e-01,  9.953922505e-01,  9.954601322e-01,  9.955274392e-01,
   9.955941724e-01,  9.956603330e-01,  9.957259220e-01,  9.957909404e-01,
   9.958553894e-01,  9.959192701e-01,  9.959825834e-01,  9.960453306e-01,
   9.961075127e-01,  9.961691309e-01,  9.962301863e-01,  9.962906801e-01,
   9.963506134e-01,  9.964099874e-01,  9.964688032e-01,  9.965270621e-01,
   9.965847652e-01,  9.966419137e-01,  9.966985090e-01,  9.967545521e-01,
   9.968100444e-01,  9.968649871e-01,  9.969193815e-01,  9.969732287e-01,
   9.970265302e-01,  9.970792873e-01,  9.971315011e-01,  9.971831731e-01,
   9.972343046e-01,  9.972848969e-01,  9.973349514e-01,  9.973844694e-01,
   9.974334524e-01,  9.974819017e-01,  9.975298187e-01,  9.975772049e-01,
   9.976240617e-01,  9.976703905e-01,  9.977161928e-01,  9.977614700e-01,
   9.978062237e-01,  9.978504553e-01,  9.978941664e-01,  9.979373585e-01,
   9.979800330e-01,  9.980221917e-01,  9.980638360e-01,  9.981049675e-01,
   9.981455878e-01,  9.981856986e-01,  9.982253014e-01,  9.982643979e-01,
   9.983029898e-01,  9.983410787e-01,  9.983786664e-01,  9.984157544e-01,
   9.984523447e-01,  9.984884388e-01,  9.985240386e-01,  9.985591457e-01,
   9.985937621e-01,  9.986278895e-01,  9.986615297e-01,  9.986946846e-01,
   9.987273561e-01,  9.987595459e-01,  9.987912561e-01,  9.988224885e-01,
   9.988532450e-01,  9.988835277e-01,  9.989133384e-01,  9.989426792e-01,
   9.989715521e-01,  9.989999591e-01,  9.990279023e-01,  9.990553838e-01,
   9.990824056e-01,  9.991089699e-01,  9.991350788e-01,  9.991607345e-01,
   9.991859391e-01,  9.992106950e-01,  9.992350042e-01,  9.992588691e-01,
   9.992822919e-01,  9.993052751e-01,  9.993278208e-01,  9.993499314e-01,
   9.993716094e-01,  9.993928572e-01,  9.994136771e-01,  9.994340717e-01,
   9.994540435e-01,  9.994735950e-01,  9.994927287e-01,  9.995114472e-01,
   9.995297532e-01,  9.995476493e-01,  9.995651381e-01,  9.995822225e-01,
   9.995989050e-01,  9.996151887e-01,  9.996310761e-01,  9.996465703e-01,
   9.996616740e-01,  9.996763903e-01,  9.996907220e-01,  9.997046723e-01,
   9.997182441e-01,  9.997314405e-01,  9.997442647e-01,  9.997567199e-01,
   9.997688092e-01,  9.997805360e-01,  9.997919035e-01,  9.998029152e-01,
   9.998135745e-01,  9.998238848e-01,  9.998338496e-01,  9.998434726e-01,
   9.998527574e-01,  9.998617077e-01,  9.998703273e-01,  9.998786199e-01,
   9.998865895e-01,  9.998942401e-01,  9.999015757e-01,  9.999086003e-01,
   9.999153183e-01,  9.999217339e-01,  9.999278514e-01,  9.999336753e-01,
   9.999392102e-01,  9.999444606e-01,  9.999494313e-01,  9.999541272e-01,
   9.999585533e-01,  9.999627146e-01,  9.999666164e-01,  9.999702640e-01,
   9.999736630e-01,  9.999768189e-01,  9.999797376e-01,  9.999824252e-01,
   9.999848878e-01,  9.999871319e-01,  9.999891641e-01,  9.999909912e-01,
   9.999926206e-01,  9.999940597e-01,  9.999953163e-01,  9.999963987e-01,
   9.999973157e-01,  9.999980764e-01,  9.999986908e-01,  9.999991695e-01,
   9.999995243e-01,  9.999997681e-01,  9.999999158e-01,  9.999999851e-01,
   1.000000000e+00,  9.999999851e-01,  9.999999158e-01,  9.999997681e-01,
   9.999995243e-01,  9.999991695e-01,  9.999986908e-01,  9.999980764e-01,
   9.999973157e-01,  9.999963987e-01,  9.999953163e-01,  9.999940597e-01,
   9.999926206e-01,  9.999909912e-01,  9.999891641e-01,  9.999871319e-01,
   9.999848878e-01,  9.999824252e-01,  9.999797376e-01,  9.999768189e-01,
   9.999736630e-01,  9.999702640e-01,  9.999666164e-01,  9.999627146e-01,
   9.999585533e-01,  9.999541272e-01,  9.999494313e-01,  9.999444606e-01,
   9.999392102e-01,  9.999336753e-01,  9.999278514e-01,  9.999217339e-01,
   9.999153183e-01,  9.999086003e-01,  9.999015757e-01,  9.998942401e-01,
   9.998865895e-01,  9.998786199e-01,  9.998703273e-01,  9.998617077e-01,
   9.998527574e-01,  9.998434726e-01,  9.998338496e-01,  9.998238848e-01,
   9.998135745e-01,  9.998029152e-01,  9.997919035e-01,  9.997805360e-01,
   9.997688092e-01,  9.997567199e-01,  9.997442647e-01,  9.997314405e-01,
   9.997182441e-01,  9.997046723e-01,  9.996907220e-01,  9.996763903e-01,
   9.996616740e-01,  9.996465703e-01,  9.996310761e-01,  9.996151887e-01,
   9.995989050e-01,  9.995822225e-01,  9.995651381e-01,  9.995476493e-01,
   9.995297532e-01,  9.995114472e-01,  9.994927287e-01,  9.994735950e-01,
   9.994540435e-01,  9.994340717e-01,  9.994136771e-01,  9.993928572e-01,
   9.993716094e-01,  9.993499314e-01,  9.993278208e-01,  9.993052751e-01,
   9.992822919e-01,  9.992588691e-01,  9.992350042e-01,  9.992106950e-01,
   9.991859391e-01,  9.991607345e-01,  9.991350788e-01,  9.991089699e-01,
   9.990824056e-01,  9.990553838e-01,  9.990279023e-01,  9.989999591e-01,
   9.989715521e-01,  9.989426792e-01,  9.989133384e-01,  9.988835277e-01,
   9.988532450e-01,  9.988224885e-01,  9.987912561e-01,  9.987595459e-01,
   9.987273561e-01,  9.986946846e-01,  9.986615297e-01,  9.986278895e-01,
   9.985937621e-01,  9.985591457e-01,  9.985240386e-01,  9.984884388e-01,
   9.984523447e-01,  9.984157544e-01,  9.983786664e-01,  9.983410787e-01,
   9.983029898e-01,  9.982643979e-01,  9.982253014e-01,  9.981856986e-01,
   9.981455878e-01,  9.981049675e-01,  9.980638360e-01,  9.980221917e-01,
   9.979800330e-01,  9.979373585e-01,  9.978941664e-01,  9.978504553e-01,
   9.978062237e-01,  9.977614700e-01,  9.977161928e-01,  9.976703905e-01,
   9.976240617e-01,  9.975772049e-01,  9.975298187e-01,  9.974819017e-01,
   9.974334524e-01,  9.973844694e-01,  9.973349514e-01,  9.972848969e-01,
   9.972343046e-01,  9.971831731e-01,  9.971315011e-01,  9.970792873e-01,
   9.970265302e-01,  9.969732287e-01,  9.969193815e-01,  9.968649871e-01,
   9.968100444e-01,  9.967545521e-01,  9.966985090e-01,  9.966419137e-01,
   9.965847652e-01,  9.965270621e-01,  9.964688032e-01,  9.964099874e-01,
   9.963506134e-01,  9.962906801e-01,  9.962301863e-01,  9.961691309e-01,
   9.961075127e-01,  9.960453306e-01,  9.959825834e-01,  9.959192701e-01,
   9.958553894e-01,  9.957909404e-01,  9.957259220e-01,  9.956603330e-01,
   9.955941724e-01,  9.955274392e-01,  9.954601322e-01,  9.953922505e-01,
   9.953237930e-01,  9.952547587e-01,  9.951851465e-01,  9.951149556e-01,
   9.950441848e-01,  9.949728332e-01,  9.949008999e-01,  9.948283838e-01,
   9.947552840e-01,  9.946815995e-01,  9.946073294e-01,  9.945324728e-01,
   9.944570287e-01,  9.943809962e-01,  9.943043745e-01,  9.942271625e-01,
   9.941493595e-01,  9.940709644e-01,  9.939919766e-01,  9.939123950e-01,
   9.938322188e-01,  9.937514471e-01,  9.936700792e-01,  9.935881142e-01,
   9.935055512e-01,  9.934223894e-01,  9.933386280e-01,  9.932542662e-01,
   9.931693033e-01,  9.930837383e-01,  9.929975705e-01,  9.929107992e-01,
   9.928234235e-01,  9.927354427e-01,  9.926468561e-01,  9.925576628e-01,
   9.924678622e-01,  9.923774535e-01,  9.922864360e-01,  9.921948090e-01,
   9.921025716e-01,  9.920097233e-01,  9.919162634e-01,  9.918221911e-01,
   9.917275057e-01,  9.916322065e-01,  9.915362930e-01,  9.914397644e-01,
   9.913426200e-01,  9.912448592e-01,  9.911464813e-01,  9.910474858e-01,
   9.909478719e-01,  9.908476390e-01,  9.907467866e-01,  9.906453139e-01,
   9.905432204e-01,  9.904405055e-01,  9.903371685e-01,  9.902332089e-01,
   9.901286261e-01,  9.900234195e-01,  9.899175885e-01,  9.898111326e-01,
   9.897040511e-01,  9.895963436e-01,  9.894880094e-01,  9.893790481e-01,
   9.892694590e-01,  9.891592417e-01,  9.890483956e-01,  9.889369203e-01,
   9.888248150e-01,  9.887120795e-01,  9.885987131e-01,  9.884847153e-01,
   9.883700857e-01,  9.882548237e-01,  9.881389289e-01,  9.880224008e-01,
   9.879052389e-01,  9.877874427e-01,  9.876690119e-01,  9.875499458e-01,
   9.874302441e-01,  9.873099063e-01,  9.871889320e-01,  9.870673207e-01,
   9.869450719e-01,  9.868221854e-01,  9.866986606e-01,  9.865744971e-01,
   9.864496945e-01,  9.863242524e-01,  9.861981703e-01,  9.860714480e-01,
   9.859440849e-01,  9.858160808e-01,  9.856874352e-01,  9.855581477e-01,
   9.854282179e-01,  9.852976456e-01,  9.851664303e-01,  9.850345716e-01,
   9.849020692e-01,  9.847689228e-01,  9.846351320e-01,  9.845006964e-01,
   9.843656158e-01,  9.842298897e-01,  9.840935179e-01,  9.839565000e-01,
   9.838188358e-01,  9.836805248e-01,  9.835415668e-01,  9.834019614e-01,
   9.832617085e-01,  9.831208075e-01,  9.829792584e-01,  9.828370608e-01,
   9.826942143e-01,  9.825507187e-01,  9.824065738e-01,  9.822617793e-01,
   9.821163348e-01,  9.819702401e-01,  9.818234951e-01,  9.816760993e-01,
   9.815280525e-01,  9.813793546e-01,  9.812300052e-01,  9.810800042e-01,
   9.809293512e-01,  9.807780461e-01,  9.806260885e-01,  9.804734784e-01,
   9.803202154e-01,  9.801662994e-01,  9.800117301e-01,  9.798565074e-01,
   9.797006309e-01,  9.795441006e-01,  9.793869162e-01,  9.792290775e-01,
   9.790705844e-01,  9.789114366e-01,  9.787516339e-01,  9.785911762e-01,
   9.784300634e-01,  9.782682951e-01,  9.781058714e-01,  9.779427919e-01,
   9.777790566e-01,  9.776146652e-01,  9.774496176e-01,  9.772839137e-01,
   9.771175534e-01,  9.769505364e-01,  9.767828626e-01,  9.766145320e-01,
   9.764455443e-01,  9.762758994e-01,  9.761055973e-01,  9.759346377e-01,
   9.757630206e-01,  9.755907458e-01,  9.754178132e-01,  9.752442228e-01,
   9.750699744e-01,  9.748950679e-01,  9.747195032e-01,  9.745432802e-01,
   9.743663988e-01,  9.741888589e-01,  9.740106605e-01,  9.738318034e-01,
   9.736522876e-01,  9.734721130e-01,  9.732912795e-01,  9.731097870e-01,
   9.729276355e-01,  9.727448249e-01,  9.725613551e-01,  9.723772262e-01,
   9.721924379e-01,  9.720069903e-01,  9.718208834e-01,  9.716341170e-01,
   9.714466911e-01,  9.712586057e-01,  9.710698608e-01,  9.708804563e-01,
   9.706903921e-01,  9.704996683e-01,  9.703082848e-01,  9.701162416e-01,
   9.699235387e-01,  9.697301760e-01,  9.695361536e-01,  9.693414713e-01,
   9.691461293e-01,  9.689501275e-01,  9.687534658e-01,  9.685561444e-01,
   9.683581631e-01,  9.681595221e-01,  9.679602212e-01,  9.677602606e-01,
   9.675596402e-01,  9.673583600e-01,  9.671564200e-01,  9.669538203e-01,
   9.667505609e-01,  9.665466418e-01,  9.663420631e-01,  9.661368247e-01,
   9.659309267e-01,  9.657243691e-01,  9.655171520e-01,  9.653092754e-01,
   9.651007394e-01,  9.648915439e-01,  9.646816891e-01,  9.644711750e-01,
   9.642600016e-01,  9.640481690e-01,  9.638356772e-01,  9.636225264e-01,
   9.634087165e-01,  9.631942476e-01,  9.629791199e-01,  9.627633333e-01,
   9.625468879e-01,  9.623297838e-01,  9.621120211e-01,  9.618935999e-01,
   9.616745202e-01,  9.614547821e-01,  9.612343858e-01,  9.610133312e-01,
   9.607916184e-01,  9.605692477e-01,  9.603462190e-01,  9.601225325e-01,
   9.598981882e-01,  9.596731862e-01,  9.594475267e-01,  9.592212098e-01,
   9.589942355e-01,  9.587666040e-01,  9.585383154e-01,  9.583093697e-01,
   9.580797672e-01,  9.578495078e-01,  9.576185918e-01,  9.573870193e-01,
   9.571547903e-01,  9.569219051e-01,  9.566883637e-01,  9.564541662e-01,
   9.562193128e-01,  9.559838036e-01,  9.557476388e-01,  9.555108185e-01,
   9.552733428e-01,  9.550352119e-01,  9.547964258e-01,  9.545569848e-01,
   9.543168891e-01,  9.540761386e-01,  9.538347337e-01,  9.535926744e-01,
   9.533499609e-01,  9.531065933e-01,  9.528625719e-01,  9.526178967e-01,
   9.523725680e-01,  9.521265858e-01,  9.518799504e-01,  9.516326619e-01,
   9.513847205e-01,  9.511361263e-01,  9.508868796e-01,  9.506369805e-01,
   9.503864291e-01,  9.501352257e-01,  9.498833704e-01,  9.496308634e-01,
   9.493777049e-01,  9.491238951e-01,  9.488694341e-01,  9.486143222e-01,
   9.483585594e-01,  9.481021461e-01,  9.478450824e-01,  9.475873685e-01,
   9.473290046e-01,  9.470699908e-01,  9.468103275e-01,  9.465500147e-01,
   9.462890527e-01,  9.460274417e-01,  9.457651818e-01,  9.455022734e-01,
   9.452387166e-01,  9.449745115e-01,  9.447096585e-01,  9.444441577e-01,
   9.441780093e-01,  9.439112136e-01,  9.436437707e-01,  9.433756809e-01,
   9.431069444e-01,  9.428375615e-01,  9.425675322e-01,  9.422968570e-01,
   9.420255359e-01,  9.417535692e-01,  9.414809571e-01,  9.412077000e-01,
   9.409337979e-01,  9.406592511e-01,  9.403840598e-01,  9.401082244e-01,
   9.398317450e-01,  9.395546218e-01,  9.392768551e-01,  9.389984451e-01,
   9.387193922e-01,  9.384396964e-01,  9.381593580e-01,  9.378783774e-01,
   9.375967547e-01,  9.373144902e-01,  9.370315841e-01,  9.367480367e-01,
   9.364638482e-01,  9.361790189e-01,  9.358935490e-01,  9.356074388e-01,
   9.353206885e-01,  9.350332984e-01,  9.347452688e-01,  9.344565999e-01,
   9.341672919e-01,  9.338773452e-01,  9.335867599e-01,  9.332955364e-01,
   9.330036749e-01,  9.327111756e-01,  9.324180389e-01,  9.321242650e-01,
   9.318298542e-01,  9.315348067e-01,  9.312391228e-01,  9.309428028e-01,
   9.306458470e-01,  9.303482555e-01,  9.300500288e-01,  9.297511670e-01,
   9.294516705e-01,  9.291515395e-01,  9.288507743e-01,  9.285493751e-01,
   9.282473424e-01,  9.279446762e-01,  9.276413770e-01,  9.273374450e-01,
   9.270328804e-01,  9.267276837e-01,  9.264218550e-01,  9.261153946e-01,
   9.258083028e-01,  9.255005800e-01,  9.251922264e-01,  9.248832422e-01,
   9.245736279e-01,  9.242633836e-01,  9.239525097e-01,  9.236410064e-01,
   9.233288741e-01,  9.230161131e-01,  9.227027236e-01,  9.223887059e-01,
   9.220740603e-01,  9.217587872e-01,  9.214428869e-01,  9.211263595e-01,
   9.208092055e-01,  9.204914252e-01,  9.201730187e-01,  9.198539865e-01,
   9.195343289e-01,  9.192140461e-01,  9.188931385e-01,  9.185716063e-01,
   9.182494498e-01,  9.179266695e-01,  9.176032655e-01,  9.172792382e-01,
   9.169545879e-01,  9.166293150e-01,  9.163034196e-01,  9.159769022e-01,
   9.156497630e-01,  9.153220024e-01,  9.149936206e-01,  9.146646180e-01,
   9.143349949e-01,  9.140047516e-01,  9.136738885e-01,  9.133424058e-01,
   9.130103038e-01,  9.126775830e-01,  9.123442435e-01,  9.120102858e-01,
   9.116757101e-01,  9.113405167e-01,  9.110047060e-01,  9.106682784e-01,
   9.103312340e-01,  9.099935733e-01,  9.096552966e-01,  9.093164041e-01,
   9.089768963e-01,  9.086367734e-01,  9.082960358e-01,  9.079546838e-01,
   9.076127176e-01,  9.072701378e-01,  9.069269445e-01,  9.065831381e-01,
   9.062387189e-01,  9.058936873e-01,  9.055480436e-01,  9.052017881e-01,
   9.048549211e-01,  9.045074431e-01,  9.041593542e-01,  9.038106549e-01,
   9.034613454e-01,  9.031114262e-01,  9.027608975e-01,  9.024097596e-01,
   9.020580130e-01,  9.017056579e-01,  9.013526947e-01,  9.009991237e-01,
   9.006449453e-01,  9.002901597e-01,  8.999347674e-01,  8.995787686e-01,
   8.992221637e-01,  8.988649531e-01,  8.985071370e-01,  8.981487158e-01,
   8.977896899e-01,  8.974300595e-01,  8.970698251e-01,  8.967089870e-01,
   8.963475454e-01,  8.959855008e-01,  8.956228535e-01,  8.952596039e-01,
   8.948957522e-01,  8.945312988e-01,  8.941662440e-01,  8.938005883e-01,
   8.934343319e-01,  8.930674752e-01,  8.927000185e-01,  8.923319621e-01,
   8.919633065e-01,  8.915940520e-01,  8.912241988e-01,  8.908537474e-01,
   8.904826981e-01,  8.901110513e-01,  8.897388072e-01,  8.893659662e-01,
   8.889925287e-01,  8.886184951e-01,  8.882438656e-01,  8.878686406e-01,
   8.874928205e-01,  8.871164056e-01,  8.867393963e-01,  8.863617928e-01,
   8.859835956e-01,  8.856048051e-01,  8.852254214e-01,  8.848454451e-01,
   8.844648764e-01,  8.840837157e-01,  8.837019634e-01,  8.833196197e-01,
   8.829366851e-01,  8.825531599e-01,  8.821690444e-01,  8.817843390e-01,
   8.813990441e-01,  8.810131600e-01,  8.806266870e-01,  8.802396255e-01,
   8.798519758e-01,  8.794637383e-01,  8.790749134e-01,  8.786855014e-01,
   8.782955026e-01,  8.779049175e-01,  8.775137463e-01,  8.771219894e-01,
   8.767296471e-01,  8.763367199e-01,  8.759432080e-01,  8.755491118e-01,
   8.751544317e-01,  8.747591681e-01,  8.743633211e-01,  8.739668913e-01,
   8.735698790e-01,  8.731722845e-01,  8.727741082e-01,  8.723753504e-01,
   8.719760116e-01,  8.715760919e-01,  8.711755918e-01,  8.707745117e-01,
   8.703728519e-01,  8.699706127e-01,  8.695677946e-01,  8.691643978e-01,
   8.687604227e-01,  8.683558696e-01,  8.679507390e-01,  8.675450312e-01,
   8.671387465e-01,  8.667318852e-01,  8.663244478e-01,  8.659164346e-01,
   8.655078459e-01,  8.650986821e-01,  8.646889436e-01,  8.642786306e-01,
   8.638677436e-01,  8.634562830e-01,  8.630442489e-01,  8.626316419e-01,
   8.622184623e-01,  8.618047104e-01,  8.613903865e-01,  8.609754911e-01,
   8.605600244e-01,  8.601439869e-01,  8.597273789e-01,  8.593102008e-01,
   8.588924528e-01,  8.584741354e-01,  8.580552488e-01,  8.576357936e-01,
   8.572157699e-01,  8.567951782e-01,  8.563740188e-01,  8.559522921e-01,
   8.555299984e-01,  8.551071381e-01,  8.546837115e-01,  8.542597190e-01,
   8.538351610e-01,  8.534100377e-01,  8.529843495e-01,  8.525580969e-01,
   8.521312801e-01,  8.517038995e-01,  8.512759554e-01,  8.508474482e-01,
   8.504183783e-01,  8.499887460e-01,  8.495585517e-01,  8.491277957e-01,
   8.486964783e-01,  8.482646000e-01,  8.478321610e-01,  8.473991617e-01,
   8.469656025e-01,  8.465314838e-01,  8.460968058e-01,  8.456615689e-01,
   8.452257735e-01,  8.447894199e-01,  8.443525086e-01,  8.439150397e-01,
   8.434770137e-01,  8.430384310e-01,  8.425992918e-01,  8.421595966e-01,
   8.417193456e-01,  8.412785393e-01,  8.408371779e-01,  8.403952619e-01,
   8.399527916e-01,  8.395097673e-01,  8.390661894e-01,  8.386220582e-01,
   8.381773741e-01,  8.377321374e-01,  8.372863485e-01,  8.368400078e-01,
   8.363931155e-01,  8.359456720e-01,  8.354976777e-01,  8.350491329e-01,
   8.346000380e-01,  8.341503934e-01,  8.337001992e-01,  8.332494560e-01,
   8.327981641e-01,  8.323463237e-01,  8.318939354e-01,  8.314409993e-01,
   8.309875159e-01,  8.305334854e-01,  8.300789083e-01,  8.296237850e-01,
   8.291681156e-01,  8.287119006e-01,  8.282551404e-01,  8.277978352e-01,
   8.273399854e-01,  8.268815915e-01,  8.264226536e-01,  8.259631722e-01,
   8.255031475e-01,  8.250425801e-01,  8.245814701e-01,  8.241198180e-01,
   8.236576240e-01,  8.231948885e-01,  8.227316120e-01,  8.222677946e-01,
   8.218034368e-01,  8.213385389e-01,  8.208731013e-01,  8.204071242e-01,
   8.199406080e-01,  8.194735532e-01,  8.190059599e-01,  8.185378286e-01,
   8.180691596e-01,  8.175999532e-01,  8.171302099e-01,  8.166599298e-01,
   8.161891134e-01,  8.157177610e-01,  8.152458730e-01,  8.147734496e-01,
   8.143004913e-01,  8.138269984e-01,  8.133529712e-01,  8.128784100e-01,
   8.124033152e-01,  8.119276871e-01,  8.114515261e-01,  8.109748326e-01,
   8.104976067e-01,  8.100198490e-01,  8.095415597e-01,  8.090627391e-01,
   8.085833877e-01,  8.081035057e-01,  8.076230935e-01,  8.071421514e-01,
   8.066606797e-01,  8.061786789e-01,  8.056961492e-01,  8.052130909e-01,
   8.047295045e-01,  8.042453902e-01,  8.037607483e-01,  8.032755793e-01,
   8.027898835e-01,  8.023036611e-01,  8.018169126e-01,  8.013296382e-01,
   8.008418383e-01,  8.003535132e-01,  7.998646633e-01,  7.993752889e-01,
   7.988853904e-01,  7.983949680e-01,  7.979040221e-01,  7.974125530e-01,
   7.969205611e-01,  7.964280468e-01,  7.959350102e-01,  7.954414518e-01,
   7.949473720e-01,  7.944527709e-01,  7.939576491e-01,  7.934620067e-01,
   7.929658442e-01,  7.924691619e-01,  7.919719600e-01,  7.914742390e-01,
   7.909759991e-01,  7.904772407e-01,  7.899779642e-01,  7.894781698e-01,
   7.889778579e-01,  7.884770288e-01,  7.879756829e-01,  7.874738204e-01,
   7.869714418e-01,  7.864685473e-01,  7.859651372e-01,  7.854612120e-01,
   7.849567719e-01,  7.844518172e-01,  7.839463483e-01,  7.834403656e-01,
   7.829338693e-01,  7.824268597e-01,  7.819193373e-01,  7.814113023e-01,
   7.809027550e-01,  7.803936959e-01,  7.798841251e-01,  7.793740431e-01,
   7.788634501e-01,  7.783523466e-01,  7.778407327e-01,  7.773286089e-01,
   7.768159755e-01,  7.763028328e-01,  7.757891811e-01,  7.752750208e-01,
   7.747603521e-01,  7.742451755e-01,  7.737294912e-01,  7.732132995e-01,
   7.726966008e-01,  7.721793954e-01,  7.716616837e-01,  7.711434659e-01,
   7.706247424e-01,  7.701055135e-01,  7.695857795e-01,  7.690655408e-01,
   7.685447977e-01,  7.680235505e-01,  7.675017995e-01,  7.669795450e-01,
   7.664567874e-01,  7.659335271e-01,  7.654097642e-01,  7.648854992e-01,
   7.643607324e-01,  7.638354640e-01,  7.633096945e-01,  7.627834241e-01,
   7.622566531e-01,  7.617293819e-01,  7.612016109e-01,  7.606733402e-01,
   7.601445703e-01,  7.596153015e-01,  7.590855341e-01,  7.585552684e-01,
   7.580245047e-01,  7.574932433e-01,  7.569614847e-01,  7.564292290e-01,
   7.558964767e-01,  7.553632280e-01,  7.548294832e-01,  7.542952428e-01,
   7.537605069e-01,  7.532252760e-01,  7.526895503e-01,  7.521533301e-01,
   7.516166159e-01,  7.510794078e-01,  7.505417063e-01,  7.500035116e-01,
   7.494648241e-01,  7.489256441e-01,  7.483859718e-01,  7.478458077e-01,
   7.473051520e-01,  7.467640051e-01,  7.462223673e-01,  7.456802389e-01,
   7.451376201e-01,  7.445945115e-01,  7.440509131e-01,  7.435068255e-01,
   7.429622489e-01,  7.424171835e-01,  7.418716298e-01,  7.413255881e-01,
   7.407790586e-01,  7.402320417e-01,  7.396845377e-01,  7.391365469e-01,
   7.385880697e-01,  7.380391064e-01,  7.374896572e-01,  7.369397225e-01,
   7.363893027e-01,  7.358383979e-01,  7.352870087e-01,  7.347351352e-01,
   7.341827778e-01,  7.336299368e-01,  7.330766125e-01,  7.325228053e-01,
   7.319685154e-01,  7.314137433e-01,  7.308584891e-01,  7.303027532e-01,
   7.297465360e-01,  7.291898377e-01,  7.286326587e-01,  7.280749993e-01,
   7.275168598e-01,  7.269582405e-01,  7.263991418e-01,  7.258395639e-01,
   7.252795072e-01,  7.247189720e-01,  7.241579587e-01,  7.235964674e-01,
   7.230344986e-01,  7.224720526e-01,  7.219091297e-01,  7.213457302e-01,
   7.207818544e-01,  7.202175026e-01,  7.196526752e-01,  7.190873725e-01,
   7.185215948e-01,  7.179553424e-01,  7.173886156e-01,  7.168214148e-01,
   7.162537403e-01,  7.156855923e-01,  7.151169713e-01,  7.145478775e-01,
   7.139783113e-01,  7.134082729e-01,  7.128377627e-01,  7.122667810e-01,
   7.116953281e-01,  7.111234044e-01,  7.105510101e-01,  7.099781456e-01,
   7.094048113e-01,  7.088310073e-01,  7.082567341e-01,  7.076819920e-01,
   7.071067812e-01,  7.065311021e-01,  7.059549551e-01,  7.053783404e-01,
   7.048012583e-01,  7.042237093e-01,  7.036456935e-01,  7.030672114e-01,
   7.024882632e-01,  7.019088493e-01,  7.013289700e-01,  7.007486255e-01,
   7.001678163e-01,  6.995865427e-01,  6.990048049e-01,  6.984226034e-01,
   6.978399383e-01,  6.972568101e-01,  6.966732191e-01,  6.960891655e-01,
   6.955046498e-01,  6.949196721e-01,  6.943342330e-01,  6.937483326e-01,
   6.931619713e-01,  6.925751494e-01,  6.919878673e-01,  6.914001253e-01,
   6.908119236e-01,  6.902232627e-01,  6.896341428e-01,  6.890445643e-01,
   6.884545275e-01,  6.878640327e-01,  6.872730802e-01,  6.866816704e-01,
   6.860898037e-01,  6.854974802e-01,  6.849047004e-01,  6.843114646e-01,
   6.837177731e-01,  6.831236262e-01,  6.825290242e-01,  6.819339676e-01,
   6.813384566e-01,  6.807424915e-01,  6.801460727e-01,  6.795492005e-01,
   6.789518752e-01,  6.783540972e-01,  6.777558667e-01,  6.771571842e-01,
   6.765580499e-01,  6.759584642e-01,  6.753584275e-01,  6.747579399e-01,
   6.741570019e-01,  6.735556139e-01,  6.729537760e-01,  6.723514888e-01,
   6.717487524e-01,  6.711455673e-01,  6.705419337e-01,  6.699378521e-01,
   6.693333226e-01,  6.687283458e-01,  6.681229218e-01,  6.675170511e-01,
   6.669107339e-01,  6.663039707e-01,  6.656967617e-01,  6.650891073e-01,
   6.644810078e-01,  6.638724636e-01,  6.632634749e-01,  6.626540422e-01,
   6.620441658e-01,  6.614338460e-01,  6.608230831e-01,  6.602118775e-01,
   6.596002295e-01,  6.589881395e-01,  6.583756078e-01,  6.577626347e-01,
   6.571492207e-01,  6.565353660e-01,  6.559210709e-01,  6.553063359e-01,
   6.546911612e-01,  6.540755472e-01,  6.534594943e-01,  6.528430028e-01,
   6.522260730e-01,  6.516087053e-01,  6.509909001e-01,  6.503726576e-01,
   6.497539782e-01,  6.491348623e-01,  6.485153102e-01,  6.478953223e-01,
   6.472748989e-01,  6.466540404e-01,  6.460327471e-01,  6.454110194e-01,
   6.447888576e-01,  6.441662620e-01,  6.435432331e-01,  6.429197711e-01,
   6.422958765e-01,  6.416715496e-01,  6.410467907e-01,  6.404216001e-01,
   6.397959784e-01,  6.391699257e-01,  6.385434425e-01,  6.379165291e-01,
   6.372891858e-01,  6.366614131e-01,  6.360332113e-01,  6.354045808e-01,
   6.347755218e-01,  6.341460348e-01,  6.335161202e-01,  6.328857782e-01,
   6.322550093e-01,  6.316238138e-01,  6.309921921e-01,  6.303601445e-01,
   6.297276714e-01,  6.290947733e-01,  6.284614503e-01,  6.278277030e-01,
   6.271935316e-01,  6.265589366e-01,  6.259239182e-01,  6.252884770e-01,
   6.246526132e-01,  6.240163272e-01,  6.233796195e-01,  6.227424903e-01,
   6.221049400e-01,  6.214669690e-01,  6.208285777e-01,  6.201897665e-01,
   6.195505357e-01,  6.189108857e-01,  6.182708169e-01,  6.176303297e-01,
   6.169894244e-01,  6.163481014e-01,  6.157063612e-01,  6.150642040e-01,
   6.144216303e-01,  6.137786404e-01,  6.131352348e-01,  6.124914137e-01,
   6.118471777e-01,  6.112025270e-01,  6.105574621e-01,  6.099119834e-01,
   6.092660912e-01,  6.086197860e-01,  6.079730680e-01,  6.073259378e-01,
   6.066783957e-01,  6.060304420e-01,  6.053820773e-01,  6.047333018e-01,
   6.040841160e-01,  6.034345203e-01,  6.027845150e-01,  6.021341006e-01,
   6.014832774e-01,  6.008320459e-01,  6.001804065e-01,  5.995283595e-01,
   5.988759054e-01,  5.982230445e-01,  5.975697773e-01,  5.969161041e-01,
   5.962620254e-01,  5.956075416e-01,  5.949526531e-01,  5.942973602e-01,
   5.936416635e-01,  5.929855633e-01,  5.923290599e-01,  5.916721539e-01,
   5.910148457e-01,  5.903571355e-01,  5.896990240e-01,  5.890405114e-01,
   5.883815982e-01,  5.877222849e-01,  5.870625718e-01,  5.864024593e-01,
   5.857419479e-01,  5.850810379e-01,  5.844197299e-01,  5.837580243e-01,
   5.830959213e-01,  5.824334216e-01,  5.817705255e-01,  5.811072334e-01,
   5.804435458e-01,  5.797794630e-01,  5.791149856e-01,  5.784501140e-01,
   5.777848485e-01,  5.771191897e-01,  5.764531379e-01,  5.757866936e-01,
   5.751198572e-01,  5.744526292e-01,  5.737850100e-01,  5.731170000e-01,
   5.724485997e-01,  5.717798095e-01,  5.711106299e-01,  5.704410614e-01,
   5.697711042e-01,  5.691007590e-01,  5.684300262e-01,  5.677589061e-01,
   5.670873993e-01,  5.664155062e-01,  5.657432272e-01,  5.650705629e-01,
   5.643975136e-01,  5.637240799e-01,  5.630502621e-01,  5.623760608e-01,
   5.617014763e-01,  5.610265092e-01,  5.603511599e-01,  5.596754290e-01,
   5.589993167e-01,  5.583228237e-01,  5.576459503e-01,  5.569686971e-01,
   5.562910645e-01,  5.556130530e-01,  5.549346631e-01,  5.542558952e-01,
   5.535767498e-01,  5.528972274e-01,  5.522173284e-01,  5.515370534e-01,
   5.508564028e-01,  5.501753771e-01,  5.494939768e-01,  5.488122024e-01,
   5.481300543e-01,  5.474475330e-01,  5.467646391e-01,  5.460813730e-01,
   5.453977352e-01,  5.447137262e-01,  5.440293465e-01,  5.433445965e-01,
   5.426594769e-01,  5.419739881e-01,  5.412881305e-01,  5.406019047e-01,
   5.399153112e-01,  5.392283504e-01,  5.385410230e-01,  5.378533294e-01,
   5.371652700e-01,  5.364768455e-01,  5.357880563e-01,  5.350989030e-01,
   5.344093860e-01,  5.337195058e-01,  5.330292630e-01,  5.323386582e-01,
   5.316476917e-01,  5.309563642e-01,  5.302646762e-01,  5.295726281e-01,
   5.288802206e-01,  5.281874540e-01,  5.274943291e-01,  5.268008462e-01,
   5.261070060e-01,  5.254128090e-01,  5.247182556e-01,  5.240233465e-01,
   5.233280821e-01,  5.226324631e-01,  5.219364899e-01,  5.212401631e-01,
   5.205434832e-01,  5.198464508e-01,  5.191490665e-01,  5.184513307e-01,
   5.177532441e-01,  5.170548072e-01,  5.163560205e-01,  5.156568846e-01,
   5.149574000e-01,  5.142575674e-01,  5.135573872e-01,  5.128568601e-01,
   5.121559865e-01,  5.114547672e-01,  5.107532026e-01,  5.100512932e-01,
   5.093490398e-01,  5.086464428e-01,  5.079435028e-01,  5.072402204e-01,
   5.065365962e-01,  5.058326308e-01,  5.051283247e-01,  5.044236785e-01,
   5.037186928e-01,  5.030133682e-01,  5.023077053e-01,  5.016017047e-01,
   5.008953670e-01,  5.001886927e-01,  4.994816825e-01,  4.987743369e-01,
   4.980666566e-01,  4.973586421e-01,  4.966502941e-01,  4.959416132e-01,
   4.952325999e-01,  4.945232549e-01,  4.938135788e-01,  4.931035723e-01,
   4.923932358e-01,  4.916825701e-01,  4.909715757e-01,  4.902602534e-01,
   4.895486036e-01,  4.888366270e-01,  4.881243243e-01,  4.874116961e-01,
   4.866987430e-01,  4.859854657e-01,  4.852718647e-01,  4.845579407e-01,
   4.838436944e-01,  4.831291264e-01,  4.824142373e-01,  4.816990278e-01,
   4.809834985e-01,  4.802676501e-01,  4.795514833e-01,  4.788349986e-01,
   4.781181967e-01,  4.774010784e-01,  4.766836441e-01,  4.759658947e-01,
   4.752478308e-01,  4.745294530e-01,  4.738107620e-01,  4.730917585e-01,
   4.723724432e-01,  4.716528166e-01,  4.709328796e-01,  4.702126327e-01,
   4.694920767e-01,  4.687712123e-01,  4.680500400e-01,  4.673285607e-01,
   4.666067749e-01,  4.658846835e-01,  4.651622870e-01,  4.644395862e-01,
   4.637165818e-01,  4.629932745e-01,  4.622696649e-01,  4.615457539e-01,
   4.608215420e-01,  4.600970300e-01,  4.593722186e-01,  4.586471086e-01,
   4.579217006e-01,  4.571959953e-01,  4.564699936e-01,  4.557436960e-01,
   4.550171034e-01,  4.542902164e-01,  4.535630358e-01,  4.528355623e-01,
   4.521077967e-01,  4.513797396e-01,  4.506513919e-01,  4.499227543e-01,
   4.491938275e-01,  4.484646122e-01,  4.477351093e-01,  4.470053194e-01,
   4.462752433e-01,  4.455448818e-01,  4.448142356e-01,  4.440833056e-01,
   4.433520923e-01,  4.426205967e-01,  4.418888195e-01,  4.411567615e-01,
   4.404244234e-01,  4.396918060e-01,  4.389589101e-01,  4.382257365e-01,
   4.374922859e-01,  4.367585592e-01,  4.360245571e-01,  4.352902805e-01,
   4.345557300e-01,  4.338209066e-01,  4.330858110e-01,  4.323504440e-01,
   4.316148065e-01,  4.308788991e-01,  4.301427228e-01,  4.294062784e-01,
   4.286695666e-01,  4.279325883e-01,  4.271953443e-01,  4.264578355e-01,
   4.257200626e-01,  4.249820265e-01,  4.242437280e-01,  4.235051680e-01,
   4.227663472e-01,  4.220272666e-01,  4.212879269e-01,  4.205483291e-01,
   4.198084739e-01,  4.190683622e-01,  4.183279950e-01,  4.175873729e-01,
   4.168464969e-01,  4.161053679e-01,  4.153639866e-01,  4.146223541e-01,
   4.138804711e-01,  4.131383385e-01,  4.123959573e-01,  4.116533282e-01,
   4.109104521e-01,  4.101673300e-01,  4.094239628e-01,  4.086803513e-01,
   4.079364964e-01,  4.071923990e-01,  4.064480600e-01,  4.057034804e-01,
   4.049586610e-01,  4.042136027e-01,  4.034683064e-01,  4.027227731e-01,
   4.019770037e-01,  4.012309992e-01,  4.004847603e-01,  3.997382881e-01,
   3.989915834e-01,  3.982446473e-01,  3.974974806e-01,  3.967500844e-01,
   3.960024594e-01,  3.952546068e-01,  3.945065273e-01,  3.937582221e-01,
   3.930096920e-01,  3.922609379e-01,  3.915119610e-01,  3.907627620e-01,
   3.900133421e-01,  3.892637021e-01,  3.885138430e-01,  3.877637659e-01,
   3.870134717e-01,  3.862629613e-01,  3.855122358e-01,  3.847612962e-01,
   3.840101434e-01,  3.832587784e-01,  3.825072023e-01,  3.817554161e-01,
   3.810034207e-01,  3.802512173e-01,  3.794988066e-01,  3.787461899e-01,
   3.779933682e-01,  3.772403423e-01,  3.764871135e-01,  3.757336827e-01,
   3.749800509e-01,  3.742262192e-01,  3.734721886e-01,  3.727179602e-01,
   3.719635351e-01,  3.712089141e-01,  3.704540986e-01,  3.696990894e-01,
   3.689438877e-01,  3.681884945e-01,  3.674329108e-01,  3.666771379e-01,
   3.659211767e-01,  3.651650283e-01,  3.644086938e-01,  3.636521743e-01,
   3.628954709e-01,  3.621385847e-01,  3.613815167e-01,  3.606242682e-01,
   3.598668402e-01,  3.591092337e-01,  3.583514500e-01,  3.575934901e-01,
   3.568353552e-01,  3.560770463e-01,  3.553185647e-01,  3.545599114e-01,
   3.538010877e-01,  3.530420945e-01,  3.522829331e-01,  3.515236046e-01,
   3.507641103e-01,  3.500044511e-01,  3.492446283e-01,  3.484846431e-01,
   3.477244967e-01,  3.469641901e-01,  3.462037246e-01,  3.454431014e-01,
   3.446823216e-01,  3.439213864e-01,  3.431602970e-01,  3.423990547e-01,
   3.416376606e-01,  3.408761160e-01,  3.401144219e-01,  3.393525797e-01,
   3.385905906e-01,  3.378284558e-01,  3.370661765e-01,  3.363037539e-01,
   3.355411893e-01,  3.347784840e-01,  3.340156391e-01,  3.332526559e-01,
   3.324895357e-01,  3.317262797e-01,  3.309628891e-01,  3.301993654e-01,
   3.294357096e-01,  3.286719231e-01,  3.279080072e-01,  3.271439631e-01,
   3.263797921e-01,  3.256154956e-01,  3.248510748e-01,  3.240865310e-01,
   3.233218656e-01,  3.225570797e-01,  3.217921749e-01,  3.210271522e-01,
   3.202620132e-01,  3.194967591e-01,  3.187313912e-01,  3.179659110e-01,
   3.172003196e-01,  3.164346185e-01,  3.156688091e-01,  3.149028926e-01,
   3.141368705e-01,  3.133707441e-01,  3.126045147e-01,  3.118381838e-01,
   3.110717527e-01,  3.103052229e-01,  3.095385956e-01,  3.087718724e-01,
   3.080050545e-01,  3.072381435e-01,  3.064711406e-01,  3.057040474e-01,
   3.049368652e-01,  3.041695956e-01,  3.034022398e-01,  3.026347993e-01,
   3.018672756e-01,  3.010996701e-01,  3.003319843e-01,  2.995642196e-01,
   2.987963776e-01,  2.980284595e-01,  2.972604670e-01,  2.964924015e-01,
   2.957242644e-01,  2.949560573e-01,  2.941877817e-01,  2.934194390e-01,
   2.926510308e-01,  2.918825585e-01,  2.911140238e-01,  2.903454280e-01,
   2.895767728e-01,  2.888080596e-01,  2.880392900e-01,  2.872704655e-01,
   2.865015877e-01,  2.857326581e-01,  2.849636784e-01,  2.841946499e-01,
   2.834255745e-01,  2.826564535e-01,  2.818872886e-01,  2.811180813e-01,
   2.803488333e-01,  2.795795462e-01,  2.788102216e-01,  2.780408610e-01,
   2.772714661e-01,  2.765020386e-01,  2.757325799e-01,  2.749630919e-01,
   2.741935761e-01,  2.734240342e-01,  2.726544677e-01,  2.718848785e-01,
   2.711152681e-01,  2.703456383e-01,  2.695759906e-01,  2.688063268e-01,
   2.680366486e-01,  2.672669577e-01,  2.664972557e-01,  2.657275445e-01,
   2.649578256e-01,  2.641881009e-01,  2.634183720e-01,  2.626486407e-01,
   2.618789087e-01,  2.611091779e-01,  2.603394499e-01,  2.595697265e-01,
   2.588000094e-01,  2.580303006e-01,  2.572606016e-01,  2.564909144e-01,
   2.557212408e-01,  2.549515824e-01,  2.541819412e-01,  2.534123190e-01,
   2.526427176e-01,  2.518731388e-01,  2.511035844e-01,  2.503340564e-01,
   2.495645565e-01,  2.487950867e-01,  2.480256487e-01,  2.472562446e-01,
   2.464868761e-01,  2.457175451e-01,  2.449482536e-01,  2.441790035e-01,
   2.434097966e-01,  2.426406350e-01,  2.418715204e-01,  2.411024550e-01,
   2.403334405e-01,  2.395644790e-01,  2.387955725e-01,  2.380267228e-01,
   2.372579320e-01,  2.364892021e-01,  2.357205351e-01,  2.349519329e-01,
   2.341833975e-01,  2.334149311e-01,  2.326465356e-01,  2.318782130e-01,
   2.311099654e-01,  2.303417949e-01,  2.295737035e-01,  2.288056933e-01,
   2.280377663e-01,  2.272699247e-01,  2.265021705e-01,  2.257345059e-01,
   2.249669329e-01,  2.241994538e-01,  2.234320705e-01,  2.226647853e-01,
   2.218976003e-01,  2.211305177e-01,  2.203635396e-01,  2.195966683e-01,
   2.188299058e-01,  2.180632545e-01,  2.172967165e-01,  2.165302940e-01,
   2.157639892e-01,  2.149978045e-01,  2.142317419e-01,  2.134658039e-01,
   2.126999927e-01,  2.119343104e-01,  2.111687595e-01,  2.104033422e-01,
   2.096380609e-01,  2.088729178e-01,  2.081079152e-01,  2.073430556e-01,
   2.065783412e-01,  2.058137745e-01,  2.050493577e-01,  2.042850934e-01,
   2.035209837e-01,  2.027570313e-01,  2.019932384e-01,  2.012296076e-01,
   2.004661412e-01,  1.997028417e-01,  1.989397115e-01,  1.981767532e-01,
   1.974139692e-01,  1.966513620e-01,  1.958889341e-01,  1.951266880e-01,
   1.943646263e-01,  1.936027516e-01,  1.928410662e-01,  1.920795730e-01,
   1.913182743e-01,  1.905571729e-01,  1.897962712e-01,  1.890355720e-01,
   1.882750779e-01,  1.875147914e-01,  1.867547154e-01,  1.859948524e-01,
   1.852352051e-01,  1.844757762e-01,  1.837165685e-01,  1.829575846e-01,
   1.821988274e-01,  1.814402994e-01,  1.806820037e-01,  1.799239428e-01,
   1.791661196e-01,  1.784085369e-01,  1.776511976e-01,  1.768941044e-01,
   1.761372603e-01,  1.753806681e-01,  1.746243306e-01,  1.738682509e-01,
   1.731124318e-01,  1.723568762e-01,  1.716015871e-01,  1.708465674e-01,
   1.700918202e-01,  1.693373484e-01,  1.685831550e-01,  1.678292431e-01,
   1.670756157e-01,  1.663222759e-01,  1.655692267e-01,  1.648164713e-01,
   1.640640128e-01,  1.633118543e-01,  1.625599989e-01,  1.618084498e-01,
   1.610572102e-01,  1.603062834e-01,  1.595556724e-01,  1.588053807e-01,
   1.580554113e-01,  1.573057677e-01,  1.565564531e-01,  1.558074708e-01,
   1.550588242e-01,  1.543105166e-01,  1.535625514e-01,  1.528149320e-01,
   1.520676618e-01,  1.513207443e-01,  1.505741829e-01,  1.498279811e-01,
   1.490821424e-01,  1.483366703e-01,  1.475915684e-01,  1.468468403e-01,
   1.461024894e-01,  1.453585196e-01,  1.446149343e-01,  1.438717373e-01,
   1.431289322e-01,  1.423865228e-01,  1.416445127e-01,  1.409029058e-01,
   1.401617058e-01,  1.394209165e-01,  1.386805417e-01,  1.379405854e-01,
   1.372010514e-01,  1.364619435e-01,  1.357232658e-01,  1.349850222e-01,
   1.342472167e-01,  1.335098533e-01,  1.327729361e-01,  1.320364690e-01,
   1.313004563e-01,  1.305649021e-01,  1.298298105e-01,  1.290951857e-01,
   1.283610319e-01,  1.276273534e-01,  1.268941544e-01,  1.261614394e-01,
   1.254292125e-01,  1.246974782e-01,  1.239662409e-01,  1.232355051e-01,
   1.225052752e-01,  1.217755556e-01,  1.210463511e-01,  1.203176661e-01,
   1.195895052e-01,  1.188618732e-01,  1.181347746e-01,  1.174082143e-01,
   1.166821969e-01,  1.159567272e-01,  1.152318102e-01,  1.145074506e-01,
   1.137836534e-01,  1.130604235e-01,  1.123377660e-01,  1.116156858e-01,
   1.108941881e-01,  1.101732779e-01,  1.094529604e-01,  1.087332408e-01,
   1.080141244e-01,  1.072956164e-01,  1.065777223e-01,  1.058604473e-01,
   1.051437969e-01,  1.044277766e-01,  1.037123920e-01,  1.029976486e-01,
   1.022835519e-01,  1.015701078e-01,  1.008573220e-01,  1.001452001e-01,
   9.943374814e-02,  9.872297189e-02,  9.801287735e-02,  9.730347049e-02,
   9.659475739e-02,  9.588674416e-02,  9.517943697e-02,  9.447284206e-02,
   9.376696573e-02,  9.306181433e-02,  9.235739428e-02,  9.165371207e-02,
   9.095077424e-02,  9.024858742e-02,  8.954715829e-02,  8.884649359e-02,
   8.814660016e-02,  8.744748488e-02,  8.674915471e-02,  8.605161671e-02,
   8.535487798e-02,  8.465894572e-02,  8.396382719e-02,  8.326952974e-02,
   8.257606080e-02,  8.188342789e-02,  8.119163860e-02,  8.050070060e-02,
   7.981062168e-02,  7.912140969e-02,  7.843307258e-02,  7.774561838e-02,
   7.705905524e-02,  7.637339139e-02,  7.568863515e-02,  7.500479497e-02,
   7.432187936e-02,  7.363989698e-02,  7.295885656e-02,  7.227876697e-02,
   7.159963716e-02,  7.092147621e-02,  7.024429332e-02,  6.956809781e-02,
   6.889289910e-02,  6.821870676e-02,  6.754553048e-02,  6.687338006e-02,
   6.620226546e-02,  6.553219677e-02,  6.486318419e-02,  6.419523811e-02,
   6.352836903e-02,  6.286258760e-02,  6.219790464e-02,  6.153433111e-02,
   6.087187815e-02,  6.021055704e-02,  5.955037923e-02,  5.889135637e-02,
   5.823350025e-02,  5.757682287e-02,  5.692133639e-02,  5.626705318e-02,
   5.561398579e-02,  5.496214699e-02,  5.431154973e-02,  5.366220719e-02,
   5.301413276e-02,  5.236734005e-02,  5.172184292e-02,  5.107765543e-02,
   5.043479191e-02,  4.979326692e-02,  4.915309530e-02,  4.851429213e-02,
   4.787687277e-02,  4.724085286e-02,  4.660624833e-02,  4.597307540e-02,
   4.534135061e-02,  4.471109079e-02,  4.408231313e-02,  4.345503513e-02,
   4.282927463e-02,  4.220504986e-02,  4.158237938e-02,  4.096128217e-02,
   4.034177758e-02,  3.972388538e-02,  3.910762574e-02,  3.849301930e-02,
   3.788008714e-02,  3.726885080e-02,  3.665933231e-02,  3.605155421e-02,
   3.544553957e-02,  3.484131198e-02,  3.423889562e-02,  3.363831523e-02,
   3.303959618e-02,  3.244276446e-02,  3.184784674e-02,  3.125487035e-02,
   3.066386336e-02,  3.007485457e-02,  2.948787356e-02,  2.890295073e-02,
   2.832011734e-02,  2.773940551e-02,  2.716084830e-02,  2.658447977e-02,
   2.601033497e-02,  2.543845002e-02,  2.486886219e-02,  2.430160989e-02,
   2.373673281e-02,  2.317427193e-02,  2.261426959e-02,  2.205676960e-02,
   2.150181731e-02,  2.094945966e-02,  2.039974534e-02,  1.985272482e-02,
   1.930845052e-02,  1.876697690e-02,  1.822836057e-02,  1.769266051e-02,
   1.715993811e-02,  1.663025745e-02,  1.610368539e-02,  1.558029186e-02,
   1.506015001e-02,  1.454333650e-02,  1.402993176e-02,  1.352002029e-02,
   1.301369099e-02,  1.251103757e-02,  1.201215894e-02,  1.151715968e-02,
   1.102615059e-02,  1.053924931e-02,  1.005658098e-02,  9.578279039e-03,
   9.104486144e-03,  8.635355205e-03,  8.171050605e-03,  7.711749628e-03,
   7.257644129e-03,  6.808942527e-03,  6.365872183e-03,  5.928682272e-03,
   5.497647286e-03,  5.073071350e-03,  4.655293609e-03,  4.244695063e-03,
   3.841707336e-03,  3.446824198e-03,  3.060616964e-03,  2.683755658e-03,
   2.317038924e-03,  1.961437906e-03,  1.618163527e-03,  1.288775731e-03,
   9.753747396e-04,  6.809730624e-04,  4.103438160e-04,  1.725808584e-04,
};
const float lut_cutoff[] = {
   7.656250000e-03,  7.781646474e-03,  7.909096730e-03,  8.038634407e-03,
   8.170293693e-03,  8.304109336e-03,  8.440116653e-03,  8.578351542e-03,
   8.718850485e-03,  8.861650564e-03,  9.006789467e-03,  9.154305502e-03,
   9.304237600e-03,  9.456625333e-03,  9.611508921e-03,  9.768929241e-03,
   9.928927840e-03,  1.009154695e-02,  1.025682948e-02,  1.042481906e-02,
   1.059556003e-02,  1.076909745e-02,  1.094547712e-02,  1.112474559e-02,
   1.130695018e-02,  1.149213897e-02,  1.168036084e-02,  1.187166547e-02,
   1.206610335e-02,  1.226372579e-02,  1.246458495e-02,  1.266873385e-02,
   1.287622636e-02,  1.308711725e-02,  1.330146218e-02,  1.351931771e-02,
   1.374074136e-02,  1.396579154e-02,  1.419452768e-02,  1.442701012e-02,
   1.466330024e-02,  1.490346038e-02,  1.514755395e-02,  1.539564536e-02,
   1.564780009e-02,  1.590408469e-02,  1.616456679e-02,  1.642931516e-02,
   1.669839966e-02,  1.697189130e-02,  1.724986228e-02,  1.753238596e-02,
   1.781953690e-02,  1.811139089e-02,  1.840802495e-02,  1.870951738e-02,
   1.901594775e-02,  1.932739693e-02,  1.964394712e-02,  1.996568187e-02,
   2.029268610e-02,  2.062504610e-02,  2.096284960e-02,  2.130618575e-02,
   2.165514517e-02,  2.200981996e-02,  2.237030372e-02,  2.273669160e-02,
   2.310908030e-02,  2.348756809e-02,  2.387225488e-02,  2.426324219e-02,
   2.466063321e-02,  2.506453282e-02,  2.547504764e-02,  2.589228599e-02,
   2.631635800e-02,  2.674737560e-02,  2.718545254e-02,  2.763070444e-02,
   2.808324882e-02,  2.854320512e-02,  2.901069472e-02,  2.948584101e-02,
   2.996876940e-02,  3.045960734e-02,  3.095848439e-02,  3.146553219e-02,
   3.198088459e-02,  3.250467759e-02,  3.303704943e-02,  3.357814063e-02,
   3.412809399e-02,  3.468705466e-02,  3.525517017e-02,  3.583259045e-02,
   3.641946790e-02,  3.701595741e-02,  3.762221642e-02,  3.823840493e-02,
   3.886468556e-02,  3.950122362e-02,  4.014818710e-02,  4.080574675e-02,
   4.147407612e-02,  4.215335160e-02,  4.284375247e-02,  4.354546094e-02,
   4.425866221e-02,  4.498354452e-02,  4.572029918e-02,  4.646912064e-02,
   4.723020653e-02,  4.800375772e-02,  4.878997838e-02,  4.958907602e-02,
   5.040126152e-02,  5.122674925e-02,  5.206575708e-02,  5.291850645e-02,
   5.378522241e-02,  5.466613372e-02,  5.556147287e-02,  5.647147617e-02,
   5.739638379e-02,  5.833643984e-02,  5.929189243e-02,  6.026299371e-02,
   6.125000000e-02,  6.225317179e-02,  6.327277384e-02,  6.430907526e-02,
   6.536234954e-02,  6.643287469e-02,  6.752093323e-02,  6.862681234e-02,
   6.975080388e-02,  7.089320451e-02,  7.205431574e-02,  7.323444401e-02,
   7.443390080e-02,  7.565300267e-02,  7.689207137e-02,  7.815143393e-02,
   7.943142272e-02,  8.073237558e-02,  8.205463585e-02,  8.339855251e-02,
   8.476448027e-02,  8.615277962e-02,  8.756381698e-02,  8.899796475e-02,
   9.045560144e-02,  9.193711176e-02,  9.344288673e-02,  9.497332376e-02,
   9.652882676e-02,  9.810980629e-02,  9.971667959e-02,  1.013498708e-01,
   1.030098109e-01,  1.046969380e-01,  1.064116974e-01,  1.081545417e-01,
   1.099259308e-01,  1.117263324e-01,  1.135562214e-01,  1.154160810e-01,
   1.173064019e-01,  1.192276831e-01,  1.211804316e-01,  1.231651629e-01,
   1.251824007e-01,  1.272326775e-01,  1.293165343e-01,  1.314345213e-01,
   1.335871973e-01,  1.357751304e-01,  1.379988983e-01,  1.402590877e-01,
   1.425562952e-01,  1.448911271e-01,  1.472641996e-01,  1.496761390e-01,
   1.521275820e-01,  1.546191754e-01,  1.571515770e-01,  1.597254550e-01,
   1.623414888e-01,  1.650003688e-01,  1.677027968e-01,  1.704494860e-01,
   1.732411614e-01,  1.760785597e-01,  1.789624298e-01,  1.818935328e-01,
   1.848726424e-01,  1.879005447e-01,  1.909780390e-01,  1.941059375e-01,
   1.972850657e-01,  2.005162626e-01,  2.038003811e-01,  2.071382879e-01,
   2.105308640e-01,  2.139790048e-01,  2.174836203e-01,  2.210456356e-01,
   2.246659906e-01,  2.283456409e-01,  2.320855577e-01,  2.358867281e-01,
   2.397501552e-01,  2.436768588e-01,  2.476678751e-01,  2.517242575e-01,
   2.558470767e-01,  2.600374207e-01,  2.642963955e-01,  2.686251250e-01,
   2.730247519e-01,  2.774964373e-01,  2.820413613e-01,  2.866607236e-01,
   2.913557432e-01,  2.961276593e-01,  3.009777313e-01,  3.059072394e-01,
   3.109174845e-01,  3.160097890e-01,  3.211854968e-01,  3.264459740e-01,
   3.317926090e-01,  3.372268128e-01,  3.427500198e-01,  3.483636875e-01,
   3.540692977e-01,  3.598683562e-01,  3.657623934e-01,  3.717529651e-01,
   3.778416522e-01,  3.840300618e-01,  3.903198271e-01,  3.967126081e-01,
   4.032100921e-01,  4.098139940e-01,  4.165260567e-01,  4.233480516e-01,
   4.302817793e-01,  4.373290698e-01,  4.444917830e-01,  4.517718094e-01,
   4.591710704e-01,  4.666915187e-01,  4.743351394e-01,  4.821039497e-01,
   4.900000000e-01,
};
const float lut_grain_size[] = {
   1.024000000e+03,  1.035000000e+03,  1.046000000e+03,  1.057000000e+03,
   1.069000000e+03,  1.080000000e+03,  1.092000000e+03,  1.104000000e+03,
   1.116000000e+03,  1.128000000e+03,  1.141000000e+03,  1.153000000e+03,
   1.166000000e+03,  1.178000000e+03,  1.191000000e+03,  1.204000000e+03,
   1.217000000e+03,  1.231000000e+03,  1.244000000e+03,  1.257000000e+03,
   1.271000000e+03,  1.285000000e+03,  1.299000000e+03,  1.313000000e+03,
   1.327000000e+03,  1.342000000e+03,  1.357000000e+03,  1.371000000e+03,
   1.386000000e+03,  1.401000000e+03,  1.417000000e+03,  1.432000000e+03,
   1.448000000e+03,  1.463000000e+03,  1.479000000e+03,  1.495000000e+03,
   1.512000000e+03,  1.528000000e+03,  1.545000000e+03,  1.562000000e+03,
   1.579000000e+03,  1.596000000e+03,  1.613000000e+03,  1.631000000e+03,
   1.649000000e+03,  1.667000000e+03,  1.685000000e+03,  1.703000000e+03,
   1.722000000e+03,  1.740000000e+03,  1.759000000e+03,  1.779000000e+03,
   1.798000000e+03,  1.817000000e+03,  1.837000000e+03,  1.857000000e+03,
   1.878000000e+03,  1.898000000e+03,  1.919000000e+03,  1.940000000e+03,
   1.961000000e+03,  1.982000000e+03,  2.004000000e+03,  2.025000000e+03,
   2.048000000e+03,  2.070000000e+03,  2.092000000e+03,  2.115000000e+03,
   2.138000000e+03,  2.161000000e+03,  2.185000000e+03,  2.209000000e+03,
   2.233000000e+03,  2.257000000e+03,  2.282000000e+03,  2.307000000e+03,
   2.332000000e+03,  2.357000000e+03,  2.383000000e+03,  2.409000000e+03,
   2.435000000e+03,  2.462000000e+03,  2.488000000e+03,  2.515000000e+03,
   2.543000000e+03,  2.571000000e+03,  2.599000000e+03,  2.627000000e+03,
   2.655000000e+03,  2.684000000e+03,  2.714000000e+03,  2.743000000e+03,
   2.773000000e+03,  2.803000000e+03,  2.834000000e+03,  2.865000000e+03,
   2.896000000e+03,  2.927000000e+03,  2.959000000e+03,  2.991000000e+03,
   3.024000000e+03,  3.057000000e+03,  3.090000000e+03,  3.124000000e+03,
   3.158000000e+03,  3.192000000e+03,  3.227000000e+03,  3.262000000e+03,
   3.298000000e+03,  3.334000000e+03,  3.370000000e+03,  3.407000000e+03,
   3.444000000e+03,  3.481000000e+03,  3.519000000e+03,  3.558000000e+03,
   3.596000000e+03,  3.635000000e+03,  3.675000000e+03,  3.715000000e+03,
   3.756000000e+03,  3.796000000e+03,  3.838000000e+03,  3.880000000e+03,
   3.922000000e+03,  3.965000000e+03,  4.008000000e+03,  4.051000000e+03,
   4.096000000e+03,  4.140000000e+03,  4.185000000e+03,  4.231000000e+03,
   4.277000000e+03,  4.323000000e+03,  4.371000000e+03,  4.418000000e+03,
   4.466000000e+03,  4.515000000e+03,  4.564000000e+03,  4.614000000e+03,
   4.664000000e+03,  4.715000000e+03,  4.766000000e+03,  4.818000000e+03,
   4.870000000e+03,  4.924000000e+03,  4.977000000e+03,  5.031000000e+03,
   5.086000000e+03,  5.142000000e+03,  5.198000000e+03,  5.254000000e+03,
   5.311000000e+03,  5.369000000e+03,  5.428000000e+03,  5.487000000e+03,
   5.547000000e+03,  5.607000000e+03,  5.668000000e+03,  5.730000000e+03,
   5.792000000e+03,  5.855000000e+03,  5.919000000e+03,  5.983000000e+03,
   6.049000000e+03,  6.114000000e+03,  6.181000000e+03,  6.248000000e+03,
   6.316000000e+03,  6.385000000e+03,  6.455000000e+03,  6.525000000e+03,
   6.596000000e+03,  6.668000000e+03,  6.741000000e+03,  6.814000000e+03,
   6.888000000e+03,  6.963000000e+03,  7.039000000e+03,  7.116000000e+03,
   7.193000000e+03,  7.271000000e+03,  7.351000000e+03,  7.431000000e+03,
   7.512000000e+03,  7.593000000e+03,  7.676000000e+03,  7.760000000e+03,
   7.844000000e+03,  7.930000000e+03,  8.016000000e+03,  8.103000000e+03,
   8.192000000e+03,  8.281000000e+03,  8.371000000e+03,  8.462000000e+03,
   8.554000000e+03,  8.647000000e+03,  8.742000000e+03,  8.837000000e+03,
   8.933000000e+03,  9.030000000e+03,  9.129000000e+03,  9.228000000e+03,
   9.328000000e+03,  9.430000000e+03,  9.533000000e+03,  9.637000000e+03,
   9.741000000e+03,  9.848000000e+03,  9.955000000e+03,  1.006300000e+04,
   1.017300000e+04,  1.028400000e+04,  1.039600000e+04,  1.050900000e+04,
   1.062300000e+04,  1.073900000e+04,  1.085600000e+04,  1.097400000e+04,
   1.109400000e+04,  1.121400000e+04,  1.133600000e+04,  1.146000000e+04,
   1.158500000e+04,  1.171100000e+04,  1.183800000e+04,  1.196700000e+04,
   1.209800000e+04,  1.222900000e+04,  1.236300000e+04,  1.249700000e+04,
   1.263300000e+04,  1.277100000e+04,  1.291000000e+04,  1.305100000e+04,
   1.319300000e+04,  1.333600000e+04,  1.348200000e+04,  1.362800000e+04,
   1.377700000e+04,  1.392700000e+04,  1.407800000e+04,  1.423200000e+04,
   1.438700000e+04,  1.454300000e+04,  1.470200000e+04,  1.486200000e+04,
   1.502400000e+04,  1.518700000e+04,  1.535300000e+04,  1.552000000e+04,
   1.568900000e+04,  1.586000000e+04,  1.603200000e+04,  1.620700000e+04,
   1.638400000e+04,
};
const float lut_quantized_pitch[] = {
  -2.400000000e+01, -2.395890338e+01, -2.390726692e+01, -2.384512538e+01,
  -2.377253662e+01, -2.368958147e+01, -2.359636353e+01, -2.349300897e+01,
  -2.337966626e+01, -2.325650579e+01, -2.312371957e+01, -2.298152074e+01,
  -2.283014314e+01, -2.266984079e+01, -2.250088734e+01, -2.232357542e+01,
  -2.213821608e+01, -2.194513803e+01, -2.174468695e+01, -2.153722474e+01,
  -2.132312871e+01, -2.110279073e+01, -2.087661643e+01, -2.064502423e+01,
  -2.040844448e+01, -2.016731850e+01, -1.992209760e+01, -1.967324207e+01,
  -1.942122021e+01, -1.916650729e+01, -1.890958447e+01, -1.865093778e+01,
  -1.839105705e+01, -1.813043480e+01, -1.786956520e+01, -1.760894295e+01,
  -1.734906222e+01, -1.709041553e+01, -1.683349271e+01, -1.657877979e+01,
  -1.632675793e+01, -1.607790240e+01, -1.583268150e+01, -1.559155552e+01,
  -1.535497577e+01, -1.512338357e+01, -1.489720927e+01, -1.467687129e+01,
  -1.446277526e+01, -1.425531305e+01, -1.405486197e+01, -1.386178392e+01,
  -1.367642458e+01, -1.349911266e+01, -1.333015921e+01, -1.316985686e+01,
  -1.301847926e+01, -1.287628043e+01, -1.274349421e+01, -1.262033374e+01,
  -1.250699103e+01, -1.240363647e+01, -1.231041853e+01, -1.222746338e+01,
  -1.215487462e+01, -1.209273308e+01, -1.204109662e+01, -1.200000000e+01,
  -1.200000000e+01, -1.198287641e+01, -1.196136122e+01, -1.193546891e+01,
  -1.190522359e+01, -1.187065894e+01, -1.183181814e+01, -1.178875374e+01,
  -1.174152761e+01, -1.169021075e+01, -1.163488315e+01, -1.157563364e+01,
  -1.151255964e+01, -1.144576700e+01, -1.137536972e+01, -1.130148976e+01,
  -1.122425670e+01, -1.114380751e+01, -1.106028623e+01, -1.097384364e+01,
  -1.088463696e+01, -1.079282947e+01, -1.069859018e+01, -1.060209343e+01,
  -1.050351853e+01, -1.040304938e+01, -1.030087400e+01, -1.019718420e+01,
  -1.009217509e+01, -9.986044705e+00, -9.878993530e+00, -9.771224077e+00,
  -9.662940438e+00, -9.554347834e+00, -9.445652166e+00, -9.337059562e+00,
  -9.228775923e+00, -9.121006470e+00, -9.013955295e+00, -8.907824911e+00,
  -8.802815805e+00, -8.699126001e+00, -8.596950623e+00, -8.496481465e+00,
  -8.397906572e+00, -8.301409822e+00, -8.207170528e+00, -8.115363038e+00,
  -8.026156356e+00, -7.939713770e+00, -7.856192488e+00, -7.775743300e+00,
  -7.698510241e+00, -7.624630277e+00, -7.554233003e+00, -7.487440359e+00,
  -7.424366360e+00, -7.365116846e+00, -7.309789253e+00, -7.258472392e+00,
  -7.211246261e+00, -7.168181864e+00, -7.129341055e+00, -7.094776407e+00,
  -7.064531090e+00, -7.038638782e+00, -7.017123590e+00, -7.000000000e+00,
  -7.000000000e+00, -6.989896040e+00, -6.977233953e+00, -6.962021929e+00,
  -6.944273602e+00, -6.924008018e+00, -6.901249595e+00, -6.876028071e+00,
  -6.848378440e+00, -6.818340877e+00, -6.785960656e+00, -6.751288045e+00,
  -6.714378210e+00, -6.675291087e+00, -6.634091261e+00, -6.590847824e+00,
  -6.545634230e+00, -6.498528137e+00, -6.449611243e+00, -6.398969108e+00,
  -6.346690975e+00, -6.292869580e+00, -6.237600948e+00, -6.180984198e+00,
  -6.123121321e+00, -6.064116971e+00, -6.004078235e+00, -5.943114409e+00,
  -5.881336765e+00, -5.818858307e+00, -5.755793539e+00, -5.692258214e+00,
  -5.628369090e+00, -5.564243680e+00, -5.500000000e+00, -5.435756320e+00,
  -5.371630910e+00, -5.307741786e+00, -5.244206461e+00, -5.181141693e+00,
  -5.118663235e+00, -5.056885591e+00, -4.995921765e+00, -4.935883029e+00,
  -4.876878679e+00, -4.819015802e+00, -4.762399052e+00, -4.707130420e+00,
  -4.653309025e+00, -4.601030892e+00, -4.550388757e+00, -4.501471863e+00,
  -4.454365770e+00, -4.409152176e+00, -4.365908739e+00, -4.324708913e+00,
  -4.285621790e+00, -4.248711955e+00, -4.214039344e+00, -4.181659123e+00,
  -4.151621560e+00, -4.123971929e+00, -4.098750405e+00, -4.075991982e+00,
  -4.055726398e+00, -4.037978071e+00, -4.022766047e+00, -4.010103960e+00,
  -4.000000000e+00, -4.000000000e+00, -3.996575282e+00, -3.992272244e+00,
  -3.987093782e+00, -3.981044719e+00, -3.974131789e+00, -3.966363627e+00,
  -3.957750748e+00, -3.948305522e+00, -3.938042149e+00, -3.926976631e+00,
  -3.915126728e+00, -3.902511928e+00, -3.889153399e+00, -3.875073945e+00,
  -3.860297952e+00, -3.844851340e+00, -3.828761502e+00, -3.812057246e+00,
  -3.794768729e+00, -3.776927392e+00, -3.758565894e+00, -3.739718036e+00,
  -3.720418686e+00, -3.700703707e+00, -3.680609875e+00, -3.660174800e+00,
  -3.639436839e+00, -3.618435018e+00, -3.597208941e+00, -3.575798706e+00,
  -3.554244815e+00, -3.532588088e+00, -3.510869567e+00, -3.489130433e+00,
  -3.467411912e+00, -3.445755185e+00, -3.424201294e+00, -3.402791059e+00,
  -3.381564982e+00, -3.360563161e+00, -3.339825200e+00, -3.319390125e+00,
  -3.299296293e+00, -3.279581314e+00, -3.260281964e+00, -3.241434106e+00,
  -3.223072608e+00, -3.205231271e+00, -3.187942754e+00, -3.171238498e+00,
  -3.155148660e+00, -3.139702048e+00, -3.124926055e+00, -3.110846601e+00,
  -3.097488072e+00, -3.084873272e+00, -3.073023369e+00, -3.061957851e+00,
  -3.051694478e+00, -3.042249252e+00, -3.033636373e+00, -3.025868211e+00,
  -3.018955281e+00, -3.012906218e+00, -3.007727756e+00, -3.003424718e+00,
  -3.000000000e+00, -3.000000000e+00, -2.993150564e+00, -2.984544487e+00,
  -2.974187564e+00, -2.962089437e+00, -2.948263578e+00, -2.932727255e+00,
  -2.915501495e+00, -2.896611043e+00, -2.876084299e+00, -2.853953262e+00,
  -2.830253456e+00, -2.805023856e+00, -2.778306799e+00, -2.750147889e+00,
  -2.720595904e+00, -2.689702680e+00, -2.657523005e+00, -2.624114492e+00,
  -2.589537457e+00, -2.553854785e+00, -2.517131789e+00, -2.479436071e+00,
  -2.440837371e+00, -2.401407414e+00, -2.361219751e+00, -2.320349600e+00,
  -2.278873678e+00, -2.236870036e+00, -2.194417882e+00, -2.151597412e+00,
  -2.108489631e+00, -2.065176175e+00, -2.021739134e+00, -1.978260866e+00,
  -1.934823825e+00, -1.891510369e+00, -1.848402588e+00, -1.805582118e+00,
  -1.763129964e+00, -1.721126322e+00, -1.679650400e+00, -1.638780249e+00,
  -1.598592586e+00, -1.559162629e+00, -1.520563929e+00, -1.482868211e+00,
  -1.446145215e+00, -1.410462543e+00, -1.375885508e+00, -1.342476995e+00,
  -1.310297320e+00, -1.279404096e+00, -1.249852111e+00, -1.221693201e+00,
  -1.194976144e+00, -1.169746544e+00, -1.146046738e+00, -1.123915701e+00,
  -1.103388957e+00, -1.084498505e+00, -1.067272745e+00, -1.051736422e+00,
  -1.037910563e+00, -1.025812436e+00, -1.015455513e+00, -1.006849436e+00,
  -1.000000000e+00, -1.000000000e+00, -9.969688121e-01, -9.931701858e-01,
  -9.886065786e-01, -9.832820806e-01, -9.772024055e-01, -9.703748786e-01,
  -9.628084214e-01, -9.545135320e-01, -9.455022632e-01, -9.357881967e-01,
  -9.253864136e-01, -9.143134630e-01, -9.025873261e-01, -8.902273783e-01,
  -8.772543472e-01, -8.636902690e-01, -8.495584412e-01, -8.348833729e-01,
  -8.196907324e-01, -8.040072926e-01, -7.878608739e-01, -7.712802845e-01,
  -7.542952593e-01, -7.369363963e-01, -7.192350912e-01, -7.012234704e-01,
  -6.829343228e-01, -6.644010294e-01, -6.456574921e-01, -6.267380617e-01,
  -6.076774643e-01, -5.885107271e-01, -5.692731039e-01, -5.500000000e-01,
  -5.307268961e-01, -5.114892729e-01, -4.923225357e-01, -4.732619383e-01,
  -4.543425079e-01, -4.355989706e-01, -4.170656772e-01, -3.987765296e-01,
  -3.807649088e-01, -3.630636037e-01, -3.457047407e-01, -3.287197155e-01,
  -3.121391261e-01, -2.959927074e-01, -2.803092676e-01, -2.651166271e-01,
  -2.504415588e-01, -2.363097310e-01, -2.227456528e-01, -2.097726217e-01,
  -1.974126739e-01, -1.856865370e-01, -1.746135864e-01, -1.642118033e-01,
  -1.544977368e-01, -1.454864680e-01, -1.371915786e-01, -1.296251214e-01,
  -1.227975945e-01, -1.167179194e-01, -1.113934214e-01, -1.068298142e-01,
  -1.030311879e-01, -1.000000000e-01, -1.000000000e-01, -9.965752820e-02,
  -9.922722436e-02, -9.870937819e-02, -9.810447186e-02, -9.741317890e-02,
  -9.663636273e-02, -9.577507477e-02, -9.483055215e-02, -9.380421494e-02,
  -9.269766308e-02, -9.151267281e-02, -9.025119282e-02, -8.891533993e-02,
  -8.750739446e-02, -8.602979518e-02, -8.448513401e-02, -8.287615025e-02,
  -8.120572461e-02, -7.947687287e-02, -7.769273924e-02, -7.585658945e-02,
  -7.397180356e-02, -7.204186857e-02, -7.007037069e-02, -6.806098754e-02,
  -6.601747998e-02, -6.394368391e-02, -6.184350179e-02, -5.972089409e-02,
  -5.757987059e-02, -5.542448154e-02, -5.325880875e-02, -5.108695668e-02,
  -4.891304332e-02, -4.674119125e-02, -4.457551846e-02, -4.242012941e-02,
  -4.027910591e-02, -3.815649821e-02, -3.605631609e-02, -3.398252002e-02,
  -3.193901246e-02, -2.992962931e-02, -2.795813143e-02, -2.602819644e-02,
  -2.414341055e-02, -2.230726076e-02, -2.052312713e-02, -1.879427539e-02,
  -1.712384975e-02, -1.551486599e-02, -1.397020482e-02, -1.249260554e-02,
  -1.108466007e-02, -9.748807182e-03, -8.487327193e-03, -7.302336925e-03,
  -6.195785058e-03, -5.169447849e-03, -4.224925227e-03, -3.363637273e-03,
  -2.586821100e-03, -1.895528136e-03, -1.290621807e-03, -7.727756445e-04,
  -3.424718033e-04,  0.000000000e+00,  0.000000000e+00,  0.000000000e+00,
   0.000000000e+00,  0.000000000e+00,  0.000000000e+00,  0.000000000e+00,
   0.000000000e+00,  0.000000000e+00,  0.000000000e+00,  0.000000000e+00,
   0.000000000e+00,  0.000000000e+00,  0.000000000e+00,  0.000000000e+00,
   0.000000000e+00,  0.000000000e+00,  0.000000000e+00,  0.000000000e+00,
   0.000000000e+00,  0.000000000e+00,  0.000000000e+00,  0.000000000e+00,
   0.000000000e+00,  0.000000000e+00,  0.000000000e+00,  0.000000000e+00,
   0.000000000e+00,  0.000000000e+00,  0.000000000e+00,  0.000000000e+00,
   0.000000000e+00,  0.000000000e+00,  0.000000000e+00,  0.000000000e+00,
   0.000000000e+00,  0.000000000e+00,  0.000000000e+00,  0.000000000e+00,
   0.000000000e+00,  0.000000000e+00,  0.000000000e+00,  0.000000000e+00,
   0.000000000e+00,  0.000000000e+00,  0.000000000e+00,  0.000000000e+00,
   0.000000000e+00,  0.000000000e+00,  0.000000000e+00,  0.000000000e+00,
   0.000000000e+00,  0.000000000e+00,  0.000000000e+00,  0.000000000e+00,
   0.000000000e+00,  0.000000000e+00,  0.000000000e+00,  0.000000000e+00,
   0.000000000e+00,  0.000000000e+00,  0.000000000e+00,  0.000000000e+00,
   0.000000000e+00,  0.000000000e+00,  0.000000000e+00,  0.000000000e+00,
   0.000000000e+00,  0.000000000e+00,  0.000000000e+00,  3.367986550e-04,
   7.588682423e-04,  1.265935706e-03,  1.857546601e-03,  2.533066061e-03,
   3.291680155e-03,  4.132397626e-03,  5.054052000e-03,  6.055304084e-03,
   7.134644816e-03,  8.290398492e-03,  9.520726336e-03,  1.082363043e-02,
   1.219695797e-02,  1.363840587e-02,  1.514552566e-02,  1.671572875e-02,
   1.834629190e-02,  2.003436307e-02,  2.177696749e-02,  2.357101401e-02,
   2.541330172e-02,  2.730052674e-02,  2.922928930e-02,  3.119610098e-02,
   3.319739218e-02,  3.522951969e-02,  3.728877451e-02,  3.937138977e-02,
   4.147354870e-02,  4.359139286e-02,  4.572103033e-02,  4.785854401e-02,
   5.000000000e-02,  5.214145599e-02,  5.427896967e-02,  5.640860714e-02,
   5.852645130e-02,  6.062861023e-02,  6.271122549e-02,  6.477048031e-02,
   6.680260782e-02,  6.880389902e-02,  7.077071070e-02,  7.269947326e-02,
   7.458669828e-02,  7.642898599e-02,  7.822303251e-02,  7.996563693e-02,
   8.165370810e-02,  8.328427125e-02,  8.485447434e-02,  8.636159413e-02,
   8.780304203e-02,  8.917636957e-02,  9.047927366e-02,  9.170960151e-02,
   9.286535518e-02,  9.394469592e-02,  9.494594800e-02,  9.586760237e-02,
   9.670831984e-02,  9.746693394e-02,  9.814245340e-02,  9.873406429e-02,
   9.924113176e-02,  9.966320135e-02,  1.000000000e-01,  1.000000000e-01,
   1.030822462e-01,  1.069549808e-01,  1.116155963e-01,  1.170597532e-01,
   1.232813899e-01,  1.302727355e-01,  1.380243270e-01,  1.465250306e-01,
   1.557620655e-01,  1.657210323e-01,  1.763859447e-01,  1.877392646e-01,
   1.997619406e-01,  2.124334499e-01,  2.257318433e-01,  2.396337939e-01,
   2.541146478e-01,  2.691484785e-01,  2.847081441e-01,  3.007653468e-01,
   3.172906950e-01,  3.342537679e-01,  3.516231829e-01,  3.693666638e-01,
   3.874511121e-01,  4.058426802e-01,  4.245068448e-01,  4.434084839e-01,
   4.625119532e-01,  4.817811647e-01,  5.011796662e-01,  5.206707212e-01,
   5.402173899e-01,  5.597826101e-01,  5.793292788e-01,  5.988203338e-01,
   6.182188353e-01,  6.374880468e-01,  6.565915161e-01,  6.754931552e-01,
   6.941573198e-01,  7.125488879e-01,  7.306333362e-01,  7.483768171e-01,
   7.657462321e-01,  7.827093050e-01,  7.992346532e-01,  8.152918559e-01,
   8.308515215e-01,  8.458853522e-01,  8.603662061e-01,  8.742681567e-01,
   8.875665501e-01,  9.002380594e-01,  9.122607354e-01,  9.236140553e-01,
   9.342789677e-01,  9.442379345e-01,  9.534749694e-01,  9.619756730e-01,
   9.697272645e-01,  9.767186101e-01,  9.829402468e-01,  9.883844037e-01,
   9.930450192e-01,  9.969177538e-01,  1.000000000e+00,  1.000000000e+00,
   1.006849436e+00,  1.015455513e+00,  1.025812436e+00,  1.037910563e+00,
   1.051736422e+00,  1.067272745e+00,  1.084498505e+00,  1.103388957e+00,
   1.123915701e+00,  1.146046738e+00,  1.169746544e+00,  1.194976144e+00,
   1.221693201e+00,  1.249852111e+00,  1.279404096e+00,  1.310297320e+00,
   1.342476995e+00,  1.375885508e+00,  1.410462543e+00,  1.446145215e+00,
   1.482868211e+00,  1.520563929e+00,  1.559162629e+00,  1.598592586e+00,
   1.638780249e+00,  1.679650400e+00,  1.721126322e+00,  1.763129964e+00,
   1.805582118e+00,  1.848402588e+00,  1.891510369e+00,  1.934823825e+00,
   1.978260866e+00,  2.021739134e+00,  2.065176175e+00,  2.108489631e+00,
   2.151597412e+00,  2.194417882e+00,  2.236870036e+00,  2.278873678e+00,
   2.320349600e+00,  2.361219751e+00,  2.401407414e+00,  2.440837371e+00,
   2.479436071e+00,  2.517131789e+00,  2.553854785e+00,  2.589537457e+00,
   2.624114492e+00,  2.657523005e+00,  2.689702680e+00,  2.720595904e+00,
   2.750147889e+00,  2.778306799e+00,  2.805023856e+00,  2.830253456e+00,
   2.853953262e+00,  2.876084299e+00,  2.896611043e+00,  2.915501495e+00,
   2.932727255e+00,  2.948263578e+00,  2.962089437e+00,  2.974187564e+00,
   2.984544487e+00,  2.993150564e+00,  3.000000000e+00,  3.000000000e+00,
   3.003367987e+00,  3.007588682e+00,  3.012659357e+00,  3.018575466e+00,
   3.025330661e+00,  3.032916802e+00,  3.041323976e+00,  3.050540520e+00,
   3.060553041e+00,  3.071346448e+00,  3.082903985e+00,  3.095207263e+00,
   3.108236304e+00,  3.121969580e+00,  3.136384059e+00,  3.151455257e+00,
   3.167157288e+00,  3.183462919e+00,  3.200343631e+00,  3.217769675e+00,
   3.235710140e+00,  3.254133017e+00,  3.273005267e+00,  3.292292893e+00,
   3.311961010e+00,  3.331973922e+00,  3.352295197e+00,  3.372887745e+00,
   3.393713898e+00,  3.414735487e+00,  3.435913929e+00,  3.457210303e+00,
   3.478585440e+00,  3.500000000e+00,  3.521414560e+00,  3.542789697e+00,
   3.564086071e+00,  3.585264513e+00,  3.606286102e+00,  3.627112255e+00,
   3.647704803e+00,  3.668026078e+00,  3.688038990e+00,  3.707707107e+00,
   3.726994733e+00,  3.745866983e+00,  3.764289860e+00,  3.782230325e+00,
   3.799656369e+00,  3.816537081e+00,  3.832842712e+00,  3.848544743e+00,
   3.863615941e+00,  3.878030420e+00,  3.891763696e+00,  3.904792737e+00,
   3.917096015e+00,  3.928653552e+00,  3.939446959e+00,  3.949459480e+00,
   3.958676024e+00,  3.967083198e+00,  3.974669339e+00,  3.981424534e+00,
   3.987340643e+00,  3.992411318e+00,  3.996632013e+00,  4.000000000e+00,
   4.000000000e+00,  4.010274154e+00,  4.023183269e+00,  4.038718654e+00,
   4.056865844e+00,  4.077604633e+00,  4.100909118e+00,  4.126747757e+00,
   4.155083435e+00,  4.185873552e+00,  4.219070108e+00,  4.254619816e+00,
   4.292464215e+00,  4.332539802e+00,  4.374778166e+00,  4.419106144e+00,
   4.465445980e+00,  4.513715493e+00,  4.563828262e+00,  4.615693814e+00,
   4.669217823e+00,  4.724302317e+00,  4.780845893e+00,  4.838743943e+00,
   4.897888879e+00,  4.958170374e+00,  5.019475601e+00,  5.081689483e+00,
   5.144694946e+00,  5.208373177e+00,  5.272603882e+00,  5.337265554e+00,
   5.402235737e+00,  5.467391300e+00,  5.532608700e+00,  5.597764263e+00,
   5.662734446e+00,  5.727396118e+00,  5.791626823e+00,  5.855305054e+00,
   5.918310517e+00,  5.980524399e+00,  6.041829626e+00,  6.102111121e+00,
   6.161256057e+00,  6.219154107e+00,  6.275697683e+00,  6.330782177e+00,
   6.384306186e+00,  6.436171738e+00,  6.486284507e+00,  6.534554020e+00,
   6.580893856e+00,  6.625221834e+00,  6.667460198e+00,  6.707535785e+00,
   6.745380184e+00,  6.780929892e+00,  6.814126448e+00,  6.844916565e+00,
   6.873252243e+00,  6.899090882e+00,  6.922395367e+00,  6.943134156e+00,
   6.961281346e+00,  6.976816731e+00,  6.989725846e+00,  7.000000000e+00,
   7.000000000e+00,  7.017123590e+00,  7.038638782e+00,  7.064531090e+00,
   7.094776407e+00,  7.129341055e+00,  7.168181864e+00,  7.211246261e+00,
   7.258472392e+00,  7.309789253e+00,  7.365116846e+00,  7.424366360e+00,
   7.487440359e+00,  7.554233003e+00,  7.624630277e+00,  7.698510241e+00,
   7.775743300e+00,  7.856192488e+00,  7.939713770e+00,  8.026156356e+00,
   8.115363038e+00,  8.207170528e+00,  8.301409822e+00,  8.397906572e+00,
   8.496481465e+00,  8.596950623e+00,  8.699126001e+00,  8.802815805e+00,
   8.907824911e+00,  9.013955295e+00,  9.121006470e+00,  9.228775923e+00,
   9.337059562e+00,  9.445652166e+00,  9.554347834e+00,  9.662940438e+00,
   9.771224077e+00,  9.878993530e+00,  9.986044705e+00,  1.009217509e+01,
   1.019718420e+01,  1.030087400e+01,  1.040304938e+01,  1.050351853e+01,
   1.060209343e+01,  1.069859018e+01,  1.079282947e+01,  1.088463696e+01,
   1.097384364e+01,  1.106028623e+01,  1.114380751e+01,  1.122425670e+01,
   1.130148976e+01,  1.137536972e+01,  1.144576700e+01,  1.151255964e+01,
   1.157563364e+01,  1.163488315e+01,  1.169021075e+01,  1.174152761e+01,
   1.178875374e+01,  1.183181814e+01,  1.187065894e+01,  1.190522359e+01,
   1.193546891e+01,  1.196136122e+01,  1.198287641e+01,  1.200000000e+01,
   1.200000000e+01,  1.204041584e+01,  1.209106419e+01,  1.215191228e+01,
   1.222290559e+01,  1.230396793e+01,  1.239500162e+01,  1.249588772e+01,
   1.260648624e+01,  1.272663649e+01,  1.285615738e+01,  1.299484782e+01,
   1.314248716e+01,  1.329883565e+01,  1.346363496e+01,  1.363660870e+01,
   1.381746308e+01,  1.400588745e+01,  1.420155503e+01,  1.440412357e+01,
   1.461323610e+01,  1.482852168e+01,  1.504959621e+01,  1.527606321e+01,
   1.550751472e+01,  1.574353212e+01,  1.598368706e+01,  1.622754236e+01,
   1.647465294e+01,  1.672456677e+01,  1.697682584e+01,  1.723096714e+01,
   1.748652364e+01,  1.774302528e+01,  1.800000000e+01,  1.825697472e+01,
   1.851347636e+01,  1.876903286e+01,  1.902317416e+01,  1.927543323e+01,
   1.952534706e+01,  1.977245764e+01,  2.001631294e+01,  2.025646788e+01,
   2.049248528e+01,  2.072393679e+01,  2.095040379e+01,  2.117147832e+01,
   2.138676390e+01,  2.159587643e+01,  2.179844497e+01,  2.199411255e+01,
   2.218253692e+01,  2.236339130e+01,  2.253636504e+01,  2.270116435e+01,
   2.285751284e+01,  2.300515218e+01,  2.314384262e+01,  2.327336351e+01,
   2.339351376e+01,  2.350411228e+01,  2.360499838e+01,  2.369603207e+01,
   2.377709441e+01,  2.384808772e+01,  2.390893581e+01,  2.395958416e+01,
   2.400000000e+01,
};


const float* lookup_table_table[] = {
  lut_sin,
  lut_window,
  lut_xfade_in,
  lut_xfade_out,
  lut_sine_window_4096,
  lut_cutoff,
  lut_grain_size,
  lut_quantized_pitch,
};


}  // namespace clouds
