// Code generated by go-swagger; DO NOT EDIT.

//
// Copyright 2021 The Sigstore Authors.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//

package index

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	stderrors "errors"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/sigstore/rekor/pkg/generated/models"
)

// SearchIndexReader is a Reader for the SearchIndex structure.
type SearchIndexReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *SearchIndexReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (any, error) {
	switch response.Code() {
	case 200:
		result := NewSearchIndexOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 400:
		result := NewSearchIndexBadRequest()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	default:
		result := NewSearchIndexDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewSearchIndexOK creates a SearchIndexOK with default headers values
func NewSearchIndexOK() *SearchIndexOK {
	return &SearchIndexOK{}
}

/*
SearchIndexOK describes a response with status code 200, with default header values.

Returns zero or more entry UUIDs from the transparency log based on search query
*/
type SearchIndexOK struct {
	Payload []string
}

// IsSuccess returns true when this search index o k response has a 2xx status code
func (o *SearchIndexOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this search index o k response has a 3xx status code
func (o *SearchIndexOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this search index o k response has a 4xx status code
func (o *SearchIndexOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this search index o k response has a 5xx status code
func (o *SearchIndexOK) IsServerError() bool {
	return false
}

// IsCode returns true when this search index o k response a status code equal to that given
func (o *SearchIndexOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the search index o k response
func (o *SearchIndexOK) Code() int {
	return 200
}

func (o *SearchIndexOK) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /api/v1/index/retrieve][%d] searchIndexOK %s", 200, payload)
}

func (o *SearchIndexOK) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /api/v1/index/retrieve][%d] searchIndexOK %s", 200, payload)
}

func (o *SearchIndexOK) GetPayload() []string {
	return o.Payload
}

func (o *SearchIndexOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// response payload
	if err := consumer.Consume(response.Body(), &o.Payload); err != nil && !stderrors.Is(err, io.EOF) {
		return err
	}

	return nil
}

// NewSearchIndexBadRequest creates a SearchIndexBadRequest with default headers values
func NewSearchIndexBadRequest() *SearchIndexBadRequest {
	return &SearchIndexBadRequest{}
}

/*
SearchIndexBadRequest describes a response with status code 400, with default header values.

The content supplied to the server was invalid
*/
type SearchIndexBadRequest struct {
	Payload *models.Error
}

// IsSuccess returns true when this search index bad request response has a 2xx status code
func (o *SearchIndexBadRequest) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this search index bad request response has a 3xx status code
func (o *SearchIndexBadRequest) IsRedirect() bool {
	return false
}

// IsClientError returns true when this search index bad request response has a 4xx status code
func (o *SearchIndexBadRequest) IsClientError() bool {
	return true
}

// IsServerError returns true when this search index bad request response has a 5xx status code
func (o *SearchIndexBadRequest) IsServerError() bool {
	return false
}

// IsCode returns true when this search index bad request response a status code equal to that given
func (o *SearchIndexBadRequest) IsCode(code int) bool {
	return code == 400
}

// Code gets the status code for the search index bad request response
func (o *SearchIndexBadRequest) Code() int {
	return 400
}

func (o *SearchIndexBadRequest) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /api/v1/index/retrieve][%d] searchIndexBadRequest %s", 400, payload)
}

func (o *SearchIndexBadRequest) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /api/v1/index/retrieve][%d] searchIndexBadRequest %s", 400, payload)
}

func (o *SearchIndexBadRequest) GetPayload() *models.Error {
	return o.Payload
}

func (o *SearchIndexBadRequest) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.Error)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && !stderrors.Is(err, io.EOF) {
		return err
	}

	return nil
}

// NewSearchIndexDefault creates a SearchIndexDefault with default headers values
func NewSearchIndexDefault(code int) *SearchIndexDefault {
	return &SearchIndexDefault{
		_statusCode: code,
	}
}

/*
SearchIndexDefault describes a response with status code -1, with default header values.

There was an internal error in the server while processing the request
*/
type SearchIndexDefault struct {
	_statusCode int

	Payload *models.Error
}

// IsSuccess returns true when this search index default response has a 2xx status code
func (o *SearchIndexDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this search index default response has a 3xx status code
func (o *SearchIndexDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this search index default response has a 4xx status code
func (o *SearchIndexDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this search index default response has a 5xx status code
func (o *SearchIndexDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this search index default response a status code equal to that given
func (o *SearchIndexDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the search index default response
func (o *SearchIndexDefault) Code() int {
	return o._statusCode
}

func (o *SearchIndexDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /api/v1/index/retrieve][%d] searchIndex default %s", o._statusCode, payload)
}

func (o *SearchIndexDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /api/v1/index/retrieve][%d] searchIndex default %s", o._statusCode, payload)
}

func (o *SearchIndexDefault) GetPayload() *models.Error {
	return o.Payload
}

func (o *SearchIndexDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.Error)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && !stderrors.Is(err, io.EOF) {
		return err
	}

	return nil
}
