// ui/base/ime/mojom/text_input_state.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "ui/base/ime/mojom/text_input_state.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/hash/md5_constexpr.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/common/task_annotator.h"
#include "base/trace_event/trace_conversion_helper.h"
#include "base/trace_event/traced_value.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_context.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"

#include "ui/base/ime/mojom/text_input_state.mojom-params-data.h"
#include "ui/base/ime/mojom/text_input_state.mojom-shared-message-ids.h"

#include "ui/base/ime/mojom/text_input_state.mojom-import-headers.h"


#ifndef UI_BASE_IME_MOJOM_TEXT_INPUT_STATE_MOJOM_JUMBO_H_
#define UI_BASE_IME_MOJOM_TEXT_INPUT_STATE_MOJOM_JUMBO_H_
#endif
namespace ui {
namespace mojom {
ImeTextSpanInfo::ImeTextSpanInfo()
    : span(),
      bounds() {}

ImeTextSpanInfo::ImeTextSpanInfo(
    const ::ui::ImeTextSpan& span_in,
    const ::gfx::Rect& bounds_in)
    : span(std::move(span_in)),
      bounds(std::move(bounds_in)) {}

ImeTextSpanInfo::~ImeTextSpanInfo() = default;

void ImeTextSpanInfo::AsValueInto(base::trace_event::TracedValue* value) const {
  value->SetString("span", base::trace_event::ValueToString(this->span, "<value of type const ::ui::ImeTextSpan&>"));
  value->SetString("bounds", base::trace_event::ValueToString(this->bounds, "<value of type const ::gfx::Rect&>"));
}

bool ImeTextSpanInfo::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
TextInputState::TextInputState()
    : type(mojo::internal::ConvertEnumValue<::ui::mojom::TextInputType, ::ui::TextInputType>(::ui::mojom::TextInputType::NONE)),
      mode(mojo::internal::ConvertEnumValue<::ui::mojom::TextInputMode, ::ui::TextInputMode>(::ui::mojom::TextInputMode::kDefault)),
      action(mojo::internal::ConvertEnumValue<::ui::mojom::TextInputAction, ::ui::TextInputAction>(::ui::mojom::TextInputAction::kDefault)),
      flags(),
      value(),
      selection(),
      composition(),
      can_compose_inline(true),
      show_ime_if_needed(),
      always_hide_ime(),
      reply_to_request(),
      edit_context_control_bounds(),
      edit_context_selection_bounds(),
      vk_policy(::ui::mojom::VirtualKeyboardPolicy::AUTO),
      last_vk_visibility_request(::ui::mojom::VirtualKeyboardVisibilityRequest::NONE),
      ime_text_spans_info() {}

TextInputState::TextInputState(
    ::ui::TextInputType type_in,
    ::ui::TextInputMode mode_in,
    ::ui::TextInputAction action_in,
    uint32_t flags_in,
    const base::Optional<::base::string16>& value_in,
    const ::gfx::Range& selection_in,
    const base::Optional<::gfx::Range>& composition_in,
    bool can_compose_inline_in,
    bool show_ime_if_needed_in,
    bool always_hide_ime_in,
    bool reply_to_request_in,
    const base::Optional<::gfx::Rect>& edit_context_control_bounds_in,
    const base::Optional<::gfx::Rect>& edit_context_selection_bounds_in,
    ::ui::mojom::VirtualKeyboardPolicy vk_policy_in,
    ::ui::mojom::VirtualKeyboardVisibilityRequest last_vk_visibility_request_in,
    std::vector<ImeTextSpanInfoPtr> ime_text_spans_info_in)
    : type(std::move(type_in)),
      mode(std::move(mode_in)),
      action(std::move(action_in)),
      flags(std::move(flags_in)),
      value(std::move(value_in)),
      selection(std::move(selection_in)),
      composition(std::move(composition_in)),
      can_compose_inline(std::move(can_compose_inline_in)),
      show_ime_if_needed(std::move(show_ime_if_needed_in)),
      always_hide_ime(std::move(always_hide_ime_in)),
      reply_to_request(std::move(reply_to_request_in)),
      edit_context_control_bounds(std::move(edit_context_control_bounds_in)),
      edit_context_selection_bounds(std::move(edit_context_selection_bounds_in)),
      vk_policy(std::move(vk_policy_in)),
      last_vk_visibility_request(std::move(last_vk_visibility_request_in)),
      ime_text_spans_info(std::move(ime_text_spans_info_in)) {}

TextInputState::~TextInputState() = default;

void TextInputState::AsValueInto(base::trace_event::TracedValue* value) const {
  value->SetInteger("type", static_cast<int>(this->type));
  value->SetInteger("mode", static_cast<int>(this->mode));
  value->SetInteger("action", static_cast<int>(this->action));
  value->SetString("flags", base::NumberToString(this->flags));
  value->SetString("value", base::trace_event::ValueToString(this->value, "<value of type const base::Optional<::base::string16>&>"));
  value->SetString("selection", base::trace_event::ValueToString(this->selection, "<value of type const ::gfx::Range&>"));
  value->SetString("composition", base::trace_event::ValueToString(this->composition, "<value of type const base::Optional<::gfx::Range>&>"));
  value->SetBoolean("can_compose_inline", this->can_compose_inline);
  value->SetBoolean("show_ime_if_needed", this->show_ime_if_needed);
  value->SetBoolean("always_hide_ime", this->always_hide_ime);
  value->SetBoolean("reply_to_request", this->reply_to_request);
  value->SetString("edit_context_control_bounds", base::trace_event::ValueToString(this->edit_context_control_bounds, "<value of type const base::Optional<::gfx::Rect>&>"));
  value->SetString("edit_context_selection_bounds", base::trace_event::ValueToString(this->edit_context_selection_bounds, "<value of type const base::Optional<::gfx::Rect>&>"));
  value->SetString("vk_policy", base::trace_event::ValueToString(this->vk_policy));
  value->SetString("last_vk_visibility_request", base::trace_event::ValueToString(this->last_vk_visibility_request));
  value->BeginArray("ime_text_spans_info");
  for (const auto& item0 : this->ime_text_spans_info) {
    if (item0.is_null()) {
      value->AppendString("nullptr");
    } else {
      value->BeginDictionary();
      item0->AsValueInto(value);
      value->EndDictionary();
    }
  }
  value->EndArray();
}

bool TextInputState::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
}  // namespace mojom
}  // namespace ui

namespace mojo {


// static
bool StructTraits<::ui::mojom::ImeTextSpanInfo::DataView, ::ui::mojom::ImeTextSpanInfoPtr>::Read(
    ::ui::mojom::ImeTextSpanInfo::DataView input,
    ::ui::mojom::ImeTextSpanInfoPtr* output) {
  bool success = true;
  ::ui::mojom::ImeTextSpanInfoPtr result(::ui::mojom::ImeTextSpanInfo::New());
  
      if (success && !input.ReadSpan(&result->span))
        success = false;
      if (success && !input.ReadBounds(&result->bounds))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::ui::mojom::TextInputState::DataView, ::ui::mojom::TextInputStatePtr>::Read(
    ::ui::mojom::TextInputState::DataView input,
    ::ui::mojom::TextInputStatePtr* output) {
  bool success = true;
  ::ui::mojom::TextInputStatePtr result(::ui::mojom::TextInputState::New());
  
      if (success && !input.ReadType(&result->type))
        success = false;
      if (success && !input.ReadMode(&result->mode))
        success = false;
      if (success && !input.ReadAction(&result->action))
        success = false;
      if (success)
        result->flags = input.flags();
      if (success && !input.ReadValue(&result->value))
        success = false;
      if (success && !input.ReadSelection(&result->selection))
        success = false;
      if (success && !input.ReadComposition(&result->composition))
        success = false;
      if (success)
        result->can_compose_inline = input.can_compose_inline();
      if (success)
        result->show_ime_if_needed = input.show_ime_if_needed();
      if (success)
        result->always_hide_ime = input.always_hide_ime();
      if (success)
        result->reply_to_request = input.reply_to_request();
      if (success && !input.ReadEditContextControlBounds(&result->edit_context_control_bounds))
        success = false;
      if (success && !input.ReadEditContextSelectionBounds(&result->edit_context_selection_bounds))
        success = false;
      if (success && !input.ReadVkPolicy(&result->vk_policy))
        success = false;
      if (success && !input.ReadLastVkVisibilityRequest(&result->last_vk_visibility_request))
        success = false;
      if (success && !input.ReadImeTextSpansInfo(&result->ime_text_spans_info))
        success = false;
  *output = std::move(result);
  return success;
}

}  // namespace mojo

#if defined(__clang__)
#pragma clang diagnostic pop
#endif