// third_party/blink/public/mojom/scroll/scroll_into_view_params.mojom-blink.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_SCROLL_SCROLL_INTO_VIEW_PARAMS_MOJOM_BLINK_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_SCROLL_SCROLL_INTO_VIEW_PARAMS_MOJOM_BLINK_H_

#include <stdint.h>

#include <limits>
#include <type_traits>
#include <utility>

#include "base/callback.h"
#include "base/macros.h"
#include "base/optional.h"

#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#if BUILDFLAG(MOJO_TRACE_ENABLED)
#include "base/trace_event/trace_event.h"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"
#include "third_party/blink/public/mojom/scroll/scroll_into_view_params.mojom-shared.h"
#include "third_party/blink/public/mojom/scroll/scroll_into_view_params.mojom-blink-forward.h"
#include "third_party/blink/public/mojom/scroll/scroll_enums.mojom-blink-forward.h"
#include "ui/gfx/geometry/mojom/geometry.mojom-blink.h"

#include "mojo/public/cpp/bindings/lib/wtf_clone_equals_util.h"
#include "mojo/public/cpp/bindings/lib/wtf_hash_util.h"
#include "third_party/blink/renderer/platform/wtf/hash_functions.h"
#include "third_party/blink/renderer/platform/wtf/text/wtf_string.h"




#include "third_party/blink/renderer/platform/platform_export.h"




namespace WTF {
struct blink_mojom_internal_ScrollAlignment_Behavior_DataHashFn {
  static unsigned GetHash(const ::blink::mojom::ScrollAlignment_Behavior& value) {
    using utype = std::underlying_type<::blink::mojom::ScrollAlignment_Behavior>::type;
    return DefaultHash<utype>::Hash().GetHash(static_cast<utype>(value));
  }
  static bool Equal(const ::blink::mojom::ScrollAlignment_Behavior& left, const ::blink::mojom::ScrollAlignment_Behavior& right) {
    return left == right;
  }
  static const bool safe_to_compare_to_empty_or_deleted = true;
};

template <>
struct HashTraits<::blink::mojom::ScrollAlignment_Behavior>
    : public GenericHashTraits<::blink::mojom::ScrollAlignment_Behavior> {
  static_assert(true,
                "-1000000 is a reserved enum value");
  static_assert(true,
                "-1000001 is a reserved enum value");
  static const bool hasIsEmptyValueFunction = true;
  static bool IsEmptyValue(const ::blink::mojom::ScrollAlignment_Behavior& value) {
    return value == static_cast<::blink::mojom::ScrollAlignment_Behavior>(-1000000);
  }
  static void ConstructDeletedValue(::blink::mojom::ScrollAlignment_Behavior& slot, bool) {
    slot = static_cast<::blink::mojom::ScrollAlignment_Behavior>(-1000001);
  }
  static bool IsDeletedValue(const ::blink::mojom::ScrollAlignment_Behavior& value) {
    return value == static_cast<::blink::mojom::ScrollAlignment_Behavior>(-1000001);
  }
};
}  // namespace WTF

// Forward-declare for |AsValueInto| so that we do not have to import the
// corresponding header.
namespace base {
namespace trace_event {
class TracedValue;
}  // namespace trace_event
}  // namespace base


namespace blink {
namespace mojom {
namespace blink {





class PLATFORM_EXPORT ScrollAlignment {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<ScrollAlignment, T>::value>;
  using DataView = ScrollAlignmentDataView;
  using Data_ = internal::ScrollAlignment_Data;
  using Behavior = ScrollAlignment_Behavior;

  template <typename... Args>
  static ScrollAlignmentPtr New(Args&&... args) {
    return ScrollAlignmentPtr(
        base::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static ScrollAlignmentPtr From(const U& u) {
    return mojo::TypeConverter<ScrollAlignmentPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, ScrollAlignment>::Convert(*this);
  }


  ScrollAlignment();

  ScrollAlignment(
      ScrollAlignment::Behavior rect_visible,
      ScrollAlignment::Behavior rect_hidden,
      ScrollAlignment::Behavior rect_partial);

  ~ScrollAlignment();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = ScrollAlignmentPtr>
  ScrollAlignmentPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, ScrollAlignment::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;
  size_t Hash(size_t seed) const;

  template <typename UserType>
  static WTF::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        ScrollAlignment::DataView, WTF::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        ScrollAlignment::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::ScrollAlignment_UnserializedMessageContext<
            UserType, ScrollAlignment::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    return mojo::internal::DeserializeImpl<ScrollAlignment::DataView>(
        data, data_num_bytes, std::vector<mojo::ScopedHandle>(), output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(const WTF::Vector<uint8_t>& input,
                          UserType* output) {
    return ScrollAlignment::Deserialize(
        input.size() == 0 ? nullptr : &input.front(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::ScrollAlignment_UnserializedMessageContext<
            UserType, ScrollAlignment::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<ScrollAlignment::DataView>(
        input.payload(), input.payload_num_bytes(),
        std::move(*input.mutable_handles()), output, Validate);
  }

  
  ScrollAlignment::Behavior rect_visible;
  
  ScrollAlignment::Behavior rect_hidden;
  
  ScrollAlignment::Behavior rect_partial;

  // Write this structure into |value|. The members are represented as a
  // dictionary |member name|: |member value|. This method does not deal with
  // the dictionary name. The caller is responsible for not calling
  // |AsValueInto| when |value| expects array items (see Array/Dictionary
  // methods of |base::trace_event::TracedValue|).
  //
  // |value| The TracedValue to be written into.
  //
  // Example uses:
  //
  //   // |my_var1, my_var2| are variables with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   value->BeginDictionary("my_var1");
  //   my_var1.AsValueInto(value.get());
  //   value->EndDictionary();
  //   value->BeginDictionary("my_var2");
  //   my_var2.AsValueInto(value.get());
  //   value->EndDictionary();
  //
  //   // |my_var| is a variable with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   my_var.AsValueInto(value.get());
  //   TRACE_EVENT1("test", "test", "my_var", std::move(value));
  //
  // Calling |AsValueInto| on two objects without opening and closing a
  // dictionary for each object is theoretically possible, but strongly
  // discouraged due to potential name collisions:
  //
  //   struct A {
  //     int foo;
  //   };
  //   struct B {
  //     int bar;
  //   };
  //   struct C {
  //     int foo;
  //     int bar;
  //   };
  //   auto value1 = std::make_unique<base::trace_event::TracedValue>();
  //   auto value2 = std::make_unique<base::trace_event::TracedValue>();
  //   A a;
  //   B b;
  //   C c;
  //   // value1 and value2 will be filled with the same information:
  //   a.AsValueInto(value1);
  //   b.AsValueInto(value1);
  //   c.AsValueInto(value2);
  void AsValueInto(base::trace_event::TracedValue* value) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, ScrollAlignment::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, ScrollAlignment::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, ScrollAlignment::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, ScrollAlignment::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}









class PLATFORM_EXPORT ScrollIntoViewParams {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<ScrollIntoViewParams, T>::value>;
  using DataView = ScrollIntoViewParamsDataView;
  using Data_ = internal::ScrollIntoViewParams_Data;

  template <typename... Args>
  static ScrollIntoViewParamsPtr New(Args&&... args) {
    return ScrollIntoViewParamsPtr(
        base::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static ScrollIntoViewParamsPtr From(const U& u) {
    return mojo::TypeConverter<ScrollIntoViewParamsPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, ScrollIntoViewParams>::Convert(*this);
  }


  ScrollIntoViewParams();

  ScrollIntoViewParams(
      ScrollAlignmentPtr align_x,
      ScrollAlignmentPtr align_y,
      ::blink::mojom::blink::ScrollType type,
      bool make_visible_in_visual_viewport,
      ::blink::mojom::blink::ScrollBehavior behavior,
      bool is_for_scroll_sequence,
      bool zoom_into_rect,
      const ::gfx::RectF& relative_element_bounds,
      const ::gfx::RectF& relative_caret_bounds,
      bool stop_at_main_frame_layout_viewport);

  ~ScrollIntoViewParams();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = ScrollIntoViewParamsPtr>
  ScrollIntoViewParamsPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, ScrollIntoViewParams::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename UserType>
  static WTF::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        ScrollIntoViewParams::DataView, WTF::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        ScrollIntoViewParams::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::ScrollIntoViewParams_UnserializedMessageContext<
            UserType, ScrollIntoViewParams::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    return mojo::internal::DeserializeImpl<ScrollIntoViewParams::DataView>(
        data, data_num_bytes, std::vector<mojo::ScopedHandle>(), output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(const WTF::Vector<uint8_t>& input,
                          UserType* output) {
    return ScrollIntoViewParams::Deserialize(
        input.size() == 0 ? nullptr : &input.front(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::ScrollIntoViewParams_UnserializedMessageContext<
            UserType, ScrollIntoViewParams::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<ScrollIntoViewParams::DataView>(
        input.payload(), input.payload_num_bytes(),
        std::move(*input.mutable_handles()), output, Validate);
  }

  
  ScrollAlignmentPtr align_x;
  
  ScrollAlignmentPtr align_y;
  
  ::blink::mojom::blink::ScrollType type;
  
  bool make_visible_in_visual_viewport;
  
  ::blink::mojom::blink::ScrollBehavior behavior;
  
  bool is_for_scroll_sequence;
  
  bool zoom_into_rect;
  
  ::gfx::RectF relative_element_bounds;
  
  ::gfx::RectF relative_caret_bounds;
  
  bool stop_at_main_frame_layout_viewport;

  // Write this structure into |value|. The members are represented as a
  // dictionary |member name|: |member value|. This method does not deal with
  // the dictionary name. The caller is responsible for not calling
  // |AsValueInto| when |value| expects array items (see Array/Dictionary
  // methods of |base::trace_event::TracedValue|).
  //
  // |value| The TracedValue to be written into.
  //
  // Example uses:
  //
  //   // |my_var1, my_var2| are variables with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   value->BeginDictionary("my_var1");
  //   my_var1.AsValueInto(value.get());
  //   value->EndDictionary();
  //   value->BeginDictionary("my_var2");
  //   my_var2.AsValueInto(value.get());
  //   value->EndDictionary();
  //
  //   // |my_var| is a variable with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   my_var.AsValueInto(value.get());
  //   TRACE_EVENT1("test", "test", "my_var", std::move(value));
  //
  // Calling |AsValueInto| on two objects without opening and closing a
  // dictionary for each object is theoretically possible, but strongly
  // discouraged due to potential name collisions:
  //
  //   struct A {
  //     int foo;
  //   };
  //   struct B {
  //     int bar;
  //   };
  //   struct C {
  //     int foo;
  //     int bar;
  //   };
  //   auto value1 = std::make_unique<base::trace_event::TracedValue>();
  //   auto value2 = std::make_unique<base::trace_event::TracedValue>();
  //   A a;
  //   B b;
  //   C c;
  //   // value1 and value2 will be filled with the same information:
  //   a.AsValueInto(value1);
  //   b.AsValueInto(value1);
  //   c.AsValueInto(value2);
  void AsValueInto(base::trace_event::TracedValue* value) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
  DISALLOW_COPY_AND_ASSIGN(ScrollIntoViewParams);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, ScrollIntoViewParams::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, ScrollIntoViewParams::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, ScrollIntoViewParams::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, ScrollIntoViewParams::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename StructPtrType>
ScrollAlignmentPtr ScrollAlignment::Clone() const {
  return New(
      mojo::Clone(rect_visible),
      mojo::Clone(rect_hidden),
      mojo::Clone(rect_partial)
  );
}

template <typename T, ScrollAlignment::EnableIfSame<T>*>
bool ScrollAlignment::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->rect_visible, other_struct.rect_visible))
    return false;
  if (!mojo::Equals(this->rect_hidden, other_struct.rect_hidden))
    return false;
  if (!mojo::Equals(this->rect_partial, other_struct.rect_partial))
    return false;
  return true;
}

template <typename T, ScrollAlignment::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (std::less<>{}(lhs.rect_visible, rhs.rect_visible))
    return true;
  if (std::less<>{}(rhs.rect_visible, lhs.rect_visible))
    return false;
  if (std::less<>{}(lhs.rect_hidden, rhs.rect_hidden))
    return true;
  if (std::less<>{}(rhs.rect_hidden, lhs.rect_hidden))
    return false;
  if (std::less<>{}(lhs.rect_partial, rhs.rect_partial))
    return true;
  if (std::less<>{}(rhs.rect_partial, lhs.rect_partial))
    return false;
  return false;
}
template <typename StructPtrType>
ScrollIntoViewParamsPtr ScrollIntoViewParams::Clone() const {
  return New(
      mojo::Clone(align_x),
      mojo::Clone(align_y),
      mojo::Clone(type),
      mojo::Clone(make_visible_in_visual_viewport),
      mojo::Clone(behavior),
      mojo::Clone(is_for_scroll_sequence),
      mojo::Clone(zoom_into_rect),
      mojo::Clone(relative_element_bounds),
      mojo::Clone(relative_caret_bounds),
      mojo::Clone(stop_at_main_frame_layout_viewport)
  );
}

template <typename T, ScrollIntoViewParams::EnableIfSame<T>*>
bool ScrollIntoViewParams::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->align_x, other_struct.align_x))
    return false;
  if (!mojo::Equals(this->align_y, other_struct.align_y))
    return false;
  if (!mojo::Equals(this->type, other_struct.type))
    return false;
  if (!mojo::Equals(this->make_visible_in_visual_viewport, other_struct.make_visible_in_visual_viewport))
    return false;
  if (!mojo::Equals(this->behavior, other_struct.behavior))
    return false;
  if (!mojo::Equals(this->is_for_scroll_sequence, other_struct.is_for_scroll_sequence))
    return false;
  if (!mojo::Equals(this->zoom_into_rect, other_struct.zoom_into_rect))
    return false;
  if (!mojo::Equals(this->relative_element_bounds, other_struct.relative_element_bounds))
    return false;
  if (!mojo::Equals(this->relative_caret_bounds, other_struct.relative_caret_bounds))
    return false;
  if (!mojo::Equals(this->stop_at_main_frame_layout_viewport, other_struct.stop_at_main_frame_layout_viewport))
    return false;
  return true;
}

template <typename T, ScrollIntoViewParams::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (std::less<>{}(lhs.align_x, rhs.align_x))
    return true;
  if (std::less<>{}(rhs.align_x, lhs.align_x))
    return false;
  if (std::less<>{}(lhs.align_y, rhs.align_y))
    return true;
  if (std::less<>{}(rhs.align_y, lhs.align_y))
    return false;
  if (std::less<>{}(lhs.type, rhs.type))
    return true;
  if (std::less<>{}(rhs.type, lhs.type))
    return false;
  if (std::less<>{}(lhs.make_visible_in_visual_viewport, rhs.make_visible_in_visual_viewport))
    return true;
  if (std::less<>{}(rhs.make_visible_in_visual_viewport, lhs.make_visible_in_visual_viewport))
    return false;
  if (std::less<>{}(lhs.behavior, rhs.behavior))
    return true;
  if (std::less<>{}(rhs.behavior, lhs.behavior))
    return false;
  if (std::less<>{}(lhs.is_for_scroll_sequence, rhs.is_for_scroll_sequence))
    return true;
  if (std::less<>{}(rhs.is_for_scroll_sequence, lhs.is_for_scroll_sequence))
    return false;
  if (std::less<>{}(lhs.zoom_into_rect, rhs.zoom_into_rect))
    return true;
  if (std::less<>{}(rhs.zoom_into_rect, lhs.zoom_into_rect))
    return false;
  if (std::less<>{}(lhs.relative_element_bounds, rhs.relative_element_bounds))
    return true;
  if (std::less<>{}(rhs.relative_element_bounds, lhs.relative_element_bounds))
    return false;
  if (std::less<>{}(lhs.relative_caret_bounds, rhs.relative_caret_bounds))
    return true;
  if (std::less<>{}(rhs.relative_caret_bounds, lhs.relative_caret_bounds))
    return false;
  if (std::less<>{}(lhs.stop_at_main_frame_layout_viewport, rhs.stop_at_main_frame_layout_viewport))
    return true;
  if (std::less<>{}(rhs.stop_at_main_frame_layout_viewport, lhs.stop_at_main_frame_layout_viewport))
    return false;
  return false;
}


}  // namespace blink
}  // namespace mojom
}  // namespace blink

namespace mojo {


template <>
struct PLATFORM_EXPORT StructTraits<::blink::mojom::blink::ScrollAlignment::DataView,
                                         ::blink::mojom::blink::ScrollAlignmentPtr> {
  static bool IsNull(const ::blink::mojom::blink::ScrollAlignmentPtr& input) { return !input; }
  static void SetToNull(::blink::mojom::blink::ScrollAlignmentPtr* output) { output->reset(); }

  static decltype(::blink::mojom::blink::ScrollAlignment::rect_visible) rect_visible(
      const ::blink::mojom::blink::ScrollAlignmentPtr& input) {
    return input->rect_visible;
  }

  static decltype(::blink::mojom::blink::ScrollAlignment::rect_hidden) rect_hidden(
      const ::blink::mojom::blink::ScrollAlignmentPtr& input) {
    return input->rect_hidden;
  }

  static decltype(::blink::mojom::blink::ScrollAlignment::rect_partial) rect_partial(
      const ::blink::mojom::blink::ScrollAlignmentPtr& input) {
    return input->rect_partial;
  }

  static bool Read(::blink::mojom::blink::ScrollAlignment::DataView input, ::blink::mojom::blink::ScrollAlignmentPtr* output);
};


template <>
struct PLATFORM_EXPORT StructTraits<::blink::mojom::blink::ScrollIntoViewParams::DataView,
                                         ::blink::mojom::blink::ScrollIntoViewParamsPtr> {
  static bool IsNull(const ::blink::mojom::blink::ScrollIntoViewParamsPtr& input) { return !input; }
  static void SetToNull(::blink::mojom::blink::ScrollIntoViewParamsPtr* output) { output->reset(); }

  static const decltype(::blink::mojom::blink::ScrollIntoViewParams::align_x)& align_x(
      const ::blink::mojom::blink::ScrollIntoViewParamsPtr& input) {
    return input->align_x;
  }

  static const decltype(::blink::mojom::blink::ScrollIntoViewParams::align_y)& align_y(
      const ::blink::mojom::blink::ScrollIntoViewParamsPtr& input) {
    return input->align_y;
  }

  static decltype(::blink::mojom::blink::ScrollIntoViewParams::type) type(
      const ::blink::mojom::blink::ScrollIntoViewParamsPtr& input) {
    return input->type;
  }

  static decltype(::blink::mojom::blink::ScrollIntoViewParams::make_visible_in_visual_viewport) make_visible_in_visual_viewport(
      const ::blink::mojom::blink::ScrollIntoViewParamsPtr& input) {
    return input->make_visible_in_visual_viewport;
  }

  static decltype(::blink::mojom::blink::ScrollIntoViewParams::behavior) behavior(
      const ::blink::mojom::blink::ScrollIntoViewParamsPtr& input) {
    return input->behavior;
  }

  static decltype(::blink::mojom::blink::ScrollIntoViewParams::is_for_scroll_sequence) is_for_scroll_sequence(
      const ::blink::mojom::blink::ScrollIntoViewParamsPtr& input) {
    return input->is_for_scroll_sequence;
  }

  static decltype(::blink::mojom::blink::ScrollIntoViewParams::zoom_into_rect) zoom_into_rect(
      const ::blink::mojom::blink::ScrollIntoViewParamsPtr& input) {
    return input->zoom_into_rect;
  }

  static const decltype(::blink::mojom::blink::ScrollIntoViewParams::relative_element_bounds)& relative_element_bounds(
      const ::blink::mojom::blink::ScrollIntoViewParamsPtr& input) {
    return input->relative_element_bounds;
  }

  static const decltype(::blink::mojom::blink::ScrollIntoViewParams::relative_caret_bounds)& relative_caret_bounds(
      const ::blink::mojom::blink::ScrollIntoViewParamsPtr& input) {
    return input->relative_caret_bounds;
  }

  static decltype(::blink::mojom::blink::ScrollIntoViewParams::stop_at_main_frame_layout_viewport) stop_at_main_frame_layout_viewport(
      const ::blink::mojom::blink::ScrollIntoViewParamsPtr& input) {
    return input->stop_at_main_frame_layout_viewport;
  }

  static bool Read(::blink::mojom::blink::ScrollIntoViewParams::DataView input, ::blink::mojom::blink::ScrollIntoViewParamsPtr* output);
};

}  // namespace mojo

#endif  // THIRD_PARTY_BLINK_PUBLIC_MOJOM_SCROLL_SCROLL_INTO_VIEW_PARAMS_MOJOM_BLINK_H_