// third_party/blink/public/mojom/native_io/native_io.mojom-blink.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_NATIVE_IO_NATIVE_IO_MOJOM_BLINK_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_NATIVE_IO_NATIVE_IO_MOJOM_BLINK_H_

#include <stdint.h>

#include <limits>
#include <type_traits>
#include <utility>

#include "base/callback.h"
#include "base/macros.h"
#include "base/optional.h"

#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#if BUILDFLAG(MOJO_TRACE_ENABLED)
#include "base/trace_event/trace_event.h"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"
#include "third_party/blink/public/mojom/native_io/native_io.mojom-shared.h"
#include "third_party/blink/public/mojom/native_io/native_io.mojom-blink-forward.h"
#include "mojo/public/mojom/base/file.mojom-blink.h"

#include "mojo/public/cpp/bindings/lib/wtf_clone_equals_util.h"
#include "mojo/public/cpp/bindings/lib/wtf_hash_util.h"
#include "third_party/blink/renderer/platform/wtf/hash_functions.h"
#include "third_party/blink/renderer/platform/wtf/text/wtf_string.h"

#include "mojo/public/cpp/bindings/associated_interface_ptr.h"
#include "mojo/public/cpp/bindings/associated_interface_ptr_info.h"
#include "mojo/public/cpp/bindings/associated_interface_request.h"
#include "mojo/public/cpp/bindings/interface_ptr.h"
#include "mojo/public/cpp/bindings/interface_request.h"
#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"
#include "mojo/public/cpp/bindings/thread_safe_interface_ptr.h"


#include "third_party/blink/renderer/platform/platform_export.h"



// Forward-declare for |AsValueInto| so that we do not have to import the
// corresponding header.
namespace base {
namespace trace_event {
class TracedValue;
}  // namespace trace_event
}  // namespace base


namespace blink {
namespace mojom {
namespace blink {

class NativeIOFileHostProxy;

template <typename ImplRefTraits>
class NativeIOFileHostStub;

class NativeIOFileHostRequestValidator;
class NativeIOFileHostResponseValidator;


class PLATFORM_EXPORT NativeIOFileHost
    : public NativeIOFileHostInterfaceBase {
 public:
  static const char Name_[];
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasSyncMethods_ = true;

  using Base_ = NativeIOFileHostInterfaceBase;
  using Proxy_ = NativeIOFileHostProxy;

  template <typename ImplRefTraits>
  using Stub_ = NativeIOFileHostStub<ImplRefTraits>;

  using RequestValidator_ = NativeIOFileHostRequestValidator;
  using ResponseValidator_ = NativeIOFileHostResponseValidator;
  enum MethodMinVersions : uint32_t {
    kCloseMinVersion = 0,
    kSetLengthMinVersion = 0,
  };
  virtual ~NativeIOFileHost() {}

  // Sync method. This signature is used by the client side; the service side
  // should implement the signature with callback below.
  
  virtual bool Close();

  using CloseCallback = base::OnceCallback<void()>;
  
  virtual void Close(CloseCallback callback) = 0;

  // Sync method. This signature is used by the client side; the service side
  // should implement the signature with callback below.
  
  virtual bool SetLength(int64_t length, ::base::File backing_file, bool* out_success, ::base::File* out_backing_file);

  using SetLengthCallback = base::OnceCallback<void(bool, ::base::File)>;
  
  virtual void SetLength(int64_t length, ::base::File backing_file, SetLengthCallback callback) = 0;
};

class NativeIOHostProxy;

template <typename ImplRefTraits>
class NativeIOHostStub;

class NativeIOHostRequestValidator;
class NativeIOHostResponseValidator;


class PLATFORM_EXPORT NativeIOHost
    : public NativeIOHostInterfaceBase {
 public:
  static const char Name_[];
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasSyncMethods_ = true;

  using Base_ = NativeIOHostInterfaceBase;
  using Proxy_ = NativeIOHostProxy;

  template <typename ImplRefTraits>
  using Stub_ = NativeIOHostStub<ImplRefTraits>;

  using RequestValidator_ = NativeIOHostRequestValidator;
  using ResponseValidator_ = NativeIOHostResponseValidator;
  enum MethodMinVersions : uint32_t {
    kOpenFileMinVersion = 0,
    kDeleteFileMinVersion = 0,
    kGetAllFileNamesMinVersion = 0,
    kRenameFileMinVersion = 0,
  };
  virtual ~NativeIOHost() {}

  // Sync method. This signature is used by the client side; the service side
  // should implement the signature with callback below.
  
  virtual bool OpenFile(const WTF::String& name, ::mojo::PendingReceiver<NativeIOFileHost> file_host_receiver, ::base::File* out_backing_file);

  using OpenFileCallback = base::OnceCallback<void(::base::File)>;
  
  virtual void OpenFile(const WTF::String& name, ::mojo::PendingReceiver<NativeIOFileHost> file_host_receiver, OpenFileCallback callback) = 0;

  // Sync method. This signature is used by the client side; the service side
  // should implement the signature with callback below.
  
  virtual bool DeleteFile(const WTF::String& name, bool* out_success);

  using DeleteFileCallback = base::OnceCallback<void(bool)>;
  
  virtual void DeleteFile(const WTF::String& name, DeleteFileCallback callback) = 0;

  // Sync method. This signature is used by the client side; the service side
  // should implement the signature with callback below.
  
  virtual bool GetAllFileNames(bool* out_success, WTF::Vector<WTF::String>* out_names);

  using GetAllFileNamesCallback = base::OnceCallback<void(bool, const WTF::Vector<WTF::String>&)>;
  
  virtual void GetAllFileNames(GetAllFileNamesCallback callback) = 0;

  // Sync method. This signature is used by the client side; the service side
  // should implement the signature with callback below.
  
  virtual bool RenameFile(const WTF::String& old_name, const WTF::String& new_name, bool* out_success);

  using RenameFileCallback = base::OnceCallback<void(bool)>;
  
  virtual void RenameFile(const WTF::String& old_name, const WTF::String& new_name, RenameFileCallback callback) = 0;
};



class PLATFORM_EXPORT NativeIOFileHostProxy
    : public NativeIOFileHost {
 public:
  using InterfaceType = NativeIOFileHost;

  explicit NativeIOFileHostProxy(mojo::MessageReceiverWithResponder* receiver);
  
  bool Close() final;
  
  void Close(CloseCallback callback) final;
  
  bool SetLength(int64_t length, ::base::File backing_file, bool* out_success, ::base::File* out_backing_file) final;
  
  void SetLength(int64_t length, ::base::File backing_file, SetLengthCallback callback) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class PLATFORM_EXPORT NativeIOHostProxy
    : public NativeIOHost {
 public:
  using InterfaceType = NativeIOHost;

  explicit NativeIOHostProxy(mojo::MessageReceiverWithResponder* receiver);
  
  bool OpenFile(const WTF::String& name, ::mojo::PendingReceiver<NativeIOFileHost> file_host_receiver, ::base::File* out_backing_file) final;
  
  void OpenFile(const WTF::String& name, ::mojo::PendingReceiver<NativeIOFileHost> file_host_receiver, OpenFileCallback callback) final;
  
  bool DeleteFile(const WTF::String& name, bool* out_success) final;
  
  void DeleteFile(const WTF::String& name, DeleteFileCallback callback) final;
  
  bool GetAllFileNames(bool* out_success, WTF::Vector<WTF::String>* out_names) final;
  
  void GetAllFileNames(GetAllFileNamesCallback callback) final;
  
  bool RenameFile(const WTF::String& old_name, const WTF::String& new_name, bool* out_success) final;
  
  void RenameFile(const WTF::String& old_name, const WTF::String& new_name, RenameFileCallback callback) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class PLATFORM_EXPORT NativeIOFileHostStubDispatch {
 public:
  static bool Accept(NativeIOFileHost* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      NativeIOFileHost* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<NativeIOFileHost>>
class NativeIOFileHostStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  NativeIOFileHostStub() {}
  ~NativeIOFileHostStub() override {}

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return NativeIOFileHostStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return NativeIOFileHostStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class PLATFORM_EXPORT NativeIOHostStubDispatch {
 public:
  static bool Accept(NativeIOHost* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      NativeIOHost* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<NativeIOHost>>
class NativeIOHostStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  NativeIOHostStub() {}
  ~NativeIOHostStub() override {}

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return NativeIOHostStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return NativeIOHostStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class PLATFORM_EXPORT NativeIOFileHostRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class PLATFORM_EXPORT NativeIOHostRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class PLATFORM_EXPORT NativeIOFileHostResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class PLATFORM_EXPORT NativeIOHostResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};





}  // namespace blink
}  // namespace mojom
}  // namespace blink

namespace mojo {

}  // namespace mojo

#endif  // THIRD_PARTY_BLINK_PUBLIC_MOJOM_NATIVE_IO_NATIVE_IO_MOJOM_BLINK_H_