// third_party/blink/public/mojom/input/input_handler.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_INPUT_INPUT_HANDLER_MOJOM_SHARED_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_INPUT_INPUT_HANDLER_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <ostream>
#include <type_traits>
#include <utility>

#include "base/compiler_specific.h"
#include "base/containers/flat_map.h"
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"
#include "third_party/blink/public/mojom/input/input_handler.mojom-shared-internal.h"
#include "cc/mojom/overscroll_behavior.mojom-shared.h"
#include "cc/mojom/touch_action.mojom-shared.h"
#include "mojo/public/mojom/base/string16.mojom-shared.h"
#include "mojo/public/mojom/base/time.mojom-shared.h"
#include "third_party/blink/public/mojom/input/gesture_event.mojom-shared.h"
#include "third_party/blink/public/mojom/input/input_event.mojom-shared.h"
#include "third_party/blink/public/mojom/input/input_event_result.mojom-shared.h"
#include "third_party/blink/public/mojom/input/pointer_lock_context.mojom-shared.h"
#include "third_party/blink/public/mojom/input/pointer_lock_result.mojom-shared.h"
#include "third_party/blink/public/mojom/input/synchronous_compositor.mojom-shared.h"
#include "third_party/blink/public/mojom/input/touch_event.mojom-shared.h"
#include "third_party/blink/public/mojom/selection_menu/selection_menu_behavior.mojom-shared.h"
#include "ui/base/ime/mojom/ime_types.mojom-shared.h"
#include "ui/events/mojom/event.mojom-shared.h"
#include "ui/events/mojom/event_constants.mojom-shared.h"
#include "ui/events/mojom/scroll_granularity.mojom-shared.h"
#include "ui/gfx/geometry/mojom/geometry.mojom-shared.h"
#include "ui/gfx/range/mojom/range.mojom-shared.h"
#include "ui/latency/mojom/latency_info.mojom-shared.h"
#include "mojo/public/cpp/bindings/lib/interface_serialization.h"


#include "mojo/public/cpp/bindings/native_enum.h"
#include "mojo/public/cpp/bindings/lib/native_struct_serialization.h"
#include "base/component_export.h"




namespace blink {
namespace mojom {
class KeyDataDataView;

class PointerDataDataView;

class WheelDataDataView;

class MouseDataDataView;

class ScrollUpdateDataView;

class ScrollDataDataView;

class PinchBeginDataDataView;

class PinchUpdateDataDataView;

class PinchEndDataDataView;

class FlingDataDataView;

class TapDataDataView;

class GestureDataDataView;

class TouchPointDataView;

class TouchDataDataView;

class EventDataView;

class DidOverscrollParamsDataView;

class TouchActionOptionalDataView;

class EditCommandDataView;



}  // namespace mojom
}  // namespace blink

namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::blink::mojom::KeyDataDataView> {
  using Data = ::blink::mojom::internal::KeyData_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::blink::mojom::PointerDataDataView> {
  using Data = ::blink::mojom::internal::PointerData_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::blink::mojom::WheelDataDataView> {
  using Data = ::blink::mojom::internal::WheelData_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::blink::mojom::MouseDataDataView> {
  using Data = ::blink::mojom::internal::MouseData_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::blink::mojom::ScrollUpdateDataView> {
  using Data = ::blink::mojom::internal::ScrollUpdate_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::blink::mojom::ScrollDataDataView> {
  using Data = ::blink::mojom::internal::ScrollData_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::blink::mojom::PinchBeginDataDataView> {
  using Data = ::blink::mojom::internal::PinchBeginData_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::blink::mojom::PinchUpdateDataDataView> {
  using Data = ::blink::mojom::internal::PinchUpdateData_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::blink::mojom::PinchEndDataDataView> {
  using Data = ::blink::mojom::internal::PinchEndData_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::blink::mojom::FlingDataDataView> {
  using Data = ::blink::mojom::internal::FlingData_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::blink::mojom::TapDataDataView> {
  using Data = ::blink::mojom::internal::TapData_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::blink::mojom::GestureDataDataView> {
  using Data = ::blink::mojom::internal::GestureData_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::blink::mojom::TouchPointDataView> {
  using Data = ::blink::mojom::internal::TouchPoint_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::blink::mojom::TouchDataDataView> {
  using Data = ::blink::mojom::internal::TouchData_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::blink::mojom::EventDataView> {
  using Data = ::blink::mojom::internal::Event_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::blink::mojom::DidOverscrollParamsDataView> {
  using Data = ::blink::mojom::internal::DidOverscrollParams_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::blink::mojom::TouchActionOptionalDataView> {
  using Data = ::blink::mojom::internal::TouchActionOptional_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::blink::mojom::EditCommandDataView> {
  using Data = ::blink::mojom::internal::EditCommand_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace blink {
namespace mojom {
// Interface base classes. They are used for type safety check.
class WidgetInputHandlerHostInterfaceBase {};

using WidgetInputHandlerHostPtrDataView =
    mojo::InterfacePtrDataView<WidgetInputHandlerHostInterfaceBase>;
using WidgetInputHandlerHostRequestDataView =
    mojo::InterfaceRequestDataView<WidgetInputHandlerHostInterfaceBase>;
using WidgetInputHandlerHostAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<WidgetInputHandlerHostInterfaceBase>;
using WidgetInputHandlerHostAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<WidgetInputHandlerHostInterfaceBase>;
class FrameWidgetInputHandlerInterfaceBase {};

using FrameWidgetInputHandlerPtrDataView =
    mojo::InterfacePtrDataView<FrameWidgetInputHandlerInterfaceBase>;
using FrameWidgetInputHandlerRequestDataView =
    mojo::InterfaceRequestDataView<FrameWidgetInputHandlerInterfaceBase>;
using FrameWidgetInputHandlerAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<FrameWidgetInputHandlerInterfaceBase>;
using FrameWidgetInputHandlerAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<FrameWidgetInputHandlerInterfaceBase>;
class WidgetInputHandlerInterfaceBase {};

using WidgetInputHandlerPtrDataView =
    mojo::InterfacePtrDataView<WidgetInputHandlerInterfaceBase>;
using WidgetInputHandlerRequestDataView =
    mojo::InterfaceRequestDataView<WidgetInputHandlerInterfaceBase>;
using WidgetInputHandlerAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<WidgetInputHandlerInterfaceBase>;
using WidgetInputHandlerAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<WidgetInputHandlerInterfaceBase>;


class KeyDataDataView {
 public:
  KeyDataDataView() {}

  KeyDataDataView(
      internal::KeyData_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data), context_(context) {}

  bool is_null() const { return !data_; }
  int32_t dom_key() const {
    return data_->dom_key;
  }
  int32_t dom_code() const {
    return data_->dom_code;
  }
  int32_t windows_key_code() const {
    return data_->windows_key_code;
  }
  int32_t native_key_code() const {
    return data_->native_key_code;
  }
  bool is_system_key() const {
    return data_->is_system_key;
  }
  bool is_browser_shortcut() const {
    return data_->is_browser_shortcut;
  }
  inline void GetTextDataView(
      ::mojo_base::mojom::String16DataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadText(UserType* output) {
    
    auto* pointer = data_->text.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::String16DataView>(
        pointer, output, context_);
  }
  inline void GetUnmodifiedTextDataView(
      ::mojo_base::mojom::String16DataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadUnmodifiedText(UserType* output) {
    
    auto* pointer = data_->unmodified_text.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::String16DataView>(
        pointer, output, context_);
  }
 private:
  internal::KeyData_Data* data_ = nullptr;
  mojo::internal::SerializationContext* context_ = nullptr;
};



class PointerDataDataView {
 public:
  PointerDataDataView() {}

  PointerDataDataView(
      internal::PointerData_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data), context_(context) {}

  bool is_null() const { return !data_; }
  int32_t pointer_id() const {
    return data_->pointer_id;
  }
  float force() const {
    return data_->force;
  }
  int32_t tilt_x() const {
    return data_->tilt_x;
  }
  int32_t tilt_y() const {
    return data_->tilt_y;
  }
  float tangential_pressure() const {
    return data_->tangential_pressure;
  }
  int32_t twist() const {
    return data_->twist;
  }
  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadButton(UserType* output) const {
    auto data_value = data_->button;
    return mojo::internal::Deserialize<::blink::mojom::Button>(
        data_value, output);
  }

  ::blink::mojom::Button button() const {
    return static_cast<::blink::mojom::Button>(data_->button);
  }
  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadPointerType(UserType* output) const {
    auto data_value = data_->pointer_type;
    return mojo::internal::Deserialize<::ui::mojom::EventPointerType>(
        data_value, output);
  }

  ::ui::mojom::EventPointerType pointer_type() const {
    return static_cast<::ui::mojom::EventPointerType>(data_->pointer_type);
  }
  int32_t movement_x() const {
    return data_->movement_x;
  }
  int32_t movement_y() const {
    return data_->movement_y;
  }
  bool is_raw_movement_event() const {
    return data_->is_raw_movement_event;
  }
  inline void GetWidgetPositionDataView(
      ::gfx::mojom::PointFDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadWidgetPosition(UserType* output) {
    
    auto* pointer = data_->widget_position.Get();
    return mojo::internal::Deserialize<::gfx::mojom::PointFDataView>(
        pointer, output, context_);
  }
  inline void GetScreenPositionDataView(
      ::gfx::mojom::PointFDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadScreenPosition(UserType* output) {
    
    auto* pointer = data_->screen_position.Get();
    return mojo::internal::Deserialize<::gfx::mojom::PointFDataView>(
        pointer, output, context_);
  }
  inline void GetMouseDataDataView(
      MouseDataDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadMouseData(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::blink::mojom::MouseDataDataView, UserType>(),
    "Attempting to read the optional `mouse_data` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with base::Optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadMouseData` instead "
    "of `ReadMouseData if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->mouse_data.Get();
    return mojo::internal::Deserialize<::blink::mojom::MouseDataDataView>(
        pointer, output, context_);
  }
 private:
  internal::PointerData_Data* data_ = nullptr;
  mojo::internal::SerializationContext* context_ = nullptr;
};



class WheelDataDataView {
 public:
  WheelDataDataView() {}

  WheelDataDataView(
      internal::WheelData_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data) {}

  bool is_null() const { return !data_; }
  float delta_x() const {
    return data_->delta_x;
  }
  float delta_y() const {
    return data_->delta_y;
  }
  float wheel_ticks_x() const {
    return data_->wheel_ticks_x;
  }
  float wheel_ticks_y() const {
    return data_->wheel_ticks_y;
  }
  float acceleration_ratio_x() const {
    return data_->acceleration_ratio_x;
  }
  float acceleration_ratio_y() const {
    return data_->acceleration_ratio_y;
  }
  uint8_t phase() const {
    return data_->phase;
  }
  uint8_t momentum_phase() const {
    return data_->momentum_phase;
  }
  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadCancelable(UserType* output) const {
    auto data_value = data_->cancelable;
    return mojo::internal::Deserialize<::blink::mojom::DispatchType>(
        data_value, output);
  }

  ::blink::mojom::DispatchType cancelable() const {
    return static_cast<::blink::mojom::DispatchType>(data_->cancelable);
  }
  uint8_t event_action() const {
    return data_->event_action;
  }
  uint8_t delta_units() const {
    return data_->delta_units;
  }
 private:
  internal::WheelData_Data* data_ = nullptr;
};



class MouseDataDataView {
 public:
  MouseDataDataView() {}

  MouseDataDataView(
      internal::MouseData_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data), context_(context) {}

  bool is_null() const { return !data_; }
  int32_t click_count() const {
    return data_->click_count;
  }
  inline void GetWheelDataDataView(
      WheelDataDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadWheelData(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::blink::mojom::WheelDataDataView, UserType>(),
    "Attempting to read the optional `wheel_data` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with base::Optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadWheelData` instead "
    "of `ReadWheelData if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->wheel_data.Get();
    return mojo::internal::Deserialize<::blink::mojom::WheelDataDataView>(
        pointer, output, context_);
  }
 private:
  internal::MouseData_Data* data_ = nullptr;
  mojo::internal::SerializationContext* context_ = nullptr;
};



class ScrollUpdateDataView {
 public:
  ScrollUpdateDataView() {}

  ScrollUpdateDataView(
      internal::ScrollUpdate_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data) {}

  bool is_null() const { return !data_; }
  float velocity_x() const {
    return data_->velocity_x;
  }
  float velocity_y() const {
    return data_->velocity_y;
  }
 private:
  internal::ScrollUpdate_Data* data_ = nullptr;
};



class ScrollDataDataView {
 public:
  ScrollDataDataView() {}

  ScrollDataDataView(
      internal::ScrollData_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data), context_(context) {}

  bool is_null() const { return !data_; }
  float delta_x() const {
    return data_->delta_x;
  }
  float delta_y() const {
    return data_->delta_y;
  }
  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadDeltaUnits(UserType* output) const {
    auto data_value = data_->delta_units;
    return mojo::internal::Deserialize<::ui::mojom::ScrollGranularity>(
        data_value, output);
  }

  ::ui::mojom::ScrollGranularity delta_units() const {
    return static_cast<::ui::mojom::ScrollGranularity>(data_->delta_units);
  }
  bool target_viewport() const {
    return data_->target_viewport;
  }
  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadInertialPhase(UserType* output) const {
    auto data_value = data_->inertial_phase;
    return mojo::internal::Deserialize<::blink::mojom::InertialPhaseState>(
        data_value, output);
  }

  ::blink::mojom::InertialPhaseState inertial_phase() const {
    return static_cast<::blink::mojom::InertialPhaseState>(data_->inertial_phase);
  }
  bool synthetic() const {
    return data_->synthetic;
  }
  int32_t pointer_count() const {
    return data_->pointer_count;
  }
  inline void GetUpdateDetailsDataView(
      ScrollUpdateDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadUpdateDetails(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::blink::mojom::ScrollUpdateDataView, UserType>(),
    "Attempting to read the optional `update_details` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with base::Optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadUpdateDetails` instead "
    "of `ReadUpdateDetails if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->update_details.Get();
    return mojo::internal::Deserialize<::blink::mojom::ScrollUpdateDataView>(
        pointer, output, context_);
  }
 private:
  internal::ScrollData_Data* data_ = nullptr;
  mojo::internal::SerializationContext* context_ = nullptr;
};



class PinchBeginDataDataView {
 public:
  PinchBeginDataDataView() {}

  PinchBeginDataDataView(
      internal::PinchBeginData_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data) {}

  bool is_null() const { return !data_; }
  bool needs_wheel_event() const {
    return data_->needs_wheel_event;
  }
 private:
  internal::PinchBeginData_Data* data_ = nullptr;
};



class PinchUpdateDataDataView {
 public:
  PinchUpdateDataDataView() {}

  PinchUpdateDataDataView(
      internal::PinchUpdateData_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data) {}

  bool is_null() const { return !data_; }
  float scale() const {
    return data_->scale;
  }
  bool zoom_disabled() const {
    return data_->zoom_disabled;
  }
  bool needs_wheel_event() const {
    return data_->needs_wheel_event;
  }
 private:
  internal::PinchUpdateData_Data* data_ = nullptr;
};



class PinchEndDataDataView {
 public:
  PinchEndDataDataView() {}

  PinchEndDataDataView(
      internal::PinchEndData_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data) {}

  bool is_null() const { return !data_; }
  bool needs_wheel_event() const {
    return data_->needs_wheel_event;
  }
 private:
  internal::PinchEndData_Data* data_ = nullptr;
};



class FlingDataDataView {
 public:
  FlingDataDataView() {}

  FlingDataDataView(
      internal::FlingData_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data) {}

  bool is_null() const { return !data_; }
  float velocity_x() const {
    return data_->velocity_x;
  }
  float velocity_y() const {
    return data_->velocity_y;
  }
  bool target_viewport() const {
    return data_->target_viewport;
  }
  bool prevent_boosting() const {
    return data_->prevent_boosting;
  }
 private:
  internal::FlingData_Data* data_ = nullptr;
};



class TapDataDataView {
 public:
  TapDataDataView() {}

  TapDataDataView(
      internal::TapData_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data) {}

  bool is_null() const { return !data_; }
  int32_t tap_count() const {
    return data_->tap_count;
  }
  bool needs_wheel_event() const {
    return data_->needs_wheel_event;
  }
 private:
  internal::TapData_Data* data_ = nullptr;
};



class GestureDataDataView {
 public:
  GestureDataDataView() {}

  GestureDataDataView(
      internal::GestureData_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data), context_(context) {}

  bool is_null() const { return !data_; }
  inline void GetScreenPositionDataView(
      ::gfx::mojom::PointFDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadScreenPosition(UserType* output) {
    
    auto* pointer = data_->screen_position.Get();
    return mojo::internal::Deserialize<::gfx::mojom::PointFDataView>(
        pointer, output, context_);
  }
  inline void GetWidgetPositionDataView(
      ::gfx::mojom::PointFDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadWidgetPosition(UserType* output) {
    
    auto* pointer = data_->widget_position.Get();
    return mojo::internal::Deserialize<::gfx::mojom::PointFDataView>(
        pointer, output, context_);
  }
  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadSourceDevice(UserType* output) const {
    auto data_value = data_->source_device;
    return mojo::internal::Deserialize<::blink::mojom::GestureDevice>(
        data_value, output);
  }

  ::blink::mojom::GestureDevice source_device() const {
    return static_cast<::blink::mojom::GestureDevice>(data_->source_device);
  }
  bool is_source_touch_event_set_non_blocking() const {
    return data_->is_source_touch_event_set_non_blocking;
  }
  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadPrimaryPointerType(UserType* output) const {
    auto data_value = data_->primary_pointer_type;
    return mojo::internal::Deserialize<::ui::mojom::EventPointerType>(
        data_value, output);
  }

  ::ui::mojom::EventPointerType primary_pointer_type() const {
    return static_cast<::ui::mojom::EventPointerType>(data_->primary_pointer_type);
  }
  int32_t unique_touch_event_id() const {
    return data_->unique_touch_event_id;
  }
  inline void GetContactSizeDataView(
      ::gfx::mojom::SizeDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadContactSize(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::gfx::mojom::SizeDataView, UserType>(),
    "Attempting to read the optional `contact_size` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with base::Optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadContactSize` instead "
    "of `ReadContactSize if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->contact_size.Get();
    return mojo::internal::Deserialize<::gfx::mojom::SizeDataView>(
        pointer, output, context_);
  }
  inline void GetScrollDataDataView(
      ScrollDataDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadScrollData(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::blink::mojom::ScrollDataDataView, UserType>(),
    "Attempting to read the optional `scroll_data` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with base::Optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadScrollData` instead "
    "of `ReadScrollData if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->scroll_data.Get();
    return mojo::internal::Deserialize<::blink::mojom::ScrollDataDataView>(
        pointer, output, context_);
  }
  inline void GetPinchBeginDataDataView(
      PinchBeginDataDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadPinchBeginData(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::blink::mojom::PinchBeginDataDataView, UserType>(),
    "Attempting to read the optional `pinch_begin_data` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with base::Optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadPinchBeginData` instead "
    "of `ReadPinchBeginData if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->pinch_begin_data.Get();
    return mojo::internal::Deserialize<::blink::mojom::PinchBeginDataDataView>(
        pointer, output, context_);
  }
  inline void GetPinchUpdateDataDataView(
      PinchUpdateDataDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadPinchUpdateData(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::blink::mojom::PinchUpdateDataDataView, UserType>(),
    "Attempting to read the optional `pinch_update_data` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with base::Optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadPinchUpdateData` instead "
    "of `ReadPinchUpdateData if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->pinch_update_data.Get();
    return mojo::internal::Deserialize<::blink::mojom::PinchUpdateDataDataView>(
        pointer, output, context_);
  }
  inline void GetPinchEndDataDataView(
      PinchEndDataDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadPinchEndData(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::blink::mojom::PinchEndDataDataView, UserType>(),
    "Attempting to read the optional `pinch_end_data` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with base::Optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadPinchEndData` instead "
    "of `ReadPinchEndData if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->pinch_end_data.Get();
    return mojo::internal::Deserialize<::blink::mojom::PinchEndDataDataView>(
        pointer, output, context_);
  }
  inline void GetTapDataDataView(
      TapDataDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadTapData(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::blink::mojom::TapDataDataView, UserType>(),
    "Attempting to read the optional `tap_data` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with base::Optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadTapData` instead "
    "of `ReadTapData if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->tap_data.Get();
    return mojo::internal::Deserialize<::blink::mojom::TapDataDataView>(
        pointer, output, context_);
  }
  inline void GetFlingDataDataView(
      FlingDataDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadFlingData(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::blink::mojom::FlingDataDataView, UserType>(),
    "Attempting to read the optional `fling_data` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with base::Optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadFlingData` instead "
    "of `ReadFlingData if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->fling_data.Get();
    return mojo::internal::Deserialize<::blink::mojom::FlingDataDataView>(
        pointer, output, context_);
  }
 private:
  internal::GestureData_Data* data_ = nullptr;
  mojo::internal::SerializationContext* context_ = nullptr;
};



class TouchPointDataView {
 public:
  TouchPointDataView() {}

  TouchPointDataView(
      internal::TouchPoint_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data), context_(context) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadState(UserType* output) const {
    auto data_value = data_->state;
    return mojo::internal::Deserialize<::blink::mojom::TouchState>(
        data_value, output);
  }

  ::blink::mojom::TouchState state() const {
    return static_cast<::blink::mojom::TouchState>(data_->state);
  }
  float radius_x() const {
    return data_->radius_x;
  }
  float radius_y() const {
    return data_->radius_y;
  }
  float rotation_angle() const {
    return data_->rotation_angle;
  }
  inline void GetPointerDataDataView(
      PointerDataDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadPointerData(UserType* output) {
    
    auto* pointer = data_->pointer_data.Get();
    return mojo::internal::Deserialize<::blink::mojom::PointerDataDataView>(
        pointer, output, context_);
  }
 private:
  internal::TouchPoint_Data* data_ = nullptr;
  mojo::internal::SerializationContext* context_ = nullptr;
};



class TouchDataDataView {
 public:
  TouchDataDataView() {}

  TouchDataDataView(
      internal::TouchData_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data), context_(context) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadCancelable(UserType* output) const {
    auto data_value = data_->cancelable;
    return mojo::internal::Deserialize<::blink::mojom::DispatchType>(
        data_value, output);
  }

  ::blink::mojom::DispatchType cancelable() const {
    return static_cast<::blink::mojom::DispatchType>(data_->cancelable);
  }
  bool moved_beyond_slop_region() const {
    return data_->moved_beyond_slop_region;
  }
  bool touch_start_or_first_move() const {
    return data_->touch_start_or_first_move;
  }
  bool hovering() const {
    return data_->hovering;
  }
  uint32_t unique_touch_event_id() const {
    return data_->unique_touch_event_id;
  }
  inline void GetTouchesDataView(
      mojo::ArrayDataView<TouchPointDataView>* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadTouches(UserType* output) {
    
    auto* pointer = data_->touches.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::blink::mojom::TouchPointDataView>>(
        pointer, output, context_);
  }
 private:
  internal::TouchData_Data* data_ = nullptr;
  mojo::internal::SerializationContext* context_ = nullptr;
};



class EventDataView {
 public:
  EventDataView() {}

  EventDataView(
      internal::Event_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data), context_(context) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadType(UserType* output) const {
    auto data_value = data_->type;
    return mojo::internal::Deserialize<::blink::mojom::EventType>(
        data_value, output);
  }

  ::blink::mojom::EventType type() const {
    return static_cast<::blink::mojom::EventType>(data_->type);
  }
  int32_t modifiers() const {
    return data_->modifiers;
  }
  inline void GetTimestampDataView(
      ::mojo_base::mojom::TimeTicksDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadTimestamp(UserType* output) {
    
    auto* pointer = data_->timestamp.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::TimeTicksDataView>(
        pointer, output, context_);
  }
  inline void GetLatencyDataView(
      ::ui::mojom::LatencyInfoDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadLatency(UserType* output) {
    
    auto* pointer = data_->latency.Get();
    return mojo::internal::Deserialize<::ui::mojom::LatencyInfoDataView>(
        pointer, output, context_);
  }
  inline void GetKeyDataDataView(
      KeyDataDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadKeyData(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::blink::mojom::KeyDataDataView, UserType>(),
    "Attempting to read the optional `key_data` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with base::Optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadKeyData` instead "
    "of `ReadKeyData if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->key_data.Get();
    return mojo::internal::Deserialize<::blink::mojom::KeyDataDataView>(
        pointer, output, context_);
  }
  inline void GetPointerDataDataView(
      PointerDataDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadPointerData(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::blink::mojom::PointerDataDataView, UserType>(),
    "Attempting to read the optional `pointer_data` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with base::Optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadPointerData` instead "
    "of `ReadPointerData if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->pointer_data.Get();
    return mojo::internal::Deserialize<::blink::mojom::PointerDataDataView>(
        pointer, output, context_);
  }
  inline void GetGestureDataDataView(
      GestureDataDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadGestureData(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::blink::mojom::GestureDataDataView, UserType>(),
    "Attempting to read the optional `gesture_data` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with base::Optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadGestureData` instead "
    "of `ReadGestureData if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->gesture_data.Get();
    return mojo::internal::Deserialize<::blink::mojom::GestureDataDataView>(
        pointer, output, context_);
  }
  inline void GetTouchDataDataView(
      TouchDataDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadTouchData(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::blink::mojom::TouchDataDataView, UserType>(),
    "Attempting to read the optional `touch_data` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with base::Optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadTouchData` instead "
    "of `ReadTouchData if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->touch_data.Get();
    return mojo::internal::Deserialize<::blink::mojom::TouchDataDataView>(
        pointer, output, context_);
  }
 private:
  internal::Event_Data* data_ = nullptr;
  mojo::internal::SerializationContext* context_ = nullptr;
};



class DidOverscrollParamsDataView {
 public:
  DidOverscrollParamsDataView() {}

  DidOverscrollParamsDataView(
      internal::DidOverscrollParams_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data), context_(context) {}

  bool is_null() const { return !data_; }
  inline void GetAccumulatedOverscrollDataView(
      ::gfx::mojom::Vector2dFDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadAccumulatedOverscroll(UserType* output) {
    
    auto* pointer = data_->accumulated_overscroll.Get();
    return mojo::internal::Deserialize<::gfx::mojom::Vector2dFDataView>(
        pointer, output, context_);
  }
  inline void GetLatestOverscrollDeltaDataView(
      ::gfx::mojom::Vector2dFDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadLatestOverscrollDelta(UserType* output) {
    
    auto* pointer = data_->latest_overscroll_delta.Get();
    return mojo::internal::Deserialize<::gfx::mojom::Vector2dFDataView>(
        pointer, output, context_);
  }
  inline void GetCurrentFlingVelocityDataView(
      ::gfx::mojom::Vector2dFDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadCurrentFlingVelocity(UserType* output) {
    
    auto* pointer = data_->current_fling_velocity.Get();
    return mojo::internal::Deserialize<::gfx::mojom::Vector2dFDataView>(
        pointer, output, context_);
  }
  inline void GetCausalEventViewportPointDataView(
      ::gfx::mojom::PointFDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadCausalEventViewportPoint(UserType* output) {
    
    auto* pointer = data_->causal_event_viewport_point.Get();
    return mojo::internal::Deserialize<::gfx::mojom::PointFDataView>(
        pointer, output, context_);
  }
  inline void GetOverscrollBehaviorDataView(
      ::cc::mojom::OverscrollBehaviorDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadOverscrollBehavior(UserType* output) {
    
    auto* pointer = data_->overscroll_behavior.Get();
    return mojo::internal::Deserialize<::cc::mojom::OverscrollBehaviorDataView>(
        pointer, output, context_);
  }
 private:
  internal::DidOverscrollParams_Data* data_ = nullptr;
  mojo::internal::SerializationContext* context_ = nullptr;
};



class TouchActionOptionalDataView {
 public:
  TouchActionOptionalDataView() {}

  TouchActionOptionalDataView(
      internal::TouchActionOptional_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadTouchAction(UserType* output) const {
    auto data_value = data_->touch_action;
    return mojo::internal::Deserialize<::cc::mojom::TouchAction>(
        data_value, output);
  }

  ::cc::mojom::TouchAction touch_action() const {
    return static_cast<::cc::mojom::TouchAction>(data_->touch_action);
  }
 private:
  internal::TouchActionOptional_Data* data_ = nullptr;
};



class EditCommandDataView {
 public:
  EditCommandDataView() {}

  EditCommandDataView(
      internal::EditCommand_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data), context_(context) {}

  bool is_null() const { return !data_; }
  inline void GetNameDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadName(UserType* output) {
    
    auto* pointer = data_->name.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, context_);
  }
  inline void GetValueDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadValue(UserType* output) {
    
    auto* pointer = data_->value.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, context_);
  }
 private:
  internal::EditCommand_Data* data_ = nullptr;
  mojo::internal::SerializationContext* context_ = nullptr;
};



}  // namespace mojom
}  // namespace blink

namespace std {

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::KeyDataDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::KeyDataDataView, UserType>;

  static void Serialize(MaybeConstUserType& input,
                        Buffer* buffer,
                        ::blink::mojom::internal::KeyData_Data::BufferWriter* output,
                        SerializationContext* context) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    (*output).Allocate(buffer);
    (*output)->dom_key = Traits::dom_key(input);
    (*output)->dom_code = Traits::dom_code(input);
    (*output)->windows_key_code = Traits::windows_key_code(input);
    (*output)->native_key_code = Traits::native_key_code(input);
    (*output)->is_system_key = Traits::is_system_key(input);
    (*output)->is_browser_shortcut = Traits::is_browser_shortcut(input);
    decltype(Traits::text(input)) in_text = Traits::text(input);
    typename decltype((*output)->text)::BaseType::BufferWriter
        text_writer;
    mojo::internal::Serialize<::mojo_base::mojom::String16DataView>(
        in_text, buffer, &text_writer, context);
    (*output)->text.Set(
        text_writer.is_null() ? nullptr : text_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->text.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null text in KeyData struct");
    decltype(Traits::unmodified_text(input)) in_unmodified_text = Traits::unmodified_text(input);
    typename decltype((*output)->unmodified_text)::BaseType::BufferWriter
        unmodified_text_writer;
    mojo::internal::Serialize<::mojo_base::mojom::String16DataView>(
        in_unmodified_text, buffer, &unmodified_text_writer, context);
    (*output)->unmodified_text.Set(
        unmodified_text_writer.is_null() ? nullptr : unmodified_text_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->unmodified_text.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null unmodified_text in KeyData struct");
  }

  static bool Deserialize(::blink::mojom::internal::KeyData_Data* input,
                          UserType* output,
                          SerializationContext* context) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::KeyDataDataView data_view(input, context);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::PointerDataDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::PointerDataDataView, UserType>;

  static void Serialize(MaybeConstUserType& input,
                        Buffer* buffer,
                        ::blink::mojom::internal::PointerData_Data::BufferWriter* output,
                        SerializationContext* context) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    (*output).Allocate(buffer);
    (*output)->pointer_id = Traits::pointer_id(input);
    (*output)->force = Traits::force(input);
    (*output)->tilt_x = Traits::tilt_x(input);
    (*output)->tilt_y = Traits::tilt_y(input);
    (*output)->tangential_pressure = Traits::tangential_pressure(input);
    (*output)->twist = Traits::twist(input);
    mojo::internal::Serialize<::blink::mojom::Button>(
        Traits::button(input), &(*output)->button);
    mojo::internal::Serialize<::ui::mojom::EventPointerType>(
        Traits::pointer_type(input), &(*output)->pointer_type);
    (*output)->movement_x = Traits::movement_x(input);
    (*output)->movement_y = Traits::movement_y(input);
    (*output)->is_raw_movement_event = Traits::is_raw_movement_event(input);
    decltype(Traits::widget_position(input)) in_widget_position = Traits::widget_position(input);
    typename decltype((*output)->widget_position)::BaseType::BufferWriter
        widget_position_writer;
    mojo::internal::Serialize<::gfx::mojom::PointFDataView>(
        in_widget_position, buffer, &widget_position_writer, context);
    (*output)->widget_position.Set(
        widget_position_writer.is_null() ? nullptr : widget_position_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->widget_position.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null widget_position in PointerData struct");
    decltype(Traits::screen_position(input)) in_screen_position = Traits::screen_position(input);
    typename decltype((*output)->screen_position)::BaseType::BufferWriter
        screen_position_writer;
    mojo::internal::Serialize<::gfx::mojom::PointFDataView>(
        in_screen_position, buffer, &screen_position_writer, context);
    (*output)->screen_position.Set(
        screen_position_writer.is_null() ? nullptr : screen_position_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->screen_position.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null screen_position in PointerData struct");
    decltype(Traits::mouse_data(input)) in_mouse_data = Traits::mouse_data(input);
    typename decltype((*output)->mouse_data)::BaseType::BufferWriter
        mouse_data_writer;
    mojo::internal::Serialize<::blink::mojom::MouseDataDataView>(
        in_mouse_data, buffer, &mouse_data_writer, context);
    (*output)->mouse_data.Set(
        mouse_data_writer.is_null() ? nullptr : mouse_data_writer.data());
  }

  static bool Deserialize(::blink::mojom::internal::PointerData_Data* input,
                          UserType* output,
                          SerializationContext* context) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::PointerDataDataView data_view(input, context);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::WheelDataDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::WheelDataDataView, UserType>;

  static void Serialize(MaybeConstUserType& input,
                        Buffer* buffer,
                        ::blink::mojom::internal::WheelData_Data::BufferWriter* output,
                        SerializationContext* context) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    (*output).Allocate(buffer);
    (*output)->delta_x = Traits::delta_x(input);
    (*output)->delta_y = Traits::delta_y(input);
    (*output)->wheel_ticks_x = Traits::wheel_ticks_x(input);
    (*output)->wheel_ticks_y = Traits::wheel_ticks_y(input);
    (*output)->acceleration_ratio_x = Traits::acceleration_ratio_x(input);
    (*output)->acceleration_ratio_y = Traits::acceleration_ratio_y(input);
    (*output)->phase = Traits::phase(input);
    (*output)->momentum_phase = Traits::momentum_phase(input);
    mojo::internal::Serialize<::blink::mojom::DispatchType>(
        Traits::cancelable(input), &(*output)->cancelable);
    (*output)->event_action = Traits::event_action(input);
    (*output)->delta_units = Traits::delta_units(input);
  }

  static bool Deserialize(::blink::mojom::internal::WheelData_Data* input,
                          UserType* output,
                          SerializationContext* context) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::WheelDataDataView data_view(input, context);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::MouseDataDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::MouseDataDataView, UserType>;

  static void Serialize(MaybeConstUserType& input,
                        Buffer* buffer,
                        ::blink::mojom::internal::MouseData_Data::BufferWriter* output,
                        SerializationContext* context) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    (*output).Allocate(buffer);
    (*output)->click_count = Traits::click_count(input);
    decltype(Traits::wheel_data(input)) in_wheel_data = Traits::wheel_data(input);
    typename decltype((*output)->wheel_data)::BaseType::BufferWriter
        wheel_data_writer;
    mojo::internal::Serialize<::blink::mojom::WheelDataDataView>(
        in_wheel_data, buffer, &wheel_data_writer, context);
    (*output)->wheel_data.Set(
        wheel_data_writer.is_null() ? nullptr : wheel_data_writer.data());
  }

  static bool Deserialize(::blink::mojom::internal::MouseData_Data* input,
                          UserType* output,
                          SerializationContext* context) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::MouseDataDataView data_view(input, context);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::ScrollUpdateDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::ScrollUpdateDataView, UserType>;

  static void Serialize(MaybeConstUserType& input,
                        Buffer* buffer,
                        ::blink::mojom::internal::ScrollUpdate_Data::BufferWriter* output,
                        SerializationContext* context) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    (*output).Allocate(buffer);
    (*output)->velocity_x = Traits::velocity_x(input);
    (*output)->velocity_y = Traits::velocity_y(input);
  }

  static bool Deserialize(::blink::mojom::internal::ScrollUpdate_Data* input,
                          UserType* output,
                          SerializationContext* context) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::ScrollUpdateDataView data_view(input, context);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::ScrollDataDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::ScrollDataDataView, UserType>;

  static void Serialize(MaybeConstUserType& input,
                        Buffer* buffer,
                        ::blink::mojom::internal::ScrollData_Data::BufferWriter* output,
                        SerializationContext* context) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    (*output).Allocate(buffer);
    (*output)->delta_x = Traits::delta_x(input);
    (*output)->delta_y = Traits::delta_y(input);
    mojo::internal::Serialize<::ui::mojom::ScrollGranularity>(
        Traits::delta_units(input), &(*output)->delta_units);
    (*output)->target_viewport = Traits::target_viewport(input);
    mojo::internal::Serialize<::blink::mojom::InertialPhaseState>(
        Traits::inertial_phase(input), &(*output)->inertial_phase);
    (*output)->synthetic = Traits::synthetic(input);
    (*output)->pointer_count = Traits::pointer_count(input);
    decltype(Traits::update_details(input)) in_update_details = Traits::update_details(input);
    typename decltype((*output)->update_details)::BaseType::BufferWriter
        update_details_writer;
    mojo::internal::Serialize<::blink::mojom::ScrollUpdateDataView>(
        in_update_details, buffer, &update_details_writer, context);
    (*output)->update_details.Set(
        update_details_writer.is_null() ? nullptr : update_details_writer.data());
  }

  static bool Deserialize(::blink::mojom::internal::ScrollData_Data* input,
                          UserType* output,
                          SerializationContext* context) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::ScrollDataDataView data_view(input, context);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::PinchBeginDataDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::PinchBeginDataDataView, UserType>;

  static void Serialize(MaybeConstUserType& input,
                        Buffer* buffer,
                        ::blink::mojom::internal::PinchBeginData_Data::BufferWriter* output,
                        SerializationContext* context) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    (*output).Allocate(buffer);
    (*output)->needs_wheel_event = Traits::needs_wheel_event(input);
  }

  static bool Deserialize(::blink::mojom::internal::PinchBeginData_Data* input,
                          UserType* output,
                          SerializationContext* context) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::PinchBeginDataDataView data_view(input, context);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::PinchUpdateDataDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::PinchUpdateDataDataView, UserType>;

  static void Serialize(MaybeConstUserType& input,
                        Buffer* buffer,
                        ::blink::mojom::internal::PinchUpdateData_Data::BufferWriter* output,
                        SerializationContext* context) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    (*output).Allocate(buffer);
    (*output)->scale = Traits::scale(input);
    (*output)->zoom_disabled = Traits::zoom_disabled(input);
    (*output)->needs_wheel_event = Traits::needs_wheel_event(input);
  }

  static bool Deserialize(::blink::mojom::internal::PinchUpdateData_Data* input,
                          UserType* output,
                          SerializationContext* context) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::PinchUpdateDataDataView data_view(input, context);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::PinchEndDataDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::PinchEndDataDataView, UserType>;

  static void Serialize(MaybeConstUserType& input,
                        Buffer* buffer,
                        ::blink::mojom::internal::PinchEndData_Data::BufferWriter* output,
                        SerializationContext* context) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    (*output).Allocate(buffer);
    (*output)->needs_wheel_event = Traits::needs_wheel_event(input);
  }

  static bool Deserialize(::blink::mojom::internal::PinchEndData_Data* input,
                          UserType* output,
                          SerializationContext* context) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::PinchEndDataDataView data_view(input, context);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::FlingDataDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::FlingDataDataView, UserType>;

  static void Serialize(MaybeConstUserType& input,
                        Buffer* buffer,
                        ::blink::mojom::internal::FlingData_Data::BufferWriter* output,
                        SerializationContext* context) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    (*output).Allocate(buffer);
    (*output)->velocity_x = Traits::velocity_x(input);
    (*output)->velocity_y = Traits::velocity_y(input);
    (*output)->target_viewport = Traits::target_viewport(input);
    (*output)->prevent_boosting = Traits::prevent_boosting(input);
  }

  static bool Deserialize(::blink::mojom::internal::FlingData_Data* input,
                          UserType* output,
                          SerializationContext* context) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::FlingDataDataView data_view(input, context);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::TapDataDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::TapDataDataView, UserType>;

  static void Serialize(MaybeConstUserType& input,
                        Buffer* buffer,
                        ::blink::mojom::internal::TapData_Data::BufferWriter* output,
                        SerializationContext* context) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    (*output).Allocate(buffer);
    (*output)->tap_count = Traits::tap_count(input);
    (*output)->needs_wheel_event = Traits::needs_wheel_event(input);
  }

  static bool Deserialize(::blink::mojom::internal::TapData_Data* input,
                          UserType* output,
                          SerializationContext* context) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::TapDataDataView data_view(input, context);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::GestureDataDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::GestureDataDataView, UserType>;

  static void Serialize(MaybeConstUserType& input,
                        Buffer* buffer,
                        ::blink::mojom::internal::GestureData_Data::BufferWriter* output,
                        SerializationContext* context) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    (*output).Allocate(buffer);
    decltype(Traits::screen_position(input)) in_screen_position = Traits::screen_position(input);
    typename decltype((*output)->screen_position)::BaseType::BufferWriter
        screen_position_writer;
    mojo::internal::Serialize<::gfx::mojom::PointFDataView>(
        in_screen_position, buffer, &screen_position_writer, context);
    (*output)->screen_position.Set(
        screen_position_writer.is_null() ? nullptr : screen_position_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->screen_position.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null screen_position in GestureData struct");
    decltype(Traits::widget_position(input)) in_widget_position = Traits::widget_position(input);
    typename decltype((*output)->widget_position)::BaseType::BufferWriter
        widget_position_writer;
    mojo::internal::Serialize<::gfx::mojom::PointFDataView>(
        in_widget_position, buffer, &widget_position_writer, context);
    (*output)->widget_position.Set(
        widget_position_writer.is_null() ? nullptr : widget_position_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->widget_position.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null widget_position in GestureData struct");
    mojo::internal::Serialize<::blink::mojom::GestureDevice>(
        Traits::source_device(input), &(*output)->source_device);
    (*output)->is_source_touch_event_set_non_blocking = Traits::is_source_touch_event_set_non_blocking(input);
    mojo::internal::Serialize<::ui::mojom::EventPointerType>(
        Traits::primary_pointer_type(input), &(*output)->primary_pointer_type);
    (*output)->unique_touch_event_id = Traits::unique_touch_event_id(input);
    decltype(Traits::contact_size(input)) in_contact_size = Traits::contact_size(input);
    typename decltype((*output)->contact_size)::BaseType::BufferWriter
        contact_size_writer;
    mojo::internal::Serialize<::gfx::mojom::SizeDataView>(
        in_contact_size, buffer, &contact_size_writer, context);
    (*output)->contact_size.Set(
        contact_size_writer.is_null() ? nullptr : contact_size_writer.data());
    decltype(Traits::scroll_data(input)) in_scroll_data = Traits::scroll_data(input);
    typename decltype((*output)->scroll_data)::BaseType::BufferWriter
        scroll_data_writer;
    mojo::internal::Serialize<::blink::mojom::ScrollDataDataView>(
        in_scroll_data, buffer, &scroll_data_writer, context);
    (*output)->scroll_data.Set(
        scroll_data_writer.is_null() ? nullptr : scroll_data_writer.data());
    decltype(Traits::pinch_begin_data(input)) in_pinch_begin_data = Traits::pinch_begin_data(input);
    typename decltype((*output)->pinch_begin_data)::BaseType::BufferWriter
        pinch_begin_data_writer;
    mojo::internal::Serialize<::blink::mojom::PinchBeginDataDataView>(
        in_pinch_begin_data, buffer, &pinch_begin_data_writer, context);
    (*output)->pinch_begin_data.Set(
        pinch_begin_data_writer.is_null() ? nullptr : pinch_begin_data_writer.data());
    decltype(Traits::pinch_update_data(input)) in_pinch_update_data = Traits::pinch_update_data(input);
    typename decltype((*output)->pinch_update_data)::BaseType::BufferWriter
        pinch_update_data_writer;
    mojo::internal::Serialize<::blink::mojom::PinchUpdateDataDataView>(
        in_pinch_update_data, buffer, &pinch_update_data_writer, context);
    (*output)->pinch_update_data.Set(
        pinch_update_data_writer.is_null() ? nullptr : pinch_update_data_writer.data());
    decltype(Traits::pinch_end_data(input)) in_pinch_end_data = Traits::pinch_end_data(input);
    typename decltype((*output)->pinch_end_data)::BaseType::BufferWriter
        pinch_end_data_writer;
    mojo::internal::Serialize<::blink::mojom::PinchEndDataDataView>(
        in_pinch_end_data, buffer, &pinch_end_data_writer, context);
    (*output)->pinch_end_data.Set(
        pinch_end_data_writer.is_null() ? nullptr : pinch_end_data_writer.data());
    decltype(Traits::tap_data(input)) in_tap_data = Traits::tap_data(input);
    typename decltype((*output)->tap_data)::BaseType::BufferWriter
        tap_data_writer;
    mojo::internal::Serialize<::blink::mojom::TapDataDataView>(
        in_tap_data, buffer, &tap_data_writer, context);
    (*output)->tap_data.Set(
        tap_data_writer.is_null() ? nullptr : tap_data_writer.data());
    decltype(Traits::fling_data(input)) in_fling_data = Traits::fling_data(input);
    typename decltype((*output)->fling_data)::BaseType::BufferWriter
        fling_data_writer;
    mojo::internal::Serialize<::blink::mojom::FlingDataDataView>(
        in_fling_data, buffer, &fling_data_writer, context);
    (*output)->fling_data.Set(
        fling_data_writer.is_null() ? nullptr : fling_data_writer.data());
  }

  static bool Deserialize(::blink::mojom::internal::GestureData_Data* input,
                          UserType* output,
                          SerializationContext* context) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::GestureDataDataView data_view(input, context);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::TouchPointDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::TouchPointDataView, UserType>;

  static void Serialize(MaybeConstUserType& input,
                        Buffer* buffer,
                        ::blink::mojom::internal::TouchPoint_Data::BufferWriter* output,
                        SerializationContext* context) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    (*output).Allocate(buffer);
    mojo::internal::Serialize<::blink::mojom::TouchState>(
        Traits::state(input), &(*output)->state);
    (*output)->radius_x = Traits::radius_x(input);
    (*output)->radius_y = Traits::radius_y(input);
    (*output)->rotation_angle = Traits::rotation_angle(input);
    decltype(Traits::pointer_data(input)) in_pointer_data = Traits::pointer_data(input);
    typename decltype((*output)->pointer_data)::BaseType::BufferWriter
        pointer_data_writer;
    mojo::internal::Serialize<::blink::mojom::PointerDataDataView>(
        in_pointer_data, buffer, &pointer_data_writer, context);
    (*output)->pointer_data.Set(
        pointer_data_writer.is_null() ? nullptr : pointer_data_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->pointer_data.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null pointer_data in TouchPoint struct");
  }

  static bool Deserialize(::blink::mojom::internal::TouchPoint_Data* input,
                          UserType* output,
                          SerializationContext* context) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::TouchPointDataView data_view(input, context);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::TouchDataDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::TouchDataDataView, UserType>;

  static void Serialize(MaybeConstUserType& input,
                        Buffer* buffer,
                        ::blink::mojom::internal::TouchData_Data::BufferWriter* output,
                        SerializationContext* context) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    (*output).Allocate(buffer);
    mojo::internal::Serialize<::blink::mojom::DispatchType>(
        Traits::cancelable(input), &(*output)->cancelable);
    (*output)->moved_beyond_slop_region = Traits::moved_beyond_slop_region(input);
    (*output)->touch_start_or_first_move = Traits::touch_start_or_first_move(input);
    (*output)->hovering = Traits::hovering(input);
    (*output)->unique_touch_event_id = Traits::unique_touch_event_id(input);
    decltype(Traits::touches(input)) in_touches = Traits::touches(input);
    typename decltype((*output)->touches)::BaseType::BufferWriter
        touches_writer;
    const mojo::internal::ContainerValidateParams touches_validate_params(
        0, false, nullptr);
    mojo::internal::Serialize<mojo::ArrayDataView<::blink::mojom::TouchPointDataView>>(
        in_touches, buffer, &touches_writer, &touches_validate_params,
        context);
    (*output)->touches.Set(
        touches_writer.is_null() ? nullptr : touches_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->touches.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null touches in TouchData struct");
  }

  static bool Deserialize(::blink::mojom::internal::TouchData_Data* input,
                          UserType* output,
                          SerializationContext* context) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::TouchDataDataView data_view(input, context);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::EventDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::EventDataView, UserType>;

  static void Serialize(MaybeConstUserType& input,
                        Buffer* buffer,
                        ::blink::mojom::internal::Event_Data::BufferWriter* output,
                        SerializationContext* context) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    (*output).Allocate(buffer);
    mojo::internal::Serialize<::blink::mojom::EventType>(
        Traits::type(input), &(*output)->type);
    (*output)->modifiers = Traits::modifiers(input);
    decltype(Traits::timestamp(input)) in_timestamp = Traits::timestamp(input);
    typename decltype((*output)->timestamp)::BaseType::BufferWriter
        timestamp_writer;
    mojo::internal::Serialize<::mojo_base::mojom::TimeTicksDataView>(
        in_timestamp, buffer, &timestamp_writer, context);
    (*output)->timestamp.Set(
        timestamp_writer.is_null() ? nullptr : timestamp_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->timestamp.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null timestamp in Event struct");
    decltype(Traits::latency(input)) in_latency = Traits::latency(input);
    typename decltype((*output)->latency)::BaseType::BufferWriter
        latency_writer;
    mojo::internal::Serialize<::ui::mojom::LatencyInfoDataView>(
        in_latency, buffer, &latency_writer, context);
    (*output)->latency.Set(
        latency_writer.is_null() ? nullptr : latency_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->latency.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null latency in Event struct");
    decltype(Traits::key_data(input)) in_key_data = Traits::key_data(input);
    typename decltype((*output)->key_data)::BaseType::BufferWriter
        key_data_writer;
    mojo::internal::Serialize<::blink::mojom::KeyDataDataView>(
        in_key_data, buffer, &key_data_writer, context);
    (*output)->key_data.Set(
        key_data_writer.is_null() ? nullptr : key_data_writer.data());
    decltype(Traits::pointer_data(input)) in_pointer_data = Traits::pointer_data(input);
    typename decltype((*output)->pointer_data)::BaseType::BufferWriter
        pointer_data_writer;
    mojo::internal::Serialize<::blink::mojom::PointerDataDataView>(
        in_pointer_data, buffer, &pointer_data_writer, context);
    (*output)->pointer_data.Set(
        pointer_data_writer.is_null() ? nullptr : pointer_data_writer.data());
    decltype(Traits::gesture_data(input)) in_gesture_data = Traits::gesture_data(input);
    typename decltype((*output)->gesture_data)::BaseType::BufferWriter
        gesture_data_writer;
    mojo::internal::Serialize<::blink::mojom::GestureDataDataView>(
        in_gesture_data, buffer, &gesture_data_writer, context);
    (*output)->gesture_data.Set(
        gesture_data_writer.is_null() ? nullptr : gesture_data_writer.data());
    decltype(Traits::touch_data(input)) in_touch_data = Traits::touch_data(input);
    typename decltype((*output)->touch_data)::BaseType::BufferWriter
        touch_data_writer;
    mojo::internal::Serialize<::blink::mojom::TouchDataDataView>(
        in_touch_data, buffer, &touch_data_writer, context);
    (*output)->touch_data.Set(
        touch_data_writer.is_null() ? nullptr : touch_data_writer.data());
  }

  static bool Deserialize(::blink::mojom::internal::Event_Data* input,
                          UserType* output,
                          SerializationContext* context) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::EventDataView data_view(input, context);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::DidOverscrollParamsDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::DidOverscrollParamsDataView, UserType>;

  static void Serialize(MaybeConstUserType& input,
                        Buffer* buffer,
                        ::blink::mojom::internal::DidOverscrollParams_Data::BufferWriter* output,
                        SerializationContext* context) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    (*output).Allocate(buffer);
    decltype(Traits::accumulated_overscroll(input)) in_accumulated_overscroll = Traits::accumulated_overscroll(input);
    typename decltype((*output)->accumulated_overscroll)::BaseType::BufferWriter
        accumulated_overscroll_writer;
    mojo::internal::Serialize<::gfx::mojom::Vector2dFDataView>(
        in_accumulated_overscroll, buffer, &accumulated_overscroll_writer, context);
    (*output)->accumulated_overscroll.Set(
        accumulated_overscroll_writer.is_null() ? nullptr : accumulated_overscroll_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->accumulated_overscroll.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null accumulated_overscroll in DidOverscrollParams struct");
    decltype(Traits::latest_overscroll_delta(input)) in_latest_overscroll_delta = Traits::latest_overscroll_delta(input);
    typename decltype((*output)->latest_overscroll_delta)::BaseType::BufferWriter
        latest_overscroll_delta_writer;
    mojo::internal::Serialize<::gfx::mojom::Vector2dFDataView>(
        in_latest_overscroll_delta, buffer, &latest_overscroll_delta_writer, context);
    (*output)->latest_overscroll_delta.Set(
        latest_overscroll_delta_writer.is_null() ? nullptr : latest_overscroll_delta_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->latest_overscroll_delta.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null latest_overscroll_delta in DidOverscrollParams struct");
    decltype(Traits::current_fling_velocity(input)) in_current_fling_velocity = Traits::current_fling_velocity(input);
    typename decltype((*output)->current_fling_velocity)::BaseType::BufferWriter
        current_fling_velocity_writer;
    mojo::internal::Serialize<::gfx::mojom::Vector2dFDataView>(
        in_current_fling_velocity, buffer, &current_fling_velocity_writer, context);
    (*output)->current_fling_velocity.Set(
        current_fling_velocity_writer.is_null() ? nullptr : current_fling_velocity_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->current_fling_velocity.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null current_fling_velocity in DidOverscrollParams struct");
    decltype(Traits::causal_event_viewport_point(input)) in_causal_event_viewport_point = Traits::causal_event_viewport_point(input);
    typename decltype((*output)->causal_event_viewport_point)::BaseType::BufferWriter
        causal_event_viewport_point_writer;
    mojo::internal::Serialize<::gfx::mojom::PointFDataView>(
        in_causal_event_viewport_point, buffer, &causal_event_viewport_point_writer, context);
    (*output)->causal_event_viewport_point.Set(
        causal_event_viewport_point_writer.is_null() ? nullptr : causal_event_viewport_point_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->causal_event_viewport_point.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null causal_event_viewport_point in DidOverscrollParams struct");
    decltype(Traits::overscroll_behavior(input)) in_overscroll_behavior = Traits::overscroll_behavior(input);
    typename decltype((*output)->overscroll_behavior)::BaseType::BufferWriter
        overscroll_behavior_writer;
    mojo::internal::Serialize<::cc::mojom::OverscrollBehaviorDataView>(
        in_overscroll_behavior, buffer, &overscroll_behavior_writer, context);
    (*output)->overscroll_behavior.Set(
        overscroll_behavior_writer.is_null() ? nullptr : overscroll_behavior_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->overscroll_behavior.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null overscroll_behavior in DidOverscrollParams struct");
  }

  static bool Deserialize(::blink::mojom::internal::DidOverscrollParams_Data* input,
                          UserType* output,
                          SerializationContext* context) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::DidOverscrollParamsDataView data_view(input, context);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::TouchActionOptionalDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::TouchActionOptionalDataView, UserType>;

  static void Serialize(MaybeConstUserType& input,
                        Buffer* buffer,
                        ::blink::mojom::internal::TouchActionOptional_Data::BufferWriter* output,
                        SerializationContext* context) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    (*output).Allocate(buffer);
    mojo::internal::Serialize<::cc::mojom::TouchAction>(
        Traits::touch_action(input), &(*output)->touch_action);
  }

  static bool Deserialize(::blink::mojom::internal::TouchActionOptional_Data* input,
                          UserType* output,
                          SerializationContext* context) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::TouchActionOptionalDataView data_view(input, context);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::EditCommandDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::EditCommandDataView, UserType>;

  static void Serialize(MaybeConstUserType& input,
                        Buffer* buffer,
                        ::blink::mojom::internal::EditCommand_Data::BufferWriter* output,
                        SerializationContext* context) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    (*output).Allocate(buffer);
    decltype(Traits::name(input)) in_name = Traits::name(input);
    typename decltype((*output)->name)::BaseType::BufferWriter
        name_writer;
    mojo::internal::Serialize<mojo::StringDataView>(
        in_name, buffer, &name_writer, context);
    (*output)->name.Set(
        name_writer.is_null() ? nullptr : name_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->name.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null name in EditCommand struct");
    decltype(Traits::value(input)) in_value = Traits::value(input);
    typename decltype((*output)->value)::BaseType::BufferWriter
        value_writer;
    mojo::internal::Serialize<mojo::StringDataView>(
        in_value, buffer, &value_writer, context);
    (*output)->value.Set(
        value_writer.is_null() ? nullptr : value_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->value.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null value in EditCommand struct");
  }

  static bool Deserialize(::blink::mojom::internal::EditCommand_Data* input,
                          UserType* output,
                          SerializationContext* context) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::EditCommandDataView data_view(input, context);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace blink {
namespace mojom {

inline void KeyDataDataView::GetTextDataView(
    ::mojo_base::mojom::String16DataView* output) {
  auto pointer = data_->text.Get();
  *output = ::mojo_base::mojom::String16DataView(pointer, context_);
}
inline void KeyDataDataView::GetUnmodifiedTextDataView(
    ::mojo_base::mojom::String16DataView* output) {
  auto pointer = data_->unmodified_text.Get();
  *output = ::mojo_base::mojom::String16DataView(pointer, context_);
}


inline void PointerDataDataView::GetWidgetPositionDataView(
    ::gfx::mojom::PointFDataView* output) {
  auto pointer = data_->widget_position.Get();
  *output = ::gfx::mojom::PointFDataView(pointer, context_);
}
inline void PointerDataDataView::GetScreenPositionDataView(
    ::gfx::mojom::PointFDataView* output) {
  auto pointer = data_->screen_position.Get();
  *output = ::gfx::mojom::PointFDataView(pointer, context_);
}
inline void PointerDataDataView::GetMouseDataDataView(
    MouseDataDataView* output) {
  auto pointer = data_->mouse_data.Get();
  *output = MouseDataDataView(pointer, context_);
}




inline void MouseDataDataView::GetWheelDataDataView(
    WheelDataDataView* output) {
  auto pointer = data_->wheel_data.Get();
  *output = WheelDataDataView(pointer, context_);
}




inline void ScrollDataDataView::GetUpdateDetailsDataView(
    ScrollUpdateDataView* output) {
  auto pointer = data_->update_details.Get();
  *output = ScrollUpdateDataView(pointer, context_);
}












inline void GestureDataDataView::GetScreenPositionDataView(
    ::gfx::mojom::PointFDataView* output) {
  auto pointer = data_->screen_position.Get();
  *output = ::gfx::mojom::PointFDataView(pointer, context_);
}
inline void GestureDataDataView::GetWidgetPositionDataView(
    ::gfx::mojom::PointFDataView* output) {
  auto pointer = data_->widget_position.Get();
  *output = ::gfx::mojom::PointFDataView(pointer, context_);
}
inline void GestureDataDataView::GetContactSizeDataView(
    ::gfx::mojom::SizeDataView* output) {
  auto pointer = data_->contact_size.Get();
  *output = ::gfx::mojom::SizeDataView(pointer, context_);
}
inline void GestureDataDataView::GetScrollDataDataView(
    ScrollDataDataView* output) {
  auto pointer = data_->scroll_data.Get();
  *output = ScrollDataDataView(pointer, context_);
}
inline void GestureDataDataView::GetPinchBeginDataDataView(
    PinchBeginDataDataView* output) {
  auto pointer = data_->pinch_begin_data.Get();
  *output = PinchBeginDataDataView(pointer, context_);
}
inline void GestureDataDataView::GetPinchUpdateDataDataView(
    PinchUpdateDataDataView* output) {
  auto pointer = data_->pinch_update_data.Get();
  *output = PinchUpdateDataDataView(pointer, context_);
}
inline void GestureDataDataView::GetPinchEndDataDataView(
    PinchEndDataDataView* output) {
  auto pointer = data_->pinch_end_data.Get();
  *output = PinchEndDataDataView(pointer, context_);
}
inline void GestureDataDataView::GetTapDataDataView(
    TapDataDataView* output) {
  auto pointer = data_->tap_data.Get();
  *output = TapDataDataView(pointer, context_);
}
inline void GestureDataDataView::GetFlingDataDataView(
    FlingDataDataView* output) {
  auto pointer = data_->fling_data.Get();
  *output = FlingDataDataView(pointer, context_);
}


inline void TouchPointDataView::GetPointerDataDataView(
    PointerDataDataView* output) {
  auto pointer = data_->pointer_data.Get();
  *output = PointerDataDataView(pointer, context_);
}


inline void TouchDataDataView::GetTouchesDataView(
    mojo::ArrayDataView<TouchPointDataView>* output) {
  auto pointer = data_->touches.Get();
  *output = mojo::ArrayDataView<TouchPointDataView>(pointer, context_);
}


inline void EventDataView::GetTimestampDataView(
    ::mojo_base::mojom::TimeTicksDataView* output) {
  auto pointer = data_->timestamp.Get();
  *output = ::mojo_base::mojom::TimeTicksDataView(pointer, context_);
}
inline void EventDataView::GetLatencyDataView(
    ::ui::mojom::LatencyInfoDataView* output) {
  auto pointer = data_->latency.Get();
  *output = ::ui::mojom::LatencyInfoDataView(pointer, context_);
}
inline void EventDataView::GetKeyDataDataView(
    KeyDataDataView* output) {
  auto pointer = data_->key_data.Get();
  *output = KeyDataDataView(pointer, context_);
}
inline void EventDataView::GetPointerDataDataView(
    PointerDataDataView* output) {
  auto pointer = data_->pointer_data.Get();
  *output = PointerDataDataView(pointer, context_);
}
inline void EventDataView::GetGestureDataDataView(
    GestureDataDataView* output) {
  auto pointer = data_->gesture_data.Get();
  *output = GestureDataDataView(pointer, context_);
}
inline void EventDataView::GetTouchDataDataView(
    TouchDataDataView* output) {
  auto pointer = data_->touch_data.Get();
  *output = TouchDataDataView(pointer, context_);
}


inline void DidOverscrollParamsDataView::GetAccumulatedOverscrollDataView(
    ::gfx::mojom::Vector2dFDataView* output) {
  auto pointer = data_->accumulated_overscroll.Get();
  *output = ::gfx::mojom::Vector2dFDataView(pointer, context_);
}
inline void DidOverscrollParamsDataView::GetLatestOverscrollDeltaDataView(
    ::gfx::mojom::Vector2dFDataView* output) {
  auto pointer = data_->latest_overscroll_delta.Get();
  *output = ::gfx::mojom::Vector2dFDataView(pointer, context_);
}
inline void DidOverscrollParamsDataView::GetCurrentFlingVelocityDataView(
    ::gfx::mojom::Vector2dFDataView* output) {
  auto pointer = data_->current_fling_velocity.Get();
  *output = ::gfx::mojom::Vector2dFDataView(pointer, context_);
}
inline void DidOverscrollParamsDataView::GetCausalEventViewportPointDataView(
    ::gfx::mojom::PointFDataView* output) {
  auto pointer = data_->causal_event_viewport_point.Get();
  *output = ::gfx::mojom::PointFDataView(pointer, context_);
}
inline void DidOverscrollParamsDataView::GetOverscrollBehaviorDataView(
    ::cc::mojom::OverscrollBehaviorDataView* output) {
  auto pointer = data_->overscroll_behavior.Get();
  *output = ::cc::mojom::OverscrollBehaviorDataView(pointer, context_);
}




inline void EditCommandDataView::GetNameDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->name.Get();
  *output = mojo::StringDataView(pointer, context_);
}
inline void EditCommandDataView::GetValueDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->value.Get();
  *output = mojo::StringDataView(pointer, context_);
}



}  // namespace mojom
}  // namespace blink

#endif  // THIRD_PARTY_BLINK_PUBLIC_MOJOM_INPUT_INPUT_HANDLER_MOJOM_SHARED_H_