// third_party/blink/public/mojom/fetch/fetch_api_request.mojom-blink.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_FETCH_FETCH_API_REQUEST_MOJOM_BLINK_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_FETCH_FETCH_API_REQUEST_MOJOM_BLINK_H_

#include <stdint.h>

#include <limits>
#include <type_traits>
#include <utility>

#include "base/callback.h"
#include "base/macros.h"
#include "base/optional.h"

#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#if BUILDFLAG(MOJO_TRACE_ENABLED)
#include "base/trace_event/trace_event.h"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"
#include "third_party/blink/public/mojom/fetch/fetch_api_request.mojom-shared.h"
#include "third_party/blink/public/mojom/fetch/fetch_api_request.mojom-blink-forward.h"
#include "mojo/public/mojom/base/file_path.mojom-blink.h"
#include "mojo/public/mojom/base/time.mojom-blink.h"
#include "mojo/public/mojom/base/unguessable_token.mojom-blink.h"
#include "services/network/public/mojom/chunked_data_pipe_getter.mojom-blink.h"
#include "services/network/public/mojom/data_pipe_getter.mojom-blink.h"
#include "services/network/public/mojom/fetch_api.mojom-blink-forward.h"
#include "services/network/public/mojom/url_loader.mojom-blink.h"
#include "third_party/blink/public/mojom/blob/serialized_blob.mojom-blink.h"
#include "third_party/blink/public/mojom/loader/request_context_frame_type.mojom-blink-forward.h"
#include "third_party/blink/public/mojom/loader/referrer.mojom-blink.h"
#include "url/mojom/url.mojom-blink.h"

#include "mojo/public/cpp/bindings/lib/wtf_clone_equals_util.h"
#include "mojo/public/cpp/bindings/lib/wtf_hash_util.h"
#include "third_party/blink/renderer/platform/wtf/hash_functions.h"
#include "third_party/blink/renderer/platform/wtf/text/wtf_string.h"

#include "mojo/public/cpp/bindings/associated_interface_ptr.h"
#include "mojo/public/cpp/bindings/associated_interface_ptr_info.h"
#include "mojo/public/cpp/bindings/associated_interface_request.h"
#include "mojo/public/cpp/bindings/interface_ptr.h"
#include "mojo/public/cpp/bindings/interface_request.h"
#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"
#include "mojo/public/cpp/bindings/thread_safe_interface_ptr.h"


#include "third_party/blink/renderer/platform/loader/fetch/resource_request.h"
#include "third_party/blink/renderer/platform/mojo/fetch_api_request_headers_mojom_traits.h"
#include "third_party/blink/renderer/platform/platform_export.h"




namespace WTF {
struct blink_mojom_internal_RequestContextType_DataHashFn {
  static unsigned GetHash(const ::blink::mojom::RequestContextType& value) {
    using utype = std::underlying_type<::blink::mojom::RequestContextType>::type;
    return DefaultHash<utype>::Hash().GetHash(static_cast<utype>(value));
  }
  static bool Equal(const ::blink::mojom::RequestContextType& left, const ::blink::mojom::RequestContextType& right) {
    return left == right;
  }
  static const bool safe_to_compare_to_empty_or_deleted = true;
};

template <>
struct HashTraits<::blink::mojom::RequestContextType>
    : public GenericHashTraits<::blink::mojom::RequestContextType> {
  static_assert(true,
                "-1000000 is a reserved enum value");
  static_assert(true,
                "-1000001 is a reserved enum value");
  static const bool hasIsEmptyValueFunction = true;
  static bool IsEmptyValue(const ::blink::mojom::RequestContextType& value) {
    return value == static_cast<::blink::mojom::RequestContextType>(-1000000);
  }
  static void ConstructDeletedValue(::blink::mojom::RequestContextType& slot, bool) {
    slot = static_cast<::blink::mojom::RequestContextType>(-1000001);
  }
  static bool IsDeletedValue(const ::blink::mojom::RequestContextType& value) {
    return value == static_cast<::blink::mojom::RequestContextType>(-1000001);
  }
};
}  // namespace WTF


namespace WTF {
struct blink_mojom_internal_FetchCacheMode_DataHashFn {
  static unsigned GetHash(const ::blink::mojom::FetchCacheMode& value) {
    using utype = std::underlying_type<::blink::mojom::FetchCacheMode>::type;
    return DefaultHash<utype>::Hash().GetHash(static_cast<utype>(value));
  }
  static bool Equal(const ::blink::mojom::FetchCacheMode& left, const ::blink::mojom::FetchCacheMode& right) {
    return left == right;
  }
  static const bool safe_to_compare_to_empty_or_deleted = true;
};

template <>
struct HashTraits<::blink::mojom::FetchCacheMode>
    : public GenericHashTraits<::blink::mojom::FetchCacheMode> {
  static_assert(true,
                "-1000000 is a reserved enum value");
  static_assert(true,
                "-1000001 is a reserved enum value");
  static const bool hasIsEmptyValueFunction = true;
  static bool IsEmptyValue(const ::blink::mojom::FetchCacheMode& value) {
    return value == static_cast<::blink::mojom::FetchCacheMode>(-1000000);
  }
  static void ConstructDeletedValue(::blink::mojom::FetchCacheMode& slot, bool) {
    slot = static_cast<::blink::mojom::FetchCacheMode>(-1000001);
  }
  static bool IsDeletedValue(const ::blink::mojom::FetchCacheMode& value) {
    return value == static_cast<::blink::mojom::FetchCacheMode>(-1000001);
  }
};
}  // namespace WTF


namespace WTF {
struct blink_mojom_internal_FetchImportanceMode_DataHashFn {
  static unsigned GetHash(const ::blink::mojom::FetchImportanceMode& value) {
    using utype = std::underlying_type<::blink::mojom::FetchImportanceMode>::type;
    return DefaultHash<utype>::Hash().GetHash(static_cast<utype>(value));
  }
  static bool Equal(const ::blink::mojom::FetchImportanceMode& left, const ::blink::mojom::FetchImportanceMode& right) {
    return left == right;
  }
  static const bool safe_to_compare_to_empty_or_deleted = true;
};

template <>
struct HashTraits<::blink::mojom::FetchImportanceMode>
    : public GenericHashTraits<::blink::mojom::FetchImportanceMode> {
  static_assert(true,
                "-1000000 is a reserved enum value");
  static_assert(true,
                "-1000001 is a reserved enum value");
  static const bool hasIsEmptyValueFunction = true;
  static bool IsEmptyValue(const ::blink::mojom::FetchImportanceMode& value) {
    return value == static_cast<::blink::mojom::FetchImportanceMode>(-1000000);
  }
  static void ConstructDeletedValue(::blink::mojom::FetchImportanceMode& slot, bool) {
    slot = static_cast<::blink::mojom::FetchImportanceMode>(-1000001);
  }
  static bool IsDeletedValue(const ::blink::mojom::FetchImportanceMode& value) {
    return value == static_cast<::blink::mojom::FetchImportanceMode>(-1000001);
  }
};
}  // namespace WTF

// Forward-declare for |AsValueInto| so that we do not have to import the
// corresponding header.
namespace base {
namespace trace_event {
class TracedValue;
}  // namespace trace_event
}  // namespace base


namespace blink {
namespace mojom {
namespace blink {











class PLATFORM_EXPORT FetchAPIRequestHeaders {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<FetchAPIRequestHeaders, T>::value>;
  using DataView = FetchAPIRequestHeadersDataView;
  using Data_ = internal::FetchAPIRequestHeaders_Data;

  template <typename... Args>
  static FetchAPIRequestHeadersPtr New(Args&&... args) {
    return FetchAPIRequestHeadersPtr(
        base::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static FetchAPIRequestHeadersPtr From(const U& u) {
    return mojo::TypeConverter<FetchAPIRequestHeadersPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, FetchAPIRequestHeaders>::Convert(*this);
  }


  FetchAPIRequestHeaders();

  explicit FetchAPIRequestHeaders(
      const WTF::HashMap<WTF::String, WTF::String>& headers);

  ~FetchAPIRequestHeaders();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = FetchAPIRequestHeadersPtr>
  FetchAPIRequestHeadersPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, FetchAPIRequestHeaders::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename UserType>
  static WTF::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        FetchAPIRequestHeaders::DataView, WTF::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        FetchAPIRequestHeaders::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::FetchAPIRequestHeaders_UnserializedMessageContext<
            UserType, FetchAPIRequestHeaders::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    return mojo::internal::DeserializeImpl<FetchAPIRequestHeaders::DataView>(
        data, data_num_bytes, std::vector<mojo::ScopedHandle>(), output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(const WTF::Vector<uint8_t>& input,
                          UserType* output) {
    return FetchAPIRequestHeaders::Deserialize(
        input.size() == 0 ? nullptr : &input.front(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::FetchAPIRequestHeaders_UnserializedMessageContext<
            UserType, FetchAPIRequestHeaders::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<FetchAPIRequestHeaders::DataView>(
        input.payload(), input.payload_num_bytes(),
        std::move(*input.mutable_handles()), output, Validate);
  }

  
  WTF::HashMap<WTF::String, WTF::String> headers;

  // Write this structure into |value|. The members are represented as a
  // dictionary |member name|: |member value|. This method does not deal with
  // the dictionary name. The caller is responsible for not calling
  // |AsValueInto| when |value| expects array items (see Array/Dictionary
  // methods of |base::trace_event::TracedValue|).
  //
  // |value| The TracedValue to be written into.
  //
  // Example uses:
  //
  //   // |my_var1, my_var2| are variables with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   value->BeginDictionary("my_var1");
  //   my_var1.AsValueInto(value.get());
  //   value->EndDictionary();
  //   value->BeginDictionary("my_var2");
  //   my_var2.AsValueInto(value.get());
  //   value->EndDictionary();
  //
  //   // |my_var| is a variable with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   my_var.AsValueInto(value.get());
  //   TRACE_EVENT1("test", "test", "my_var", std::move(value));
  //
  // Calling |AsValueInto| on two objects without opening and closing a
  // dictionary for each object is theoretically possible, but strongly
  // discouraged due to potential name collisions:
  //
  //   struct A {
  //     int foo;
  //   };
  //   struct B {
  //     int bar;
  //   };
  //   struct C {
  //     int foo;
  //     int bar;
  //   };
  //   auto value1 = std::make_unique<base::trace_event::TracedValue>();
  //   auto value2 = std::make_unique<base::trace_event::TracedValue>();
  //   A a;
  //   B b;
  //   C c;
  //   // value1 and value2 will be filled with the same information:
  //   a.AsValueInto(value1);
  //   b.AsValueInto(value1);
  //   c.AsValueInto(value2);
  void AsValueInto(base::trace_event::TracedValue* value) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, FetchAPIRequestHeaders::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, FetchAPIRequestHeaders::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, FetchAPIRequestHeaders::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, FetchAPIRequestHeaders::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class PLATFORM_EXPORT FetchAPIDataElement {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<FetchAPIDataElement, T>::value>;
  using DataView = FetchAPIDataElementDataView;
  using Data_ = internal::FetchAPIDataElement_Data;

  template <typename... Args>
  static FetchAPIDataElementPtr New(Args&&... args) {
    return FetchAPIDataElementPtr(
        base::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static FetchAPIDataElementPtr From(const U& u) {
    return mojo::TypeConverter<FetchAPIDataElementPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, FetchAPIDataElement>::Convert(*this);
  }


  FetchAPIDataElement();

  FetchAPIDataElement(
      ::network::mojom::blink::DataElementType type,
      WTF::Vector<uint8_t> buf,
      const ::base::FilePath& path,
      const WTF::String& blob_uuid,
      ::mojo::PendingRemote<::network::mojom::blink::DataPipeGetter> data_pipe_getter,
      ::mojo::PendingRemote<::network::mojom::blink::ChunkedDataPipeGetter> chunked_data_pipe_getter,
      uint64_t offset,
      uint64_t length,
      ::base::Time expected_modification_time);

  ~FetchAPIDataElement();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = FetchAPIDataElementPtr>
  FetchAPIDataElementPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, FetchAPIDataElement::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename UserType>
  static WTF::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        FetchAPIDataElement::DataView, WTF::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        FetchAPIDataElement::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::FetchAPIDataElement_UnserializedMessageContext<
            UserType, FetchAPIDataElement::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    return mojo::internal::DeserializeImpl<FetchAPIDataElement::DataView>(
        data, data_num_bytes, std::vector<mojo::ScopedHandle>(), output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(const WTF::Vector<uint8_t>& input,
                          UserType* output) {
    return FetchAPIDataElement::Deserialize(
        input.size() == 0 ? nullptr : &input.front(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::FetchAPIDataElement_UnserializedMessageContext<
            UserType, FetchAPIDataElement::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<FetchAPIDataElement::DataView>(
        input.payload(), input.payload_num_bytes(),
        std::move(*input.mutable_handles()), output, Validate);
  }

  
  ::network::mojom::blink::DataElementType type;
  
  WTF::Vector<uint8_t> buf;
  
  ::base::FilePath path;
  
  WTF::String blob_uuid;
  
  ::mojo::PendingRemote<::network::mojom::blink::DataPipeGetter> data_pipe_getter;
  
  ::mojo::PendingRemote<::network::mojom::blink::ChunkedDataPipeGetter> chunked_data_pipe_getter;
  
  uint64_t offset;
  
  uint64_t length;
  
  ::base::Time expected_modification_time;

  // Write this structure into |value|. The members are represented as a
  // dictionary |member name|: |member value|. This method does not deal with
  // the dictionary name. The caller is responsible for not calling
  // |AsValueInto| when |value| expects array items (see Array/Dictionary
  // methods of |base::trace_event::TracedValue|).
  //
  // |value| The TracedValue to be written into.
  //
  // Example uses:
  //
  //   // |my_var1, my_var2| are variables with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   value->BeginDictionary("my_var1");
  //   my_var1.AsValueInto(value.get());
  //   value->EndDictionary();
  //   value->BeginDictionary("my_var2");
  //   my_var2.AsValueInto(value.get());
  //   value->EndDictionary();
  //
  //   // |my_var| is a variable with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   my_var.AsValueInto(value.get());
  //   TRACE_EVENT1("test", "test", "my_var", std::move(value));
  //
  // Calling |AsValueInto| on two objects without opening and closing a
  // dictionary for each object is theoretically possible, but strongly
  // discouraged due to potential name collisions:
  //
  //   struct A {
  //     int foo;
  //   };
  //   struct B {
  //     int bar;
  //   };
  //   struct C {
  //     int foo;
  //     int bar;
  //   };
  //   auto value1 = std::make_unique<base::trace_event::TracedValue>();
  //   auto value2 = std::make_unique<base::trace_event::TracedValue>();
  //   A a;
  //   B b;
  //   C c;
  //   // value1 and value2 will be filled with the same information:
  //   a.AsValueInto(value1);
  //   b.AsValueInto(value1);
  //   c.AsValueInto(value2);
  void AsValueInto(base::trace_event::TracedValue* value) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
  DISALLOW_COPY_AND_ASSIGN(FetchAPIDataElement);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, FetchAPIDataElement::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, FetchAPIDataElement::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, FetchAPIDataElement::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, FetchAPIDataElement::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class PLATFORM_EXPORT FetchAPIRequestBody {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<FetchAPIRequestBody, T>::value>;
  using DataView = FetchAPIRequestBodyDataView;
  using Data_ = internal::FetchAPIRequestBody_Data;

  template <typename... Args>
  static FetchAPIRequestBodyPtr New(Args&&... args) {
    return FetchAPIRequestBodyPtr(
        base::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static FetchAPIRequestBodyPtr From(const U& u) {
    return mojo::TypeConverter<FetchAPIRequestBodyPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, FetchAPIRequestBody>::Convert(*this);
  }


  FetchAPIRequestBody();

  FetchAPIRequestBody(
      WTF::Vector<FetchAPIDataElementPtr> elements,
      uint64_t identifier,
      bool contains_sensitive_info);

  ~FetchAPIRequestBody();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = FetchAPIRequestBodyPtr>
  FetchAPIRequestBodyPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, FetchAPIRequestBody::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename UserType>
  static WTF::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        FetchAPIRequestBody::DataView, WTF::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        FetchAPIRequestBody::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::FetchAPIRequestBody_UnserializedMessageContext<
            UserType, FetchAPIRequestBody::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    return mojo::internal::DeserializeImpl<FetchAPIRequestBody::DataView>(
        data, data_num_bytes, std::vector<mojo::ScopedHandle>(), output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(const WTF::Vector<uint8_t>& input,
                          UserType* output) {
    return FetchAPIRequestBody::Deserialize(
        input.size() == 0 ? nullptr : &input.front(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::FetchAPIRequestBody_UnserializedMessageContext<
            UserType, FetchAPIRequestBody::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<FetchAPIRequestBody::DataView>(
        input.payload(), input.payload_num_bytes(),
        std::move(*input.mutable_handles()), output, Validate);
  }

  
  WTF::Vector<FetchAPIDataElementPtr> elements;
  
  uint64_t identifier;
  
  bool contains_sensitive_info;

  // Write this structure into |value|. The members are represented as a
  // dictionary |member name|: |member value|. This method does not deal with
  // the dictionary name. The caller is responsible for not calling
  // |AsValueInto| when |value| expects array items (see Array/Dictionary
  // methods of |base::trace_event::TracedValue|).
  //
  // |value| The TracedValue to be written into.
  //
  // Example uses:
  //
  //   // |my_var1, my_var2| are variables with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   value->BeginDictionary("my_var1");
  //   my_var1.AsValueInto(value.get());
  //   value->EndDictionary();
  //   value->BeginDictionary("my_var2");
  //   my_var2.AsValueInto(value.get());
  //   value->EndDictionary();
  //
  //   // |my_var| is a variable with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   my_var.AsValueInto(value.get());
  //   TRACE_EVENT1("test", "test", "my_var", std::move(value));
  //
  // Calling |AsValueInto| on two objects without opening and closing a
  // dictionary for each object is theoretically possible, but strongly
  // discouraged due to potential name collisions:
  //
  //   struct A {
  //     int foo;
  //   };
  //   struct B {
  //     int bar;
  //   };
  //   struct C {
  //     int foo;
  //     int bar;
  //   };
  //   auto value1 = std::make_unique<base::trace_event::TracedValue>();
  //   auto value2 = std::make_unique<base::trace_event::TracedValue>();
  //   A a;
  //   B b;
  //   C c;
  //   // value1 and value2 will be filled with the same information:
  //   a.AsValueInto(value1);
  //   b.AsValueInto(value1);
  //   c.AsValueInto(value2);
  void AsValueInto(base::trace_event::TracedValue* value) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
  DISALLOW_COPY_AND_ASSIGN(FetchAPIRequestBody);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, FetchAPIRequestBody::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, FetchAPIRequestBody::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, FetchAPIRequestBody::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, FetchAPIRequestBody::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class PLATFORM_EXPORT FetchAPIRequest {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<FetchAPIRequest, T>::value>;
  using DataView = FetchAPIRequestDataView;
  using Data_ = internal::FetchAPIRequest_Data;

  template <typename... Args>
  static FetchAPIRequestPtr New(Args&&... args) {
    return FetchAPIRequestPtr(
        base::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static FetchAPIRequestPtr From(const U& u) {
    return mojo::TypeConverter<FetchAPIRequestPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, FetchAPIRequest>::Convert(*this);
  }


  FetchAPIRequest();

  FetchAPIRequest(
      ::network::mojom::blink::RequestMode mode,
      bool is_main_resource_load,
      ::network::mojom::blink::RequestDestination destination,
      ::blink::mojom::blink::RequestContextFrameType frame_type,
      const ::blink::KURL& url,
      const WTF::String& method,
      ::WTF::HashMap<::WTF::String, WTF::String, WTF::CaseFoldingHash> headers,
      const ::scoped_refptr<::blink::BlobDataHandle>& blob,
      ::blink::ResourceRequestBody body,
      ::blink::mojom::blink::ReferrerPtr referrer,
      ::network::mojom::blink::CredentialsMode credentials_mode,
      FetchCacheMode cache_mode,
      ::network::mojom::blink::RedirectMode redirect_mode,
      const WTF::String& integrity,
      ::net::RequestPriority priority,
      const base::Optional<::base::UnguessableToken>& fetch_window_id,
      bool keepalive,
      bool is_reload,
      bool is_history_navigation);

  ~FetchAPIRequest();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = FetchAPIRequestPtr>
  FetchAPIRequestPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, FetchAPIRequest::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename UserType>
  static WTF::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        FetchAPIRequest::DataView, WTF::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        FetchAPIRequest::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::FetchAPIRequest_UnserializedMessageContext<
            UserType, FetchAPIRequest::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    return mojo::internal::DeserializeImpl<FetchAPIRequest::DataView>(
        data, data_num_bytes, std::vector<mojo::ScopedHandle>(), output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(const WTF::Vector<uint8_t>& input,
                          UserType* output) {
    return FetchAPIRequest::Deserialize(
        input.size() == 0 ? nullptr : &input.front(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::FetchAPIRequest_UnserializedMessageContext<
            UserType, FetchAPIRequest::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<FetchAPIRequest::DataView>(
        input.payload(), input.payload_num_bytes(),
        std::move(*input.mutable_handles()), output, Validate);
  }

  
  ::network::mojom::blink::RequestMode mode;
  
  bool is_main_resource_load;
  
  ::network::mojom::blink::RequestDestination destination;
  
  ::blink::mojom::blink::RequestContextFrameType frame_type;
  
  ::blink::KURL url;
  
  WTF::String method;
  
  ::WTF::HashMap<::WTF::String, WTF::String, WTF::CaseFoldingHash> headers;
  
  ::scoped_refptr<::blink::BlobDataHandle> blob;
  
  ::blink::ResourceRequestBody body;
  
  ::blink::mojom::blink::ReferrerPtr referrer;
  
  ::network::mojom::blink::CredentialsMode credentials_mode;
  
  FetchCacheMode cache_mode;
  
  ::network::mojom::blink::RedirectMode redirect_mode;
  
  WTF::String integrity;
  
  ::net::RequestPriority priority;
  
  base::Optional<::base::UnguessableToken> fetch_window_id;
  
  bool keepalive;
  
  bool is_reload;
  
  bool is_history_navigation;

  // Write this structure into |value|. The members are represented as a
  // dictionary |member name|: |member value|. This method does not deal with
  // the dictionary name. The caller is responsible for not calling
  // |AsValueInto| when |value| expects array items (see Array/Dictionary
  // methods of |base::trace_event::TracedValue|).
  //
  // |value| The TracedValue to be written into.
  //
  // Example uses:
  //
  //   // |my_var1, my_var2| are variables with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   value->BeginDictionary("my_var1");
  //   my_var1.AsValueInto(value.get());
  //   value->EndDictionary();
  //   value->BeginDictionary("my_var2");
  //   my_var2.AsValueInto(value.get());
  //   value->EndDictionary();
  //
  //   // |my_var| is a variable with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   my_var.AsValueInto(value.get());
  //   TRACE_EVENT1("test", "test", "my_var", std::move(value));
  //
  // Calling |AsValueInto| on two objects without opening and closing a
  // dictionary for each object is theoretically possible, but strongly
  // discouraged due to potential name collisions:
  //
  //   struct A {
  //     int foo;
  //   };
  //   struct B {
  //     int bar;
  //   };
  //   struct C {
  //     int foo;
  //     int bar;
  //   };
  //   auto value1 = std::make_unique<base::trace_event::TracedValue>();
  //   auto value2 = std::make_unique<base::trace_event::TracedValue>();
  //   A a;
  //   B b;
  //   C c;
  //   // value1 and value2 will be filled with the same information:
  //   a.AsValueInto(value1);
  //   b.AsValueInto(value1);
  //   c.AsValueInto(value2);
  void AsValueInto(base::trace_event::TracedValue* value) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
  DISALLOW_COPY_AND_ASSIGN(FetchAPIRequest);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, FetchAPIRequest::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, FetchAPIRequest::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, FetchAPIRequest::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, FetchAPIRequest::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename StructPtrType>
FetchAPIRequestHeadersPtr FetchAPIRequestHeaders::Clone() const {
  return New(
      mojo::Clone(headers)
  );
}

template <typename T, FetchAPIRequestHeaders::EnableIfSame<T>*>
bool FetchAPIRequestHeaders::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->headers, other_struct.headers))
    return false;
  return true;
}

template <typename T, FetchAPIRequestHeaders::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (std::less<>{}(lhs.headers, rhs.headers))
    return true;
  if (std::less<>{}(rhs.headers, lhs.headers))
    return false;
  return false;
}
template <typename StructPtrType>
FetchAPIDataElementPtr FetchAPIDataElement::Clone() const {
  return New(
      mojo::Clone(type),
      mojo::Clone(buf),
      mojo::Clone(path),
      mojo::Clone(blob_uuid),
      mojo::Clone(data_pipe_getter),
      mojo::Clone(chunked_data_pipe_getter),
      mojo::Clone(offset),
      mojo::Clone(length),
      mojo::Clone(expected_modification_time)
  );
}

template <typename T, FetchAPIDataElement::EnableIfSame<T>*>
bool FetchAPIDataElement::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->type, other_struct.type))
    return false;
  if (!mojo::Equals(this->buf, other_struct.buf))
    return false;
  if (!mojo::Equals(this->path, other_struct.path))
    return false;
  if (!mojo::Equals(this->blob_uuid, other_struct.blob_uuid))
    return false;
  if (!mojo::Equals(this->data_pipe_getter, other_struct.data_pipe_getter))
    return false;
  if (!mojo::Equals(this->chunked_data_pipe_getter, other_struct.chunked_data_pipe_getter))
    return false;
  if (!mojo::Equals(this->offset, other_struct.offset))
    return false;
  if (!mojo::Equals(this->length, other_struct.length))
    return false;
  if (!mojo::Equals(this->expected_modification_time, other_struct.expected_modification_time))
    return false;
  return true;
}

template <typename T, FetchAPIDataElement::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (std::less<>{}(lhs.type, rhs.type))
    return true;
  if (std::less<>{}(rhs.type, lhs.type))
    return false;
  if (std::less<>{}(lhs.buf, rhs.buf))
    return true;
  if (std::less<>{}(rhs.buf, lhs.buf))
    return false;
  if (std::less<>{}(lhs.path, rhs.path))
    return true;
  if (std::less<>{}(rhs.path, lhs.path))
    return false;
  if (std::less<>{}(lhs.blob_uuid, rhs.blob_uuid))
    return true;
  if (std::less<>{}(rhs.blob_uuid, lhs.blob_uuid))
    return false;
  if (std::less<>{}(lhs.data_pipe_getter, rhs.data_pipe_getter))
    return true;
  if (std::less<>{}(rhs.data_pipe_getter, lhs.data_pipe_getter))
    return false;
  if (std::less<>{}(lhs.chunked_data_pipe_getter, rhs.chunked_data_pipe_getter))
    return true;
  if (std::less<>{}(rhs.chunked_data_pipe_getter, lhs.chunked_data_pipe_getter))
    return false;
  if (std::less<>{}(lhs.offset, rhs.offset))
    return true;
  if (std::less<>{}(rhs.offset, lhs.offset))
    return false;
  if (std::less<>{}(lhs.length, rhs.length))
    return true;
  if (std::less<>{}(rhs.length, lhs.length))
    return false;
  if (std::less<>{}(lhs.expected_modification_time, rhs.expected_modification_time))
    return true;
  if (std::less<>{}(rhs.expected_modification_time, lhs.expected_modification_time))
    return false;
  return false;
}
template <typename StructPtrType>
FetchAPIRequestBodyPtr FetchAPIRequestBody::Clone() const {
  return New(
      mojo::Clone(elements),
      mojo::Clone(identifier),
      mojo::Clone(contains_sensitive_info)
  );
}

template <typename T, FetchAPIRequestBody::EnableIfSame<T>*>
bool FetchAPIRequestBody::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->elements, other_struct.elements))
    return false;
  if (!mojo::Equals(this->identifier, other_struct.identifier))
    return false;
  if (!mojo::Equals(this->contains_sensitive_info, other_struct.contains_sensitive_info))
    return false;
  return true;
}

template <typename T, FetchAPIRequestBody::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (std::less<>{}(lhs.elements, rhs.elements))
    return true;
  if (std::less<>{}(rhs.elements, lhs.elements))
    return false;
  if (std::less<>{}(lhs.identifier, rhs.identifier))
    return true;
  if (std::less<>{}(rhs.identifier, lhs.identifier))
    return false;
  if (std::less<>{}(lhs.contains_sensitive_info, rhs.contains_sensitive_info))
    return true;
  if (std::less<>{}(rhs.contains_sensitive_info, lhs.contains_sensitive_info))
    return false;
  return false;
}
template <typename StructPtrType>
FetchAPIRequestPtr FetchAPIRequest::Clone() const {
  return New(
      mojo::Clone(mode),
      mojo::Clone(is_main_resource_load),
      mojo::Clone(destination),
      mojo::Clone(frame_type),
      mojo::Clone(url),
      mojo::Clone(method),
      mojo::Clone(headers),
      mojo::Clone(blob),
      mojo::Clone(body),
      mojo::Clone(referrer),
      mojo::Clone(credentials_mode),
      mojo::Clone(cache_mode),
      mojo::Clone(redirect_mode),
      mojo::Clone(integrity),
      mojo::Clone(priority),
      mojo::Clone(fetch_window_id),
      mojo::Clone(keepalive),
      mojo::Clone(is_reload),
      mojo::Clone(is_history_navigation)
  );
}

template <typename T, FetchAPIRequest::EnableIfSame<T>*>
bool FetchAPIRequest::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->mode, other_struct.mode))
    return false;
  if (!mojo::Equals(this->is_main_resource_load, other_struct.is_main_resource_load))
    return false;
  if (!mojo::Equals(this->destination, other_struct.destination))
    return false;
  if (!mojo::Equals(this->frame_type, other_struct.frame_type))
    return false;
  if (!mojo::Equals(this->url, other_struct.url))
    return false;
  if (!mojo::Equals(this->method, other_struct.method))
    return false;
  if (!mojo::Equals(this->headers, other_struct.headers))
    return false;
  if (!mojo::Equals(this->blob, other_struct.blob))
    return false;
  if (!mojo::Equals(this->body, other_struct.body))
    return false;
  if (!mojo::Equals(this->referrer, other_struct.referrer))
    return false;
  if (!mojo::Equals(this->credentials_mode, other_struct.credentials_mode))
    return false;
  if (!mojo::Equals(this->cache_mode, other_struct.cache_mode))
    return false;
  if (!mojo::Equals(this->redirect_mode, other_struct.redirect_mode))
    return false;
  if (!mojo::Equals(this->integrity, other_struct.integrity))
    return false;
  if (!mojo::Equals(this->priority, other_struct.priority))
    return false;
  if (!mojo::Equals(this->fetch_window_id, other_struct.fetch_window_id))
    return false;
  if (!mojo::Equals(this->keepalive, other_struct.keepalive))
    return false;
  if (!mojo::Equals(this->is_reload, other_struct.is_reload))
    return false;
  if (!mojo::Equals(this->is_history_navigation, other_struct.is_history_navigation))
    return false;
  return true;
}

template <typename T, FetchAPIRequest::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (std::less<>{}(lhs.mode, rhs.mode))
    return true;
  if (std::less<>{}(rhs.mode, lhs.mode))
    return false;
  if (std::less<>{}(lhs.is_main_resource_load, rhs.is_main_resource_load))
    return true;
  if (std::less<>{}(rhs.is_main_resource_load, lhs.is_main_resource_load))
    return false;
  if (std::less<>{}(lhs.destination, rhs.destination))
    return true;
  if (std::less<>{}(rhs.destination, lhs.destination))
    return false;
  if (std::less<>{}(lhs.frame_type, rhs.frame_type))
    return true;
  if (std::less<>{}(rhs.frame_type, lhs.frame_type))
    return false;
  if (std::less<>{}(lhs.url, rhs.url))
    return true;
  if (std::less<>{}(rhs.url, lhs.url))
    return false;
  if (std::less<>{}(lhs.method, rhs.method))
    return true;
  if (std::less<>{}(rhs.method, lhs.method))
    return false;
  if (std::less<>{}(lhs.headers, rhs.headers))
    return true;
  if (std::less<>{}(rhs.headers, lhs.headers))
    return false;
  if (std::less<>{}(lhs.blob, rhs.blob))
    return true;
  if (std::less<>{}(rhs.blob, lhs.blob))
    return false;
  if (std::less<>{}(lhs.body, rhs.body))
    return true;
  if (std::less<>{}(rhs.body, lhs.body))
    return false;
  if (std::less<>{}(lhs.referrer, rhs.referrer))
    return true;
  if (std::less<>{}(rhs.referrer, lhs.referrer))
    return false;
  if (std::less<>{}(lhs.credentials_mode, rhs.credentials_mode))
    return true;
  if (std::less<>{}(rhs.credentials_mode, lhs.credentials_mode))
    return false;
  if (std::less<>{}(lhs.cache_mode, rhs.cache_mode))
    return true;
  if (std::less<>{}(rhs.cache_mode, lhs.cache_mode))
    return false;
  if (std::less<>{}(lhs.redirect_mode, rhs.redirect_mode))
    return true;
  if (std::less<>{}(rhs.redirect_mode, lhs.redirect_mode))
    return false;
  if (std::less<>{}(lhs.integrity, rhs.integrity))
    return true;
  if (std::less<>{}(rhs.integrity, lhs.integrity))
    return false;
  if (std::less<>{}(lhs.priority, rhs.priority))
    return true;
  if (std::less<>{}(rhs.priority, lhs.priority))
    return false;
  if (std::less<>{}(lhs.fetch_window_id, rhs.fetch_window_id))
    return true;
  if (std::less<>{}(rhs.fetch_window_id, lhs.fetch_window_id))
    return false;
  if (std::less<>{}(lhs.keepalive, rhs.keepalive))
    return true;
  if (std::less<>{}(rhs.keepalive, lhs.keepalive))
    return false;
  if (std::less<>{}(lhs.is_reload, rhs.is_reload))
    return true;
  if (std::less<>{}(rhs.is_reload, lhs.is_reload))
    return false;
  if (std::less<>{}(lhs.is_history_navigation, rhs.is_history_navigation))
    return true;
  if (std::less<>{}(rhs.is_history_navigation, lhs.is_history_navigation))
    return false;
  return false;
}


}  // namespace blink
}  // namespace mojom
}  // namespace blink

namespace mojo {


template <>
struct PLATFORM_EXPORT StructTraits<::blink::mojom::blink::FetchAPIRequestHeaders::DataView,
                                         ::blink::mojom::blink::FetchAPIRequestHeadersPtr> {
  static bool IsNull(const ::blink::mojom::blink::FetchAPIRequestHeadersPtr& input) { return !input; }
  static void SetToNull(::blink::mojom::blink::FetchAPIRequestHeadersPtr* output) { output->reset(); }

  static const decltype(::blink::mojom::blink::FetchAPIRequestHeaders::headers)& headers(
      const ::blink::mojom::blink::FetchAPIRequestHeadersPtr& input) {
    return input->headers;
  }

  static bool Read(::blink::mojom::blink::FetchAPIRequestHeaders::DataView input, ::blink::mojom::blink::FetchAPIRequestHeadersPtr* output);
};


template <>
struct PLATFORM_EXPORT StructTraits<::blink::mojom::blink::FetchAPIDataElement::DataView,
                                         ::blink::mojom::blink::FetchAPIDataElementPtr> {
  static bool IsNull(const ::blink::mojom::blink::FetchAPIDataElementPtr& input) { return !input; }
  static void SetToNull(::blink::mojom::blink::FetchAPIDataElementPtr* output) { output->reset(); }

  static decltype(::blink::mojom::blink::FetchAPIDataElement::type) type(
      const ::blink::mojom::blink::FetchAPIDataElementPtr& input) {
    return input->type;
  }

  static const decltype(::blink::mojom::blink::FetchAPIDataElement::buf)& buf(
      const ::blink::mojom::blink::FetchAPIDataElementPtr& input) {
    return input->buf;
  }

  static const decltype(::blink::mojom::blink::FetchAPIDataElement::path)& path(
      const ::blink::mojom::blink::FetchAPIDataElementPtr& input) {
    return input->path;
  }

  static const decltype(::blink::mojom::blink::FetchAPIDataElement::blob_uuid)& blob_uuid(
      const ::blink::mojom::blink::FetchAPIDataElementPtr& input) {
    return input->blob_uuid;
  }

  static  decltype(::blink::mojom::blink::FetchAPIDataElement::data_pipe_getter)& data_pipe_getter(
       ::blink::mojom::blink::FetchAPIDataElementPtr& input) {
    return input->data_pipe_getter;
  }

  static  decltype(::blink::mojom::blink::FetchAPIDataElement::chunked_data_pipe_getter)& chunked_data_pipe_getter(
       ::blink::mojom::blink::FetchAPIDataElementPtr& input) {
    return input->chunked_data_pipe_getter;
  }

  static decltype(::blink::mojom::blink::FetchAPIDataElement::offset) offset(
      const ::blink::mojom::blink::FetchAPIDataElementPtr& input) {
    return input->offset;
  }

  static decltype(::blink::mojom::blink::FetchAPIDataElement::length) length(
      const ::blink::mojom::blink::FetchAPIDataElementPtr& input) {
    return input->length;
  }

  static const decltype(::blink::mojom::blink::FetchAPIDataElement::expected_modification_time)& expected_modification_time(
      const ::blink::mojom::blink::FetchAPIDataElementPtr& input) {
    return input->expected_modification_time;
  }

  static bool Read(::blink::mojom::blink::FetchAPIDataElement::DataView input, ::blink::mojom::blink::FetchAPIDataElementPtr* output);
};


template <>
struct PLATFORM_EXPORT StructTraits<::blink::mojom::blink::FetchAPIRequestBody::DataView,
                                         ::blink::mojom::blink::FetchAPIRequestBodyPtr> {
  static bool IsNull(const ::blink::mojom::blink::FetchAPIRequestBodyPtr& input) { return !input; }
  static void SetToNull(::blink::mojom::blink::FetchAPIRequestBodyPtr* output) { output->reset(); }

  static  decltype(::blink::mojom::blink::FetchAPIRequestBody::elements)& elements(
       ::blink::mojom::blink::FetchAPIRequestBodyPtr& input) {
    return input->elements;
  }

  static decltype(::blink::mojom::blink::FetchAPIRequestBody::identifier) identifier(
      const ::blink::mojom::blink::FetchAPIRequestBodyPtr& input) {
    return input->identifier;
  }

  static decltype(::blink::mojom::blink::FetchAPIRequestBody::contains_sensitive_info) contains_sensitive_info(
      const ::blink::mojom::blink::FetchAPIRequestBodyPtr& input) {
    return input->contains_sensitive_info;
  }

  static bool Read(::blink::mojom::blink::FetchAPIRequestBody::DataView input, ::blink::mojom::blink::FetchAPIRequestBodyPtr* output);
};


template <>
struct PLATFORM_EXPORT StructTraits<::blink::mojom::blink::FetchAPIRequest::DataView,
                                         ::blink::mojom::blink::FetchAPIRequestPtr> {
  static bool IsNull(const ::blink::mojom::blink::FetchAPIRequestPtr& input) { return !input; }
  static void SetToNull(::blink::mojom::blink::FetchAPIRequestPtr* output) { output->reset(); }

  static decltype(::blink::mojom::blink::FetchAPIRequest::mode) mode(
      const ::blink::mojom::blink::FetchAPIRequestPtr& input) {
    return input->mode;
  }

  static decltype(::blink::mojom::blink::FetchAPIRequest::is_main_resource_load) is_main_resource_load(
      const ::blink::mojom::blink::FetchAPIRequestPtr& input) {
    return input->is_main_resource_load;
  }

  static decltype(::blink::mojom::blink::FetchAPIRequest::destination) destination(
      const ::blink::mojom::blink::FetchAPIRequestPtr& input) {
    return input->destination;
  }

  static decltype(::blink::mojom::blink::FetchAPIRequest::frame_type) frame_type(
      const ::blink::mojom::blink::FetchAPIRequestPtr& input) {
    return input->frame_type;
  }

  static const decltype(::blink::mojom::blink::FetchAPIRequest::url)& url(
      const ::blink::mojom::blink::FetchAPIRequestPtr& input) {
    return input->url;
  }

  static const decltype(::blink::mojom::blink::FetchAPIRequest::method)& method(
      const ::blink::mojom::blink::FetchAPIRequestPtr& input) {
    return input->method;
  }

  static const decltype(::blink::mojom::blink::FetchAPIRequest::headers)& headers(
      const ::blink::mojom::blink::FetchAPIRequestPtr& input) {
    return input->headers;
  }

  static  decltype(::blink::mojom::blink::FetchAPIRequest::blob)& blob(
       ::blink::mojom::blink::FetchAPIRequestPtr& input) {
    return input->blob;
  }

  static  decltype(::blink::mojom::blink::FetchAPIRequest::body)& body(
       ::blink::mojom::blink::FetchAPIRequestPtr& input) {
    return input->body;
  }

  static const decltype(::blink::mojom::blink::FetchAPIRequest::referrer)& referrer(
      const ::blink::mojom::blink::FetchAPIRequestPtr& input) {
    return input->referrer;
  }

  static decltype(::blink::mojom::blink::FetchAPIRequest::credentials_mode) credentials_mode(
      const ::blink::mojom::blink::FetchAPIRequestPtr& input) {
    return input->credentials_mode;
  }

  static decltype(::blink::mojom::blink::FetchAPIRequest::cache_mode) cache_mode(
      const ::blink::mojom::blink::FetchAPIRequestPtr& input) {
    return input->cache_mode;
  }

  static decltype(::blink::mojom::blink::FetchAPIRequest::redirect_mode) redirect_mode(
      const ::blink::mojom::blink::FetchAPIRequestPtr& input) {
    return input->redirect_mode;
  }

  static const decltype(::blink::mojom::blink::FetchAPIRequest::integrity)& integrity(
      const ::blink::mojom::blink::FetchAPIRequestPtr& input) {
    return input->integrity;
  }

  static decltype(::blink::mojom::blink::FetchAPIRequest::priority) priority(
      const ::blink::mojom::blink::FetchAPIRequestPtr& input) {
    return input->priority;
  }

  static const decltype(::blink::mojom::blink::FetchAPIRequest::fetch_window_id)& fetch_window_id(
      const ::blink::mojom::blink::FetchAPIRequestPtr& input) {
    return input->fetch_window_id;
  }

  static decltype(::blink::mojom::blink::FetchAPIRequest::keepalive) keepalive(
      const ::blink::mojom::blink::FetchAPIRequestPtr& input) {
    return input->keepalive;
  }

  static decltype(::blink::mojom::blink::FetchAPIRequest::is_reload) is_reload(
      const ::blink::mojom::blink::FetchAPIRequestPtr& input) {
    return input->is_reload;
  }

  static decltype(::blink::mojom::blink::FetchAPIRequest::is_history_navigation) is_history_navigation(
      const ::blink::mojom::blink::FetchAPIRequestPtr& input) {
    return input->is_history_navigation;
  }

  static bool Read(::blink::mojom::blink::FetchAPIRequest::DataView input, ::blink::mojom::blink::FetchAPIRequestPtr* output);
};

}  // namespace mojo

#endif  // THIRD_PARTY_BLINK_PUBLIC_MOJOM_FETCH_FETCH_API_REQUEST_MOJOM_BLINK_H_