// third_party/blink/public/mojom/favicon/favicon_url.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "third_party/blink/public/mojom/favicon/favicon_url.mojom-shared.h"

#include <utility>

#include "base/stl_util.h"  // for base::size()
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_context.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"

#include "third_party/blink/public/mojom/favicon/favicon_url.mojom-params-data.h"
namespace blink {
namespace mojom {

std::ostream& operator<<(std::ostream& os, FaviconIconType value) {
  switch(value) {
    case FaviconIconType::kInvalid:
      return os << "FaviconIconType::kInvalid";
    case FaviconIconType::kFavicon:
      return os << "FaviconIconType::kFavicon";
    case FaviconIconType::kTouchIcon:
      return os << "FaviconIconType::kTouchIcon";
    case FaviconIconType::kTouchPrecomposedIcon:
      return os << "FaviconIconType::kTouchPrecomposedIcon";
    default:
      return os << "Unknown FaviconIconType value: " << static_cast<int32_t>(value);
  }
}

namespace internal {


// static
bool FaviconURL_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;

  if (!ValidateStructHeaderAndClaimMemory(data, validation_context))
    return false;

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const FaviconURL_Data* object = static_cast<const FaviconURL_Data*>(data);

  static constexpr struct {
    uint32_t version;
    uint32_t num_bytes;
  } kVersionSizes[] = {{ 0, 32 }};

  if (object->header_.version <=
          kVersionSizes[base::size(kVersionSizes) - 1].version) {
    // Scan in reverse order to optimize for more recent versions.
    for (int i = base::size(kVersionSizes) - 1; i >= 0; --i) {
      if (object->header_.version >= kVersionSizes[i].version) {
        if (object->header_.num_bytes == kVersionSizes[i].num_bytes)
          break;

        ReportValidationError(
            validation_context,
            mojo::internal::VALIDATION_ERROR_UNEXPECTED_STRUCT_HEADER);
        return false;
      }
    }
  } else if (object->header_.num_bytes <
                 kVersionSizes[base::size(kVersionSizes) - 1].num_bytes) {
    ReportValidationError(
        validation_context,
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_STRUCT_HEADER);
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->icon_url, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->icon_url, validation_context))
    return false;


  if (!::blink::mojom::internal::FaviconIconType_Data
        ::Validate(object->icon_type, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->icon_sizes, 3, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams icon_sizes_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->icon_sizes, validation_context,
                                         &icon_sizes_validate_params)) {
    return false;
  }

  return true;
}

FaviconURL_Data::FaviconURL_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace blink