// services/data_decoder/public/mojom/resource_snapshot_for_web_bundle.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_DATA_DECODER_PUBLIC_MOJOM_RESOURCE_SNAPSHOT_FOR_WEB_BUNDLE_MOJOM_SHARED_H_
#define SERVICES_DATA_DECODER_PUBLIC_MOJOM_RESOURCE_SNAPSHOT_FOR_WEB_BUNDLE_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <ostream>
#include <type_traits>
#include <utility>

#include "base/compiler_specific.h"
#include "base/containers/flat_map.h"
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"
#include "services/data_decoder/public/mojom/resource_snapshot_for_web_bundle.mojom-shared-internal.h"
#include "mojo/public/mojom/base/big_buffer.mojom-shared.h"
#include "url/mojom/url.mojom-shared.h"
#include "mojo/public/cpp/bindings/lib/interface_serialization.h"






namespace data_decoder {
namespace mojom {
class SerializedResourceInfoDataView;



}  // namespace mojom
}  // namespace data_decoder

namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::data_decoder::mojom::SerializedResourceInfoDataView> {
  using Data = ::data_decoder::mojom::internal::SerializedResourceInfo_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace data_decoder {
namespace mojom {
// Interface base classes. They are used for type safety check.
class ResourceSnapshotForWebBundleInterfaceBase {};

using ResourceSnapshotForWebBundlePtrDataView =
    mojo::InterfacePtrDataView<ResourceSnapshotForWebBundleInterfaceBase>;
using ResourceSnapshotForWebBundleRequestDataView =
    mojo::InterfaceRequestDataView<ResourceSnapshotForWebBundleInterfaceBase>;
using ResourceSnapshotForWebBundleAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<ResourceSnapshotForWebBundleInterfaceBase>;
using ResourceSnapshotForWebBundleAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<ResourceSnapshotForWebBundleInterfaceBase>;


class SerializedResourceInfoDataView {
 public:
  SerializedResourceInfoDataView() {}

  SerializedResourceInfoDataView(
      internal::SerializedResourceInfo_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data), context_(context) {}

  bool is_null() const { return !data_; }
  inline void GetUrlDataView(
      ::url::mojom::UrlDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadUrl(UserType* output) {
    
    auto* pointer = data_->url.Get();
    return mojo::internal::Deserialize<::url::mojom::UrlDataView>(
        pointer, output, context_);
  }
  inline void GetMimeTypeDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadMimeType(UserType* output) {
    
    auto* pointer = data_->mime_type.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, context_);
  }
  uint64_t size() const {
    return data_->size;
  }
 private:
  internal::SerializedResourceInfo_Data* data_ = nullptr;
  mojo::internal::SerializationContext* context_ = nullptr;
};



}  // namespace mojom
}  // namespace data_decoder

namespace std {

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::data_decoder::mojom::SerializedResourceInfoDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::data_decoder::mojom::SerializedResourceInfoDataView, UserType>;

  static void Serialize(MaybeConstUserType& input,
                        Buffer* buffer,
                        ::data_decoder::mojom::internal::SerializedResourceInfo_Data::BufferWriter* output,
                        SerializationContext* context) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    (*output).Allocate(buffer);
    decltype(Traits::url(input)) in_url = Traits::url(input);
    typename decltype((*output)->url)::BaseType::BufferWriter
        url_writer;
    mojo::internal::Serialize<::url::mojom::UrlDataView>(
        in_url, buffer, &url_writer, context);
    (*output)->url.Set(
        url_writer.is_null() ? nullptr : url_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->url.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null url in SerializedResourceInfo struct");
    decltype(Traits::mime_type(input)) in_mime_type = Traits::mime_type(input);
    typename decltype((*output)->mime_type)::BaseType::BufferWriter
        mime_type_writer;
    mojo::internal::Serialize<mojo::StringDataView>(
        in_mime_type, buffer, &mime_type_writer, context);
    (*output)->mime_type.Set(
        mime_type_writer.is_null() ? nullptr : mime_type_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->mime_type.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null mime_type in SerializedResourceInfo struct");
    (*output)->size = Traits::size(input);
  }

  static bool Deserialize(::data_decoder::mojom::internal::SerializedResourceInfo_Data* input,
                          UserType* output,
                          SerializationContext* context) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::data_decoder::mojom::SerializedResourceInfoDataView data_view(input, context);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace data_decoder {
namespace mojom {

inline void SerializedResourceInfoDataView::GetUrlDataView(
    ::url::mojom::UrlDataView* output) {
  auto pointer = data_->url.Get();
  *output = ::url::mojom::UrlDataView(pointer, context_);
}
inline void SerializedResourceInfoDataView::GetMimeTypeDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->mime_type.Get();
  *output = mojo::StringDataView(pointer, context_);
}



}  // namespace mojom
}  // namespace data_decoder

#endif  // SERVICES_DATA_DECODER_PUBLIC_MOJOM_RESOURCE_SNAPSHOT_FOR_WEB_BUNDLE_MOJOM_SHARED_H_