// media/mojo/mojom/platform_verification.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "media/mojo/mojom/platform_verification.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/hash/md5_constexpr.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/common/task_annotator.h"
#include "base/trace_event/trace_conversion_helper.h"
#include "base/trace_event/traced_value.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_context.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"

#include "media/mojo/mojom/platform_verification.mojom-params-data.h"
#include "media/mojo/mojom/platform_verification.mojom-shared-message-ids.h"

#include "media/mojo/mojom/platform_verification.mojom-import-headers.h"


#ifndef MEDIA_MOJO_MOJOM_PLATFORM_VERIFICATION_MOJOM_JUMBO_H_
#define MEDIA_MOJO_MOJOM_PLATFORM_VERIFICATION_MOJOM_JUMBO_H_
#endif
namespace media {
namespace mojom {
const char PlatformVerification::Name_[] = "media.mojom.PlatformVerification";

class PlatformVerification_ChallengePlatform_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  PlatformVerification_ChallengePlatform_ForwardToCallback(
      PlatformVerification::ChallengePlatformCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  PlatformVerification::ChallengePlatformCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(PlatformVerification_ChallengePlatform_ForwardToCallback);
};

class PlatformVerification_GetStorageId_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  PlatformVerification_GetStorageId_ForwardToCallback(
      PlatformVerification::GetStorageIdCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  PlatformVerification::GetStorageIdCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(PlatformVerification_GetStorageId_ForwardToCallback);
};

PlatformVerificationProxy::PlatformVerificationProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void PlatformVerificationProxy::ChallengePlatform(
    const std::string& in_service_id, const std::string& in_challenge, ChallengePlatformCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "media::mojom::PlatformVerification::ChallengePlatform", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetString("service_id", in_service_id);
      raw_value->SetString("challenge", in_challenge);
      return value;
    }());
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kPlatformVerification_ChallengePlatform_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::media::mojom::internal::PlatformVerification_ChallengePlatform_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  typename decltype(params->service_id)::BaseType::BufferWriter
      service_id_writer;
  mojo::internal::Serialize<mojo::StringDataView>(
      in_service_id, buffer, &service_id_writer, &serialization_context);
  params->service_id.Set(
      service_id_writer.is_null() ? nullptr : service_id_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->service_id.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null service_id in PlatformVerification.ChallengePlatform request");
  typename decltype(params->challenge)::BaseType::BufferWriter
      challenge_writer;
  mojo::internal::Serialize<mojo::StringDataView>(
      in_challenge, buffer, &challenge_writer, &serialization_context);
  params->challenge.Set(
      challenge_writer.is_null() ? nullptr : challenge_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->challenge.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null challenge in PlatformVerification.ChallengePlatform request");
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PlatformVerification::Name_);
  message.set_method_name("ChallengePlatform");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new PlatformVerification_ChallengePlatform_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}

void PlatformVerificationProxy::GetStorageId(
    uint32_t in_version, GetStorageIdCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "media::mojom::PlatformVerification::GetStorageId", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetString("version", base::NumberToString(in_version));
      return value;
    }());
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kPlatformVerification_GetStorageId_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::media::mojom::internal::PlatformVerification_GetStorageId_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  params->version = in_version;
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PlatformVerification::Name_);
  message.set_method_name("GetStorageId");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new PlatformVerification_GetStorageId_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}
class PlatformVerification_ChallengePlatform_ProxyToResponder {
 public:
  static PlatformVerification::ChallengePlatformCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<PlatformVerification_ChallengePlatform_ProxyToResponder> proxy(
        new PlatformVerification_ChallengePlatform_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&PlatformVerification_ChallengePlatform_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~PlatformVerification_ChallengePlatform_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  PlatformVerification_ChallengePlatform_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "PlatformVerification::ChallengePlatformCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      bool in_success, const std::string& in_signed_data, const std::string& in_signed_data_signature, const std::string& in_platform_key_certificate);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(PlatformVerification_ChallengePlatform_ProxyToResponder);
};

bool PlatformVerification_ChallengePlatform_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "media::mojom::PlatformVerification::ChallengePlatformCallback",
               "message", message->name());
#endif
  mojo::internal::MessageDispatchContext dispatch_context(message);

  DCHECK(message->is_serialized());
  internal::PlatformVerification_ChallengePlatform_ResponseParams_Data* params =
      reinterpret_cast<
          internal::PlatformVerification_ChallengePlatform_ResponseParams_Data*>(
              message->mutable_payload());
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  
  bool success = true;
  bool p_success{};
  std::string p_signed_data{};
  std::string p_signed_data_signature{};
  std::string p_platform_key_certificate{};
  PlatformVerification_ChallengePlatform_ResponseParamsDataView input_data_view(params, &serialization_context);
  
  if (success)
    p_success = input_data_view.success();
  if (success && !input_data_view.ReadSignedData(&p_signed_data))
    success = false;
  if (success && !input_data_view.ReadSignedDataSignature(&p_signed_data_signature))
    success = false;
  if (success && !input_data_view.ReadPlatformKeyCertificate(&p_platform_key_certificate))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        PlatformVerification::Name_, 0, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_success), 
std::move(p_signed_data), 
std::move(p_signed_data_signature), 
std::move(p_platform_key_certificate));
  return true;
}

void PlatformVerification_ChallengePlatform_ProxyToResponder::Run(
    bool in_success, const std::string& in_signed_data, const std::string& in_signed_data_signature, const std::string& in_platform_key_certificate) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)media::mojom::PlatformVerification::ChallengePlatformCallback", "async_response_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetBoolean("success", in_success);
      raw_value->SetString("signed_data", in_signed_data);
      raw_value->SetString("signed_data_signature", in_signed_data_signature);
      raw_value->SetString("platform_key_certificate", in_platform_key_certificate);
      return value;
    }());
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kPlatformVerification_ChallengePlatform_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::media::mojom::internal::PlatformVerification_ChallengePlatform_ResponseParams_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  params->success = in_success;
  typename decltype(params->signed_data)::BaseType::BufferWriter
      signed_data_writer;
  mojo::internal::Serialize<mojo::StringDataView>(
      in_signed_data, buffer, &signed_data_writer, &serialization_context);
  params->signed_data.Set(
      signed_data_writer.is_null() ? nullptr : signed_data_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->signed_data.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null signed_data in ");
  typename decltype(params->signed_data_signature)::BaseType::BufferWriter
      signed_data_signature_writer;
  mojo::internal::Serialize<mojo::StringDataView>(
      in_signed_data_signature, buffer, &signed_data_signature_writer, &serialization_context);
  params->signed_data_signature.Set(
      signed_data_signature_writer.is_null() ? nullptr : signed_data_signature_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->signed_data_signature.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null signed_data_signature in ");
  typename decltype(params->platform_key_certificate)::BaseType::BufferWriter
      platform_key_certificate_writer;
  mojo::internal::Serialize<mojo::StringDataView>(
      in_platform_key_certificate, buffer, &platform_key_certificate_writer, &serialization_context);
  params->platform_key_certificate.Set(
      platform_key_certificate_writer.is_null() ? nullptr : platform_key_certificate_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->platform_key_certificate.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null platform_key_certificate in ");
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)media::mojom::PlatformVerification::ChallengePlatformCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PlatformVerification::Name_);
  message.set_method_name("ChallengePlatform");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class PlatformVerification_GetStorageId_ProxyToResponder {
 public:
  static PlatformVerification::GetStorageIdCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<PlatformVerification_GetStorageId_ProxyToResponder> proxy(
        new PlatformVerification_GetStorageId_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&PlatformVerification_GetStorageId_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~PlatformVerification_GetStorageId_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  PlatformVerification_GetStorageId_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "PlatformVerification::GetStorageIdCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      uint32_t in_version, const std::vector<uint8_t>& in_storage_id);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(PlatformVerification_GetStorageId_ProxyToResponder);
};

bool PlatformVerification_GetStorageId_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "media::mojom::PlatformVerification::GetStorageIdCallback",
               "message", message->name());
#endif
  mojo::internal::MessageDispatchContext dispatch_context(message);

  DCHECK(message->is_serialized());
  internal::PlatformVerification_GetStorageId_ResponseParams_Data* params =
      reinterpret_cast<
          internal::PlatformVerification_GetStorageId_ResponseParams_Data*>(
              message->mutable_payload());
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  
  bool success = true;
  uint32_t p_version{};
  std::vector<uint8_t> p_storage_id{};
  PlatformVerification_GetStorageId_ResponseParamsDataView input_data_view(params, &serialization_context);
  
  if (success)
    p_version = input_data_view.version();
  if (success && !input_data_view.ReadStorageId(&p_storage_id))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        PlatformVerification::Name_, 1, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_version), 
std::move(p_storage_id));
  return true;
}

void PlatformVerification_GetStorageId_ProxyToResponder::Run(
    uint32_t in_version, const std::vector<uint8_t>& in_storage_id) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)media::mojom::PlatformVerification::GetStorageIdCallback", "async_response_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetString("version", base::NumberToString(in_version));
      raw_value->BeginArray("storage_id");
      for (const auto& item0 : in_storage_id) {
        raw_value->AppendInteger(item0);
      }
      raw_value->EndArray();
      return value;
    }());
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kPlatformVerification_GetStorageId_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::media::mojom::internal::PlatformVerification_GetStorageId_ResponseParams_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  params->version = in_version;
  typename decltype(params->storage_id)::BaseType::BufferWriter
      storage_id_writer;
  const mojo::internal::ContainerValidateParams storage_id_validate_params(
      0, false, nullptr);
  mojo::internal::Serialize<mojo::ArrayDataView<uint8_t>>(
      in_storage_id, buffer, &storage_id_writer, &storage_id_validate_params,
      &serialization_context);
  params->storage_id.Set(
      storage_id_writer.is_null() ? nullptr : storage_id_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->storage_id.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null storage_id in ");
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)media::mojom::PlatformVerification::GetStorageIdCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PlatformVerification::Name_);
  message.set_method_name("GetStorageId");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool PlatformVerificationStubDispatch::Accept(
    PlatformVerification* impl,
    mojo::Message* message) {
  mojo::internal::MessageDispatchContext dispatch_context(message);
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  switch (message->header()->name) {
    case internal::kPlatformVerification_ChallengePlatform_Name: {
      break;
    }
    case internal::kPlatformVerification_GetStorageId_Name: {
      break;
    }
  }
  return false;
}

// static
bool PlatformVerificationStubDispatch::AcceptWithResponder(
    PlatformVerification* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  mojo::internal::MessageDispatchContext dispatch_context(message);
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kPlatformVerification_ChallengePlatform_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)media::mojom::PlatformVerification::ChallengePlatform",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)media::mojom::PlatformVerification::ChallengePlatform");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::PlatformVerification_ChallengePlatform_Params_Data* params =
          reinterpret_cast<
              internal::PlatformVerification_ChallengePlatform_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      std::string p_service_id{};
      std::string p_challenge{};
      PlatformVerification_ChallengePlatform_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success && !input_data_view.ReadServiceId(&p_service_id))
        success = false;
      if (success && !input_data_view.ReadChallenge(&p_challenge))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PlatformVerification::Name_, 0, false);
        return false;
      }
      PlatformVerification::ChallengePlatformCallback callback =
          PlatformVerification_ChallengePlatform_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ChallengePlatform(
std::move(p_service_id), 
std::move(p_challenge), std::move(callback));
      return true;
    }
    case internal::kPlatformVerification_GetStorageId_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)media::mojom::PlatformVerification::GetStorageId",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)media::mojom::PlatformVerification::GetStorageId");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::PlatformVerification_GetStorageId_Params_Data* params =
          reinterpret_cast<
              internal::PlatformVerification_GetStorageId_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      uint32_t p_version{};
      PlatformVerification_GetStorageId_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success)
        p_version = input_data_view.version();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PlatformVerification::Name_, 1, false);
        return false;
      }
      PlatformVerification::GetStorageIdCallback callback =
          PlatformVerification_GetStorageId_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetStorageId(
std::move(p_version), std::move(callback));
      return true;
    }
  }
  return false;
}


static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kPlatformVerificationValidationInfo[] = {
    {internal::kPlatformVerification_ChallengePlatform_Name,
     {&internal::PlatformVerification_ChallengePlatform_Params_Data::Validate,
      &internal::PlatformVerification_ChallengePlatform_ResponseParams_Data::Validate}},
    {internal::kPlatformVerification_GetStorageId_Name,
     {&internal::PlatformVerification_GetStorageId_Params_Data::Validate,
      &internal::PlatformVerification_GetStorageId_ResponseParams_Data::Validate}},
};

bool PlatformVerificationRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::media::mojom::PlatformVerification::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, kPlatformVerificationValidationInfo);
}

bool PlatformVerificationResponseValidator::Accept(mojo::Message* message) {
  const char* name = ::media::mojom::PlatformVerification::Name_;
  return mojo::internal::ValidateResponseGeneric(message, name, kPlatformVerificationValidationInfo);

}
}  // namespace mojom
}  // namespace media

namespace mojo {

}  // namespace mojo

#if defined(__clang__)
#pragma clang diagnostic pop
#endif