// media/capture/mojom/video_capture_types.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef MEDIA_CAPTURE_MOJOM_VIDEO_CAPTURE_TYPES_MOJOM_H_
#define MEDIA_CAPTURE_MOJOM_VIDEO_CAPTURE_TYPES_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <type_traits>
#include <utility>

#include "base/callback.h"
#include "base/macros.h"
#include "base/optional.h"

#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#if BUILDFLAG(MOJO_TRACE_ENABLED)
#include "base/trace_event/trace_event.h"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"
#include "media/capture/mojom/video_capture_types.mojom-shared.h"
#include "media/capture/mojom/video_capture_types.mojom-forward.h"
#include "gpu/ipc/common/mailbox_holder.mojom.h"
#include "media/mojo/mojom/media_types.mojom.h"
#include "mojo/public/mojom/base/shared_memory.mojom.h"
#include "mojo/public/mojom/base/time.mojom.h"
#include "ui/gfx/geometry/mojom/geometry.mojom.h"
#include "ui/gfx/mojom/buffer_types.mojom.h"
#include "ui/gfx/mojom/color_space.mojom.h"
#include <string>
#include <vector>

#include "mojo/public/cpp/bindings/associated_interface_ptr.h"
#include "mojo/public/cpp/bindings/associated_interface_ptr_info.h"
#include "mojo/public/cpp/bindings/associated_interface_request.h"
#include "mojo/public/cpp/bindings/interface_ptr.h"
#include "mojo/public/cpp/bindings/interface_request.h"
#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"
#include "mojo/public/cpp/bindings/thread_safe_interface_ptr.h"


#include "media/capture/mojom/video_capture_types_mojom_traits.h"



// Forward-declare for |AsValueInto| so that we do not have to import the
// corresponding header.
namespace base {
namespace trace_event {
class TracedValue;
}  // namespace trace_event
}  // namespace base


namespace media {
namespace mojom {





class  VideoCaptureControlSupport {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<VideoCaptureControlSupport, T>::value>;
  using DataView = VideoCaptureControlSupportDataView;
  using Data_ = internal::VideoCaptureControlSupport_Data;

  template <typename... Args>
  static VideoCaptureControlSupportPtr New(Args&&... args) {
    return VideoCaptureControlSupportPtr(
        base::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static VideoCaptureControlSupportPtr From(const U& u) {
    return mojo::TypeConverter<VideoCaptureControlSupportPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, VideoCaptureControlSupport>::Convert(*this);
  }


  VideoCaptureControlSupport();

  VideoCaptureControlSupport(
      bool pan,
      bool tilt,
      bool zoom);

  ~VideoCaptureControlSupport();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = VideoCaptureControlSupportPtr>
  VideoCaptureControlSupportPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, VideoCaptureControlSupport::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        VideoCaptureControlSupport::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        VideoCaptureControlSupport::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::VideoCaptureControlSupport_UnserializedMessageContext<
            UserType, VideoCaptureControlSupport::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    return mojo::internal::DeserializeImpl<VideoCaptureControlSupport::DataView>(
        data, data_num_bytes, std::vector<mojo::ScopedHandle>(), output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(const std::vector<uint8_t>& input,
                          UserType* output) {
    return VideoCaptureControlSupport::Deserialize(
        input.size() == 0 ? nullptr : &input.front(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::VideoCaptureControlSupport_UnserializedMessageContext<
            UserType, VideoCaptureControlSupport::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<VideoCaptureControlSupport::DataView>(
        input.payload(), input.payload_num_bytes(),
        std::move(*input.mutable_handles()), output, Validate);
  }

  
  bool pan;
  
  bool tilt;
  
  bool zoom;

  // Write this structure into |value|. The members are represented as a
  // dictionary |member name|: |member value|. This method does not deal with
  // the dictionary name. The caller is responsible for not calling
  // |AsValueInto| when |value| expects array items (see Array/Dictionary
  // methods of |base::trace_event::TracedValue|).
  //
  // |value| The TracedValue to be written into.
  //
  // Example uses:
  //
  //   // |my_var1, my_var2| are variables with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   value->BeginDictionary("my_var1");
  //   my_var1.AsValueInto(value.get());
  //   value->EndDictionary();
  //   value->BeginDictionary("my_var2");
  //   my_var2.AsValueInto(value.get());
  //   value->EndDictionary();
  //
  //   // |my_var| is a variable with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   my_var.AsValueInto(value.get());
  //   TRACE_EVENT1("test", "test", "my_var", std::move(value));
  //
  // Calling |AsValueInto| on two objects without opening and closing a
  // dictionary for each object is theoretically possible, but strongly
  // discouraged due to potential name collisions:
  //
  //   struct A {
  //     int foo;
  //   };
  //   struct B {
  //     int bar;
  //   };
  //   struct C {
  //     int foo;
  //     int bar;
  //   };
  //   auto value1 = std::make_unique<base::trace_event::TracedValue>();
  //   auto value2 = std::make_unique<base::trace_event::TracedValue>();
  //   A a;
  //   B b;
  //   C c;
  //   // value1 and value2 will be filled with the same information:
  //   a.AsValueInto(value1);
  //   b.AsValueInto(value1);
  //   c.AsValueInto(value2);
  void AsValueInto(base::trace_event::TracedValue* value) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, VideoCaptureControlSupport::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, VideoCaptureControlSupport::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, VideoCaptureControlSupport::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, VideoCaptureControlSupport::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}







class  VideoFrameFeedback {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<VideoFrameFeedback, T>::value>;
  using DataView = VideoFrameFeedbackDataView;
  using Data_ = internal::VideoFrameFeedback_Data;

  template <typename... Args>
  static VideoFrameFeedbackPtr New(Args&&... args) {
    return VideoFrameFeedbackPtr(
        base::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static VideoFrameFeedbackPtr From(const U& u) {
    return mojo::TypeConverter<VideoFrameFeedbackPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, VideoFrameFeedback>::Convert(*this);
  }


  VideoFrameFeedback();

  VideoFrameFeedback(
      double resource_utilization,
      float max_framerate_fps,
      int32_t max_pixels);

  ~VideoFrameFeedback();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = VideoFrameFeedbackPtr>
  VideoFrameFeedbackPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, VideoFrameFeedback::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        VideoFrameFeedback::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        VideoFrameFeedback::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::VideoFrameFeedback_UnserializedMessageContext<
            UserType, VideoFrameFeedback::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    return mojo::internal::DeserializeImpl<VideoFrameFeedback::DataView>(
        data, data_num_bytes, std::vector<mojo::ScopedHandle>(), output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(const std::vector<uint8_t>& input,
                          UserType* output) {
    return VideoFrameFeedback::Deserialize(
        input.size() == 0 ? nullptr : &input.front(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::VideoFrameFeedback_UnserializedMessageContext<
            UserType, VideoFrameFeedback::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<VideoFrameFeedback::DataView>(
        input.payload(), input.payload_num_bytes(),
        std::move(*input.mutable_handles()), output, Validate);
  }

  
  double resource_utilization;
  
  float max_framerate_fps;
  
  int32_t max_pixels;

  // Write this structure into |value|. The members are represented as a
  // dictionary |member name|: |member value|. This method does not deal with
  // the dictionary name. The caller is responsible for not calling
  // |AsValueInto| when |value| expects array items (see Array/Dictionary
  // methods of |base::trace_event::TracedValue|).
  //
  // |value| The TracedValue to be written into.
  //
  // Example uses:
  //
  //   // |my_var1, my_var2| are variables with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   value->BeginDictionary("my_var1");
  //   my_var1.AsValueInto(value.get());
  //   value->EndDictionary();
  //   value->BeginDictionary("my_var2");
  //   my_var2.AsValueInto(value.get());
  //   value->EndDictionary();
  //
  //   // |my_var| is a variable with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   my_var.AsValueInto(value.get());
  //   TRACE_EVENT1("test", "test", "my_var", std::move(value));
  //
  // Calling |AsValueInto| on two objects without opening and closing a
  // dictionary for each object is theoretically possible, but strongly
  // discouraged due to potential name collisions:
  //
  //   struct A {
  //     int foo;
  //   };
  //   struct B {
  //     int bar;
  //   };
  //   struct C {
  //     int foo;
  //     int bar;
  //   };
  //   auto value1 = std::make_unique<base::trace_event::TracedValue>();
  //   auto value2 = std::make_unique<base::trace_event::TracedValue>();
  //   A a;
  //   B b;
  //   C c;
  //   // value1 and value2 will be filled with the same information:
  //   a.AsValueInto(value1);
  //   b.AsValueInto(value1);
  //   c.AsValueInto(value2);
  void AsValueInto(base::trace_event::TracedValue* value) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, VideoFrameFeedback::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, VideoFrameFeedback::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, VideoFrameFeedback::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, VideoFrameFeedback::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}











class  VideoBufferHandle {
 public:
  using DataView = VideoBufferHandleDataView;
  using Data_ = internal::VideoBufferHandle_Data;
  using Tag = Data_::VideoBufferHandle_Tag;

  static VideoBufferHandlePtr New() {
    return VideoBufferHandlePtr(base::in_place);
  }
  // Construct an instance holding |shared_buffer_handle|.
  static VideoBufferHandlePtr
  NewSharedBufferHandle(
      ::mojo::ScopedSharedBufferHandle shared_buffer_handle) {
    auto result = VideoBufferHandlePtr(base::in_place);
    result->set_shared_buffer_handle(std::move(shared_buffer_handle));
    return result;
  }
  // Construct an instance holding |read_only_shmem_region|.
  static VideoBufferHandlePtr
  NewReadOnlyShmemRegion(
      ::base::ReadOnlySharedMemoryRegion read_only_shmem_region) {
    auto result = VideoBufferHandlePtr(base::in_place);
    result->set_read_only_shmem_region(std::move(read_only_shmem_region));
    return result;
  }
  // Construct an instance holding |shared_memory_via_raw_file_descriptor|.
  static VideoBufferHandlePtr
  NewSharedMemoryViaRawFileDescriptor(
      SharedMemoryViaRawFileDescriptorPtr shared_memory_via_raw_file_descriptor) {
    auto result = VideoBufferHandlePtr(base::in_place);
    result->set_shared_memory_via_raw_file_descriptor(std::move(shared_memory_via_raw_file_descriptor));
    return result;
  }
  // Construct an instance holding |mailbox_handles|.
  static VideoBufferHandlePtr
  NewMailboxHandles(
      MailboxBufferHandleSetPtr mailbox_handles) {
    auto result = VideoBufferHandlePtr(base::in_place);
    result->set_mailbox_handles(std::move(mailbox_handles));
    return result;
  }
  // Construct an instance holding |gpu_memory_buffer_handle|.
  static VideoBufferHandlePtr
  NewGpuMemoryBufferHandle(
      ::gfx::GpuMemoryBufferHandle gpu_memory_buffer_handle) {
    auto result = VideoBufferHandlePtr(base::in_place);
    result->set_gpu_memory_buffer_handle(std::move(gpu_memory_buffer_handle));
    return result;
  }

  template <typename U>
  static VideoBufferHandlePtr From(const U& u) {
    return mojo::TypeConverter<VideoBufferHandlePtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, VideoBufferHandle>::Convert(*this);
  }

  VideoBufferHandle();
  ~VideoBufferHandle();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename UnionPtrType = VideoBufferHandlePtr>
  VideoBufferHandlePtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T,
            typename std::enable_if<std::is_same<
                T, VideoBufferHandle>::value>::type* = nullptr>
  bool Equals(const T& other) const;

  Tag which() const {
    return tag_;
  }


  
  bool is_shared_buffer_handle() const { return tag_ == Tag::SHARED_BUFFER_HANDLE; }

  
  ::mojo::ScopedSharedBufferHandle& get_shared_buffer_handle() const {
    DCHECK(tag_ == Tag::SHARED_BUFFER_HANDLE);
    return *(data_.shared_buffer_handle);
  }

  
  void set_shared_buffer_handle(
      ::mojo::ScopedSharedBufferHandle shared_buffer_handle);
  
  bool is_read_only_shmem_region() const { return tag_ == Tag::READ_ONLY_SHMEM_REGION; }

  
  ::base::ReadOnlySharedMemoryRegion& get_read_only_shmem_region() const {
    DCHECK(tag_ == Tag::READ_ONLY_SHMEM_REGION);
    return *(data_.read_only_shmem_region);
  }

  
  void set_read_only_shmem_region(
      ::base::ReadOnlySharedMemoryRegion read_only_shmem_region);
  
  bool is_shared_memory_via_raw_file_descriptor() const { return tag_ == Tag::SHARED_MEMORY_VIA_RAW_FILE_DESCRIPTOR; }

  
  SharedMemoryViaRawFileDescriptorPtr& get_shared_memory_via_raw_file_descriptor() const {
    DCHECK(tag_ == Tag::SHARED_MEMORY_VIA_RAW_FILE_DESCRIPTOR);
    return *(data_.shared_memory_via_raw_file_descriptor);
  }

  
  void set_shared_memory_via_raw_file_descriptor(
      SharedMemoryViaRawFileDescriptorPtr shared_memory_via_raw_file_descriptor);
  
  bool is_mailbox_handles() const { return tag_ == Tag::MAILBOX_HANDLES; }

  
  MailboxBufferHandleSetPtr& get_mailbox_handles() const {
    DCHECK(tag_ == Tag::MAILBOX_HANDLES);
    return *(data_.mailbox_handles);
  }

  
  void set_mailbox_handles(
      MailboxBufferHandleSetPtr mailbox_handles);
  
  bool is_gpu_memory_buffer_handle() const { return tag_ == Tag::GPU_MEMORY_BUFFER_HANDLE; }

  
  ::gfx::GpuMemoryBufferHandle& get_gpu_memory_buffer_handle() const {
    DCHECK(tag_ == Tag::GPU_MEMORY_BUFFER_HANDLE);
    return *(data_.gpu_memory_buffer_handle);
  }

  
  void set_gpu_memory_buffer_handle(
      ::gfx::GpuMemoryBufferHandle gpu_memory_buffer_handle);

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        VideoBufferHandle::DataView>(input);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    return mojo::internal::DeserializeImpl<VideoBufferHandle::DataView>(
        input.payload(), input.payload_num_bytes(),
        std::move(*input.mutable_handles()), output, Validate);
  }

 private:
  union Union_ {
    Union_() {}
    ~Union_() {}
    ::mojo::ScopedSharedBufferHandle* shared_buffer_handle;
    ::base::ReadOnlySharedMemoryRegion* read_only_shmem_region;
    SharedMemoryViaRawFileDescriptorPtr* shared_memory_via_raw_file_descriptor;
    MailboxBufferHandleSetPtr* mailbox_handles;
    ::gfx::GpuMemoryBufferHandle* gpu_memory_buffer_handle;
  };

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  void DestroyActive();
  Tag tag_;
  Union_ data_;
};






class  VideoCaptureFormat {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<VideoCaptureFormat, T>::value>;
  using DataView = VideoCaptureFormatDataView;
  using Data_ = internal::VideoCaptureFormat_Data;

  template <typename... Args>
  static VideoCaptureFormatPtr New(Args&&... args) {
    return VideoCaptureFormatPtr(
        base::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static VideoCaptureFormatPtr From(const U& u) {
    return mojo::TypeConverter<VideoCaptureFormatPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, VideoCaptureFormat>::Convert(*this);
  }


  VideoCaptureFormat();

  VideoCaptureFormat(
      const ::gfx::Size& frame_size,
      float frame_rate,
      ::media::VideoPixelFormat pixel_format);

  ~VideoCaptureFormat();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = VideoCaptureFormatPtr>
  VideoCaptureFormatPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, VideoCaptureFormat::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        VideoCaptureFormat::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        VideoCaptureFormat::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::VideoCaptureFormat_UnserializedMessageContext<
            UserType, VideoCaptureFormat::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    return mojo::internal::DeserializeImpl<VideoCaptureFormat::DataView>(
        data, data_num_bytes, std::vector<mojo::ScopedHandle>(), output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(const std::vector<uint8_t>& input,
                          UserType* output) {
    return VideoCaptureFormat::Deserialize(
        input.size() == 0 ? nullptr : &input.front(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::VideoCaptureFormat_UnserializedMessageContext<
            UserType, VideoCaptureFormat::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<VideoCaptureFormat::DataView>(
        input.payload(), input.payload_num_bytes(),
        std::move(*input.mutable_handles()), output, Validate);
  }

  
  ::gfx::Size frame_size;
  
  float frame_rate;
  
  ::media::VideoPixelFormat pixel_format;

  // Write this structure into |value|. The members are represented as a
  // dictionary |member name|: |member value|. This method does not deal with
  // the dictionary name. The caller is responsible for not calling
  // |AsValueInto| when |value| expects array items (see Array/Dictionary
  // methods of |base::trace_event::TracedValue|).
  //
  // |value| The TracedValue to be written into.
  //
  // Example uses:
  //
  //   // |my_var1, my_var2| are variables with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   value->BeginDictionary("my_var1");
  //   my_var1.AsValueInto(value.get());
  //   value->EndDictionary();
  //   value->BeginDictionary("my_var2");
  //   my_var2.AsValueInto(value.get());
  //   value->EndDictionary();
  //
  //   // |my_var| is a variable with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   my_var.AsValueInto(value.get());
  //   TRACE_EVENT1("test", "test", "my_var", std::move(value));
  //
  // Calling |AsValueInto| on two objects without opening and closing a
  // dictionary for each object is theoretically possible, but strongly
  // discouraged due to potential name collisions:
  //
  //   struct A {
  //     int foo;
  //   };
  //   struct B {
  //     int bar;
  //   };
  //   struct C {
  //     int foo;
  //     int bar;
  //   };
  //   auto value1 = std::make_unique<base::trace_event::TracedValue>();
  //   auto value2 = std::make_unique<base::trace_event::TracedValue>();
  //   A a;
  //   B b;
  //   C c;
  //   // value1 and value2 will be filled with the same information:
  //   a.AsValueInto(value1);
  //   b.AsValueInto(value1);
  //   c.AsValueInto(value2);
  void AsValueInto(base::trace_event::TracedValue* value) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, VideoCaptureFormat::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, VideoCaptureFormat::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, VideoCaptureFormat::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, VideoCaptureFormat::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  VideoCaptureParams {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<VideoCaptureParams, T>::value>;
  using DataView = VideoCaptureParamsDataView;
  using Data_ = internal::VideoCaptureParams_Data;

  template <typename... Args>
  static VideoCaptureParamsPtr New(Args&&... args) {
    return VideoCaptureParamsPtr(
        base::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static VideoCaptureParamsPtr From(const U& u) {
    return mojo::TypeConverter<VideoCaptureParamsPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, VideoCaptureParams>::Convert(*this);
  }


  VideoCaptureParams();

  VideoCaptureParams(
      const ::media::VideoCaptureFormat& requested_format,
      ::media::VideoCaptureBufferType buffer_type,
      ::media::ResolutionChangePolicy resolution_change_policy,
      ::media::PowerLineFrequency power_line_frequency,
      bool enable_face_detection);

  ~VideoCaptureParams();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = VideoCaptureParamsPtr>
  VideoCaptureParamsPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, VideoCaptureParams::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        VideoCaptureParams::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        VideoCaptureParams::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::VideoCaptureParams_UnserializedMessageContext<
            UserType, VideoCaptureParams::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    return mojo::internal::DeserializeImpl<VideoCaptureParams::DataView>(
        data, data_num_bytes, std::vector<mojo::ScopedHandle>(), output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(const std::vector<uint8_t>& input,
                          UserType* output) {
    return VideoCaptureParams::Deserialize(
        input.size() == 0 ? nullptr : &input.front(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::VideoCaptureParams_UnserializedMessageContext<
            UserType, VideoCaptureParams::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<VideoCaptureParams::DataView>(
        input.payload(), input.payload_num_bytes(),
        std::move(*input.mutable_handles()), output, Validate);
  }

  
  ::media::VideoCaptureFormat requested_format;
  
  ::media::VideoCaptureBufferType buffer_type;
  
  ::media::ResolutionChangePolicy resolution_change_policy;
  
  ::media::PowerLineFrequency power_line_frequency;
  
  bool enable_face_detection;

  // Write this structure into |value|. The members are represented as a
  // dictionary |member name|: |member value|. This method does not deal with
  // the dictionary name. The caller is responsible for not calling
  // |AsValueInto| when |value| expects array items (see Array/Dictionary
  // methods of |base::trace_event::TracedValue|).
  //
  // |value| The TracedValue to be written into.
  //
  // Example uses:
  //
  //   // |my_var1, my_var2| are variables with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   value->BeginDictionary("my_var1");
  //   my_var1.AsValueInto(value.get());
  //   value->EndDictionary();
  //   value->BeginDictionary("my_var2");
  //   my_var2.AsValueInto(value.get());
  //   value->EndDictionary();
  //
  //   // |my_var| is a variable with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   my_var.AsValueInto(value.get());
  //   TRACE_EVENT1("test", "test", "my_var", std::move(value));
  //
  // Calling |AsValueInto| on two objects without opening and closing a
  // dictionary for each object is theoretically possible, but strongly
  // discouraged due to potential name collisions:
  //
  //   struct A {
  //     int foo;
  //   };
  //   struct B {
  //     int bar;
  //   };
  //   struct C {
  //     int foo;
  //     int bar;
  //   };
  //   auto value1 = std::make_unique<base::trace_event::TracedValue>();
  //   auto value2 = std::make_unique<base::trace_event::TracedValue>();
  //   A a;
  //   B b;
  //   C c;
  //   // value1 and value2 will be filled with the same information:
  //   a.AsValueInto(value1);
  //   b.AsValueInto(value1);
  //   c.AsValueInto(value2);
  void AsValueInto(base::trace_event::TracedValue* value) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, VideoCaptureParams::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, VideoCaptureParams::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, VideoCaptureParams::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, VideoCaptureParams::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}






class  PlaneStrides {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<PlaneStrides, T>::value>;
  using DataView = PlaneStridesDataView;
  using Data_ = internal::PlaneStrides_Data;

  template <typename... Args>
  static PlaneStridesPtr New(Args&&... args) {
    return PlaneStridesPtr(
        base::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static PlaneStridesPtr From(const U& u) {
    return mojo::TypeConverter<PlaneStridesPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, PlaneStrides>::Convert(*this);
  }


  PlaneStrides();

  explicit PlaneStrides(
      std::vector<uint32_t> stride_by_plane);

  ~PlaneStrides();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = PlaneStridesPtr>
  PlaneStridesPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, PlaneStrides::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        PlaneStrides::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        PlaneStrides::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::PlaneStrides_UnserializedMessageContext<
            UserType, PlaneStrides::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    return mojo::internal::DeserializeImpl<PlaneStrides::DataView>(
        data, data_num_bytes, std::vector<mojo::ScopedHandle>(), output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(const std::vector<uint8_t>& input,
                          UserType* output) {
    return PlaneStrides::Deserialize(
        input.size() == 0 ? nullptr : &input.front(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::PlaneStrides_UnserializedMessageContext<
            UserType, PlaneStrides::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<PlaneStrides::DataView>(
        input.payload(), input.payload_num_bytes(),
        std::move(*input.mutable_handles()), output, Validate);
  }

  
  std::vector<uint32_t> stride_by_plane;

  // Write this structure into |value|. The members are represented as a
  // dictionary |member name|: |member value|. This method does not deal with
  // the dictionary name. The caller is responsible for not calling
  // |AsValueInto| when |value| expects array items (see Array/Dictionary
  // methods of |base::trace_event::TracedValue|).
  //
  // |value| The TracedValue to be written into.
  //
  // Example uses:
  //
  //   // |my_var1, my_var2| are variables with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   value->BeginDictionary("my_var1");
  //   my_var1.AsValueInto(value.get());
  //   value->EndDictionary();
  //   value->BeginDictionary("my_var2");
  //   my_var2.AsValueInto(value.get());
  //   value->EndDictionary();
  //
  //   // |my_var| is a variable with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   my_var.AsValueInto(value.get());
  //   TRACE_EVENT1("test", "test", "my_var", std::move(value));
  //
  // Calling |AsValueInto| on two objects without opening and closing a
  // dictionary for each object is theoretically possible, but strongly
  // discouraged due to potential name collisions:
  //
  //   struct A {
  //     int foo;
  //   };
  //   struct B {
  //     int bar;
  //   };
  //   struct C {
  //     int foo;
  //     int bar;
  //   };
  //   auto value1 = std::make_unique<base::trace_event::TracedValue>();
  //   auto value2 = std::make_unique<base::trace_event::TracedValue>();
  //   A a;
  //   B b;
  //   C c;
  //   // value1 and value2 will be filled with the same information:
  //   a.AsValueInto(value1);
  //   b.AsValueInto(value1);
  //   c.AsValueInto(value2);
  void AsValueInto(base::trace_event::TracedValue* value) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, PlaneStrides::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, PlaneStrides::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, PlaneStrides::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, PlaneStrides::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  VideoFrameInfo {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<VideoFrameInfo, T>::value>;
  using DataView = VideoFrameInfoDataView;
  using Data_ = internal::VideoFrameInfo_Data;

  template <typename... Args>
  static VideoFrameInfoPtr New(Args&&... args) {
    return VideoFrameInfoPtr(
        base::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static VideoFrameInfoPtr From(const U& u) {
    return mojo::TypeConverter<VideoFrameInfoPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, VideoFrameInfo>::Convert(*this);
  }


  VideoFrameInfo();

  VideoFrameInfo(
      ::base::TimeDelta timestamp,
      const ::media::VideoFrameMetadata& metadata,
      ::media::VideoPixelFormat pixel_format,
      const ::gfx::Size& coded_size,
      const ::gfx::Rect& visible_rect,
      const base::Optional<::gfx::ColorSpace>& color_space,
      PlaneStridesPtr strides);

  ~VideoFrameInfo();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = VideoFrameInfoPtr>
  VideoFrameInfoPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, VideoFrameInfo::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        VideoFrameInfo::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        VideoFrameInfo::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::VideoFrameInfo_UnserializedMessageContext<
            UserType, VideoFrameInfo::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    return mojo::internal::DeserializeImpl<VideoFrameInfo::DataView>(
        data, data_num_bytes, std::vector<mojo::ScopedHandle>(), output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(const std::vector<uint8_t>& input,
                          UserType* output) {
    return VideoFrameInfo::Deserialize(
        input.size() == 0 ? nullptr : &input.front(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::VideoFrameInfo_UnserializedMessageContext<
            UserType, VideoFrameInfo::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<VideoFrameInfo::DataView>(
        input.payload(), input.payload_num_bytes(),
        std::move(*input.mutable_handles()), output, Validate);
  }

  
  ::base::TimeDelta timestamp;
  
  ::media::VideoFrameMetadata metadata;
  
  ::media::VideoPixelFormat pixel_format;
  
  ::gfx::Size coded_size;
  
  ::gfx::Rect visible_rect;
  
  base::Optional<::gfx::ColorSpace> color_space;
  
  PlaneStridesPtr strides;

  // Write this structure into |value|. The members are represented as a
  // dictionary |member name|: |member value|. This method does not deal with
  // the dictionary name. The caller is responsible for not calling
  // |AsValueInto| when |value| expects array items (see Array/Dictionary
  // methods of |base::trace_event::TracedValue|).
  //
  // |value| The TracedValue to be written into.
  //
  // Example uses:
  //
  //   // |my_var1, my_var2| are variables with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   value->BeginDictionary("my_var1");
  //   my_var1.AsValueInto(value.get());
  //   value->EndDictionary();
  //   value->BeginDictionary("my_var2");
  //   my_var2.AsValueInto(value.get());
  //   value->EndDictionary();
  //
  //   // |my_var| is a variable with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   my_var.AsValueInto(value.get());
  //   TRACE_EVENT1("test", "test", "my_var", std::move(value));
  //
  // Calling |AsValueInto| on two objects without opening and closing a
  // dictionary for each object is theoretically possible, but strongly
  // discouraged due to potential name collisions:
  //
  //   struct A {
  //     int foo;
  //   };
  //   struct B {
  //     int bar;
  //   };
  //   struct C {
  //     int foo;
  //     int bar;
  //   };
  //   auto value1 = std::make_unique<base::trace_event::TracedValue>();
  //   auto value2 = std::make_unique<base::trace_event::TracedValue>();
  //   A a;
  //   B b;
  //   C c;
  //   // value1 and value2 will be filled with the same information:
  //   a.AsValueInto(value1);
  //   b.AsValueInto(value1);
  //   c.AsValueInto(value2);
  void AsValueInto(base::trace_event::TracedValue* value) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
  DISALLOW_COPY_AND_ASSIGN(VideoFrameInfo);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, VideoFrameInfo::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, VideoFrameInfo::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, VideoFrameInfo::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, VideoFrameInfo::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  VideoCaptureDeviceDescriptor {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<VideoCaptureDeviceDescriptor, T>::value>;
  using DataView = VideoCaptureDeviceDescriptorDataView;
  using Data_ = internal::VideoCaptureDeviceDescriptor_Data;

  template <typename... Args>
  static VideoCaptureDeviceDescriptorPtr New(Args&&... args) {
    return VideoCaptureDeviceDescriptorPtr(
        base::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static VideoCaptureDeviceDescriptorPtr From(const U& u) {
    return mojo::TypeConverter<VideoCaptureDeviceDescriptorPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, VideoCaptureDeviceDescriptor>::Convert(*this);
  }


  VideoCaptureDeviceDescriptor();

  VideoCaptureDeviceDescriptor(
      const std::string& display_name,
      const std::string& device_id,
      const std::string& model_id,
      ::media::VideoFacingMode facing_mode,
      VideoCaptureApi capture_api,
      const ::media::VideoCaptureControlSupport& control_support,
      VideoCaptureTransportType transport_type);

  ~VideoCaptureDeviceDescriptor();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = VideoCaptureDeviceDescriptorPtr>
  VideoCaptureDeviceDescriptorPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, VideoCaptureDeviceDescriptor::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        VideoCaptureDeviceDescriptor::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        VideoCaptureDeviceDescriptor::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::VideoCaptureDeviceDescriptor_UnserializedMessageContext<
            UserType, VideoCaptureDeviceDescriptor::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    return mojo::internal::DeserializeImpl<VideoCaptureDeviceDescriptor::DataView>(
        data, data_num_bytes, std::vector<mojo::ScopedHandle>(), output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(const std::vector<uint8_t>& input,
                          UserType* output) {
    return VideoCaptureDeviceDescriptor::Deserialize(
        input.size() == 0 ? nullptr : &input.front(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::VideoCaptureDeviceDescriptor_UnserializedMessageContext<
            UserType, VideoCaptureDeviceDescriptor::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<VideoCaptureDeviceDescriptor::DataView>(
        input.payload(), input.payload_num_bytes(),
        std::move(*input.mutable_handles()), output, Validate);
  }

  
  std::string display_name;
  
  std::string device_id;
  
  std::string model_id;
  
  ::media::VideoFacingMode facing_mode;
  
  VideoCaptureApi capture_api;
  
  ::media::VideoCaptureControlSupport control_support;
  
  VideoCaptureTransportType transport_type;

  // Write this structure into |value|. The members are represented as a
  // dictionary |member name|: |member value|. This method does not deal with
  // the dictionary name. The caller is responsible for not calling
  // |AsValueInto| when |value| expects array items (see Array/Dictionary
  // methods of |base::trace_event::TracedValue|).
  //
  // |value| The TracedValue to be written into.
  //
  // Example uses:
  //
  //   // |my_var1, my_var2| are variables with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   value->BeginDictionary("my_var1");
  //   my_var1.AsValueInto(value.get());
  //   value->EndDictionary();
  //   value->BeginDictionary("my_var2");
  //   my_var2.AsValueInto(value.get());
  //   value->EndDictionary();
  //
  //   // |my_var| is a variable with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   my_var.AsValueInto(value.get());
  //   TRACE_EVENT1("test", "test", "my_var", std::move(value));
  //
  // Calling |AsValueInto| on two objects without opening and closing a
  // dictionary for each object is theoretically possible, but strongly
  // discouraged due to potential name collisions:
  //
  //   struct A {
  //     int foo;
  //   };
  //   struct B {
  //     int bar;
  //   };
  //   struct C {
  //     int foo;
  //     int bar;
  //   };
  //   auto value1 = std::make_unique<base::trace_event::TracedValue>();
  //   auto value2 = std::make_unique<base::trace_event::TracedValue>();
  //   A a;
  //   B b;
  //   C c;
  //   // value1 and value2 will be filled with the same information:
  //   a.AsValueInto(value1);
  //   b.AsValueInto(value1);
  //   c.AsValueInto(value2);
  void AsValueInto(base::trace_event::TracedValue* value) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, VideoCaptureDeviceDescriptor::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, VideoCaptureDeviceDescriptor::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, VideoCaptureDeviceDescriptor::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, VideoCaptureDeviceDescriptor::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  VideoCaptureDeviceInfo {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<VideoCaptureDeviceInfo, T>::value>;
  using DataView = VideoCaptureDeviceInfoDataView;
  using Data_ = internal::VideoCaptureDeviceInfo_Data;

  template <typename... Args>
  static VideoCaptureDeviceInfoPtr New(Args&&... args) {
    return VideoCaptureDeviceInfoPtr(
        base::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static VideoCaptureDeviceInfoPtr From(const U& u) {
    return mojo::TypeConverter<VideoCaptureDeviceInfoPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, VideoCaptureDeviceInfo>::Convert(*this);
  }


  VideoCaptureDeviceInfo();

  VideoCaptureDeviceInfo(
      const ::media::VideoCaptureDeviceDescriptor& descriptor,
      std::vector<::media::VideoCaptureFormat> supported_formats);

  ~VideoCaptureDeviceInfo();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = VideoCaptureDeviceInfoPtr>
  VideoCaptureDeviceInfoPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, VideoCaptureDeviceInfo::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        VideoCaptureDeviceInfo::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        VideoCaptureDeviceInfo::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::VideoCaptureDeviceInfo_UnserializedMessageContext<
            UserType, VideoCaptureDeviceInfo::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    return mojo::internal::DeserializeImpl<VideoCaptureDeviceInfo::DataView>(
        data, data_num_bytes, std::vector<mojo::ScopedHandle>(), output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(const std::vector<uint8_t>& input,
                          UserType* output) {
    return VideoCaptureDeviceInfo::Deserialize(
        input.size() == 0 ? nullptr : &input.front(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::VideoCaptureDeviceInfo_UnserializedMessageContext<
            UserType, VideoCaptureDeviceInfo::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<VideoCaptureDeviceInfo::DataView>(
        input.payload(), input.payload_num_bytes(),
        std::move(*input.mutable_handles()), output, Validate);
  }

  
  ::media::VideoCaptureDeviceDescriptor descriptor;
  
  std::vector<::media::VideoCaptureFormat> supported_formats;

  // Write this structure into |value|. The members are represented as a
  // dictionary |member name|: |member value|. This method does not deal with
  // the dictionary name. The caller is responsible for not calling
  // |AsValueInto| when |value| expects array items (see Array/Dictionary
  // methods of |base::trace_event::TracedValue|).
  //
  // |value| The TracedValue to be written into.
  //
  // Example uses:
  //
  //   // |my_var1, my_var2| are variables with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   value->BeginDictionary("my_var1");
  //   my_var1.AsValueInto(value.get());
  //   value->EndDictionary();
  //   value->BeginDictionary("my_var2");
  //   my_var2.AsValueInto(value.get());
  //   value->EndDictionary();
  //
  //   // |my_var| is a variable with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   my_var.AsValueInto(value.get());
  //   TRACE_EVENT1("test", "test", "my_var", std::move(value));
  //
  // Calling |AsValueInto| on two objects without opening and closing a
  // dictionary for each object is theoretically possible, but strongly
  // discouraged due to potential name collisions:
  //
  //   struct A {
  //     int foo;
  //   };
  //   struct B {
  //     int bar;
  //   };
  //   struct C {
  //     int foo;
  //     int bar;
  //   };
  //   auto value1 = std::make_unique<base::trace_event::TracedValue>();
  //   auto value2 = std::make_unique<base::trace_event::TracedValue>();
  //   A a;
  //   B b;
  //   C c;
  //   // value1 and value2 will be filled with the same information:
  //   a.AsValueInto(value1);
  //   b.AsValueInto(value1);
  //   c.AsValueInto(value2);
  void AsValueInto(base::trace_event::TracedValue* value) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, VideoCaptureDeviceInfo::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, VideoCaptureDeviceInfo::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, VideoCaptureDeviceInfo::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, VideoCaptureDeviceInfo::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  MailboxBufferHandleSet {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<MailboxBufferHandleSet, T>::value>;
  using DataView = MailboxBufferHandleSetDataView;
  using Data_ = internal::MailboxBufferHandleSet_Data;

  template <typename... Args>
  static MailboxBufferHandleSetPtr New(Args&&... args) {
    return MailboxBufferHandleSetPtr(
        base::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static MailboxBufferHandleSetPtr From(const U& u) {
    return mojo::TypeConverter<MailboxBufferHandleSetPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, MailboxBufferHandleSet>::Convert(*this);
  }


  MailboxBufferHandleSet();

  explicit MailboxBufferHandleSet(
      std::vector<::gpu::MailboxHolder> mailbox_holder);

  ~MailboxBufferHandleSet();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = MailboxBufferHandleSetPtr>
  MailboxBufferHandleSetPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, MailboxBufferHandleSet::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        MailboxBufferHandleSet::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        MailboxBufferHandleSet::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::MailboxBufferHandleSet_UnserializedMessageContext<
            UserType, MailboxBufferHandleSet::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    return mojo::internal::DeserializeImpl<MailboxBufferHandleSet::DataView>(
        data, data_num_bytes, std::vector<mojo::ScopedHandle>(), output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(const std::vector<uint8_t>& input,
                          UserType* output) {
    return MailboxBufferHandleSet::Deserialize(
        input.size() == 0 ? nullptr : &input.front(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::MailboxBufferHandleSet_UnserializedMessageContext<
            UserType, MailboxBufferHandleSet::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<MailboxBufferHandleSet::DataView>(
        input.payload(), input.payload_num_bytes(),
        std::move(*input.mutable_handles()), output, Validate);
  }

  
  std::vector<::gpu::MailboxHolder> mailbox_holder;

  // Write this structure into |value|. The members are represented as a
  // dictionary |member name|: |member value|. This method does not deal with
  // the dictionary name. The caller is responsible for not calling
  // |AsValueInto| when |value| expects array items (see Array/Dictionary
  // methods of |base::trace_event::TracedValue|).
  //
  // |value| The TracedValue to be written into.
  //
  // Example uses:
  //
  //   // |my_var1, my_var2| are variables with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   value->BeginDictionary("my_var1");
  //   my_var1.AsValueInto(value.get());
  //   value->EndDictionary();
  //   value->BeginDictionary("my_var2");
  //   my_var2.AsValueInto(value.get());
  //   value->EndDictionary();
  //
  //   // |my_var| is a variable with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   my_var.AsValueInto(value.get());
  //   TRACE_EVENT1("test", "test", "my_var", std::move(value));
  //
  // Calling |AsValueInto| on two objects without opening and closing a
  // dictionary for each object is theoretically possible, but strongly
  // discouraged due to potential name collisions:
  //
  //   struct A {
  //     int foo;
  //   };
  //   struct B {
  //     int bar;
  //   };
  //   struct C {
  //     int foo;
  //     int bar;
  //   };
  //   auto value1 = std::make_unique<base::trace_event::TracedValue>();
  //   auto value2 = std::make_unique<base::trace_event::TracedValue>();
  //   A a;
  //   B b;
  //   C c;
  //   // value1 and value2 will be filled with the same information:
  //   a.AsValueInto(value1);
  //   b.AsValueInto(value1);
  //   c.AsValueInto(value2);
  void AsValueInto(base::trace_event::TracedValue* value) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, MailboxBufferHandleSet::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, MailboxBufferHandleSet::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, MailboxBufferHandleSet::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, MailboxBufferHandleSet::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  SharedMemoryViaRawFileDescriptor {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<SharedMemoryViaRawFileDescriptor, T>::value>;
  using DataView = SharedMemoryViaRawFileDescriptorDataView;
  using Data_ = internal::SharedMemoryViaRawFileDescriptor_Data;

  template <typename... Args>
  static SharedMemoryViaRawFileDescriptorPtr New(Args&&... args) {
    return SharedMemoryViaRawFileDescriptorPtr(
        base::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static SharedMemoryViaRawFileDescriptorPtr From(const U& u) {
    return mojo::TypeConverter<SharedMemoryViaRawFileDescriptorPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, SharedMemoryViaRawFileDescriptor>::Convert(*this);
  }


  SharedMemoryViaRawFileDescriptor();

  SharedMemoryViaRawFileDescriptor(
      ::mojo::PlatformHandle file_descriptor_handle,
      uint32_t shared_memory_size_in_bytes);

  ~SharedMemoryViaRawFileDescriptor();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = SharedMemoryViaRawFileDescriptorPtr>
  SharedMemoryViaRawFileDescriptorPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, SharedMemoryViaRawFileDescriptor::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        SharedMemoryViaRawFileDescriptor::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        SharedMemoryViaRawFileDescriptor::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::SharedMemoryViaRawFileDescriptor_UnserializedMessageContext<
            UserType, SharedMemoryViaRawFileDescriptor::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    return mojo::internal::DeserializeImpl<SharedMemoryViaRawFileDescriptor::DataView>(
        data, data_num_bytes, std::vector<mojo::ScopedHandle>(), output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(const std::vector<uint8_t>& input,
                          UserType* output) {
    return SharedMemoryViaRawFileDescriptor::Deserialize(
        input.size() == 0 ? nullptr : &input.front(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::SharedMemoryViaRawFileDescriptor_UnserializedMessageContext<
            UserType, SharedMemoryViaRawFileDescriptor::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<SharedMemoryViaRawFileDescriptor::DataView>(
        input.payload(), input.payload_num_bytes(),
        std::move(*input.mutable_handles()), output, Validate);
  }

  
  ::mojo::PlatformHandle file_descriptor_handle;
  
  uint32_t shared_memory_size_in_bytes;

  // Write this structure into |value|. The members are represented as a
  // dictionary |member name|: |member value|. This method does not deal with
  // the dictionary name. The caller is responsible for not calling
  // |AsValueInto| when |value| expects array items (see Array/Dictionary
  // methods of |base::trace_event::TracedValue|).
  //
  // |value| The TracedValue to be written into.
  //
  // Example uses:
  //
  //   // |my_var1, my_var2| are variables with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   value->BeginDictionary("my_var1");
  //   my_var1.AsValueInto(value.get());
  //   value->EndDictionary();
  //   value->BeginDictionary("my_var2");
  //   my_var2.AsValueInto(value.get());
  //   value->EndDictionary();
  //
  //   // |my_var| is a variable with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   my_var.AsValueInto(value.get());
  //   TRACE_EVENT1("test", "test", "my_var", std::move(value));
  //
  // Calling |AsValueInto| on two objects without opening and closing a
  // dictionary for each object is theoretically possible, but strongly
  // discouraged due to potential name collisions:
  //
  //   struct A {
  //     int foo;
  //   };
  //   struct B {
  //     int bar;
  //   };
  //   struct C {
  //     int foo;
  //     int bar;
  //   };
  //   auto value1 = std::make_unique<base::trace_event::TracedValue>();
  //   auto value2 = std::make_unique<base::trace_event::TracedValue>();
  //   A a;
  //   B b;
  //   C c;
  //   // value1 and value2 will be filled with the same information:
  //   a.AsValueInto(value1);
  //   b.AsValueInto(value1);
  //   c.AsValueInto(value2);
  void AsValueInto(base::trace_event::TracedValue* value) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
  DISALLOW_COPY_AND_ASSIGN(SharedMemoryViaRawFileDescriptor);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, SharedMemoryViaRawFileDescriptor::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, SharedMemoryViaRawFileDescriptor::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, SharedMemoryViaRawFileDescriptor::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, SharedMemoryViaRawFileDescriptor::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename UnionPtrType>
VideoBufferHandlePtr VideoBufferHandle::Clone() const {
  // Use UnionPtrType to prevent the compiler from trying to compile this
  // without being asked.
  UnionPtrType rv(New());
  switch (tag_) {
    case Tag::SHARED_BUFFER_HANDLE:
      rv->set_shared_buffer_handle(mojo::Clone(*data_.shared_buffer_handle));
      break;
    case Tag::READ_ONLY_SHMEM_REGION:
      rv->set_read_only_shmem_region(mojo::Clone(*data_.read_only_shmem_region));
      break;
    case Tag::SHARED_MEMORY_VIA_RAW_FILE_DESCRIPTOR:
      rv->set_shared_memory_via_raw_file_descriptor(mojo::Clone(*data_.shared_memory_via_raw_file_descriptor));
      break;
    case Tag::MAILBOX_HANDLES:
      rv->set_mailbox_handles(mojo::Clone(*data_.mailbox_handles));
      break;
    case Tag::GPU_MEMORY_BUFFER_HANDLE:
      rv->set_gpu_memory_buffer_handle(mojo::Clone(*data_.gpu_memory_buffer_handle));
      break;
  }
  return rv;
}

template <typename T,
          typename std::enable_if<std::is_same<
              T, VideoBufferHandle>::value>::type*>
bool VideoBufferHandle::Equals(const T& other) const {
  if (tag_ != other.which())
    return false;

  switch (tag_) {
    case Tag::SHARED_BUFFER_HANDLE:
      return mojo::Equals(*(data_.shared_buffer_handle), *(other.data_.shared_buffer_handle));
    case Tag::READ_ONLY_SHMEM_REGION:
      return mojo::Equals(*(data_.read_only_shmem_region), *(other.data_.read_only_shmem_region));
    case Tag::SHARED_MEMORY_VIA_RAW_FILE_DESCRIPTOR:
      return mojo::Equals(*(data_.shared_memory_via_raw_file_descriptor), *(other.data_.shared_memory_via_raw_file_descriptor));
    case Tag::MAILBOX_HANDLES:
      return mojo::Equals(*(data_.mailbox_handles), *(other.data_.mailbox_handles));
    case Tag::GPU_MEMORY_BUFFER_HANDLE:
      return mojo::Equals(*(data_.gpu_memory_buffer_handle), *(other.data_.gpu_memory_buffer_handle));
  }

  return false;
}
template <typename StructPtrType>
VideoCaptureControlSupportPtr VideoCaptureControlSupport::Clone() const {
  return New(
      mojo::Clone(pan),
      mojo::Clone(tilt),
      mojo::Clone(zoom)
  );
}

template <typename T, VideoCaptureControlSupport::EnableIfSame<T>*>
bool VideoCaptureControlSupport::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->pan, other_struct.pan))
    return false;
  if (!mojo::Equals(this->tilt, other_struct.tilt))
    return false;
  if (!mojo::Equals(this->zoom, other_struct.zoom))
    return false;
  return true;
}

template <typename T, VideoCaptureControlSupport::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (std::less<>{}(lhs.pan, rhs.pan))
    return true;
  if (std::less<>{}(rhs.pan, lhs.pan))
    return false;
  if (std::less<>{}(lhs.tilt, rhs.tilt))
    return true;
  if (std::less<>{}(rhs.tilt, lhs.tilt))
    return false;
  if (std::less<>{}(lhs.zoom, rhs.zoom))
    return true;
  if (std::less<>{}(rhs.zoom, lhs.zoom))
    return false;
  return false;
}
template <typename StructPtrType>
VideoCaptureFormatPtr VideoCaptureFormat::Clone() const {
  return New(
      mojo::Clone(frame_size),
      mojo::Clone(frame_rate),
      mojo::Clone(pixel_format)
  );
}

template <typename T, VideoCaptureFormat::EnableIfSame<T>*>
bool VideoCaptureFormat::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->frame_size, other_struct.frame_size))
    return false;
  if (!mojo::Equals(this->frame_rate, other_struct.frame_rate))
    return false;
  if (!mojo::Equals(this->pixel_format, other_struct.pixel_format))
    return false;
  return true;
}

template <typename T, VideoCaptureFormat::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (std::less<>{}(lhs.frame_size, rhs.frame_size))
    return true;
  if (std::less<>{}(rhs.frame_size, lhs.frame_size))
    return false;
  if (std::less<>{}(lhs.frame_rate, rhs.frame_rate))
    return true;
  if (std::less<>{}(rhs.frame_rate, lhs.frame_rate))
    return false;
  if (std::less<>{}(lhs.pixel_format, rhs.pixel_format))
    return true;
  if (std::less<>{}(rhs.pixel_format, lhs.pixel_format))
    return false;
  return false;
}
template <typename StructPtrType>
VideoCaptureParamsPtr VideoCaptureParams::Clone() const {
  return New(
      mojo::Clone(requested_format),
      mojo::Clone(buffer_type),
      mojo::Clone(resolution_change_policy),
      mojo::Clone(power_line_frequency),
      mojo::Clone(enable_face_detection)
  );
}

template <typename T, VideoCaptureParams::EnableIfSame<T>*>
bool VideoCaptureParams::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->requested_format, other_struct.requested_format))
    return false;
  if (!mojo::Equals(this->buffer_type, other_struct.buffer_type))
    return false;
  if (!mojo::Equals(this->resolution_change_policy, other_struct.resolution_change_policy))
    return false;
  if (!mojo::Equals(this->power_line_frequency, other_struct.power_line_frequency))
    return false;
  if (!mojo::Equals(this->enable_face_detection, other_struct.enable_face_detection))
    return false;
  return true;
}

template <typename T, VideoCaptureParams::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (std::less<>{}(lhs.requested_format, rhs.requested_format))
    return true;
  if (std::less<>{}(rhs.requested_format, lhs.requested_format))
    return false;
  if (std::less<>{}(lhs.buffer_type, rhs.buffer_type))
    return true;
  if (std::less<>{}(rhs.buffer_type, lhs.buffer_type))
    return false;
  if (std::less<>{}(lhs.resolution_change_policy, rhs.resolution_change_policy))
    return true;
  if (std::less<>{}(rhs.resolution_change_policy, lhs.resolution_change_policy))
    return false;
  if (std::less<>{}(lhs.power_line_frequency, rhs.power_line_frequency))
    return true;
  if (std::less<>{}(rhs.power_line_frequency, lhs.power_line_frequency))
    return false;
  if (std::less<>{}(lhs.enable_face_detection, rhs.enable_face_detection))
    return true;
  if (std::less<>{}(rhs.enable_face_detection, lhs.enable_face_detection))
    return false;
  return false;
}
template <typename StructPtrType>
VideoFrameFeedbackPtr VideoFrameFeedback::Clone() const {
  return New(
      mojo::Clone(resource_utilization),
      mojo::Clone(max_framerate_fps),
      mojo::Clone(max_pixels)
  );
}

template <typename T, VideoFrameFeedback::EnableIfSame<T>*>
bool VideoFrameFeedback::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->resource_utilization, other_struct.resource_utilization))
    return false;
  if (!mojo::Equals(this->max_framerate_fps, other_struct.max_framerate_fps))
    return false;
  if (!mojo::Equals(this->max_pixels, other_struct.max_pixels))
    return false;
  return true;
}

template <typename T, VideoFrameFeedback::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (std::less<>{}(lhs.resource_utilization, rhs.resource_utilization))
    return true;
  if (std::less<>{}(rhs.resource_utilization, lhs.resource_utilization))
    return false;
  if (std::less<>{}(lhs.max_framerate_fps, rhs.max_framerate_fps))
    return true;
  if (std::less<>{}(rhs.max_framerate_fps, lhs.max_framerate_fps))
    return false;
  if (std::less<>{}(lhs.max_pixels, rhs.max_pixels))
    return true;
  if (std::less<>{}(rhs.max_pixels, lhs.max_pixels))
    return false;
  return false;
}
template <typename StructPtrType>
PlaneStridesPtr PlaneStrides::Clone() const {
  return New(
      mojo::Clone(stride_by_plane)
  );
}

template <typename T, PlaneStrides::EnableIfSame<T>*>
bool PlaneStrides::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->stride_by_plane, other_struct.stride_by_plane))
    return false;
  return true;
}

template <typename T, PlaneStrides::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (std::less<>{}(lhs.stride_by_plane, rhs.stride_by_plane))
    return true;
  if (std::less<>{}(rhs.stride_by_plane, lhs.stride_by_plane))
    return false;
  return false;
}
template <typename StructPtrType>
VideoFrameInfoPtr VideoFrameInfo::Clone() const {
  return New(
      mojo::Clone(timestamp),
      mojo::Clone(metadata),
      mojo::Clone(pixel_format),
      mojo::Clone(coded_size),
      mojo::Clone(visible_rect),
      mojo::Clone(color_space),
      mojo::Clone(strides)
  );
}

template <typename T, VideoFrameInfo::EnableIfSame<T>*>
bool VideoFrameInfo::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->timestamp, other_struct.timestamp))
    return false;
  if (!mojo::Equals(this->metadata, other_struct.metadata))
    return false;
  if (!mojo::Equals(this->pixel_format, other_struct.pixel_format))
    return false;
  if (!mojo::Equals(this->coded_size, other_struct.coded_size))
    return false;
  if (!mojo::Equals(this->visible_rect, other_struct.visible_rect))
    return false;
  if (!mojo::Equals(this->color_space, other_struct.color_space))
    return false;
  if (!mojo::Equals(this->strides, other_struct.strides))
    return false;
  return true;
}

template <typename T, VideoFrameInfo::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (std::less<>{}(lhs.timestamp, rhs.timestamp))
    return true;
  if (std::less<>{}(rhs.timestamp, lhs.timestamp))
    return false;
  if (std::less<>{}(lhs.metadata, rhs.metadata))
    return true;
  if (std::less<>{}(rhs.metadata, lhs.metadata))
    return false;
  if (std::less<>{}(lhs.pixel_format, rhs.pixel_format))
    return true;
  if (std::less<>{}(rhs.pixel_format, lhs.pixel_format))
    return false;
  if (std::less<>{}(lhs.coded_size, rhs.coded_size))
    return true;
  if (std::less<>{}(rhs.coded_size, lhs.coded_size))
    return false;
  if (std::less<>{}(lhs.visible_rect, rhs.visible_rect))
    return true;
  if (std::less<>{}(rhs.visible_rect, lhs.visible_rect))
    return false;
  if (std::less<>{}(lhs.color_space, rhs.color_space))
    return true;
  if (std::less<>{}(rhs.color_space, lhs.color_space))
    return false;
  if (std::less<>{}(lhs.strides, rhs.strides))
    return true;
  if (std::less<>{}(rhs.strides, lhs.strides))
    return false;
  return false;
}
template <typename StructPtrType>
VideoCaptureDeviceDescriptorPtr VideoCaptureDeviceDescriptor::Clone() const {
  return New(
      mojo::Clone(display_name),
      mojo::Clone(device_id),
      mojo::Clone(model_id),
      mojo::Clone(facing_mode),
      mojo::Clone(capture_api),
      mojo::Clone(control_support),
      mojo::Clone(transport_type)
  );
}

template <typename T, VideoCaptureDeviceDescriptor::EnableIfSame<T>*>
bool VideoCaptureDeviceDescriptor::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->display_name, other_struct.display_name))
    return false;
  if (!mojo::Equals(this->device_id, other_struct.device_id))
    return false;
  if (!mojo::Equals(this->model_id, other_struct.model_id))
    return false;
  if (!mojo::Equals(this->facing_mode, other_struct.facing_mode))
    return false;
  if (!mojo::Equals(this->capture_api, other_struct.capture_api))
    return false;
  if (!mojo::Equals(this->control_support, other_struct.control_support))
    return false;
  if (!mojo::Equals(this->transport_type, other_struct.transport_type))
    return false;
  return true;
}

template <typename T, VideoCaptureDeviceDescriptor::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (std::less<>{}(lhs.display_name, rhs.display_name))
    return true;
  if (std::less<>{}(rhs.display_name, lhs.display_name))
    return false;
  if (std::less<>{}(lhs.device_id, rhs.device_id))
    return true;
  if (std::less<>{}(rhs.device_id, lhs.device_id))
    return false;
  if (std::less<>{}(lhs.model_id, rhs.model_id))
    return true;
  if (std::less<>{}(rhs.model_id, lhs.model_id))
    return false;
  if (std::less<>{}(lhs.facing_mode, rhs.facing_mode))
    return true;
  if (std::less<>{}(rhs.facing_mode, lhs.facing_mode))
    return false;
  if (std::less<>{}(lhs.capture_api, rhs.capture_api))
    return true;
  if (std::less<>{}(rhs.capture_api, lhs.capture_api))
    return false;
  if (std::less<>{}(lhs.control_support, rhs.control_support))
    return true;
  if (std::less<>{}(rhs.control_support, lhs.control_support))
    return false;
  if (std::less<>{}(lhs.transport_type, rhs.transport_type))
    return true;
  if (std::less<>{}(rhs.transport_type, lhs.transport_type))
    return false;
  return false;
}
template <typename StructPtrType>
VideoCaptureDeviceInfoPtr VideoCaptureDeviceInfo::Clone() const {
  return New(
      mojo::Clone(descriptor),
      mojo::Clone(supported_formats)
  );
}

template <typename T, VideoCaptureDeviceInfo::EnableIfSame<T>*>
bool VideoCaptureDeviceInfo::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->descriptor, other_struct.descriptor))
    return false;
  if (!mojo::Equals(this->supported_formats, other_struct.supported_formats))
    return false;
  return true;
}

template <typename T, VideoCaptureDeviceInfo::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (std::less<>{}(lhs.descriptor, rhs.descriptor))
    return true;
  if (std::less<>{}(rhs.descriptor, lhs.descriptor))
    return false;
  if (std::less<>{}(lhs.supported_formats, rhs.supported_formats))
    return true;
  if (std::less<>{}(rhs.supported_formats, lhs.supported_formats))
    return false;
  return false;
}
template <typename StructPtrType>
MailboxBufferHandleSetPtr MailboxBufferHandleSet::Clone() const {
  return New(
      mojo::Clone(mailbox_holder)
  );
}

template <typename T, MailboxBufferHandleSet::EnableIfSame<T>*>
bool MailboxBufferHandleSet::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->mailbox_holder, other_struct.mailbox_holder))
    return false;
  return true;
}

template <typename T, MailboxBufferHandleSet::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (std::less<>{}(lhs.mailbox_holder, rhs.mailbox_holder))
    return true;
  if (std::less<>{}(rhs.mailbox_holder, lhs.mailbox_holder))
    return false;
  return false;
}
template <typename StructPtrType>
SharedMemoryViaRawFileDescriptorPtr SharedMemoryViaRawFileDescriptor::Clone() const {
  return New(
      mojo::Clone(file_descriptor_handle),
      mojo::Clone(shared_memory_size_in_bytes)
  );
}

template <typename T, SharedMemoryViaRawFileDescriptor::EnableIfSame<T>*>
bool SharedMemoryViaRawFileDescriptor::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->file_descriptor_handle, other_struct.file_descriptor_handle))
    return false;
  if (!mojo::Equals(this->shared_memory_size_in_bytes, other_struct.shared_memory_size_in_bytes))
    return false;
  return true;
}

template <typename T, SharedMemoryViaRawFileDescriptor::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (std::less<>{}(lhs.file_descriptor_handle, rhs.file_descriptor_handle))
    return true;
  if (std::less<>{}(rhs.file_descriptor_handle, lhs.file_descriptor_handle))
    return false;
  if (std::less<>{}(lhs.shared_memory_size_in_bytes, rhs.shared_memory_size_in_bytes))
    return true;
  if (std::less<>{}(rhs.shared_memory_size_in_bytes, lhs.shared_memory_size_in_bytes))
    return false;
  return false;
}


}  // namespace mojom
}  // namespace media

namespace mojo {


template <>
struct  StructTraits<::media::mojom::VideoCaptureControlSupport::DataView,
                                         ::media::mojom::VideoCaptureControlSupportPtr> {
  static bool IsNull(const ::media::mojom::VideoCaptureControlSupportPtr& input) { return !input; }
  static void SetToNull(::media::mojom::VideoCaptureControlSupportPtr* output) { output->reset(); }

  static decltype(::media::mojom::VideoCaptureControlSupport::pan) pan(
      const ::media::mojom::VideoCaptureControlSupportPtr& input) {
    return input->pan;
  }

  static decltype(::media::mojom::VideoCaptureControlSupport::tilt) tilt(
      const ::media::mojom::VideoCaptureControlSupportPtr& input) {
    return input->tilt;
  }

  static decltype(::media::mojom::VideoCaptureControlSupport::zoom) zoom(
      const ::media::mojom::VideoCaptureControlSupportPtr& input) {
    return input->zoom;
  }

  static bool Read(::media::mojom::VideoCaptureControlSupport::DataView input, ::media::mojom::VideoCaptureControlSupportPtr* output);
};


template <>
struct  StructTraits<::media::mojom::VideoCaptureFormat::DataView,
                                         ::media::mojom::VideoCaptureFormatPtr> {
  static bool IsNull(const ::media::mojom::VideoCaptureFormatPtr& input) { return !input; }
  static void SetToNull(::media::mojom::VideoCaptureFormatPtr* output) { output->reset(); }

  static const decltype(::media::mojom::VideoCaptureFormat::frame_size)& frame_size(
      const ::media::mojom::VideoCaptureFormatPtr& input) {
    return input->frame_size;
  }

  static decltype(::media::mojom::VideoCaptureFormat::frame_rate) frame_rate(
      const ::media::mojom::VideoCaptureFormatPtr& input) {
    return input->frame_rate;
  }

  static decltype(::media::mojom::VideoCaptureFormat::pixel_format) pixel_format(
      const ::media::mojom::VideoCaptureFormatPtr& input) {
    return input->pixel_format;
  }

  static bool Read(::media::mojom::VideoCaptureFormat::DataView input, ::media::mojom::VideoCaptureFormatPtr* output);
};


template <>
struct  StructTraits<::media::mojom::VideoCaptureParams::DataView,
                                         ::media::mojom::VideoCaptureParamsPtr> {
  static bool IsNull(const ::media::mojom::VideoCaptureParamsPtr& input) { return !input; }
  static void SetToNull(::media::mojom::VideoCaptureParamsPtr* output) { output->reset(); }

  static const decltype(::media::mojom::VideoCaptureParams::requested_format)& requested_format(
      const ::media::mojom::VideoCaptureParamsPtr& input) {
    return input->requested_format;
  }

  static decltype(::media::mojom::VideoCaptureParams::buffer_type) buffer_type(
      const ::media::mojom::VideoCaptureParamsPtr& input) {
    return input->buffer_type;
  }

  static decltype(::media::mojom::VideoCaptureParams::resolution_change_policy) resolution_change_policy(
      const ::media::mojom::VideoCaptureParamsPtr& input) {
    return input->resolution_change_policy;
  }

  static decltype(::media::mojom::VideoCaptureParams::power_line_frequency) power_line_frequency(
      const ::media::mojom::VideoCaptureParamsPtr& input) {
    return input->power_line_frequency;
  }

  static decltype(::media::mojom::VideoCaptureParams::enable_face_detection) enable_face_detection(
      const ::media::mojom::VideoCaptureParamsPtr& input) {
    return input->enable_face_detection;
  }

  static bool Read(::media::mojom::VideoCaptureParams::DataView input, ::media::mojom::VideoCaptureParamsPtr* output);
};


template <>
struct  StructTraits<::media::mojom::VideoFrameFeedback::DataView,
                                         ::media::mojom::VideoFrameFeedbackPtr> {
  static bool IsNull(const ::media::mojom::VideoFrameFeedbackPtr& input) { return !input; }
  static void SetToNull(::media::mojom::VideoFrameFeedbackPtr* output) { output->reset(); }

  static decltype(::media::mojom::VideoFrameFeedback::resource_utilization) resource_utilization(
      const ::media::mojom::VideoFrameFeedbackPtr& input) {
    return input->resource_utilization;
  }

  static decltype(::media::mojom::VideoFrameFeedback::max_framerate_fps) max_framerate_fps(
      const ::media::mojom::VideoFrameFeedbackPtr& input) {
    return input->max_framerate_fps;
  }

  static decltype(::media::mojom::VideoFrameFeedback::max_pixels) max_pixels(
      const ::media::mojom::VideoFrameFeedbackPtr& input) {
    return input->max_pixels;
  }

  static bool Read(::media::mojom::VideoFrameFeedback::DataView input, ::media::mojom::VideoFrameFeedbackPtr* output);
};


template <>
struct  StructTraits<::media::mojom::PlaneStrides::DataView,
                                         ::media::mojom::PlaneStridesPtr> {
  static bool IsNull(const ::media::mojom::PlaneStridesPtr& input) { return !input; }
  static void SetToNull(::media::mojom::PlaneStridesPtr* output) { output->reset(); }

  static const decltype(::media::mojom::PlaneStrides::stride_by_plane)& stride_by_plane(
      const ::media::mojom::PlaneStridesPtr& input) {
    return input->stride_by_plane;
  }

  static bool Read(::media::mojom::PlaneStrides::DataView input, ::media::mojom::PlaneStridesPtr* output);
};


template <>
struct  StructTraits<::media::mojom::VideoFrameInfo::DataView,
                                         ::media::mojom::VideoFrameInfoPtr> {
  static bool IsNull(const ::media::mojom::VideoFrameInfoPtr& input) { return !input; }
  static void SetToNull(::media::mojom::VideoFrameInfoPtr* output) { output->reset(); }

  static const decltype(::media::mojom::VideoFrameInfo::timestamp)& timestamp(
      const ::media::mojom::VideoFrameInfoPtr& input) {
    return input->timestamp;
  }

  static const decltype(::media::mojom::VideoFrameInfo::metadata)& metadata(
      const ::media::mojom::VideoFrameInfoPtr& input) {
    return input->metadata;
  }

  static decltype(::media::mojom::VideoFrameInfo::pixel_format) pixel_format(
      const ::media::mojom::VideoFrameInfoPtr& input) {
    return input->pixel_format;
  }

  static const decltype(::media::mojom::VideoFrameInfo::coded_size)& coded_size(
      const ::media::mojom::VideoFrameInfoPtr& input) {
    return input->coded_size;
  }

  static const decltype(::media::mojom::VideoFrameInfo::visible_rect)& visible_rect(
      const ::media::mojom::VideoFrameInfoPtr& input) {
    return input->visible_rect;
  }

  static const decltype(::media::mojom::VideoFrameInfo::color_space)& color_space(
      const ::media::mojom::VideoFrameInfoPtr& input) {
    return input->color_space;
  }

  static const decltype(::media::mojom::VideoFrameInfo::strides)& strides(
      const ::media::mojom::VideoFrameInfoPtr& input) {
    return input->strides;
  }

  static bool Read(::media::mojom::VideoFrameInfo::DataView input, ::media::mojom::VideoFrameInfoPtr* output);
};


template <>
struct  StructTraits<::media::mojom::VideoCaptureDeviceDescriptor::DataView,
                                         ::media::mojom::VideoCaptureDeviceDescriptorPtr> {
  static bool IsNull(const ::media::mojom::VideoCaptureDeviceDescriptorPtr& input) { return !input; }
  static void SetToNull(::media::mojom::VideoCaptureDeviceDescriptorPtr* output) { output->reset(); }

  static const decltype(::media::mojom::VideoCaptureDeviceDescriptor::display_name)& display_name(
      const ::media::mojom::VideoCaptureDeviceDescriptorPtr& input) {
    return input->display_name;
  }

  static const decltype(::media::mojom::VideoCaptureDeviceDescriptor::device_id)& device_id(
      const ::media::mojom::VideoCaptureDeviceDescriptorPtr& input) {
    return input->device_id;
  }

  static const decltype(::media::mojom::VideoCaptureDeviceDescriptor::model_id)& model_id(
      const ::media::mojom::VideoCaptureDeviceDescriptorPtr& input) {
    return input->model_id;
  }

  static decltype(::media::mojom::VideoCaptureDeviceDescriptor::facing_mode) facing_mode(
      const ::media::mojom::VideoCaptureDeviceDescriptorPtr& input) {
    return input->facing_mode;
  }

  static decltype(::media::mojom::VideoCaptureDeviceDescriptor::capture_api) capture_api(
      const ::media::mojom::VideoCaptureDeviceDescriptorPtr& input) {
    return input->capture_api;
  }

  static const decltype(::media::mojom::VideoCaptureDeviceDescriptor::control_support)& control_support(
      const ::media::mojom::VideoCaptureDeviceDescriptorPtr& input) {
    return input->control_support;
  }

  static decltype(::media::mojom::VideoCaptureDeviceDescriptor::transport_type) transport_type(
      const ::media::mojom::VideoCaptureDeviceDescriptorPtr& input) {
    return input->transport_type;
  }

  static bool Read(::media::mojom::VideoCaptureDeviceDescriptor::DataView input, ::media::mojom::VideoCaptureDeviceDescriptorPtr* output);
};


template <>
struct  StructTraits<::media::mojom::VideoCaptureDeviceInfo::DataView,
                                         ::media::mojom::VideoCaptureDeviceInfoPtr> {
  static bool IsNull(const ::media::mojom::VideoCaptureDeviceInfoPtr& input) { return !input; }
  static void SetToNull(::media::mojom::VideoCaptureDeviceInfoPtr* output) { output->reset(); }

  static const decltype(::media::mojom::VideoCaptureDeviceInfo::descriptor)& descriptor(
      const ::media::mojom::VideoCaptureDeviceInfoPtr& input) {
    return input->descriptor;
  }

  static const decltype(::media::mojom::VideoCaptureDeviceInfo::supported_formats)& supported_formats(
      const ::media::mojom::VideoCaptureDeviceInfoPtr& input) {
    return input->supported_formats;
  }

  static bool Read(::media::mojom::VideoCaptureDeviceInfo::DataView input, ::media::mojom::VideoCaptureDeviceInfoPtr* output);
};


template <>
struct  StructTraits<::media::mojom::MailboxBufferHandleSet::DataView,
                                         ::media::mojom::MailboxBufferHandleSetPtr> {
  static bool IsNull(const ::media::mojom::MailboxBufferHandleSetPtr& input) { return !input; }
  static void SetToNull(::media::mojom::MailboxBufferHandleSetPtr* output) { output->reset(); }

  static const decltype(::media::mojom::MailboxBufferHandleSet::mailbox_holder)& mailbox_holder(
      const ::media::mojom::MailboxBufferHandleSetPtr& input) {
    return input->mailbox_holder;
  }

  static bool Read(::media::mojom::MailboxBufferHandleSet::DataView input, ::media::mojom::MailboxBufferHandleSetPtr* output);
};


template <>
struct  StructTraits<::media::mojom::SharedMemoryViaRawFileDescriptor::DataView,
                                         ::media::mojom::SharedMemoryViaRawFileDescriptorPtr> {
  static bool IsNull(const ::media::mojom::SharedMemoryViaRawFileDescriptorPtr& input) { return !input; }
  static void SetToNull(::media::mojom::SharedMemoryViaRawFileDescriptorPtr* output) { output->reset(); }

  static  decltype(::media::mojom::SharedMemoryViaRawFileDescriptor::file_descriptor_handle)& file_descriptor_handle(
       ::media::mojom::SharedMemoryViaRawFileDescriptorPtr& input) {
    return input->file_descriptor_handle;
  }

  static decltype(::media::mojom::SharedMemoryViaRawFileDescriptor::shared_memory_size_in_bytes) shared_memory_size_in_bytes(
      const ::media::mojom::SharedMemoryViaRawFileDescriptorPtr& input) {
    return input->shared_memory_size_in_bytes;
  }

  static bool Read(::media::mojom::SharedMemoryViaRawFileDescriptor::DataView input, ::media::mojom::SharedMemoryViaRawFileDescriptorPtr* output);
};


template <>
struct  UnionTraits<::media::mojom::VideoBufferHandle::DataView,
                                        ::media::mojom::VideoBufferHandlePtr> {
  static bool IsNull(const ::media::mojom::VideoBufferHandlePtr& input) { return !input; }
  static void SetToNull(::media::mojom::VideoBufferHandlePtr* output) { output->reset(); }

  static ::media::mojom::VideoBufferHandle::Tag GetTag(const ::media::mojom::VideoBufferHandlePtr& input) {
    return input->which();
  }

  static  ::mojo::ScopedSharedBufferHandle& shared_buffer_handle( ::media::mojom::VideoBufferHandlePtr& input) {
    return input->get_shared_buffer_handle();
  }

  static  ::base::ReadOnlySharedMemoryRegion& read_only_shmem_region( ::media::mojom::VideoBufferHandlePtr& input) {
    return input->get_read_only_shmem_region();
  }

  static  ::media::mojom::SharedMemoryViaRawFileDescriptorPtr& shared_memory_via_raw_file_descriptor( ::media::mojom::VideoBufferHandlePtr& input) {
    return input->get_shared_memory_via_raw_file_descriptor();
  }

  static const ::media::mojom::MailboxBufferHandleSetPtr& mailbox_handles(const ::media::mojom::VideoBufferHandlePtr& input) {
    return input->get_mailbox_handles();
  }

  static  ::gfx::GpuMemoryBufferHandle& gpu_memory_buffer_handle( ::media::mojom::VideoBufferHandlePtr& input) {
    return input->get_gpu_memory_buffer_handle();
  }

  static bool Read(::media::mojom::VideoBufferHandle::DataView input, ::media::mojom::VideoBufferHandlePtr* output);
};

}  // namespace mojo

#endif  // MEDIA_CAPTURE_MOJOM_VIDEO_CAPTURE_TYPES_MOJOM_H_