// components/services/storage/public/mojom/native_file_system_context.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef COMPONENTS_SERVICES_STORAGE_PUBLIC_MOJOM_NATIVE_FILE_SYSTEM_CONTEXT_MOJOM_H_
#define COMPONENTS_SERVICES_STORAGE_PUBLIC_MOJOM_NATIVE_FILE_SYSTEM_CONTEXT_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <type_traits>
#include <utility>

#include "base/callback.h"
#include "base/macros.h"
#include "base/optional.h"

#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#if BUILDFLAG(MOJO_TRACE_ENABLED)
#include "base/trace_event/trace_event.h"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"
#include "components/services/storage/public/mojom/native_file_system_context.mojom-shared.h"
#include "components/services/storage/public/mojom/native_file_system_context.mojom-forward.h"
#include "third_party/blink/public/mojom/file_system_access/native_file_system_transfer_token.mojom.h"
#include "url/mojom/origin.mojom.h"
#include <string>
#include <vector>

#include "mojo/public/cpp/bindings/associated_interface_ptr.h"
#include "mojo/public/cpp/bindings/associated_interface_ptr_info.h"
#include "mojo/public/cpp/bindings/associated_interface_request.h"
#include "mojo/public/cpp/bindings/interface_ptr.h"
#include "mojo/public/cpp/bindings/interface_request.h"
#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"
#include "mojo/public/cpp/bindings/thread_safe_interface_ptr.h"





// Forward-declare for |AsValueInto| so that we do not have to import the
// corresponding header.
namespace base {
namespace trace_event {
class TracedValue;
}  // namespace trace_event
}  // namespace base


namespace storage {
namespace mojom {

class NativeFileSystemContextProxy;

template <typename ImplRefTraits>
class NativeFileSystemContextStub;

class NativeFileSystemContextRequestValidator;
class NativeFileSystemContextResponseValidator;


class  NativeFileSystemContext
    : public NativeFileSystemContextInterfaceBase {
 public:
  static const char Name_[];
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasSyncMethods_ = false;

  using Base_ = NativeFileSystemContextInterfaceBase;
  using Proxy_ = NativeFileSystemContextProxy;

  template <typename ImplRefTraits>
  using Stub_ = NativeFileSystemContextStub<ImplRefTraits>;

  using RequestValidator_ = NativeFileSystemContextRequestValidator;
  using ResponseValidator_ = NativeFileSystemContextResponseValidator;
  enum MethodMinVersions : uint32_t {
    kSerializeHandleMinVersion = 0,
    kDeserializeHandleMinVersion = 0,
  };
  virtual ~NativeFileSystemContext() {}


  using SerializeHandleCallback = base::OnceCallback<void(const std::vector<uint8_t>&)>;
  
  virtual void SerializeHandle(::mojo::PendingRemote<::blink::mojom::NativeFileSystemTransferToken> token, SerializeHandleCallback callback) = 0;

  
  virtual void DeserializeHandle(const ::url::Origin& origin, const std::vector<uint8_t>& bits, ::mojo::PendingReceiver<::blink::mojom::NativeFileSystemTransferToken> token) = 0;
};



class  NativeFileSystemContextProxy
    : public NativeFileSystemContext {
 public:
  using InterfaceType = NativeFileSystemContext;

  explicit NativeFileSystemContextProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void SerializeHandle(::mojo::PendingRemote<::blink::mojom::NativeFileSystemTransferToken> token, SerializeHandleCallback callback) final;
  
  void DeserializeHandle(const ::url::Origin& origin, const std::vector<uint8_t>& bits, ::mojo::PendingReceiver<::blink::mojom::NativeFileSystemTransferToken> token) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class  NativeFileSystemContextStubDispatch {
 public:
  static bool Accept(NativeFileSystemContext* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      NativeFileSystemContext* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<NativeFileSystemContext>>
class NativeFileSystemContextStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  NativeFileSystemContextStub() {}
  ~NativeFileSystemContextStub() override {}

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return NativeFileSystemContextStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return NativeFileSystemContextStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  NativeFileSystemContextRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  NativeFileSystemContextResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};





}  // namespace mojom
}  // namespace storage

namespace mojo {

}  // namespace mojo

#endif  // COMPONENTS_SERVICES_STORAGE_PUBLIC_MOJOM_NATIVE_FILE_SYSTEM_CONTEXT_MOJOM_H_