// components/printing/common/print.mojom-shared-internal.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef COMPONENTS_PRINTING_COMMON_PRINT_MOJOM_SHARED_INTERNAL_H_
#define COMPONENTS_PRINTING_COMMON_PRINT_MOJOM_SHARED_INTERNAL_H_

#include "mojo/public/cpp/bindings/lib/array_internal.h"
#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/map_data_internal.h"
#include "mojo/public/cpp/bindings/lib/buffer.h"
#include "mojo/public/mojom/base/shared_memory.mojom-shared-internal.h"
#include "mojo/public/mojom/base/string16.mojom-shared-internal.h"
#include "mojo/public/mojom/base/values.mojom-shared-internal.h"
#include "mojo/public/mojom/base/unguessable_token.mojom-shared-internal.h"
#include "printing/mojom/print.mojom-shared-internal.h"
#include "ui/gfx/geometry/mojom/geometry.mojom-shared-internal.h"
#include "ui/accessibility/mojom/ax_tree_update.mojom-shared-internal.h"
#include "mojo/public/cpp/bindings/lib/native_enum_data.h"
#include "mojo/public/interfaces/bindings/native_struct.mojom-shared-internal.h"



namespace mojo {
namespace internal {
class ValidationContext;
}
}
namespace printing {
namespace mojom {
namespace internal {
class PreviewIds_Data;
class PrintFrameContentParams_Data;
class OptionsFromDocumentParams_Data;
class DidPrintContentParams_Data;
class DidStartPreviewParams_Data;
class DidPreviewPageParams_Data;
class DidPreviewDocumentParams_Data;
class PrintParams_Data;
class PrintPagesParams_Data;
class DidPrintDocumentParams_Data;
class ScriptedPrintParams_Data;

#pragma pack(push, 1)
class  PreviewIds_Data {
 public:
  class BufferWriter {
   public:
    BufferWriter() = default;

    void Allocate(mojo::internal::Buffer* serialization_buffer) {
      serialization_buffer_ = serialization_buffer;
      index_ = serialization_buffer_->Allocate(sizeof(PreviewIds_Data));
      new (data()) PreviewIds_Data();
    }

    bool is_null() const { return !serialization_buffer_; }
    PreviewIds_Data* data() {
      DCHECK(!is_null());
      return serialization_buffer_->Get<PreviewIds_Data>(index_);
    }
    PreviewIds_Data* operator->() { return data(); }

   private:
    mojo::internal::Buffer* serialization_buffer_ = nullptr;
    size_t index_ = 0;

    DISALLOW_COPY_AND_ASSIGN(BufferWriter);
  };

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  int32_t request_id;
  int32_t ui_id;

 private:
  PreviewIds_Data();
  ~PreviewIds_Data() = delete;
};
static_assert(sizeof(PreviewIds_Data) == 16,
              "Bad sizeof(PreviewIds_Data)");
// Used by PreviewIds::WrapAsMessage to lazily serialize the struct.
template <typename UserType, typename DataView>
struct PreviewIds_UnserializedMessageContext
    : public mojo::internal::UnserializedMessageContext {
 public:
  static const mojo::internal::UnserializedMessageContext::Tag kMessageTag;

  PreviewIds_UnserializedMessageContext(
    uint32_t message_name,
    uint32_t message_flags,
    UserType input)
      : mojo::internal::UnserializedMessageContext(&kMessageTag, message_name, message_flags)
      , user_data_(std::move(input)) {}
  ~PreviewIds_UnserializedMessageContext() override = default;

  UserType TakeData() {
    return std::move(user_data_);
  }

 private:
  // mojo::internal::UnserializedMessageContext:
  void Serialize(mojo::internal::SerializationContext* context,
                 mojo::internal::Buffer* buffer) override {
    PreviewIds_Data::BufferWriter writer;
    mojo::internal::Serialize<DataView>(user_data_, buffer, &writer, context);
  }

  UserType user_data_;
};

template <typename UserType, typename DataView>
const mojo::internal::UnserializedMessageContext::Tag
    PreviewIds_UnserializedMessageContext<UserType, DataView>::kMessageTag = {};
class  PrintFrameContentParams_Data {
 public:
  class BufferWriter {
   public:
    BufferWriter() = default;

    void Allocate(mojo::internal::Buffer* serialization_buffer) {
      serialization_buffer_ = serialization_buffer;
      index_ = serialization_buffer_->Allocate(sizeof(PrintFrameContentParams_Data));
      new (data()) PrintFrameContentParams_Data();
    }

    bool is_null() const { return !serialization_buffer_; }
    PrintFrameContentParams_Data* data() {
      DCHECK(!is_null());
      return serialization_buffer_->Get<PrintFrameContentParams_Data>(index_);
    }
    PrintFrameContentParams_Data* operator->() { return data(); }

   private:
    mojo::internal::Buffer* serialization_buffer_ = nullptr;
    size_t index_ = 0;

    DISALLOW_COPY_AND_ASSIGN(BufferWriter);
  };

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<::gfx::mojom::internal::Rect_Data> printable_area;
  int32_t document_cookie;
  uint8_t padfinal_[4];

 private:
  PrintFrameContentParams_Data();
  ~PrintFrameContentParams_Data() = delete;
};
static_assert(sizeof(PrintFrameContentParams_Data) == 24,
              "Bad sizeof(PrintFrameContentParams_Data)");
// Used by PrintFrameContentParams::WrapAsMessage to lazily serialize the struct.
template <typename UserType, typename DataView>
struct PrintFrameContentParams_UnserializedMessageContext
    : public mojo::internal::UnserializedMessageContext {
 public:
  static const mojo::internal::UnserializedMessageContext::Tag kMessageTag;

  PrintFrameContentParams_UnserializedMessageContext(
    uint32_t message_name,
    uint32_t message_flags,
    UserType input)
      : mojo::internal::UnserializedMessageContext(&kMessageTag, message_name, message_flags)
      , user_data_(std::move(input)) {}
  ~PrintFrameContentParams_UnserializedMessageContext() override = default;

  UserType TakeData() {
    return std::move(user_data_);
  }

 private:
  // mojo::internal::UnserializedMessageContext:
  void Serialize(mojo::internal::SerializationContext* context,
                 mojo::internal::Buffer* buffer) override {
    PrintFrameContentParams_Data::BufferWriter writer;
    mojo::internal::Serialize<DataView>(user_data_, buffer, &writer, context);
  }

  UserType user_data_;
};

template <typename UserType, typename DataView>
const mojo::internal::UnserializedMessageContext::Tag
    PrintFrameContentParams_UnserializedMessageContext<UserType, DataView>::kMessageTag = {};
class  OptionsFromDocumentParams_Data {
 public:
  class BufferWriter {
   public:
    BufferWriter() = default;

    void Allocate(mojo::internal::Buffer* serialization_buffer) {
      serialization_buffer_ = serialization_buffer;
      index_ = serialization_buffer_->Allocate(sizeof(OptionsFromDocumentParams_Data));
      new (data()) OptionsFromDocumentParams_Data();
    }

    bool is_null() const { return !serialization_buffer_; }
    OptionsFromDocumentParams_Data* data() {
      DCHECK(!is_null());
      return serialization_buffer_->Get<OptionsFromDocumentParams_Data>(index_);
    }
    OptionsFromDocumentParams_Data* operator->() { return data(); }

   private:
    mojo::internal::Buffer* serialization_buffer_ = nullptr;
    size_t index_ = 0;

    DISALLOW_COPY_AND_ASSIGN(BufferWriter);
  };

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  uint8_t is_scaling_disabled : 1;
  uint8_t pad0_[3];
  int32_t copies;
  int32_t duplex;
  uint8_t padfinal_[4];

 private:
  OptionsFromDocumentParams_Data();
  ~OptionsFromDocumentParams_Data() = delete;
};
static_assert(sizeof(OptionsFromDocumentParams_Data) == 24,
              "Bad sizeof(OptionsFromDocumentParams_Data)");
// Used by OptionsFromDocumentParams::WrapAsMessage to lazily serialize the struct.
template <typename UserType, typename DataView>
struct OptionsFromDocumentParams_UnserializedMessageContext
    : public mojo::internal::UnserializedMessageContext {
 public:
  static const mojo::internal::UnserializedMessageContext::Tag kMessageTag;

  OptionsFromDocumentParams_UnserializedMessageContext(
    uint32_t message_name,
    uint32_t message_flags,
    UserType input)
      : mojo::internal::UnserializedMessageContext(&kMessageTag, message_name, message_flags)
      , user_data_(std::move(input)) {}
  ~OptionsFromDocumentParams_UnserializedMessageContext() override = default;

  UserType TakeData() {
    return std::move(user_data_);
  }

 private:
  // mojo::internal::UnserializedMessageContext:
  void Serialize(mojo::internal::SerializationContext* context,
                 mojo::internal::Buffer* buffer) override {
    OptionsFromDocumentParams_Data::BufferWriter writer;
    mojo::internal::Serialize<DataView>(user_data_, buffer, &writer, context);
  }

  UserType user_data_;
};

template <typename UserType, typename DataView>
const mojo::internal::UnserializedMessageContext::Tag
    OptionsFromDocumentParams_UnserializedMessageContext<UserType, DataView>::kMessageTag = {};
class  DidPrintContentParams_Data {
 public:
  class BufferWriter {
   public:
    BufferWriter() = default;

    void Allocate(mojo::internal::Buffer* serialization_buffer) {
      serialization_buffer_ = serialization_buffer;
      index_ = serialization_buffer_->Allocate(sizeof(DidPrintContentParams_Data));
      new (data()) DidPrintContentParams_Data();
    }

    bool is_null() const { return !serialization_buffer_; }
    DidPrintContentParams_Data* data() {
      DCHECK(!is_null());
      return serialization_buffer_->Get<DidPrintContentParams_Data>(index_);
    }
    DidPrintContentParams_Data* operator->() { return data(); }

   private:
    mojo::internal::Buffer* serialization_buffer_ = nullptr;
    size_t index_ = 0;

    DISALLOW_COPY_AND_ASSIGN(BufferWriter);
  };

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<::mojo_base::mojom::internal::ReadOnlySharedMemoryRegion_Data> metafile_data_region;
  mojo::internal::Pointer<mojo::internal::Map_Data<uint32_t, mojo::internal::Pointer<::mojo_base::mojom::internal::UnguessableToken_Data>>> subframe_content_info;

 private:
  DidPrintContentParams_Data();
  ~DidPrintContentParams_Data() = delete;
};
static_assert(sizeof(DidPrintContentParams_Data) == 24,
              "Bad sizeof(DidPrintContentParams_Data)");
// Used by DidPrintContentParams::WrapAsMessage to lazily serialize the struct.
template <typename UserType, typename DataView>
struct DidPrintContentParams_UnserializedMessageContext
    : public mojo::internal::UnserializedMessageContext {
 public:
  static const mojo::internal::UnserializedMessageContext::Tag kMessageTag;

  DidPrintContentParams_UnserializedMessageContext(
    uint32_t message_name,
    uint32_t message_flags,
    UserType input)
      : mojo::internal::UnserializedMessageContext(&kMessageTag, message_name, message_flags)
      , user_data_(std::move(input)) {}
  ~DidPrintContentParams_UnserializedMessageContext() override = default;

  UserType TakeData() {
    return std::move(user_data_);
  }

 private:
  // mojo::internal::UnserializedMessageContext:
  void Serialize(mojo::internal::SerializationContext* context,
                 mojo::internal::Buffer* buffer) override {
    DidPrintContentParams_Data::BufferWriter writer;
    mojo::internal::Serialize<DataView>(user_data_, buffer, &writer, context);
  }

  UserType user_data_;
};

template <typename UserType, typename DataView>
const mojo::internal::UnserializedMessageContext::Tag
    DidPrintContentParams_UnserializedMessageContext<UserType, DataView>::kMessageTag = {};
class  DidStartPreviewParams_Data {
 public:
  class BufferWriter {
   public:
    BufferWriter() = default;

    void Allocate(mojo::internal::Buffer* serialization_buffer) {
      serialization_buffer_ = serialization_buffer;
      index_ = serialization_buffer_->Allocate(sizeof(DidStartPreviewParams_Data));
      new (data()) DidStartPreviewParams_Data();
    }

    bool is_null() const { return !serialization_buffer_; }
    DidStartPreviewParams_Data* data() {
      DCHECK(!is_null());
      return serialization_buffer_->Get<DidStartPreviewParams_Data>(index_);
    }
    DidStartPreviewParams_Data* operator->() { return data(); }

   private:
    mojo::internal::Buffer* serialization_buffer_ = nullptr;
    size_t index_ = 0;

    DISALLOW_COPY_AND_ASSIGN(BufferWriter);
  };

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  uint32_t page_count;
  int32_t pages_per_sheet;
  mojo::internal::Pointer<mojo::internal::Array_Data<uint32_t>> pages_to_render;
  mojo::internal::Pointer<::gfx::mojom::internal::Size_Data> page_size;
  int32_t fit_to_page_scaling;
  uint8_t padfinal_[4];

 private:
  DidStartPreviewParams_Data();
  ~DidStartPreviewParams_Data() = delete;
};
static_assert(sizeof(DidStartPreviewParams_Data) == 40,
              "Bad sizeof(DidStartPreviewParams_Data)");
// Used by DidStartPreviewParams::WrapAsMessage to lazily serialize the struct.
template <typename UserType, typename DataView>
struct DidStartPreviewParams_UnserializedMessageContext
    : public mojo::internal::UnserializedMessageContext {
 public:
  static const mojo::internal::UnserializedMessageContext::Tag kMessageTag;

  DidStartPreviewParams_UnserializedMessageContext(
    uint32_t message_name,
    uint32_t message_flags,
    UserType input)
      : mojo::internal::UnserializedMessageContext(&kMessageTag, message_name, message_flags)
      , user_data_(std::move(input)) {}
  ~DidStartPreviewParams_UnserializedMessageContext() override = default;

  UserType TakeData() {
    return std::move(user_data_);
  }

 private:
  // mojo::internal::UnserializedMessageContext:
  void Serialize(mojo::internal::SerializationContext* context,
                 mojo::internal::Buffer* buffer) override {
    DidStartPreviewParams_Data::BufferWriter writer;
    mojo::internal::Serialize<DataView>(user_data_, buffer, &writer, context);
  }

  UserType user_data_;
};

template <typename UserType, typename DataView>
const mojo::internal::UnserializedMessageContext::Tag
    DidStartPreviewParams_UnserializedMessageContext<UserType, DataView>::kMessageTag = {};
class  DidPreviewPageParams_Data {
 public:
  class BufferWriter {
   public:
    BufferWriter() = default;

    void Allocate(mojo::internal::Buffer* serialization_buffer) {
      serialization_buffer_ = serialization_buffer;
      index_ = serialization_buffer_->Allocate(sizeof(DidPreviewPageParams_Data));
      new (data()) DidPreviewPageParams_Data();
    }

    bool is_null() const { return !serialization_buffer_; }
    DidPreviewPageParams_Data* data() {
      DCHECK(!is_null());
      return serialization_buffer_->Get<DidPreviewPageParams_Data>(index_);
    }
    DidPreviewPageParams_Data* operator->() { return data(); }

   private:
    mojo::internal::Buffer* serialization_buffer_ = nullptr;
    size_t index_ = 0;

    DISALLOW_COPY_AND_ASSIGN(BufferWriter);
  };

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<internal::DidPrintContentParams_Data> content;
  uint32_t page_number;
  int32_t document_cookie;

 private:
  DidPreviewPageParams_Data();
  ~DidPreviewPageParams_Data() = delete;
};
static_assert(sizeof(DidPreviewPageParams_Data) == 24,
              "Bad sizeof(DidPreviewPageParams_Data)");
// Used by DidPreviewPageParams::WrapAsMessage to lazily serialize the struct.
template <typename UserType, typename DataView>
struct DidPreviewPageParams_UnserializedMessageContext
    : public mojo::internal::UnserializedMessageContext {
 public:
  static const mojo::internal::UnserializedMessageContext::Tag kMessageTag;

  DidPreviewPageParams_UnserializedMessageContext(
    uint32_t message_name,
    uint32_t message_flags,
    UserType input)
      : mojo::internal::UnserializedMessageContext(&kMessageTag, message_name, message_flags)
      , user_data_(std::move(input)) {}
  ~DidPreviewPageParams_UnserializedMessageContext() override = default;

  UserType TakeData() {
    return std::move(user_data_);
  }

 private:
  // mojo::internal::UnserializedMessageContext:
  void Serialize(mojo::internal::SerializationContext* context,
                 mojo::internal::Buffer* buffer) override {
    DidPreviewPageParams_Data::BufferWriter writer;
    mojo::internal::Serialize<DataView>(user_data_, buffer, &writer, context);
  }

  UserType user_data_;
};

template <typename UserType, typename DataView>
const mojo::internal::UnserializedMessageContext::Tag
    DidPreviewPageParams_UnserializedMessageContext<UserType, DataView>::kMessageTag = {};
class  DidPreviewDocumentParams_Data {
 public:
  class BufferWriter {
   public:
    BufferWriter() = default;

    void Allocate(mojo::internal::Buffer* serialization_buffer) {
      serialization_buffer_ = serialization_buffer;
      index_ = serialization_buffer_->Allocate(sizeof(DidPreviewDocumentParams_Data));
      new (data()) DidPreviewDocumentParams_Data();
    }

    bool is_null() const { return !serialization_buffer_; }
    DidPreviewDocumentParams_Data* data() {
      DCHECK(!is_null());
      return serialization_buffer_->Get<DidPreviewDocumentParams_Data>(index_);
    }
    DidPreviewDocumentParams_Data* operator->() { return data(); }

   private:
    mojo::internal::Buffer* serialization_buffer_ = nullptr;
    size_t index_ = 0;

    DISALLOW_COPY_AND_ASSIGN(BufferWriter);
  };

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<internal::DidPrintContentParams_Data> content;
  int32_t document_cookie;
  uint32_t expected_pages_count;

 private:
  DidPreviewDocumentParams_Data();
  ~DidPreviewDocumentParams_Data() = delete;
};
static_assert(sizeof(DidPreviewDocumentParams_Data) == 24,
              "Bad sizeof(DidPreviewDocumentParams_Data)");
// Used by DidPreviewDocumentParams::WrapAsMessage to lazily serialize the struct.
template <typename UserType, typename DataView>
struct DidPreviewDocumentParams_UnserializedMessageContext
    : public mojo::internal::UnserializedMessageContext {
 public:
  static const mojo::internal::UnserializedMessageContext::Tag kMessageTag;

  DidPreviewDocumentParams_UnserializedMessageContext(
    uint32_t message_name,
    uint32_t message_flags,
    UserType input)
      : mojo::internal::UnserializedMessageContext(&kMessageTag, message_name, message_flags)
      , user_data_(std::move(input)) {}
  ~DidPreviewDocumentParams_UnserializedMessageContext() override = default;

  UserType TakeData() {
    return std::move(user_data_);
  }

 private:
  // mojo::internal::UnserializedMessageContext:
  void Serialize(mojo::internal::SerializationContext* context,
                 mojo::internal::Buffer* buffer) override {
    DidPreviewDocumentParams_Data::BufferWriter writer;
    mojo::internal::Serialize<DataView>(user_data_, buffer, &writer, context);
  }

  UserType user_data_;
};

template <typename UserType, typename DataView>
const mojo::internal::UnserializedMessageContext::Tag
    DidPreviewDocumentParams_UnserializedMessageContext<UserType, DataView>::kMessageTag = {};
class  PrintParams_Data {
 public:
  class BufferWriter {
   public:
    BufferWriter() = default;

    void Allocate(mojo::internal::Buffer* serialization_buffer) {
      serialization_buffer_ = serialization_buffer;
      index_ = serialization_buffer_->Allocate(sizeof(PrintParams_Data));
      new (data()) PrintParams_Data();
    }

    bool is_null() const { return !serialization_buffer_; }
    PrintParams_Data* data() {
      DCHECK(!is_null());
      return serialization_buffer_->Get<PrintParams_Data>(index_);
    }
    PrintParams_Data* operator->() { return data(); }

   private:
    mojo::internal::Buffer* serialization_buffer_ = nullptr;
    size_t index_ = 0;

    DISALLOW_COPY_AND_ASSIGN(BufferWriter);
  };

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<::gfx::mojom::internal::Size_Data> page_size;
  mojo::internal::Pointer<::gfx::mojom::internal::Size_Data> content_size;
  mojo::internal::Pointer<::gfx::mojom::internal::Rect_Data> printable_area;
  int32_t margin_top;
  int32_t margin_left;
  int32_t page_orientation;
  int32_t document_cookie;
  mojo::internal::Pointer<::gfx::mojom::internal::Size_Data> dpi;
  double scale_factor;
  uint8_t selection_only : 1;
  uint8_t supports_alpha_blend : 1;
  uint8_t is_first_request : 1;
  uint8_t print_to_pdf : 1;
  uint8_t display_header_footer : 1;
  uint8_t rasterize_pdf : 1;
  uint8_t should_print_backgrounds : 1;
  uint8_t prefer_css_page_size : 1;
  uint8_t pad16_[3];
  int32_t preview_ui_id;
  int32_t preview_request_id;
  int32_t print_scaling_option;
  mojo::internal::Pointer<::mojo_base::mojom::internal::String16_Data> title;
  mojo::internal::Pointer<::mojo_base::mojom::internal::String16_Data> url;
  mojo::internal::Pointer<::mojo_base::mojom::internal::String16_Data> header_template;
  mojo::internal::Pointer<::mojo_base::mojom::internal::String16_Data> footer_template;
  int32_t printed_doc_type;
  uint32_t pages_per_sheet;

 private:
  PrintParams_Data();
  ~PrintParams_Data() = delete;
};
static_assert(sizeof(PrintParams_Data) == 120,
              "Bad sizeof(PrintParams_Data)");
// Used by PrintParams::WrapAsMessage to lazily serialize the struct.
template <typename UserType, typename DataView>
struct PrintParams_UnserializedMessageContext
    : public mojo::internal::UnserializedMessageContext {
 public:
  static const mojo::internal::UnserializedMessageContext::Tag kMessageTag;

  PrintParams_UnserializedMessageContext(
    uint32_t message_name,
    uint32_t message_flags,
    UserType input)
      : mojo::internal::UnserializedMessageContext(&kMessageTag, message_name, message_flags)
      , user_data_(std::move(input)) {}
  ~PrintParams_UnserializedMessageContext() override = default;

  UserType TakeData() {
    return std::move(user_data_);
  }

 private:
  // mojo::internal::UnserializedMessageContext:
  void Serialize(mojo::internal::SerializationContext* context,
                 mojo::internal::Buffer* buffer) override {
    PrintParams_Data::BufferWriter writer;
    mojo::internal::Serialize<DataView>(user_data_, buffer, &writer, context);
  }

  UserType user_data_;
};

template <typename UserType, typename DataView>
const mojo::internal::UnserializedMessageContext::Tag
    PrintParams_UnserializedMessageContext<UserType, DataView>::kMessageTag = {};
class  PrintPagesParams_Data {
 public:
  class BufferWriter {
   public:
    BufferWriter() = default;

    void Allocate(mojo::internal::Buffer* serialization_buffer) {
      serialization_buffer_ = serialization_buffer;
      index_ = serialization_buffer_->Allocate(sizeof(PrintPagesParams_Data));
      new (data()) PrintPagesParams_Data();
    }

    bool is_null() const { return !serialization_buffer_; }
    PrintPagesParams_Data* data() {
      DCHECK(!is_null());
      return serialization_buffer_->Get<PrintPagesParams_Data>(index_);
    }
    PrintPagesParams_Data* operator->() { return data(); }

   private:
    mojo::internal::Buffer* serialization_buffer_ = nullptr;
    size_t index_ = 0;

    DISALLOW_COPY_AND_ASSIGN(BufferWriter);
  };

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<internal::PrintParams_Data> params;
  mojo::internal::Pointer<mojo::internal::Array_Data<uint32_t>> pages;

 private:
  PrintPagesParams_Data();
  ~PrintPagesParams_Data() = delete;
};
static_assert(sizeof(PrintPagesParams_Data) == 24,
              "Bad sizeof(PrintPagesParams_Data)");
// Used by PrintPagesParams::WrapAsMessage to lazily serialize the struct.
template <typename UserType, typename DataView>
struct PrintPagesParams_UnserializedMessageContext
    : public mojo::internal::UnserializedMessageContext {
 public:
  static const mojo::internal::UnserializedMessageContext::Tag kMessageTag;

  PrintPagesParams_UnserializedMessageContext(
    uint32_t message_name,
    uint32_t message_flags,
    UserType input)
      : mojo::internal::UnserializedMessageContext(&kMessageTag, message_name, message_flags)
      , user_data_(std::move(input)) {}
  ~PrintPagesParams_UnserializedMessageContext() override = default;

  UserType TakeData() {
    return std::move(user_data_);
  }

 private:
  // mojo::internal::UnserializedMessageContext:
  void Serialize(mojo::internal::SerializationContext* context,
                 mojo::internal::Buffer* buffer) override {
    PrintPagesParams_Data::BufferWriter writer;
    mojo::internal::Serialize<DataView>(user_data_, buffer, &writer, context);
  }

  UserType user_data_;
};

template <typename UserType, typename DataView>
const mojo::internal::UnserializedMessageContext::Tag
    PrintPagesParams_UnserializedMessageContext<UserType, DataView>::kMessageTag = {};
class  DidPrintDocumentParams_Data {
 public:
  class BufferWriter {
   public:
    BufferWriter() = default;

    void Allocate(mojo::internal::Buffer* serialization_buffer) {
      serialization_buffer_ = serialization_buffer;
      index_ = serialization_buffer_->Allocate(sizeof(DidPrintDocumentParams_Data));
      new (data()) DidPrintDocumentParams_Data();
    }

    bool is_null() const { return !serialization_buffer_; }
    DidPrintDocumentParams_Data* data() {
      DCHECK(!is_null());
      return serialization_buffer_->Get<DidPrintDocumentParams_Data>(index_);
    }
    DidPrintDocumentParams_Data* operator->() { return data(); }

   private:
    mojo::internal::Buffer* serialization_buffer_ = nullptr;
    size_t index_ = 0;

    DISALLOW_COPY_AND_ASSIGN(BufferWriter);
  };

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<internal::DidPrintContentParams_Data> content;
  int32_t document_cookie;
  uint8_t pad1_[4];
  mojo::internal::Pointer<::gfx::mojom::internal::Size_Data> page_size;
  mojo::internal::Pointer<::gfx::mojom::internal::Rect_Data> content_area;
  mojo::internal::Pointer<::gfx::mojom::internal::Point_Data> physical_offsets;

 private:
  DidPrintDocumentParams_Data();
  ~DidPrintDocumentParams_Data() = delete;
};
static_assert(sizeof(DidPrintDocumentParams_Data) == 48,
              "Bad sizeof(DidPrintDocumentParams_Data)");
// Used by DidPrintDocumentParams::WrapAsMessage to lazily serialize the struct.
template <typename UserType, typename DataView>
struct DidPrintDocumentParams_UnserializedMessageContext
    : public mojo::internal::UnserializedMessageContext {
 public:
  static const mojo::internal::UnserializedMessageContext::Tag kMessageTag;

  DidPrintDocumentParams_UnserializedMessageContext(
    uint32_t message_name,
    uint32_t message_flags,
    UserType input)
      : mojo::internal::UnserializedMessageContext(&kMessageTag, message_name, message_flags)
      , user_data_(std::move(input)) {}
  ~DidPrintDocumentParams_UnserializedMessageContext() override = default;

  UserType TakeData() {
    return std::move(user_data_);
  }

 private:
  // mojo::internal::UnserializedMessageContext:
  void Serialize(mojo::internal::SerializationContext* context,
                 mojo::internal::Buffer* buffer) override {
    DidPrintDocumentParams_Data::BufferWriter writer;
    mojo::internal::Serialize<DataView>(user_data_, buffer, &writer, context);
  }

  UserType user_data_;
};

template <typename UserType, typename DataView>
const mojo::internal::UnserializedMessageContext::Tag
    DidPrintDocumentParams_UnserializedMessageContext<UserType, DataView>::kMessageTag = {};
class  ScriptedPrintParams_Data {
 public:
  class BufferWriter {
   public:
    BufferWriter() = default;

    void Allocate(mojo::internal::Buffer* serialization_buffer) {
      serialization_buffer_ = serialization_buffer;
      index_ = serialization_buffer_->Allocate(sizeof(ScriptedPrintParams_Data));
      new (data()) ScriptedPrintParams_Data();
    }

    bool is_null() const { return !serialization_buffer_; }
    ScriptedPrintParams_Data* data() {
      DCHECK(!is_null());
      return serialization_buffer_->Get<ScriptedPrintParams_Data>(index_);
    }
    ScriptedPrintParams_Data* operator->() { return data(); }

   private:
    mojo::internal::Buffer* serialization_buffer_ = nullptr;
    size_t index_ = 0;

    DISALLOW_COPY_AND_ASSIGN(BufferWriter);
  };

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  int32_t cookie;
  uint32_t expected_pages_count;
  uint8_t has_selection : 1;
  uint8_t is_scripted : 1;
  uint8_t is_modifiable : 1;
  uint8_t pad4_[3];
  int32_t margin_type;

 private:
  ScriptedPrintParams_Data();
  ~ScriptedPrintParams_Data() = delete;
};
static_assert(sizeof(ScriptedPrintParams_Data) == 24,
              "Bad sizeof(ScriptedPrintParams_Data)");
// Used by ScriptedPrintParams::WrapAsMessage to lazily serialize the struct.
template <typename UserType, typename DataView>
struct ScriptedPrintParams_UnserializedMessageContext
    : public mojo::internal::UnserializedMessageContext {
 public:
  static const mojo::internal::UnserializedMessageContext::Tag kMessageTag;

  ScriptedPrintParams_UnserializedMessageContext(
    uint32_t message_name,
    uint32_t message_flags,
    UserType input)
      : mojo::internal::UnserializedMessageContext(&kMessageTag, message_name, message_flags)
      , user_data_(std::move(input)) {}
  ~ScriptedPrintParams_UnserializedMessageContext() override = default;

  UserType TakeData() {
    return std::move(user_data_);
  }

 private:
  // mojo::internal::UnserializedMessageContext:
  void Serialize(mojo::internal::SerializationContext* context,
                 mojo::internal::Buffer* buffer) override {
    ScriptedPrintParams_Data::BufferWriter writer;
    mojo::internal::Serialize<DataView>(user_data_, buffer, &writer, context);
  }

  UserType user_data_;
};

template <typename UserType, typename DataView>
const mojo::internal::UnserializedMessageContext::Tag
    ScriptedPrintParams_UnserializedMessageContext<UserType, DataView>::kMessageTag = {};

#pragma pack(pop)

}  // namespace internal
}  // namespace mojom
}  // namespace printing

#endif  // COMPONENTS_PRINTING_COMMON_PRINT_MOJOM_SHARED_INTERNAL_H_